/*
 * Decompiled with CFR 0.152.
 */
package com.infor.core.pool;

import com.infor.core.pool.IRecyclable;
import com.infor.core.pool.IRecycleBin;
import com.infor.core.pool.LIFO;
import com.infor.core.pool.RecycleBinIsEmptyException;

public class WaitPool
implements IRecycleBin {
    private IRecycleBin pool = null;
    private volatile boolean isDestroyed = false;
    private long waitTime = -1L;

    public WaitPool() {
        this(new LIFO(), -1L);
    }

    public WaitPool(IRecycleBin pool) {
        this(pool, -1L);
    }

    public WaitPool(IRecycleBin pool, long waitTime) {
        if (pool == null) {
            throw new NullPointerException("WaitPool: Container pool was null.");
        }
        this.pool = pool;
        this.waitTime = waitTime;
    }

    public synchronized void destroy() {
        if (!this.pool.isDestroyed()) {
            this.pool.destroy();
        }
    }

    public boolean isDestroyed() {
        return this.pool.isDestroyed();
    }

    public synchronized IRecyclable getRecyclable() {
        boolean waited = false;
        IRecyclable obj = null;
        while (true) {
            if (this.isDestroyed) {
                return null;
            }
            try {
                obj = this.pool.getRecyclable();
            }
            catch (RecycleBinIsEmptyException empty) {
                try {
                    if (this.waitTime == 0L) {
                        return null;
                    }
                    if (this.waitTime > 0L) {
                        if (waited) {
                            return null;
                        }
                        this.wait(this.waitTime);
                        waited = true;
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException iex) {}
                continue;
            }
            break;
        }
        return obj;
    }

    public int getSize() {
        return this.pool.getSize();
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public synchronized void recycle(IRecyclable obj) {
        this.pool.recycle(obj);
        this.notify();
    }

    public void setWaitTime(long newWaitTime) {
        this.waitTime = newWaitTime;
    }
}

