/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obr.plugin;

import java.io.File;
import java.util.List;
import org.apache.felix.obr.plugin.Config;
import org.apache.felix.obr.plugin.ObrUpdate;
import org.apache.felix.obr.plugin.PathFile;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;

public class ObrInstall
extends AbstractMojo {
    private ArtifactRepository m_localRepo;
    private String m_repositoryPath;
    private MavenProject m_project;
    private Settings m_settings;
    private boolean installToLocalOBR;
    private String m_fileInLocalRepo;

    public void execute() throws MojoExecutionException {
        PathFile repoExist;
        PathFile file;
        this.getLog().info((CharSequence)"Obr Plugin starts:");
        if (!this.installToLocalOBR) {
            this.getLog().info((CharSequence)"maven-obr-plugin:repository goal is disable due to one of the following reason:");
            this.getLog().info((CharSequence)" - 'installToLocalOBR' configuration set to false");
            this.getLog().info((CharSequence)" - JVM property maven.obr.installToLocalOBR set to false");
            return;
        }
        if (this.m_repositoryPath == null) {
            this.m_repositoryPath = "file:/" + this.m_localRepo.getBasedir() + File.separator + "repository.xml";
            this.getLog().warn((CharSequence)("-DpathRepo is not define, use default repository: " + this.m_repositoryPath));
        }
        if ((file = new PathFile(this.m_repositoryPath)).isExists() && !this.m_repositoryPath.startsWith("file:/")) {
            this.m_repositoryPath = "file:/" + this.m_repositoryPath;
        }
        String obrXmlFile = null;
        List l = this.m_project.getResources();
        for (int i = 0; i < l.size(); ++i) {
            File f = new File(((Resource)l.get(i)).getDirectory() + File.separator + "obr.xml");
            if (!f.exists()) continue;
            obrXmlFile = ((Resource)l.get(i)).getDirectory() + File.separator + "obr.xml";
            break;
        }
        if (obrXmlFile == null) {
            this.getLog().warn((CharSequence)"obr.xml is not present, use default");
        }
        if (!(file = new PathFile(PathFile.uniformSeparator(this.m_settings.getLocalRepository()) + File.separator + PathFile.uniformSeparator(this.m_localRepo.pathOf(this.m_project.getArtifact())))).isExists()) {
            this.getLog().error((CharSequence)("file not found in local repository: " + this.m_settings.getLocalRepository() + File.separator + this.m_localRepo.pathOf(this.m_project.getArtifact())));
            this.getLog().error((CharSequence)("file not found in local repository: " + this.m_localRepo.getBasedir() + File.separator + this.m_localRepo.pathOf(this.m_project.getArtifact())));
            return;
        }
        this.m_fileInLocalRepo = file.getOnlyAbsoluteFilename();
        PathFile fileRepo = new PathFile(this.m_repositoryPath);
        if (fileRepo.isRelative()) {
            fileRepo.setBaseDir(this.m_settings.getLocalRepository());
        }
        if (!(repoExist = new PathFile(fileRepo.getAbsolutePath())).isExists()) {
            fileRepo.createPath();
        }
        Config user = new Config();
        this.getLog().debug((CharSequence)("Maven2 Local File repository = " + fileRepo.getAbsoluteFilename()));
        this.getLog().debug((CharSequence)("OBR repository = " + obrXmlFile));
        ObrUpdate obrUpdate = new ObrUpdate(fileRepo, obrXmlFile, this.m_project, this.m_fileInLocalRepo, PathFile.uniformSeparator(this.m_settings.getLocalRepository()), user, this.getLog());
        try {
            obrUpdate.updateRepository();
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
            throw new MojoExecutionException("MojoFailureException");
        }
    }
}

