/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.cdi.Utils;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;

public class CdiPropertyInjector
implements PropertyInjector {
    private PropertyInjector delegate;
    private Class<?> clazz;
    private boolean injectorEnabled = true;

    public CdiPropertyInjector(PropertyInjector delegate, Class<?> clazz, Map<Class<?>, Type> sessionBeanInterface, BeanManager manager) {
        this.delegate = delegate;
        this.clazz = clazz;
        if (sessionBeanInterface.containsKey(clazz)) {
            this.injectorEnabled = false;
        }
        if (!manager.getBeans(clazz, new Annotation[0]).isEmpty() && Utils.isJaxrsComponent(clazz)) {
            this.injectorEnabled = false;
        }
    }

    public CompletionStage<Void> inject(Object target, boolean unwrapAsync) {
        if (this.injectorEnabled) {
            return this.delegate.inject(target, unwrapAsync);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> inject(HttpRequest request, HttpResponse response, Object target, boolean unwrapAsync) throws Failure, WebApplicationException, ApplicationException {
        if (this.injectorEnabled) {
            return this.delegate.inject(request, response, target, unwrapAsync);
        }
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return "CdiPropertyInjector (enabled: " + this.injectorEnabled + ") for " + this.clazz;
    }
}

