/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.ContentDirectoryContent;
import org.apache.felix.framework.util.JarFileX;
import org.apache.felix.moduleloader.IContent;

public class JarContent
implements IContent {
    private static final int BUFSIZE = 4096;
    private static final transient String LEGACY_EMBEDDED_DIRECTORY = "embedded";
    private static final transient String EMBEDDED_DIRECTORY = "-embedded";
    private static final transient String LIBRARY_DIRECTORY = "lib";
    private final Logger m_logger;
    private final Object m_revisionLock;
    private final File m_rootDir;
    private final File m_file;
    private JarFileX m_jarFile = null;
    private final boolean m_legacy;
    private boolean m_opened = false;

    public JarContent(Logger logger, Object revisionLock, File rootDir, File file) {
        this.m_logger = logger;
        this.m_revisionLock = revisionLock;
        this.m_rootDir = rootDir;
        this.m_file = file;
        this.m_legacy = false;
    }

    public JarContent(Logger logger, Object revisionLock, File rootDir, File file, boolean legacy) {
        this.m_logger = logger;
        this.m_revisionLock = revisionLock;
        this.m_rootDir = rootDir;
        this.m_file = file;
        this.m_legacy = legacy;
    }

    protected void finalize() {
        if (this.m_jarFile != null) {
            try {
                this.m_jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void open() {
        this.m_opened = true;
    }

    public synchronized void close() {
        try {
            if (this.m_jarFile != null) {
                this.m_jarFile.close();
            }
        }
        catch (Exception ex) {
            this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
        }
        this.m_jarFile = null;
        this.m_opened = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return false;
            }
        }
        try {
            ZipEntry ze = this.m_jarFile.getEntry(name);
            boolean bl = ze != null;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
    }

    public synchronized Enumeration getEntries() {
        EntriesEnumeration e;
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return null;
            }
        }
        return (e = new EntriesEnumeration(this.m_jarFile.entries())).hasMoreElements() ? e : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] getEntryAsBytes(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return null;
            }
        }
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        try {
            ZipEntry ze = this.m_jarFile.getEntry(name);
            if (ze == null) {
                byte[] byArray = null;
                return byArray;
            }
            is = this.m_jarFile.getInputStream(ze);
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            baos = new ByteArrayOutputStream(4096);
            byte[] buf = new byte[4096];
            int n = 0;
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                baos.write(buf, 0, n);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            this.m_logger.log(1, "JarContent: Unable to read bytes.", ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public synchronized InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return null;
            }
        }
        InputStream is = null;
        try {
            ZipEntry ze = this.m_jarFile.getEntry(name);
            if (ze == null) {
                return null;
            }
            is = this.m_jarFile.getInputStream(ze);
            if (is == null) {
                return null;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IContent getEntryAsContent(String entryName) {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return null;
            }
        }
        entryName = entryName.startsWith("/") ? entryName.substring(1) : entryName;
        File embedDir = this.m_legacy ? new File(this.m_rootDir, LEGACY_EMBEDDED_DIRECTORY) : new File(this.m_rootDir, this.m_file.getName() + EMBEDDED_DIRECTORY);
        ZipEntry ze = this.m_jarFile.getEntry(entryName);
        if (ze != null && ze.isDirectory()) {
            File extractedDir = new File(embedDir, entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(extractedDir) && !BundleCache.getSecureAction().mkdirs(extractedDir)) {
                    this.m_logger.log(1, "Unable to extract embedded directory.");
                }
            }
            return new ContentDirectoryContent(this, entryName);
        }
        if (ze != null && ze.getName().endsWith(".jar")) {
            File extractedJar = new File(embedDir, entryName);
            Object object = this.m_revisionLock;
            synchronized (object) {
                if (!BundleCache.getSecureAction().fileExists(extractedJar)) {
                    try {
                        this.extractEmbeddedJar(entryName);
                    }
                    catch (Exception ex) {
                        this.m_logger.log(1, "Unable to extract embedded JAR file.", ex);
                    }
                }
            }
            return new JarContent(this.m_logger, this.m_revisionLock, extractedJar.getParentFile(), extractedJar);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getEntryAsNativeLibrary(String name) {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        if (this.m_jarFile == null) {
            try {
                this.openJarFile();
            }
            catch (IOException ex) {
                this.m_logger.log(1, "JarContent: Unable to open JAR file.", ex);
                return null;
            }
        }
        File libDir = new File(this.m_rootDir, LIBRARY_DIRECTORY);
        File libFile = new File(libDir, File.separatorChar + name);
        libDir = libFile.getParentFile();
        if (!BundleCache.getSecureAction().fileExists(libDir) && !BundleCache.getSecureAction().mkdirs(libDir)) {
            this.m_logger.log(1, "JarContent: Unable to create library directory.");
            return null;
        }
        if (!BundleCache.getSecureAction().fileExists(libFile)) {
            InputStream is = null;
            try {
                ZipEntry ze = this.m_jarFile.getEntry(name);
                if (ze == null) {
                    String string = null;
                    return string;
                }
                is = new BufferedInputStream(this.m_jarFile.getInputStream(ze), BundleCache.BUFSIZE);
                if (is == null) {
                    throw new IOException("No input stream: " + name);
                }
                BundleCache.copyStreamToFile(is, libFile);
            }
            catch (Exception ex) {
                this.m_logger.log(1, "JarContent: Extracting native library.", ex);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        return BundleCache.getSecureAction().getAbsolutePath(libFile);
    }

    public String toString() {
        return "JAR " + this.m_file.getPath();
    }

    public File getFile() {
        return this.m_file;
    }

    private void openJarFile() throws IOException {
        if (this.m_jarFile == null) {
            this.m_jarFile = BundleCache.getSecureAction().openJAR(this.m_file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEmbeddedJar(String jarPath) throws Exception {
        jarPath = jarPath.length() > 0 && jarPath.charAt(0) == '/' ? jarPath.substring(1) : jarPath;
        File embedDir = this.m_legacy ? new File(this.m_rootDir, LEGACY_EMBEDDED_DIRECTORY) : new File(this.m_rootDir, this.m_file.getName() + EMBEDDED_DIRECTORY);
        File jarFile = new File(embedDir, jarPath);
        if (!BundleCache.getSecureAction().fileExists(jarFile)) {
            InputStream is = null;
            try {
                ZipEntry ze = this.m_jarFile.getEntry(jarPath);
                if (ze == null) {
                    return;
                }
                if (!ze.isDirectory()) {
                    File jarDir = jarFile.getParentFile();
                    if (!BundleCache.getSecureAction().fileExists(jarDir) && !BundleCache.getSecureAction().mkdirs(jarDir)) {
                        throw new IOException("Unable to create embedded JAR directory.");
                    }
                    is = new BufferedInputStream(this.m_jarFile.getInputStream(ze), BundleCache.BUFSIZE);
                    if (is == null) {
                        throw new IOException("No input stream: " + jarPath);
                    }
                    BundleCache.copyStreamToFile(is, jarFile);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private Enumeration m_enumeration = null;

        public EntriesEnumeration(Enumeration enumeration) {
            this.m_enumeration = enumeration;
        }

        public boolean hasMoreElements() {
            return this.m_enumeration.hasMoreElements();
        }

        public Object nextElement() {
            return ((ZipEntry)this.m_enumeration.nextElement()).getName();
        }
    }
}

