/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.util.Vector;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TroopSpace;
import megamek.common.VTOL;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKTankFile
extends BLKFile
implements IMechLoader {
    protected static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "", "Naval", "Hydrofoil", "Submarine", "", "", "", "", "", "WiGE"};

    public BLKTankFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        Tank tank = new Tank();
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        tank.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            tank.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            tank.setModel("");
        }
        this.setTechLevel(tank);
        if (this.dataFile.exists("source")) {
            tank.setSource(this.dataFile.getDataAsString("source")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        tank.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n2 = -1;
        for (n = 0; n < MOVES.length; ++n) {
            if (!string.equalsIgnoreCase(MOVES[n])) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        tank.setMovementMode(n2);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray;
            for (String object2 : stringArray = this.dataFile.getDataAsString("transporters")) {
                if (!object2.startsWith("TroopSpace:", 0)) continue;
                Double i = new Double(object2.substring(11));
                int n3 = i.intValue();
                tank.addTransporter(new TroopSpace(n3));
            }
        }
        n = 0;
        if (this.dataFile.exists("engine_type")) {
            n = this.dataFile.getDataAsInt("engine_type")[0];
        }
        int n4 = 2;
        if (tank.isClan()) {
            n4 |= 1;
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        int n5 = this.dataFile.getDataAsInt("cruiseMP")[0] * (int)tank.getWeight() - tank.getSuspensionFactor();
        tank.setEngine(new Engine(n5, BLKFile.translateEngineCode(n), n4));
        if (this.dataFile.exists("armor_type")) {
            tank.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            tank.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            tank.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length < 4 || nArray.length > 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        tank.setHasNoTurret(nArray.length == 4);
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            tank.initializeArmor(nArray2[i], i);
        }
        tank.autoSetInternal();
        this.loadEquipment(tank, "Front", 1);
        this.loadEquipment(tank, "Right", 2);
        this.loadEquipment(tank, "Left", 3);
        this.loadEquipment(tank, "Rear", 4);
        if (!tank.hasNoTurret()) {
            this.loadEquipment(tank, "Turret", 5);
        }
        this.loadEquipment(tank, "Body", 0);
        if (this.dataFile.exists("omni")) {
            tank.setOmni(true);
        }
        return tank;
    }

    public static void encode(String string, Tank tank) {
        String string2;
        BuildingBlock buildingBlock = new BuildingBlock();
        buildingBlock.createNewBlock();
        if (tank instanceof VTOL) {
            buildingBlock.writeBlockData("UnitType", "VTOL");
        } else {
            buildingBlock.writeBlockData("UnitType", "Tank");
        }
        buildingBlock.writeBlockData("blockversion", 1);
        buildingBlock.writeBlockData("Name", tank.getChassis());
        buildingBlock.writeBlockData("Model", tank.getModel());
        buildingBlock.writeBlockData("year", tank.getYear());
        if (tank.isMixedTech()) {
            string2 = !tank.isClan() ? "Mixed (IS Chassis)" : "Mixed (Clan Chassis)";
        } else {
            switch (tank.getTechLevel()) {
                case 0: {
                    string2 = "IS Level 1";
                    break;
                }
                case 1: {
                    string2 = "IS Level 2";
                    break;
                }
                default: {
                    string2 = "IS Level 3";
                    break;
                }
                case 2: {
                    string2 = "Clan Level 2";
                    break;
                }
                case 6: {
                    string2 = "Clan Level 3";
                }
            }
        }
        buildingBlock.writeBlockData("type", string2);
        buildingBlock.writeBlockData("tonnage", tank.getWeight());
        buildingBlock.writeBlockData("motion_type", tank.getMovementModeAsString());
        if (tank.getTroopCarryingSpace() > 0) {
            buildingBlock.writeBlockData("transporters", "TroopSpace: " + tank.getTroopCarryingSpace());
        }
        int n = 0;
        switch (tank.getEngine().getEngineType()) {
            case 0: {
                n = 1;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            case 7: {
                n = 7;
            }
        }
        buildingBlock.writeBlockData("engine_type", n);
        buildingBlock.writeBlockData("cruiseMP", tank.getOriginalWalkMP());
        if (tank.getArmorType() != 0) {
            buildingBlock.writeBlockData("armor_type", tank.getArmorType());
            buildingBlock.writeBlockData("armor_tech", tank.getArmorTechLevel());
        }
        if (tank.getStructureType() != 0) {
            buildingBlock.writeBlockData("internal_type", tank.getStructureType());
        }
        if (tank.isOmni()) {
            buildingBlock.writeBlockData("omni", 1);
        }
        int[] nArray = new int[tank.locations() - 1];
        for (int i = 1; i < tank.locations(); ++i) {
            nArray[i - 1] = tank.getOArmor(i);
        }
        buildingBlock.writeBlockData("armor", nArray);
        Vector vector = new Vector(tank.locations());
        for (int i = 0; i < tank.locations(); ++i) {
            vector.add(new Vector());
        }
        for (Mounted mounted : tank.getEquipment()) {
            String string3 = mounted.getType().getInternalName();
            int n2 = mounted.getLocation();
            if (n2 == -1) continue;
            ((Vector)vector.get(n2)).add(string3);
        }
        for (int i = 0; i < tank.locations(); ++i) {
            buildingBlock.writeBlockData(tank.getLocationName(i) + " Equipment", (Vector)vector.get(i));
        }
        buildingBlock.writeBlockFile(string);
    }
}

