#!/usr/bin/env python3
# Copyright (c) Meta Platforms, Inc. and affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# pyre-unsafe

from typing import Any, Callable, Dict, Optional, Tuple

UEXW_MAX_LENGTH: int = ...

class TType:
    STOP: int = ...
    VOID: int = ...
    BOOL: int = ...
    BYTE: int = ...
    I08: int = ...
    DOUBLE: int = ...
    I16: int = ...
    I32: int = ...
    I64: int = ...
    STRING: int = ...
    UTF7: int = ...
    STRUCT: int = ...
    MAP: int = ...
    SET: int = ...
    LIST: int = ...
    UTF8: int = ...
    UTF16: int = ...
    FLOAT: int = ...

class TMessageType:
    CALL: int = ...
    REPLY: int = ...
    EXCEPTION: int = ...
    ONEWAY: int = ...

class TPriority:
    HIGH_IMPORTANT: int = ...
    HIGH: int = ...
    IMPORTANT: int = ...
    NORMAL: int = ...
    BEST_EFFORT: int = ...
    N_PRIORITIES: int = ...

class TRequestContext:
    def __init__(self) -> None:
        self._headers: Optional[Any] = None

    def getHeaders(self) -> Any: ...
    def setHeaders(self, headers: Any) -> None: ...

class TProcessorEventHandler:
    def getHandlerContext(self, fn_name: str, server_context: Any) -> None: ...
    def preRead(self, handler_context: Any, fn_name: str, args: Any) -> None: ...
    def postRead(self, handler_context: Any, fn_name: str, args: Any) -> None: ...
    def preWrite(self, handler_context: Any, fn_name: str, result: Any) -> None: ...
    def postWrite(self, handler_context: Any, fn_name: str, result: Any) -> None: ...
    def handlerException(
        self, handler_context: Any, fn_name: str, exception: Any
    ) -> None: ...
    def handlerError(
        self, handler_context: Any, fn_name: str, exception: Exception
    ) -> None: ...

class TServerInterface:
    def __init__(self) -> None: ...
    def setRequestContext(self, request_context: TRequestContext) -> None: ...
    def getRequestContext(self) -> TRequestContext: ...

class TProcessor:
    def __init__(self) -> None:
        self._event_handler: TProcessorEventHandler = ...
        self._handler: Optional[Any] = ...
        self._processMap: Dict = ...
        self._priorityMap: Dict[str, int] = ...

    def setEventHandler(self, event_handler: TProcessorEventHandler) -> None: ...
    def getEventHandler(self) -> TProcessorEventHandler: ...
    def process(
        self, iprot: Any, oprot: Any, server_context: Optional[Any]
    ) -> None: ...
    def onewayMethods(self) -> Tuple[Any]: ...
    def readMessageBegin(self, iprot: Any) -> Tuple[str, int]: ...
    def skipMessageStruct(self, iprot: Any) -> None: ...
    def doesKnowFunction(self, name: str) -> bool: ...
    def callFunction(
        self, name: str, seqid: int, iprot: Any, oprot: Any, server_ctx: Any
    ) -> Callable: ...
    def readArgs(
        self, iprot: Any, handler_ctx: Any, fn_name: str, argtype: Any
    ) -> Any: ...
    def writeException(
        self, oprot: Any, name: str, seqid: int, exc: Exception
    ) -> None: ...
    def get_priority(self, fname: str) -> int: ...
    def _getReplyType(self, result: Any) -> int: ...
    @staticmethod
    def _get_exception_from_thrift_result(result: Any) -> Optional[Exception]: ...
    def writeReply(
        self,
        oprot: Any,
        handler_ctx: Any,
        fn_name: str,
        seqid: int,
        result: Any,
        server_ctx: Optional[Any],
    ) -> None: ...

class TException(Exception):
    def __init__(self, message: Optional[str] = None) -> None: ...
    # The sad `Any` below is because 10% of Thrift exceptions define their
    # message field as `optional` whereas 90% leave it as unqualified.
    @property
    def message(self) -> Any: ...
    @message.setter
    def message(self, value: Optional[str]) -> None: ...

class TApplicationException(TException):
    UNKNOWN: int = ...
    UNKNOWN_METHOD: int = ...
    INVALID_MESSAGE_TYPE: int = ...
    WRONG_METHOD_NAME: int = ...
    BAD_SEQUENCE_ID: int = ...
    MISSING_RESULT: int = ...
    INTERNAL_ERROR: int = ...
    PROTOCOL_ERROR: int = ...
    INVALID_TRANSFORM: int = ...
    INVALID_PROTOCOL: int = ...
    UNSUPPORTED_CLIENT_TYPE: int = ...
    LOADSHEDDING: int = ...
    TIMEOUT: int = ...
    INJECTED_FAILURE: int = ...

    EXTYPE_TO_STRING: Dict[int, str] = ...

    type: int = ...
    def __init__(self, type: int = UNKNOWN, message: Optional[str] = None) -> None: ...
    def __str__(self) -> str: ...
    def read(self, iprot: Any) -> None: ...
    def write(self, oprot: Any) -> None: ...

class UnimplementedTypedef:
    pass
