use std::sync::Arc;

use serde::{Deserialize, Serialize};
use strum::{EnumIter, EnumString, IntoStaticStr};

#[derive(
    Debug, PartialEq, Eq, Copy, Clone, EnumIter, EnumString, IntoStaticStr, Serialize, Deserialize,
)]
#[strum(serialize_all = "snake_case")]
pub enum IconName {
    Ai,
    AiAnthropic,
    AiBedrock,
    AiClaude,
    AiDeepSeek,
    AiEdit,
    AiGemini,
    AiGoogle,
    AiLmStudio,
    AiMistral,
    AiOllama,
    AiOpenAi,
    AiOpenAiCompat,
    AiOpenRouter,
    AiVZero,
    AiXAi,
    AiZed,
    ArrowCircle,
    ArrowDown,
    ArrowDown10,
    ArrowDownRight,
    ArrowLeft,
    ArrowRight,
    ArrowRightLeft,
    ArrowUp,
    ArrowUpRight,
    Attach,
    AtSign,
    AudioOff,
    AudioOn,
    Backspace,
    Bell,
    BellDot,
    BellOff,
    BellRing,
    Binary,
    Blocks,
    BoltOutlined,
    BoltFilled,
    Book,
    BookCopy,
    CaseSensitive,
    Chat,
    Check,
    CheckDouble,
    ChevronDown,
    ChevronDownUp,
    ChevronLeft,
    ChevronRight,
    ChevronUp,
    ChevronUpDown,
    Circle,
    CircleHelp,
    Close,
    CloudDownload,
    Code,
    Cog,
    Command,
    Control,
    Copilot,
    CopilotDisabled,
    CopilotError,
    CopilotInit,
    Copy,
    CountdownTimer,
    Crosshair,
    CursorIBeam,
    Dash,
    DatabaseZap,
    Debug,
    DebugBreakpoint,
    DebugContinue,
    DebugDisabledBreakpoint,
    DebugDisabledLogBreakpoint,
    DebugDetach,
    DebugIgnoreBreakpoints,
    DebugLogBreakpoint,
    DebugPause,
    DebugStepBack,
    DebugStepInto,
    DebugStepOut,
    DebugStepOver,
    Diff,
    Disconnected,
    Download,
    EditorAtom,
    EditorCursor,
    EditorEmacs,
    EditorJetBrains,
    EditorSublime,
    EditorVsCode,
    Ellipsis,
    EllipsisVertical,
    Envelope,
    Eraser,
    Escape,
    Exit,
    ExpandDown,
    ExpandUp,
    ExpandVertical,
    Eye,
    File,
    FileCode,
    FileDiff,
    FileDoc,
    FileGeneric,
    FileGit,
    FileLock,
    FileMarkdown,
    FileRust,
    FileTextFilled,
    FileTextOutlined,
    FileToml,
    FileTree,
    Filter,
    Flame,
    Folder,
    FolderOpen,
    FolderSearch,
    Font,
    FontSize,
    FontWeight,
    ForwardArrow,
    GenericClose,
    GenericMaximize,
    GenericMinimize,
    GenericRestore,
    GitBranch,
    GitBranchAlt,
    Github,
    Hash,
    HistoryRerun,
    Image,
    Indicator,
    Info,
    Json,
    Keyboard,
    Library,
    LineHeight,
    Link,
    ListCollapse,
    ListFilter,
    ListTodo,
    ListTree,
    ListX,
    LoadCircle,
    LocationEdit,
    LockOutlined,
    MagnifyingGlass,
    Maximize,
    Menu,
    MenuAlt,
    MenuAltTemp,
    Mic,
    MicMute,
    Minimize,
    Notepad,
    Option,
    PageDown,
    PageUp,
    Paperclip,
    Pencil,
    PencilUnavailable,
    Person,
    Pin,
    PlayOutlined,
    PlayFilled,
    Plus,
    Power,
    Public,
    PullRequest,
    Quote,
    Reader,
    RefreshTitle,
    Regex,
    ReplNeutral,
    Replace,
    ReplaceAll,
    ReplaceNext,
    ReplyArrowRight,
    Rerun,
    Return,
    RotateCcw,
    RotateCw,
    Scissors,
    Screen,
    SelectAll,
    Send,
    Server,
    Settings,
    ShieldCheck,
    Shift,
    Slash,
    Sliders,
    Space,
    Sparkle,
    Split,
    SplitAlt,
    SquareDot,
    SquareMinus,
    SquarePlus,
    Star,
    StarFilled,
    Stop,
    Supermaven,
    SupermavenDisabled,
    SupermavenError,
    SupermavenInit,
    SwatchBook,
    SweepAi,
    Tab,
    Terminal,
    TerminalAlt,
    TerminalGhost,
    TextSnippet,
    TextThread,
    Thread,
    ThreadFromSummary,
    ThumbsDown,
    ThumbsUp,
    TodoComplete,
    TodoPending,
    TodoProgress,
    ToolCopy,
    ToolDeleteFile,
    ToolDiagnostics,
    ToolFolder,
    ToolHammer,
    ToolNotification,
    ToolPencil,
    ToolRead,
    ToolRegex,
    ToolSearch,
    ToolTerminal,
    ToolThink,
    ToolWeb,
    Trash,
    Triangle,
    TriangleRight,
    Undo,
    Unpin,
    UserCheck,
    UserGroup,
    UserRoundPen,
    Warning,
    WholeWord,
    XCircle,
    XCircleFilled,
    ZedAgent,
    ZedAssistant,
    ZedBurnMode,
    ZedBurnModeOn,
    ZedSrcCustom,
    ZedSrcExtension,
    ZedPredict,
    ZedPredictDisabled,
    ZedPredictDown,
    ZedPredictError,
    ZedPredictUp,
    ZedXCopilot,
    Linux,
}

impl IconName {
    /// Returns the path to this icon.
    pub fn path(&self) -> Arc<str> {
        let file_stem: &'static str = self.into();
        format!("icons/{file_stem}.svg").into()
    }
}
