/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.midlet;

import com.sun.midp.Configuration;
import com.sun.midp.lcdui.DisplayAccess;
import com.sun.midp.lcdui.MIDLetMap;
import com.sun.midp.midlet.MIDletState;
import com.sun.midp.midlet.MIDletSuite;
import javax.microedition.midlet.MIDletStateChangeException;

public class Scheduler {
    private MIDletSuite midletSuite;
    private MIDletState foreground;
    private MIDletState[] midlets;
    private int nmidlets;
    private int scanIndex;
    private static Object mutex;
    private static Scheduler scheduler;

    protected Scheduler() {
        if (scheduler != null) {
            throw new Error("Only one scheduler instance allowed");
        }
        mutex = new Object();
        this.nmidlets = 0;
        this.midlets = new MIDletState[5];
    }

    public static synchronized Scheduler getScheduler() {
        if (scheduler == null) {
            String prop = Configuration.getProperty("com.sun.midp.midlet.scheduler");
            if (prop != null) {
                try {
                    scheduler = (Scheduler)Class.forName(prop).newInstance();
                }
                catch (Throwable ex) {
                    throw new Error("A scheduler cannot be created from the value of property com.sun.midp.midlet.scheduler");
                }
            } else {
                scheduler = new Scheduler();
            }
        }
        return scheduler;
    }

    protected void register(MIDletState midlet) {
        Object object = mutex;
        synchronized (object) {
            int i = this.findMIDletByClass(midlet);
            if (i >= 0) {
                midlet.setState(4);
            }
            if (this.nmidlets >= this.midlets.length) {
                MIDletState[] n = new MIDletState[this.nmidlets + 5];
                System.arraycopy(this.midlets, 0, n, 0, this.nmidlets);
                this.midlets = n;
            }
            this.midlets[this.nmidlets++] = midlet;
        }
    }

    protected Object getMutex() {
        return mutex;
    }

    public MIDletSuite getMIDletSuite() {
        return this.midletSuite;
    }

    public void schedule(MIDletSuite aMidletSuite) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.midletSuite != null) {
            throw new RuntimeException("There is already a MIDlet Suite scheduled.");
        }
        this.midletSuite = aMidletSuite;
        this.midletSuite.loadInitialMIDlet();
        while (this.nmidlets > 0) {
            try {
                MIDletState newfg;
                MIDletState oldfg;
                Object object = mutex;
                synchronized (object) {
                    oldfg = null;
                    if (this.foreground != null && this.foreground.getState() != 2) {
                        oldfg = this.foreground;
                        this.foreground = null;
                    }
                    newfg = null;
                    if (this.foreground == null) {
                        this.foreground = this.selectForeground(oldfg);
                        if (this.foreground != null) {
                            this.foreground.setState(2);
                            newfg = this.foreground;
                        }
                    }
                }
                if (oldfg != null) {
                    Scheduler.setForeground(oldfg, false);
                }
                if (newfg != null) {
                    Scheduler.setForeground(newfg, true);
                }
                Object object2 = mutex;
                synchronized (object2) {
                    MIDletState curr = this.selectByPriority();
                    switch (curr.getState()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            try {
                                mutex.wait();
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                        case 3: {
                            try {
                                curr.setState(1);
                                curr.startApp();
                            }
                            catch (Exception ex) {
                                Scheduler.printException("startApp threw an Exception", ex);
                                curr.setState(4);
                            }
                            break;
                        }
                        case 4: {
                            try {
                                curr.destroyApp(true);
                            }
                            catch (MIDletStateChangeException ex) {
                            }
                            catch (Exception ex) {
                                Scheduler.printException("destroyApp threw an Exception", ex);
                            }
                            curr.setState(5);
                        }
                        case 5: {
                            this.unregister(curr);
                            break;
                        }
                        default: {
                            throw new Error("Illegal MIDletState state " + curr.getState());
                        }
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Exception in schedule");
                ex.printStackTrace();
            }
        }
        this.midletSuite = null;
    }

    private MIDletState selectByPriority() {
        MIDletState found = null;
        int state = -1;
        int i = this.nmidlets - 1;
        while (i >= 0) {
            int s;
            if (this.scanIndex < 0 || this.scanIndex >= this.nmidlets) {
                this.scanIndex = this.nmidlets - 1;
            }
            if ((s = this.midlets[this.scanIndex].getState()) > state) {
                found = this.midlets[this.scanIndex];
                state = s;
            }
            --this.scanIndex;
            --i;
        }
        return found;
    }

    private MIDletState selectForeground(MIDletState oldfg) {
        MIDletState found = null;
        int i = this.nmidlets - 1;
        while (i >= 0) {
            if (this.midlets[i].getState() == 1 && (found = this.midlets[i]).getDisplayAccess().hasCurrent()) {
                return found;
            }
            --i;
        }
        if (oldfg != null && oldfg.getState() == 1) {
            return oldfg;
        }
        return found;
    }

    public void notifyHasCurrent(DisplayAccess displayAccess, boolean hasCurrent) {
        Object object = mutex;
        synchronized (object) {
            if (this.foreground != null) {
                DisplayAccess fda = this.foreground.getDisplayAccess();
                if (fda == displayAccess) {
                    if (!hasCurrent && this.foreground.getState() == 2) {
                        this.foreground.setState(1);
                    }
                } else if (hasCurrent && !fda.hasCurrent() && this.foreground.getState() == 2) {
                    this.foreground.setState(1);
                }
            }
            mutex.notify();
        }
    }

    public void notifyEnd(DisplayAccess displayAccess) {
        Object object = mutex;
        synchronized (object) {
            if (this.foreground != null) {
                if (this.foreground.getDisplayAccess() != displayAccess) {
                    return;
                }
                this.foreground.setState(4);
                this.scanIndex = 0;
            }
        }
    }

    protected static boolean hasForeground(MIDletState midlet) {
        return midlet != null && midlet == Scheduler.scheduler.foreground;
    }

    private static void setForeground(MIDletState midlet, boolean foreground) {
        midlet.getDisplayAccess().setForeground(foreground);
    }

    private void unregister(MIDletState m) {
        int i = 0;
        while (i < this.nmidlets) {
            if (m == this.midlets[i]) {
                this.midlets[i] = this.midlets[this.nmidlets - 1];
                this.midlets[--this.nmidlets] = null;
                MIDLetMap.remove(m.getMIDlet());
                break;
            }
            ++i;
        }
    }

    private int findMIDletByClass(MIDletState m) {
        int i = 0;
        while (i < this.nmidlets) {
            if (m.getMIDlet().getClass() == this.midlets[i].getMIDlet().getClass()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void printException(String msg, Exception ex) {
        try {
            System.out.println(msg);
            if (ex.getMessage() == null) {
                System.out.println(ex);
            }
            ex.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

