/*
 * Decompiled with CFR 0.152.
 */
package java.util;

public class Random {
    private long seed;
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;

    public Random() {
        this(System.currentTimeMillis());
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public synchronized void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }

    protected synchronized int next(int bits) {
        long nextseed;
        this.seed = nextseed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(nextseed >>> 48 - bits);
    }

    public int nextInt() {
        return this.next(32);
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }
}

