/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Layout;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringLayout;

public abstract class Item {
    private String label;
    private Screen owner;
    private boolean focus;
    Layout[] layouts;

    Item(String label) {
        this.label = label;
    }

    Item(String label, int num) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.label = label;
            if (num > 0) {
                this.layouts = new Layout[num];
                this.layouts[0] = new StringLayout(label, Screen.CONTENT_FONT);
            }
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    Screen getOwner() {
        return this.owner;
    }

    void setOwner(Screen owner) {
        if (this.owner != null && owner != null) {
            throw new IllegalStateException();
        }
        this.owner = owner;
        if (owner == null) {
            this.focus = false;
        }
    }

    void focusChanged() {
        if (this.initLayoutDone()) {
            int itemY = this.owner instanceof Form ? ((Form)this.owner).getItemY(this) : 0;
            this.owner.repaintContent(0, itemY, Display.WIDTH, this.getHeight());
        }
    }

    void setFocus(boolean newFocus) {
        if (newFocus != this.focus) {
            this.focus = newFocus;
            this.focusChanged();
        }
    }

    boolean hasFocus() {
        return this.focus;
    }

    boolean takesFocus() {
        return true;
    }

    int initHilight(int vpY, int vpH) {
        return 0;
    }

    int traverse(int dir, int top, int bottom, boolean traversingIn, boolean allowTraverseOut) {
        return Form.traverse(dir == 6, top, bottom, this.getHeight(), Screen.CONTENT_HEIGHT, traversingIn, this.takesFocus());
    }

    abstract int getHeight();

    abstract int setWidth(int var1);

    abstract void paint(Graphics var1);

    final void repaint(int x, int y, int width, int height) {
        if (this.initLayoutDone()) {
            int itemY = this.owner instanceof Form ? ((Form)this.owner).getItemY(this) : 0;
            this.owner.repaintContent(x, itemY + y, width, height);
        }
    }

    boolean select() {
        return false;
    }

    boolean keyPressed(int keyCode) {
        return false;
    }

    void keyTyped(char c) {
    }

    void contentChanged(int x, int y, int deltaHeight) {
        if (this.initLayoutDone()) {
            this.owner.contentChanged(this, x, y, deltaHeight);
        }
    }

    boolean isGrouped(Item item) {
        return item == this;
    }

    boolean isGroupable() {
        return false;
    }

    boolean initLayoutDone() {
        return this.owner != null && this.owner.initLayoutDone();
    }
}

