/*
Copyright 2020 The Flux CD contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package gitprovider

import (
	"fmt"
	"net/url"
)

// BoolVar returns a pointer to the given bool.
func BoolVar(b bool) *bool {
	return &b
}

// StringVar returns a pointer to the given string.
func StringVar(s string) *string {
	return &s
}

// GetDomainURL returns the domain URL prepended with https:// if a scheme is not set.
func GetDomainURL(d string) string {
	parsedURL, _ := url.Parse(d)
	if parsedURL.Scheme != "https" && parsedURL.Scheme != "http" {
		d = fmt.Sprintf("https://%s", d)
	}
	return d
}
