/*
  --------------------------------------------------------------
  Conjunctive normal form
  --------------------------------------------------------------
*/

#ifndef __CNF_H
#define __CNF_H

#include "bool/bool.h"
#include "proof/proof-id.h"
#include "symbolic/DAG.h"
#include "veriT-config.h"

/**
   \brief add clauses for cnf associated with DAG
   \param DAG the formula
   \param Pclauses a pointer to a stack of clauses where to add cnf
   \remark assumes previous clauses generated by cnf module are still there */
void cnf(TDAG DAG, Tstack_clause* Pclauses);

/**
   \brief add clauses for cnf associated with DAG
   \param DAG the formula
   \param Pclauses a pointer to a stack of clauses where to add cnf
   \param proof the proof
   \remark assumes previous clauses generated by cnf module are still there */
void cnf_proof(TDAG DAG, Tstack_clause* Pclauses, Tproof proof);

void cnf_init(void);
void cnf_done(void);
void cnf_reset(void);

#endif /* __CNF_H */
