export declare function score(intervals: FuzzyMatchingInterval[], strLength: number): number;
export interface FuzzyConfiguration {
    caseSensitive?: boolean;
    excludedChars?: string[];
    includeMatches?: boolean;
    shouldSort?: boolean;
    shouldRender?: boolean;
    escapeHTML?: boolean;
    pre?: string;
    post?: string;
}
export interface FuzzyMatchingInterval {
    from: number;
    to: number;
}
export interface FuzzyResult {
    rendered: string;
    original: string;
    index: number;
    score: number;
    intervals?: FuzzyMatchingInterval[];
}
export declare class Fuzzy {
    private readonly conf;
    constructor(conf?: FuzzyConfiguration);
    filter(pattern: string, list: string[], conf?: FuzzyConfiguration): FuzzyResult[];
    match(pattern: string, text: string, conf?: FuzzyConfiguration): FuzzyResult | null;
    render(text: string, intervals: FuzzyMatchingInterval[], conf?: FuzzyConfiguration): string;
    private extractSubString;
    private generateMatchingInterval;
}
export declare function filter(pattern: string, list: string[], conf?: FuzzyConfiguration): FuzzyResult[];
export declare function match(pattern: string, text: string, conf?: FuzzyConfiguration): FuzzyResult | null;
export declare function render(text: string, intervals: FuzzyMatchingInterval[], conf?: FuzzyConfiguration): string;
