/**
 * @license @tabler/icons-react v3.28.1 - MIT
 *
 * This source code is licensed under the MIT license.
 * See the LICENSE file in the root directory of this source tree.
 */

'use strict';

var react = require('react');

var defaultAttributes = {
  outline: {
    xmlns: "http://www.w3.org/2000/svg",
    width: 24,
    height: 24,
    viewBox: "0 0 24 24",
    fill: "none",
    stroke: "currentColor",
    strokeWidth: 2,
    strokeLinecap: "round",
    strokeLinejoin: "round"
  },
  filled: {
    xmlns: "http://www.w3.org/2000/svg",
    width: 24,
    height: 24,
    viewBox: "0 0 24 24",
    fill: "currentColor",
    stroke: "none"
  }
};

const createReactComponent = (type, iconName, iconNamePascal, iconNode) => {
  const Component = react.forwardRef(
    ({ color = "currentColor", size = 24, stroke = 2, title, className, children, ...rest }, ref) => react.createElement(
      "svg",
      {
        ref,
        ...defaultAttributes[type],
        width: size,
        height: size,
        className: [`tabler-icon`, `tabler-icon-${iconName}`, className].join(" "),
        ...type === "filled" ? {
          fill: color
        } : {
          strokeWidth: stroke,
          stroke: color
        },
        ...rest
      },
      [
        title && react.createElement("title", { key: "svg-title" }, title),
        ...iconNode.map(([tag, attrs]) => react.createElement(tag, attrs)),
        ...Array.isArray(children) ? children : [children]
      ]
    )
  );
  Component.displayName = `${iconNamePascal}`;
  return Component;
};

var IconAB2 = createReactComponent("outline", "a-b-2", "IconAB2", [["path", { "d": "M16 21h3c.81 0 1.48 -.67 1.48 -1.48l.02 -.02c0 -.82 -.69 -1.5 -1.5 -1.5h-3v3z", "key": "svg-0" }], ["path", { "d": "M16 15h2.5c.84 -.01 1.5 .66 1.5 1.5s-.66 1.5 -1.5 1.5h-2.5v-3z", "key": "svg-1" }], ["path", { "d": "M4 9v-4c0 -1.036 .895 -2 2 -2s2 .964 2 2v4", "key": "svg-2" }], ["path", { "d": "M2.99 11.98a9 9 0 0 0 9 9m9 -9a9 9 0 0 0 -9 -9", "key": "svg-3" }], ["path", { "d": "M8 7h-4", "key": "svg-4" }]]);

var IconAB2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAB2
});

var IconABOff = createReactComponent("outline", "a-b-off", "IconABOff", [["path", { "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5", "key": "svg-0" }], ["path", { "d": "M12 12v6", "key": "svg-1" }], ["path", { "d": "M12 6v2", "key": "svg-2" }], ["path", { "d": "M16 8h3a2 2 0 1 1 0 4h-3m3 0a2 2 0 0 1 .83 3.82m-3.83 -3.82v-4", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconABOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconABOff
});

var IconAB = createReactComponent("outline", "a-b", "IconAB", [["path", { "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5", "key": "svg-0" }], ["path", { "d": "M12 6l0 12", "key": "svg-1" }], ["path", { "d": "M16 16v-8h3a2 2 0 0 1 0 4h-3m3 0a2 2 0 0 1 0 4h-3", "key": "svg-2" }]]);

var IconAB$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAB
});

var IconAbacusOff = createReactComponent("outline", "abacus-off", "IconAbacusOff", [["path", { "d": "M5 5v16", "key": "svg-0" }], ["path", { "d": "M19 21v-2m0 -4v-12", "key": "svg-1" }], ["path", { "d": "M5 7h2m4 0h8", "key": "svg-2" }], ["path", { "d": "M5 15h10", "key": "svg-3" }], ["path", { "d": "M8 13v4", "key": "svg-4" }], ["path", { "d": "M11 13v4", "key": "svg-5" }], ["path", { "d": "M16 16v1", "key": "svg-6" }], ["path", { "d": "M14 5v4", "key": "svg-7" }], ["path", { "d": "M11 5v2", "key": "svg-8" }], ["path", { "d": "M8 8v1", "key": "svg-9" }], ["path", { "d": "M3 21h18", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconAbacusOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAbacusOff
});

var IconAbacus = createReactComponent("outline", "abacus", "IconAbacus", [["path", { "d": "M5 3v18", "key": "svg-0" }], ["path", { "d": "M19 21v-18", "key": "svg-1" }], ["path", { "d": "M5 7h14", "key": "svg-2" }], ["path", { "d": "M5 15h14", "key": "svg-3" }], ["path", { "d": "M8 13v4", "key": "svg-4" }], ["path", { "d": "M11 13v4", "key": "svg-5" }], ["path", { "d": "M16 13v4", "key": "svg-6" }], ["path", { "d": "M14 5v4", "key": "svg-7" }], ["path", { "d": "M11 5v4", "key": "svg-8" }], ["path", { "d": "M8 5v4", "key": "svg-9" }], ["path", { "d": "M3 21h18", "key": "svg-10" }]]);

var IconAbacus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAbacus
});

var IconAbc = createReactComponent("outline", "abc", "IconAbc", [["path", { "d": "M3 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M3 13h4", "key": "svg-1" }], ["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-1a2 2 0 1 0 -4 0v1", "key": "svg-2" }], ["path", { "d": "M20.732 12a2 2 0 0 0 -3.732 1v1a2 2 0 0 0 3.726 1.01", "key": "svg-3" }]]);

var IconAbc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAbc
});

var IconAccessPointOff = createReactComponent("outline", "access-point-off", "IconAccessPointOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M14.828 9.172a4 4 0 0 1 1.172 2.828", "key": "svg-1" }], ["path", { "d": "M17.657 6.343a8 8 0 0 1 1.635 8.952", "key": "svg-2" }], ["path", { "d": "M9.168 14.828a4 4 0 0 1 0 -5.656", "key": "svg-3" }], ["path", { "d": "M6.337 17.657a8 8 0 0 1 0 -11.314", "key": "svg-4" }]]);

var IconAccessPointOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAccessPointOff
});

var IconAccessPoint = createReactComponent("outline", "access-point", "IconAccessPoint", [["path", { "d": "M12 12l0 .01", "key": "svg-0" }], ["path", { "d": "M14.828 9.172a4 4 0 0 1 0 5.656", "key": "svg-1" }], ["path", { "d": "M17.657 6.343a8 8 0 0 1 0 11.314", "key": "svg-2" }], ["path", { "d": "M9.168 14.828a4 4 0 0 1 0 -5.656", "key": "svg-3" }], ["path", { "d": "M6.337 17.657a8 8 0 0 1 0 -11.314", "key": "svg-4" }]]);

var IconAccessPoint$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAccessPoint
});

var IconAccessibleOff = createReactComponent("outline", "accessible-off", "IconAccessibleOff", [["path", { "d": "M10 16.5l2 -3l2 3m-2 -3v-1.5m2.627 -1.376l.373 -.124m-6 0l2.231 .744", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 8a.5 .5 0 1 0 -.5 -.5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAccessibleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAccessibleOff
});

var IconAccessible = createReactComponent("outline", "accessible", "IconAccessible", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1", "key": "svg-1" }], ["circle", { "cx": "12", "cy": "7.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }]]);

var IconAccessible$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAccessible
});

var IconActivityHeartbeat = createReactComponent("outline", "activity-heartbeat", "IconActivityHeartbeat", [["path", { "d": "M3 12h4.5l1.5 -6l4 12l2 -9l1.5 3h4.5", "key": "svg-0" }]]);

var IconActivityHeartbeat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconActivityHeartbeat
});

var IconActivity = createReactComponent("outline", "activity", "IconActivity", [["path", { "d": "M3 12h4l3 8l4 -16l3 8h4", "key": "svg-0" }]]);

var IconActivity$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconActivity
});

var IconAd2 = createReactComponent("outline", "ad-2", "IconAd2", [["path", { "d": "M11.933 5h-6.933v16h13v-8", "key": "svg-0" }], ["path", { "d": "M14 17h-5", "key": "svg-1" }], ["path", { "d": "M9 13h5v-4h-5z", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }], ["path", { "d": "M18 6l2 -2", "key": "svg-4" }], ["path", { "d": "M19 9h2", "key": "svg-5" }]]);

var IconAd2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAd2
});

var IconAdCircleOff = createReactComponent("outline", "ad-circle-off", "IconAdCircleOff", [["path", { "d": "M4.91 4.949a9.968 9.968 0 0 0 -2.91 7.051c0 5.523 4.477 10 10 10a9.968 9.968 0 0 0 7.05 -2.909", "key": "svg-0" }], ["path", { "d": "M20.778 16.793a9.955 9.955 0 0 0 1.222 -4.793c0 -5.523 -4.477 -10 -10 -10c-1.74 0 -3.376 .444 -4.8 1.225", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.138 -1.358", "key": "svg-2" }], ["path", { "d": "M9.854 9.853c.094 .196 .146 .415 .146 .647v4.5", "key": "svg-3" }], ["path", { "d": "M7 13h3", "key": "svg-4" }], ["path", { "d": "M14 14v1h1", "key": "svg-5" }], ["path", { "d": "M17 13v-2a2 2 0 0 0 -2 -2h-1v1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconAdCircleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdCircleOff
});

var IconAdCircle = createReactComponent("outline", "ad-circle", "IconAdCircle", [["path", { "d": "M12 12m-10 0a10 10 0 1 0 20 0a10 10 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-1" }], ["path", { "d": "M7 13h3", "key": "svg-2" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-3" }]]);

var IconAdCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdCircle
});

var IconAdOff = createReactComponent("outline", "ad-off", "IconAdOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 15v-4a2 2 0 0 1 2 -2m2 2v4", "key": "svg-1" }], ["path", { "d": "M7 13h4", "key": "svg-2" }], ["path", { "d": "M17 9v4", "key": "svg-3" }], ["path", { "d": "M16.115 12.131c.33 .149 .595 .412 .747 .74", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAdOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdOff
});

var IconAd = createReactComponent("outline", "ad", "IconAd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v-4a2 2 0 0 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M7 13l4 0", "key": "svg-2" }], ["path", { "d": "M17 9v6h-1.5a1.5 1.5 0 1 1 1.5 -1.5", "key": "svg-3" }]]);

var IconAd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAd
});

var IconAddressBookOff = createReactComponent("outline", "address-book-off", "IconAddressBookOff", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.57 3.399c-.363 .37 -.87 .601 -1.43 .601h-10a2 2 0 0 1 -2 -2v-12", "key": "svg-0" }], ["path", { "d": "M10 16h6", "key": "svg-1" }], ["path", { "d": "M11 11a2 2 0 0 0 2 2m2 -2a2 2 0 0 0 -2 -2", "key": "svg-2" }], ["path", { "d": "M4 8h3", "key": "svg-3" }], ["path", { "d": "M4 12h3", "key": "svg-4" }], ["path", { "d": "M4 16h3", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconAddressBookOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAddressBookOff
});

var IconAddressBook = createReactComponent("outline", "address-book", "IconAddressBook", [["path", { "d": "M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z", "key": "svg-0" }], ["path", { "d": "M10 16h6", "key": "svg-1" }], ["path", { "d": "M13 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M4 8h3", "key": "svg-3" }], ["path", { "d": "M4 12h3", "key": "svg-4" }], ["path", { "d": "M4 16h3", "key": "svg-5" }]]);

var IconAddressBook$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAddressBook
});

var IconAdjustmentsAlt = createReactComponent("outline", "adjustments-alt", "IconAdjustmentsAlt", [["path", { "d": "M4 8h4v4h-4z", "key": "svg-0" }], ["path", { "d": "M6 4l0 4", "key": "svg-1" }], ["path", { "d": "M6 12l0 8", "key": "svg-2" }], ["path", { "d": "M10 14h4v4h-4z", "key": "svg-3" }], ["path", { "d": "M12 4l0 10", "key": "svg-4" }], ["path", { "d": "M12 18l0 2", "key": "svg-5" }], ["path", { "d": "M16 5h4v4h-4z", "key": "svg-6" }], ["path", { "d": "M18 4l0 1", "key": "svg-7" }], ["path", { "d": "M18 9l0 11", "key": "svg-8" }]]);

var IconAdjustmentsAlt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsAlt
});

var IconAdjustmentsBolt = createReactComponent("outline", "adjustments-bolt", "IconAdjustmentsBolt", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-5" }], ["path", { "d": "M12 18v2", "key": "svg-6" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-7" }], ["path", { "d": "M18 4v1", "key": "svg-8" }], ["path", { "d": "M18 9v3", "key": "svg-9" }]]);

var IconAdjustmentsBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsBolt
});

var IconAdjustmentsCancel = createReactComponent("outline", "adjustments-cancel", "IconAdjustmentsCancel", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.499 14.675a2 2 0 1 0 -1.499 3.325", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-9" }], ["path", { "d": "M17 21l4 -4", "key": "svg-10" }]]);

var IconAdjustmentsCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsCancel
});

var IconAdjustmentsCheck = createReactComponent("outline", "adjustments-check", "IconAdjustmentsCheck", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.823 15.176a2 2 0 1 0 -2.638 2.651", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v5", "key": "svg-7" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-8" }]]);

var IconAdjustmentsCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsCheck
});

var IconAdjustmentsCode = createReactComponent("outline", "adjustments-code", "IconAdjustmentsCode", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.557 14.745a2 2 0 1 0 -1.557 3.255", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v4", "key": "svg-8" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-9" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-10" }]]);

var IconAdjustmentsCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsCode
});

var IconAdjustmentsCog = createReactComponent("outline", "adjustments-cog", "IconAdjustmentsCog", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.199 14.399a2 2 0 1 0 -1.199 3.601", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v2.5", "key": "svg-8" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-9" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-10" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-11" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-12" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-13" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-14" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-15" }]]);

var IconAdjustmentsCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsCog
});

var IconAdjustmentsDollar = createReactComponent("outline", "adjustments-dollar", "IconAdjustmentsDollar", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.366 14.54a2 2 0 1 0 -.216 3.097", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v1", "key": "svg-8" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-9" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-10" }]]);

var IconAdjustmentsDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsDollar
});

var IconAdjustmentsDown = createReactComponent("outline", "adjustments-down", "IconAdjustmentsDown", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.945 15.53a2 2 0 1 0 -1.945 2.47", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 16v6", "key": "svg-9" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-10" }]]);

var IconAdjustmentsDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsDown
});

var IconAdjustmentsExclamation = createReactComponent("outline", "adjustments-exclamation", "IconAdjustmentsExclamation", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 16v3", "key": "svg-9" }], ["path", { "d": "M19 22v.01", "key": "svg-10" }]]);

var IconAdjustmentsExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsExclamation
});

var IconAdjustmentsHeart = createReactComponent("outline", "adjustments-heart", "IconAdjustmentsHeart", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 4v8.5", "key": "svg-3" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-4" }], ["path", { "d": "M18 4v1", "key": "svg-5" }], ["path", { "d": "M18 9v2.5", "key": "svg-6" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-7" }]]);

var IconAdjustmentsHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsHeart
});

var IconAdjustmentsHorizontal = createReactComponent("outline", "adjustments-horizontal", "IconAdjustmentsHorizontal", [["path", { "d": "M14 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M4 6l8 0", "key": "svg-1" }], ["path", { "d": "M16 6l4 0", "key": "svg-2" }], ["path", { "d": "M8 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M4 12l2 0", "key": "svg-4" }], ["path", { "d": "M10 12l10 0", "key": "svg-5" }], ["path", { "d": "M17 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-6" }], ["path", { "d": "M4 18l11 0", "key": "svg-7" }], ["path", { "d": "M19 18l1 0", "key": "svg-8" }]]);

var IconAdjustmentsHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsHorizontal
});

var IconAdjustmentsMinus = createReactComponent("outline", "adjustments-minus", "IconAdjustmentsMinus", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.954 15.574a2 2 0 1 0 -1.954 2.426", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v6", "key": "svg-8" }], ["path", { "d": "M16 19h6", "key": "svg-9" }]]);

var IconAdjustmentsMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsMinus
});

var IconAdjustmentsOff = createReactComponent("outline", "adjustments-off", "IconAdjustmentsOff", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 6v2", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v4m0 4v2", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v5m0 4v2", "key": "svg-8" }], ["path", { "d": "M3 3l18 18", "key": "svg-9" }]]);

var IconAdjustmentsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsOff
});

var IconAdjustmentsPause = createReactComponent("outline", "adjustments-pause", "IconAdjustmentsPause", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.627 14.836a2 2 0 1 0 -.62 2.892", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M17 17v5", "key": "svg-8" }], ["path", { "d": "M21 17v5", "key": "svg-9" }], ["path", { "d": "M18 9v4.5", "key": "svg-10" }]]);

var IconAdjustmentsPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsPause
});

var IconAdjustmentsPin = createReactComponent("outline", "adjustments-pin", "IconAdjustmentsPin", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.071 14.31a2 2 0 1 0 -1.071 3.69", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v2.5", "key": "svg-8" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-9" }], ["path", { "d": "M19 18v.01", "key": "svg-10" }]]);

var IconAdjustmentsPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsPin
});

var IconAdjustmentsPlus = createReactComponent("outline", "adjustments-plus", "IconAdjustmentsPlus", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.958 15.592a2 2 0 1 0 -1.958 2.408", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M16 19h6", "key": "svg-9" }], ["path", { "d": "M19 16v6", "key": "svg-10" }]]);

var IconAdjustmentsPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsPlus
});

var IconAdjustmentsQuestion = createReactComponent("outline", "adjustments-question", "IconAdjustmentsQuestion", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.577 14.77a2 2 0 1 0 .117 2.295", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-6" }], ["path", { "d": "M12 18v2", "key": "svg-7" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-8" }], ["path", { "d": "M18 4v1", "key": "svg-9" }], ["path", { "d": "M18 9v2", "key": "svg-10" }]]);

var IconAdjustmentsQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsQuestion
});

var IconAdjustmentsSearch = createReactComponent("outline", "adjustments-search", "IconAdjustmentsSearch", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 14a2 2 0 0 0 -1.042 3.707", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v2", "key": "svg-7" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-8" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-9" }]]);

var IconAdjustmentsSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsSearch
});

var IconAdjustmentsShare = createReactComponent("outline", "adjustments-share", "IconAdjustmentsShare", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.387 14.56a2 2 0 1 0 -.798 3.352", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M16 22l5 -5", "key": "svg-8" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-9" }], ["path", { "d": "M18 9v4", "key": "svg-10" }]]);

var IconAdjustmentsShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsShare
});

var IconAdjustmentsSpark = createReactComponent("outline", "adjustments-spark", "IconAdjustmentsSpark", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.879 15.312a2 2 0 1 0 -2.26 2.652", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-5" }], ["path", { "d": "M18 4v1", "key": "svg-6" }], ["path", { "d": "M18 9v2.5", "key": "svg-7" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-8" }]]);

var IconAdjustmentsSpark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsSpark
});

var IconAdjustmentsStar = createReactComponent("outline", "adjustments-star", "IconAdjustmentsStar", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M12 4v9.5", "key": "svg-3" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-4" }], ["path", { "d": "M18 4v1", "key": "svg-5" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-6" }], ["path", { "d": "M18 9v1", "key": "svg-7" }]]);

var IconAdjustmentsStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsStar
});

var IconAdjustmentsUp = createReactComponent("outline", "adjustments-up", "IconAdjustmentsUp", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.927 15.462a2 2 0 1 0 -1.927 2.538", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v3", "key": "svg-8" }], ["path", { "d": "M19 22v-6", "key": "svg-9" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-10" }]]);

var IconAdjustmentsUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsUp
});

var IconAdjustmentsX = createReactComponent("outline", "adjustments-x", "IconAdjustmentsX", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M13.653 14.874a2 2 0 1 0 -.586 2.818", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v4", "key": "svg-8" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-9" }], ["path", { "d": "M17 22l5 -5", "key": "svg-10" }]]);

var IconAdjustmentsX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustmentsX
});

var IconAdjustments = createReactComponent("outline", "adjustments", "IconAdjustments", [["path", { "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 4v4", "key": "svg-1" }], ["path", { "d": "M6 12v8", "key": "svg-2" }], ["path", { "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M12 4v10", "key": "svg-4" }], ["path", { "d": "M12 18v2", "key": "svg-5" }], ["path", { "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-6" }], ["path", { "d": "M18 4v1", "key": "svg-7" }], ["path", { "d": "M18 9v11", "key": "svg-8" }]]);

var IconAdjustments$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAdjustments
});

var IconAerialLift = createReactComponent("outline", "aerial-lift", "IconAerialLift", [["path", { "d": "M4 5l16 -2m-8 1v10m-5.106 -6h10.306c2.45 3 2.45 9 -.2 12h-10.106c-2.544 -3 -2.544 -9 0 -12zm-1.894 6h14", "key": "svg-0" }]]);

var IconAerialLift$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAerialLift
});

var IconAffiliate = createReactComponent("outline", "affiliate", "IconAffiliate", [["path", { "d": "M5.931 6.936l1.275 4.249m5.607 5.609l4.251 1.275", "key": "svg-0" }], ["path", { "d": "M11.683 12.317l5.759 -5.759", "key": "svg-1" }], ["path", { "d": "M5.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-2" }], ["path", { "d": "M18.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-3" }], ["path", { "d": "M18.5 18.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-4" }], ["path", { "d": "M8.5 15.5m-4.5 0a4.5 4.5 0 1 0 9 0a4.5 4.5 0 1 0 -9 0", "key": "svg-5" }]]);

var IconAffiliate$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAffiliate
});

var IconAi = createReactComponent("outline", "ai", "IconAi", [["path", { "d": "M8 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M8 13h4", "key": "svg-1" }], ["path", { "d": "M16 8v8", "key": "svg-2" }]]);

var IconAi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAi
});

var IconAirBalloon = createReactComponent("outline", "air-balloon", "IconAirBalloon", [["path", { "d": "M10 19m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 16c3.314 0 6 -4.686 6 -8a6 6 0 1 0 -12 0c0 3.314 2.686 8 6 8z", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 7 0 1 0 4 0a2 7 0 1 0 -4 0", "key": "svg-2" }]]);

var IconAirBalloon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAirBalloon
});

var IconAirConditioningDisabled = createReactComponent("outline", "air-conditioning-disabled", "IconAirConditioningDisabled", [["path", { "d": "M3 8m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 16v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3", "key": "svg-1" }]]);

var IconAirConditioningDisabled$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAirConditioningDisabled
});

var IconAirConditioning = createReactComponent("outline", "air-conditioning", "IconAirConditioning", [["path", { "d": "M8 16a3 3 0 0 1 -3 3", "key": "svg-0" }], ["path", { "d": "M16 16a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M12 16v4", "key": "svg-2" }], ["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M7 13v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3", "key": "svg-4" }]]);

var IconAirConditioning$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAirConditioning
});

var IconAirTrafficControl = createReactComponent("outline", "air-traffic-control", "IconAirTrafficControl", [["path", { "d": "M11 3h2", "key": "svg-0" }], ["path", { "d": "M12 3v3", "key": "svg-1" }], ["path", { "d": "M5.998 6h12.004a2 2 0 0 1 1.916 2.575l-1.8 6a2 2 0 0 1 -1.916 1.425h-8.404a2 2 0 0 1 -1.916 -1.425l-1.8 -6a2 2 0 0 1 1.916 -2.575z", "key": "svg-2" }], ["path", { "d": "M8.5 6l1.5 10v5", "key": "svg-3" }], ["path", { "d": "M15.5 6l-1.5 10v5", "key": "svg-4" }]]);

var IconAirTrafficControl$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAirTrafficControl
});

var IconAlarmAverage = createReactComponent("outline", "alarm-average", "IconAlarmAverage", [["path", { "d": "M5 13a7 7 0 1 0 14 0a7 7 0 0 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M8 13h1l2 3l2 -6l2 3h1", "key": "svg-3" }]]);

var IconAlarmAverage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmAverage
});

var IconAlarmMinus = createReactComponent("outline", "alarm-minus", "IconAlarmMinus", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M10 13h4", "key": "svg-3" }]]);

var IconAlarmMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmMinus
});

var IconAlarmOff = createReactComponent("outline", "alarm-off", "IconAlarmOff", [["path", { "d": "M7.587 7.566a7 7 0 1 0 9.833 9.864m1.35 -2.645a7 7 0 0 0 -8.536 -8.56", "key": "svg-0" }], ["path", { "d": "M12 12v1h1", "key": "svg-1" }], ["path", { "d": "M5.261 5.265l-1.011 .735", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconAlarmOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmOff
});

var IconAlarmPlus = createReactComponent("outline", "alarm-plus", "IconAlarmPlus", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-1" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-2" }], ["path", { "d": "M10 13h4", "key": "svg-3" }], ["path", { "d": "M12 11v4", "key": "svg-4" }]]);

var IconAlarmPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmPlus
});

var IconAlarmSmoke = createReactComponent("outline", "alarm-smoke", "IconAlarmSmoke", [["path", { "d": "M18 8l-.8 3a1.25 1.25 0 0 1 -1.2 1h-8a1.25 1.25 0 0 1 -1.2 -1l-.8 -3", "key": "svg-0" }], ["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M12 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-2" }], ["path", { "d": "M7 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-3" }], ["path", { "d": "M17 16c.643 .288 1.017 .756 1 1.25c.017 .494 -.357 .962 -1 1.25s-1.017 .756 -1 1.25c-.017 .494 .357 .962 1 1.25", "key": "svg-4" }]]);

var IconAlarmSmoke$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmSmoke
});

var IconAlarmSnooze = createReactComponent("outline", "alarm-snooze", "IconAlarmSnooze", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M10 11h4l-4 4h4", "key": "svg-1" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }]]);

var IconAlarmSnooze$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarmSnooze
});

var IconAlarm = createReactComponent("outline", "alarm", "IconAlarm", [["path", { "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 10l0 3l2 0", "key": "svg-1" }], ["path", { "d": "M7 4l-2.75 2", "key": "svg-2" }], ["path", { "d": "M17 4l2.75 2", "key": "svg-3" }]]);

var IconAlarm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlarm
});

var IconAlbumOff = createReactComponent("outline", "album-off", "IconAlbumOff", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.581 3.41c-.362 .364 -.864 .59 -1.419 .59h-12a2 2 0 0 1 -2 -2v-12c0 -.552 .224 -1.052 .585 -1.413", "key": "svg-0" }], ["path", { "d": "M12 4v4m1.503 1.497l.497 -.497l2 2v-7", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAlbumOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlbumOff
});

var IconAlbum = createReactComponent("outline", "album", "IconAlbum", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 4v7l2 -2l2 2v-7", "key": "svg-1" }]]);

var IconAlbum$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlbum
});

var IconAlertCircleOff = createReactComponent("outline", "alert-circle-off", "IconAlertCircleOff", [["path", { "d": "M5.644 5.629a9 9 0 1 0 12.715 12.741m1.693 -2.349a9 9 0 0 0 -12.087 -12.068", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAlertCircleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertCircleOff
});

var IconAlertCircle = createReactComponent("outline", "alert-circle", "IconAlertCircle", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertCircle
});

var IconAlertHexagonOff = createReactComponent("outline", "alert-hexagon-off", "IconAlertHexagonOff", [["path", { "d": "M18.36 18.387l-5.268 3.333a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l1.317 -.777m2.535 -1.493l2.898 -1.709a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .414 -.116 .812 -.326 1.155", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 8v.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }], ["path", { "d": "M12 16h.01", "key": "svg-4" }]]);

var IconAlertHexagonOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertHexagonOff
});

var IconAlertHexagon = createReactComponent("outline", "alert-hexagon", "IconAlertHexagon", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertHexagon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertHexagon
});

var IconAlertOctagon = createReactComponent("outline", "alert-octagon", "IconAlertOctagon", [["path", { "d": "M12.802 2.165l5.575 2.389c.48 .206 .863 .589 1.07 1.07l2.388 5.574c.22 .512 .22 1.092 0 1.604l-2.389 5.575c-.206 .48 -.589 .863 -1.07 1.07l-5.574 2.388c-.512 .22 -1.092 .22 -1.604 0l-5.575 -2.389a2.036 2.036 0 0 1 -1.07 -1.07l-2.388 -5.574a2.036 2.036 0 0 1 0 -1.604l2.389 -5.575c.206 -.48 .589 -.863 1.07 -1.07l5.574 -2.388a2.036 2.036 0 0 1 1.604 0z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertOctagon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertOctagon
});

var IconAlertSmallOff = createReactComponent("outline", "alert-small-off", "IconAlertSmallOff", [["path", { "d": "M12 16h.01", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAlertSmallOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertSmallOff
});

var IconAlertSmall = createReactComponent("outline", "alert-small", "IconAlertSmall", [["path", { "d": "M12 8v4", "key": "svg-0" }], ["path", { "d": "M12 16h.01", "key": "svg-1" }]]);

var IconAlertSmall$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertSmall
});

var IconAlertSquareRoundedOff = createReactComponent("outline", "alert-square-rounded-off", "IconAlertSquareRoundedOff", [["path", { "d": "M19.201 19.199c-1.35 1.35 -3.6 1.801 -7.201 1.801c-7.2 0 -9 -1.8 -9 -9c0 -3.598 .45 -5.847 1.797 -7.197m2.626 -1.376c1.204 -.307 2.709 -.427 4.577 -.427c7.2 0 9 1.8 9 9c0 1.865 -.12 3.367 -.425 4.57", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAlertSquareRoundedOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertSquareRoundedOff
});

var IconAlertSquareRounded = createReactComponent("outline", "alert-square-rounded", "IconAlertSquareRounded", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertSquareRounded$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertSquareRounded
});

var IconAlertSquare = createReactComponent("outline", "alert-square", "IconAlertSquare", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M12 8v4", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertSquare
});

var IconAlertTriangleOff = createReactComponent("outline", "alert-triangle-off", "IconAlertTriangleOff", [["path", { "d": "M21.998 17.997a1.913 1.913 0 0 0 -.255 -.872l-8.106 -13.534a1.914 1.914 0 0 0 -3.274 0l-1.04 1.736m-1.493 2.493l-5.573 9.304a1.914 1.914 0 0 0 1.636 2.871h16.107", "key": "svg-0" }], ["path", { "d": "M12 16h.01", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }], ["path", { "d": "M12 7v1", "key": "svg-3" }]]);

var IconAlertTriangleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertTriangleOff
});

var IconAlertTriangle = createReactComponent("outline", "alert-triangle", "IconAlertTriangle", [["path", { "d": "M12 9v4", "key": "svg-0" }], ["path", { "d": "M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }]]);

var IconAlertTriangle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlertTriangle
});

var IconAlien = createReactComponent("outline", "alien", "IconAlien", [["path", { "d": "M11 17a2.5 2.5 0 0 0 2 0", "key": "svg-0" }], ["path", { "d": "M12 3c-4.664 0 -7.396 2.331 -7.862 5.595a11.816 11.816 0 0 0 2 8.592a10.777 10.777 0 0 0 3.199 3.064c1.666 1 3.664 1 5.33 0a10.777 10.777 0 0 0 3.199 -3.064a11.89 11.89 0 0 0 2 -8.592c-.466 -3.265 -3.198 -5.595 -7.862 -5.595z", "key": "svg-1" }], ["path", { "d": "M8 11l2 2", "key": "svg-2" }], ["path", { "d": "M16 11l-2 2", "key": "svg-3" }]]);

var IconAlien$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlien
});

var IconAlignBoxBottomCenter = createReactComponent("outline", "align-box-bottom-center", "IconAlignBoxBottomCenter", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 15v2", "key": "svg-1" }], ["path", { "d": "M12 11v6", "key": "svg-2" }], ["path", { "d": "M15 13v4", "key": "svg-3" }]]);

var IconAlignBoxBottomCenter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxBottomCenter
});

var IconAlignBoxBottomLeft = createReactComponent("outline", "align-box-bottom-left", "IconAlignBoxBottomLeft", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v2", "key": "svg-1" }], ["path", { "d": "M10 11v6", "key": "svg-2" }], ["path", { "d": "M13 13v4", "key": "svg-3" }]]);

var IconAlignBoxBottomLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxBottomLeft
});

var IconAlignBoxBottomRight = createReactComponent("outline", "align-box-bottom-right", "IconAlignBoxBottomRight", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 15v2", "key": "svg-1" }], ["path", { "d": "M14 11v6", "key": "svg-2" }], ["path", { "d": "M17 13v4", "key": "svg-3" }]]);

var IconAlignBoxBottomRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxBottomRight
});

var IconAlignBoxCenterBottom = createReactComponent("outline", "align-box-center-bottom", "IconAlignBoxCenterBottom", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 17h2", "key": "svg-1" }], ["path", { "d": "M9 14h6", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }]]);

var IconAlignBoxCenterBottom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxCenterBottom
});

var IconAlignBoxCenterMiddle = createReactComponent("outline", "align-box-center-middle", "IconAlignBoxCenterMiddle", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 15h2", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M10 9h4", "key": "svg-3" }]]);

var IconAlignBoxCenterMiddle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxCenterMiddle
});

var IconAlignBoxCenterStretch = createReactComponent("outline", "align-box-center-stretch", "IconAlignBoxCenterStretch", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 17h2", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M10 7h4", "key": "svg-3" }]]);

var IconAlignBoxCenterStretch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxCenterStretch
});

var IconAlignBoxCenterTop = createReactComponent("outline", "align-box-center-top", "IconAlignBoxCenterTop", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 13h2", "key": "svg-1" }], ["path", { "d": "M9 10h6", "key": "svg-2" }], ["path", { "d": "M10 7h4", "key": "svg-3" }]]);

var IconAlignBoxCenterTop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxCenterTop
});

var IconAlignBoxLeftBottom = createReactComponent("outline", "align-box-left-bottom", "IconAlignBoxLeftBottom", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 17h-2", "key": "svg-1" }], ["path", { "d": "M13 14h-6", "key": "svg-2" }], ["path", { "d": "M11 11h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftBottom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxLeftBottom
});

var IconAlignBoxLeftMiddle = createReactComponent("outline", "align-box-left-middle", "IconAlignBoxLeftMiddle", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 15h-2", "key": "svg-1" }], ["path", { "d": "M13 12h-6", "key": "svg-2" }], ["path", { "d": "M11 9h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftMiddle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxLeftMiddle
});

var IconAlignBoxLeftStretch = createReactComponent("outline", "align-box-left-stretch", "IconAlignBoxLeftStretch", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M9 17h-2", "key": "svg-1" }], ["path", { "d": "M13 12h-6", "key": "svg-2" }], ["path", { "d": "M11 7h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftStretch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxLeftStretch
});

var IconAlignBoxLeftTop = createReactComponent("outline", "align-box-left-top", "IconAlignBoxLeftTop", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 13h-2", "key": "svg-1" }], ["path", { "d": "M13 10h-6", "key": "svg-2" }], ["path", { "d": "M11 7h-4", "key": "svg-3" }]]);

var IconAlignBoxLeftTop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxLeftTop
});

var IconAlignBoxRightBottom = createReactComponent("outline", "align-box-right-bottom", "IconAlignBoxRightBottom", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M15 17h2", "key": "svg-1" }], ["path", { "d": "M11 14h6", "key": "svg-2" }], ["path", { "d": "M13 11h4", "key": "svg-3" }]]);

var IconAlignBoxRightBottom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxRightBottom
});

var IconAlignBoxRightMiddle = createReactComponent("outline", "align-box-right-middle", "IconAlignBoxRightMiddle", [["path", { "d": "M15 15h2", "key": "svg-0" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-1" }], ["path", { "d": "M11 12h6", "key": "svg-2" }], ["path", { "d": "M13 9h4", "key": "svg-3" }]]);

var IconAlignBoxRightMiddle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxRightMiddle
});

var IconAlignBoxRightStretch = createReactComponent("outline", "align-box-right-stretch", "IconAlignBoxRightStretch", [["path", { "d": "M15 17h2", "key": "svg-0" }], ["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z", "key": "svg-1" }], ["path", { "d": "M11 12h6", "key": "svg-2" }], ["path", { "d": "M13 7h4", "key": "svg-3" }]]);

var IconAlignBoxRightStretch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxRightStretch
});

var IconAlignBoxRightTop = createReactComponent("outline", "align-box-right-top", "IconAlignBoxRightTop", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M15 13h2", "key": "svg-1" }], ["path", { "d": "M11 10h6", "key": "svg-2" }], ["path", { "d": "M13 7h4", "key": "svg-3" }]]);

var IconAlignBoxRightTop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxRightTop
});

var IconAlignBoxTopCenter = createReactComponent("outline", "align-box-top-center", "IconAlignBoxTopCenter", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M9 9v-2", "key": "svg-1" }], ["path", { "d": "M12 13v-6", "key": "svg-2" }], ["path", { "d": "M15 11v-4", "key": "svg-3" }]]);

var IconAlignBoxTopCenter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxTopCenter
});

var IconAlignBoxTopLeft = createReactComponent("outline", "align-box-top-left", "IconAlignBoxTopLeft", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9v-2", "key": "svg-1" }], ["path", { "d": "M10 13v-6", "key": "svg-2" }], ["path", { "d": "M13 11v-4", "key": "svg-3" }]]);

var IconAlignBoxTopLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxTopLeft
});

var IconAlignBoxTopRight = createReactComponent("outline", "align-box-top-right", "IconAlignBoxTopRight", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 9v-2", "key": "svg-1" }], ["path", { "d": "M14 13v-6", "key": "svg-2" }], ["path", { "d": "M17 11v-4", "key": "svg-3" }]]);

var IconAlignBoxTopRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignBoxTopRight
});

var IconAlignCenter = createReactComponent("outline", "align-center", "IconAlignCenter", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M8 12l8 0", "key": "svg-1" }], ["path", { "d": "M6 18l12 0", "key": "svg-2" }]]);

var IconAlignCenter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignCenter
});

var IconAlignJustified = createReactComponent("outline", "align-justified", "IconAlignJustified", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M4 12l16 0", "key": "svg-1" }], ["path", { "d": "M4 18l12 0", "key": "svg-2" }]]);

var IconAlignJustified$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignJustified
});

var IconAlignLeft2 = createReactComponent("outline", "align-left-2", "IconAlignLeft2", [["path", { "d": "M4 4v16", "key": "svg-0" }], ["path", { "d": "M8 6h12", "key": "svg-1" }], ["path", { "d": "M8 12h6", "key": "svg-2" }], ["path", { "d": "M8 18h10", "key": "svg-3" }]]);

var IconAlignLeft2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignLeft2
});

var IconAlignLeft = createReactComponent("outline", "align-left", "IconAlignLeft", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M4 12l10 0", "key": "svg-1" }], ["path", { "d": "M4 18l14 0", "key": "svg-2" }]]);

var IconAlignLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignLeft
});

var IconAlignRight2 = createReactComponent("outline", "align-right-2", "IconAlignRight2", [["path", { "d": "M20 4v16", "key": "svg-0" }], ["path", { "d": "M4 6h12", "key": "svg-1" }], ["path", { "d": "M10 12h6", "key": "svg-2" }], ["path", { "d": "M6 18h10", "key": "svg-3" }]]);

var IconAlignRight2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignRight2
});

var IconAlignRight = createReactComponent("outline", "align-right", "IconAlignRight", [["path", { "d": "M4 6l16 0", "key": "svg-0" }], ["path", { "d": "M10 12l10 0", "key": "svg-1" }], ["path", { "d": "M6 18l14 0", "key": "svg-2" }]]);

var IconAlignRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlignRight
});

var IconAlpha = createReactComponent("outline", "alpha", "IconAlpha", [["path", { "d": "M18.1 6c-1.1 2.913 -1.9 4.913 -2.4 6c-1.879 4.088 -3.713 6 -6 6c-2.4 0 -4.8 -2.4 -4.8 -6s2.4 -6 4.8 -6c2.267 0 4.135 1.986 6 6c.512 1.102 1.312 3.102 2.4 6", "key": "svg-0" }]]);

var IconAlpha$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlpha
});

var IconAlphabetArabic = createReactComponent("outline", "alphabet-arabic", "IconAlphabetArabic", [["path", { "d": "M10 6v4", "key": "svg-0" }], ["path", { "d": "M13 14h8q -2.518 -3 -4 -3", "key": "svg-1" }], ["path", { "d": "M13 6v9.958c0 .963 0 1.444 -.293 1.743s-.764 .299 -1.707 .299h-1", "key": "svg-2" }], ["path", { "d": "M7 6v9.958c0 .963 0 1.444 -.293 1.743s-.764 .299 -1.707 .299h-1", "key": "svg-3" }]]);

var IconAlphabetArabic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetArabic
});

var IconAlphabetBangla = createReactComponent("outline", "alphabet-bangla", "IconAlphabetBangla", [["path", { "d": "M14 12c.904 -.027 3 2 3 7", "key": "svg-0" }], ["path", { "d": "M10 11c0 -.955 0 -2 .786 -2.677c1.262 -1.089 3.025 .55 3.2 2.06c.086 .741 -.215 3.109 -1.489 4.527c-.475 .53 -.904 .992 -1.711 1.074c-.75 .076 -1.364 -.122 -2.076 -.588c-1.138 -.743 -2.327 -1.997 -3.336 -3.73c-1.078 -1.849 -1.66 -3.113 -2.374 -5.666", "key": "svg-1" }], ["path", { "d": "M7.37 7.072c.769 -.836 5.246 -4.094 8.4 -.202c.382 .472 .573 .708 .9 1.63c.326 .921 .326 1.562 .326 2.844v7.656", "key": "svg-2" }], ["path", { "d": "M17 10c0 -1.989 1.5 -4 4 -4", "key": "svg-3" }]]);

var IconAlphabetBangla$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetBangla
});

var IconAlphabetCyrillic = createReactComponent("outline", "alphabet-cyrillic", "IconAlphabetCyrillic", [["path", { "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3", "key": "svg-0" }], ["path", { "d": "M19 7h-3a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1a2 2 0 0 0 2 -2v-3a2 2 0 0 0 -2 -2h-3", "key": "svg-1" }]]);

var IconAlphabetCyrillic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetCyrillic
});

var IconAlphabetGreek = createReactComponent("outline", "alphabet-greek", "IconAlphabetGreek", [["path", { "d": "M10 10v7", "key": "svg-0" }], ["path", { "d": "M5 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M14 20v-11a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2", "key": "svg-2" }]]);

var IconAlphabetGreek$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetGreek
});

var IconAlphabetHebrew = createReactComponent("outline", "alphabet-hebrew", "IconAlphabetHebrew", [["path", { "d": "M7 6c2.333 5.143 6.611 6.857 9.333 12", "key": "svg-0" }], ["path", { "d": "M13.667 14c2.505 -1.5 2.666 -4.141 2.666 -5.333c0 -1.778 -.443 -2.667 -.443 -2.667", "key": "svg-1" }], ["path", { "d": "M7.485 18s-.485 -.905 -.485 -2.714c0 -1.172 .164 -3.722 2.641 -5.27", "key": "svg-2" }]]);

var IconAlphabetHebrew$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetHebrew
});

var IconAlphabetKorean = createReactComponent("outline", "alphabet-korean", "IconAlphabetKorean", [["path", { "d": "M7 7h6c0 2.5 -1.593 8.474 -6 10", "key": "svg-0" }], ["path", { "d": "M16 5v14z", "key": "svg-1" }], ["path", { "d": "M16 12h2", "key": "svg-2" }]]);

var IconAlphabetKorean$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetKorean
});

var IconAlphabetLatin = createReactComponent("outline", "alphabet-latin", "IconAlphabetLatin", [["path", { "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3", "key": "svg-0" }], ["path", { "d": "M14 7v10", "key": "svg-1" }], ["path", { "d": "M14 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconAlphabetLatin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetLatin
});

var IconAlphabetThai = createReactComponent("outline", "alphabet-thai", "IconAlphabetThai", [["path", { "d": "M8 18v-3.444c0 -.49 .165 -.924 .494 -1.363c.326 -.449 1.009 -.76 1.506 -.934c.032 -.011 .035 -.079 .004 -.095c-.434 -.22 -1.294 -.52 -1.626 -1.032l-.014 -.021l-.083 -.125c-.281 -.42 -.281 -1.246 -.281 -1.246c0 -1.456 .849 -2.62 1.837 -3.199q .9 -.54 2.137 -.541q 1.077 0 1.995 .47c1.328 .647 2.031 2.202 2.031 3.976v7.554", "key": "svg-0" }]]);

var IconAlphabetThai$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlphabetThai
});

var IconAlt = createReactComponent("outline", "alt", "IconAlt", [["path", { "d": "M4 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M4 13h4", "key": "svg-1" }], ["path", { "d": "M11 8v8h4", "key": "svg-2" }], ["path", { "d": "M16 8h4", "key": "svg-3" }], ["path", { "d": "M18 8v8", "key": "svg-4" }]]);

var IconAlt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAlt
});

var IconAmbulance = createReactComponent("outline", "ambulance", "IconAmbulance", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-11a1 1 0 0 1 1 -1h9v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5", "key": "svg-2" }], ["path", { "d": "M6 10h4m-2 -2v4", "key": "svg-3" }]]);

var IconAmbulance$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAmbulance
});

var IconAmpersand = createReactComponent("outline", "ampersand", "IconAmpersand", [["path", { "d": "M19 20l-10.403 -10.972a2.948 2.948 0 0 1 0 -4.165a2.94 2.94 0 0 1 4.161 0a2.948 2.948 0 0 1 0 4.165l-4.68 4.687a3.685 3.685 0 0 0 0 5.207a3.675 3.675 0 0 0 5.2 0l5.722 -5.922", "key": "svg-0" }]]);

var IconAmpersand$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAmpersand
});

var IconAnalyzeOff = createReactComponent("outline", "analyze-off", "IconAnalyzeOff", [["path", { "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.086 8.086 0 0 0 -4.31 .62m-2.383 1.608a8.089 8.089 0 0 0 -1.326 1.69", "key": "svg-0" }], ["path", { "d": "M4 13a8.1 8.1 0 0 0 13.687 4.676", "key": "svg-1" }], ["path", { "d": "M20 16a1 1 0 0 0 -1 -1", "key": "svg-2" }], ["path", { "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9.888 9.87a3 3 0 1 0 4.233 4.252m.595 -3.397a3.012 3.012 0 0 0 -1.426 -1.435", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAnalyzeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAnalyzeOff
});

var IconAnalyze = createReactComponent("outline", "analyze", "IconAnalyze", [["path", { "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.095 8.095 0 0 0 -8.019 3.918", "key": "svg-0" }], ["path", { "d": "M4 13a8.1 8.1 0 0 0 15 3", "key": "svg-1" }], ["path", { "d": "M19 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconAnalyze$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAnalyze
});

var IconAnchorOff = createReactComponent("outline", "anchor-off", "IconAnchorOff", [["path", { "d": "M12 12v9", "key": "svg-0" }], ["path", { "d": "M4 13a8 8 0 0 0 14.138 5.13m1.44 -2.56a7.99 7.99 0 0 0 .422 -2.57", "key": "svg-1" }], ["path", { "d": "M21 13h-2", "key": "svg-2" }], ["path", { "d": "M5 13h-2", "key": "svg-3" }], ["path", { "d": "M12.866 8.873a3 3 0 1 0 -3.737 -3.747", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAnchorOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAnchorOff
});

var IconAnchor = createReactComponent("outline", "anchor", "IconAnchor", [["path", { "d": "M12 9v12m-8 -8a8 8 0 0 0 16 0m1 0h-2m-14 0h-2", "key": "svg-0" }], ["path", { "d": "M12 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconAnchor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAnchor
});

var IconAngle = createReactComponent("outline", "angle", "IconAngle", [["path", { "d": "M21 19h-18l9 -15", "key": "svg-0" }], ["path", { "d": "M20.615 15.171h.015", "key": "svg-1" }], ["path", { "d": "M19.515 11.771h.015", "key": "svg-2" }], ["path", { "d": "M17.715 8.671h.015", "key": "svg-3" }], ["path", { "d": "M15.415 5.971h.015", "key": "svg-4" }]]);

var IconAngle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAngle
});

var IconAnkh = createReactComponent("outline", "ankh", "IconAnkh", [["path", { "d": "M6 13h12", "key": "svg-0" }], ["path", { "d": "M12 21v-8l-.422 -.211a6.472 6.472 0 0 1 -3.578 -5.789a4 4 0 1 1 8 0a6.472 6.472 0 0 1 -3.578 5.789l-.422 .211", "key": "svg-1" }]]);

var IconAnkh$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAnkh
});

var IconAntennaBars1 = createReactComponent("outline", "antenna-bars-1", "IconAntennaBars1", [["path", { "d": "M6 18l0 .01", "key": "svg-0" }], ["path", { "d": "M10 18l0 .01", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBars1
});

var IconAntennaBars2 = createReactComponent("outline", "antenna-bars-2", "IconAntennaBars2", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 .01", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBars2
});

var IconAntennaBars3 = createReactComponent("outline", "antenna-bars-3", "IconAntennaBars3", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 .01", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBars3
});

var IconAntennaBars4 = createReactComponent("outline", "antenna-bars-4", "IconAntennaBars4", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 -9", "key": "svg-2" }], ["path", { "d": "M18 18l0 .01", "key": "svg-3" }]]);

var IconAntennaBars4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBars4
});

var IconAntennaBars5 = createReactComponent("outline", "antenna-bars-5", "IconAntennaBars5", [["path", { "d": "M6 18l0 -3", "key": "svg-0" }], ["path", { "d": "M10 18l0 -6", "key": "svg-1" }], ["path", { "d": "M14 18l0 -9", "key": "svg-2" }], ["path", { "d": "M18 18l0 -12", "key": "svg-3" }]]);

var IconAntennaBars5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBars5
});

var IconAntennaBarsOff = createReactComponent("outline", "antenna-bars-off", "IconAntennaBarsOff", [["path", { "d": "M6 18v-3", "key": "svg-0" }], ["path", { "d": "M10 18v-6", "key": "svg-1" }], ["path", { "d": "M14 18v-4", "key": "svg-2" }], ["path", { "d": "M14 10v-1", "key": "svg-3" }], ["path", { "d": "M18 14v-8", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAntennaBarsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaBarsOff
});

var IconAntennaOff = createReactComponent("outline", "antenna-off", "IconAntennaOff", [["path", { "d": "M20 4v8", "key": "svg-0" }], ["path", { "d": "M16 4.5v7", "key": "svg-1" }], ["path", { "d": "M12 5v3m0 4v9", "key": "svg-2" }], ["path", { "d": "M8 8v2.5", "key": "svg-3" }], ["path", { "d": "M4 6v4", "key": "svg-4" }], ["path", { "d": "M20 8h-8m-4 0h-4", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconAntennaOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntennaOff
});

var IconAntenna = createReactComponent("outline", "antenna", "IconAntenna", [["path", { "d": "M20 4v8", "key": "svg-0" }], ["path", { "d": "M16 4.5v7", "key": "svg-1" }], ["path", { "d": "M12 5v16", "key": "svg-2" }], ["path", { "d": "M8 5.5v5", "key": "svg-3" }], ["path", { "d": "M4 6v4", "key": "svg-4" }], ["path", { "d": "M20 8h-16", "key": "svg-5" }]]);

var IconAntenna$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAntenna
});

var IconApertureOff = createReactComponent("outline", "aperture-off", "IconApertureOff", [["path", { "d": "M3.6 15h10.55", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M7.395 7.534l2.416 7.438", "key": "svg-2" }], ["path", { "d": "M17.032 4.636l-4.852 3.526m-2.334 1.695l-1.349 .98", "key": "svg-3" }], ["path", { "d": "M20.559 14.51l-8.535 -6.201", "key": "svg-4" }], ["path", { "d": "M12.257 20.916l2.123 -6.533m.984 -3.028l.154 -.473", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconApertureOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApertureOff
});

var IconAperture = createReactComponent("outline", "aperture", "IconAperture", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M3.6 15h10.55", "key": "svg-1" }], ["path", { "d": "M6.551 4.938l3.26 10.034", "key": "svg-2" }], ["path", { "d": "M17.032 4.636l-8.535 6.201", "key": "svg-3" }], ["path", { "d": "M20.559 14.51l-8.535 -6.201", "key": "svg-4" }], ["path", { "d": "M12.257 20.916l3.261 -10.034", "key": "svg-5" }]]);

var IconAperture$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAperture
});

var IconApiAppOff = createReactComponent("outline", "api-app-off", "IconApiAppOff", [["path", { "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5", "key": "svg-0" }], ["path", { "d": "M15 15v3.5a2.5 2.5 0 1 1 -5 0v-.5", "key": "svg-1" }], ["path", { "d": "M13 9h5.5a2.5 2.5 0 1 1 0 5h-.5", "key": "svg-2" }], ["path", { "d": "M9 12v-3m.042 -3.957a2.5 2.5 0 0 1 4.958 .457v.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconApiAppOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApiAppOff
});

var IconApiApp = createReactComponent("outline", "api-app", "IconApiApp", [["path", { "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5", "key": "svg-0" }], ["path", { "d": "M15 12v6.5a2.5 2.5 0 1 1 -5 0v-.5", "key": "svg-1" }], ["path", { "d": "M12 9h6.5a2.5 2.5 0 1 1 0 5h-.5", "key": "svg-2" }], ["path", { "d": "M9 12v-6.5a2.5 2.5 0 0 1 5 0v.5", "key": "svg-3" }]]);

var IconApiApp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApiApp
});

var IconApiOff = createReactComponent("outline", "api-off", "IconApiOff", [["path", { "d": "M4 13h5", "key": "svg-0" }], ["path", { "d": "M12 16v-4m0 -4h3a2 2 0 0 1 2 2v1c0 .554 -.225 1.055 -.589 1.417m-3.411 .583h-1", "key": "svg-1" }], ["path", { "d": "M20 8v8", "key": "svg-2" }], ["path", { "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconApiOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApiOff
});

var IconApi = createReactComponent("outline", "api", "IconApi", [["path", { "d": "M4 13h5", "key": "svg-0" }], ["path", { "d": "M12 16v-8h3a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-3", "key": "svg-1" }], ["path", { "d": "M20 8v8", "key": "svg-2" }], ["path", { "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5", "key": "svg-3" }]]);

var IconApi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApi
});

var IconAppWindow = createReactComponent("outline", "app-window", "IconAppWindow", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 8h.01", "key": "svg-1" }], ["path", { "d": "M9 8h.01", "key": "svg-2" }]]);

var IconAppWindow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAppWindow
});

var IconApple = createReactComponent("outline", "apple", "IconApple", [["path", { "d": "M4 11.319c0 3.102 .444 5.319 2.222 7.978c1.351 1.797 3.156 2.247 5.08 .988c.426 -.268 .97 -.268 1.397 0c1.923 1.26 3.728 .809 5.079 -.988c1.778 -2.66 2.222 -4.876 2.222 -7.977c0 -2.661 -1.99 -5.32 -4.444 -5.32c-1.267 0 -2.41 .693 -3.22 1.44a.5 .5 0 0 1 -.672 0c-.809 -.746 -1.953 -1.44 -3.22 -1.44c-2.454 0 -4.444 2.66 -4.444 5.319", "key": "svg-0" }], ["path", { "d": "M7 12c0 -1.47 .454 -2.34 1.5 -3", "key": "svg-1" }], ["path", { "d": "M12 7c0 -1.2 .867 -4 3 -4", "key": "svg-2" }]]);

var IconApple$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApple
});

var IconAppsOff = createReactComponent("outline", "apps-off", "IconAppsOff", [["path", { "d": "M8 4h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706", "key": "svg-0" }], ["path", { "d": "M18 14h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706", "key": "svg-1" }], ["path", { "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M14 7h6", "key": "svg-3" }], ["path", { "d": "M17 4v6", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconAppsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAppsOff
});

var IconApps = createReactComponent("outline", "apps", "IconApps", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M14 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M14 7l6 0", "key": "svg-3" }], ["path", { "d": "M17 4l0 6", "key": "svg-4" }]]);

var IconApps$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconApps
});

var IconArcheryArrow = createReactComponent("outline", "archery-arrow", "IconArcheryArrow", [["path", { "d": "M14 7v3h3l3 -3h-3v-3z", "key": "svg-0" }], ["path", { "d": "M14 10l-9 9", "key": "svg-1" }], ["path", { "d": "M5 15v4h4", "key": "svg-2" }]]);

var IconArcheryArrow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArcheryArrow
});

var IconArchiveOff = createReactComponent("outline", "archive-off", "IconArchiveOff", [["path", { "d": "M8 4h11a2 2 0 1 1 0 4h-7m-4 0h-3a2 2 0 0 1 -.826 -3.822", "key": "svg-0" }], ["path", { "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 1.824 -1.18m.176 -3.82v-7", "key": "svg-1" }], ["path", { "d": "M10 12h2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconArchiveOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArchiveOff
});

var IconArchive = createReactComponent("outline", "archive", "IconArchive", [["path", { "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10", "key": "svg-1" }], ["path", { "d": "M10 12l4 0", "key": "svg-2" }]]);

var IconArchive$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArchive
});

var IconArmchair2Off = createReactComponent("outline", "armchair-2-off", "IconArmchair2Off", [["path", { "d": "M5 10v-4a3 3 0 0 1 .128 -.869m2.038 -2.013c.264 -.078 .544 -.118 .834 -.118h8a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M16.124 12.145a3 3 0 1 1 3.756 3.724m-.88 3.131h-14v-3a3 3 0 1 1 3 -3v2", "key": "svg-1" }], ["path", { "d": "M8 12h4", "key": "svg-2" }], ["path", { "d": "M7 19v2", "key": "svg-3" }], ["path", { "d": "M17 19v2", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconArmchair2Off$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArmchair2Off
});

var IconArmchair2 = createReactComponent("outline", "armchair-2", "IconArmchair2", [["path", { "d": "M5 10v-4a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v4", "key": "svg-0" }], ["path", { "d": "M16 15v-2a3 3 0 1 1 3 3v3h-14v-3a3 3 0 1 1 3 -3v2", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M7 19v2", "key": "svg-3" }], ["path", { "d": "M17 19v2", "key": "svg-4" }]]);

var IconArmchair2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArmchair2
});

var IconArmchairOff = createReactComponent("outline", "armchair-off", "IconArmchairOff", [["path", { "d": "M17 13a2 2 0 1 1 4 0v4m-2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 1 1 4 0v2h8.036", "key": "svg-0" }], ["path", { "d": "M5 11v-5a3 3 0 0 1 .134 -.89m1.987 -1.98a3 3 0 0 1 .879 -.13h8a3 3 0 0 1 3 3v5", "key": "svg-1" }], ["path", { "d": "M6 19v2", "key": "svg-2" }], ["path", { "d": "M18 19v2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconArmchairOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArmchairOff
});

var IconArmchair = createReactComponent("outline", "armchair", "IconArmchair", [["path", { "d": "M5 11a2 2 0 0 1 2 2v2h10v-2a2 2 0 1 1 4 0v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M5 11v-5a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v5", "key": "svg-1" }], ["path", { "d": "M6 19v2", "key": "svg-2" }], ["path", { "d": "M18 19v2", "key": "svg-3" }]]);

var IconArmchair$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArmchair
});

var IconArrowAutofitContent = createReactComponent("outline", "arrow-autofit-content", "IconArrowAutofitContent", [["path", { "d": "M6 4l-3 3l3 3", "key": "svg-0" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M4 14m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-2" }], ["path", { "d": "M10 7h-7", "key": "svg-3" }], ["path", { "d": "M21 7h-7", "key": "svg-4" }]]);

var IconArrowAutofitContent$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitContent
});

var IconArrowAutofitDown = createReactComponent("outline", "arrow-autofit-down", "IconArrowAutofitDown", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8", "key": "svg-0" }], ["path", { "d": "M18 4v17", "key": "svg-1" }], ["path", { "d": "M15 18l3 3l3 -3", "key": "svg-2" }]]);

var IconArrowAutofitDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitDown
});

var IconArrowAutofitHeight = createReactComponent("outline", "arrow-autofit-height", "IconArrowAutofitHeight", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6", "key": "svg-0" }], ["path", { "d": "M18 14v7", "key": "svg-1" }], ["path", { "d": "M18 3v7", "key": "svg-2" }], ["path", { "d": "M15 18l3 3l3 -3", "key": "svg-3" }], ["path", { "d": "M15 6l3 -3l3 3", "key": "svg-4" }]]);

var IconArrowAutofitHeight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitHeight
});

var IconArrowAutofitLeft = createReactComponent("outline", "arrow-autofit-left", "IconArrowAutofitLeft", [["path", { "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M20 18h-17", "key": "svg-1" }], ["path", { "d": "M6 15l-3 3l3 3", "key": "svg-2" }]]);

var IconArrowAutofitLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitLeft
});

var IconArrowAutofitRight = createReactComponent("outline", "arrow-autofit-right", "IconArrowAutofitRight", [["path", { "d": "M20 12v-6a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2v8", "key": "svg-0" }], ["path", { "d": "M4 18h17", "key": "svg-1" }], ["path", { "d": "M18 15l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowAutofitRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitRight
});

var IconArrowAutofitUp = createReactComponent("outline", "arrow-autofit-up", "IconArrowAutofitUp", [["path", { "d": "M12 4h-6a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h8", "key": "svg-0" }], ["path", { "d": "M18 20v-17", "key": "svg-1" }], ["path", { "d": "M15 6l3 -3l3 3", "key": "svg-2" }]]);

var IconArrowAutofitUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitUp
});

var IconArrowAutofitWidth = createReactComponent("outline", "arrow-autofit-width", "IconArrowAutofitWidth", [["path", { "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M10 18h-7", "key": "svg-1" }], ["path", { "d": "M21 18h-7", "key": "svg-2" }], ["path", { "d": "M6 15l-3 3l3 3", "key": "svg-3" }], ["path", { "d": "M18 15l3 3l-3 3", "key": "svg-4" }]]);

var IconArrowAutofitWidth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowAutofitWidth
});

var IconArrowBackUpDouble = createReactComponent("outline", "arrow-back-up-double", "IconArrowBackUpDouble", [["path", { "d": "M13 14l-4 -4l4 -4", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M9 10h7a4 4 0 1 1 0 8h-1", "key": "svg-2" }]]);

var IconArrowBackUpDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBackUpDouble
});

var IconArrowBackUp = createReactComponent("outline", "arrow-back-up", "IconArrowBackUp", [["path", { "d": "M9 14l-4 -4l4 -4", "key": "svg-0" }], ["path", { "d": "M5 10h11a4 4 0 1 1 0 8h-1", "key": "svg-1" }]]);

var IconArrowBackUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBackUp
});

var IconArrowBack = createReactComponent("outline", "arrow-back", "IconArrowBack", [["path", { "d": "M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1", "key": "svg-0" }]]);

var IconArrowBack$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBack
});

var IconArrowBadgeDown = createReactComponent("outline", "arrow-badge-down", "IconArrowBadgeDown", [["path", { "d": "M17 13v-6l-5 4l-5 -4v6l5 4z", "key": "svg-0" }]]);

var IconArrowBadgeDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBadgeDown
});

var IconArrowBadgeLeft = createReactComponent("outline", "arrow-badge-left", "IconArrowBadgeLeft", [["path", { "d": "M11 17h6l-4 -5l4 -5h-6l-4 5z", "key": "svg-0" }]]);

var IconArrowBadgeLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBadgeLeft
});

var IconArrowBadgeRight = createReactComponent("outline", "arrow-badge-right", "IconArrowBadgeRight", [["path", { "d": "M13 7h-6l4 5l-4 5h6l4 -5z", "key": "svg-0" }]]);

var IconArrowBadgeRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBadgeRight
});

var IconArrowBadgeUp = createReactComponent("outline", "arrow-badge-up", "IconArrowBadgeUp", [["path", { "d": "M17 11v6l-5 -4l-5 4v-6l5 -4z", "key": "svg-0" }]]);

var IconArrowBadgeUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBadgeUp
});

var IconArrowBarBoth = createReactComponent("outline", "arrow-bar-both", "IconArrowBarBoth", [["path", { "d": "M8 12h-6", "key": "svg-0" }], ["path", { "d": "M5 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M22 12h-6", "key": "svg-2" }], ["path", { "d": "M19 15l3 -3l-3 -3", "key": "svg-3" }], ["path", { "d": "M12 4v16", "key": "svg-4" }]]);

var IconArrowBarBoth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarBoth
});

var IconArrowBarDown = createReactComponent("outline", "arrow-bar-down", "IconArrowBarDown", [["path", { "d": "M12 20l0 -10", "key": "svg-0" }], ["path", { "d": "M12 20l4 -4", "key": "svg-1" }], ["path", { "d": "M12 20l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l16 0", "key": "svg-3" }]]);

var IconArrowBarDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarDown
});

var IconArrowBarLeft = createReactComponent("outline", "arrow-bar-left", "IconArrowBarLeft", [["path", { "d": "M4 12l10 0", "key": "svg-0" }], ["path", { "d": "M4 12l4 4", "key": "svg-1" }], ["path", { "d": "M4 12l4 -4", "key": "svg-2" }], ["path", { "d": "M20 4l0 16", "key": "svg-3" }]]);

var IconArrowBarLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarLeft
});

var IconArrowBarRight = createReactComponent("outline", "arrow-bar-right", "IconArrowBarRight", [["path", { "d": "M20 12l-10 0", "key": "svg-0" }], ["path", { "d": "M20 12l-4 4", "key": "svg-1" }], ["path", { "d": "M20 12l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l0 16", "key": "svg-3" }]]);

var IconArrowBarRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarRight
});

var IconArrowBarToDown = createReactComponent("outline", "arrow-bar-to-down", "IconArrowBarToDown", [["path", { "d": "M4 20l16 0", "key": "svg-0" }], ["path", { "d": "M12 14l0 -10", "key": "svg-1" }], ["path", { "d": "M12 14l4 -4", "key": "svg-2" }], ["path", { "d": "M12 14l-4 -4", "key": "svg-3" }]]);

var IconArrowBarToDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarToDown
});

var IconArrowBarToLeft = createReactComponent("outline", "arrow-bar-to-left", "IconArrowBarToLeft", [["path", { "d": "M10 12l10 0", "key": "svg-0" }], ["path", { "d": "M10 12l4 4", "key": "svg-1" }], ["path", { "d": "M10 12l4 -4", "key": "svg-2" }], ["path", { "d": "M4 4l0 16", "key": "svg-3" }]]);

var IconArrowBarToLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarToLeft
});

var IconArrowBarToRight = createReactComponent("outline", "arrow-bar-to-right", "IconArrowBarToRight", [["path", { "d": "M14 12l-10 0", "key": "svg-0" }], ["path", { "d": "M14 12l-4 4", "key": "svg-1" }], ["path", { "d": "M14 12l-4 -4", "key": "svg-2" }], ["path", { "d": "M20 4l0 16", "key": "svg-3" }]]);

var IconArrowBarToRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarToRight
});

var IconArrowBarToUp = createReactComponent("outline", "arrow-bar-to-up", "IconArrowBarToUp", [["path", { "d": "M12 10l0 10", "key": "svg-0" }], ["path", { "d": "M12 10l4 4", "key": "svg-1" }], ["path", { "d": "M12 10l-4 4", "key": "svg-2" }], ["path", { "d": "M4 4l16 0", "key": "svg-3" }]]);

var IconArrowBarToUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarToUp
});

var IconArrowBarUp = createReactComponent("outline", "arrow-bar-up", "IconArrowBarUp", [["path", { "d": "M12 4l0 10", "key": "svg-0" }], ["path", { "d": "M12 4l4 4", "key": "svg-1" }], ["path", { "d": "M12 4l-4 4", "key": "svg-2" }], ["path", { "d": "M4 20l16 0", "key": "svg-3" }]]);

var IconArrowBarUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBarUp
});

var IconArrowBearLeft2 = createReactComponent("outline", "arrow-bear-left-2", "IconArrowBearLeft2", [["path", { "d": "M9 3h-5v5", "key": "svg-0" }], ["path", { "d": "M4 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93", "key": "svg-1" }], ["path", { "d": "M20 5l-4.5 4.5", "key": "svg-2" }]]);

var IconArrowBearLeft2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBearLeft2
});

var IconArrowBearLeft = createReactComponent("outline", "arrow-bear-left", "IconArrowBearLeft", [["path", { "d": "M13 3h-5v5", "key": "svg-0" }], ["path", { "d": "M8 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93", "key": "svg-1" }]]);

var IconArrowBearLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBearLeft
});

var IconArrowBearRight2 = createReactComponent("outline", "arrow-bear-right-2", "IconArrowBearRight2", [["path", { "d": "M15 3h5v5", "key": "svg-0" }], ["path", { "d": "M20 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-1" }], ["path", { "d": "M4 5l4.5 4.5", "key": "svg-2" }]]);

var IconArrowBearRight2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBearRight2
});

var IconArrowBearRight = createReactComponent("outline", "arrow-bear-right", "IconArrowBearRight", [["path", { "d": "M12 3h5v5", "key": "svg-0" }], ["path", { "d": "M17 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-1" }]]);

var IconArrowBearRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBearRight
});

var IconArrowBigDownLine = createReactComponent("outline", "arrow-big-down-line", "IconArrowBigDownLine", [["path", { "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-6h6v6z", "key": "svg-0" }], ["path", { "d": "M15 3h-6", "key": "svg-1" }]]);

var IconArrowBigDownLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigDownLine
});

var IconArrowBigDownLines = createReactComponent("outline", "arrow-big-down-lines", "IconArrowBigDownLines", [["path", { "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-3h6v3z", "key": "svg-0" }], ["path", { "d": "M15 3h-6", "key": "svg-1" }], ["path", { "d": "M15 6h-6", "key": "svg-2" }]]);

var IconArrowBigDownLines$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigDownLines
});

var IconArrowBigDown = createReactComponent("outline", "arrow-big-down", "IconArrowBigDown", [["path", { "d": "M15 4v8h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-8a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1z", "key": "svg-0" }]]);

var IconArrowBigDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigDown
});

var IconArrowBigLeftLine = createReactComponent("outline", "arrow-big-left-line", "IconArrowBigLeftLine", [["path", { "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M21 15v-6", "key": "svg-1" }]]);

var IconArrowBigLeftLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigLeftLine
});

var IconArrowBigLeftLines = createReactComponent("outline", "arrow-big-left-lines", "IconArrowBigLeftLines", [["path", { "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h3v6h-3z", "key": "svg-0" }], ["path", { "d": "M21 15v-6", "key": "svg-1" }], ["path", { "d": "M18 15v-6", "key": "svg-2" }]]);

var IconArrowBigLeftLines$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigLeftLines
});

var IconArrowBigLeft = createReactComponent("outline", "arrow-big-left", "IconArrowBigLeft", [["path", { "d": "M20 15h-8v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h8a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1z", "key": "svg-0" }]]);

var IconArrowBigLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigLeft
});

var IconArrowBigRightLine = createReactComponent("outline", "arrow-big-right-line", "IconArrowBigRightLine", [["path", { "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-6v-6h6z", "key": "svg-0" }], ["path", { "d": "M3 9v6", "key": "svg-1" }]]);

var IconArrowBigRightLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigRightLine
});

var IconArrowBigRightLines = createReactComponent("outline", "arrow-big-right-lines", "IconArrowBigRightLines", [["path", { "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-3v-6h3z", "key": "svg-0" }], ["path", { "d": "M3 9v6", "key": "svg-1" }], ["path", { "d": "M6 9v6", "key": "svg-2" }]]);

var IconArrowBigRightLines$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigRightLines
});

var IconArrowBigRight = createReactComponent("outline", "arrow-big-right", "IconArrowBigRight", [["path", { "d": "M4 9h8v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-8a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1z", "key": "svg-0" }]]);

var IconArrowBigRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigRight
});

var IconArrowBigUpLine = createReactComponent("outline", "arrow-big-up-line", "IconArrowBigUpLine", [["path", { "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v6h-6v-6z", "key": "svg-0" }], ["path", { "d": "M9 21h6", "key": "svg-1" }]]);

var IconArrowBigUpLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigUpLine
});

var IconArrowBigUpLines = createReactComponent("outline", "arrow-big-up-lines", "IconArrowBigUpLines", [["path", { "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v3h-6v-3z", "key": "svg-0" }], ["path", { "d": "M9 21h6", "key": "svg-1" }], ["path", { "d": "M9 18h6", "key": "svg-2" }]]);

var IconArrowBigUpLines$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigUpLines
});

var IconArrowBigUp = createReactComponent("outline", "arrow-big-up", "IconArrowBigUp", [["path", { "d": "M9 20v-8h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v8a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }]]);

var IconArrowBigUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBigUp
});

var IconArrowBounce = createReactComponent("outline", "arrow-bounce", "IconArrowBounce", [["path", { "d": "M10 18h4", "key": "svg-0" }], ["path", { "d": "M3 8a9 9 0 0 1 9 9v1l1.428 -4.285a12 12 0 0 1 6.018 -6.938l.554 -.277", "key": "svg-1" }], ["path", { "d": "M15 6h5v5", "key": "svg-2" }]]);

var IconArrowBounce$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowBounce
});

var IconArrowCapsule = createReactComponent("outline", "arrow-capsule", "IconArrowCapsule", [["path", { "d": "M18 15a6 6 0 1 1 -12 0v-6a6 6 0 1 1 12 0v2", "key": "svg-0" }], ["path", { "d": "M15 8l3 3l3 -3", "key": "svg-1" }]]);

var IconArrowCapsule$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowCapsule
});

var IconArrowCurveLeft = createReactComponent("outline", "arrow-curve-left", "IconArrowCurveLeft", [["path", { "d": "M14 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M10 3v4.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v2.394", "key": "svg-1" }]]);

var IconArrowCurveLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowCurveLeft
});

var IconArrowCurveRight = createReactComponent("outline", "arrow-curve-right", "IconArrowCurveRight", [["path", { "d": "M10 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M14 3v4.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v2.394", "key": "svg-1" }]]);

var IconArrowCurveRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowCurveRight
});

var IconArrowDownBar = createReactComponent("outline", "arrow-down-bar", "IconArrowDownBar", [["path", { "d": "M12 3v18", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M9 3h6", "key": "svg-2" }]]);

var IconArrowDownBar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownBar
});

var IconArrowDownCircle = createReactComponent("outline", "arrow-down-circle", "IconArrowDownCircle", [["path", { "d": "M12 7v14", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M12 7a2 2 0 1 0 0 -4a2 2 0 0 0 0 4", "key": "svg-2" }]]);

var IconArrowDownCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownCircle
});

var IconArrowDownDashed = createReactComponent("outline", "arrow-down-dashed", "IconArrowDownDashed", [["path", { "d": "M12 5v.5m0 3v1.5m0 3v6", "key": "svg-0" }], ["path", { "d": "M18 13l-6 6", "key": "svg-1" }], ["path", { "d": "M6 13l6 6", "key": "svg-2" }]]);

var IconArrowDownDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownDashed
});

var IconArrowDownFromArc = createReactComponent("outline", "arrow-down-from-arc", "IconArrowDownFromArc", [["path", { "d": "M12 15v-12", "key": "svg-0" }], ["path", { "d": "M16 7l-4 -4l-4 4", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 0 0 18 0", "key": "svg-2" }]]);

var IconArrowDownFromArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownFromArc
});

var IconArrowDownLeftCircle = createReactComponent("outline", "arrow-down-left-circle", "IconArrowDownLeftCircle", [["path", { "d": "M15.536 8.464l-9.536 9.536", "key": "svg-0" }], ["path", { "d": "M6 14v4h4", "key": "svg-1" }], ["path", { "d": "M15.586 8.414a2 2 0 1 0 2.828 -2.828a2 2 0 0 0 -2.828 2.828", "key": "svg-2" }]]);

var IconArrowDownLeftCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownLeftCircle
});

var IconArrowDownLeft = createReactComponent("outline", "arrow-down-left", "IconArrowDownLeft", [["path", { "d": "M17 7l-10 10", "key": "svg-0" }], ["path", { "d": "M16 17l-9 0l0 -9", "key": "svg-1" }]]);

var IconArrowDownLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownLeft
});

var IconArrowDownRhombus = createReactComponent("outline", "arrow-down-rhombus", "IconArrowDownRhombus", [["path", { "d": "M12 8v13", "key": "svg-0" }], ["path", { "d": "M15 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M14.5 5.5l-2.5 -2.5l-2.5 2.5l2.5 2.5z", "key": "svg-2" }]]);

var IconArrowDownRhombus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownRhombus
});

var IconArrowDownRightCircle = createReactComponent("outline", "arrow-down-right-circle", "IconArrowDownRightCircle", [["path", { "d": "M8.464 8.464l9.536 9.536", "key": "svg-0" }], ["path", { "d": "M14 18h4v-4", "key": "svg-1" }], ["path", { "d": "M8.414 8.414a2 2 0 1 0 -2.828 -2.828a2 2 0 0 0 2.828 2.828", "key": "svg-2" }]]);

var IconArrowDownRightCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownRightCircle
});

var IconArrowDownRight = createReactComponent("outline", "arrow-down-right", "IconArrowDownRight", [["path", { "d": "M7 7l10 10", "key": "svg-0" }], ["path", { "d": "M17 8l0 9l-9 0", "key": "svg-1" }]]);

var IconArrowDownRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownRight
});

var IconArrowDownSquare = createReactComponent("outline", "arrow-down-square", "IconArrowDownSquare", [["path", { "d": "M12 7v14", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M14 3v4h-4v-4z", "key": "svg-2" }]]);

var IconArrowDownSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownSquare
});

var IconArrowDownTail = createReactComponent("outline", "arrow-down-tail", "IconArrowDownTail", [["path", { "d": "M12 6v15", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M9 3l3 3l3 -3", "key": "svg-2" }]]);

var IconArrowDownTail$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownTail
});

var IconArrowDownToArc = createReactComponent("outline", "arrow-down-to-arc", "IconArrowDownToArc", [["path", { "d": "M12 3v12", "key": "svg-0" }], ["path", { "d": "M16 11l-4 4l-4 -4", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 0 0 18 0", "key": "svg-2" }]]);

var IconArrowDownToArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDownToArc
});

var IconArrowDown = createReactComponent("outline", "arrow-down", "IconArrowDown", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 13l-6 6", "key": "svg-1" }], ["path", { "d": "M6 13l6 6", "key": "svg-2" }]]);

var IconArrowDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowDown
});

var IconArrowElbowLeft = createReactComponent("outline", "arrow-elbow-left", "IconArrowElbowLeft", [["path", { "d": "M3 14v-6h6", "key": "svg-0" }], ["path", { "d": "M3 8l9 9l9 -9", "key": "svg-1" }]]);

var IconArrowElbowLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowElbowLeft
});

var IconArrowElbowRight = createReactComponent("outline", "arrow-elbow-right", "IconArrowElbowRight", [["path", { "d": "M21 14v-6h-6", "key": "svg-0" }], ["path", { "d": "M21 8l-9 9l-9 -9", "key": "svg-1" }]]);

var IconArrowElbowRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowElbowRight
});

var IconArrowFork = createReactComponent("outline", "arrow-fork", "IconArrowFork", [["path", { "d": "M16 3h5v5", "key": "svg-0" }], ["path", { "d": "M8 3h-5v5", "key": "svg-1" }], ["path", { "d": "M21 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93", "key": "svg-2" }], ["path", { "d": "M3 3l7.536 7.536a5 5 0 0 1 1.464 3.534v.93", "key": "svg-3" }]]);

var IconArrowFork$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowFork
});

var IconArrowForwardUpDouble = createReactComponent("outline", "arrow-forward-up-double", "IconArrowForwardUpDouble", [["path", { "d": "M11 14l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M16 14l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M15 10h-7a4 4 0 1 0 0 8h1", "key": "svg-2" }]]);

var IconArrowForwardUpDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowForwardUpDouble
});

var IconArrowForwardUp = createReactComponent("outline", "arrow-forward-up", "IconArrowForwardUp", [["path", { "d": "M15 14l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M19 10h-11a4 4 0 1 0 0 8h1", "key": "svg-1" }]]);

var IconArrowForwardUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowForwardUp
});

var IconArrowForward = createReactComponent("outline", "arrow-forward", "IconArrowForward", [["path", { "d": "M15 11l4 4l-4 4m4 -4h-11a4 4 0 0 1 0 -8h1", "key": "svg-0" }]]);

var IconArrowForward$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowForward
});

var IconArrowGuide = createReactComponent("outline", "arrow-guide", "IconArrowGuide", [["path", { "d": "M5 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M7 19h3a2 2 0 0 0 2 -2v-8a2 2 0 0 1 2 -2h7", "key": "svg-1" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowGuide$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowGuide
});

var IconArrowIteration = createReactComponent("outline", "arrow-iteration", "IconArrowIteration", [["path", { "d": "M8.5 16a5.5 5.5 0 1 0 -5.5 -5.5v.5", "key": "svg-0" }], ["path", { "d": "M3 16h18", "key": "svg-1" }], ["path", { "d": "M18 13l3 3l-3 3", "key": "svg-2" }]]);

var IconArrowIteration$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowIteration
});

var IconArrowLeftBar = createReactComponent("outline", "arrow-left-bar", "IconArrowLeftBar", [["path", { "d": "M21 12h-18", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 9v6", "key": "svg-2" }]]);

var IconArrowLeftBar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftBar
});

var IconArrowLeftCircle = createReactComponent("outline", "arrow-left-circle", "IconArrowLeftCircle", [["path", { "d": "M17 12h-14", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M19 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconArrowLeftCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftCircle
});

var IconArrowLeftDashed = createReactComponent("outline", "arrow-left-dashed", "IconArrowLeftDashed", [["path", { "d": "M5 12h6m3 0h1.5m3 0h.5", "key": "svg-0" }], ["path", { "d": "M5 12l6 6", "key": "svg-1" }], ["path", { "d": "M5 12l6 -6", "key": "svg-2" }]]);

var IconArrowLeftDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftDashed
});

var IconArrowLeftFromArc = createReactComponent("outline", "arrow-left-from-arc", "IconArrowLeftFromArc", [["path", { "d": "M9 12h12", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18", "key": "svg-2" }]]);

var IconArrowLeftFromArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftFromArc
});

var IconArrowLeftRhombus = createReactComponent("outline", "arrow-left-rhombus", "IconArrowLeftRhombus", [["path", { "d": "M16 12h-13", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M18.5 9.5l2.5 2.5l-2.5 2.5l-2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowLeftRhombus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftRhombus
});

var IconArrowLeftRight = createReactComponent("outline", "arrow-left-right", "IconArrowLeftRight", [["path", { "d": "M17 13l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M7 13l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 14a5 5 0 0 1 5 -5h4", "key": "svg-2" }], ["path", { "d": "M12 19v-5a5 5 0 0 0 -5 -5h-4", "key": "svg-3" }]]);

var IconArrowLeftRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftRight
});

var IconArrowLeftSquare = createReactComponent("outline", "arrow-left-square", "IconArrowLeftSquare", [["path", { "d": "M17 12h-14", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 14h-4v-4h4z", "key": "svg-2" }]]);

var IconArrowLeftSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftSquare
});

var IconArrowLeftTail = createReactComponent("outline", "arrow-left-tail", "IconArrowLeftTail", [["path", { "d": "M18 12h-15", "key": "svg-0" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-1" }], ["path", { "d": "M21 9l-3 3l3 3", "key": "svg-2" }]]);

var IconArrowLeftTail$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftTail
});

var IconArrowLeftToArc = createReactComponent("outline", "arrow-left-to-arc", "IconArrowLeftToArc", [["path", { "d": "M21 12h-12", "key": "svg-0" }], ["path", { "d": "M13 16l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18", "key": "svg-2" }]]);

var IconArrowLeftToArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeftToArc
});

var IconArrowLeft = createReactComponent("outline", "arrow-left", "IconArrowLeft", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M5 12l6 6", "key": "svg-1" }], ["path", { "d": "M5 12l6 -6", "key": "svg-2" }]]);

var IconArrowLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLeft
});

var IconArrowLoopLeft2 = createReactComponent("outline", "arrow-loop-left-2", "IconArrowLoopLeft2", [["path", { "d": "M13 21v-6m0 -6v-1a4 4 0 1 1 4 4h-13", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }]]);

var IconArrowLoopLeft2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLoopLeft2
});

var IconArrowLoopLeft = createReactComponent("outline", "arrow-loop-left", "IconArrowLoopLeft", [["path", { "d": "M13 21v-13a4 4 0 1 1 4 4h-13", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }]]);

var IconArrowLoopLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLoopLeft
});

var IconArrowLoopRight2 = createReactComponent("outline", "arrow-loop-right-2", "IconArrowLoopRight2", [["path", { "d": "M12 21v-6m0 -6v-1a4 4 0 1 0 -4 4h13", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }]]);

var IconArrowLoopRight2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLoopRight2
});

var IconArrowLoopRight = createReactComponent("outline", "arrow-loop-right", "IconArrowLoopRight", [["path", { "d": "M12 21v-13a4 4 0 1 0 -4 4h13", "key": "svg-0" }], ["path", { "d": "M17 16l4 -4l-4 -4", "key": "svg-1" }]]);

var IconArrowLoopRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowLoopRight
});

var IconArrowMergeAltLeft = createReactComponent("outline", "arrow-merge-alt-left", "IconArrowMergeAltLeft", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M18 21v.01", "key": "svg-1" }], ["path", { "d": "M18 18.01v.01", "key": "svg-2" }], ["path", { "d": "M17 15.02v.01", "key": "svg-3" }], ["path", { "d": "M14 13.03v.01", "key": "svg-4" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394", "key": "svg-5" }]]);

var IconArrowMergeAltLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMergeAltLeft
});

var IconArrowMergeAltRight = createReactComponent("outline", "arrow-merge-alt-right", "IconArrowMergeAltRight", [["path", { "d": "M16 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M6 21v.01", "key": "svg-1" }], ["path", { "d": "M6 18.01v.01", "key": "svg-2" }], ["path", { "d": "M7 15.02v.01", "key": "svg-3" }], ["path", { "d": "M10 13.03v.01", "key": "svg-4" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394", "key": "svg-5" }]]);

var IconArrowMergeAltRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMergeAltRight
});

var IconArrowMergeBoth = createReactComponent("outline", "arrow-merge-both", "IconArrowMergeBoth", [["path", { "d": "M16 8l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10", "key": "svg-2" }], ["path", { "d": "M6 18c4 -1.333 6 -4.667 6 -10", "key": "svg-3" }]]);

var IconArrowMergeBoth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMergeBoth
});

var IconArrowMergeLeft = createReactComponent("outline", "arrow-merge-left", "IconArrowMergeLeft", [["path", { "d": "M8 8l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M6 18c4 -1.333 6 -4.667 6 -10", "key": "svg-2" }]]);

var IconArrowMergeLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMergeLeft
});

var IconArrowMergeRight = createReactComponent("outline", "arrow-merge-right", "IconArrowMergeRight", [["path", { "d": "M16 8l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }], ["path", { "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10", "key": "svg-2" }]]);

var IconArrowMergeRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMergeRight
});

var IconArrowMerge = createReactComponent("outline", "arrow-merge", "IconArrowMerge", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394", "key": "svg-1" }], ["path", { "d": "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394", "key": "svg-2" }]]);

var IconArrowMerge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMerge
});

var IconArrowMoveDown = createReactComponent("outline", "arrow-move-down", "IconArrowMoveDown", [["path", { "d": "M12 11v10", "key": "svg-0" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-1" }], ["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconArrowMoveDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMoveDown
});

var IconArrowMoveLeft = createReactComponent("outline", "arrow-move-left", "IconArrowMoveLeft", [["path", { "d": "M13 12h-10", "key": "svg-0" }], ["path", { "d": "M6 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M17 12a2 2 0 1 1 4 0a2 2 0 0 1 -4 0z", "key": "svg-2" }]]);

var IconArrowMoveLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMoveLeft
});

var IconArrowMoveRight = createReactComponent("outline", "arrow-move-right", "IconArrowMoveRight", [["path", { "d": "M11 12h10", "key": "svg-0" }], ["path", { "d": "M18 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M7 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0z", "key": "svg-2" }]]);

var IconArrowMoveRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMoveRight
});

var IconArrowMoveUp = createReactComponent("outline", "arrow-move-up", "IconArrowMoveUp", [["path", { "d": "M12 13v-10", "key": "svg-0" }], ["path", { "d": "M9 6l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 17a2 2 0 1 1 0 4a2 2 0 0 1 0 -4z", "key": "svg-2" }]]);

var IconArrowMoveUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowMoveUp
});

var IconArrowNarrowDownDashed = createReactComponent("outline", "arrow-narrow-down-dashed", "IconArrowNarrowDownDashed", [["path", { "d": "M12 5v.5m0 3v1.5m0 3v6", "key": "svg-0" }], ["path", { "d": "M16 15l-4 4", "key": "svg-1" }], ["path", { "d": "M8 15l4 4", "key": "svg-2" }]]);

var IconArrowNarrowDownDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowDownDashed
});

var IconArrowNarrowDown = createReactComponent("outline", "arrow-narrow-down", "IconArrowNarrowDown", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M16 15l-4 4", "key": "svg-1" }], ["path", { "d": "M8 15l4 4", "key": "svg-2" }]]);

var IconArrowNarrowDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowDown
});

var IconArrowNarrowLeftDashed = createReactComponent("outline", "arrow-narrow-left-dashed", "IconArrowNarrowLeftDashed", [["path", { "d": "M5 12h6m3 0h1.5m3 0h.5", "key": "svg-0" }], ["path", { "d": "M5 12l4 4", "key": "svg-1" }], ["path", { "d": "M5 12l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowLeftDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowLeftDashed
});

var IconArrowNarrowLeft = createReactComponent("outline", "arrow-narrow-left", "IconArrowNarrowLeft", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M5 12l4 4", "key": "svg-1" }], ["path", { "d": "M5 12l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowLeft
});

var IconArrowNarrowRightDashed = createReactComponent("outline", "arrow-narrow-right-dashed", "IconArrowNarrowRightDashed", [["path", { "d": "M5 12h.5m3 0h1.5m3 0h6", "key": "svg-0" }], ["path", { "d": "M15 16l4 -4", "key": "svg-1" }], ["path", { "d": "M15 8l4 4", "key": "svg-2" }]]);

var IconArrowNarrowRightDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowRightDashed
});

var IconArrowNarrowRight = createReactComponent("outline", "arrow-narrow-right", "IconArrowNarrowRight", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M15 16l4 -4", "key": "svg-1" }], ["path", { "d": "M15 8l4 4", "key": "svg-2" }]]);

var IconArrowNarrowRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowRight
});

var IconArrowNarrowUpDashed = createReactComponent("outline", "arrow-narrow-up-dashed", "IconArrowNarrowUpDashed", [["path", { "d": "M12 5v6m0 3v1.5m0 3v.5", "key": "svg-0" }], ["path", { "d": "M16 9l-4 -4", "key": "svg-1" }], ["path", { "d": "M8 9l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowUpDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowUpDashed
});

var IconArrowNarrowUp = createReactComponent("outline", "arrow-narrow-up", "IconArrowNarrowUp", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M16 9l-4 -4", "key": "svg-1" }], ["path", { "d": "M8 9l4 -4", "key": "svg-2" }]]);

var IconArrowNarrowUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowNarrowUp
});

var IconArrowRampLeft2 = createReactComponent("outline", "arrow-ramp-left-2", "IconArrowRampLeft2", [["path", { "d": "M18 3v8.707", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M18 21c0 -6.075 -4.925 -11 -11 -11h-3", "key": "svg-2" }]]);

var IconArrowRampLeft2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampLeft2
});

var IconArrowRampLeft3 = createReactComponent("outline", "arrow-ramp-left-3", "IconArrowRampLeft3", [["path", { "d": "M18 3v6", "key": "svg-0" }], ["path", { "d": "M8 16l-4 -4l4 -4", "key": "svg-1" }], ["path", { "d": "M18 21v-6a3 3 0 0 0 -3 -3h-11", "key": "svg-2" }]]);

var IconArrowRampLeft3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampLeft3
});

var IconArrowRampLeft = createReactComponent("outline", "arrow-ramp-left", "IconArrowRampLeft", [["path", { "d": "M17 3l0 8.707", "key": "svg-0" }], ["path", { "d": "M13 7l4 -4l4 4", "key": "svg-1" }], ["path", { "d": "M7 14l-4 -4l4 -4", "key": "svg-2" }], ["path", { "d": "M17 21a11 11 0 0 0 -11 -11h-3", "key": "svg-3" }]]);

var IconArrowRampLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampLeft
});

var IconArrowRampRight2 = createReactComponent("outline", "arrow-ramp-right-2", "IconArrowRampRight2", [["path", { "d": "M6 3v8.707", "key": "svg-0" }], ["path", { "d": "M16 14l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M6 21c0 -6.075 4.925 -11 11 -11h3", "key": "svg-2" }]]);

var IconArrowRampRight2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampRight2
});

var IconArrowRampRight3 = createReactComponent("outline", "arrow-ramp-right-3", "IconArrowRampRight3", [["path", { "d": "M6 3v6", "key": "svg-0" }], ["path", { "d": "M16 16l4 -4l-4 -4", "key": "svg-1" }], ["path", { "d": "M6 21v-6a3 3 0 0 1 3 -3h11", "key": "svg-2" }]]);

var IconArrowRampRight3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampRight3
});

var IconArrowRampRight = createReactComponent("outline", "arrow-ramp-right", "IconArrowRampRight", [["path", { "d": "M7 3l0 8.707", "key": "svg-0" }], ["path", { "d": "M11 7l-4 -4l-4 4", "key": "svg-1" }], ["path", { "d": "M17 14l4 -4l-4 -4", "key": "svg-2" }], ["path", { "d": "M7 21a11 11 0 0 1 11 -11h3", "key": "svg-3" }]]);

var IconArrowRampRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRampRight
});

var IconArrowRightBar = createReactComponent("outline", "arrow-right-bar", "IconArrowRightBar", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M3 12h18", "key": "svg-1" }], ["path", { "d": "M3 9v6", "key": "svg-2" }]]);

var IconArrowRightBar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightBar
});

var IconArrowRightCircle = createReactComponent("outline", "arrow-right-circle", "IconArrowRightCircle", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M5 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 12h14", "key": "svg-2" }]]);

var IconArrowRightCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightCircle
});

var IconArrowRightDashed = createReactComponent("outline", "arrow-right-dashed", "IconArrowRightDashed", [["path", { "d": "M5 12h.5m3 0h1.5m3 0h6", "key": "svg-0" }], ["path", { "d": "M13 18l6 -6", "key": "svg-1" }], ["path", { "d": "M13 6l6 6", "key": "svg-2" }]]);

var IconArrowRightDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightDashed
});

var IconArrowRightFromArc = createReactComponent("outline", "arrow-right-from-arc", "IconArrowRightFromArc", [["path", { "d": "M15 12h-12", "key": "svg-0" }], ["path", { "d": "M7 8l-4 4l4 4", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 0 0 0 -18", "key": "svg-2" }]]);

var IconArrowRightFromArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightFromArc
});

var IconArrowRightRhombus = createReactComponent("outline", "arrow-right-rhombus", "IconArrowRightRhombus", [["path", { "d": "M8 12h13", "key": "svg-0" }], ["path", { "d": "M18 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M5.5 9.5l-2.5 2.5l2.5 2.5l2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowRightRhombus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightRhombus
});

var IconArrowRightSquare = createReactComponent("outline", "arrow-right-square", "IconArrowRightSquare", [["path", { "d": "M7 12l14 0", "key": "svg-0" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 10h4v4h-4z", "key": "svg-2" }]]);

var IconArrowRightSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightSquare
});

var IconArrowRightTail = createReactComponent("outline", "arrow-right-tail", "IconArrowRightTail", [["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-0" }], ["path", { "d": "M3 15l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M6 12l15 0", "key": "svg-2" }]]);

var IconArrowRightTail$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightTail
});

var IconArrowRightToArc = createReactComponent("outline", "arrow-right-to-arc", "IconArrowRightToArc", [["path", { "d": "M3 12h12", "key": "svg-0" }], ["path", { "d": "M11 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 0 0 0 -18", "key": "svg-2" }]]);

var IconArrowRightToArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRightToArc
});

var IconArrowRight = createReactComponent("outline", "arrow-right", "IconArrowRight", [["path", { "d": "M5 12l14 0", "key": "svg-0" }], ["path", { "d": "M13 18l6 -6", "key": "svg-1" }], ["path", { "d": "M13 6l6 6", "key": "svg-2" }]]);

var IconArrowRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRight
});

var IconArrowRotaryFirstLeft = createReactComponent("outline", "arrow-rotary-first-left", "IconArrowRotaryFirstLeft", [["path", { "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M16 10v10", "key": "svg-1" }], ["path", { "d": "M13.5 9.5l-8.5 8.5", "key": "svg-2" }], ["path", { "d": "M10 18h-5v-5", "key": "svg-3" }]]);

var IconArrowRotaryFirstLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryFirstLeft
});

var IconArrowRotaryFirstRight = createReactComponent("outline", "arrow-rotary-first-right", "IconArrowRotaryFirstRight", [["path", { "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M8 10v10", "key": "svg-1" }], ["path", { "d": "M10.5 9.5l8.5 8.5", "key": "svg-2" }], ["path", { "d": "M14 18h5v-5", "key": "svg-3" }]]);

var IconArrowRotaryFirstRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryFirstRight
});

var IconArrowRotaryLastLeft = createReactComponent("outline", "arrow-rotary-last-left", "IconArrowRotaryLastLeft", [["path", { "d": "M15 15a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M15 15v6", "key": "svg-1" }], ["path", { "d": "M12.5 9.5l-6.5 -6.5", "key": "svg-2" }], ["path", { "d": "M11 3h-5v5", "key": "svg-3" }]]);

var IconArrowRotaryLastLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryLastLeft
});

var IconArrowRotaryLastRight = createReactComponent("outline", "arrow-rotary-last-right", "IconArrowRotaryLastRight", [["path", { "d": "M9 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M9 15v6", "key": "svg-1" }], ["path", { "d": "M11.5 9.5l6.5 -6.5", "key": "svg-2" }], ["path", { "d": "M13 3h5v5", "key": "svg-3" }]]);

var IconArrowRotaryLastRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryLastRight
});

var IconArrowRotaryLeft = createReactComponent("outline", "arrow-rotary-left", "IconArrowRotaryLeft", [["path", { "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z", "key": "svg-0" }], ["path", { "d": "M16 10v10", "key": "svg-1" }], ["path", { "d": "M13 7h-10", "key": "svg-2" }], ["path", { "d": "M7 11l-4 -4l4 -4", "key": "svg-3" }]]);

var IconArrowRotaryLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryLeft
});

var IconArrowRotaryRight = createReactComponent("outline", "arrow-rotary-right", "IconArrowRotaryRight", [["path", { "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M8 10v10", "key": "svg-1" }], ["path", { "d": "M17 11l4 -4l-4 -4", "key": "svg-2" }], ["path", { "d": "M11 7h10", "key": "svg-3" }]]);

var IconArrowRotaryRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryRight
});

var IconArrowRotaryStraight = createReactComponent("outline", "arrow-rotary-straight", "IconArrowRotaryStraight", [["path", { "d": "M13 13m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M13 16v5", "key": "svg-1" }], ["path", { "d": "M13 3v7", "key": "svg-2" }], ["path", { "d": "M9 7l4 -4l4 4", "key": "svg-3" }]]);

var IconArrowRotaryStraight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRotaryStraight
});

var IconArrowRoundaboutLeft = createReactComponent("outline", "arrow-roundabout-left", "IconArrowRoundaboutLeft", [["path", { "d": "M3 9h8a5 5 0 1 1 5 5v7", "key": "svg-0" }], ["path", { "d": "M7 5l-4 4l4 4", "key": "svg-1" }]]);

var IconArrowRoundaboutLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRoundaboutLeft
});

var IconArrowRoundaboutRight = createReactComponent("outline", "arrow-roundabout-right", "IconArrowRoundaboutRight", [["path", { "d": "M21 9h-8a5 5 0 1 0 -5 5v7", "key": "svg-0" }], ["path", { "d": "M17 5l4 4l-4 4", "key": "svg-1" }]]);

var IconArrowRoundaboutRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowRoundaboutRight
});

var IconArrowSharpTurnLeft = createReactComponent("outline", "arrow-sharp-turn-left", "IconArrowSharpTurnLeft", [["path", { "d": "M17 18v-11.31a.7 .7 0 0 0 -1.195 -.495l-9.805 9.805", "key": "svg-0" }], ["path", { "d": "M11 16h-5v-5", "key": "svg-1" }]]);

var IconArrowSharpTurnLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowSharpTurnLeft
});

var IconArrowSharpTurnRight = createReactComponent("outline", "arrow-sharp-turn-right", "IconArrowSharpTurnRight", [["path", { "d": "M7 18v-11.31a.7 .7 0 0 1 1.195 -.495l9.805 9.805", "key": "svg-0" }], ["path", { "d": "M13 16h5v-5", "key": "svg-1" }]]);

var IconArrowSharpTurnRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowSharpTurnRight
});

var IconArrowUpBar = createReactComponent("outline", "arrow-up-bar", "IconArrowUpBar", [["path", { "d": "M12 21l0 -18", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M9 21l6 0", "key": "svg-2" }]]);

var IconArrowUpBar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpBar
});

var IconArrowUpCircle = createReactComponent("outline", "arrow-up-circle", "IconArrowUpCircle", [["path", { "d": "M12 17v-14", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M12 17a2 2 0 1 0 0 4a2 2 0 0 0 0 -4", "key": "svg-2" }]]);

var IconArrowUpCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpCircle
});

var IconArrowUpDashed = createReactComponent("outline", "arrow-up-dashed", "IconArrowUpDashed", [["path", { "d": "M12 5v6m0 3v1.5m0 3v.5", "key": "svg-0" }], ["path", { "d": "M18 11l-6 -6", "key": "svg-1" }], ["path", { "d": "M6 11l6 -6", "key": "svg-2" }]]);

var IconArrowUpDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpDashed
});

var IconArrowUpFromArc = createReactComponent("outline", "arrow-up-from-arc", "IconArrowUpFromArc", [["path", { "d": "M12 9v12", "key": "svg-0" }], ["path", { "d": "M8 17l4 4l4 -4", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconArrowUpFromArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpFromArc
});

var IconArrowUpLeftCircle = createReactComponent("outline", "arrow-up-left-circle", "IconArrowUpLeftCircle", [["path", { "d": "M15.536 15.536l-9.536 -9.536", "key": "svg-0" }], ["path", { "d": "M10 6h-4v4", "key": "svg-1" }], ["path", { "d": "M15.586 15.586a2 2 0 1 0 2.828 2.828a2 2 0 0 0 -2.828 -2.828", "key": "svg-2" }]]);

var IconArrowUpLeftCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpLeftCircle
});

var IconArrowUpLeft = createReactComponent("outline", "arrow-up-left", "IconArrowUpLeft", [["path", { "d": "M7 7l10 10", "key": "svg-0" }], ["path", { "d": "M16 7l-9 0l0 9", "key": "svg-1" }]]);

var IconArrowUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpLeft
});

var IconArrowUpRhombus = createReactComponent("outline", "arrow-up-rhombus", "IconArrowUpRhombus", [["path", { "d": "M12 16v-13", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M14.5 18.5l-2.5 2.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-2" }]]);

var IconArrowUpRhombus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpRhombus
});

var IconArrowUpRightCircle = createReactComponent("outline", "arrow-up-right-circle", "IconArrowUpRightCircle", [["path", { "d": "M8.464 15.536l9.536 -9.536", "key": "svg-0" }], ["path", { "d": "M18 10v-4h-4", "key": "svg-1" }], ["path", { "d": "M8.414 15.586a2 2 0 1 0 -2.828 2.828a2 2 0 0 0 2.828 -2.828", "key": "svg-2" }]]);

var IconArrowUpRightCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpRightCircle
});

var IconArrowUpRight = createReactComponent("outline", "arrow-up-right", "IconArrowUpRight", [["path", { "d": "M17 7l-10 10", "key": "svg-0" }], ["path", { "d": "M8 7l9 0l0 9", "key": "svg-1" }]]);

var IconArrowUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpRight
});

var IconArrowUpSquare = createReactComponent("outline", "arrow-up-square", "IconArrowUpSquare", [["path", { "d": "M12 17l0 -14", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M10 21v-4h4v4z", "key": "svg-2" }]]);

var IconArrowUpSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpSquare
});

var IconArrowUpTail = createReactComponent("outline", "arrow-up-tail", "IconArrowUpTail", [["path", { "d": "M12 18l0 -15", "key": "svg-0" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M15 21l-3 -3l-3 3", "key": "svg-2" }]]);

var IconArrowUpTail$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpTail
});

var IconArrowUpToArc = createReactComponent("outline", "arrow-up-to-arc", "IconArrowUpToArc", [["path", { "d": "M12 21v-12", "key": "svg-0" }], ["path", { "d": "M8 13l4 -4l4 4", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconArrowUpToArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUpToArc
});

var IconArrowUp = createReactComponent("outline", "arrow-up", "IconArrowUp", [["path", { "d": "M12 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 11l-6 -6", "key": "svg-1" }], ["path", { "d": "M6 11l6 -6", "key": "svg-2" }]]);

var IconArrowUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowUp
});

var IconArrowWaveLeftDown = createReactComponent("outline", "arrow-wave-left-down", "IconArrowWaveLeftDown", [["path", { "d": "M7 14h-4v-4", "key": "svg-0" }], ["path", { "d": "M21 12c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3.113 -.716 -4 -2s-2.48 -2.033 -4 -2c-1.52 -.033 -3 1 -4 2l-2 2", "key": "svg-1" }]]);

var IconArrowWaveLeftDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowWaveLeftDown
});

var IconArrowWaveLeftUp = createReactComponent("outline", "arrow-wave-left-up", "IconArrowWaveLeftUp", [["path", { "d": "M7 10h-4v4", "key": "svg-0" }], ["path", { "d": "M21 12c-.887 -1.285 -2.48 -2.033 -4 -2c-1.52 -.033 -3.113 .715 -4 2c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3 -1 -4 -2l-2 -2", "key": "svg-1" }]]);

var IconArrowWaveLeftUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowWaveLeftUp
});

var IconArrowWaveRightDown = createReactComponent("outline", "arrow-wave-right-down", "IconArrowWaveRightDown", [["path", { "d": "M17 14h4v-4", "key": "svg-0" }], ["path", { "d": "M3 12c.887 1.284 2.48 2.033 4 2c1.52 .033 3.113 -.716 4 -2s2.48 -2.033 4 -2c1.52 -.033 3 1 4 2l2 2", "key": "svg-1" }]]);

var IconArrowWaveRightDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowWaveRightDown
});

var IconArrowWaveRightUp = createReactComponent("outline", "arrow-wave-right-up", "IconArrowWaveRightUp", [["path", { "d": "M17 10h4v4", "key": "svg-0" }], ["path", { "d": "M3 12c.887 -1.284 2.48 -2.033 4 -2c1.52 -.033 3.113 .716 4 2s2.48 2.033 4 2c1.52 .033 3 -1 4 -2l2 -2", "key": "svg-1" }]]);

var IconArrowWaveRightUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowWaveRightUp
});

var IconArrowZigZag = createReactComponent("outline", "arrow-zig-zag", "IconArrowZigZag", [["path", { "d": "M6 20v-10l10 6v-12", "key": "svg-0" }], ["path", { "d": "M13 7l3 -3l3 3", "key": "svg-1" }]]);

var IconArrowZigZag$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowZigZag
});

var IconArrowsCross = createReactComponent("outline", "arrows-cross", "IconArrowsCross", [["path", { "d": "M16 4h4v4", "key": "svg-0" }], ["path", { "d": "M15 9l5 -5", "key": "svg-1" }], ["path", { "d": "M4 20l5 -5", "key": "svg-2" }], ["path", { "d": "M16 20h4v-4", "key": "svg-3" }], ["path", { "d": "M4 4l16 16", "key": "svg-4" }]]);

var IconArrowsCross$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsCross
});

var IconArrowsDiagonal2 = createReactComponent("outline", "arrows-diagonal-2", "IconArrowsDiagonal2", [["path", { "d": "M16 20l4 0l0 -4", "key": "svg-0" }], ["path", { "d": "M14 14l6 6", "key": "svg-1" }], ["path", { "d": "M8 4l-4 0l0 4", "key": "svg-2" }], ["path", { "d": "M4 4l6 6", "key": "svg-3" }]]);

var IconArrowsDiagonal2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDiagonal2
});

var IconArrowsDiagonalMinimize2 = createReactComponent("outline", "arrows-diagonal-minimize-2", "IconArrowsDiagonalMinimize2", [["path", { "d": "M18 10h-4v-4", "key": "svg-0" }], ["path", { "d": "M20 4l-6 6", "key": "svg-1" }], ["path", { "d": "M6 14h4v4", "key": "svg-2" }], ["path", { "d": "M10 14l-6 6", "key": "svg-3" }]]);

var IconArrowsDiagonalMinimize2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDiagonalMinimize2
});

var IconArrowsDiagonalMinimize = createReactComponent("outline", "arrows-diagonal-minimize", "IconArrowsDiagonalMinimize", [["path", { "d": "M6 10h4v-4", "key": "svg-0" }], ["path", { "d": "M4 4l6 6", "key": "svg-1" }], ["path", { "d": "M18 14h-4v4", "key": "svg-2" }], ["path", { "d": "M14 14l6 6", "key": "svg-3" }]]);

var IconArrowsDiagonalMinimize$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDiagonalMinimize
});

var IconArrowsDiagonal = createReactComponent("outline", "arrows-diagonal", "IconArrowsDiagonal", [["path", { "d": "M16 4l4 0l0 4", "key": "svg-0" }], ["path", { "d": "M14 10l6 -6", "key": "svg-1" }], ["path", { "d": "M8 20l-4 0l0 -4", "key": "svg-2" }], ["path", { "d": "M4 20l6 -6", "key": "svg-3" }]]);

var IconArrowsDiagonal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDiagonal
});

var IconArrowsDiff = createReactComponent("outline", "arrows-diff", "IconArrowsDiff", [["path", { "d": "M11 16h10", "key": "svg-0" }], ["path", { "d": "M11 16l4 4", "key": "svg-1" }], ["path", { "d": "M11 16l4 -4", "key": "svg-2" }], ["path", { "d": "M13 8h-10", "key": "svg-3" }], ["path", { "d": "M13 8l-4 4", "key": "svg-4" }], ["path", { "d": "M13 8l-4 -4", "key": "svg-5" }]]);

var IconArrowsDiff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDiff
});

var IconArrowsDoubleNeSw = createReactComponent("outline", "arrows-double-ne-sw", "IconArrowsDoubleNeSw", [["path", { "d": "M3 14l11 -11", "key": "svg-0" }], ["path", { "d": "M10 3h4v4", "key": "svg-1" }], ["path", { "d": "M10 17v4h4", "key": "svg-2" }], ["path", { "d": "M21 10l-11 11", "key": "svg-3" }]]);

var IconArrowsDoubleNeSw$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDoubleNeSw
});

var IconArrowsDoubleNwSe = createReactComponent("outline", "arrows-double-nw-se", "IconArrowsDoubleNwSe", [["path", { "d": "M14 21l-11 -11", "key": "svg-0" }], ["path", { "d": "M3 14v-4h4", "key": "svg-1" }], ["path", { "d": "M17 14h4v-4", "key": "svg-2" }], ["path", { "d": "M10 3l11 11", "key": "svg-3" }]]);

var IconArrowsDoubleNwSe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDoubleNwSe
});

var IconArrowsDoubleSeNw = createReactComponent("outline", "arrows-double-se-nw", "IconArrowsDoubleSeNw", [["path", { "d": "M3 10l11 11", "key": "svg-0" }], ["path", { "d": "M14 17v4h-4", "key": "svg-1" }], ["path", { "d": "M14 3h-4v4", "key": "svg-2" }], ["path", { "d": "M21 14l-11 -11", "key": "svg-3" }]]);

var IconArrowsDoubleSeNw$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDoubleSeNw
});

var IconArrowsDoubleSwNe = createReactComponent("outline", "arrows-double-sw-ne", "IconArrowsDoubleSwNe", [["path", { "d": "M14 3l-11 11", "key": "svg-0" }], ["path", { "d": "M3 10v4h4", "key": "svg-1" }], ["path", { "d": "M17 10h4v4", "key": "svg-2" }], ["path", { "d": "M10 21l11 -11", "key": "svg-3" }]]);

var IconArrowsDoubleSwNe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDoubleSwNe
});

var IconArrowsDownUp = createReactComponent("outline", "arrows-down-up", "IconArrowsDownUp", [["path", { "d": "M17 3l0 18", "key": "svg-0" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M7 21l0 -18", "key": "svg-2" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-3" }]]);

var IconArrowsDownUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDownUp
});

var IconArrowsDown = createReactComponent("outline", "arrows-down", "IconArrowsDown", [["path", { "d": "M7 21l0 -18", "key": "svg-0" }], ["path", { "d": "M20 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M4 18l3 3l3 -3", "key": "svg-2" }], ["path", { "d": "M17 21l0 -18", "key": "svg-3" }]]);

var IconArrowsDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsDown
});

var IconArrowsExchange2 = createReactComponent("outline", "arrows-exchange-2", "IconArrowsExchange2", [["path", { "d": "M17 10h-14l4 -4", "key": "svg-0" }], ["path", { "d": "M7 14h14l-4 4", "key": "svg-1" }]]);

var IconArrowsExchange2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsExchange2
});

var IconArrowsExchange = createReactComponent("outline", "arrows-exchange", "IconArrowsExchange", [["path", { "d": "M7 10h14l-4 -4", "key": "svg-0" }], ["path", { "d": "M17 14h-14l4 4", "key": "svg-1" }]]);

var IconArrowsExchange$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsExchange
});

var IconArrowsHorizontal = createReactComponent("outline", "arrows-horizontal", "IconArrowsHorizontal", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M3 12l18 0", "key": "svg-2" }]]);

var IconArrowsHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsHorizontal
});

var IconArrowsJoin2 = createReactComponent("outline", "arrows-join-2", "IconArrowsJoin2", [["path", { "d": "M3 7h1.948c1.913 0 3.705 .933 4.802 2.5a5.861 5.861 0 0 0 4.802 2.5h6.448", "key": "svg-0" }], ["path", { "d": "M3 17h1.95a5.854 5.854 0 0 0 4.798 -2.5a5.854 5.854 0 0 1 4.798 -2.5h5.454", "key": "svg-1" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-2" }]]);

var IconArrowsJoin2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsJoin2
});

var IconArrowsJoin = createReactComponent("outline", "arrows-join", "IconArrowsJoin", [["path", { "d": "M3 7h5l3.5 5h9.5", "key": "svg-0" }], ["path", { "d": "M3 17h5l3.495 -5", "key": "svg-1" }], ["path", { "d": "M18 15l3 -3l-3 -3", "key": "svg-2" }]]);

var IconArrowsJoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsJoin
});

var IconArrowsLeftDown = createReactComponent("outline", "arrows-left-down", "IconArrowsLeftDown", [["path", { "d": "M7 3l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M3 7h11a3 3 0 0 1 3 3v11", "key": "svg-1" }], ["path", { "d": "M13 17l4 4l4 -4", "key": "svg-2" }]]);

var IconArrowsLeftDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsLeftDown
});

var IconArrowsLeftRight = createReactComponent("outline", "arrows-left-right", "IconArrowsLeftRight", [["path", { "d": "M21 17l-18 0", "key": "svg-0" }], ["path", { "d": "M6 10l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M3 7l18 0", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsLeftRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsLeftRight
});

var IconArrowsLeft = createReactComponent("outline", "arrows-left", "IconArrowsLeft", [["path", { "d": "M3 7l18 0", "key": "svg-0" }], ["path", { "d": "M6 20l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M6 4l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 17l18 0", "key": "svg-3" }]]);

var IconArrowsLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsLeft
});

var IconArrowsMaximize = createReactComponent("outline", "arrows-maximize", "IconArrowsMaximize", [["path", { "d": "M16 4l4 0l0 4", "key": "svg-0" }], ["path", { "d": "M14 10l6 -6", "key": "svg-1" }], ["path", { "d": "M8 20l-4 0l0 -4", "key": "svg-2" }], ["path", { "d": "M4 20l6 -6", "key": "svg-3" }], ["path", { "d": "M16 20l4 0l0 -4", "key": "svg-4" }], ["path", { "d": "M14 14l6 6", "key": "svg-5" }], ["path", { "d": "M8 4l-4 0l0 4", "key": "svg-6" }], ["path", { "d": "M4 4l6 6", "key": "svg-7" }]]);

var IconArrowsMaximize$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsMaximize
});

var IconArrowsMinimize = createReactComponent("outline", "arrows-minimize", "IconArrowsMinimize", [["path", { "d": "M5 9l4 0l0 -4", "key": "svg-0" }], ["path", { "d": "M3 3l6 6", "key": "svg-1" }], ["path", { "d": "M5 15l4 0l0 4", "key": "svg-2" }], ["path", { "d": "M3 21l6 -6", "key": "svg-3" }], ["path", { "d": "M19 9l-4 0l0 -4", "key": "svg-4" }], ["path", { "d": "M15 9l6 -6", "key": "svg-5" }], ["path", { "d": "M19 15l-4 0l0 4", "key": "svg-6" }], ["path", { "d": "M15 15l6 6", "key": "svg-7" }]]);

var IconArrowsMinimize$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsMinimize
});

var IconArrowsMoveHorizontal = createReactComponent("outline", "arrows-move-horizontal", "IconArrowsMoveHorizontal", [["path", { "d": "M18 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M15 12h6", "key": "svg-1" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 12h6", "key": "svg-3" }]]);

var IconArrowsMoveHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsMoveHorizontal
});

var IconArrowsMoveVertical = createReactComponent("outline", "arrows-move-vertical", "IconArrowsMoveVertical", [["path", { "d": "M9 18l3 3l3 -3", "key": "svg-0" }], ["path", { "d": "M12 15v6", "key": "svg-1" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M12 3v6", "key": "svg-3" }]]);

var IconArrowsMoveVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsMoveVertical
});

var IconArrowsMove = createReactComponent("outline", "arrows-move", "IconArrowsMove", [["path", { "d": "M18 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M15 12h6", "key": "svg-1" }], ["path", { "d": "M6 9l-3 3l3 3", "key": "svg-2" }], ["path", { "d": "M3 12h6", "key": "svg-3" }], ["path", { "d": "M9 18l3 3l3 -3", "key": "svg-4" }], ["path", { "d": "M12 15v6", "key": "svg-5" }], ["path", { "d": "M15 6l-3 -3l-3 3", "key": "svg-6" }], ["path", { "d": "M12 3v6", "key": "svg-7" }]]);

var IconArrowsMove$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsMove
});

var IconArrowsRandom = createReactComponent("outline", "arrows-random", "IconArrowsRandom", [["path", { "d": "M20 21h-4v-4", "key": "svg-0" }], ["path", { "d": "M16 21l5 -5", "key": "svg-1" }], ["path", { "d": "M6.5 9.504l-3.5 -2l2 -3.504", "key": "svg-2" }], ["path", { "d": "M3 7.504l6.83 -1.87", "key": "svg-3" }], ["path", { "d": "M4 16l4 -1l1 4", "key": "svg-4" }], ["path", { "d": "M8 15l-3.5 6", "key": "svg-5" }], ["path", { "d": "M21 5l-.5 4l-4 -.5", "key": "svg-6" }], ["path", { "d": "M20.5 9l-4.5 -5.5", "key": "svg-7" }]]);

var IconArrowsRandom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsRandom
});

var IconArrowsRightDown = createReactComponent("outline", "arrows-right-down", "IconArrowsRightDown", [["path", { "d": "M3 17l4 4l4 -4", "key": "svg-0" }], ["path", { "d": "M7 21v-11a3 3 0 0 1 3 -3h11", "key": "svg-1" }], ["path", { "d": "M17 11l4 -4l-4 -4", "key": "svg-2" }]]);

var IconArrowsRightDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsRightDown
});

var IconArrowsRightLeft = createReactComponent("outline", "arrows-right-left", "IconArrowsRightLeft", [["path", { "d": "M21 7l-18 0", "key": "svg-0" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M6 20l-3 -3l3 -3", "key": "svg-2" }], ["path", { "d": "M3 17l18 0", "key": "svg-3" }]]);

var IconArrowsRightLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsRightLeft
});

var IconArrowsRight = createReactComponent("outline", "arrows-right", "IconArrowsRight", [["path", { "d": "M21 17l-18 0", "key": "svg-0" }], ["path", { "d": "M18 4l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M21 7l-18 0", "key": "svg-3" }]]);

var IconArrowsRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsRight
});

var IconArrowsShuffle2 = createReactComponent("outline", "arrows-shuffle-2", "IconArrowsShuffle2", [["path", { "d": "M18 4l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5", "key": "svg-2" }], ["path", { "d": "M3 17h3a5 5 0 0 0 5 -5a5 5 0 0 1 5 -5h5", "key": "svg-3" }]]);

var IconArrowsShuffle2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsShuffle2
});

var IconArrowsShuffle = createReactComponent("outline", "arrows-shuffle", "IconArrowsShuffle", [["path", { "d": "M18 4l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-1" }], ["path", { "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5", "key": "svg-2" }], ["path", { "d": "M21 7h-5a4.978 4.978 0 0 0 -3 1m-4 8a4.984 4.984 0 0 1 -3 1h-3", "key": "svg-3" }]]);

var IconArrowsShuffle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsShuffle
});

var IconArrowsSort = createReactComponent("outline", "arrows-sort", "IconArrowsSort", [["path", { "d": "M3 9l4 -4l4 4m-4 -4v14", "key": "svg-0" }], ["path", { "d": "M21 15l-4 4l-4 -4m4 4v-14", "key": "svg-1" }]]);

var IconArrowsSort$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsSort
});

var IconArrowsSplit2 = createReactComponent("outline", "arrows-split-2", "IconArrowsSplit2", [["path", { "d": "M21 17h-5.397a5 5 0 0 1 -4.096 -2.133l-.514 -.734a5 5 0 0 0 -4.096 -2.133h-3.897", "key": "svg-0" }], ["path", { "d": "M21 7h-5.395a5 5 0 0 0 -4.098 2.135l-.51 .73a5 5 0 0 1 -4.097 2.135h-3.9", "key": "svg-1" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsSplit2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsSplit2
});

var IconArrowsSplit = createReactComponent("outline", "arrows-split", "IconArrowsSplit", [["path", { "d": "M21 17h-8l-3.5 -5h-6.5", "key": "svg-0" }], ["path", { "d": "M21 7h-8l-3.495 5", "key": "svg-1" }], ["path", { "d": "M18 10l3 -3l-3 -3", "key": "svg-2" }], ["path", { "d": "M18 20l3 -3l-3 -3", "key": "svg-3" }]]);

var IconArrowsSplit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsSplit
});

var IconArrowsTransferDown = createReactComponent("outline", "arrows-transfer-down", "IconArrowsTransferDown", [["path", { "d": "M17 3v6", "key": "svg-0" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M7 21v-18", "key": "svg-2" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-3" }], ["path", { "d": "M17 21v-2", "key": "svg-4" }], ["path", { "d": "M17 15v-2", "key": "svg-5" }]]);

var IconArrowsTransferDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsTransferDown
});

var IconArrowsTransferUpDown = createReactComponent("outline", "arrows-transfer-up-down", "IconArrowsTransferUpDown", [["path", { "d": "M7 21v-6", "key": "svg-0" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M7 3v2", "key": "svg-3" }], ["path", { "d": "M7 9v2", "key": "svg-4" }], ["path", { "d": "M17 3v6", "key": "svg-5" }], ["path", { "d": "M17 21v-2", "key": "svg-6" }], ["path", { "d": "M17 15v-2", "key": "svg-7" }]]);

var IconArrowsTransferUpDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsTransferUpDown
});

var IconArrowsTransferUp = createReactComponent("outline", "arrows-transfer-up", "IconArrowsTransferUp", [["path", { "d": "M7 21v-6", "key": "svg-0" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M17 3v18", "key": "svg-2" }], ["path", { "d": "M10 18l-3 3l-3 -3", "key": "svg-3" }], ["path", { "d": "M7 3v2", "key": "svg-4" }], ["path", { "d": "M7 9v2", "key": "svg-5" }]]);

var IconArrowsTransferUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsTransferUp
});

var IconArrowsUpDown = createReactComponent("outline", "arrows-up-down", "IconArrowsUpDown", [["path", { "d": "M7 3l0 18", "key": "svg-0" }], ["path", { "d": "M10 6l-3 -3l-3 3", "key": "svg-1" }], ["path", { "d": "M20 18l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M17 21l0 -18", "key": "svg-3" }]]);

var IconArrowsUpDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsUpDown
});

var IconArrowsUpLeft = createReactComponent("outline", "arrows-up-left", "IconArrowsUpLeft", [["path", { "d": "M21 7l-4 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M17 3v11a3 3 0 0 1 -3 3h-11", "key": "svg-1" }], ["path", { "d": "M7 13l-4 4l4 4", "key": "svg-2" }]]);

var IconArrowsUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsUpLeft
});

var IconArrowsUpRight = createReactComponent("outline", "arrows-up-right", "IconArrowsUpRight", [["path", { "d": "M17 21l4 -4l-4 -4", "key": "svg-0" }], ["path", { "d": "M21 17h-11a3 3 0 0 1 -3 -3v-11", "key": "svg-1" }], ["path", { "d": "M11 7l-4 -4l-4 4", "key": "svg-2" }]]);

var IconArrowsUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsUpRight
});

var IconArrowsUp = createReactComponent("outline", "arrows-up", "IconArrowsUp", [["path", { "d": "M17 3l0 18", "key": "svg-0" }], ["path", { "d": "M4 6l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M20 6l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M7 3l0 18", "key": "svg-3" }]]);

var IconArrowsUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsUp
});

var IconArrowsVertical = createReactComponent("outline", "arrows-vertical", "IconArrowsVertical", [["path", { "d": "M8 7l4 -4l4 4", "key": "svg-0" }], ["path", { "d": "M8 17l4 4l4 -4", "key": "svg-1" }], ["path", { "d": "M12 3l0 18", "key": "svg-2" }]]);

var IconArrowsVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArrowsVertical
});

var IconArtboardOff = createReactComponent("outline", "artboard-off", "IconArtboardOff", [["path", { "d": "M12 8h3a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M15.716 15.698a1 1 0 0 1 -.716 .302h-6a1 1 0 0 1 -1 -1v-6c0 -.273 .11 -.52 .287 -.7", "key": "svg-1" }], ["path", { "d": "M3 8h1", "key": "svg-2" }], ["path", { "d": "M3 16h1", "key": "svg-3" }], ["path", { "d": "M8 3v1", "key": "svg-4" }], ["path", { "d": "M16 3v1", "key": "svg-5" }], ["path", { "d": "M20 8h1", "key": "svg-6" }], ["path", { "d": "M20 16h1", "key": "svg-7" }], ["path", { "d": "M8 20v1", "key": "svg-8" }], ["path", { "d": "M16 20v1", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconArtboardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArtboardOff
});

var IconArtboard = createReactComponent("outline", "artboard", "IconArtboard", [["path", { "d": "M8 8m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 8l1 0", "key": "svg-1" }], ["path", { "d": "M3 16l1 0", "key": "svg-2" }], ["path", { "d": "M8 3l0 1", "key": "svg-3" }], ["path", { "d": "M16 3l0 1", "key": "svg-4" }], ["path", { "d": "M20 8l1 0", "key": "svg-5" }], ["path", { "d": "M20 16l1 0", "key": "svg-6" }], ["path", { "d": "M8 20l0 1", "key": "svg-7" }], ["path", { "d": "M16 20l0 1", "key": "svg-8" }]]);

var IconArtboard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArtboard
});

var IconArticleOff = createReactComponent("outline", "article-off", "IconArticleOff", [["path", { "d": "M8 4h11a2 2 0 0 1 2 2v11m-1.172 2.821a1.993 1.993 0 0 1 -.828 .179h-14a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.156 -1.814", "key": "svg-0" }], ["path", { "d": "M7 8h1m4 0h5", "key": "svg-1" }], ["path", { "d": "M7 12h5m4 0h1", "key": "svg-2" }], ["path", { "d": "M7 16h9", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconArticleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArticleOff
});

var IconArticle = createReactComponent("outline", "article", "IconArticle", [["path", { "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 8h10", "key": "svg-1" }], ["path", { "d": "M7 12h10", "key": "svg-2" }], ["path", { "d": "M7 16h10", "key": "svg-3" }]]);

var IconArticle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconArticle
});

var IconAspectRatioOff = createReactComponent("outline", "aspect-ratio-off", "IconAspectRatioOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 12v-3h2", "key": "svg-1" }], ["path", { "d": "M17 12v1m-2 2h-1", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAspectRatioOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAspectRatioOff
});

var IconAspectRatio = createReactComponent("outline", "aspect-ratio", "IconAspectRatio", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 12v-3h3", "key": "svg-1" }], ["path", { "d": "M17 12v3h-3", "key": "svg-2" }]]);

var IconAspectRatio$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAspectRatio
});

var IconAssemblyOff = createReactComponent("outline", "assembly-off", "IconAssemblyOff", [["path", { "d": "M18.376 18.377l-5.284 3.343a2.27 2.27 0 0 1 -2.184 0l-6.75 -4.27a2.23 2.23 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l1.328 -.783m2.514 -1.487l2.908 -1.71a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .417 -.118 .817 -.33 1.16", "key": "svg-0" }], ["path", { "d": "M14.855 14.855l-2.37 1.519a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l.563 -.336m2.437 -1.454a1.03 1.03 0 0 1 1 0l3 1.79h-.014c.312 .181 .503 .516 .5 .877v1.702", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAssemblyOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAssemblyOff
});

var IconAssembly = createReactComponent("outline", "assembly", "IconAssembly", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.27 2.27 0 0 1 -2.184 0l-6.75 -4.27a2.23 2.23 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98z", "key": "svg-0" }], ["path", { "d": "M15.5 9.422c.312 .18 .503 .515 .5 .876v3.277c0 .364 -.197 .7 -.515 .877l-3 1.922a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l3 -1.79c.311 -.174 .69 -.174 1 0l3 1.79h-.014z", "key": "svg-1" }]]);

var IconAssembly$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAssembly
});

var IconAsset = createReactComponent("outline", "asset", "IconAsset", [["path", { "d": "M9 15m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14.218 17.975l6.619 -12.174", "key": "svg-3" }], ["path", { "d": "M6.079 9.756l12.217 -6.631", "key": "svg-4" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }]]);

var IconAsset$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAsset
});

var IconAsteriskSimple = createReactComponent("outline", "asterisk-simple", "IconAsteriskSimple", [["path", { "d": "M12 12v-9", "key": "svg-0" }], ["path", { "d": "M12 12l-9 -2.5", "key": "svg-1" }], ["path", { "d": "M12 12l9 -2.5", "key": "svg-2" }], ["path", { "d": "M12 12l6 8.5", "key": "svg-3" }], ["path", { "d": "M12 12l-6 8.5", "key": "svg-4" }]]);

var IconAsteriskSimple$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAsteriskSimple
});

var IconAsterisk = createReactComponent("outline", "asterisk", "IconAsterisk", [["path", { "d": "M12 12l8 -4.5", "key": "svg-0" }], ["path", { "d": "M12 12v9", "key": "svg-1" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-2" }], ["path", { "d": "M12 12l8 4.5", "key": "svg-3" }], ["path", { "d": "M12 3v9", "key": "svg-4" }], ["path", { "d": "M12 12l-8 4.5", "key": "svg-5" }]]);

var IconAsterisk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAsterisk
});

var IconAtOff = createReactComponent("outline", "at-off", "IconAtOff", [["path", { "d": "M9.174 9.17a4 4 0 0 0 5.646 5.668m1.18 -2.838a4 4 0 0 0 -4 -4", "key": "svg-0" }], ["path", { "d": "M19.695 15.697a2.5 2.5 0 0 0 1.305 -2.197v-1.5a9 9 0 0 0 -13.055 -8.047m-2.322 1.683a9 9 0 0 0 9.877 14.644", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconAtOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAtOff
});

var IconAt = createReactComponent("outline", "at", "IconAt", [["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M16 12v1.5a2.5 2.5 0 0 0 5 0v-1.5a9 9 0 1 0 -5.5 8.28", "key": "svg-1" }]]);

var IconAt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAt
});

var IconAtom2 = createReactComponent("outline", "atom-2", "IconAtom2", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 21l0 .01", "key": "svg-1" }], ["path", { "d": "M3 9l0 .01", "key": "svg-2" }], ["path", { "d": "M21 9l0 .01", "key": "svg-3" }], ["path", { "d": "M8 20.1a9 9 0 0 1 -5 -7.1", "key": "svg-4" }], ["path", { "d": "M16 20.1a9 9 0 0 0 5 -7.1", "key": "svg-5" }], ["path", { "d": "M6.2 5a9 9 0 0 1 11.4 0", "key": "svg-6" }]]);

var IconAtom2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAtom2
});

var IconAtomOff = createReactComponent("outline", "atom-off", "IconAtomOff", [["path", { "d": "M12 12v.01", "key": "svg-0" }], ["path", { "d": "M9.172 9.172c-3.906 3.905 -5.805 8.337 -4.243 9.9c1.562 1.561 6 -.338 9.9 -4.244m1.884 -2.113c2.587 -3.277 3.642 -6.502 2.358 -7.786c-1.284 -1.284 -4.508 -.23 -7.784 2.357", "key": "svg-1" }], ["path", { "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242m-.072 -4.071c-.767 -1.794 -2.215 -3.872 -4.172 -5.828c-1.944 -1.945 -4.041 -3.402 -5.828 -4.172", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAtomOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAtomOff
});

var IconAtom = createReactComponent("outline", "atom", "IconAtom", [["path", { "d": "M12 12v.01", "key": "svg-0" }], ["path", { "d": "M19.071 4.929c-1.562 -1.562 -6 .337 -9.9 4.243c-3.905 3.905 -5.804 8.337 -4.242 9.9c1.562 1.561 6 -.338 9.9 -4.244c3.905 -3.905 5.804 -8.337 4.242 -9.9", "key": "svg-1" }], ["path", { "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242c1.561 -1.562 -.338 -6 -4.244 -9.9c-3.905 -3.905 -8.337 -5.804 -9.9 -4.242", "key": "svg-2" }]]);

var IconAtom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAtom
});

var IconAugmentedReality2 = createReactComponent("outline", "augmented-reality-2", "IconAugmentedReality2", [["path", { "d": "M10 21h-2a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M17 17l-4 -2.5l4 -2.5l4 2.5v4.5l-4 2.5z", "key": "svg-1" }], ["path", { "d": "M13 14.5v4.5l4 2.5", "key": "svg-2" }], ["path", { "d": "M17 17l4 -2.5", "key": "svg-3" }], ["path", { "d": "M11 4h2", "key": "svg-4" }]]);

var IconAugmentedReality2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAugmentedReality2
});

var IconAugmentedRealityOff = createReactComponent("outline", "augmented-reality-off", "IconAugmentedRealityOff", [["path", { "d": "M4 8v-2c0 -.557 .228 -1.061 .595 -1.424", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2c.558 0 1.062 -.228 1.425 -.596", "key": "svg-3" }], ["path", { "d": "M12 12.5l.312 -.195m2.457 -1.536l1.231 -.769", "key": "svg-4" }], ["path", { "d": "M9.225 9.235l-1.225 .765l4 2.5v4.5l3.076 -1.923m.924 -3.077v-2l-4 -2.5l-.302 .189", "key": "svg-5" }], ["path", { "d": "M8 10v4.5l4 2.5", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconAugmentedRealityOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAugmentedRealityOff
});

var IconAugmentedReality = createReactComponent("outline", "augmented-reality", "IconAugmentedReality", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 12.5l4 -2.5", "key": "svg-4" }], ["path", { "d": "M8 10l4 2.5v4.5l4 -2.5v-4.5l-4 -2.5z", "key": "svg-5" }], ["path", { "d": "M8 10v4.5l4 2.5", "key": "svg-6" }]]);

var IconAugmentedReality$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAugmentedReality
});

var IconAuth2fa = createReactComponent("outline", "auth-2fa", "IconAuth2fa", [["path", { "d": "M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54", "key": "svg-0" }], ["path", { "d": "M10 16v-8h4", "key": "svg-1" }], ["path", { "d": "M10 12l3 0", "key": "svg-2" }], ["path", { "d": "M17 16v-6a2 2 0 0 1 4 0v6", "key": "svg-3" }], ["path", { "d": "M17 13l4 0", "key": "svg-4" }]]);

var IconAuth2fa$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAuth2fa
});

var IconAutomaticGearbox = createReactComponent("outline", "automatic-gearbox", "IconAutomaticGearbox", [["path", { "d": "M17 17v4h1a2 2 0 1 0 0 -4h-1z", "key": "svg-0" }], ["path", { "d": "M17 11h1.5a1.5 1.5 0 0 0 0 -3h-1.5v5", "key": "svg-1" }], ["path", { "d": "M5 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M5 7v3a1 1 0 0 0 1 1h3v7a1 1 0 0 0 1 1h3", "key": "svg-3" }], ["path", { "d": "M9 11h4", "key": "svg-4" }]]);

var IconAutomaticGearbox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAutomaticGearbox
});

var IconAutomation = createReactComponent("outline", "automation", "IconAutomation", [["path", { "d": "M13 20.693c-.905 .628 -2.36 .292 -2.675 -1.01a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.492 .362 1.716 2.219 .674 3.03", "key": "svg-0" }], ["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 22l5 -3l-5 -3z", "key": "svg-2" }]]);

var IconAutomation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAutomation
});

var IconAvocado = createReactComponent("outline", "avocado", "IconAvocado", [["path", { "d": "M17.8 14.04a3.905 3.905 0 0 1 1.337 -2.075c1.195 -.985 1.816 -2.285 1.863 -3.902c-.047 -1.43 -.54 -2.626 -1.477 -3.586c-.96 -.938 -2.156 -1.43 -3.585 -1.477c-1.618 .047 -2.918 .668 -3.903 1.863c-.562 .68 -1.254 1.125 -2.074 1.336c-.938 .188 -1.828 .48 -2.672 .88c-.844 .398 -1.559 .878 -2.144 1.44c-1.43 1.501 -2.145 3.224 -2.145 5.169c0 1.946 .715 3.668 2.145 5.168c1.5 1.429 3.222 2.144 5.168 2.144c1.945 0 3.667 -.715 5.167 -2.145c.563 -.585 1.055 -1.3 1.477 -2.144c.398 -.844 .68 -1.723 .844 -2.637v-.035z", "key": "svg-0" }], ["path", { "d": "M10.87 10.036c-.942 .112 -1.794 .538 -2.556 1.278c-.74 .762 -1.166 1.614 -1.278 2.556c-.135 .92 .112 1.704 .74 2.354c.65 .628 1.435 .875 2.354 .74c.942 -.112 1.794 -.538 2.556 -1.278c.74 -.762 1.166 -1.614 1.278 -2.556c.135 -.92 -.112 -1.704 -.74 -2.354c-.65 -.628 -1.435 -.875 -2.354 -.74z", "key": "svg-1" }]]);

var IconAvocado$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAvocado
});

var IconAwardOff = createReactComponent("outline", "award-off", "IconAwardOff", [["path", { "d": "M16.72 12.704a6 6 0 0 0 -8.433 -8.418m-1.755 2.24a6 6 0 0 0 7.936 7.944", "key": "svg-0" }], ["path", { "d": "M12 15l3.4 5.89l1.598 -3.233l.707 .046m1.108 -2.902l-1.617 -2.8", "key": "svg-1" }], ["path", { "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconAwardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAwardOff
});

var IconAward = createReactComponent("outline", "award", "IconAward", [["path", { "d": "M12 9m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M12 15l3.4 5.89l1.598 -3.233l3.598 .232l-3.4 -5.889", "key": "svg-1" }], ["path", { "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889", "key": "svg-2" }]]);

var IconAward$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAward
});

var IconAxe = createReactComponent("outline", "axe", "IconAxe", [["path", { "d": "M13 9l7.383 7.418c.823 .82 .823 2.148 0 2.967a2.11 2.11 0 0 1 -2.976 0l-7.407 -7.385", "key": "svg-0" }], ["path", { "d": "M6.66 15.66l-3.32 -3.32a1.25 1.25 0 0 1 .42 -2.044l3.24 -1.296l6 -6l3 3l-6 6l-1.296 3.24a1.25 1.25 0 0 1 -2.044 .42z", "key": "svg-1" }]]);

var IconAxe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAxe
});

var IconAxisX = createReactComponent("outline", "axis-x", "IconAxisX", [["path", { "d": "M4 13v.01", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 5v.01", "key": "svg-2" }], ["path", { "d": "M17 20l3 -3l-3 -3", "key": "svg-3" }], ["path", { "d": "M4 17h16", "key": "svg-4" }]]);

var IconAxisX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAxisX
});

var IconAxisY = createReactComponent("outline", "axis-y", "IconAxisY", [["path", { "d": "M11 20h-.01", "key": "svg-0" }], ["path", { "d": "M15 20h-.01", "key": "svg-1" }], ["path", { "d": "M19 20h-.01", "key": "svg-2" }], ["path", { "d": "M4 7l3 -3l3 3", "key": "svg-3" }], ["path", { "d": "M7 20v-16", "key": "svg-4" }]]);

var IconAxisY$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconAxisY
});

var IconBabyBottle = createReactComponent("outline", "baby-bottle", "IconBabyBottle", [["path", { "d": "M5 10h14", "key": "svg-0" }], ["path", { "d": "M12 2v2", "key": "svg-1" }], ["path", { "d": "M12 4a5 5 0 0 1 5 5v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-11a5 5 0 0 1 5 -5z", "key": "svg-2" }]]);

var IconBabyBottle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBabyBottle
});

var IconBabyCarriage = createReactComponent("outline", "baby-carriage", "IconBabyCarriage", [["path", { "d": "M8 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M18 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M2 5h2.5l1.632 4.897a6 6 0 0 0 5.693 4.103h2.675a5.5 5.5 0 0 0 0 -11h-.5v6", "key": "svg-2" }], ["path", { "d": "M6 9h14", "key": "svg-3" }], ["path", { "d": "M9 17l1 -3", "key": "svg-4" }], ["path", { "d": "M16 14l1 3", "key": "svg-5" }]]);

var IconBabyCarriage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBabyCarriage
});

var IconBackground = createReactComponent("outline", "background", "IconBackground", [["path", { "d": "M4 8l4 -4", "key": "svg-0" }], ["path", { "d": "M14 4l-10 10", "key": "svg-1" }], ["path", { "d": "M4 20l16 -16", "key": "svg-2" }], ["path", { "d": "M20 10l-10 10", "key": "svg-3" }], ["path", { "d": "M20 16l-4 4", "key": "svg-4" }]]);

var IconBackground$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackground
});

var IconBackhoe = createReactComponent("outline", "backhoe", "IconBackhoe", [["path", { "d": "M4 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M13 19l-9 0", "key": "svg-2" }], ["path", { "d": "M4 15l9 0", "key": "svg-3" }], ["path", { "d": "M8 12v-5h2a3 3 0 0 1 3 3v5", "key": "svg-4" }], ["path", { "d": "M5 15v-2a1 1 0 0 1 1 -1h7", "key": "svg-5" }], ["path", { "d": "M21.12 9.88l-3.12 -4.88l-5 5", "key": "svg-6" }], ["path", { "d": "M21.12 9.88a3 3 0 0 1 -2.12 5.12a3 3 0 0 1 -2.12 -.88l4.24 -4.24z", "key": "svg-7" }]]);

var IconBackhoe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackhoe
});

var IconBackpackOff = createReactComponent("outline", "backpack-off", "IconBackpackOff", [["path", { "d": "M10 6h3a6 6 0 0 1 6 6v3m-.129 3.872a3 3 0 0 1 -2.871 2.128h-8a3 3 0 0 1 -3 -3v-6a5.99 5.99 0 0 1 2.285 -4.712", "key": "svg-0" }], ["path", { "d": "M10 6v-1a2 2 0 1 1 4 0v1", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBackpackOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackpackOff
});

var IconBackpack = createReactComponent("outline", "backpack", "IconBackpack", [["path", { "d": "M5 18v-6a6 6 0 0 1 6 -6h2a6 6 0 0 1 6 6v6a3 3 0 0 1 -3 3h-8a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M10 6v-1a2 2 0 1 1 4 0v1", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M11 10h2", "key": "svg-3" }]]);

var IconBackpack$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackpack
});

var IconBackslash = createReactComponent("outline", "backslash", "IconBackslash", [["path", { "d": "M7 5l10 14", "key": "svg-0" }]]);

var IconBackslash$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackslash
});

var IconBackspace = createReactComponent("outline", "backspace", "IconBackspace", [["path", { "d": "M20 6a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-11l-5 -5a1.5 1.5 0 0 1 0 -2l5 -5z", "key": "svg-0" }], ["path", { "d": "M12 10l4 4m0 -4l-4 4", "key": "svg-1" }]]);

var IconBackspace$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBackspace
});

var IconBadge2k = createReactComponent("outline", "badge-2k", "IconBadge2k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 9h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-4" }]]);

var IconBadge2k$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge2k
});

var IconBadge3d = createReactComponent("outline", "badge-3d", "IconBadge3d", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9h1.5a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1.5", "key": "svg-1" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2z", "key": "svg-2" }]]);

var IconBadge3d$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge3d
});

var IconBadge3k = createReactComponent("outline", "badge-3k", "IconBadge3k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 9.5a.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a.5 .5 0 0 1 -.5 -.5", "key": "svg-4" }]]);

var IconBadge3k$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge3k
});

var IconBadge4k = createReactComponent("outline", "badge-4k", "IconBadge4k", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9v2a1 1 0 0 0 1 1h1", "key": "svg-1" }], ["path", { "d": "M10 9v6", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-4" }], ["path", { "d": "M15 12h-1", "key": "svg-5" }]]);

var IconBadge4k$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge4k
});

var IconBadge5k = createReactComponent("outline", "badge-5k", "IconBadge5k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M7 15h2a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-2v-3h3", "key": "svg-4" }]]);

var IconBadge5k$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge5k
});

var IconBadge8k = createReactComponent("outline", "badge-8k", "IconBadge8k", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6", "key": "svg-1" }], ["path", { "d": "M17 9l-2 3l2 3", "key": "svg-2" }], ["path", { "d": "M15 12h-1", "key": "svg-3" }], ["path", { "d": "M8.5 12h-.5a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1zh-.5a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1", "key": "svg-4" }]]);

var IconBadge8k$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge8k
});

var IconBadgeAdOff = createReactComponent("outline", "badge-ad-off", "IconBadgeAdOff", [["path", { "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M14 14v1h1m2 -2v-2a2 2 0 0 0 -2 -2h-1v1", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.077 -1.385m.788 .762c.087 .19 .135 .4 .135 .623v4.5", "key": "svg-2" }], ["path", { "d": "M7 13h3", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBadgeAdOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeAdOff
});

var IconBadgeAd = createReactComponent("outline", "badge-ad", "IconBadgeAd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-2" }], ["path", { "d": "M7 13h3", "key": "svg-3" }]]);

var IconBadgeAd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeAd
});

var IconBadgeAr = createReactComponent("outline", "badge-ar", "IconBadgeAr", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-1" }], ["path", { "d": "M7 13h3", "key": "svg-2" }], ["path", { "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3", "key": "svg-3" }]]);

var IconBadgeAr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeAr
});

var IconBadgeCc = createReactComponent("outline", "badge-cc", "IconBadgeCc", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M10 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-1" }], ["path", { "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }]]);

var IconBadgeCc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeCc
});

var IconBadgeHd = createReactComponent("outline", "badge-hd", "IconBadgeHd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 15v-6", "key": "svg-2" }], ["path", { "d": "M10 15v-6", "key": "svg-3" }], ["path", { "d": "M7 12h3", "key": "svg-4" }]]);

var IconBadgeHd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeHd
});

var IconBadgeOff = createReactComponent("outline", "badge-off", "IconBadgeOff", [["path", { "d": "M7 7v10l5 3l5 -3m0 -4v-9l-5 3l-2.496 -1.497", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBadgeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeOff
});

var IconBadgeSd = createReactComponent("outline", "badge-sd", "IconBadgeSd", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z", "key": "svg-1" }], ["path", { "d": "M7 14.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-2" }]]);

var IconBadgeSd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeSd
});

var IconBadgeTm = createReactComponent("outline", "badge-tm", "IconBadgeTm", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 9h4", "key": "svg-1" }], ["path", { "d": "M8 9v6", "key": "svg-2" }], ["path", { "d": "M13 15v-6l2 3l2 -3v6", "key": "svg-3" }]]);

var IconBadgeTm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeTm
});

var IconBadgeVo = createReactComponent("outline", "badge-vo", "IconBadgeVo", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 9l2 6l2 -6", "key": "svg-1" }], ["path", { "d": "M15.5 9a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1 -3 0v-3a1.5 1.5 0 0 1 1.5 -1.5z", "key": "svg-2" }]]);

var IconBadgeVo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeVo
});

var IconBadgeVr = createReactComponent("outline", "badge-vr", "IconBadgeVr", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3", "key": "svg-1" }], ["path", { "d": "M7 9l2 6l2 -6", "key": "svg-2" }]]);

var IconBadgeVr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeVr
});

var IconBadgeWc = createReactComponent("outline", "badge-wc", "IconBadgeWc", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6.5 9l.5 6l2 -4l2 4l.5 -6", "key": "svg-1" }], ["path", { "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0", "key": "svg-2" }]]);

var IconBadgeWc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgeWc
});

var IconBadge = createReactComponent("outline", "badge", "IconBadge", [["path", { "d": "M17 17v-13l-5 3l-5 -3v13l5 3z", "key": "svg-0" }]]);

var IconBadge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadge
});

var IconBadgesOff = createReactComponent("outline", "badges-off", "IconBadgesOff", [["path", { "d": "M14.505 14.497l-2.505 1.503l-5 -3v4l5 3l5 -3", "key": "svg-0" }], ["path", { "d": "M13.873 9.876l3.127 -1.876v-4l-5 3l-2.492 -1.495m-2.508 1.495v1l2.492 1.495", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBadgesOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadgesOff
});

var IconBadges = createReactComponent("outline", "badges", "IconBadges", [["path", { "d": "M17 17v-4l-5 3l-5 -3v4l5 3z", "key": "svg-0" }], ["path", { "d": "M17 8v-4l-5 3l-5 -3v4l5 3z", "key": "svg-1" }]]);

var IconBadges$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBadges
});

var IconBaguette = createReactComponent("outline", "baguette", "IconBaguette", [["path", { "d": "M5.628 11.283l5.644 -5.637c2.665 -2.663 5.924 -3.747 8.663 -1.205l.188 .181a2.987 2.987 0 0 1 0 4.228l-11.287 11.274a3 3 0 0 1 -4.089 .135l-.143 -.135c-2.728 -2.724 -1.704 -6.117 1.024 -8.841z", "key": "svg-0" }], ["path", { "d": "M9.5 7.5l1.5 3.5", "key": "svg-1" }], ["path", { "d": "M6.5 10.5l1.5 3.5", "key": "svg-2" }], ["path", { "d": "M12.5 4.5l1.5 3.5", "key": "svg-3" }]]);

var IconBaguette$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBaguette
});

var IconBallAmericanFootballOff = createReactComponent("outline", "ball-american-football-off", "IconBallAmericanFootballOff", [["path", { "d": "M15 9l-1 1m-2 2l-3 3", "key": "svg-0" }], ["path", { "d": "M10 12l2 2", "key": "svg-1" }], ["path", { "d": "M8 21a5 5 0 0 0 -5 -5", "key": "svg-2" }], ["path", { "d": "M6.813 6.802a12.96 12.96 0 0 0 -3.813 9.198a5 5 0 0 0 5 5a12.96 12.96 0 0 0 9.186 -3.801m1.789 -2.227a12.94 12.94 0 0 0 2.025 -6.972a5 5 0 0 0 -5 -5a12.94 12.94 0 0 0 -6.967 2.022", "key": "svg-3" }], ["path", { "d": "M16 3a5 5 0 0 0 5 5", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBallAmericanFootballOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallAmericanFootballOff
});

var IconBallAmericanFootball = createReactComponent("outline", "ball-american-football", "IconBallAmericanFootball", [["path", { "d": "M15 9l-6 6", "key": "svg-0" }], ["path", { "d": "M10 12l2 2", "key": "svg-1" }], ["path", { "d": "M12 10l2 2", "key": "svg-2" }], ["path", { "d": "M8 21a5 5 0 0 0 -5 -5", "key": "svg-3" }], ["path", { "d": "M16 3c-7.18 0 -13 5.82 -13 13a5 5 0 0 0 5 5c7.18 0 13 -5.82 13 -13a5 5 0 0 0 -5 -5", "key": "svg-4" }], ["path", { "d": "M16 3a5 5 0 0 0 5 5", "key": "svg-5" }]]);

var IconBallAmericanFootball$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallAmericanFootball
});

var IconBallBaseball = createReactComponent("outline", "ball-baseball", "IconBallBaseball", [["path", { "d": "M5.636 18.364a9 9 0 1 0 12.728 -12.728a9 9 0 0 0 -12.728 12.728z", "key": "svg-0" }], ["path", { "d": "M12.495 3.02a9 9 0 0 1 -9.475 9.475", "key": "svg-1" }], ["path", { "d": "M20.98 11.505a9 9 0 0 0 -9.475 9.475", "key": "svg-2" }], ["path", { "d": "M9 9l2 2", "key": "svg-3" }], ["path", { "d": "M13 13l2 2", "key": "svg-4" }], ["path", { "d": "M11 7l2 1", "key": "svg-5" }], ["path", { "d": "M7 11l1 2", "key": "svg-6" }], ["path", { "d": "M16 11l1 2", "key": "svg-7" }], ["path", { "d": "M11 16l2 1", "key": "svg-8" }]]);

var IconBallBaseball$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallBaseball
});

var IconBallBasketball = createReactComponent("outline", "ball-basketball", "IconBallBasketball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M5.65 5.65l12.7 12.7", "key": "svg-1" }], ["path", { "d": "M5.65 18.35l12.7 -12.7", "key": "svg-2" }], ["path", { "d": "M12 3a9 9 0 0 0 9 9", "key": "svg-3" }], ["path", { "d": "M3 12a9 9 0 0 1 9 9", "key": "svg-4" }]]);

var IconBallBasketball$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallBasketball
});

var IconBallBowling = createReactComponent("outline", "ball-bowling", "IconBallBowling", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 9l0 .01", "key": "svg-1" }], ["path", { "d": "M15 8l0 .01", "key": "svg-2" }], ["path", { "d": "M14 12l0 .01", "key": "svg-3" }]]);

var IconBallBowling$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallBowling
});

var IconBallFootballOff = createReactComponent("outline", "ball-football-off", "IconBallFootballOff", [["path", { "d": "M20.041 16.046a9 9 0 0 0 -12.084 -12.09m-2.323 1.683a9 9 0 0 0 12.726 12.73", "key": "svg-0" }], ["path", { "d": "M12 7l4.755 3.455l-.566 1.743l-.98 3.014l-.209 .788h-6l-1.755 -5.545l1.86 -1.351l2.313 -1.681z", "key": "svg-1" }], ["path", { "d": "M12 7v-4", "key": "svg-2" }], ["path", { "d": "M15 16l2.5 3", "key": "svg-3" }], ["path", { "d": "M16.755 10.455l3.745 -1.455", "key": "svg-4" }], ["path", { "d": "M9.061 16.045l-2.561 2.955", "key": "svg-5" }], ["path", { "d": "M7.245 10.455l-3.745 -1.455", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBallFootballOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallFootballOff
});

var IconBallFootball = createReactComponent("outline", "ball-football", "IconBallFootball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7l4.76 3.45l-1.76 5.55h-6l-1.76 -5.55z", "key": "svg-1" }], ["path", { "d": "M12 7v-4m3 13l2.5 3m-.74 -8.55l3.74 -1.45m-11.44 7.05l-2.56 2.95m.74 -8.55l-3.74 -1.45", "key": "svg-2" }]]);

var IconBallFootball$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallFootball
});

var IconBallTennis = createReactComponent("outline", "ball-tennis", "IconBallTennis", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M6 5.3a9 9 0 0 1 0 13.4", "key": "svg-1" }], ["path", { "d": "M18 5.3a9 9 0 0 0 0 13.4", "key": "svg-2" }]]);

var IconBallTennis$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallTennis
});

var IconBallVolleyball = createReactComponent("outline", "ball-volleyball", "IconBallVolleyball", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12a8 8 0 0 0 8 4", "key": "svg-1" }], ["path", { "d": "M7.5 13.5a12 12 0 0 0 8.5 6.5", "key": "svg-2" }], ["path", { "d": "M12 12a8 8 0 0 0 -7.464 4.928", "key": "svg-3" }], ["path", { "d": "M12.951 7.353a12 12 0 0 0 -9.88 4.111", "key": "svg-4" }], ["path", { "d": "M12 12a8 8 0 0 0 -.536 -8.928", "key": "svg-5" }], ["path", { "d": "M15.549 15.147a12 12 0 0 0 1.38 -10.611", "key": "svg-6" }]]);

var IconBallVolleyball$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallVolleyball
});

var IconBalloonOff = createReactComponent("outline", "balloon-off", "IconBalloonOff", [["path", { "d": "M14 8a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M7.762 3.753a6 6 0 0 1 10.238 4.247c0 1.847 -.37 3.564 -1.007 4.993m-1.59 2.42c-.967 1 -2.14 1.587 -3.403 1.587c-3.314 0 -6 -4.03 -6 -9c0 -.593 .086 -1.166 .246 -1.707", "key": "svg-1" }], ["path", { "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBalloonOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBalloonOff
});

var IconBalloon = createReactComponent("outline", "balloon", "IconBalloon", [["path", { "d": "M14 8a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M6 8a6 6 0 1 1 12 0c0 4.97 -2.686 9 -6 9s-6 -4.03 -6 -9", "key": "svg-1" }], ["path", { "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2", "key": "svg-2" }]]);

var IconBalloon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBalloon
});

var IconBallpenOff = createReactComponent("outline", "ballpen-off", "IconBallpenOff", [["path", { "d": "M14 6l7 7l-2 2", "key": "svg-0" }], ["path", { "d": "M10 10l-4.172 4.172a2.828 2.828 0 1 0 4 4l4.172 -4.172", "key": "svg-1" }], ["path", { "d": "M16 12l4.414 -4.414a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-4.414 4.414", "key": "svg-2" }], ["path", { "d": "M4 20l1.768 -1.768", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBallpenOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallpenOff
});

var IconBallpen = createReactComponent("outline", "ballpen", "IconBallpen", [["path", { "d": "M14 6l7 7l-4 4", "key": "svg-0" }], ["path", { "d": "M5.828 18.172a2.828 2.828 0 0 0 4 0l10.586 -10.586a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-10.586 10.586a2.828 2.828 0 0 0 0 4z", "key": "svg-1" }], ["path", { "d": "M4 20l1.768 -1.768", "key": "svg-2" }]]);

var IconBallpen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBallpen
});

var IconBan = createReactComponent("outline", "ban", "IconBan", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M5.7 5.7l12.6 12.6", "key": "svg-1" }]]);

var IconBan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBan
});

var IconBandageOff = createReactComponent("outline", "bandage-off", "IconBandageOff", [["path", { "d": "M10 12v.01", "key": "svg-0" }], ["path", { "d": "M12 14v.01", "key": "svg-1" }], ["path", { "d": "M10.513 6.487l1.987 -1.987a4.95 4.95 0 0 1 7 7l-2.018 2.018m-1.982 1.982l-4 4a4.95 4.95 0 0 1 -7 -7l4 -4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBandageOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBandageOff
});

var IconBandage = createReactComponent("outline", "bandage", "IconBandage", [["path", { "d": "M14 12l0 .01", "key": "svg-0" }], ["path", { "d": "M10 12l0 .01", "key": "svg-1" }], ["path", { "d": "M12 10l0 .01", "key": "svg-2" }], ["path", { "d": "M12 14l0 .01", "key": "svg-3" }], ["path", { "d": "M4.5 12.5l8 -8a4.94 4.94 0 0 1 7 7l-8 8a4.94 4.94 0 0 1 -7 -7", "key": "svg-4" }]]);

var IconBandage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBandage
});

var IconBarbellOff = createReactComponent("outline", "barbell-off", "IconBarbellOff", [["path", { "d": "M2 12h1", "key": "svg-0" }], ["path", { "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2", "key": "svg-1" }], ["path", { "d": "M6.298 6.288a1 1 0 0 0 -.298 .712v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-8", "key": "svg-2" }], ["path", { "d": "M9 12h3", "key": "svg-3" }], ["path", { "d": "M15 15v2a1 1 0 0 0 1 1h1c.275 0 .523 -.11 .704 -.29m.296 -3.71v-7a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1v4", "key": "svg-4" }], ["path", { "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1", "key": "svg-5" }], ["path", { "d": "M22 12h-1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBarbellOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarbellOff
});

var IconBarbell = createReactComponent("outline", "barbell", "IconBarbell", [["path", { "d": "M2 12h1", "key": "svg-0" }], ["path", { "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2", "key": "svg-1" }], ["path", { "d": "M6 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z", "key": "svg-2" }], ["path", { "d": "M9 12h6", "key": "svg-3" }], ["path", { "d": "M15 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z", "key": "svg-4" }], ["path", { "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2", "key": "svg-5" }], ["path", { "d": "M22 12h-1", "key": "svg-6" }]]);

var IconBarbell$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarbell
});

var IconBarcodeOff = createReactComponent("outline", "barcode-off", "IconBarcodeOff", [["path", { "d": "M4 7v-1c0 -.552 .224 -1.052 .586 -1.414", "key": "svg-0" }], ["path", { "d": "M4 17v1a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M16 20h2c.551 0 1.05 -.223 1.412 -.584", "key": "svg-3" }], ["path", { "d": "M5 11h1v2h-1z", "key": "svg-4" }], ["path", { "d": "M10 11v2", "key": "svg-5" }], ["path", { "d": "M15 11v.01", "key": "svg-6" }], ["path", { "d": "M19 11v2", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBarcodeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarcodeOff
});

var IconBarcode = createReactComponent("outline", "barcode", "IconBarcode", [["path", { "d": "M4 7v-1a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 17v1a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-1", "key": "svg-3" }], ["path", { "d": "M5 11h1v2h-1z", "key": "svg-4" }], ["path", { "d": "M10 11l0 2", "key": "svg-5" }], ["path", { "d": "M14 11h1v2h-1z", "key": "svg-6" }], ["path", { "d": "M19 11l0 2", "key": "svg-7" }]]);

var IconBarcode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarcode
});

var IconBarrelOff = createReactComponent("outline", "barrel-off", "IconBarrelOff", [["path", { "d": "M8 4h8.722a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78a16.35 16.35 0 0 1 -.407 3.609m-.964 3.013l-.066 .158a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.21 .458 -4.42 1.374 -6.63", "key": "svg-0" }], ["path", { "d": "M14 4c.585 2.337 .913 4.674 .985 7.01m-.114 3.86a33.415 33.415 0 0 1 -.871 5.13", "key": "svg-1" }], ["path", { "d": "M10 4a34.42 34.42 0 0 0 -.366 1.632m-.506 3.501a32.126 32.126 0 0 0 -.128 2.867c0 2.667 .333 5.333 1 8", "key": "svg-2" }], ["path", { "d": "M4.5 16h11.5", "key": "svg-3" }], ["path", { "d": "M19.5 8h-7.5m-4 0h-3.5", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBarrelOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarrelOff
});

var IconBarrel = createReactComponent("outline", "barrel", "IconBarrel", [["path", { "d": "M7.278 4h9.444a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78c0 2.26 -.479 4.52 -1.437 6.78a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.26 .479 -4.52 1.437 -6.78a2 2 0 0 1 1.841 -1.22z", "key": "svg-0" }], ["path", { "d": "M14 4c.667 2.667 1 5.333 1 8s-.333 5.333 -1 8", "key": "svg-1" }], ["path", { "d": "M10 4c-.667 2.667 -1 5.333 -1 8s.333 5.333 1 8", "key": "svg-2" }], ["path", { "d": "M4.5 16h15", "key": "svg-3" }], ["path", { "d": "M19.5 8h-15", "key": "svg-4" }]]);

var IconBarrel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarrel
});

var IconBarrierBlockOff = createReactComponent("outline", "barrier-block-off", "IconBarrierBlockOff", [["path", { "d": "M11 7h8a1 1 0 0 1 1 1v7c0 .27 -.107 .516 -.282 .696", "key": "svg-0" }], ["path", { "d": "M16 16h-11a1 1 0 0 1 -1 -1v-7a1 1 0 0 1 1 -1h2", "key": "svg-1" }], ["path", { "d": "M7 16v4", "key": "svg-2" }], ["path", { "d": "M7.5 16l4.244 -4.244", "key": "svg-3" }], ["path", { "d": "M13.745 9.755l2.755 -2.755", "key": "svg-4" }], ["path", { "d": "M13.5 16l1.249 -1.249", "key": "svg-5" }], ["path", { "d": "M16.741 12.759l3.259 -3.259", "key": "svg-6" }], ["path", { "d": "M4 13.5l4.752 -4.752", "key": "svg-7" }], ["path", { "d": "M17 17v3", "key": "svg-8" }], ["path", { "d": "M5 20h4", "key": "svg-9" }], ["path", { "d": "M15 20h4", "key": "svg-10" }], ["path", { "d": "M17 7v-2", "key": "svg-11" }], ["path", { "d": "M3 3l18 18", "key": "svg-12" }]]);

var IconBarrierBlockOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarrierBlockOff
});

var IconBarrierBlock = createReactComponent("outline", "barrier-block", "IconBarrierBlock", [["path", { "d": "M4 7m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v7a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 16v4", "key": "svg-1" }], ["path", { "d": "M7.5 16l9 -9", "key": "svg-2" }], ["path", { "d": "M13.5 16l6.5 -6.5", "key": "svg-3" }], ["path", { "d": "M4 13.5l6.5 -6.5", "key": "svg-4" }], ["path", { "d": "M17 16v4", "key": "svg-5" }], ["path", { "d": "M5 20h4", "key": "svg-6" }], ["path", { "d": "M15 20h4", "key": "svg-7" }], ["path", { "d": "M17 7v-2", "key": "svg-8" }], ["path", { "d": "M7 7v-2", "key": "svg-9" }]]);

var IconBarrierBlock$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBarrierBlock
});

var IconBaselineDensityLarge = createReactComponent("outline", "baseline-density-large", "IconBaselineDensityLarge", [["path", { "d": "M4 4h16", "key": "svg-0" }], ["path", { "d": "M4 20h16", "key": "svg-1" }]]);

var IconBaselineDensityLarge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBaselineDensityLarge
});

var IconBaselineDensityMedium = createReactComponent("outline", "baseline-density-medium", "IconBaselineDensityMedium", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M4 12h16", "key": "svg-1" }], ["path", { "d": "M4 4h16", "key": "svg-2" }]]);

var IconBaselineDensityMedium$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBaselineDensityMedium
});

var IconBaselineDensitySmall = createReactComponent("outline", "baseline-density-small", "IconBaselineDensitySmall", [["path", { "d": "M4 3h16", "key": "svg-0" }], ["path", { "d": "M4 9h16", "key": "svg-1" }], ["path", { "d": "M4 15h16", "key": "svg-2" }], ["path", { "d": "M4 21h16", "key": "svg-3" }]]);

var IconBaselineDensitySmall$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBaselineDensitySmall
});

var IconBaseline = createReactComponent("outline", "baseline", "IconBaseline", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M8 16v-8a4 4 0 1 1 8 0v8", "key": "svg-1" }], ["path", { "d": "M8 10h8", "key": "svg-2" }]]);

var IconBaseline$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBaseline
});

var IconBasketBolt = createReactComponent("outline", "basket-bolt", "IconBasketBolt", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.358 2.04", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconBasketBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketBolt
});

var IconBasketCancel = createReactComponent("outline", "basket-cancel", "IconBasketCancel", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.3 1.713", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconBasketCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketCancel
});

var IconBasketCheck = createReactComponent("outline", "basket-check", "IconBasketCheck", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.479 2.729", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconBasketCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketCheck
});

var IconBasketCode = createReactComponent("outline", "basket-code", "IconBasketCode", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304c-.21 1.202 -.37 2.104 -.475 2.705", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconBasketCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketCode
});

var IconBasketCog = createReactComponent("outline", "basket-cog", "IconBasketCog", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.267 1.522", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconBasketCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketCog
});

var IconBasketDiscount = createReactComponent("outline", "basket-discount", "IconBasketDiscount", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12.5 20h-5.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.394 2.248", "key": "svg-2" }], ["path", { "d": "M13.856 13.254a2 2 0 1 0 -1.856 2.746", "key": "svg-3" }], ["path", { "d": "M16 21l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21v.01", "key": "svg-5" }], ["path", { "d": "M16 16v.01", "key": "svg-6" }]]);

var IconBasketDiscount$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketDiscount
});

var IconBasketDollar = createReactComponent("outline", "basket-dollar", "IconBasketDollar", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconBasketDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketDollar
});

var IconBasketDown = createReactComponent("outline", "basket-down", "IconBasketDown", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.349 1.989", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-5" }]]);

var IconBasketDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketDown
});

var IconBasketExclamation = createReactComponent("outline", "basket-exclamation", "IconBasketExclamation", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M15 20h-7.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.36 2.055", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 16v3", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }]]);

var IconBasketExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketExclamation
});

var IconBasketHeart = createReactComponent("outline", "basket-heart", "IconBasketHeart", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M10.5 20h-3.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.143 .817", "key": "svg-2" }], ["path", { "d": "M12.602 12.092a2 2 0 0 0 -2.233 3.066", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconBasketHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketHeart
});

var IconBasketMinus = createReactComponent("outline", "basket-minus", "IconBasketMinus", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.833 4.75", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconBasketMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketMinus
});

var IconBasketOff = createReactComponent("outline", "basket-off", "IconBasketOff", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l.75 -2.252m1.001 -3.002l.249 -.746", "key": "svg-1" }], ["path", { "d": "M12 8h7a2 2 0 0 1 1.977 2.304c-.442 2.516 -.756 4.438 -.977 5.696m-1.01 3.003a2.997 2.997 0 0 1 -2.234 .997h-9.512a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h2.999", "key": "svg-2" }], ["path", { "d": "M12 12a2 2 0 1 0 2 2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBasketOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketOff
});

var IconBasketPause = createReactComponent("outline", "basket-pause", "IconBasketPause", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13 20h-5.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.478 2.725", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconBasketPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketPause
});

var IconBasketPin = createReactComponent("outline", "basket-pin", "IconBasketPin", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.161 .92", "key": "svg-2" }], ["path", { "d": "M13.866 13.28a2 2 0 1 0 -1.866 2.72", "key": "svg-3" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-4" }], ["path", { "d": "M19 18v.01", "key": "svg-5" }]]);

var IconBasketPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketPin
});

var IconBasketPlus = createReactComponent("outline", "basket-plus", "IconBasketPlus", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.359 2.043", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconBasketPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketPlus
});

var IconBasketQuestion = createReactComponent("outline", "basket-question", "IconBasketQuestion", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M15 20h-7.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.161 .918", "key": "svg-2" }], ["path", { "d": "M12 16a2 2 0 1 0 0 -4a2 2 0 0 0 0 4z", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-5" }]]);

var IconBasketQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketQuestion
});

var IconBasketSearch = createReactComponent("outline", "basket-search", "IconBasketSearch", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M11 20h-3.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.215 1.227", "key": "svg-2" }], ["path", { "d": "M13.483 12.658a2 2 0 1 0 -2.162 3.224", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconBasketSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketSearch
});

var IconBasketShare = createReactComponent("outline", "basket-share", "IconBasketShare", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12.5 20h-5.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.478 2.723", "key": "svg-2" }], ["path", { "d": "M14 14a2 2 0 1 0 -2 2", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconBasketShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketShare
});

var IconBasketStar = createReactComponent("outline", "basket-star", "IconBasketStar", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M10.5 20h-3.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.133 .757", "key": "svg-2" }], ["path", { "d": "M13.596 12.794a2 2 0 0 0 -3.377 2.116", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconBasketStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketStar
});

var IconBasketUp = createReactComponent("outline", "basket-up", "IconBasketUp", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M12 20h-4.756a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.358 2.04", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconBasketUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketUp
});

var IconBasketX = createReactComponent("outline", "basket-x", "IconBasketX", [["path", { "d": "M17 10l-2 -6", "key": "svg-0" }], ["path", { "d": "M7 10l2 -6", "key": "svg-1" }], ["path", { "d": "M13.5 20h-6.256a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304h13.999a2 2 0 0 1 1.977 2.304l-.532 3.03", "key": "svg-2" }], ["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconBasketX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasketX
});

var IconBasket = createReactComponent("outline", "basket", "IconBasket", [["path", { "d": "M10 14a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M5.001 8h13.999a2 2 0 0 1 1.977 2.304l-1.255 7.152a3 3 0 0 1 -2.966 2.544h-9.512a3 3 0 0 1 -2.965 -2.544l-1.255 -7.152a2 2 0 0 1 1.977 -2.304z", "key": "svg-1" }], ["path", { "d": "M17 10l-2 -6", "key": "svg-2" }], ["path", { "d": "M7 10l2 -6", "key": "svg-3" }]]);

var IconBasket$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBasket
});

var IconBat = createReactComponent("outline", "bat", "IconBat", [["path", { "d": "M17 16c.74 -2.286 2.778 -3.762 5 -3c-.173 -2.595 .13 -5.314 -2 -7.5c-1.708 2.648 -3.358 2.557 -5 2.5v-4l-3 2l-3 -2v4c-1.642 .057 -3.292 .148 -5 -2.5c-2.13 2.186 -1.827 4.905 -2 7.5c2.222 -.762 4.26 .714 5 3c2.593 0 3.889 .952 5 4c1.111 -3.048 2.407 -4 5 -4z", "key": "svg-0" }], ["path", { "d": "M9 8a3 3 0 0 0 6 0", "key": "svg-1" }]]);

var IconBat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBat
});

var IconBathOff = createReactComponent("outline", "bath-off", "IconBathOff", [["path", { "d": "M16 12h4a1 1 0 0 1 1 1v3c0 .311 -.036 .614 -.103 .904m-1.61 2.378a3.982 3.982 0 0 1 -2.287 .718h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1h8", "key": "svg-0" }], ["path", { "d": "M6 12v-6m1.178 -2.824c.252 -.113 .53 -.176 .822 -.176h3v2.25", "key": "svg-1" }], ["path", { "d": "M4 21l1 -1.5", "key": "svg-2" }], ["path", { "d": "M20 21l-1 -1.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBathOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBathOff
});

var IconBath = createReactComponent("outline", "bath", "IconBath", [["path", { "d": "M4 12h16a1 1 0 0 1 1 1v3a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M6 12v-7a2 2 0 0 1 2 -2h3v2.25", "key": "svg-1" }], ["path", { "d": "M4 21l1 -1.5", "key": "svg-2" }], ["path", { "d": "M20 21l-1 -1.5", "key": "svg-3" }]]);

var IconBath$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBath
});

var IconBattery1 = createReactComponent("outline", "battery-1", "IconBattery1", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }]]);

var IconBattery1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBattery1
});

var IconBattery2 = createReactComponent("outline", "battery-2", "IconBattery2", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }]]);

var IconBattery2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBattery2
});

var IconBattery3 = createReactComponent("outline", "battery-3", "IconBattery3", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }], ["path", { "d": "M13 10l0 4", "key": "svg-3" }]]);

var IconBattery3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBattery3
});

var IconBattery4 = createReactComponent("outline", "battery-4", "IconBattery4", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7 10l0 4", "key": "svg-1" }], ["path", { "d": "M10 10l0 4", "key": "svg-2" }], ["path", { "d": "M13 10l0 4", "key": "svg-3" }], ["path", { "d": "M16 10l0 4", "key": "svg-4" }]]);

var IconBattery4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBattery4
});

var IconBatteryAutomotive = createReactComponent("outline", "battery-automotive", "IconBatteryAutomotive", [["path", { "d": "M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 5v-2", "key": "svg-1" }], ["path", { "d": "M18 3v2", "key": "svg-2" }], ["path", { "d": "M6.5 12h3", "key": "svg-3" }], ["path", { "d": "M14.5 12h3", "key": "svg-4" }], ["path", { "d": "M16 10.5v3", "key": "svg-5" }]]);

var IconBatteryAutomotive$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryAutomotive
});

var IconBatteryCharging2 = createReactComponent("outline", "battery-charging-2", "IconBatteryCharging2", [["path", { "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-4.5", "key": "svg-0" }], ["path", { "d": "M3 15h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2v-2z", "key": "svg-1" }], ["path", { "d": "M6 22v-3", "key": "svg-2" }], ["path", { "d": "M4 15v-2.5", "key": "svg-3" }], ["path", { "d": "M8 15v-2.5", "key": "svg-4" }]]);

var IconBatteryCharging2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryCharging2
});

var IconBatteryCharging = createReactComponent("outline", "battery-charging", "IconBatteryCharging", [["path", { "d": "M16 7h1a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-2", "key": "svg-0" }], ["path", { "d": "M8 7h-2a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1", "key": "svg-1" }], ["path", { "d": "M12 8l-2 4h3l-2 4", "key": "svg-2" }]]);

var IconBatteryCharging$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryCharging
});

var IconBatteryEco = createReactComponent("outline", "battery-eco", "IconBatteryEco", [["path", { "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-5.5", "key": "svg-0" }], ["path", { "d": "M3 16.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333v-.857z", "key": "svg-1" }], ["path", { "d": "M3 20v-3", "key": "svg-2" }]]);

var IconBatteryEco$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryEco
});

var IconBatteryExclamation = createReactComponent("outline", "battery-exclamation", "IconBatteryExclamation", [["path", { "d": "M9 17h8c1.105 0 2 -.895 2 -2v-.5c0 -.276 .224 -.5 .5 -.5s.5 -.224 .5 -.5v-3c0 -.276 -.224 -.5 -.5 -.5s-.5 -.224 -.5 -.5v-.5c0 -1.105 -.895 -2 -2 -2h-11c-1.105 0 -2 .895 -2 2v3", "key": "svg-0" }], ["path", { "d": "M5 16v3", "key": "svg-1" }], ["path", { "d": "M5 22v.01", "key": "svg-2" }]]);

var IconBatteryExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryExclamation
});

var IconBatteryOff = createReactComponent("outline", "battery-off", "IconBatteryOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M11 7h6a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5m-2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h1", "key": "svg-1" }]]);

var IconBatteryOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryOff
});

var IconBatterySpark = createReactComponent("outline", "battery-spark", "IconBatterySpark", [["path", { "d": "M12 17h-6a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v1", "key": "svg-0" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-1" }]]);

var IconBatterySpark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatterySpark
});

var IconBatteryVertical1 = createReactComponent("outline", "battery-vertical-1", "IconBatteryVertical1", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }]]);

var IconBatteryVertical1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVertical1
});

var IconBatteryVertical2 = createReactComponent("outline", "battery-vertical-2", "IconBatteryVertical2", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }]]);

var IconBatteryVertical2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVertical2
});

var IconBatteryVertical3 = createReactComponent("outline", "battery-vertical-3", "IconBatteryVertical3", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }]]);

var IconBatteryVertical3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVertical3
});

var IconBatteryVertical4 = createReactComponent("outline", "battery-vertical-4", "IconBatteryVertical4", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M10 17h4", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M10 11h4", "key": "svg-3" }], ["path", { "d": "M10 8h4", "key": "svg-4" }]]);

var IconBatteryVertical4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVertical4
});

var IconBatteryVerticalCharging2 = createReactComponent("outline", "battery-vertical-charging-2", "IconBatteryVerticalCharging2", [["path", { "d": "M7 18v-11c0 -1.105 .895 -2 2 -2h.5c.276 0 .5 -.224 .5 -.5s.224 -.5 .5 -.5h3c.276 0 .5 .224 .5 .5s.224 .5 .5 .5h.5c1.105 0 2 .895 2 2v1m-10 10c0 1.105 .895 2 2 2h1", "key": "svg-0" }], ["path", { "d": "M12 14h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M15 21v-3", "key": "svg-2" }], ["path", { "d": "M13 14v-2.5", "key": "svg-3" }], ["path", { "d": "M17 14v-2.5", "key": "svg-4" }]]);

var IconBatteryVerticalCharging2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVerticalCharging2
});

var IconBatteryVerticalCharging = createReactComponent("outline", "battery-vertical-charging", "IconBatteryVerticalCharging", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }], ["path", { "d": "M12.667 8l-2.667 4h4l-2.667 4", "key": "svg-1" }]]);

var IconBatteryVerticalCharging$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVerticalCharging
});

var IconBatteryVerticalEco = createReactComponent("outline", "battery-vertical-eco", "IconBatteryVerticalEco", [["path", { "d": "M7 18v-11c0 -1.105 .895 -2 2 -2h.5c.276 0 .5 -.224 .5 -.5s.224 -.5 .5 -.5h3c.276 0 .5 .224 .5 .5s.224 .5 .5 .5h.5c1.105 0 2 .895 2 2v1m-8 12c-1.105 0 -2 -.895 -2 -2", "key": "svg-0" }], ["path", { "d": "M13 17.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333z", "key": "svg-1" }], ["path", { "d": "M13 21v-3", "key": "svg-2" }]]);

var IconBatteryVerticalEco$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVerticalEco
});

var IconBatteryVerticalExclamation = createReactComponent("outline", "battery-vertical-exclamation", "IconBatteryVerticalExclamation", [["path", { "d": "M17 12v-5c0 -1.105 -.895 -2 -2 -2h-.5c-.276 0 -.5 -.224 -.5 -.5s-.224 -.5 -.5 -.5h-3c-.276 0 -.5 .224 -.5 .5s-.224 .5 -.5 .5h-.5c-1.105 0 -2 .895 -2 2v11c0 1.105 .895 2 2 2h6", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconBatteryVerticalExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVerticalExclamation
});

var IconBatteryVerticalOff = createReactComponent("outline", "battery-vertical-off", "IconBatteryVerticalOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M17 13v-6a2 2 0 0 0 -2 -2h-.5a.5 .5 0 0 1 -.5 -.5a.5 .5 0 0 0 -.5 -.5h-3a.5 .5 0 0 0 -.5 .5a.5 .5 0 0 1 -.5 .5h-.5m-2 2v11a2 2 0 0 0 2 2h6a2 2 0 0 0 2 -2v-1", "key": "svg-1" }]]);

var IconBatteryVerticalOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVerticalOff
});

var IconBatteryVertical = createReactComponent("outline", "battery-vertical", "IconBatteryVertical", [["path", { "d": "M7 18v-11a2 2 0 0 1 2 -2h.5a.5 .5 0 0 0 .5 -.5a.5 .5 0 0 1 .5 -.5h3a.5 .5 0 0 1 .5 .5a.5 .5 0 0 0 .5 .5h.5a2 2 0 0 1 2 2v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2", "key": "svg-0" }]]);

var IconBatteryVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBatteryVertical
});

var IconBattery = createReactComponent("outline", "battery", "IconBattery", [["path", { "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }]]);

var IconBattery$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBattery
});

var IconBeachOff = createReactComponent("outline", "beach-off", "IconBeachOff", [["path", { "d": "M15.071 15.102a7.502 7.502 0 0 0 -8.124 1.648", "key": "svg-0" }], ["path", { "d": "M10.27 6.269l9.926 5.731a6 6 0 0 0 -10.32 -6.123", "key": "svg-1" }], ["path", { "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196", "key": "svg-2" }], ["path", { "d": "M15 9l-.739 1.279", "key": "svg-3" }], ["path", { "d": "M12.794 12.82l-.794 1.376", "key": "svg-4" }], ["path", { "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1.135 -.858", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBeachOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBeachOff
});

var IconBeach = createReactComponent("outline", "beach", "IconBeach", [["path", { "d": "M17.553 16.75a7.5 7.5 0 0 0 -10.606 0", "key": "svg-0" }], ["path", { "d": "M18 3.804a6 6 0 0 0 -8.196 2.196l10.392 6a6 6 0 0 0 -2.196 -8.196z", "key": "svg-1" }], ["path", { "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196", "key": "svg-2" }], ["path", { "d": "M15 9l-3 5.196", "key": "svg-3" }], ["path", { "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 1 .25", "key": "svg-4" }]]);

var IconBeach$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBeach
});

var IconBedFlat = createReactComponent("outline", "bed-flat", "IconBedFlat", [["path", { "d": "M5 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M10 13h11v-2a3 3 0 0 0 -3 -3h-8v5z", "key": "svg-1" }], ["path", { "d": "M3 16h18", "key": "svg-2" }]]);

var IconBedFlat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBedFlat
});

var IconBedOff = createReactComponent("outline", "bed-off", "IconBedOff", [["path", { "d": "M7 7a2 2 0 1 0 2 2", "key": "svg-0" }], ["path", { "d": "M22 17v-3h-4m-4 0h-12", "key": "svg-1" }], ["path", { "d": "M2 8v9", "key": "svg-2" }], ["path", { "d": "M12 12v2h2m4 0h4v-2a3 3 0 0 0 -3 -3h-6", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBedOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBedOff
});

var IconBed = createReactComponent("outline", "bed", "IconBed", [["path", { "d": "M7 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M22 17v-3h-20", "key": "svg-1" }], ["path", { "d": "M2 8v9", "key": "svg-2" }], ["path", { "d": "M12 14h10v-2a3 3 0 0 0 -3 -3h-7v5z", "key": "svg-3" }]]);

var IconBed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBed
});

var IconBeerOff = createReactComponent("outline", "beer-off", "IconBeerOff", [["path", { "d": "M7 7v1.111c0 1.242 .29 2.467 .845 3.578l.31 .622a8 8 0 0 1 .845 3.578v4.111h6v-4.111a8 8 0 0 1 .045 -.85m.953 -3.035l.157 -.315a8 8 0 0 0 .845 -3.578v-4.111h-9", "key": "svg-0" }], ["path", { "d": "M7 8h1m4 0h5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBeerOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBeerOff
});

var IconBeer = createReactComponent("outline", "beer", "IconBeer", [["path", { "d": "M9 21h6a1 1 0 0 0 1 -1v-3.625c0 -1.397 .29 -2.775 .845 -4.025l.31 -.7c.556 -1.25 .845 -2.253 .845 -3.65v-4a1 1 0 0 0 -1 -1h-10a1 1 0 0 0 -1 1v4c0 1.397 .29 2.4 .845 3.65l.31 .7a9.931 9.931 0 0 1 .845 4.025v3.625a1 1 0 0 0 1 1z", "key": "svg-0" }], ["path", { "d": "M6 8h12", "key": "svg-1" }]]);

var IconBeer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBeer
});

var IconBellBolt = createReactComponent("outline", "bell-bolt", "IconBellBolt", [["path", { "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.368 2.67", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconBellBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellBolt
});

var IconBellCancel = createReactComponent("outline", "bell-cancel", "IconBellCancel", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconBellCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellCancel
});

var IconBellCheck = createReactComponent("outline", "bell-check", "IconBellCheck", [["path", { "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.016 .129 .037 .256 .065 .382", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.502 2.959", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconBellCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellCheck
});

var IconBellCode = createReactComponent("outline", "bell-code", "IconBellCode", [["path", { "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.498 2.958", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconBellCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellCode
});

var IconBellCog = createReactComponent("outline", "bell-cog", "IconBellCog", [["path", { "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v.5", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-8" }]]);

var IconBellCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellCog
});

var IconBellDollar = createReactComponent("outline", "bell-dollar", "IconBellDollar", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.911 5.17", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.02 2.822", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconBellDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellDollar
});

var IconBellDown = createReactComponent("outline", "bell-down", "IconBellDown", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.518 2.955", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconBellDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellDown
});

var IconBellExclamation = createReactComponent("outline", "bell-exclamation", "IconBellExclamation", [["path", { "d": "M15 17h-11a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1.5", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconBellExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellExclamation
});

var IconBellHeart = createReactComponent("outline", "bell-heart", "IconBellHeart", [["path", { "d": "M10 17h-6a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1c0 1.408 .97 2.59 2.28 2.913", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconBellHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellHeart
});

var IconBellMinus = createReactComponent("outline", "bell-minus", "IconBellMinus", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.047 .386 .149 .758 .3 1.107", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.504 2.958", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconBellMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellMinus
});

var IconBellOff = createReactComponent("outline", "bell-off", "IconBellOff", [["path", { "d": "M9.346 5.353c.21 -.129 .428 -.246 .654 -.353a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3m-1 3h-13a4 4 0 0 0 2 -3v-3a6.996 6.996 0 0 1 1.273 -3.707", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBellOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellOff
});

var IconBellPause = createReactComponent("outline", "bell-pause", "IconBellPause", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.022 2.821", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconBellPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellPause
});

var IconBellPin = createReactComponent("outline", "bell-pin", "IconBellPin", [["path", { "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.64 2.931", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconBellPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellPin
});

var IconBellPlus = createReactComponent("outline", "bell-plus", "IconBellPlus", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.51 2.957", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconBellPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellPlus
});

var IconBellQuestion = createReactComponent("outline", "bell-question", "IconBellQuestion", [["path", { "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 5.914 .716", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconBellQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellQuestion
});

var IconBellRinging2 = createReactComponent("outline", "bell-ringing-2", "IconBellRinging2", [["path", { "d": "M19.364 4.636a2 2 0 0 1 0 2.828a7 7 0 0 1 -1.414 7.072l-2.122 2.12a4 4 0 0 0 -.707 3.536l-11.313 -11.312a4 4 0 0 0 3.535 -.707l2.121 -2.123a7 7 0 0 1 7.072 -1.414a2 2 0 0 1 2.828 0z", "key": "svg-0" }], ["path", { "d": "M7.343 12.414l-.707 .707a3 3 0 0 0 4.243 4.243l.707 -.707", "key": "svg-1" }]]);

var IconBellRinging2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellRinging2
});

var IconBellRinging = createReactComponent("outline", "bell-ringing", "IconBellRinging", [["path", { "d": "M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M21 6.727a11.05 11.05 0 0 0 -2.794 -3.727", "key": "svg-2" }], ["path", { "d": "M3 6.727a11.05 11.05 0 0 1 2.792 -3.727", "key": "svg-3" }]]);

var IconBellRinging$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellRinging
});

var IconBellSchool = createReactComponent("outline", "bell-school", "IconBellSchool", [["path", { "d": "M10 10m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M13.5 15h.5a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-1a2 2 0 0 1 2 -2h.5", "key": "svg-1" }], ["path", { "d": "M16 17a5.698 5.698 0 0 0 4.467 -7.932l-.467 -1.068", "key": "svg-2" }], ["path", { "d": "M10 10v.01", "key": "svg-3" }], ["path", { "d": "M20 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBellSchool$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellSchool
});

var IconBellSearch = createReactComponent("outline", "bell-search", "IconBellSearch", [["path", { "d": "M11 17h-7a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.685 2.984", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconBellSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellSearch
});

var IconBellShare = createReactComponent("outline", "bell-share", "IconBellShare", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconBellShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellShare
});

var IconBellStar = createReactComponent("outline", "bell-star", "IconBellStar", [["path", { "d": "M9.5 17h-5.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.88 5", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 2.15 2.878", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconBellStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellStar
});

var IconBellUp = createReactComponent("outline", "bell-up", "IconBellUp", [["path", { "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 3.49 2.96", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconBellUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellUp
});

var IconBellX = createReactComponent("outline", "bell-x", "IconBellX", [["path", { "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 4.194 2.753", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconBellX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellX
});

var IconBellZ = createReactComponent("outline", "bell-z", "IconBellZ", [["path", { "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }], ["path", { "d": "M10 9h4l-4 4h4", "key": "svg-2" }]]);

var IconBellZ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBellZ
});

var IconBell = createReactComponent("outline", "bell", "IconBell", [["path", { "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6", "key": "svg-0" }], ["path", { "d": "M9 17v1a3 3 0 0 0 6 0v-1", "key": "svg-1" }]]);

var IconBell$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBell
});

var IconBeta = createReactComponent("outline", "beta", "IconBeta", [["path", { "d": "M8 22v-14a4 4 0 0 1 4 -4h.5a3.5 3.5 0 0 1 0 7h-.5h.5a4.5 4.5 0 1 1 -4.5 4.5v-.5", "key": "svg-0" }]]);

var IconBeta$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBeta
});

var IconBible = createReactComponent("outline", "bible", "IconBible", [["path", { "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z", "key": "svg-0" }], ["path", { "d": "M19 16h-12a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M12 7v6", "key": "svg-2" }], ["path", { "d": "M10 9h4", "key": "svg-3" }]]);

var IconBible$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBible
});

var IconBikeOff = createReactComponent("outline", "bike-off", "IconBikeOff", [["path", { "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M16.437 16.44a3 3 0 0 0 4.123 4.123m1.44 -2.563a3 3 0 0 0 -3 -3", "key": "svg-1" }], ["path", { "d": "M12 19v-4l-3 -3l1.665 -1.332m2.215 -1.772l1.12 -.896l2 3h3", "key": "svg-2" }], ["path", { "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBikeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBikeOff
});

var IconBike = createReactComponent("outline", "bike", "IconBike", [["path", { "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M19 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M12 19l0 -4l-3 -3l5 -4l2 3l3 0", "key": "svg-2" }], ["path", { "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBike$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBike
});

var IconBinaryOff = createReactComponent("outline", "binary-off", "IconBinaryOff", [["path", { "d": "M11 7v-2h-1", "key": "svg-0" }], ["path", { "d": "M18 19v-1", "key": "svg-1" }], ["path", { "d": "M15.5 5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z", "key": "svg-2" }], ["path", { "d": "M10.5 14h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z", "key": "svg-3" }], ["path", { "d": "M6 10v.01", "key": "svg-4" }], ["path", { "d": "M6 19v.01", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBinaryOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBinaryOff
});

var IconBinaryTree2 = createReactComponent("outline", "binary-tree-2", "IconBinaryTree2", [["path", { "d": "M14 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-0" }], ["path", { "d": "M7 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-1" }], ["path", { "d": "M21 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-2" }], ["path", { "d": "M14 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-3" }], ["path", { "d": "M12 8v8", "key": "svg-4" }], ["path", { "d": "M6.316 12.496l4.368 -4.992", "key": "svg-5" }], ["path", { "d": "M17.684 12.496l-4.366 -4.99", "key": "svg-6" }]]);

var IconBinaryTree2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBinaryTree2
});

var IconBinaryTree = createReactComponent("outline", "binary-tree", "IconBinaryTree", [["path", { "d": "M6 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-0" }], ["path", { "d": "M16 4a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-1" }], ["path", { "d": "M16 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-2" }], ["path", { "d": "M11 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-3" }], ["path", { "d": "M21 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z", "key": "svg-4" }], ["path", { "d": "M5.058 18.306l2.88 -4.606", "key": "svg-5" }], ["path", { "d": "M10.061 10.303l2.877 -4.604", "key": "svg-6" }], ["path", { "d": "M10.065 13.705l2.876 4.6", "key": "svg-7" }], ["path", { "d": "M15.063 5.7l2.881 4.61", "key": "svg-8" }]]);

var IconBinaryTree$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBinaryTree
});

var IconBinary = createReactComponent("outline", "binary", "IconBinary", [["path", { "d": "M11 10v-5h-1m8 14v-5h-1", "key": "svg-0" }], ["path", { "d": "M15 5m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-1" }], ["path", { "d": "M10 14m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-2" }], ["path", { "d": "M6 10h.01m-.01 9h.01", "key": "svg-3" }]]);

var IconBinary$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBinary
});

var IconBinoculars = createReactComponent("outline", "binoculars", "IconBinoculars", [["path", { "d": "M7 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M16.346 9.17l-.729 -1.261c-.16 -.248 -1.056 -.203 -1.117 .091l-.177 1.38", "key": "svg-2" }], ["path", { "d": "M19.761 14.813l-2.84 -5.133c-.189 -.31 -.592 -.68 -1.421 -.68c-.828 0 -1.5 .448 -1.5 1v6", "key": "svg-3" }], ["path", { "d": "M7.654 9.17l.729 -1.261c.16 -.249 1.056 -.203 1.117 .091l.177 1.38", "key": "svg-4" }], ["path", { "d": "M4.239 14.813l2.84 -5.133c.189 -.31 .592 -.68 1.421 -.68c.828 0 1.5 .448 1.5 1v6", "key": "svg-5" }], ["rect", { "width": "4", "height": "2", "x": "10", "y": "12", "key": "svg-6" }]]);

var IconBinoculars$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBinoculars
});

var IconBiohazardOff = createReactComponent("outline", "biohazard-off", "IconBiohazardOff", [["path", { "d": "M10.586 10.586a2 2 0 1 0 2.836 2.82", "key": "svg-0" }], ["path", { "d": "M11.939 14c0 .173 .048 .351 .056 .533v.217a4.75 4.75 0 0 1 -4.533 4.745h-.217", "key": "svg-1" }], ["path", { "d": "M2.495 14.745a4.75 4.75 0 0 1 7.737 -3.693", "key": "svg-2" }], ["path", { "d": "M16.745 19.495a4.75 4.75 0 0 1 -4.69 -5.503h-.06", "key": "svg-3" }], ["path", { "d": "M14.533 10.538a4.75 4.75 0 0 1 6.957 3.987v.217", "key": "svg-4" }], ["path", { "d": "M10.295 10.929a4.75 4.75 0 0 1 -2.988 -3.64m.66 -3.324a4.75 4.75 0 0 1 .5 -.66l.164 -.172", "key": "svg-5" }], ["path", { "d": "M15.349 3.133a4.75 4.75 0 0 1 -.836 7.385", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBiohazardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBiohazardOff
});

var IconBiohazard = createReactComponent("outline", "biohazard", "IconBiohazard", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11.939 14c0 .173 .048 .351 .056 .533l0 .217a4.75 4.75 0 0 1 -4.533 4.745l-.217 0m-4.75 -4.75a4.75 4.75 0 0 1 7.737 -3.693m6.513 8.443a4.75 4.75 0 0 1 -4.69 -5.503l-.06 0m1.764 -2.944a4.75 4.75 0 0 1 7.731 3.477l0 .217m-11.195 -3.813a4.75 4.75 0 0 1 -1.828 -7.624l.164 -.172m6.718 0a4.75 4.75 0 0 1 -1.665 7.798", "key": "svg-1" }]]);

var IconBiohazard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBiohazard
});

var IconBlade = createReactComponent("outline", "blade", "IconBlade", [["path", { "d": "M17.707 3.707l2.586 2.586a1 1 0 0 1 0 1.414l-.586 .586a1 1 0 0 0 0 1.414l.586 .586a1 1 0 0 1 0 1.414l-8.586 8.586a1 1 0 0 1 -1.414 0l-.586 -.586a1 1 0 0 0 -1.414 0l-.586 .586a1 1 0 0 1 -1.414 0l-2.586 -2.586a1 1 0 0 1 0 -1.414l.586 -.586a1 1 0 0 0 0 -1.414l-.586 -.586a1 1 0 0 1 0 -1.414l8.586 -8.586a1 1 0 0 1 1.414 0l.586 .586a1 1 0 0 0 1.414 0l.586 -.586a1 1 0 0 1 1.414 0z", "key": "svg-0" }], ["path", { "d": "M8 16l3.2 -3.2", "key": "svg-1" }], ["path", { "d": "M12.8 11.2l3.2 -3.2", "key": "svg-2" }], ["path", { "d": "M14 8l2 2", "key": "svg-3" }], ["path", { "d": "M8 14l2 2", "key": "svg-4" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBlade$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlade
});

var IconBleachChlorine = createReactComponent("outline", "bleach-chlorine", "IconBleachChlorine", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M11 12h-1a2 2 0 1 0 0 4h1", "key": "svg-1" }], ["path", { "d": "M14 12v4h2", "key": "svg-2" }]]);

var IconBleachChlorine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBleachChlorine
});

var IconBleachNoChlorine = createReactComponent("outline", "bleach-no-chlorine", "IconBleachNoChlorine", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M6.576 19l7.907 -13.733", "key": "svg-1" }], ["path", { "d": "M11.719 19.014l5.346 -9.284", "key": "svg-2" }]]);

var IconBleachNoChlorine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBleachNoChlorine
});

var IconBleachOff = createReactComponent("outline", "bleach-off", "IconBleachOff", [["path", { "d": "M5 19h14m1.986 -1.977a2 2 0 0 0 -.146 -.773l-7.1 -12.25a2 2 0 0 0 -3.5 0l-.815 1.405m-1.488 2.568l-4.797 8.277a2 2 0 0 0 1.75 2.75", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBleachOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBleachOff
});

var IconBleach = createReactComponent("outline", "bleach", "IconBleach", [["path", { "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75", "key": "svg-0" }]]);

var IconBleach$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBleach
});

var IconBlendMode = createReactComponent("outline", "blend-mode", "IconBlendMode", [["path", { "d": "M14.5 9.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-0" }], ["path", { "d": "M9.5 14.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-1" }]]);

var IconBlendMode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlendMode
});

var IconBlender = createReactComponent("outline", "blender", "IconBlender", [["path", { "d": "M9 10h-3a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1h10.802a1 1 0 0 1 .984 1.179l-1.786 9.821", "key": "svg-0" }], ["path", { "d": "M8 4l2 11", "key": "svg-1" }], ["path", { "d": "M11 15h4a3 3 0 0 1 3 3v2a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-2a3 3 0 0 1 3 -3z", "key": "svg-2" }], ["path", { "d": "M12 4v-1h2v1", "key": "svg-3" }], ["path", { "d": "M13 18v.01", "key": "svg-4" }]]);

var IconBlender$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlender
});

var IconBlob = createReactComponent("outline", "blob", "IconBlob", [["path", { "d": "M5.897 20.188c1.67 .752 3.896 .812 6.103 .812s4.434 -.059 6.104 -.812c.868 -.392 1.614 -.982 2.133 -1.856c.514 -.865 .763 -1.94 .763 -3.234c0 -2.577 -.983 -5.315 -2.557 -7.416c-1.57 -2.094 -3.833 -3.682 -6.443 -3.682s-4.873 1.588 -6.443 3.682c-1.574 2.101 -2.557 4.84 -2.557 7.416c0 1.295 .249 2.369 .763 3.234c.519 .874 1.265 1.464 2.134 1.856", "key": "svg-0" }]]);

var IconBlob$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlob
});

var IconBlockquote = createReactComponent("outline", "blockquote", "IconBlockquote", [["path", { "d": "M6 15h15", "key": "svg-0" }], ["path", { "d": "M21 19h-15", "key": "svg-1" }], ["path", { "d": "M15 11h6", "key": "svg-2" }], ["path", { "d": "M21 7h-6", "key": "svg-3" }], ["path", { "d": "M9 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2", "key": "svg-4" }], ["path", { "d": "M3 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2", "key": "svg-5" }]]);

var IconBlockquote$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlockquote
});

var IconBlocks = createReactComponent("outline", "blocks", "IconBlocks", [["path", { "d": "M14 4a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 14h12a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h3a2 2 0 0 1 2 2v12", "key": "svg-1" }]]);

var IconBlocks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlocks
});

var IconBluetoothConnected = createReactComponent("outline", "bluetooth-connected", "IconBluetoothConnected", [["path", { "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8", "key": "svg-0" }], ["path", { "d": "M4 12l1 0", "key": "svg-1" }], ["path", { "d": "M18 12l1 0", "key": "svg-2" }]]);

var IconBluetoothConnected$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBluetoothConnected
});

var IconBluetoothOff = createReactComponent("outline", "bluetooth-off", "IconBluetoothOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M16.438 16.45l-4.438 3.55v-8m0 -4v-4l5 4l-2.776 2.22m-2.222 1.779l-5 4", "key": "svg-1" }]]);

var IconBluetoothOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBluetoothOff
});

var IconBluetoothX = createReactComponent("outline", "bluetooth-x", "IconBluetoothX", [["path", { "d": "M7 8l10 8l-5 4v-16l1 .802m0 6.396l-6 4.802", "key": "svg-0" }], ["path", { "d": "M16 6l4 4", "key": "svg-1" }], ["path", { "d": "M20 6l-4 4", "key": "svg-2" }]]);

var IconBluetoothX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBluetoothX
});

var IconBluetooth = createReactComponent("outline", "bluetooth", "IconBluetooth", [["path", { "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8", "key": "svg-0" }]]);

var IconBluetooth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBluetooth
});

var IconBlurOff = createReactComponent("outline", "blur-off", "IconBlurOff", [["path", { "d": "M12 3v5m0 4v8", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M16 12h5", "key": "svg-2" }], ["path", { "d": "M13 9h7", "key": "svg-3" }], ["path", { "d": "M12 6h6", "key": "svg-4" }], ["path", { "d": "M12 18h6", "key": "svg-5" }], ["path", { "d": "M12 15h3m4 0h1", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBlurOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlurOff
});

var IconBlur = createReactComponent("outline", "blur", "IconBlur", [["path", { "d": "M12 21a9.01 9.01 0 0 0 2.32 -.302a9 9 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z", "key": "svg-0" }], ["path", { "d": "M12 3v17", "key": "svg-1" }], ["path", { "d": "M12 12h9", "key": "svg-2" }], ["path", { "d": "M12 9h8", "key": "svg-3" }], ["path", { "d": "M12 6h6", "key": "svg-4" }], ["path", { "d": "M12 18h6", "key": "svg-5" }], ["path", { "d": "M12 15h8", "key": "svg-6" }]]);

var IconBlur$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBlur
});

var IconBmp = createReactComponent("outline", "bmp", "IconBmp", [["path", { "d": "M18 16v-8h2a2 2 0 1 1 0 4h-2", "key": "svg-0" }], ["path", { "d": "M6 14a2 2 0 0 1 -2 2h-2v-8h2a2 2 0 1 1 0 4h-2h2a2 2 0 0 1 2 2z", "key": "svg-1" }], ["path", { "d": "M9 16v-8l3 6l3 -6v8", "key": "svg-2" }]]);

var IconBmp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBmp
});

var IconBodyScan = createReactComponent("outline", "body-scan", "IconBodyScan", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M10 17v-1a2 2 0 1 1 4 0v1", "key": "svg-5" }], ["path", { "d": "M8 10c.666 .666 1.334 1 2 1h4c.666 0 1.334 -.334 2 -1", "key": "svg-6" }], ["path", { "d": "M12 11v3", "key": "svg-7" }]]);

var IconBodyScan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBodyScan
});

var IconBoldOff = createReactComponent("outline", "bold-off", "IconBoldOff", [["path", { "d": "M9 5h4a3.5 3.5 0 0 1 2.222 6.204m-3.222 .796h-5v-5", "key": "svg-0" }], ["path", { "d": "M17.107 17.112a3.5 3.5 0 0 1 -3.107 1.888h-7v-7", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBoldOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoldOff
});

var IconBold = createReactComponent("outline", "bold", "IconBold", [["path", { "d": "M7 5h6a3.5 3.5 0 0 1 0 7h-6z", "key": "svg-0" }], ["path", { "d": "M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7", "key": "svg-1" }]]);

var IconBold$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBold
});

var IconBoltOff = createReactComponent("outline", "bolt-off", "IconBoltOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M15.212 15.21l-4.212 5.79v-7h-6l3.79 -5.21m1.685 -2.32l2.525 -3.47v6m1 1h5l-2.104 2.893", "key": "svg-1" }]]);

var IconBoltOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoltOff
});

var IconBolt = createReactComponent("outline", "bolt", "IconBolt", [["path", { "d": "M13 3l0 7l6 0l-8 11l0 -7l-6 0l8 -11", "key": "svg-0" }]]);

var IconBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBolt
});

var IconBomb = createReactComponent("outline", "bomb", "IconBomb", [["path", { "d": "M15.349 5.349l3.301 3.301a1.2 1.2 0 0 1 0 1.698l-.972 .972a7.5 7.5 0 1 1 -5 -5l.972 -.972a1.2 1.2 0 0 1 1.698 0z", "key": "svg-0" }], ["path", { "d": "M17 7l1.293 -1.293a2.414 2.414 0 0 0 .707 -1.707a1 1 0 0 1 1 -1h1", "key": "svg-1" }], ["path", { "d": "M7 13a3 3 0 0 1 3 -3", "key": "svg-2" }]]);

var IconBomb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBomb
});

var IconBoneOff = createReactComponent("outline", "bone-off", "IconBoneOff", [["path", { "d": "M12.5 8.502l.38 -.38a3 3 0 1 1 5.12 -2.122a3 3 0 1 1 -2.12 5.122l-.372 .372m-2.008 2.008l-2.378 2.378a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l2.378 -2.378", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBoneOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoneOff
});

var IconBone = createReactComponent("outline", "bone", "IconBone", [["path", { "d": "M15 3a3 3 0 0 1 3 3a3 3 0 1 1 -2.12 5.122l-4.758 4.758a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l4.758 -4.758a3 3 0 0 1 2.12 -5.122z", "key": "svg-0" }]]);

var IconBone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBone
});

var IconBongOff = createReactComponent("outline", "bong-off", "IconBongOff", [["path", { "d": "M9 5v-2h4v6m1.5 1.5l2.5 -2.5l2 2l-2.5 2.5m-.5 3.505a5 5 0 1 1 -7 -4.589v-2.416", "key": "svg-0" }], ["path", { "d": "M8 3h6", "key": "svg-1" }], ["path", { "d": "M6.1 17h9.8", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBongOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBongOff
});

var IconBong = createReactComponent("outline", "bong", "IconBong", [["path", { "d": "M13 3v8.416c.134 .059 .265 .123 .393 .193l3.607 -3.609l2 2l-3.608 3.608a5 5 0 1 1 -6.392 -2.192v-8.416h4z", "key": "svg-0" }], ["path", { "d": "M8 3h6", "key": "svg-1" }], ["path", { "d": "M6.1 17h9.8", "key": "svg-2" }]]);

var IconBong$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBong
});

var IconBook2 = createReactComponent("outline", "book-2", "IconBook2", [["path", { "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z", "key": "svg-0" }], ["path", { "d": "M19 16h-12a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M9 8h6", "key": "svg-2" }]]);

var IconBook2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBook2
});

var IconBookDownload = createReactComponent("outline", "book-download", "IconBookDownload", [["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5", "key": "svg-0" }], ["path", { "d": "M13 16h-7a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M15 19l3 3l3 -3", "key": "svg-2" }], ["path", { "d": "M18 22v-9", "key": "svg-3" }]]);

var IconBookDownload$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookDownload
});

var IconBookOff = createReactComponent("outline", "book-off", "IconBookOff", [["path", { "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 5.899 -1.096", "key": "svg-0" }], ["path", { "d": "M3 6a9 9 0 0 1 2.114 -.884m3.8 -.21c1.07 .17 2.116 .534 3.086 1.094a9 9 0 0 1 9 0", "key": "svg-1" }], ["path", { "d": "M3 6v13", "key": "svg-2" }], ["path", { "d": "M12 6v2m0 4v7", "key": "svg-3" }], ["path", { "d": "M21 6v11", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBookOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookOff
});

var IconBookUpload = createReactComponent("outline", "book-upload", "IconBookUpload", [["path", { "d": "M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5", "key": "svg-0" }], ["path", { "d": "M11 16h-5a2 2 0 0 0 -2 2", "key": "svg-1" }], ["path", { "d": "M15 16l3 -3l3 3", "key": "svg-2" }], ["path", { "d": "M18 13v9", "key": "svg-3" }]]);

var IconBookUpload$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookUpload
});

var IconBook = createReactComponent("outline", "book", "IconBook", [["path", { "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0", "key": "svg-0" }], ["path", { "d": "M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0", "key": "svg-1" }], ["path", { "d": "M3 6l0 13", "key": "svg-2" }], ["path", { "d": "M12 6l0 13", "key": "svg-3" }], ["path", { "d": "M21 6l0 13", "key": "svg-4" }]]);

var IconBook$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBook
});

var IconBookmarkAi = createReactComponent("outline", "bookmark-ai", "IconBookmarkAi", [["path", { "d": "M10.02 18.32l-4.02 2.68v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4.5", "key": "svg-0" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M14 19h4", "key": "svg-2" }], ["path", { "d": "M21 15v6", "key": "svg-3" }]]);

var IconBookmarkAi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkAi
});

var IconBookmarkEdit = createReactComponent("outline", "bookmark-edit", "IconBookmarkEdit", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 1 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-1" }]]);

var IconBookmarkEdit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkEdit
});

var IconBookmarkMinus = createReactComponent("outline", "bookmark-minus", "IconBookmarkMinus", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v8", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconBookmarkMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkMinus
});

var IconBookmarkOff = createReactComponent("outline", "bookmark-off", "IconBookmarkOff", [["path", { "d": "M7.708 3.721a3.982 3.982 0 0 1 2.292 -.721h4a4 4 0 0 1 4 4v7m0 4v3l-6 -4l-6 4v-14c0 -.308 .035 -.609 .1 -.897", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBookmarkOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkOff
});

var IconBookmarkPlus = createReactComponent("outline", "bookmark-plus", "IconBookmarkPlus", [["path", { "d": "M12 17l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v5", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconBookmarkPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkPlus
});

var IconBookmarkQuestion = createReactComponent("outline", "bookmark-question", "IconBookmarkQuestion", [["path", { "d": "M15 19l-3 -2l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconBookmarkQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarkQuestion
});

var IconBookmark = createReactComponent("outline", "bookmark", "IconBookmark", [["path", { "d": "M18 7v14l-6 -4l-6 4v-14a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4z", "key": "svg-0" }]]);

var IconBookmark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmark
});

var IconBookmarksOff = createReactComponent("outline", "bookmarks-off", "IconBookmarksOff", [["path", { "d": "M11 7h2a2 2 0 0 1 2 2v2m0 4v6l-5 -3l-5 3v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v10", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBookmarksOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarksOff
});

var IconBookmarks = createReactComponent("outline", "bookmarks", "IconBookmarks", [["path", { "d": "M15 10v11l-5 -3l-5 3v-11a3 3 0 0 1 3 -3h4a3 3 0 0 1 3 3z", "key": "svg-0" }], ["path", { "d": "M11 3h5a3 3 0 0 1 3 3v11", "key": "svg-1" }]]);

var IconBookmarks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBookmarks
});

var IconBooksOff = createReactComponent("outline", "books-off", "IconBooksOff", [["path", { "d": "M9 9v10a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-14", "key": "svg-0" }], ["path", { "d": "M8 4a1 1 0 0 1 1 1", "key": "svg-1" }], ["path", { "d": "M9 5a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4", "key": "svg-2" }], ["path", { "d": "M13 13v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-10", "key": "svg-3" }], ["path", { "d": "M5 8h3", "key": "svg-4" }], ["path", { "d": "M9 16h4", "key": "svg-5" }], ["path", { "d": "M14.254 10.244l-1.218 -4.424a1.02 1.02 0 0 1 .634 -1.219l.133 -.041l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.236 11.75", "key": "svg-6" }], ["path", { "d": "M19.585 19.589l-1.572 .38c-.562 .136 -1.133 -.19 -1.282 -.731l-.952 -3.458", "key": "svg-7" }], ["path", { "d": "M14 9l4 -1", "key": "svg-8" }], ["path", { "d": "M19.207 15.199l.716 -.18", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconBooksOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBooksOff
});

var IconBooks = createReactComponent("outline", "books", "IconBooks", [["path", { "d": "M5 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M5 8h4", "key": "svg-2" }], ["path", { "d": "M9 16h4", "key": "svg-3" }], ["path", { "d": "M13.803 4.56l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.695 13.418a1.02 1.02 0 0 1 -.634 1.219l-.133 .041l-2.184 .53c-.562 .135 -1.133 -.19 -1.282 -.732l-3.695 -13.418a1.02 1.02 0 0 1 .634 -1.219l.133 -.041z", "key": "svg-4" }], ["path", { "d": "M14 9l4 -1", "key": "svg-5" }], ["path", { "d": "M16 16l3.923 -.98", "key": "svg-6" }]]);

var IconBooks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBooks
});

var IconBoom = createReactComponent("outline", "boom", "IconBoom", [["path", { "d": "M3 9.662c2 2.338 2 4.338 0 6.338c3 .5 4.5 1 5 4c2 -3 6 -4 9 0c0 -3 1 -4 4 -4.004q -3 -2.995 0 -5.996c-3 0 -5 -2 -5 -5c-2 4 -5 3 -7.5 -1c-.5 3 -2.5 5 -5.5 5.662", "key": "svg-0" }]]);

var IconBoom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoom
});

var IconBorderAll = createReactComponent("outline", "border-all", "IconBorderAll", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M4 12l16 0", "key": "svg-1" }], ["path", { "d": "M12 4l0 16", "key": "svg-2" }]]);

var IconBorderAll$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderAll
});

var IconBorderBottomPlus = createReactComponent("outline", "border-bottom-plus", "IconBorderBottomPlus", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M4 16v-.01", "key": "svg-1" }], ["path", { "d": "M20 16v-.01", "key": "svg-2" }], ["path", { "d": "M4 12v-.01", "key": "svg-3" }], ["path", { "d": "M20 12v-.01", "key": "svg-4" }], ["path", { "d": "M4 8v-.01", "key": "svg-5" }], ["path", { "d": "M20 8v-.01", "key": "svg-6" }], ["path", { "d": "M4 4v-.01", "key": "svg-7" }], ["path", { "d": "M8 4v-.01", "key": "svg-8" }], ["path", { "d": "M12 4v-.01", "key": "svg-9" }], ["path", { "d": "M16 4v-.01", "key": "svg-10" }], ["path", { "d": "M20 4v-.01", "key": "svg-11" }], ["path", { "d": "M15 12h-6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderBottomPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderBottomPlus
});

var IconBorderBottom = createReactComponent("outline", "border-bottom", "IconBorderBottom", [["path", { "d": "M20 20l-16 0", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M12 8l0 .01", "key": "svg-7" }], ["path", { "d": "M20 8l0 .01", "key": "svg-8" }], ["path", { "d": "M4 12l0 .01", "key": "svg-9" }], ["path", { "d": "M8 12l0 .01", "key": "svg-10" }], ["path", { "d": "M12 12l0 .01", "key": "svg-11" }], ["path", { "d": "M16 12l0 .01", "key": "svg-12" }], ["path", { "d": "M20 12l0 .01", "key": "svg-13" }], ["path", { "d": "M4 16l0 .01", "key": "svg-14" }], ["path", { "d": "M12 16l0 .01", "key": "svg-15" }], ["path", { "d": "M20 16l0 .01", "key": "svg-16" }]]);

var IconBorderBottom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderBottom
});

var IconBorderCornerIos = createReactComponent("outline", "border-corner-ios", "IconBorderCornerIos", [["path", { "d": "M4 20c0 -6.559 0 -9.838 1.628 -12.162a9 9 0 0 1 2.21 -2.21c2.324 -1.628 5.602 -1.628 12.162 -1.628", "key": "svg-0" }]]);

var IconBorderCornerIos$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderCornerIos
});

var IconBorderCornerPill = createReactComponent("outline", "border-corner-pill", "IconBorderCornerPill", [["path", { "d": "M4 20v-5c0 -6.075 4.925 -11 11 -11h5", "key": "svg-0" }]]);

var IconBorderCornerPill$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderCornerPill
});

var IconBorderCornerRounded = createReactComponent("outline", "border-corner-rounded", "IconBorderCornerRounded", [["path", { "d": "M4 20v-10a6 6 0 0 1 6 -6h10", "key": "svg-0" }]]);

var IconBorderCornerRounded$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderCornerRounded
});

var IconBorderCornerSquare = createReactComponent("outline", "border-corner-square", "IconBorderCornerSquare", [["path", { "d": "M4 20v-15a1 1 0 0 1 1 -1h15", "key": "svg-0" }]]);

var IconBorderCornerSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderCornerSquare
});

var IconBorderCorners = createReactComponent("outline", "border-corners", "IconBorderCorners", [["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M20 16v2a2 2 0 0 1 -2 2h-2", "key": "svg-1" }], ["path", { "d": "M8 20h-2a2 2 0 0 1 -2 -2v-2", "key": "svg-2" }], ["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBorderCorners$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderCorners
});

var IconBorderHorizontal = createReactComponent("outline", "border-horizontal", "IconBorderHorizontal", [["path", { "d": "M4 12l16 0", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M12 8l0 .01", "key": "svg-7" }], ["path", { "d": "M20 8l0 .01", "key": "svg-8" }], ["path", { "d": "M4 16l0 .01", "key": "svg-9" }], ["path", { "d": "M12 16l0 .01", "key": "svg-10" }], ["path", { "d": "M20 16l0 .01", "key": "svg-11" }], ["path", { "d": "M4 20l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderHorizontal
});

var IconBorderInner = createReactComponent("outline", "border-inner", "IconBorderInner", [["path", { "d": "M4 12l16 0", "key": "svg-0" }], ["path", { "d": "M12 4l0 16", "key": "svg-1" }], ["path", { "d": "M4 4l0 .01", "key": "svg-2" }], ["path", { "d": "M8 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M20 4l0 .01", "key": "svg-5" }], ["path", { "d": "M4 8l0 .01", "key": "svg-6" }], ["path", { "d": "M20 8l0 .01", "key": "svg-7" }], ["path", { "d": "M4 16l0 .01", "key": "svg-8" }], ["path", { "d": "M20 16l0 .01", "key": "svg-9" }], ["path", { "d": "M4 20l0 .01", "key": "svg-10" }], ["path", { "d": "M8 20l0 .01", "key": "svg-11" }], ["path", { "d": "M16 20l0 .01", "key": "svg-12" }], ["path", { "d": "M20 20l0 .01", "key": "svg-13" }]]);

var IconBorderInner$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderInner
});

var IconBorderLeftPlus = createReactComponent("outline", "border-left-plus", "IconBorderLeftPlus", [["path", { "d": "M4 20v-16", "key": "svg-0" }], ["path", { "d": "M8 4v.01", "key": "svg-1" }], ["path", { "d": "M12 4v.01", "key": "svg-2" }], ["path", { "d": "M16 4v.01", "key": "svg-3" }], ["path", { "d": "M20 4v.01", "key": "svg-4" }], ["path", { "d": "M20 8v.01", "key": "svg-5" }], ["path", { "d": "M20 12v.01", "key": "svg-6" }], ["path", { "d": "M20 16v.01", "key": "svg-7" }], ["path", { "d": "M8 20v.01", "key": "svg-8" }], ["path", { "d": "M12 20v.01", "key": "svg-9" }], ["path", { "d": "M16 20v.01", "key": "svg-10" }], ["path", { "d": "M20 20v.01", "key": "svg-11" }], ["path", { "d": "M9 12h6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderLeftPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderLeftPlus
});

var IconBorderLeft = createReactComponent("outline", "border-left", "IconBorderLeft", [["path", { "d": "M4 20l0 -16", "key": "svg-0" }], ["path", { "d": "M8 4l0 .01", "key": "svg-1" }], ["path", { "d": "M12 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M12 8l0 .01", "key": "svg-5" }], ["path", { "d": "M20 8l0 .01", "key": "svg-6" }], ["path", { "d": "M8 12l0 .01", "key": "svg-7" }], ["path", { "d": "M12 12l0 .01", "key": "svg-8" }], ["path", { "d": "M16 12l0 .01", "key": "svg-9" }], ["path", { "d": "M20 12l0 .01", "key": "svg-10" }], ["path", { "d": "M12 16l0 .01", "key": "svg-11" }], ["path", { "d": "M20 16l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderLeft
});

var IconBorderNone = createReactComponent("outline", "border-none", "IconBorderNone", [["path", { "d": "M4 4l0 .01", "key": "svg-0" }], ["path", { "d": "M8 4l0 .01", "key": "svg-1" }], ["path", { "d": "M12 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M12 8l0 .01", "key": "svg-6" }], ["path", { "d": "M20 8l0 .01", "key": "svg-7" }], ["path", { "d": "M4 12l0 .01", "key": "svg-8" }], ["path", { "d": "M8 12l0 .01", "key": "svg-9" }], ["path", { "d": "M12 12l0 .01", "key": "svg-10" }], ["path", { "d": "M16 12l0 .01", "key": "svg-11" }], ["path", { "d": "M20 12l0 .01", "key": "svg-12" }], ["path", { "d": "M4 16l0 .01", "key": "svg-13" }], ["path", { "d": "M12 16l0 .01", "key": "svg-14" }], ["path", { "d": "M20 16l0 .01", "key": "svg-15" }], ["path", { "d": "M4 20l0 .01", "key": "svg-16" }], ["path", { "d": "M8 20l0 .01", "key": "svg-17" }], ["path", { "d": "M12 20l0 .01", "key": "svg-18" }], ["path", { "d": "M16 20l0 .01", "key": "svg-19" }], ["path", { "d": "M20 20l0 .01", "key": "svg-20" }]]);

var IconBorderNone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderNone
});

var IconBorderOuter = createReactComponent("outline", "border-outer", "IconBorderOuter", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 8l0 .01", "key": "svg-1" }], ["path", { "d": "M8 12l0 .01", "key": "svg-2" }], ["path", { "d": "M12 12l0 .01", "key": "svg-3" }], ["path", { "d": "M16 12l0 .01", "key": "svg-4" }], ["path", { "d": "M12 16l0 .01", "key": "svg-5" }]]);

var IconBorderOuter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderOuter
});

var IconBorderRadius = createReactComponent("outline", "border-radius", "IconBorderRadius", [["path", { "d": "M4 12v-4a4 4 0 0 1 4 -4h4", "key": "svg-0" }], ["path", { "d": "M16 4l0 .01", "key": "svg-1" }], ["path", { "d": "M20 4l0 .01", "key": "svg-2" }], ["path", { "d": "M20 8l0 .01", "key": "svg-3" }], ["path", { "d": "M20 12l0 .01", "key": "svg-4" }], ["path", { "d": "M4 16l0 .01", "key": "svg-5" }], ["path", { "d": "M20 16l0 .01", "key": "svg-6" }], ["path", { "d": "M4 20l0 .01", "key": "svg-7" }], ["path", { "d": "M8 20l0 .01", "key": "svg-8" }], ["path", { "d": "M12 20l0 .01", "key": "svg-9" }], ["path", { "d": "M16 20l0 .01", "key": "svg-10" }], ["path", { "d": "M20 20l0 .01", "key": "svg-11" }]]);

var IconBorderRadius$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderRadius
});

var IconBorderRightPlus = createReactComponent("outline", "border-right-plus", "IconBorderRightPlus", [["path", { "d": "M20 20v-16", "key": "svg-0" }], ["path", { "d": "M16 4v.01", "key": "svg-1" }], ["path", { "d": "M12 4v.01", "key": "svg-2" }], ["path", { "d": "M8 4v.01", "key": "svg-3" }], ["path", { "d": "M4 4v.01", "key": "svg-4" }], ["path", { "d": "M4 8v.01", "key": "svg-5" }], ["path", { "d": "M4 12v.01", "key": "svg-6" }], ["path", { "d": "M4 16v.01", "key": "svg-7" }], ["path", { "d": "M16 20v.01", "key": "svg-8" }], ["path", { "d": "M12 20v.01", "key": "svg-9" }], ["path", { "d": "M8 20v.01", "key": "svg-10" }], ["path", { "d": "M4 20v.01", "key": "svg-11" }], ["path", { "d": "M15 12h-6", "key": "svg-12" }], ["path", { "d": "M12 9v6", "key": "svg-13" }]]);

var IconBorderRightPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderRightPlus
});

var IconBorderRight = createReactComponent("outline", "border-right", "IconBorderRight", [["path", { "d": "M20 4l0 16", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M12 4l0 .01", "key": "svg-3" }], ["path", { "d": "M16 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M12 8l0 .01", "key": "svg-6" }], ["path", { "d": "M4 12l0 .01", "key": "svg-7" }], ["path", { "d": "M8 12l0 .01", "key": "svg-8" }], ["path", { "d": "M12 12l0 .01", "key": "svg-9" }], ["path", { "d": "M16 12l0 .01", "key": "svg-10" }], ["path", { "d": "M4 16l0 .01", "key": "svg-11" }], ["path", { "d": "M12 16l0 .01", "key": "svg-12" }], ["path", { "d": "M4 20l0 .01", "key": "svg-13" }], ["path", { "d": "M8 20l0 .01", "key": "svg-14" }], ["path", { "d": "M12 20l0 .01", "key": "svg-15" }], ["path", { "d": "M16 20l0 .01", "key": "svg-16" }]]);

var IconBorderRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderRight
});

var IconBorderSides = createReactComponent("outline", "border-sides", "IconBorderSides", [["path", { "d": "M4 8v8", "key": "svg-0" }], ["path", { "d": "M20 16v-8", "key": "svg-1" }], ["path", { "d": "M8 4h8", "key": "svg-2" }], ["path", { "d": "M8 20h8", "key": "svg-3" }]]);

var IconBorderSides$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderSides
});

var IconBorderStyle2 = createReactComponent("outline", "border-style-2", "IconBorderStyle2", [["path", { "d": "M4 18v.01", "key": "svg-0" }], ["path", { "d": "M8 18v.01", "key": "svg-1" }], ["path", { "d": "M12 18v.01", "key": "svg-2" }], ["path", { "d": "M16 18v.01", "key": "svg-3" }], ["path", { "d": "M20 18v.01", "key": "svg-4" }], ["path", { "d": "M18 12h2", "key": "svg-5" }], ["path", { "d": "M11 12h2", "key": "svg-6" }], ["path", { "d": "M4 12h2", "key": "svg-7" }], ["path", { "d": "M4 6h16", "key": "svg-8" }]]);

var IconBorderStyle2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderStyle2
});

var IconBorderStyle = createReactComponent("outline", "border-style", "IconBorderStyle", [["path", { "d": "M4 20v-14a2 2 0 0 1 2 -2h14", "key": "svg-0" }], ["path", { "d": "M20 8v.01", "key": "svg-1" }], ["path", { "d": "M20 12v.01", "key": "svg-2" }], ["path", { "d": "M20 16v.01", "key": "svg-3" }], ["path", { "d": "M8 20v.01", "key": "svg-4" }], ["path", { "d": "M12 20v.01", "key": "svg-5" }], ["path", { "d": "M16 20v.01", "key": "svg-6" }], ["path", { "d": "M20 20v.01", "key": "svg-7" }]]);

var IconBorderStyle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderStyle
});

var IconBorderTopPlus = createReactComponent("outline", "border-top-plus", "IconBorderTopPlus", [["path", { "d": "M4 4h16", "key": "svg-0" }], ["path", { "d": "M4 8v.01", "key": "svg-1" }], ["path", { "d": "M20 8v.01", "key": "svg-2" }], ["path", { "d": "M4 12v.01", "key": "svg-3" }], ["path", { "d": "M20 12v.01", "key": "svg-4" }], ["path", { "d": "M4 16v.01", "key": "svg-5" }], ["path", { "d": "M15 12h-6", "key": "svg-6" }], ["path", { "d": "M12 9v6", "key": "svg-7" }], ["path", { "d": "M20 16v.01", "key": "svg-8" }], ["path", { "d": "M4 20v.01", "key": "svg-9" }], ["path", { "d": "M8 20v.01", "key": "svg-10" }], ["path", { "d": "M12 20v.01", "key": "svg-11" }], ["path", { "d": "M16 20v.01", "key": "svg-12" }], ["path", { "d": "M20 20v.01", "key": "svg-13" }]]);

var IconBorderTopPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderTopPlus
});

var IconBorderTop = createReactComponent("outline", "border-top", "IconBorderTop", [["path", { "d": "M4 4l16 0", "key": "svg-0" }], ["path", { "d": "M4 8l0 .01", "key": "svg-1" }], ["path", { "d": "M12 8l0 .01", "key": "svg-2" }], ["path", { "d": "M20 8l0 .01", "key": "svg-3" }], ["path", { "d": "M4 12l0 .01", "key": "svg-4" }], ["path", { "d": "M8 12l0 .01", "key": "svg-5" }], ["path", { "d": "M12 12l0 .01", "key": "svg-6" }], ["path", { "d": "M16 12l0 .01", "key": "svg-7" }], ["path", { "d": "M20 12l0 .01", "key": "svg-8" }], ["path", { "d": "M4 16l0 .01", "key": "svg-9" }], ["path", { "d": "M12 16l0 .01", "key": "svg-10" }], ["path", { "d": "M20 16l0 .01", "key": "svg-11" }], ["path", { "d": "M4 20l0 .01", "key": "svg-12" }], ["path", { "d": "M8 20l0 .01", "key": "svg-13" }], ["path", { "d": "M12 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderTop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderTop
});

var IconBorderVertical = createReactComponent("outline", "border-vertical", "IconBorderVertical", [["path", { "d": "M12 4l0 16", "key": "svg-0" }], ["path", { "d": "M4 4l0 .01", "key": "svg-1" }], ["path", { "d": "M8 4l0 .01", "key": "svg-2" }], ["path", { "d": "M16 4l0 .01", "key": "svg-3" }], ["path", { "d": "M20 4l0 .01", "key": "svg-4" }], ["path", { "d": "M4 8l0 .01", "key": "svg-5" }], ["path", { "d": "M20 8l0 .01", "key": "svg-6" }], ["path", { "d": "M4 12l0 .01", "key": "svg-7" }], ["path", { "d": "M8 12l0 .01", "key": "svg-8" }], ["path", { "d": "M16 12l0 .01", "key": "svg-9" }], ["path", { "d": "M20 12l0 .01", "key": "svg-10" }], ["path", { "d": "M4 16l0 .01", "key": "svg-11" }], ["path", { "d": "M20 16l0 .01", "key": "svg-12" }], ["path", { "d": "M4 20l0 .01", "key": "svg-13" }], ["path", { "d": "M8 20l0 .01", "key": "svg-14" }], ["path", { "d": "M16 20l0 .01", "key": "svg-15" }], ["path", { "d": "M20 20l0 .01", "key": "svg-16" }]]);

var IconBorderVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBorderVertical
});

var IconBottleOff = createReactComponent("outline", "bottle-off", "IconBottleOff", [["path", { "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z", "key": "svg-0" }], ["path", { "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v.199m0 4v2a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2a8.09 8.09 0 0 1 1.35 -4.474m1.336 -2.63a7.822 7.822 0 0 0 .314 -2.196", "key": "svg-1" }], ["path", { "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 .866 -.142", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBottleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBottleOff
});

var IconBottle = createReactComponent("outline", "bottle", "IconBottle", [["path", { "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z", "key": "svg-0" }], ["path", { "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v6.199a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2c0 -1.682 .524 -3.322 1.5 -4.693l.05 -.07a7.823 7.823 0 0 0 1.45 -4.537", "key": "svg-1" }], ["path", { "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1 -.805", "key": "svg-2" }]]);

var IconBottle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBottle
});

var IconBounceLeft = createReactComponent("outline", "bounce-left", "IconBounceLeft", [["path", { "d": "M20 15.5c-3 -1 -5.5 -.5 -8 4.5c-.5 -3 -1.5 -5.5 -3 -8", "key": "svg-0" }], ["path", { "d": "M6 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z", "key": "svg-1" }]]);

var IconBounceLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBounceLeft
});

var IconBounceRight = createReactComponent("outline", "bounce-right", "IconBounceRight", [["path", { "d": "M4 15.5c3 -1 5.5 -.5 8 4.5c.5 -3 1.5 -5.5 3 -8", "key": "svg-0" }], ["path", { "d": "M18 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z", "key": "svg-1" }]]);

var IconBounceRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBounceRight
});

var IconBow = createReactComponent("outline", "bow", "IconBow", [["path", { "d": "M17 3h4v4", "key": "svg-0" }], ["path", { "d": "M21 3l-15 15", "key": "svg-1" }], ["path", { "d": "M3 18h3v3", "key": "svg-2" }], ["path", { "d": "M16.5 20c1.576 -1.576 2.5 -4.095 2.5 -6.5c0 -4.81 -3.69 -8.5 -8.5 -8.5c-2.415 0 -4.922 .913 -6.5 2.5l12.5 12.5z", "key": "svg-3" }]]);

var IconBow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBow
});

var IconBowlChopsticks = createReactComponent("outline", "bowl-chopsticks", "IconBowlChopsticks", [["path", { "d": "M4 11h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M19 7l-14 1", "key": "svg-1" }], ["path", { "d": "M19 2l-14 3", "key": "svg-2" }]]);

var IconBowlChopsticks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBowlChopsticks
});

var IconBowlSpoon = createReactComponent("outline", "bowl-spoon", "IconBowlSpoon", [["path", { "d": "M4 11h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M8 7c1.657 0 3 -.895 3 -2s-1.343 -2 -3 -2s-3 .895 -3 2s1.343 2 3 2", "key": "svg-1" }], ["path", { "d": "M11 5h9", "key": "svg-2" }]]);

var IconBowlSpoon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBowlSpoon
});

var IconBowl = createReactComponent("outline", "bowl", "IconBowl", [["path", { "d": "M4 8h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z", "key": "svg-0" }]]);

var IconBowl$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBowl
});

var IconBowling = createReactComponent("outline", "bowling", "IconBowling", [["path", { "d": "M7 11v.01", "key": "svg-0" }], ["path", { "d": "M11 10v.01", "key": "svg-1" }], ["path", { "d": "M10 14v.01", "key": "svg-2" }], ["path", { "d": "M11.059 6.07a8 8 0 1 0 .32 15.81", "key": "svg-3" }], ["path", { "d": "M15.969 9h4", "key": "svg-4" }], ["path", { "d": "M14.969 5c0 1.5 1 2 1 4c0 2.5 -2 4.5 -2 7c0 2.6 1.9 6 1.9 6h4.1s2 -3.4 2 -6c0 -2.5 -2 -4.5 -2 -7c0 -2 1 -2.5 1 -4a3 3 0 1 0 -6 0", "key": "svg-5" }]]);

var IconBowling$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBowling
});

var IconBoxAlignBottomLeft = createReactComponent("outline", "box-align-bottom-left", "IconBoxAlignBottomLeft", [["path", { "d": "M5 13h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 4v.01", "key": "svg-2" }], ["path", { "d": "M9 4v.01", "key": "svg-3" }], ["path", { "d": "M15 4v.01", "key": "svg-4" }], ["path", { "d": "M15 20v.01", "key": "svg-5" }], ["path", { "d": "M20 4v.01", "key": "svg-6" }], ["path", { "d": "M20 9v.01", "key": "svg-7" }], ["path", { "d": "M20 15v.01", "key": "svg-8" }], ["path", { "d": "M20 20v.01", "key": "svg-9" }]]);

var IconBoxAlignBottomLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignBottomLeft
});

var IconBoxAlignBottomRight = createReactComponent("outline", "box-align-bottom-right", "IconBoxAlignBottomRight", [["path", { "d": "M19 13h-5a1 1 0 0 0 -1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 1 -1v-5a1 1 0 0 0 -1 -1z", "key": "svg-0" }], ["path", { "d": "M20 9v.01", "key": "svg-1" }], ["path", { "d": "M20 4v.01", "key": "svg-2" }], ["path", { "d": "M15 4v.01", "key": "svg-3" }], ["path", { "d": "M9 4v.01", "key": "svg-4" }], ["path", { "d": "M9 20v.01", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 9v.01", "key": "svg-7" }], ["path", { "d": "M4 15v.01", "key": "svg-8" }], ["path", { "d": "M4 20v.01", "key": "svg-9" }]]);

var IconBoxAlignBottomRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignBottomRight
});

var IconBoxAlignBottom = createReactComponent("outline", "box-align-bottom", "IconBoxAlignBottom", [["path", { "d": "M4 14h16v5a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1v-5z", "key": "svg-0" }], ["path", { "d": "M4 9v.01", "key": "svg-1" }], ["path", { "d": "M4 4v.01", "key": "svg-2" }], ["path", { "d": "M9 4v.01", "key": "svg-3" }], ["path", { "d": "M15 4v.01", "key": "svg-4" }], ["path", { "d": "M20 4v.01", "key": "svg-5" }], ["path", { "d": "M20 9v.01", "key": "svg-6" }]]);

var IconBoxAlignBottom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignBottom
});

var IconBoxAlignLeft = createReactComponent("outline", "box-align-left", "IconBoxAlignLeft", [["path", { "d": "M10.002 20.003v-16h-5a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1h5z", "key": "svg-0" }], ["path", { "d": "M15.002 20.003h-.01", "key": "svg-1" }], ["path", { "d": "M20.003 20.003h-.011", "key": "svg-2" }], ["path", { "d": "M20.003 15.002h-.011", "key": "svg-3" }], ["path", { "d": "M20.003 9.002h-.011", "key": "svg-4" }], ["path", { "d": "M20.003 4.002h-.011", "key": "svg-5" }], ["path", { "d": "M15.002 4.002h-.01", "key": "svg-6" }]]);

var IconBoxAlignLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignLeft
});

var IconBoxAlignRight = createReactComponent("outline", "box-align-right", "IconBoxAlignRight", [["path", { "d": "M13.998 20.003v-16h5a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-5z", "key": "svg-0" }], ["path", { "d": "M8.998 20.003h.01", "key": "svg-1" }], ["path", { "d": "M3.997 20.003h.011", "key": "svg-2" }], ["path", { "d": "M3.997 15.002h.011", "key": "svg-3" }], ["path", { "d": "M3.997 9.002h.011", "key": "svg-4" }], ["path", { "d": "M3.997 4.002h.011", "key": "svg-5" }], ["path", { "d": "M8.998 4.002h.01", "key": "svg-6" }]]);

var IconBoxAlignRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignRight
});

var IconBoxAlignTopLeft = createReactComponent("outline", "box-align-top-left", "IconBoxAlignTopLeft", [["path", { "d": "M11 5v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1z", "key": "svg-0" }], ["path", { "d": "M15 4h-.01", "key": "svg-1" }], ["path", { "d": "M20 4h-.01", "key": "svg-2" }], ["path", { "d": "M20 9h-.01", "key": "svg-3" }], ["path", { "d": "M20 15h-.01", "key": "svg-4" }], ["path", { "d": "M4 15h-.01", "key": "svg-5" }], ["path", { "d": "M20 20h-.01", "key": "svg-6" }], ["path", { "d": "M15 20h-.01", "key": "svg-7" }], ["path", { "d": "M9 20h-.01", "key": "svg-8" }], ["path", { "d": "M4 20h-.01", "key": "svg-9" }]]);

var IconBoxAlignTopLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignTopLeft
});

var IconBoxAlignTopRight = createReactComponent("outline", "box-align-top-right", "IconBoxAlignTopRight", [["path", { "d": "M19 11.01h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1z", "key": "svg-0" }], ["path", { "d": "M20 15.01v-.01", "key": "svg-1" }], ["path", { "d": "M20 20.01v-.01", "key": "svg-2" }], ["path", { "d": "M15 20.01v-.01", "key": "svg-3" }], ["path", { "d": "M9 20.01v-.01", "key": "svg-4" }], ["path", { "d": "M9 4.01v-.01", "key": "svg-5" }], ["path", { "d": "M4 20.01v-.01", "key": "svg-6" }], ["path", { "d": "M4 15.01v-.01", "key": "svg-7" }], ["path", { "d": "M4 9.01v-.01", "key": "svg-8" }], ["path", { "d": "M4 4.01v-.01", "key": "svg-9" }]]);

var IconBoxAlignTopRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignTopRight
});

var IconBoxAlignTop = createReactComponent("outline", "box-align-top", "IconBoxAlignTop", [["path", { "d": "M4 10.005h16v-5a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1v5z", "key": "svg-0" }], ["path", { "d": "M4 15.005v-.01", "key": "svg-1" }], ["path", { "d": "M4 20.005v-.01", "key": "svg-2" }], ["path", { "d": "M9 20.005v-.01", "key": "svg-3" }], ["path", { "d": "M15 20.005v-.01", "key": "svg-4" }], ["path", { "d": "M20 20.005v-.01", "key": "svg-5" }], ["path", { "d": "M20 15.005v-.01", "key": "svg-6" }]]);

var IconBoxAlignTop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxAlignTop
});

var IconBoxMargin = createReactComponent("outline", "box-margin", "IconBoxMargin", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4v.01", "key": "svg-1" }], ["path", { "d": "M8 4v.01", "key": "svg-2" }], ["path", { "d": "M12 4v.01", "key": "svg-3" }], ["path", { "d": "M16 4v.01", "key": "svg-4" }], ["path", { "d": "M20 4v.01", "key": "svg-5" }], ["path", { "d": "M4 20v.01", "key": "svg-6" }], ["path", { "d": "M8 20v.01", "key": "svg-7" }], ["path", { "d": "M12 20v.01", "key": "svg-8" }], ["path", { "d": "M16 20v.01", "key": "svg-9" }], ["path", { "d": "M20 20v.01", "key": "svg-10" }], ["path", { "d": "M20 16v.01", "key": "svg-11" }], ["path", { "d": "M20 12v.01", "key": "svg-12" }], ["path", { "d": "M20 8v.01", "key": "svg-13" }], ["path", { "d": "M4 16v.01", "key": "svg-14" }], ["path", { "d": "M4 12v.01", "key": "svg-15" }], ["path", { "d": "M4 8v.01", "key": "svg-16" }]]);

var IconBoxMargin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMargin
});

var IconBoxModel2Off = createReactComponent("outline", "box-model-2-off", "IconBoxModel2Off", [["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-0" }], ["path", { "d": "M12 8h4v4m0 4h-8v-8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBoxModel2Off$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxModel2Off
});

var IconBoxModel2 = createReactComponent("outline", "box-model-2", "IconBoxModel2", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconBoxModel2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxModel2
});

var IconBoxModelOff = createReactComponent("outline", "box-model-off", "IconBoxModelOff", [["path", { "d": "M12 8h4v4m0 4h-8v-8", "key": "svg-0" }], ["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-1" }], ["path", { "d": "M16 16l3.3 3.3", "key": "svg-2" }], ["path", { "d": "M16 8l3.3 -3.3", "key": "svg-3" }], ["path", { "d": "M8 8l-3.3 -3.3", "key": "svg-4" }], ["path", { "d": "M8 16l-3.3 3.3", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconBoxModelOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxModelOff
});

var IconBoxModel = createReactComponent("outline", "box-model", "IconBoxModel", [["path", { "d": "M8 8h8v8h-8z", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M16 16l3.3 3.3", "key": "svg-2" }], ["path", { "d": "M16 8l3.3 -3.3", "key": "svg-3" }], ["path", { "d": "M8 8l-3.3 -3.3", "key": "svg-4" }], ["path", { "d": "M8 16l-3.3 3.3", "key": "svg-5" }]]);

var IconBoxModel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxModel
});

var IconBoxMultiple0 = createReactComponent("outline", "box-multiple-0", "IconBoxMultiple0", [["path", { "d": "M14 6a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple0$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple0
});

var IconBoxMultiple1 = createReactComponent("outline", "box-multiple-1", "IconBoxMultiple1", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M14 14v-8l-2 2", "key": "svg-2" }]]);

var IconBoxMultiple1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple1
});

var IconBoxMultiple2 = createReactComponent("outline", "box-multiple-2", "IconBoxMultiple2", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M12 8a2 2 0 1 1 4 0c0 .591 -.417 1.318 -.816 1.858l-3.184 4.143l4 0", "key": "svg-2" }]]);

var IconBoxMultiple2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple2
});

var IconBoxMultiple3 = createReactComponent("outline", "box-multiple-3", "IconBoxMultiple3", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M14 10a2 2 0 1 0 -2 -2", "key": "svg-2" }], ["path", { "d": "M12 12a2 2 0 1 0 2 -2", "key": "svg-3" }]]);

var IconBoxMultiple3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple3
});

var IconBoxMultiple4 = createReactComponent("outline", "box-multiple-4", "IconBoxMultiple4", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }], ["path", { "d": "M15 14v-8l-4 6h5", "key": "svg-2" }]]);

var IconBoxMultiple4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple4
});

var IconBoxMultiple5 = createReactComponent("outline", "box-multiple-5", "IconBoxMultiple5", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 14h2a2 2 0 1 0 0 -4h-2v-4h4", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple5
});

var IconBoxMultiple6 = createReactComponent("outline", "box-multiple-6", "IconBoxMultiple6", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M16 8a2 2 0 1 0 -4 0v4", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple6$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple6
});

var IconBoxMultiple7 = createReactComponent("outline", "box-multiple-7", "IconBoxMultiple7", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 6h4l-2 8", "key": "svg-1" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-2" }]]);

var IconBoxMultiple7$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple7
});

var IconBoxMultiple8 = createReactComponent("outline", "box-multiple-8", "IconBoxMultiple8", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple8$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple8
});

var IconBoxMultiple9 = createReactComponent("outline", "box-multiple-9", "IconBoxMultiple9", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 12a2 2 0 1 0 4 0v-4", "key": "svg-2" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-3" }]]);

var IconBoxMultiple9$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple9
});

var IconBoxMultiple = createReactComponent("outline", "box-multiple", "IconBoxMultiple", [["path", { "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2", "key": "svg-1" }]]);

var IconBoxMultiple$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxMultiple
});

var IconBoxOff = createReactComponent("outline", "box-off", "IconBoxOff", [["path", { "d": "M17.765 17.757l-5.765 3.243l-8 -4.5v-9l2.236 -1.258m2.57 -1.445l3.194 -1.797l8 4.5v8.5", "key": "svg-0" }], ["path", { "d": "M14.561 10.559l5.439 -3.059", "key": "svg-1" }], ["path", { "d": "M12 12v9", "key": "svg-2" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBoxOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxOff
});

var IconBoxPadding = createReactComponent("outline", "box-padding", "IconBoxPadding", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 16v.01", "key": "svg-1" }], ["path", { "d": "M8 12v.01", "key": "svg-2" }], ["path", { "d": "M8 8v.01", "key": "svg-3" }], ["path", { "d": "M16 16v.01", "key": "svg-4" }], ["path", { "d": "M16 12v.01", "key": "svg-5" }], ["path", { "d": "M16 8v.01", "key": "svg-6" }], ["path", { "d": "M12 8v.01", "key": "svg-7" }], ["path", { "d": "M12 16v.01", "key": "svg-8" }]]);

var IconBoxPadding$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBoxPadding
});

var IconBox = createReactComponent("outline", "box", "IconBox", [["path", { "d": "M12 3l8 4.5l0 9l-8 4.5l-8 -4.5l0 -9l8 -4.5", "key": "svg-0" }], ["path", { "d": "M12 12l8 -4.5", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }], ["path", { "d": "M12 12l-8 -4.5", "key": "svg-3" }]]);

var IconBox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBox
});

var IconBracesOff = createReactComponent("outline", "braces-off", "IconBracesOff", [["path", { "d": "M5.176 5.177c-.113 .251 -.176 .53 -.176 .823v3c0 1.657 -.895 3 -2 3c1.105 0 2 1.343 2 3v3a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M17 4a2 2 0 0 1 2 2v3c0 1.657 .895 3 2 3c-1.105 0 -2 1.343 -2 3m-.176 3.821a2 2 0 0 1 -1.824 1.179", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBracesOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracesOff
});

var IconBraces = createReactComponent("outline", "braces", "IconBraces", [["path", { "d": "M7 4a2 2 0 0 0 -2 2v3a2 3 0 0 1 -2 3a2 3 0 0 1 2 3v3a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M17 4a2 2 0 0 1 2 2v3a2 3 0 0 0 2 3a2 3 0 0 0 -2 3v3a2 2 0 0 1 -2 2", "key": "svg-1" }]]);

var IconBraces$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBraces
});

var IconBracketsAngleOff = createReactComponent("outline", "brackets-angle-off", "IconBracketsAngleOff", [["path", { "d": "M8 4h.01", "key": "svg-0" }], ["path", { "d": "M6.453 6.474l-3.453 5.526l5 8", "key": "svg-1" }], ["path", { "d": "M16 4l5 8l-1.917 3.067", "key": "svg-2" }], ["path", { "d": "M17.535 17.544l-1.535 2.456", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBracketsAngleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsAngleOff
});

var IconBracketsAngle = createReactComponent("outline", "brackets-angle", "IconBracketsAngle", [["path", { "d": "M8 4l-5 8l5 8", "key": "svg-0" }], ["path", { "d": "M16 4l5 8l-5 8", "key": "svg-1" }]]);

var IconBracketsAngle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsAngle
});

var IconBracketsContainEnd = createReactComponent("outline", "brackets-contain-end", "IconBracketsContainEnd", [["path", { "d": "M14 4h4v16h-4", "key": "svg-0" }], ["path", { "d": "M5 16h.01", "key": "svg-1" }], ["path", { "d": "M9 16h.01", "key": "svg-2" }], ["path", { "d": "M13 16h.01", "key": "svg-3" }]]);

var IconBracketsContainEnd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsContainEnd
});

var IconBracketsContainStart = createReactComponent("outline", "brackets-contain-start", "IconBracketsContainStart", [["path", { "d": "M9 4h-4v16h4", "key": "svg-0" }], ["path", { "d": "M18 16h-.01", "key": "svg-1" }], ["path", { "d": "M14 16h-.01", "key": "svg-2" }], ["path", { "d": "M10 16h-.01", "key": "svg-3" }]]);

var IconBracketsContainStart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsContainStart
});

var IconBracketsContain = createReactComponent("outline", "brackets-contain", "IconBracketsContain", [["path", { "d": "M7 4h-4v16h4", "key": "svg-0" }], ["path", { "d": "M17 4h4v16h-4", "key": "svg-1" }], ["path", { "d": "M8 16h.01", "key": "svg-2" }], ["path", { "d": "M12 16h.01", "key": "svg-3" }], ["path", { "d": "M16 16h.01", "key": "svg-4" }]]);

var IconBracketsContain$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsContain
});

var IconBracketsOff = createReactComponent("outline", "brackets-off", "IconBracketsOff", [["path", { "d": "M5 5v15h3", "key": "svg-0" }], ["path", { "d": "M16 4h3v11m0 4v1h-3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBracketsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBracketsOff
});

var IconBrackets = createReactComponent("outline", "brackets", "IconBrackets", [["path", { "d": "M8 4h-3v16h3", "key": "svg-0" }], ["path", { "d": "M16 4h3v16h-3", "key": "svg-1" }]]);

var IconBrackets$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrackets
});

var IconBraille = createReactComponent("outline", "braille", "IconBraille", [["path", { "d": "M15 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-0" }], ["path", { "d": "M7 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-1" }], ["path", { "d": "M7 19a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z", "key": "svg-2" }], ["path", { "d": "M16 12h.01", "key": "svg-3" }], ["path", { "d": "M8 12h.01", "key": "svg-4" }], ["path", { "d": "M16 19h.01", "key": "svg-5" }]]);

var IconBraille$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBraille
});

var IconBrain = createReactComponent("outline", "brain", "IconBrain", [["path", { "d": "M15.5 13a3.5 3.5 0 0 0 -3.5 3.5v1a3.5 3.5 0 0 0 7 0v-1.8", "key": "svg-0" }], ["path", { "d": "M8.5 13a3.5 3.5 0 0 1 3.5 3.5v1a3.5 3.5 0 0 1 -7 0v-1.8", "key": "svg-1" }], ["path", { "d": "M17.5 16a3.5 3.5 0 0 0 0 -7h-.5", "key": "svg-2" }], ["path", { "d": "M19 9.3v-2.8a3.5 3.5 0 0 0 -7 0", "key": "svg-3" }], ["path", { "d": "M6.5 16a3.5 3.5 0 0 1 0 -7h.5", "key": "svg-4" }], ["path", { "d": "M5 9.3v-2.8a3.5 3.5 0 0 1 7 0v10", "key": "svg-5" }]]);

var IconBrain$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrain
});

var IconBrand4chan = createReactComponent("outline", "brand-4chan", "IconBrand4chan", [["path", { "d": "M14 11s6.054 -1.05 6 -4.5c-.038 -2.324 -2.485 -3.19 -3.016 -1.5c0 0 -.502 -2 -2.01 -2c-1.508 0 -2.984 3 -.974 8z", "key": "svg-0" }], ["path", { "d": "M13.98 11s6.075 -1.05 6.02 -4.5c-.038 -2.324 -2.493 -3.19 -3.025 -1.5c0 0 -.505 -2 -2.017 -2c-1.513 0 -3 3 -.977 8z", "key": "svg-1" }], ["path", { "d": "M13 13.98l.062 .309l.081 .35l.075 .29l.092 .328l.11 .358l.061 .188l.139 .392c.64 1.73 1.841 3.837 3.88 3.805c2.324 -.038 3.19 -2.493 1.5 -3.025l.148 -.045l.165 -.058a4.13 4.13 0 0 0 .098 -.039l.222 -.098c.586 -.28 1.367 -.832 1.367 -1.777c0 -1.513 -3 -3 -8 -.977z", "key": "svg-2" }], ["path", { "d": "M10.02 13l-.309 .062l-.35 .081l-.29 .075l-.328 .092l-.358 .11l-.188 .061l-.392 .139c-1.73 .64 -3.837 1.84 -3.805 3.88c.038 2.324 2.493 3.19 3.025 1.5l.045 .148l.058 .165l.039 .098l.098 .222c.28 .586 .832 1.367 1.777 1.367c1.513 0 3 -3 .977 -8z", "key": "svg-3" }], ["path", { "d": "M11 10.02l-.062 -.309l-.081 -.35l-.075 -.29l-.092 -.328l-.11 -.358l-.128 -.382l-.148 -.399c-.658 -1.687 -1.844 -3.634 -3.804 -3.604c-2.324 .038 -3.19 2.493 -1.5 3.025l-.148 .045l-.164 .058a4.13 4.13 0 0 0 -.1 .039l-.22 .098c-.588 .28 -1.368 .832 -1.368 1.777c0 1.513 3 3 8 .977z", "key": "svg-4" }]]);

var IconBrand4chan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrand4chan
});

var IconBrandAbstract = createReactComponent("outline", "brand-abstract", "IconBrandAbstract", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M10.5 13.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-1" }], ["path", { "d": "M8 8h8v8", "key": "svg-2" }]]);

var IconBrandAbstract$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAbstract
});

var IconBrandAdobeAfterEffect = createReactComponent("outline", "brand-adobe-after-effect", "IconBrandAdobeAfterEffect", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M12 15.79l-.82 -2.653m-4.864 2.652l.82 -2.652m0 0l.686 -2.218c.559 -1.806 .838 -2.708 1.336 -2.708s.777 .902 1.335 2.708l.686 2.218m-4.043 0h4.043", "key": "svg-1" }], ["path", { "d": "M13.895 12.824v1.07a1.895 1.895 0 0 0 3.54 .942m-3.54 -2.012v-.824a1.895 1.895 0 1 1 3.79 0v.824z", "key": "svg-2" }]]);

var IconBrandAdobeAfterEffect$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobeAfterEffect
});

var IconBrandAdobeIllustrator = createReactComponent("outline", "brand-adobe-illustrator", "IconBrandAdobeIllustrator", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M12.947 15.79l-.82 -2.653m-4.864 2.652l.82 -2.652m0 0l.687 -2.218c.558 -1.806 .838 -2.708 1.335 -2.708c.498 0 .777 .902 1.336 2.708l.686 2.218m-4.043 0h4.043", "key": "svg-1" }], ["path", { "d": "M15.789 15.789v-4.736", "key": "svg-2" }], ["path", { "d": "M15.789 8.684v-.473", "key": "svg-3" }]]);

var IconBrandAdobeIllustrator$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobeIllustrator
});

var IconBrandAdobeIndesign = createReactComponent("outline", "brand-adobe-indesign", "IconBrandAdobeIndesign", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M14.842 11.053v3.79c0 1.044 -.49 .946 -1.42 .946a2.368 2.368 0 0 1 0 -4.736zm0 0v-2.843", "key": "svg-1" }], ["path", { "d": "M8.211 8.211v7.578", "key": "svg-2" }]]);

var IconBrandAdobeIndesign$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobeIndesign
});

var IconBrandAdobePhotoshop = createReactComponent("outline", "brand-adobe-photoshop", "IconBrandAdobePhotoshop", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M6.79 15.79v-3.79m0 0v-2.724c0 -.11 0 -.165 .004 -.211c.044 -.45 .4 -.806 .85 -.85c.046 -.004 .101 -.004 .211 -.004h1.303a1.895 1.895 0 1 1 0 3.789z", "key": "svg-1" }], ["path", { "d": "M17.178 11.263c-.164 -.659 -.935 -1.158 -1.862 -1.158c-1.047 0 -1.895 .637 -1.895 1.421c0 .785 .848 1.421 1.895 1.421c1.046 0 1.895 .637 1.895 1.421c0 .785 -.849 1.421 -1.895 1.421c-.93 0 -1.704 -.502 -1.864 -1.165", "key": "svg-2" }]]);

var IconBrandAdobePhotoshop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobePhotoshop
});

var IconBrandAdobePremier = createReactComponent("outline", "brand-adobe-premier", "IconBrandAdobePremier", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M7.263 15.79v-3.79m0 0v-3.248c0 -.335 .222 -.541 .542 -.541h1.353a1.895 1.895 0 1 1 0 3.789z", "key": "svg-1" }], ["path", { "d": "M13.895 10.579v1.895m0 0v3.315m0 -3.315c.531 -.709 1.026 -1.592 1.894 -1.832q .22 -.062 .474 -.063", "key": "svg-2" }]]);

var IconBrandAdobePremier$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobePremier
});

var IconBrandAdobeXd = createReactComponent("outline", "brand-adobe-xd", "IconBrandAdobeXd", [["path", { "d": "M3 12c0 -4.243 0 -6.364 1.318 -7.682s3.44 -1.318 7.682 -1.318s6.364 0 7.682 1.318s1.318 3.44 1.318 7.682s0 6.364 -1.318 7.682s-3.44 1.318 -7.682 1.318s-6.364 0 -7.682 -1.318s-1.318 -3.44 -1.318 -7.682", "key": "svg-0" }], ["path", { "d": "M6.316 8.21l5.684 7.58m-5.684 0l5.684 -7.58", "key": "svg-1" }], ["path", { "d": "M17.684 11.053v3.79c0 1.044 -.49 .946 -1.42 .946a2.368 2.368 0 0 1 0 -4.736zm0 0v-2.843", "key": "svg-2" }]]);

var IconBrandAdobeXd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobeXd
});

var IconBrandAdobe = createReactComponent("outline", "brand-adobe", "IconBrandAdobe", [["path", { "d": "M12.893 4.514l7.977 14a.993 .993 0 0 1 -.394 1.365a1.04 1.04 0 0 1 -.5 .127h-3.476l-4.5 -8l-2.5 4h1.5l2 4h-8.977c-.565 0 -1.023 -.45 -1.023 -1c0 -.171 .045 -.34 .13 -.49l7.977 -13.993a1.034 1.034 0 0 1 1.786 0z", "key": "svg-0" }]]);

var IconBrandAdobe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdobe
});

var IconBrandAdonisJs = createReactComponent("outline", "brand-adonis-js", "IconBrandAdonisJs", [["path", { "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z", "key": "svg-0" }], ["path", { "d": "M8.863 16.922c1.137 -.422 1.637 -.922 3.137 -.922s2 .5 3.138 .922c.713 .264 1.516 -.102 1.778 -.772c.126 -.32 .11 -.673 -.044 -.983l-3.708 -7.474c-.297 -.598 -1.058 -.859 -1.7 -.583a1.24 1.24 0 0 0 -.627 .583l-3.709 7.474c-.321 .648 -.017 1.415 .679 1.714c.332 .143 .715 .167 1.056 .04z", "key": "svg-1" }]]);

var IconBrandAdonisJs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAdonisJs
});

var IconBrandAirbnb = createReactComponent("outline", "brand-airbnb", "IconBrandAirbnb", [["path", { "d": "M12 10c-2 0 -3 1 -3 3c0 1.5 1.494 3.535 3 5.5c1 1 1.5 1.5 2.5 2s2.5 1 4.5 -.5s1.5 -3.5 .5 -6s-2.333 -5.5 -5 -9.5c-.834 -1 -1.5 -1.5 -2.503 -1.5c-1 0 -1.623 .45 -2.497 1.5c-2.667 4 -4 7 -5 9.5s-1.5 4.5 .5 6s3.5 1 4.5 .5s1.5 -1 2.5 -2c1.506 -1.965 3 -4 3 -5.5c0 -2 -1 -3 -3 -3z", "key": "svg-0" }]]);

var IconBrandAirbnb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAirbnb
});

var IconBrandAirtable = createReactComponent("outline", "brand-airtable", "IconBrandAirtable", [["path", { "d": "M3 10v8l7 -3v-2.6z", "key": "svg-0" }], ["path", { "d": "M3 6l9 3l9 -3l-9 -3z", "key": "svg-1" }], ["path", { "d": "M14 12.3v8.7l7 -3v-8z", "key": "svg-2" }]]);

var IconBrandAirtable$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAirtable
});

var IconBrandAlgolia = createReactComponent("outline", "brand-algolia", "IconBrandAlgolia", [["path", { "d": "M15.5 11c-.414 -1.477 -1.886 -2.5 -3.5 -2.5a3.47 3.47 0 0 0 -3.5 3.5a3.47 3.47 0 0 0 3.5 3.5c.974 0 1.861 -.357 2.5 -1l4.5 4.5v-15h-7c-4.386 0 -8 3.582 -8 8s3.614 8 8 8a7.577 7.577 0 0 0 2.998 -.614", "key": "svg-0" }]]);

var IconBrandAlgolia$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAlgolia
});

var IconBrandAlipay = createReactComponent("outline", "brand-alipay", "IconBrandAlipay", [["path", { "d": "M19 3h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 7h10", "key": "svg-1" }], ["path", { "d": "M12 3v7", "key": "svg-2" }], ["path", { "d": "M21 17.314c-2.971 -1.923 -15 -8.779 -15 -1.864c0 1.716 1.52 2.55 2.985 2.55c3.512 0 6.814 -5.425 6.814 -8h-6.604", "key": "svg-3" }]]);

var IconBrandAlipay$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAlipay
});

var IconBrandAlpineJs = createReactComponent("outline", "brand-alpine-js", "IconBrandAlpineJs", [["path", { "d": "M3 11.5l4.5 4.5h9l-9 -9z", "key": "svg-0" }], ["path", { "d": "M16.5 16l4.5 -4.5l-4.5 -4.5l-4.5 4.5", "key": "svg-1" }]]);

var IconBrandAlpineJs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAlpineJs
});

var IconBrandAmazon = createReactComponent("outline", "brand-amazon", "IconBrandAmazon", [["path", { "d": "M17 12.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94", "key": "svg-0" }], ["path", { "d": "M19.5 15c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1", "key": "svg-1" }]]);

var IconBrandAmazon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAmazon
});

var IconBrandAmd = createReactComponent("outline", "brand-amd", "IconBrandAmd", [["path", { "d": "M16 16v-7c0 -.566 -.434 -1 -1 -1h-7l-5 -5h17c.566 0 1 .434 1 1v17l-5 -5z", "key": "svg-0" }], ["path", { "d": "M11.293 20.707l4.707 -4.707h-7a1 1 0 0 1 -1 -1v-7l-4.707 4.707a1 1 0 0 0 -.293 .707v6.586a1 1 0 0 0 1 1h6.586a1 1 0 0 0 .707 -.293z", "key": "svg-1" }]]);

var IconBrandAmd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAmd
});

var IconBrandAmie = createReactComponent("outline", "brand-amie", "IconBrandAmie", [["path", { "d": "M3 8.5c0 1.33 .472 2.55 1.257 3.5a5.5 5.5 0 0 0 7.743 7.743a5.5 5.5 0 0 0 7.743 -7.743a5.5 5.5 0 0 0 -7.743 -7.743a5.5 5.5 0 0 0 -9 4.243", "key": "svg-0" }], ["path", { "d": "M10 9.5c0 -.828 .895 -1.5 2 -1.5s2 .672 2 1.5v5c0 .828 -.895 1.5 -2 1.5s-2 -.672 -2 -1.5z", "key": "svg-1" }]]);

var IconBrandAmie$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAmie
});

var IconBrandAmigo = createReactComponent("outline", "brand-amigo", "IconBrandAmigo", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M9.591 3.635l-7.13 14.082c-1.712 3.38 1.759 5.45 3.69 3.573l1.86 -1.81c3.142 -3.054 4.959 -2.99 8.039 .11l1.329 1.337c2.372 2.387 5.865 .078 4.176 -3.225l-7.195 -14.067c-1.114 -2.18 -3.666 -2.18 -4.77 0z", "key": "svg-1" }]]);

var IconBrandAmigo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAmigo
});

var IconBrandAmongUs = createReactComponent("outline", "brand-among-us", "IconBrandAmongUs", [["path", { "d": "M10.646 12.774c-1.939 .396 -4.467 .317 -6.234 -.601c-2.454 -1.263 -1.537 -4.66 1.423 -4.982c2.254 -.224 3.814 -.354 5.65 .214c.835 .256 1.93 .569 1.355 3.281c-.191 1.067 -1.07 1.904 -2.194 2.088z", "key": "svg-0" }], ["path", { "d": "M5.84 7.132c.083 -.564 .214 -1.12 .392 -1.661c.456 -.936 1.095 -2.068 3.985 -2.456a22.464 22.464 0 0 1 2.867 .08c1.776 .14 2.643 1.234 3.287 3.368c.339 1.157 .46 2.342 .629 3.537v11l-12.704 -.019c-.552 -2.386 -.262 -5.894 .204 -8.481", "key": "svg-1" }], ["path", { "d": "M17 10c.991 .163 2.105 .383 3.069 .67c.255 .13 .52 .275 .534 .505c.264 3.434 .57 7.448 .278 9.825h-3.881", "key": "svg-2" }]]);

var IconBrandAmongUs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAmongUs
});

var IconBrandAndroid = createReactComponent("outline", "brand-android", "IconBrandAndroid", [["path", { "d": "M4 10l0 6", "key": "svg-0" }], ["path", { "d": "M20 10l0 6", "key": "svg-1" }], ["path", { "d": "M7 9h10v8a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-8a5 5 0 0 1 10 0", "key": "svg-2" }], ["path", { "d": "M8 3l1 2", "key": "svg-3" }], ["path", { "d": "M16 3l-1 2", "key": "svg-4" }], ["path", { "d": "M9 18l0 3", "key": "svg-5" }], ["path", { "d": "M15 18l0 3", "key": "svg-6" }]]);

var IconBrandAndroid$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAndroid
});

var IconBrandAngular = createReactComponent("outline", "brand-angular", "IconBrandAngular", [["path", { "d": "M5.428 17.245l6.076 3.471a1 1 0 0 0 .992 0l6.076 -3.471a1 1 0 0 0 .495 -.734l1.323 -9.704a1 1 0 0 0 -.658 -1.078l-7.4 -2.612a1 1 0 0 0 -.665 0l-7.399 2.613a1 1 0 0 0 -.658 1.078l1.323 9.704a1 1 0 0 0 .495 .734z", "key": "svg-0" }], ["path", { "d": "M9 15l3 -8l3 8", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconBrandAngular$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAngular
});

var IconBrandAnsible = createReactComponent("outline", "brand-ansible", "IconBrandAnsible", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9.647 12.294l6.353 3.706l-4 -9l-4 9", "key": "svg-1" }]]);

var IconBrandAnsible$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAnsible
});

var IconBrandAo3 = createReactComponent("outline", "brand-ao3", "IconBrandAo3", [["path", { "d": "M2 5c7.109 4.1 10.956 10.131 12 14c1.074 -4.67 4.49 -8.94 8 -11", "key": "svg-0" }], ["path", { "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 9c-.278 5.494 -2.337 7.33 -4 10c4.013 -2 6.02 -5 15.05 -5c4.012 0 3.51 2.5 1 3c2 .5 2.508 5 -2.007 2", "key": "svg-2" }]]);

var IconBrandAo3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAo3
});

var IconBrandAppgallery = createReactComponent("outline", "brand-appgallery", "IconBrandAppgallery", [["path", { "d": "M4 4m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M9 8a3 3 0 0 0 6 0", "key": "svg-1" }]]);

var IconBrandAppgallery$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAppgallery
});

var IconBrandAppleArcade = createReactComponent("outline", "brand-apple-arcade", "IconBrandAppleArcade", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M20 12.5v4.75a.734 .734 0 0 1 -.055 .325a.704 .704 0 0 1 -.348 .366l-5.462 2.58a5 5 0 0 1 -4.27 0l-5.462 -2.58a.705 .705 0 0 1 -.401 -.691l0 -4.75", "key": "svg-1" }], ["path", { "d": "M4.431 12.216l5.634 -2.332a5.065 5.065 0 0 1 3.87 0l5.634 2.332a.692 .692 0 0 1 .028 1.269l-5.462 2.543a5.064 5.064 0 0 1 -4.27 0l-5.462 -2.543a.691 .691 0 0 1 .028 -1.27z", "key": "svg-2" }], ["path", { "d": "M12 7l0 6", "key": "svg-3" }]]);

var IconBrandAppleArcade$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAppleArcade
});

var IconBrandAppleNews = createReactComponent("outline", "brand-apple-news", "IconBrandAppleNews", [["path", { "d": "M4 14l6 6h-6z", "key": "svg-0" }], ["path", { "d": "M20 10l-6 -6h6z", "key": "svg-1" }], ["path", { "d": "M4 4v4l12 12h4v-4l-12 -12z", "key": "svg-2" }]]);

var IconBrandAppleNews$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAppleNews
});

var IconBrandApplePodcast = createReactComponent("outline", "brand-apple-podcast", "IconBrandApplePodcast", [["path", { "d": "M18.364 18.364a9 9 0 1 0 -12.728 0", "key": "svg-0" }], ["path", { "d": "M11.766 22h.468a2 2 0 0 0 1.985 -1.752l.5 -4a2 2 0 0 0 -1.985 -2.248h-1.468a2 2 0 0 0 -1.985 2.248l.5 4a2 2 0 0 0 1.985 1.752z", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandApplePodcast$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandApplePodcast
});

var IconBrandApple = createReactComponent("outline", "brand-apple", "IconBrandApple", [["path", { "d": "M8.286 7.008c-3.216 0 -4.286 3.23 -4.286 5.92c0 3.229 2.143 8.072 4.286 8.072c1.165 -.05 1.799 -.538 3.214 -.538c1.406 0 1.607 .538 3.214 .538s4.286 -3.229 4.286 -5.381c-.03 -.011 -2.649 -.434 -2.679 -3.23c-.02 -2.335 2.589 -3.179 2.679 -3.228c-1.096 -1.606 -3.162 -2.113 -3.75 -2.153c-1.535 -.12 -3.032 1.077 -3.75 1.077c-.729 0 -2.036 -1.077 -3.214 -1.077z", "key": "svg-0" }], ["path", { "d": "M12 4a2 2 0 0 0 2 -2a2 2 0 0 0 -2 2", "key": "svg-1" }]]);

var IconBrandApple$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandApple
});

var IconBrandAppstore = createReactComponent("outline", "brand-appstore", "IconBrandAppstore", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 16l1.106 -1.99m1.4 -2.522l2.494 -4.488", "key": "svg-1" }], ["path", { "d": "M7 14h5m2.9 0h2.1", "key": "svg-2" }], ["path", { "d": "M16 16l-2.51 -4.518m-1.487 -2.677l-1 -1.805", "key": "svg-3" }]]);

var IconBrandAppstore$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAppstore
});

var IconBrandArc = createReactComponent("outline", "brand-arc", "IconBrandArc", [["path", { "d": "M4.687 14.694l-.987 2.103c-.502 1.07 -.125 2.387 .908 2.945c1.096 .59 2.444 .13 2.972 -.995l.9 -1.92", "key": "svg-0" }], ["path", { "d": "M18.317 14.576c1.818 -1.6 3.16 -3.78 3.64 -6.217c.235 -1.194 -.525 -2.351 -1.695 -2.586a2.14 2.14 0 0 0 -1.625 .326c-.478 .323 -.81 .826 -.922 1.398c-.208 1.054 -.695 2.037 -1.366 2.872", "key": "svg-1" }], ["path", { "d": "M12.68 12.759a5.4 5.4 0 0 1 -1.283 .157c-.336 0 -.683 -.04 -1.03 -.115c-1.44 -.31 -2.89 -1.215 -3.709 -2.315a3.7 3.7 0 0 1 -.487 -.853a2.157 2.157 0 0 0 -2.818 -1.213c-1.107 .455 -1.641 1.736 -1.196 2.86c.508 1.278 1.404 2.45 2.53 3.415a11.2 11.2 0 0 0 3.791 2.133c.953 .31 1.942 .483 2.916 .483a9.8 9.8 0 0 0 3.162 -.537", "key": "svg-2" }], ["path", { "d": "M10.37 12.801l.943 -2.013c.09 -.19 .357 -.19 .446 0l.923 1.97h.006h-.006l1.88 4.015l.923 1.971a2.16 2.16 0 0 0 1.957 1.254q .29 0 .576 -.081c1.303 -.365 1.92 -1.887 1.339 -3.129l-1.04 -2.218l-1.968 -4.204l-.003 .003l.003 -.003l-2.862 -6.112a2.16 2.16 0 0 0 -1.954 -1.254c-.833 0 -1.593 .488 -1.953 1.254l-2.92 6.232", "key": "svg-3" }]]);

var IconBrandArc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandArc
});

var IconBrandAsana = createReactComponent("outline", "brand-asana", "IconBrandAsana", [["path", { "d": "M12 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M7 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconBrandAsana$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAsana
});

var IconBrandAstro = createReactComponent("outline", "brand-astro", "IconBrandAstro", [["path", { "d": "M14.972 3.483c.163 .196 .247 .46 .413 .987l3.64 11.53a15.5 15.5 0 0 0 -4.352 -1.42l-2.37 -7.723a.31 .31 0 0 0 -.296 -.213a.31 .31 0 0 0 -.295 .214l-2.342 7.718a15.5 15.5 0 0 0 -4.37 1.422l3.657 -11.53c.168 -.527 .251 -.79 .415 -.986c.144 -.172 .331 -.306 .544 -.388c.242 -.094 .527 -.094 1.099 -.094h2.612c.572 0 .858 0 1.1 .094c.213 .082 .4 .217 .545 .39", "key": "svg-0" }], ["path", { "d": "M9 18c0 1.5 2 3 3 4c1 -1 3 -3 3 -4q -3 1.5 -6 0", "key": "svg-1" }]]);

var IconBrandAstro$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAstro
});

var IconBrandAuth0 = createReactComponent("outline", "brand-auth0", "IconBrandAuth0", [["path", { "d": "M12 14.5l-5.5 3.5l2 -6l-4.5 -4h6l2 -5l2 5h6l-4.5 4l2 6z", "key": "svg-0" }], ["path", { "d": "M20.507 8.872l-2.01 -5.872h-12.994l-2.009 5.872c-1.242 3.593 -.135 7.094 3.249 9.407l5.257 3.721l5.257 -3.721c3.385 -2.313 4.49 -5.814 3.25 -9.407z", "key": "svg-1" }]]);

var IconBrandAuth0$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAuth0
});

var IconBrandAws = createReactComponent("outline", "brand-aws", "IconBrandAws", [["path", { "d": "M17 18.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94", "key": "svg-0" }], ["path", { "d": "M19.5 21c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1", "key": "svg-1" }], ["path", { "d": "M3 11v-4.5a1.5 1.5 0 0 1 3 0v4.5", "key": "svg-2" }], ["path", { "d": "M3 9h3", "key": "svg-3" }], ["path", { "d": "M9 5l1.2 6l1.8 -4l1.8 4l1.2 -6", "key": "svg-4" }], ["path", { "d": "M18 10.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75", "key": "svg-5" }]]);

var IconBrandAws$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAws
});

var IconBrandAzure = createReactComponent("outline", "brand-azure", "IconBrandAzure", [["path", { "d": "M6 7.5l-4 9.5h4l6 -15z", "key": "svg-0" }], ["path", { "d": "M22 20l-7 -15l-3 7l4 5l-8 3z", "key": "svg-1" }]]);

var IconBrandAzure$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandAzure
});

var IconBrandBackbone = createReactComponent("outline", "brand-backbone", "IconBrandBackbone", [["path", { "d": "M5 20l14 -8l-14 -8z", "key": "svg-0" }], ["path", { "d": "M19 20l-14 -8l14 -8z", "key": "svg-1" }]]);

var IconBrandBackbone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBackbone
});

var IconBrandBadoo = createReactComponent("outline", "brand-badoo", "IconBrandBadoo", [["path", { "d": "M22 9.43c0 5.838 -4.477 10.57 -10 10.57s-10 -4.662 -10 -10.5c0 -2.667 1.83 -5.01 4.322 -5.429c2.492 -.418 4.9 1.392 5.678 3.929c.768 -2.54 3.177 -4.354 5.668 -3.931c2.495 .417 4.332 2.69 4.332 5.36z", "key": "svg-0" }], ["path", { "d": "M7.5 10c0 2.761 2.015 5 4.5 5s4.5 -2.239 4.5 -5", "key": "svg-1" }]]);

var IconBrandBadoo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBadoo
});

var IconBrandBaidu = createReactComponent("outline", "brand-baidu", "IconBrandBaidu", [["path", { "d": "M5 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M14.463 11.596c1.282 1.774 3.476 3.416 3.476 3.416s1.921 1.574 .593 3.636c-1.328 2.063 -4.892 1.152 -4.892 1.152s-1.416 -.44 -3.06 -.088c-1.644 .356 -3.06 .22 -3.06 .22s-2.055 -.22 -2.47 -2.304c-.416 -2.084 1.918 -3.638 2.102 -3.858c.182 -.222 1.409 -.966 2.284 -2.394c.875 -1.428 3.337 -2.287 5.027 .221z", "key": "svg-1" }], ["path", { "d": "M9 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M15 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M19 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBrandBaidu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBaidu
});

var IconBrandBandcamp = createReactComponent("outline", "brand-bandcamp", "IconBrandBandcamp", [["path", { "d": "M8.5 6h13.5l-7 12h-13z", "key": "svg-0" }]]);

var IconBrandBandcamp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBandcamp
});

var IconBrandBandlab = createReactComponent("outline", "brand-bandlab", "IconBrandBandlab", [["path", { "d": "M6.885 7l-2.536 4.907c-2.021 3.845 -2.499 8.775 3.821 9.093h6.808c4.86 -.207 7.989 -2.975 4.607 -9.093l-2.988 -4.907", "key": "svg-0" }], ["path", { "d": "M15.078 4h-5.136l3.678 8.768c.547 1.14 .847 1.822 .162 2.676c-.053 .093 -1.332 1.907 -3.053 1.495c-.825 -.187 -1.384 -.926 -1.32 -1.74c.04 -.91 .62 -1.717 1.488 -2.074a4.463 4.463 0 0 1 2.723 -.358", "key": "svg-1" }]]);

var IconBrandBandlab$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBandlab
});

var IconBrandBeats = createReactComponent("outline", "brand-beats", "IconBrandBeats", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12.5 12.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-1" }], ["path", { "d": "M9 12v-8", "key": "svg-2" }]]);

var IconBrandBeats$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBeats
});

var IconBrandBebo = createReactComponent("outline", "brand-bebo", "IconBrandBebo", [["path", { "d": "M12 17.5a3.5 3.5 0 0 0 3.5 -3.5c0 -1.838 -1.159 -3.002 -3.005 -3.372c-.746 -.15 -1.37 -.745 -1.37 -1.506c0 -1.142 .934 -2.095 2.058 -1.894c3.61 .645 5.817 3.058 5.817 6.772a7 7 0 1 1 -14 0v-9.25a1.75 1.75 0 1 1 3.5 0v9.25a3.5 3.5 0 0 0 3.5 3.5", "key": "svg-0" }]]);

var IconBrandBebo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBebo
});

var IconBrandBehance = createReactComponent("outline", "brand-behance", "IconBrandBehance", [["path", { "d": "M3 18v-12h4.5a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-4.5", "key": "svg-0" }], ["path", { "d": "M3 12l4.5 0", "key": "svg-1" }], ["path", { "d": "M14 13h7a3.5 3.5 0 0 0 -7 0v2a3.5 3.5 0 0 0 6.64 1", "key": "svg-2" }], ["path", { "d": "M16 6l3 0", "key": "svg-3" }]]);

var IconBrandBehance$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBehance
});

var IconBrandBilibili = createReactComponent("outline", "brand-bilibili", "IconBrandBilibili", [["path", { "d": "M3 10a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v6a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-6z", "key": "svg-0" }], ["path", { "d": "M8 3l2 3", "key": "svg-1" }], ["path", { "d": "M16 3l-2 3", "key": "svg-2" }], ["path", { "d": "M9 13v-2", "key": "svg-3" }], ["path", { "d": "M15 11v2", "key": "svg-4" }]]);

var IconBrandBilibili$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBilibili
});

var IconBrandBinance = createReactComponent("outline", "brand-binance", "IconBrandBinance", [["path", { "d": "M6 8l2 2l4 -4l4 4l2 -2l-6 -6z", "key": "svg-0" }], ["path", { "d": "M6 16l2 -2l4 4l3.5 -3.5l2 2l-5.5 5.5z", "key": "svg-1" }], ["path", { "d": "M20 10l2 2l-2 2l-2 -2z", "key": "svg-2" }], ["path", { "d": "M4 10l2 2l-2 2l-2 -2z", "key": "svg-3" }], ["path", { "d": "M12 10l2 2l-2 2l-2 -2z", "key": "svg-4" }]]);

var IconBrandBinance$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBinance
});

var IconBrandBing = createReactComponent("outline", "brand-bing", "IconBrandBing", [["path", { "d": "M5 3l4 1.5v12l6 -2.5l-2 -1l-1 -4l7 2.5v4.5l-10 5l-4 -2z", "key": "svg-0" }]]);

var IconBrandBing$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBing
});

var IconBrandBitbucket = createReactComponent("outline", "brand-bitbucket", "IconBrandBitbucket", [["path", { "d": "M3.648 4a.64 .64 0 0 0 -.64 .744l3.14 14.528c.07 .417 .43 .724 .852 .728h10a.644 .644 0 0 0 .642 -.539l3.35 -14.71a.641 .641 0 0 0 -.64 -.744l-16.704 -.007z", "key": "svg-0" }], ["path", { "d": "M14 15h-4l-1 -6h6z", "key": "svg-1" }]]);

var IconBrandBitbucket$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBitbucket
});

var IconBrandBlackberry = createReactComponent("outline", "brand-blackberry", "IconBrandBlackberry", [["path", { "d": "M7 6a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-0" }], ["path", { "d": "M6 12a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-1" }], ["path", { "d": "M13 12a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-2" }], ["path", { "d": "M14 6a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-3" }], ["path", { "d": "M12 18a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-4" }], ["path", { "d": "M20 15a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-5" }], ["path", { "d": "M21 9a1 1 0 0 0 -1 -1h-2l-.5 2h2.5a1 1 0 0 0 1 -1z", "key": "svg-6" }]]);

var IconBrandBlackberry$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBlackberry
});

var IconBrandBlender = createReactComponent("outline", "brand-blender", "IconBrandBlender", [["path", { "d": "M15 14m-6 0a6 5 0 1 0 12 0a6 5 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M15 14m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M3 16l9 -6.5", "key": "svg-2" }], ["path", { "d": "M6 9h9", "key": "svg-3" }], ["path", { "d": "M13 5l5.65 5", "key": "svg-4" }]]);

var IconBrandBlender$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBlender
});

var IconBrandBlogger = createReactComponent("outline", "brand-blogger", "IconBrandBlogger", [["path", { "d": "M8 21h8a5 5 0 0 0 5 -5v-3a3 3 0 0 0 -3 -3h-1v-2a5 5 0 0 0 -5 -5h-4a5 5 0 0 0 -5 5v8a5 5 0 0 0 5 5z", "key": "svg-0" }], ["path", { "d": "M7 7m0 1.5a1.5 1.5 0 0 1 1.5 -1.5h3a1.5 1.5 0 0 1 1.5 1.5v0a1.5 1.5 0 0 1 -1.5 1.5h-3a1.5 1.5 0 0 1 -1.5 -1.5z", "key": "svg-1" }], ["path", { "d": "M7 14m0 1.5a1.5 1.5 0 0 1 1.5 -1.5h7a1.5 1.5 0 0 1 1.5 1.5v0a1.5 1.5 0 0 1 -1.5 1.5h-7a1.5 1.5 0 0 1 -1.5 -1.5z", "key": "svg-2" }]]);

var IconBrandBlogger$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBlogger
});

var IconBrandBluesky = createReactComponent("outline", "brand-bluesky", "IconBrandBluesky", [["path", { "d": "M6.335 5.144c-1.654 -1.199 -4.335 -2.127 -4.335 .826c0 .59 .35 4.953 .556 5.661c.713 2.463 3.13 2.75 5.444 2.369c-4.045 .665 -4.889 3.208 -2.667 5.41c1.03 1.018 1.913 1.59 2.667 1.59c2 0 3.134 -2.769 3.5 -3.5c.333 -.667 .5 -1.167 .5 -1.5c0 .333 .167 .833 .5 1.5c.366 .731 1.5 3.5 3.5 3.5c.754 0 1.637 -.571 2.667 -1.59c2.222 -2.203 1.378 -4.746 -2.667 -5.41c2.314 .38 4.73 .094 5.444 -2.369c.206 -.708 .556 -5.072 .556 -5.661c0 -2.953 -2.68 -2.025 -4.335 -.826c-2.293 1.662 -4.76 5.048 -5.665 6.856c-.905 -1.808 -3.372 -5.194 -5.665 -6.856z", "key": "svg-0" }]]);

var IconBrandBluesky$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBluesky
});

var IconBrandBooking = createReactComponent("outline", "brand-booking", "IconBrandBooking", [["path", { "d": "M4 18v-9.5a4.5 4.5 0 0 1 4.5 -4.5h7a4.5 4.5 0 0 1 4.5 4.5v7a4.5 4.5 0 0 1 -4.5 4.5h-9.5a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 12h3.5a2 2 0 1 1 0 4h-3.5v-7a1 1 0 0 1 1 -1h1.5a2 2 0 1 1 0 4h-1.5", "key": "svg-1" }], ["path", { "d": "M16 16l.01 0", "key": "svg-2" }]]);

var IconBrandBooking$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBooking
});

var IconBrandBootstrap = createReactComponent("outline", "brand-bootstrap", "IconBrandBootstrap", [["path", { "d": "M2 12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2", "key": "svg-0" }], ["path", { "d": "M2 12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2", "key": "svg-1" }], ["path", { "d": "M9 16v-8h3.5a2 2 0 1 1 0 4h-3.5h4a2 2 0 1 1 0 4h-4z", "key": "svg-2" }]]);

var IconBrandBootstrap$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBootstrap
});

var IconBrandBulma = createReactComponent("outline", "brand-bulma", "IconBrandBulma", [["path", { "d": "M5 16l1 -9l5 -5l6.5 6l-3.5 4l5 5l-8 5z", "key": "svg-0" }]]);

var IconBrandBulma$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBulma
});

var IconBrandBumble = createReactComponent("outline", "brand-bumble", "IconBrandBumble", [["path", { "d": "M7 12h10", "key": "svg-0" }], ["path", { "d": "M9 8h6", "key": "svg-1" }], ["path", { "d": "M10 16h4", "key": "svg-2" }], ["path", { "d": "M16.268 3h-8.536a1.46 1.46 0 0 0 -1.268 .748l-4.268 7.509a1.507 1.507 0 0 0 0 1.486l4.268 7.509c.26 .462 .744 .747 1.268 .748h8.536a1.46 1.46 0 0 0 1.268 -.748l4.268 -7.509a1.507 1.507 0 0 0 0 -1.486l-4.268 -7.509a1.46 1.46 0 0 0 -1.268 -.748z", "key": "svg-3" }]]);

var IconBrandBumble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBumble
});

var IconBrandBunpo = createReactComponent("outline", "brand-bunpo", "IconBrandBunpo", [["path", { "d": "M3.9 7.205a17.764 17.764 0 0 0 4.008 2.753a7.917 7.917 0 0 0 4.57 .567c1.5 -.33 2.907 -1 4.121 -1.956a12.107 12.107 0 0 0 2.892 -2.903c.603 -.94 .745 -1.766 .484 -2.231c-.261 -.465 -.927 -.568 -1.72 -.257a7.564 7.564 0 0 0 -2.608 2.034a18.425 18.425 0 0 0 -2.588 3.884a34.927 34.927 0 0 0 -2.093 5.073a12.908 12.908 0 0 0 -.677 3.515c-.07 .752 .07 1.51 .405 2.184c.323 .562 1.06 1.132 2.343 1.132c3.474 0 5.093 -3.53 5.463 -5.62c.24 -1.365 -.085 -3.197 -1.182 -4.01", "key": "svg-0" }]]);

var IconBrandBunpo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandBunpo
});

var IconBrandCSharp = createReactComponent("outline", "brand-c-sharp", "IconBrandCSharp", [["path", { "d": "M10 9a3 3 0 0 0 -3 -3h-.5a3.5 3.5 0 0 0 -3.5 3.5v5a3.5 3.5 0 0 0 3.5 3.5h.5a3 3 0 0 0 3 -3", "key": "svg-0" }], ["path", { "d": "M16 7l-1 10", "key": "svg-1" }], ["path", { "d": "M20 7l-1 10", "key": "svg-2" }], ["path", { "d": "M14 10h7.5", "key": "svg-3" }], ["path", { "d": "M21 14h-7.5", "key": "svg-4" }]]);

var IconBrandCSharp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCSharp
});

var IconBrandCake = createReactComponent("outline", "brand-cake", "IconBrandCake", [["path", { "d": "M20.84 12c0 2.05 .985 3.225 -.04 5c-1.026 1.775 -2.537 1.51 -4.314 2.534c-1.776 1.026 -2.302 2.466 -4.353 2.466c-2.051 0 -2.576 -1.441 -4.353 -2.466c-1.776 -1.024 -3.288 -.759 -4.314 -2.534c-1.025 -1.775 -.04 -2.95 -.04 -5s-.985 -3.225 .04 -5c1.026 -1.775 2.537 -1.51 4.314 -2.534c1.776 -1.026 2.302 -2.466 4.353 -2.466s2.577 1.441 4.353 2.466c1.776 1.024 3.288 .759 4.313 2.534c1.026 1.775 .04 2.95 .04 5z", "key": "svg-0" }]]);

var IconBrandCake$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCake
});

var IconBrandCakephp = createReactComponent("outline", "brand-cakephp", "IconBrandCakephp", [["path", { "d": "M12 11l8 2c1.361 -.545 2 -1.248 2 -2v-3.8c0 -1.765 -4.479 -3.2 -10.002 -3.2c-5.522 0 -9.998 1.435 -9.998 3.2v2.8c0 1.766 4.478 4 10 4v-3z", "key": "svg-0" }], ["path", { "d": "M12 14v3l8 2c1.362 -.547 2 -1.246 2 -2v-3c0 .754 -.638 1.453 -2 2l-8 -2z", "key": "svg-1" }], ["path", { "d": "M2 17c0 1.766 4.476 3 9.998 3l.002 -3c-5.522 0 -10 -1.734 -10 -3.5v3.5z", "key": "svg-2" }], ["path", { "d": "M2 10v4", "key": "svg-3" }], ["path", { "d": "M22 10v4", "key": "svg-4" }]]);

var IconBrandCakephp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCakephp
});

var IconBrandCampaignmonitor = createReactComponent("outline", "brand-campaignmonitor", "IconBrandCampaignmonitor", [["path", { "d": "M3 18l9 -6.462l-9 -5.538v12h18v-12l-9 5.538", "key": "svg-0" }]]);

var IconBrandCampaignmonitor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCampaignmonitor
});

var IconBrandCarbon = createReactComponent("outline", "brand-carbon", "IconBrandCarbon", [["path", { "d": "M14 10v-.2a1.8 1.8 0 0 0 -1.8 -1.8h-.4a1.8 1.8 0 0 0 -1.8 1.8v4.4a1.8 1.8 0 0 0 1.8 1.8h.4a1.8 1.8 0 0 0 1.8 -1.8v-.2", "key": "svg-0" }], ["path", { "d": "M3 3m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-1" }]]);

var IconBrandCarbon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCarbon
});

var IconBrandCashapp = createReactComponent("outline", "brand-cashapp", "IconBrandCashapp", [["path", { "d": "M17.1 8.648a.568 .568 0 0 1 -.761 .011a5.682 5.682 0 0 0 -3.659 -1.34c-1.102 0 -2.205 .363 -2.205 1.374c0 1.023 1.182 1.364 2.546 1.875c2.386 .796 4.363 1.796 4.363 4.137c0 2.545 -1.977 4.295 -5.204 4.488l-.295 1.364a.557 .557 0 0 1 -.546 .443h-2.034l-.102 -.011a.568 .568 0 0 1 -.432 -.67l.318 -1.444a7.432 7.432 0 0 1 -3.273 -1.784v-.011a.545 .545 0 0 1 0 -.773l1.137 -1.102c.214 -.2 .547 -.2 .761 0a5.495 5.495 0 0 0 3.852 1.5c1.478 0 2.466 -.625 2.466 -1.614c0 -.989 -1 -1.25 -2.886 -1.954c-2 -.716 -3.898 -1.728 -3.898 -4.091c0 -2.75 2.284 -4.091 4.989 -4.216l.284 -1.398a.545 .545 0 0 1 .545 -.432h2.023l.114 .012a.544 .544 0 0 1 .42 .647l-.307 1.557a8.528 8.528 0 0 1 2.818 1.58l.023 .022c.216 .228 .216 .569 0 .773l-1.057 1.057z", "key": "svg-0" }]]);

var IconBrandCashapp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCashapp
});

var IconBrandChrome = createReactComponent("outline", "brand-chrome", "IconBrandChrome", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M12 9h8.4", "key": "svg-2" }], ["path", { "d": "M14.598 13.5l-4.2 7.275", "key": "svg-3" }], ["path", { "d": "M9.402 13.5l-4.2 -7.275", "key": "svg-4" }]]);

var IconBrandChrome$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandChrome
});

var IconBrandCinema4d = createReactComponent("outline", "brand-cinema-4d", "IconBrandCinema4d", [["path", { "d": "M9.65 6.956a5.39 5.39 0 0 0 7.494 7.495", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M17.7 12.137a5.738 5.738 0 1 1 -5.737 -5.737", "key": "svg-2" }], ["path", { "d": "M17.7 12.338v-1.175c0 -.47 .171 -.92 .476 -1.253a1.56 1.56 0 0 1 1.149 -.52c.827 0 1.523 .676 1.62 1.573c.037 .344 .055 .69 .055 1.037", "key": "svg-3" }], ["path", { "d": "M11.662 6.4h1.175c.47 0 .92 -.176 1.253 -.49c.333 -.314 .52 -.74 .52 -1.184c0 -.852 -.676 -1.57 -1.573 -1.67a9.496 9.496 0 0 0 -1.037 -.056", "key": "svg-4" }]]);

var IconBrandCinema4d$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCinema4d
});

var IconBrandCitymapper = createReactComponent("outline", "brand-citymapper", "IconBrandCitymapper", [["path", { "d": "M3 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z", "key": "svg-0" }], ["path", { "d": "M21 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M13 9l3 3l-3 3", "key": "svg-3" }]]);

var IconBrandCitymapper$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCitymapper
});

var IconBrandCloudflare = createReactComponent("outline", "brand-cloudflare", "IconBrandCloudflare", [["path", { "d": "M13.031 7.007c2.469 -.007 3.295 1.293 3.969 2.993c4 0 4.994 3.825 5 6h-20c-.001 -1.64 1.36 -2.954 3 -3c0 -1.5 1 -3 3 -3c.66 -1.942 2.562 -2.986 5.031 -2.993z", "key": "svg-0" }], ["path", { "d": "M12 13h6", "key": "svg-1" }], ["path", { "d": "M17 10l-2.5 6", "key": "svg-2" }]]);

var IconBrandCloudflare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCloudflare
});

var IconBrandCodecov = createReactComponent("outline", "brand-codecov", "IconBrandCodecov", [["path", { "d": "M9.695 12.985a5.972 5.972 0 0 0 -3.295 -.985c-1.257 0 -2.436 .339 -3.4 1a9 9 0 1 1 18 0c-.966 -.664 -2.14 -1 -3.4 -1a6 6 0 0 0 -5.605 8.144", "key": "svg-0" }]]);

var IconBrandCodecov$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCodecov
});

var IconBrandCodepen = createReactComponent("outline", "brand-codepen", "IconBrandCodepen", [["path", { "d": "M3 15l9 6l9 -6l-9 -6l-9 6", "key": "svg-0" }], ["path", { "d": "M3 9l9 6l9 -6l-9 -6l-9 6", "key": "svg-1" }], ["path", { "d": "M3 9l0 6", "key": "svg-2" }], ["path", { "d": "M21 9l0 6", "key": "svg-3" }], ["path", { "d": "M12 3l0 6", "key": "svg-4" }], ["path", { "d": "M12 15l0 6", "key": "svg-5" }]]);

var IconBrandCodepen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCodepen
});

var IconBrandCodesandbox = createReactComponent("outline", "brand-codesandbox", "IconBrandCodesandbox", [["path", { "d": "M20 7.5v9l-4 2.25l-4 2.25l-4 -2.25l-4 -2.25v-9l4 -2.25l4 -2.25l4 2.25z", "key": "svg-0" }], ["path", { "d": "M12 12l4 -2.25l4 -2.25", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }], ["path", { "d": "M12 12l-4 -2.25l-4 -2.25", "key": "svg-3" }], ["path", { "d": "M20 12l-4 2v4.75", "key": "svg-4" }], ["path", { "d": "M4 12l4 2l0 4.75", "key": "svg-5" }], ["path", { "d": "M8 5.25l4 2.25l4 -2.25", "key": "svg-6" }]]);

var IconBrandCodesandbox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCodesandbox
});

var IconBrandCohost = createReactComponent("outline", "brand-cohost", "IconBrandCohost", [["path", { "d": "M17 14m-3 0a3 2 0 1 0 6 0a3 2 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M4.526 17.666c-1.133 -.772 -1.897 -1.924 -2.291 -3.456c-.398 -1.54 -.29 -2.937 .32 -4.19c.61 -1.255 1.59 -2.34 2.938 -3.254c1.348 -.914 2.93 -1.625 4.749 -2.132c1.81 -.504 3.516 -.708 5.12 -.61c1.608 .1 2.979 .537 4.112 1.31s1.897 1.924 2.291 3.456c.398 1.541 .29 2.938 -.32 4.192c-.61 1.253 -1.59 2.337 -2.938 3.252c-1.348 .915 -2.93 1.626 -4.749 2.133c-1.81 .503 -3.516 .707 -5.12 .61c-1.608 -.102 -2.979 -.538 -4.112 -1.31z", "key": "svg-1" }], ["path", { "d": "M11 12.508c-.53 -.316 -1.23 -.508 -2 -.508c-1.657 0 -3 .895 -3 2s1.343 2 3 2c.767 0 1.467 -.192 2 -.508", "key": "svg-2" }]]);

var IconBrandCohost$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCohost
});

var IconBrandCoinbase = createReactComponent("outline", "brand-coinbase", "IconBrandCoinbase", [["path", { "d": "M12.95 22c-4.503 0 -8.445 -3.04 -9.61 -7.413c-1.165 -4.373 .737 -8.988 4.638 -11.25a9.906 9.906 0 0 1 12.008 1.598l-3.335 3.367a5.185 5.185 0 0 0 -7.354 .013a5.252 5.252 0 0 0 0 7.393a5.185 5.185 0 0 0 7.354 .013l3.349 3.367a9.887 9.887 0 0 1 -7.05 2.912z", "key": "svg-0" }]]);

var IconBrandCoinbase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCoinbase
});

var IconBrandComedyCentral = createReactComponent("outline", "brand-comedy-central", "IconBrandComedyCentral", [["path", { "d": "M5.343 17.657a8 8 0 1 0 0 -11.314", "key": "svg-0" }], ["path", { "d": "M13.828 9.172a4 4 0 1 0 0 5.656", "key": "svg-1" }]]);

var IconBrandComedyCentral$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandComedyCentral
});

var IconBrandCoreos = createReactComponent("outline", "brand-coreos", "IconBrandCoreos", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M12 3c-3.263 3.212 -3 7.654 -3 12c4.59 .244 8.814 -.282 12 -3", "key": "svg-1" }], ["path", { "d": "M9.5 9a4.494 4.494 0 0 1 5.5 5.5", "key": "svg-2" }]]);

var IconBrandCoreos$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCoreos
});

var IconBrandCouchdb = createReactComponent("outline", "brand-couchdb", "IconBrandCouchdb", [["path", { "d": "M6 12h12v-2a2 2 0 0 1 2 -2a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2a2 2 0 0 1 2 2v2z", "key": "svg-0" }], ["path", { "d": "M6 15h12", "key": "svg-1" }], ["path", { "d": "M6 18h12", "key": "svg-2" }], ["path", { "d": "M21 11v7", "key": "svg-3" }], ["path", { "d": "M3 11v7", "key": "svg-4" }]]);

var IconBrandCouchdb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCouchdb
});

var IconBrandCouchsurfing = createReactComponent("outline", "brand-couchsurfing", "IconBrandCouchsurfing", [["path", { "d": "M3.1 13c3.267 0 5.9 -.167 7.9 -.5c3 -.5 4 -2 4 -3.5a3 3 0 1 0 -6 0c0 1.554 1.807 3 3 4c1.193 1 2 2.5 2 3.5a1.5 1.5 0 1 1 -3 0c0 -2 4 -3.5 7 -3.5h2.9", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandCouchsurfing$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCouchsurfing
});

var IconBrandCpp = createReactComponent("outline", "brand-cpp", "IconBrandCpp", [["path", { "d": "M18 12h4", "key": "svg-0" }], ["path", { "d": "M20 10v4", "key": "svg-1" }], ["path", { "d": "M11 12h4", "key": "svg-2" }], ["path", { "d": "M13 10v4", "key": "svg-3" }], ["path", { "d": "M9 9a3 3 0 0 0 -3 -3h-.5a3.5 3.5 0 0 0 -3.5 3.5v5a3.5 3.5 0 0 0 3.5 3.5h.5a3 3 0 0 0 3 -3", "key": "svg-4" }]]);

var IconBrandCpp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCpp
});

var IconBrandCraft = createReactComponent("outline", "brand-craft", "IconBrandCraft", [["path", { "d": "M20 4h-8a8 8 0 1 0 0 16h8a8 8 0 0 0 -8 -8a8 8 0 0 0 8 -8", "key": "svg-0" }], ["path", { "d": "M4 12h8", "key": "svg-1" }], ["path", { "d": "M12 4v16", "key": "svg-2" }]]);

var IconBrandCraft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCraft
});

var IconBrandCrunchbase = createReactComponent("outline", "brand-crunchbase", "IconBrandCrunchbase", [["path", { "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M10.414 11.586a2 2 0 1 0 0 2.828", "key": "svg-1" }], ["path", { "d": "M15 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M13 7v6", "key": "svg-3" }]]);

var IconBrandCrunchbase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCrunchbase
});

var IconBrandCss3 = createReactComponent("outline", "brand-css3", "IconBrandCss3", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M8.5 8h7l-4.5 4h4l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5", "key": "svg-1" }]]);

var IconBrandCss3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCss3
});

var IconBrandCtemplar = createReactComponent("outline", "brand-ctemplar", "IconBrandCtemplar", [["path", { "d": "M6.04 14.831l4.46 -4.331", "key": "svg-0" }], ["path", { "d": "M12.555 20.82c4.55 -3.456 7.582 -8.639 8.426 -14.405a1.668 1.668 0 0 0 -.934 -1.767a19.647 19.647 0 0 0 -8.047 -1.648a19.647 19.647 0 0 0 -8.047 1.647a1.668 1.668 0 0 0 -.934 1.767c.844 5.766 3.875 10.95 8.426 14.406a.948 .948 0 0 0 1.11 0z", "key": "svg-1" }], ["path", { "d": "M20 5c-2 0 -4.37 3.304 -8 6.644c-3.63 -3.34 -6 -6.644 -8 -6.644", "key": "svg-2" }], ["path", { "d": "M17.738 15l-4.238 -4.5", "key": "svg-3" }]]);

var IconBrandCtemplar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCtemplar
});

var IconBrandCucumber = createReactComponent("outline", "brand-cucumber", "IconBrandCucumber", [["path", { "d": "M20 10.99c-.01 5.52 -4.48 10 -10 10.01v-2.26l-.01 -.01c-4.28 -1.11 -6.86 -5.47 -5.76 -9.75a8 8 0 0 1 9.74 -5.76c3.53 .91 6.03 4.13 6.03 7.78v-.01z", "key": "svg-0" }], ["path", { "d": "M10.5 8l-.5 -1", "key": "svg-1" }], ["path", { "d": "M13.5 14l.5 1", "key": "svg-2" }], ["path", { "d": "M9 12.5l-1 .5", "key": "svg-3" }], ["path", { "d": "M11 14l-.5 1", "key": "svg-4" }], ["path", { "d": "M13 8l.5 -1", "key": "svg-5" }], ["path", { "d": "M16 12.5l-1 -.5", "key": "svg-6" }], ["path", { "d": "M9 10l-1 -.5", "key": "svg-7" }]]);

var IconBrandCucumber$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCucumber
});

var IconBrandCupra = createReactComponent("outline", "brand-cupra", "IconBrandCupra", [["path", { "d": "M4.5 10l-2.5 -4l15.298 6.909a.2 .2 0 0 1 .09 .283l-3.388 5.808", "key": "svg-0" }], ["path", { "d": "M10 19l-3.388 -5.808a.2 .2 0 0 1 .09 -.283l15.298 -6.909l-2.5 4", "key": "svg-1" }]]);

var IconBrandCupra$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCupra
});

var IconBrandCypress = createReactComponent("outline", "brand-cypress", "IconBrandCypress", [["path", { "d": "M19.48 17.007a9 9 0 1 0 -7.48 3.993c.896 0 1.691 -.573 1.974 -1.423l3.526 -10.577", "key": "svg-0" }], ["path", { "d": "M13.5 9l2 6", "key": "svg-1" }], ["path", { "d": "M10.764 9.411a3 3 0 1 0 -.023 5.19", "key": "svg-2" }]]);

var IconBrandCypress$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandCypress
});

var IconBrandD3 = createReactComponent("outline", "brand-d3", "IconBrandD3", [["path", { "d": "M3 4h1.8c3.976 0 7.2 3.582 7.2 8s-3.224 8 -7.2 8h-1.8", "key": "svg-0" }], ["path", { "d": "M12 4h5.472c1.948 0 3.528 1.79 3.528 4s-1.58 4 -3.528 4", "key": "svg-1" }], ["path", { "d": "M17.472 12h-2.472", "key": "svg-2" }], ["path", { "d": "M17.472 12h-2.352", "key": "svg-3" }], ["path", { "d": "M17.472 12c1.948 0 3.528 1.79 3.528 4s-1.58 4 -3.528 4h-5.472", "key": "svg-4" }]]);

var IconBrandD3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandD3
});

var IconBrandDatabricks = createReactComponent("outline", "brand-databricks", "IconBrandDatabricks", [["path", { "d": "M3 17l9 5l9 -5v-3l-9 5l-9 -5v-3l9 5l9 -5v-3l-9 5l-9 -5l9 -5l5.418 3.01", "key": "svg-0" }]]);

var IconBrandDatabricks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDatabricks
});

var IconBrandDaysCounter = createReactComponent("outline", "brand-days-counter", "IconBrandDaysCounter", [["path", { "d": "M20.779 10.007a9 9 0 1 0 -10.77 10.772", "key": "svg-0" }], ["path", { "d": "M13 21h8v-7", "key": "svg-1" }], ["path", { "d": "M12 8v4l3 3", "key": "svg-2" }]]);

var IconBrandDaysCounter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDaysCounter
});

var IconBrandDcos = createReactComponent("outline", "brand-dcos", "IconBrandDcos", [["path", { "d": "M3 18l18 -12h-18l9 14l9 -14v10l-18 -10z", "key": "svg-0" }]]);

var IconBrandDcos$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDcos
});

var IconBrandDebian = createReactComponent("outline", "brand-debian", "IconBrandDebian", [["path", { "d": "M12 17c-2.397 -.943 -4 -3.153 -4 -5.635c0 -2.19 1.039 -3.14 1.604 -3.595c2.646 -2.133 6.396 -.27 6.396 3.23c0 2.5 -2.905 2.121 -3.5 1.5c-.595 -.621 -1 -1.5 -.5 -2.5", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandDebian$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDebian
});

var IconBrandDeezer = createReactComponent("outline", "brand-deezer", "IconBrandDeezer", [["path", { "d": "M3 16.5h2v.5h-2z", "key": "svg-0" }], ["path", { "d": "M8 16.5h2.5v.5h-2.5z", "key": "svg-1" }], ["path", { "d": "M16 17h-2.5v-.5h2.5z", "key": "svg-2" }], ["path", { "d": "M21.5 17h-2.5v-.5h2.5z", "key": "svg-3" }], ["path", { "d": "M21.5 13h-2.5v.5h2.5z", "key": "svg-4" }], ["path", { "d": "M21.5 9.5h-2.5v.5h2.5z", "key": "svg-5" }], ["path", { "d": "M21.5 6h-2.5v.5h2.5z", "key": "svg-6" }], ["path", { "d": "M16 13h-2.5v.5h2.5z", "key": "svg-7" }], ["path", { "d": "M8 13.5h2.5v-.5h-2.5z", "key": "svg-8" }], ["path", { "d": "M8 9.5h2.5v.5h-2.5z", "key": "svg-9" }]]);

var IconBrandDeezer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDeezer
});

var IconBrandDeliveroo = createReactComponent("outline", "brand-deliveroo", "IconBrandDeliveroo", [["path", { "d": "M15 11l1 -9l5 .5l-1 13.5l-3 6l-12.5 -2.5l-1.5 -6l7 -1.5l-1.5 -7.5l4.5 -1z", "key": "svg-0" }], ["circle", { "cx": "15.5", "cy": "15.5", "r": "1", "fill": "currentColor", "key": "svg-1" }], ["circle", { "cx": "11.5", "cy": "14.5", "r": "1", "fill": "currentColor", "key": "svg-2" }]]);

var IconBrandDeliveroo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDeliveroo
});

var IconBrandDeno = createReactComponent("outline", "brand-deno", "IconBrandDeno", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M13.47 20.882l-1.47 -5.882c-2.649 -.088 -5 -1.624 -5 -3.5c0 -1.933 2.239 -3.5 5 -3.5s4 1 5 3c.024 .048 .69 2.215 2 6.5", "key": "svg-1" }], ["path", { "d": "M12 11h.01", "key": "svg-2" }]]);

var IconBrandDeno$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDeno
});

var IconBrandDenodo = createReactComponent("outline", "brand-denodo", "IconBrandDenodo", [["path", { "d": "M11 11h2v2h-2z", "key": "svg-0" }], ["path", { "d": "M3.634 15.634l1.732 -1l1 1.732l-1.732 1z", "key": "svg-1" }], ["path", { "d": "M11 19h2v2h-2z", "key": "svg-2" }], ["path", { "d": "M18.634 14.634l1.732 1l-1 1.732l-1.732 -1z", "key": "svg-3" }], ["path", { "d": "M17.634 7.634l1.732 -1l1 1.732l-1.732 1z", "key": "svg-4" }], ["path", { "d": "M11 3h2v2h-2z", "key": "svg-5" }], ["path", { "d": "M3.634 8.366l1 -1.732l1.732 1l-1 1.732z", "key": "svg-6" }]]);

var IconBrandDenodo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDenodo
});

var IconBrandDeviantart = createReactComponent("outline", "brand-deviantart", "IconBrandDeviantart", [["path", { "d": "M18 3v4l-3.857 6h3.857v4h-6.429l-2.571 4h-3v-4l3.857 -6h-3.857v-4h6.429l2.571 -4z", "key": "svg-0" }]]);

var IconBrandDeviantart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDeviantart
});

var IconBrandDigg = createReactComponent("outline", "brand-digg", "IconBrandDigg", [["path", { "d": "M6 15h-3v-4h3", "key": "svg-0" }], ["path", { "d": "M15 15h-3v-4h3", "key": "svg-1" }], ["path", { "d": "M9 15v-4", "key": "svg-2" }], ["path", { "d": "M15 11v7h-3", "key": "svg-3" }], ["path", { "d": "M6 7v8", "key": "svg-4" }], ["path", { "d": "M21 15h-3v-4h3", "key": "svg-5" }], ["path", { "d": "M21 11v7h-3", "key": "svg-6" }]]);

var IconBrandDigg$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDigg
});

var IconBrandDingtalk = createReactComponent("outline", "brand-dingtalk", "IconBrandDingtalk", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M8 7.5l7.02 2.632a1 1 0 0 1 .567 1.33l-1.087 2.538h1.5l-5 4l1 -4c-3.1 .03 -3.114 -3.139 -4 -6.5z", "key": "svg-1" }]]);

var IconBrandDingtalk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDingtalk
});

var IconBrandDiscord = createReactComponent("outline", "brand-discord", "IconBrandDiscord", [["path", { "d": "M8 12a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-0" }], ["path", { "d": "M14 12a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-1" }], ["path", { "d": "M15.5 17c0 1 1.5 3 2 3c1.5 0 2.833 -1.667 3.5 -3c.667 -1.667 .5 -5.833 -1.5 -11.5c-1.457 -1.015 -3 -1.34 -4.5 -1.5l-.972 1.923a11.913 11.913 0 0 0 -4.053 0l-.975 -1.923c-1.5 .16 -3.043 .485 -4.5 1.5c-2 5.667 -2.167 9.833 -1.5 11.5c.667 1.333 2 3 3.5 3c.5 0 2 -2 2 -3", "key": "svg-2" }], ["path", { "d": "M7 16.5c3.5 1 6.5 1 10 0", "key": "svg-3" }]]);

var IconBrandDiscord$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDiscord
});

var IconBrandDisney = createReactComponent("outline", "brand-disney", "IconBrandDisney", [["path", { "d": "M3.22 5.838c-1.307 -.15 -1.22 -.578 -1.22 -.794c0 -.216 .424 -1.044 4.34 -1.044c4.694 0 14.66 3.645 14.66 10.042s-8.71 4.931 -10.435 4.52c-1.724 -.412 -5.565 -2.256 -5.565 -4.174c0 -1.395 3.08 -2.388 6.715 -2.388c3.634 0 5.285 1.041 5.285 2c0 .5 -.074 1.229 -1 1.5", "key": "svg-0" }], ["path", { "d": "M10.02 8a505.153 505.153 0 0 0 0 13", "key": "svg-1" }]]);

var IconBrandDisney$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDisney
});

var IconBrandDisqus = createReactComponent("outline", "brand-disqus", "IconBrandDisqus", [["path", { "d": "M11.847 21c-2.259 0 -4.323 -.667 -5.919 -2h-3.928l1.708 -3.266c-.545 -1.174 -.759 -2.446 -.758 -3.734c0 -4.97 3.84 -9 8.898 -9c5.052 0 9.152 4.03 9.152 9c0 4.972 -4.098 9 -9.153 9z", "key": "svg-0" }], ["path", { "d": "M11.485 15h-1.485v-6h1.485c2.112 0 3.515 .823 3.515 2.981v.035c0 2.18 -1.403 2.984 -3.515 2.984z", "key": "svg-1" }]]);

var IconBrandDisqus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDisqus
});

var IconBrandDjango = createReactComponent("outline", "brand-django", "IconBrandDjango", [["path", { "d": "M3 3m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M12 7v8.5l-2.015 .201a2.715 2.715 0 1 1 0 -5.402l2.015 .201", "key": "svg-1" }], ["path", { "d": "M16 7v.01", "key": "svg-2" }], ["path", { "d": "M16 10v5.586c0 .905 -.36 1.774 -1 2.414", "key": "svg-3" }]]);

var IconBrandDjango$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDjango
});

var IconBrandDocker = createReactComponent("outline", "brand-docker", "IconBrandDocker", [["path", { "d": "M22 12.54c-1.804 -.345 -2.701 -1.08 -3.523 -2.94c-.487 .696 -1.102 1.568 -.92 2.4c.028 .238 -.32 1 -.557 1h-14c0 5.208 3.164 7 6.196 7c4.124 .022 7.828 -1.376 9.854 -5c1.146 -.101 2.296 -1.505 2.95 -2.46z", "key": "svg-0" }], ["path", { "d": "M5 10h3v3h-3z", "key": "svg-1" }], ["path", { "d": "M8 10h3v3h-3z", "key": "svg-2" }], ["path", { "d": "M11 10h3v3h-3z", "key": "svg-3" }], ["path", { "d": "M8 7h3v3h-3z", "key": "svg-4" }], ["path", { "d": "M11 7h3v3h-3z", "key": "svg-5" }], ["path", { "d": "M11 4h3v3h-3z", "key": "svg-6" }], ["path", { "d": "M4.571 18c1.5 0 2.047 -.074 2.958 -.78", "key": "svg-7" }], ["path", { "d": "M10 16l0 .01", "key": "svg-8" }]]);

var IconBrandDocker$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDocker
});

var IconBrandDoctrine = createReactComponent("outline", "brand-doctrine", "IconBrandDoctrine", [["path", { "d": "M12 14m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M9 14h6", "key": "svg-1" }], ["path", { "d": "M12 11l3 3l-3 3", "key": "svg-2" }], ["path", { "d": "M10 3l6.9 6", "key": "svg-3" }]]);

var IconBrandDoctrine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDoctrine
});

var IconBrandDolbyDigital = createReactComponent("outline", "brand-dolby-digital", "IconBrandDolbyDigital", [["path", { "d": "M21 6v12h-.89c-3.34 0 -6.047 -2.686 -6.047 -6s2.707 -6 6.046 -6h.891z", "key": "svg-0" }], ["path", { "d": "M3.063 6v12h.891c3.34 0 6.046 -2.686 6.046 -6s-2.707 -6 -6.046 -6h-.89z", "key": "svg-1" }]]);

var IconBrandDolbyDigital$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDolbyDigital
});

var IconBrandDouban = createReactComponent("outline", "brand-douban", "IconBrandDouban", [["path", { "d": "M4 20h16", "key": "svg-0" }], ["path", { "d": "M5 4h14", "key": "svg-1" }], ["path", { "d": "M8 8h8a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-2a2 2 0 0 1 2 -2z", "key": "svg-2" }], ["path", { "d": "M16 14l-2 6", "key": "svg-3" }], ["path", { "d": "M8 17l1 3", "key": "svg-4" }]]);

var IconBrandDouban$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDouban
});

var IconBrandDribbble = createReactComponent("outline", "brand-dribbble", "IconBrandDribbble", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 3.6c5 6 7 10.5 7.5 16.2", "key": "svg-1" }], ["path", { "d": "M6.4 19c3.5 -3.5 6 -6.5 14.5 -6.4", "key": "svg-2" }], ["path", { "d": "M3.1 10.75c5 0 9.814 -.38 15.314 -5", "key": "svg-3" }]]);

var IconBrandDribbble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDribbble
});

var IconBrandDrops = createReactComponent("outline", "brand-drops", "IconBrandDrops", [["path", { "d": "M17.637 7.416a7.907 7.907 0 0 1 1.76 8.666a8 8 0 0 1 -7.397 4.918a8 8 0 0 1 -7.396 -4.918a7.907 7.907 0 0 1 1.759 -8.666l5.637 -5.416l5.637 5.416z", "key": "svg-0" }], ["path", { "d": "M14.466 10.923a3.595 3.595 0 0 1 .77 3.877a3.5 3.5 0 0 1 -3.236 2.2a3.5 3.5 0 0 1 -3.236 -2.2a3.595 3.595 0 0 1 .77 -3.877l2.466 -2.423l2.466 2.423z", "key": "svg-1" }]]);

var IconBrandDrops$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDrops
});

var IconBrandDrupal = createReactComponent("outline", "brand-drupal", "IconBrandDrupal", [["path", { "d": "M12 2c0 4.308 -7 6 -7 12a7 7 0 0 0 14 0c0 -6 -7 -7.697 -7 -12z", "key": "svg-0" }], ["path", { "d": "M12 11.33a65.753 65.753 0 0 1 -2.012 2.023c-1 .957 -1.988 1.967 -1.988 3.647c0 2.17 1.79 4 4 4s4 -1.827 4 -4c0 -1.676 -.989 -2.685 -1.983 -3.642c-.42 -.404 -2.259 -2.357 -5.517 -5.858l3.5 3.83z", "key": "svg-1" }]]);

var IconBrandDrupal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandDrupal
});

var IconBrandEdge = createReactComponent("outline", "brand-edge", "IconBrandEdge", [["path", { "d": "M20.978 11.372a9 9 0 1 0 -1.593 5.773", "key": "svg-0" }], ["path", { "d": "M20.978 11.372c.21 2.993 -5.034 2.413 -6.913 1.486c1.392 -1.6 .402 -4.038 -2.274 -3.851c-1.745 .122 -2.927 1.157 -2.784 3.202c.28 3.99 4.444 6.205 10.36 4.79", "key": "svg-1" }], ["path", { "d": "M3.022 12.628c-.283 -4.043 8.717 -7.228 11.248 -2.688", "key": "svg-2" }], ["path", { "d": "M12.628 20.978c-2.993 .21 -5.162 -4.725 -3.567 -9.748", "key": "svg-3" }]]);

var IconBrandEdge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandEdge
});

var IconBrandElastic = createReactComponent("outline", "brand-elastic", "IconBrandElastic", [["path", { "d": "M14 2a5 5 0 0 1 5 5c0 .712 -.232 1.387 -.5 2c1.894 .042 3.5 1.595 3.5 3.5c0 1.869 -1.656 3.4 -3.5 3.5c.333 .625 .5 1.125 .5 1.5a2.5 2.5 0 0 1 -2.5 2.5c-.787 0 -1.542 -.432 -2 -1c-.786 1.73 -2.476 3 -4.5 3a5 5 0 0 1 -4.583 -7a3.5 3.5 0 0 1 -.11 -6.992l.195 0a2.5 2.5 0 0 1 2 -4c.787 0 1.542 .432 2 1c.786 -1.73 2.476 -3 4.5 -3z", "key": "svg-0" }], ["path", { "d": "M8.5 9l-3 -1", "key": "svg-1" }], ["path", { "d": "M9.5 5l-1 4l1 2l5 2l4 -4", "key": "svg-2" }], ["path", { "d": "M18.499 16l-3 -.5l-1 -2.5", "key": "svg-3" }], ["path", { "d": "M14.5 19l1 -3.5", "key": "svg-4" }], ["path", { "d": "M5.417 15l4.083 -4", "key": "svg-5" }]]);

var IconBrandElastic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandElastic
});

var IconBrandElectronicArts = createReactComponent("outline", "brand-electronic-arts", "IconBrandElectronicArts", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M17.5 15l-3 -6l-3 6h-5l1.5 -3", "key": "svg-1" }], ["path", { "d": "M17 14h-2", "key": "svg-2" }], ["path", { "d": "M6.5 12h3.5", "key": "svg-3" }], ["path", { "d": "M8 9h3", "key": "svg-4" }]]);

var IconBrandElectronicArts$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandElectronicArts
});

var IconBrandEmber = createReactComponent("outline", "brand-ember", "IconBrandEmber", [["path", { "d": "M3 12.958c8.466 1.647 11.112 -1.196 12.17 -2.294c2.116 -2.196 0 -6.589 -2.646 -5.49c-2.644 1.096 -6.35 7.686 -3.174 12.078c2.116 2.928 6 2.178 11.65 -2.252", "key": "svg-0" }]]);

var IconBrandEmber$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandEmber
});

var IconBrandEnvato = createReactComponent("outline", "brand-envato", "IconBrandEnvato", [["path", { "d": "M4.711 17.875c-.534 -1.339 -1.35 -4.178 .129 -6.47c1.415 -2.193 3.769 -3.608 5.099 -4.278l-5.229 10.748z", "key": "svg-0" }], ["path", { "d": "M19.715 12.508c-.54 3.409 -2.094 6.156 -4.155 7.348c-4.069 2.353 -8.144 .45 -9.297 -.188c.877 -1.436 4.433 -7.22 6.882 -10.591c2.714 -3.737 5.864 -5.978 6.565 -6.077c0 .201 .03 .55 .071 1.03c.144 1.709 .443 5.264 -.066 8.478z", "key": "svg-1" }]]);

var IconBrandEnvato$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandEnvato
});

var IconBrandEtsy = createReactComponent("outline", "brand-etsy", "IconBrandEtsy", [["path", { "d": "M14 12h-5", "key": "svg-0" }], ["path", { "d": "M3 3m0 5a5 5 0 0 1 5 -5h8a5 5 0 0 1 5 5v8a5 5 0 0 1 -5 5h-8a5 5 0 0 1 -5 -5z", "key": "svg-1" }], ["path", { "d": "M15 16h-5a1 1 0 0 1 -1 -1v-6a1 1 0 0 1 1 -1h5", "key": "svg-2" }]]);

var IconBrandEtsy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandEtsy
});

var IconBrandEvernote = createReactComponent("outline", "brand-evernote", "IconBrandEvernote", [["path", { "d": "M4 8h5v-5", "key": "svg-0" }], ["path", { "d": "M17.9 19c.6 -2.5 1.1 -5.471 1.1 -9c0 -4.5 -2 -5 -3 -5c-1.906 0 -3 -.5 -3.5 -1c-.354 -.354 -.5 -1 -1.5 -1h-2l-5 5c0 6 2.5 8 5 8c1 0 1.5 -.5 2 -1.5s1.414 -.326 2.5 0c1.044 .313 2.01 .255 2.5 .5c1 .5 2 1.5 2 3c0 .5 0 3 -3 3s-3 -3 -1 -3", "key": "svg-1" }], ["path", { "d": "M15 10h1", "key": "svg-2" }]]);

var IconBrandEvernote$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandEvernote
});

var IconBrandFacebook = createReactComponent("outline", "brand-facebook", "IconBrandFacebook", [["path", { "d": "M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3", "key": "svg-0" }]]);

var IconBrandFacebook$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFacebook
});

var IconBrandFeedly = createReactComponent("outline", "brand-feedly", "IconBrandFeedly", [["path", { "d": "M7.833 12.278l4.445 -4.445", "key": "svg-0" }], ["path", { "d": "M10.055 14.5l2.223 -2.222", "key": "svg-1" }], ["path", { "d": "M12.278 16.722l.555 -.555", "key": "svg-2" }], ["path", { "d": "M19.828 14.828a4 4 0 0 0 0 -5.656l-5 -5a4 4 0 0 0 -5.656 0l-5 5a4 4 0 0 0 0 5.656l6.171 6.172h3.314l6.171 -6.172z", "key": "svg-3" }]]);

var IconBrandFeedly$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFeedly
});

var IconBrandFigma = createReactComponent("outline", "brand-figma", "IconBrandFigma", [["path", { "d": "M15 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M6 3m0 3a3 3 0 0 1 3 -3h6a3 3 0 0 1 3 3v0a3 3 0 0 1 -3 3h-6a3 3 0 0 1 -3 -3z", "key": "svg-1" }], ["path", { "d": "M9 9a3 3 0 0 0 0 6h3m-3 0a3 3 0 1 0 3 3v-15", "key": "svg-2" }]]);

var IconBrandFigma$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFigma
});

var IconBrandFilezilla = createReactComponent("outline", "brand-filezilla", "IconBrandFilezilla", [["path", { "d": "M16 15.824a4.062 4.062 0 0 1 -2.25 .033c-.738 -.201 -2.018 -.08 -2.75 .143l4.583 -5h-6.583", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M8 15l2 -8h5", "key": "svg-2" }]]);

var IconBrandFilezilla$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFilezilla
});

var IconBrandFinder = createReactComponent("outline", "brand-finder", "IconBrandFinder", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 8v1", "key": "svg-1" }], ["path", { "d": "M17 8v1", "key": "svg-2" }], ["path", { "d": "M12.5 4c-.654 1.486 -1.26 3.443 -1.5 9h2.5c-.19 2.867 .094 5.024 .5 7", "key": "svg-3" }], ["path", { "d": "M7 15.5c3.667 2 6.333 2 10 0", "key": "svg-4" }]]);

var IconBrandFinder$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFinder
});

var IconBrandFirebase = createReactComponent("outline", "brand-firebase", "IconBrandFirebase", [["path", { "d": "M4.53 17.05l6.15 -11.72h-.02c.38 -.74 1.28 -1.02 2.01 -.63c.26 .14 .48 .36 .62 .62l1.06 2.01", "key": "svg-0" }], ["path", { "d": "M15.47 6.45c.58 -.59 1.53 -.59 2.11 -.01c.22 .22 .36 .5 .41 .81l1.5 9.11c.1 .62 -.2 1.24 -.76 1.54l-6.07 2.9c-.46 .25 -1.01 .26 -1.46 0l-6.02 -2.92c-.55 -.31 -.85 -.92 -.75 -1.54l1.96 -12.04c.12 -.82 .89 -1.38 1.7 -1.25c.46 .07 .87 .36 1.09 .77l1.24 1.76", "key": "svg-1" }], ["path", { "d": "M4.57 17.18l10.93 -10.68", "key": "svg-2" }]]);

var IconBrandFirebase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFirebase
});

var IconBrandFirefox = createReactComponent("outline", "brand-firefox", "IconBrandFirefox", [["path", { "d": "M4.028 7.82a9 9 0 1 0 12.823 -3.4c-1.636 -1.02 -3.064 -1.02 -4.851 -1.02h-1.647", "key": "svg-0" }], ["path", { "d": "M4.914 9.485c-1.756 -1.569 -.805 -5.38 .109 -6.17c.086 .896 .585 1.208 1.111 1.685c.88 -.275 1.313 -.282 1.867 0c.82 -.91 1.694 -2.354 2.628 -2.093c-1.082 1.741 -.07 3.733 1.371 4.173c-.17 .975 -1.484 1.913 -2.76 2.686c-1.296 .938 -.722 1.85 0 2.234c.949 .506 3.611 -1 4.545 .354c-1.698 .102 -1.536 3.107 -3.983 2.727c2.523 .957 4.345 .462 5.458 -.34c1.965 -1.52 2.879 -3.542 2.879 -5.557c-.014 -1.398 .194 -2.695 -1.26 -4.75", "key": "svg-1" }]]);

var IconBrandFirefox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFirefox
});

var IconBrandFiverr = createReactComponent("outline", "brand-fiverr", "IconBrandFiverr", [["path", { "d": "M15 3h-2a6 6 0 0 0 -6 6h-3v4h3v8h4v-7h4v7h4v-11h-8v-1.033a1.967 1.967 0 0 1 2 -1.967h2v-4z", "key": "svg-0" }]]);

var IconBrandFiverr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFiverr
});

var IconBrandFlickr = createReactComponent("outline", "brand-flickr", "IconBrandFlickr", [["path", { "d": "M7 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandFlickr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFlickr
});

var IconBrandFlightradar24 = createReactComponent("outline", "brand-flightradar24", "IconBrandFlightradar24", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-1" }], ["path", { "d": "M8.5 20l3.5 -8l-6.5 6", "key": "svg-2" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBrandFlightradar24$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFlightradar24
});

var IconBrandFlipboard = createReactComponent("outline", "brand-flipboard", "IconBrandFlipboard", [["path", { "d": "M3.973 3h16.054c.537 0 .973 .436 .973 .973v4.052a.973 .973 0 0 1 -.973 .973h-5.025v4.831c0 .648 -.525 1.173 -1.173 1.173h-4.829v5.025a.973 .973 0 0 1 -.974 .973h-4.053a.973 .973 0 0 1 -.973 -.973v-16.054c0 -.537 .436 -.973 .973 -.973z", "key": "svg-0" }]]);

var IconBrandFlipboard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFlipboard
});

var IconBrandFlutter = createReactComponent("outline", "brand-flutter", "IconBrandFlutter", [["path", { "d": "M7 14l-3 -3l8 -8h6z", "key": "svg-0" }], ["path", { "d": "M14 21l-5 -5l5 -5h5l-5 5l5 5z", "key": "svg-1" }]]);

var IconBrandFlutter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFlutter
});

var IconBrandFortnite = createReactComponent("outline", "brand-fortnite", "IconBrandFortnite", [["path", { "d": "M8 3h7.5l-.5 4h-3v3h3v3.5h-3v6.5l-4 1z", "key": "svg-0" }]]);

var IconBrandFortnite$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFortnite
});

var IconBrandFoursquare = createReactComponent("outline", "brand-foursquare", "IconBrandFoursquare", [["path", { "d": "M7 3h10c.644 0 1.11 .696 .978 1.33l-1.984 9.859a1.014 1.014 0 0 1 -1 .811h-2.254c-.308 0 -.6 .141 -.793 .382l-4.144 5.25c-.599 .752 -1.809 .331 -1.809 -.632v-16c0 -.564 .44 -1 1 -1z", "key": "svg-0" }], ["path", { "d": "M12 9l5 0", "key": "svg-1" }]]);

var IconBrandFoursquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFoursquare
});

var IconBrandFramerMotion = createReactComponent("outline", "brand-framer-motion", "IconBrandFramerMotion", [["path", { "d": "M12 12l-8 -8v16l16 -16v16l-4 -4", "key": "svg-0" }], ["path", { "d": "M20 12l-8 8l-4 -4", "key": "svg-1" }]]);

var IconBrandFramerMotion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFramerMotion
});

var IconBrandFramer = createReactComponent("outline", "brand-framer", "IconBrandFramer", [["path", { "d": "M6 15h12l-12 -12h12v6h-12v6l6 6v-6", "key": "svg-0" }]]);

var IconBrandFramer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFramer
});

var IconBrandFunimation = createReactComponent("outline", "brand-funimation", "IconBrandFunimation", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 13h8a4 4 0 1 1 -8 0z", "key": "svg-1" }]]);

var IconBrandFunimation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandFunimation
});

var IconBrandGatsby = createReactComponent("outline", "brand-gatsby", "IconBrandGatsby", [["path", { "d": "M3.296 14.297l6.407 6.407a9.018 9.018 0 0 1 -6.325 -6.116l-.082 -.291z", "key": "svg-0" }], ["path", { "d": "M16 13h5c-.41 3.603 -3.007 6.59 -6.386 7.614l-11.228 -11.229a9 9 0 0 1 15.66 -2.985", "key": "svg-1" }]]);

var IconBrandGatsby$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGatsby
});

var IconBrandGit = createReactComponent("outline", "brand-git", "IconBrandGit", [["path", { "d": "M16 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M12 15v-6", "key": "svg-3" }], ["path", { "d": "M15 11l-2 -2", "key": "svg-4" }], ["path", { "d": "M11 7l-1.9 -1.9", "key": "svg-5" }], ["path", { "d": "M13.446 2.6l7.955 7.954a2.045 2.045 0 0 1 0 2.892l-7.955 7.955a2.045 2.045 0 0 1 -2.892 0l-7.955 -7.955a2.045 2.045 0 0 1 0 -2.892l7.955 -7.955a2.045 2.045 0 0 1 2.892 0z", "key": "svg-6" }]]);

var IconBrandGit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGit
});

var IconBrandGithubCopilot = createReactComponent("outline", "brand-github-copilot", "IconBrandGithubCopilot", [["path", { "d": "M4 18v-5.5c0 -.667 .167 -1.333 .5 -2", "key": "svg-0" }], ["path", { "d": "M12 7.5c0 -1 -.01 -4.07 -4 -3.5c-3.5 .5 -4 2.5 -4 3.5c0 1.5 0 4 3 4c4 0 5 -2.5 5 -4z", "key": "svg-1" }], ["path", { "d": "M4 12c-1.333 .667 -2 1.333 -2 2c0 1 0 3 1.5 4c3 2 6.5 3 8.5 3s5.499 -1 8.5 -3c1.5 -1 1.5 -3 1.5 -4c0 -.667 -.667 -1.333 -2 -2", "key": "svg-2" }], ["path", { "d": "M20 18v-5.5c0 -.667 -.167 -1.333 -.5 -2", "key": "svg-3" }], ["path", { "d": "M12 7.5l0 -.297l.01 -.269l.027 -.298l.013 -.105l.033 -.215c.014 -.073 .029 -.146 .046 -.22l.06 -.223c.336 -1.118 1.262 -2.237 3.808 -1.873c2.838 .405 3.703 1.797 3.93 2.842l.036 .204c0 .033 .01 .066 .013 .098l.016 .185l0 .171l0 .49l-.015 .394l-.02 .271c-.122 1.366 -.655 2.845 -2.962 2.845c-3.256 0 -4.524 -1.656 -4.883 -3.081l-.053 -.242a3.865 3.865 0 0 1 -.036 -.235l-.021 -.227a3.518 3.518 0 0 1 -.007 -.215z", "key": "svg-4" }], ["path", { "d": "M10 15v2", "key": "svg-5" }], ["path", { "d": "M14 15v2", "key": "svg-6" }]]);

var IconBrandGithubCopilot$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGithubCopilot
});

var IconBrandGithub = createReactComponent("outline", "brand-github", "IconBrandGithub", [["path", { "d": "M9 19c-4.3 1.4 -4.3 -2.5 -6 -3m12 5v-3.5c0 -1 .1 -1.4 -.5 -2c2.8 -.3 5.5 -1.4 5.5 -6a4.6 4.6 0 0 0 -1.3 -3.2a4.2 4.2 0 0 0 -.1 -3.2s-1.1 -.3 -3.5 1.3a12.3 12.3 0 0 0 -6.2 0c-2.4 -1.6 -3.5 -1.3 -3.5 -1.3a4.2 4.2 0 0 0 -.1 3.2a4.6 4.6 0 0 0 -1.3 3.2c0 4.6 2.7 5.7 5.5 6c-.6 .6 -.6 1.2 -.5 2v3.5", "key": "svg-0" }]]);

var IconBrandGithub$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGithub
});

var IconBrandGitlab = createReactComponent("outline", "brand-gitlab", "IconBrandGitlab", [["path", { "d": "M21 14l-9 7l-9 -7l3 -11l3 7h6l3 -7z", "key": "svg-0" }]]);

var IconBrandGitlab$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGitlab
});

var IconBrandGmail = createReactComponent("outline", "brand-gmail", "IconBrandGmail", [["path", { "d": "M16 20h3a1 1 0 0 0 1 -1v-14a1 1 0 0 0 -1 -1h-3v16z", "key": "svg-0" }], ["path", { "d": "M5 20h3v-16h-3a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1z", "key": "svg-1" }], ["path", { "d": "M16 4l-4 4l-4 -4", "key": "svg-2" }], ["path", { "d": "M4 6.5l8 7.5l8 -7.5", "key": "svg-3" }]]);

var IconBrandGmail$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGmail
});

var IconBrandGolang = createReactComponent("outline", "brand-golang", "IconBrandGolang", [["path", { "d": "M15.695 14.305c1.061 1.06 2.953 .888 4.226 -.384c1.272 -1.273 1.444 -3.165 .384 -4.226c-1.061 -1.06 -2.953 -.888 -4.226 .384c-1.272 1.273 -1.444 3.165 -.384 4.226z", "key": "svg-0" }], ["path", { "d": "M12.68 9.233c-1.084 -.497 -2.545 -.191 -3.591 .846c-1.284 1.273 -1.457 3.165 -.388 4.226c1.07 1.06 2.978 .888 4.261 -.384a3.669 3.669 0 0 0 1.038 -1.921h-2.427", "key": "svg-1" }], ["path", { "d": "M5.5 15h-1.5", "key": "svg-2" }], ["path", { "d": "M6 9h-2", "key": "svg-3" }], ["path", { "d": "M5 12h-3", "key": "svg-4" }]]);

var IconBrandGolang$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGolang
});

var IconBrandGoogleAnalytics = createReactComponent("outline", "brand-google-analytics", "IconBrandGoogleAnalytics", [["path", { "d": "M10 9m0 1.105a1.105 1.105 0 0 1 1.105 -1.105h1.79a1.105 1.105 0 0 1 1.105 1.105v9.79a1.105 1.105 0 0 1 -1.105 1.105h-1.79a1.105 1.105 0 0 1 -1.105 -1.105z", "key": "svg-0" }], ["path", { "d": "M17 3m0 1.105a1.105 1.105 0 0 1 1.105 -1.105h1.79a1.105 1.105 0 0 1 1.105 1.105v15.79a1.105 1.105 0 0 1 -1.105 1.105h-1.79a1.105 1.105 0 0 1 -1.105 -1.105z", "key": "svg-1" }], ["path", { "d": "M5 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandGoogleAnalytics$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleAnalytics
});

var IconBrandGoogleBigQuery = createReactComponent("outline", "brand-google-big-query", "IconBrandGoogleBigQuery", [["path", { "d": "M17.73 19.875a2.225 2.225 0 0 1 -1.948 1.125h-7.283a2.222 2.222 0 0 1 -1.947 -1.158l-4.272 -6.75a2.269 2.269 0 0 1 0 -2.184l4.272 -6.75a2.225 2.225 0 0 1 1.946 -1.158h7.285c.809 0 1.554 .443 1.947 1.158l3.98 6.75a2.33 2.33 0 0 1 0 2.25l-3.98 6.75v-.033z", "key": "svg-0" }], ["path", { "d": "M11.5 11.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-1" }], ["path", { "d": "M14 14l2 2", "key": "svg-2" }]]);

var IconBrandGoogleBigQuery$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleBigQuery
});

var IconBrandGoogleDrive = createReactComponent("outline", "brand-google-drive", "IconBrandGoogleDrive", [["path", { "d": "M12 10l-6 10l-3 -5l6 -10z", "key": "svg-0" }], ["path", { "d": "M9 15h12l-3 5h-12", "key": "svg-1" }], ["path", { "d": "M15 15l-6 -10h6l6 10z", "key": "svg-2" }]]);

var IconBrandGoogleDrive$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleDrive
});

var IconBrandGoogleFit = createReactComponent("outline", "brand-google-fit", "IconBrandGoogleFit", [["path", { "d": "M12 8.866l-2.733 -2.734a3.866 3.866 0 0 0 -5.467 5.467l2.733 2.734l5.467 5.467l8.202 -8.201a3.866 3.866 0 0 0 -5.469 -5.466l-8.201 8.2", "key": "svg-0" }]]);

var IconBrandGoogleFit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleFit
});

var IconBrandGoogleHome = createReactComponent("outline", "brand-google-home", "IconBrandGoogleHome", [["path", { "d": "M19.072 21h-14.144a1.928 1.928 0 0 1 -1.928 -1.928v-6.857c0 -.512 .203 -1 .566 -1.365l7.07 -7.063a1.928 1.928 0 0 1 2.727 0l7.071 7.063c.363 .362 .566 .853 .566 1.365v6.857a1.928 1.928 0 0 1 -1.928 1.928z", "key": "svg-0" }], ["path", { "d": "M7 13v4h10v-4l-5 -5", "key": "svg-1" }], ["path", { "d": "M14.8 5.2l-11.8 11.8", "key": "svg-2" }], ["path", { "d": "M7 17v4", "key": "svg-3" }], ["path", { "d": "M17 17v4", "key": "svg-4" }]]);

var IconBrandGoogleHome$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleHome
});

var IconBrandGoogleMaps = createReactComponent("outline", "brand-google-maps", "IconBrandGoogleMaps", [["path", { "d": "M12 9.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M6.428 12.494l7.314 -9.252", "key": "svg-1" }], ["path", { "d": "M10.002 7.935l-2.937 -2.545", "key": "svg-2" }], ["path", { "d": "M17.693 6.593l-8.336 9.979", "key": "svg-3" }], ["path", { "d": "M17.591 6.376c.472 .907 .715 1.914 .709 2.935a7.263 7.263 0 0 1 -.72 3.18a19.085 19.085 0 0 1 -2.089 3c-.784 .933 -1.49 1.93 -2.11 2.98c-.314 .62 -.568 1.27 -.757 1.938c-.121 .36 -.277 .591 -.622 .591c-.315 0 -.463 -.136 -.626 -.593a10.595 10.595 0 0 0 -.779 -1.978a18.18 18.18 0 0 0 -1.423 -2.091c-.877 -1.184 -2.179 -2.535 -2.853 -4.071a7.077 7.077 0 0 1 -.621 -2.967a6.226 6.226 0 0 1 1.476 -4.055a6.25 6.25 0 0 1 4.811 -2.245a6.462 6.462 0 0 1 1.918 .284a6.255 6.255 0 0 1 3.686 3.092z", "key": "svg-4" }]]);

var IconBrandGoogleMaps$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleMaps
});

var IconBrandGoogleOne = createReactComponent("outline", "brand-google-one", "IconBrandGoogleOne", [["path", { "d": "M11 5v13.982a2 2 0 0 0 4 0v-13.982a2 2 0 1 0 -4 0z", "key": "svg-0" }], ["path", { "d": "M6.63 8.407a2.125 2.125 0 0 0 -.074 2.944c.77 .834 2.051 .869 2.862 .077l4.95 -4.834c.812 -.792 .846 -2.11 .076 -2.945a1.984 1.984 0 0 0 -2.861 -.077l-4.953 4.835z", "key": "svg-1" }]]);

var IconBrandGoogleOne$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogleOne
});

var IconBrandGooglePhotos = createReactComponent("outline", "brand-google-photos", "IconBrandGooglePhotos", [["path", { "d": "M7.5 7c2.485 0 4.5 1.974 4.5 4.409v.591h-8.397a.61 .61 0 0 1 -.426 -.173a.585 .585 0 0 1 -.177 -.418c0 -2.435 2.015 -4.409 4.5 -4.409z", "key": "svg-0" }], ["path", { "d": "M16.5 17c-2.485 0 -4.5 -1.974 -4.5 -4.409v-.591h8.397c.333 0 .603 .265 .603 .591c0 2.435 -2.015 4.409 -4.5 4.409z", "key": "svg-1" }], ["path", { "d": "M7 16.5c0 -2.485 1.972 -4.5 4.405 -4.5h.595v8.392a.61 .61 0 0 1 -.173 .431a.584 .584 0 0 1 -.422 .177c-2.433 0 -4.405 -2.015 -4.405 -4.5z", "key": "svg-2" }], ["path", { "d": "M17 7.5c0 2.485 -1.972 4.5 -4.405 4.5h-.595v-8.397a.61 .61 0 0 1 .175 -.428a.584 .584 0 0 1 .42 -.175c2.433 0 4.405 2.015 4.405 4.5z", "key": "svg-3" }]]);

var IconBrandGooglePhotos$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGooglePhotos
});

var IconBrandGooglePlay = createReactComponent("outline", "brand-google-play", "IconBrandGooglePlay", [["path", { "d": "M4 3.71v16.58a.7 .7 0 0 0 1.05 .606l14.622 -8.42a.55 .55 0 0 0 0 -.953l-14.622 -8.419a.7 .7 0 0 0 -1.05 .607z", "key": "svg-0" }], ["path", { "d": "M15 9l-10.5 11.5", "key": "svg-1" }], ["path", { "d": "M4.5 3.5l10.5 11.5", "key": "svg-2" }]]);

var IconBrandGooglePlay$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGooglePlay
});

var IconBrandGooglePodcasts = createReactComponent("outline", "brand-google-podcasts", "IconBrandGooglePodcasts", [["path", { "d": "M12 3v2", "key": "svg-0" }], ["path", { "d": "M12 19v2", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M8 17v2", "key": "svg-3" }], ["path", { "d": "M4 11v2", "key": "svg-4" }], ["path", { "d": "M20 11v2", "key": "svg-5" }], ["path", { "d": "M8 5v8", "key": "svg-6" }], ["path", { "d": "M16 7v-2", "key": "svg-7" }], ["path", { "d": "M16 19v-8", "key": "svg-8" }]]);

var IconBrandGooglePodcasts$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGooglePodcasts
});

var IconBrandGoogle = createReactComponent("outline", "brand-google", "IconBrandGoogle", [["path", { "d": "M20.945 11a9 9 0 1 1 -3.284 -5.997l-2.655 2.392a5.5 5.5 0 1 0 2.119 6.605h-4.125v-3h7.945z", "key": "svg-0" }]]);

var IconBrandGoogle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGoogle
});

var IconBrandGrammarly = createReactComponent("outline", "brand-grammarly", "IconBrandGrammarly", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15.697 9.434a4.5 4.5 0 1 0 .217 4.788", "key": "svg-1" }], ["path", { "d": "M13.5 14h2.5v2.5", "key": "svg-2" }]]);

var IconBrandGrammarly$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGrammarly
});

var IconBrandGraphql = createReactComponent("outline", "brand-graphql", "IconBrandGraphql", [["path", { "d": "M4 8l8 -5l8 5v8l-8 5l-8 -5z", "key": "svg-0" }], ["path", { "d": "M12 4l7.5 12h-15z", "key": "svg-1" }], ["path", { "d": "M11 3a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-2" }], ["path", { "d": "M11 21a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-3" }], ["path", { "d": "M3 8a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-4" }], ["path", { "d": "M3 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-5" }], ["path", { "d": "M19 16a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-6" }], ["path", { "d": "M19 8a1 1 0 1 0 2 0a1 1 0 0 0 -2 0", "key": "svg-7" }]]);

var IconBrandGraphql$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGraphql
});

var IconBrandGravatar = createReactComponent("outline", "brand-gravatar", "IconBrandGravatar", [["path", { "d": "M5.64 5.632a9 9 0 1 0 6.36 -2.632v7.714", "key": "svg-0" }]]);

var IconBrandGravatar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGravatar
});

var IconBrandGrindr = createReactComponent("outline", "brand-grindr", "IconBrandGrindr", [["path", { "d": "M13 13.282c0 .492 .784 1.718 2.102 1.718c1.318 0 2.898 -.966 2.898 -2.062c0 -.817 -.932 -.938 -1.409 -.938c-.228 0 -3.591 .111 -3.591 1.282z", "key": "svg-0" }], ["path", { "d": "M12 21c-2.984 0 -6.471 -2.721 -6.63 -2.982c-2.13 -3.49 -2.37 -13.703 -2.37 -13.703l1.446 -1.315c2.499 .39 5.023 .617 7.554 .68a58.626 58.626 0 0 0 7.554 -.68l1.446 1.315s-.24 10.213 -2.37 13.704c-.16 .26 -3.646 2.981 -6.63 2.981z", "key": "svg-1" }], ["path", { "d": "M11 13.282c0 .492 -.784 1.718 -2.102 1.718c-1.318 0 -2.898 -.966 -2.898 -2.062c0 -.817 .932 -.938 1.409 -.938c.228 0 3.591 .111 3.591 1.282z", "key": "svg-2" }]]);

var IconBrandGrindr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGrindr
});

var IconBrandGuardian = createReactComponent("outline", "brand-guardian", "IconBrandGuardian", [["path", { "d": "M14 13h6", "key": "svg-0" }], ["path", { "d": "M4 12c0 -9.296 9.5 -9 9.5 -9c-2.808 0 -4.5 4.373 -4.5 9s1.763 8.976 4.572 8.976c0 .023 -9.572 1.092 -9.572 -8.976z", "key": "svg-1" }], ["path", { "d": "M14.5 3c1.416 0 3.853 1.16 4.5 2v3.5", "key": "svg-2" }], ["path", { "d": "M15 13v8s2.77 -.37 4 -2v-6", "key": "svg-3" }], ["path", { "d": "M13.5 21h1.5", "key": "svg-4" }], ["path", { "d": "M13.5 3h1", "key": "svg-5" }]]);

var IconBrandGuardian$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGuardian
});

var IconBrandGumroad = createReactComponent("outline", "brand-gumroad", "IconBrandGumroad", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M13.5 13h2.5v3", "key": "svg-1" }], ["path", { "d": "M15.024 9.382a4 4 0 1 0 -3.024 6.618c1.862 0 2.554 -1.278 3 -3", "key": "svg-2" }]]);

var IconBrandGumroad$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandGumroad
});

var IconBrandHackerrank = createReactComponent("outline", "brand-hackerrank", "IconBrandHackerrank", [["path", { "d": "M19.484 5.667c-1.146 -.904 -3.35 -2.394 -6.497 -3.429c-.484 -.159 -.725 -.238 -1.04 -.238c-.314 0 -.556 .08 -1.04 .238c-3.147 1.035 -5.35 2.525 -6.496 3.43c-.402 .317 -.604 .476 -.797 .816c-.194 .341 -.233 .62 -.309 1.178a33 33 0 0 0 -.305 4.338c0 1.742 .165 3.317 .305 4.338c.076 .558 .115 .837 .309 1.178c.193 .34 .395 .5 .797 .817c1.146 .904 3.35 2.394 6.497 3.429c.483 .159 .725 .238 1.04 .238c.314 0 .555 -.08 1.04 -.238c3.146 -1.035 5.35 -2.525 6.496 -3.43c.402 -.317 .603 -.476 .797 -.816c.194 -.341 .232 -.62 .309 -1.178c.14 -1.021 .305 -2.596 .305 -4.338s-.165 -3.317 -.305 -4.338c-.077 -.558 -.115 -.837 -.309 -1.178s-.395 -.5 -.797 -.817", "key": "svg-0" }], ["path", { "d": "M9 8v7", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M16 16h-2l1 1z", "key": "svg-3" }], ["path", { "d": "M8 8h2l-1 -1z", "key": "svg-4" }], ["path", { "d": "M15 9v7", "key": "svg-5" }]]);

var IconBrandHackerrank$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHackerrank
});

var IconBrandHbo = createReactComponent("outline", "brand-hbo", "IconBrandHbo", [["path", { "d": "M2 16v-8", "key": "svg-0" }], ["path", { "d": "M6 8v8", "key": "svg-1" }], ["path", { "d": "M2 12h4", "key": "svg-2" }], ["path", { "d": "M9 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2v8z", "key": "svg-3" }], ["path", { "d": "M19 8a4 4 0 1 1 0 8a4 4 0 0 1 0 -8z", "key": "svg-4" }], ["path", { "d": "M19 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBrandHbo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHbo
});

var IconBrandHeadlessui = createReactComponent("outline", "brand-headlessui", "IconBrandHeadlessui", [["path", { "d": "M6.744 4.325l7.82 -1.267a4.456 4.456 0 0 1 5.111 3.686l1.267 7.82a4.456 4.456 0 0 1 -3.686 5.111l-7.82 1.267a4.456 4.456 0 0 1 -5.111 -3.686l-1.267 -7.82a4.456 4.456 0 0 1 3.686 -5.111z", "key": "svg-0" }], ["path", { "d": "M7.252 7.704l7.897 -1.28a1 1 0 0 1 1.147 .828l.36 2.223l-9.562 3.51l-.67 -4.134a1 1 0 0 1 .828 -1.147z", "key": "svg-1" }]]);

var IconBrandHeadlessui$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHeadlessui
});

var IconBrandHexo = createReactComponent("outline", "brand-hexo", "IconBrandHexo", [["path", { "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M9 8v8", "key": "svg-1" }], ["path", { "d": "M15 8v8", "key": "svg-2" }], ["path", { "d": "M9 12h6", "key": "svg-3" }]]);

var IconBrandHexo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHexo
});

var IconBrandHipchat = createReactComponent("outline", "brand-hipchat", "IconBrandHipchat", [["path", { "d": "M17.802 17.292s.077 -.055 .2 -.149c1.843 -1.425 3 -3.49 3 -5.789c0 -4.286 -4.03 -7.764 -9 -7.764c-4.97 0 -9 3.478 -9 7.764c0 4.288 4.03 7.646 9 7.646c.424 0 1.12 -.028 2.088 -.084c1.262 .82 3.104 1.493 4.716 1.493c.499 0 .734 -.41 .414 -.828c-.486 -.596 -1.156 -1.551 -1.416 -2.29z", "key": "svg-0" }], ["path", { "d": "M7.5 13.5c2.5 2.5 6.5 2.5 9 0", "key": "svg-1" }]]);

var IconBrandHipchat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHipchat
});

var IconBrandHtml5 = createReactComponent("outline", "brand-html5", "IconBrandHtml5", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M15.5 8h-7l.5 4h6l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5", "key": "svg-1" }]]);

var IconBrandHtml5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandHtml5
});

var IconBrandInertia = createReactComponent("outline", "brand-inertia", "IconBrandInertia", [["path", { "d": "M12.5 8l4 4l-4 4h4.5l4 -4l-4 -4z", "key": "svg-0" }], ["path", { "d": "M3.5 8l4 4l-4 4h4.5l4 -4l-4 -4z", "key": "svg-1" }]]);

var IconBrandInertia$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandInertia
});

var IconBrandInstagram = createReactComponent("outline", "brand-instagram", "IconBrandInstagram", [["path", { "d": "M4 8a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M16.5 7.5v.01", "key": "svg-2" }]]);

var IconBrandInstagram$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandInstagram
});

var IconBrandIntercom = createReactComponent("outline", "brand-intercom", "IconBrandIntercom", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 8v3", "key": "svg-1" }], ["path", { "d": "M10 7v6", "key": "svg-2" }], ["path", { "d": "M14 7v6", "key": "svg-3" }], ["path", { "d": "M17 8v3", "key": "svg-4" }], ["path", { "d": "M7 15c4 2.667 6 2.667 10 0", "key": "svg-5" }]]);

var IconBrandIntercom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandIntercom
});

var IconBrandItch = createReactComponent("outline", "brand-itch", "IconBrandItch", [["path", { "d": "M2 7v1c0 1.087 1.078 2 2 2c1.107 0 2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2s2 -.91 2 -2c0 1.09 .893 2 2 2c.922 0 2 -.913 2 -2v-1c-.009 -.275 -.538 -.964 -1.588 -2.068a3 3 0 0 0 -2.174 -.932h-12.476a3 3 0 0 0 -2.174 .932c-1.05 1.104 -1.58 1.793 -1.588 2.068z", "key": "svg-0" }], ["path", { "d": "M4 10c-.117 6.28 .154 9.765 .814 10.456c1.534 .367 4.355 .535 7.186 .536c2.83 -.001 5.652 -.169 7.186 -.536c.99 -1.037 .898 -9.559 .814 -10.456", "key": "svg-1" }], ["path", { "d": "M10 16l2 -2l2 2", "key": "svg-2" }], ["path", { "d": "M12 14v4", "key": "svg-3" }]]);

var IconBrandItch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandItch
});

var IconBrandJavascript = createReactComponent("outline", "brand-javascript", "IconBrandJavascript", [["path", { "d": "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z", "key": "svg-0" }], ["path", { "d": "M7.5 8h3v8l-2 -1", "key": "svg-1" }], ["path", { "d": "M16.5 8h-2.5a.5 .5 0 0 0 -.5 .5v3a.5 .5 0 0 0 .5 .5h1.423a.5 .5 0 0 1 .495 .57l-.418 2.93l-2 .5", "key": "svg-2" }]]);

var IconBrandJavascript$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandJavascript
});

var IconBrandJuejin = createReactComponent("outline", "brand-juejin", "IconBrandJuejin", [["path", { "d": "M2 12l10 7.422l10 -7.422", "key": "svg-0" }], ["path", { "d": "M7 9l5 4l5 -4", "key": "svg-1" }], ["path", { "d": "M11 6l1 .8l1 -.8l-1 -.8z", "key": "svg-2" }]]);

var IconBrandJuejin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandJuejin
});

var IconBrandKakoTalk = createReactComponent("outline", "brand-kako-talk", "IconBrandKakoTalk", [["path", { "d": "M10 8v7", "key": "svg-0" }], ["path", { "d": "M14 10l-2 2.5l2 2.5", "key": "svg-1" }], ["path", { "d": "M12 4c4.97 0 9 3.358 9 7.5c0 4.142 -4.03 7.5 -9 7.5c-.67 0 -1.323 -.061 -1.95 -.177l-3.05 2.177l.592 -2.962c-2.741 -1.284 -4.592 -3.73 -4.592 -6.538c0 -4.142 4.03 -7.5 9 -7.5z", "key": "svg-2" }]]);

var IconBrandKakoTalk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandKakoTalk
});

var IconBrandKbin = createReactComponent("outline", "brand-kbin", "IconBrandKbin", [["g", { "key": "svg-0", "strokeWidth": "1.838" }]]);

var IconBrandKbin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandKbin
});

var IconBrandKick = createReactComponent("outline", "brand-kick", "IconBrandKick", [["path", { "d": "M4 4h5v4h3v-2h2v-2h6v4h-2v2h-2v4h2v2h2v4h-6v-2h-2v-2h-3v4h-5z", "key": "svg-0" }]]);

var IconBrandKick$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandKick
});

var IconBrandKickstarter = createReactComponent("outline", "brand-kickstarter", "IconBrandKickstarter", [["path", { "d": "M11 9l2.975 -4.65c.615 -.9 1.405 -1.35 2.377 -1.35c.79 0 1.474 .286 2.054 .858c.576 .574 .866 1.256 .866 2.054c0 .588 -.153 1.109 -.46 1.559l-2.812 4.029l3.465 4.912c.356 .46 .535 1 .535 1.613a2.92 2.92 0 0 1 -.843 2.098c-.561 .584 -1.242 .877 -2.04 .877c-.876 0 -1.545 -.29 -2 -.87l-4.112 -5.697v3.067c0 .876 -.313 1.69 -.611 2.175c-.543 .883 -1.35 1.325 -2.389 1.325c-.944 0 -1.753 -.327 -2.271 -.974c-.486 -.6 -.729 -1.392 -.729 -2.38v-11.371c0 -.934 .247 -1.706 .74 -2.313c.512 -.641 1.347 -.962 2.26 -.962c.868 0 1.821 .321 2.4 .962c.323 .356 .515 .714 .6 1.08c.052 .224 0 .643 0 1.26v2.698z", "key": "svg-0" }]]);

var IconBrandKickstarter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandKickstarter
});

var IconBrandKotlin = createReactComponent("outline", "brand-kotlin", "IconBrandKotlin", [["path", { "d": "M20 20h-16v-16h16", "key": "svg-0" }], ["path", { "d": "M4 20l16 -16", "key": "svg-1" }], ["path", { "d": "M4 12l8 -8", "key": "svg-2" }], ["path", { "d": "M12 12l8 8", "key": "svg-3" }]]);

var IconBrandKotlin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandKotlin
});

var IconBrandLaravel = createReactComponent("outline", "brand-laravel", "IconBrandLaravel", [["path", { "d": "M3 17l8 5l7 -4v-8l-4 -2.5l4 -2.5l4 2.5v4l-11 6.5l-4 -2.5v-7.5l-4 -2.5z", "key": "svg-0" }], ["path", { "d": "M11 18v4", "key": "svg-1" }], ["path", { "d": "M7 15.5l7 -4", "key": "svg-2" }], ["path", { "d": "M14 7.5v4", "key": "svg-3" }], ["path", { "d": "M14 11.5l4 2.5", "key": "svg-4" }], ["path", { "d": "M11 13v-7.5l-4 -2.5l-4 2.5", "key": "svg-5" }], ["path", { "d": "M7 8l4 -2.5", "key": "svg-6" }], ["path", { "d": "M18 10l4 -2.5", "key": "svg-7" }]]);

var IconBrandLaravel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLaravel
});

var IconBrandLastfm = createReactComponent("outline", "brand-lastfm", "IconBrandLastfm", [["path", { "d": "M20 8c-.83 -1 -1.388 -1 -2 -1c-.612 0 -2 .271 -2 2s1.384 2.233 3 3c1.616 .767 2.125 1.812 2 3s-1 2 -3 2s-3 -1 -3.5 -2s-1.585 -4.78 -2.497 -6a5 5 0 1 0 -1 7", "key": "svg-0" }]]);

var IconBrandLastfm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLastfm
});

var IconBrandLeetcode = createReactComponent("outline", "brand-leetcode", "IconBrandLeetcode", [["path", { "d": "M12 13h7.5", "key": "svg-0" }], ["path", { "d": "M9.424 7.268l4.999 -4.999", "key": "svg-1" }], ["path", { "d": "M16.633 16.644l-2.402 2.415a3.189 3.189 0 0 1 -4.524 0l-3.77 -3.787a3.223 3.223 0 0 1 0 -4.544l3.77 -3.787a3.189 3.189 0 0 1 4.524 0l2.302 2.313", "key": "svg-2" }]]);

var IconBrandLeetcode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLeetcode
});

var IconBrandLetterboxd = createReactComponent("outline", "brand-letterboxd", "IconBrandLetterboxd", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M16 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }]]);

var IconBrandLetterboxd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLetterboxd
});

var IconBrandLine = createReactComponent("outline", "brand-line", "IconBrandLine", [["path", { "d": "M21 10.663c0 -4.224 -4.041 -7.663 -9 -7.663s-9 3.439 -9 7.663c0 3.783 3.201 6.958 7.527 7.56c1.053 .239 .932 .644 .696 2.133c-.039 .238 -.184 .932 .777 .512c.96 -.42 5.18 -3.201 7.073 -5.48c1.304 -1.504 1.927 -3.029 1.927 -4.715v-.01z", "key": "svg-0" }]]);

var IconBrandLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLine
});

var IconBrandLinkedin = createReactComponent("outline", "brand-linkedin", "IconBrandLinkedin", [["path", { "d": "M8 11v5", "key": "svg-0" }], ["path", { "d": "M8 8v.01", "key": "svg-1" }], ["path", { "d": "M12 16v-5", "key": "svg-2" }], ["path", { "d": "M16 16v-3a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-4" }]]);

var IconBrandLinkedin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLinkedin
});

var IconBrandLinktree = createReactComponent("outline", "brand-linktree", "IconBrandLinktree", [["path", { "d": "M4 10h16", "key": "svg-0" }], ["path", { "d": "M6.5 4.5l11 11", "key": "svg-1" }], ["path", { "d": "M6.5 15.5l11 -11", "key": "svg-2" }], ["path", { "d": "M12 10v-8", "key": "svg-3" }], ["path", { "d": "M12 15v7", "key": "svg-4" }]]);

var IconBrandLinktree$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLinktree
});

var IconBrandLinqpad = createReactComponent("outline", "brand-linqpad", "IconBrandLinqpad", [["path", { "d": "M5 21h3.5l2.5 -6l2.5 -1l2.5 7h4l1 -4.5l-2 -1l-7 -12l-6 -.5l1.5 4l2.5 .5l1 2.5l-7 8z", "key": "svg-0" }]]);

var IconBrandLinqpad$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLinqpad
});

var IconBrandLivewire = createReactComponent("outline", "brand-livewire", "IconBrandLivewire", [["path", { "d": "M20.982 18.777c-.372 .548 -.652 1.223 -1.406 1.223c-1.269 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.269 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-.398 0 -.679 -.189 -.915 -.448a10.414 10.414 0 0 1 -1.43 -5.29c0 -5.669 4.477 -10.262 10 -10.262c5.524 0 10 4.594 10 10.261c0 1.62 -.366 3.152 -1.018 4.516z", "key": "svg-0" }], ["path", { "d": "M20.982 18.777c-.372 .548 -.652 1.223 -1.406 1.223c-1.269 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.269 0 -1.2 1.913 -2.47 1.913c-1.268 0 -1.337 -1.913 -2.607 -1.913c-1.27 0 -1.2 1.913 -2.47 1.913c-.398 0 -.679 -.189 -.915 -.448a10.414 10.414 0 0 1 -1.43 -5.29c0 -5.669 4.477 -10.262 10 -10.262c5.524 0 10 4.594 10 10.261c0 1.62 -.366 3.152 -1.018 4.516z", "key": "svg-1" }], ["path", { "d": "M11.5 16c3.167 0 4.5 -1.748 4.5 -4.231c0 -2.484 -2.014 -4.769 -4.5 -4.769c-2.485 0 -4.5 2.286 -4.5 4.769s1.333 4.231 4.5 4.231z", "key": "svg-2" }], ["path", { "d": "M10 11a1 1 0 1 0 0 -2a1 1 0 0 0 0 2z", "key": "svg-3" }]]);

var IconBrandLivewire$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLivewire
});

var IconBrandLoom = createReactComponent("outline", "brand-loom", "IconBrandLoom", [["path", { "d": "M17.464 6.518a6 6 0 1 0 -3.023 7.965", "key": "svg-0" }], ["path", { "d": "M17.482 17.464a6 6 0 1 0 -7.965 -3.023", "key": "svg-1" }], ["path", { "d": "M6.54 17.482a6 6 0 1 0 3.024 -7.965", "key": "svg-2" }], ["path", { "d": "M6.518 6.54a6 6 0 1 0 7.965 3.024", "key": "svg-3" }]]);

var IconBrandLoom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandLoom
});

var IconBrandMailgun = createReactComponent("outline", "brand-mailgun", "IconBrandMailgun", [["path", { "d": "M17 12a2 2 0 1 0 4 0a9 9 0 1 0 -2.987 6.697", "key": "svg-0" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-1" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }]]);

var IconBrandMailgun$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMailgun
});

var IconBrandMantine = createReactComponent("outline", "brand-mantine", "IconBrandMantine", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 16c1.22 -.912 2 -2.36 2 -4a5.01 5.01 0 0 0 -2 -4", "key": "svg-1" }], ["path", { "d": "M14 9h-2", "key": "svg-2" }], ["path", { "d": "M14 15h-2", "key": "svg-3" }], ["path", { "d": "M10 12h.01", "key": "svg-4" }]]);

var IconBrandMantine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMantine
});

var IconBrandMastercard = createReactComponent("outline", "brand-mastercard", "IconBrandMastercard", [["path", { "d": "M14 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 9.765a3 3 0 1 0 0 4.47", "key": "svg-1" }], ["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconBrandMastercard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMastercard
});

var IconBrandMastodon = createReactComponent("outline", "brand-mastodon", "IconBrandMastodon", [["path", { "d": "M18.648 15.254c-1.816 1.763 -6.648 1.626 -6.648 1.626a18.262 18.262 0 0 1 -3.288 -.256c1.127 1.985 4.12 2.81 8.982 2.475c-1.945 2.013 -13.598 5.257 -13.668 -7.636l-.026 -1.154c0 -3.036 .023 -4.115 1.352 -5.633c1.671 -1.91 6.648 -1.666 6.648 -1.666s4.977 -.243 6.648 1.667c1.329 1.518 1.352 2.597 1.352 5.633s-.456 4.074 -1.352 4.944z", "key": "svg-0" }], ["path", { "d": "M12 11.204v-2.926c0 -1.258 -.895 -2.278 -2 -2.278s-2 1.02 -2 2.278v4.722m4 -4.722c0 -1.258 .895 -2.278 2 -2.278s2 1.02 2 2.278v4.722", "key": "svg-1" }]]);

var IconBrandMastodon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMastodon
});

var IconBrandMatrix = createReactComponent("outline", "brand-matrix", "IconBrandMatrix", [["path", { "d": "M4 3h-1v18h1", "key": "svg-0" }], ["path", { "d": "M20 21h1v-18h-1", "key": "svg-1" }], ["path", { "d": "M7 9v6", "key": "svg-2" }], ["path", { "d": "M12 15v-3.5a2.5 2.5 0 1 0 -5 0v.5", "key": "svg-3" }], ["path", { "d": "M17 15v-3.5a2.5 2.5 0 1 0 -5 0v.5", "key": "svg-4" }]]);

var IconBrandMatrix$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMatrix
});

var IconBrandMcdonalds = createReactComponent("outline", "brand-mcdonalds", "IconBrandMcdonalds", [["path", { "d": "M20 20c0 -3.952 -.966 -16 -4.038 -16s-3.962 9.087 -3.962 14.756c0 -5.669 -.896 -14.756 -3.962 -14.756c-3.065 0 -4.038 12.048 -4.038 16", "key": "svg-0" }]]);

var IconBrandMcdonalds$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMcdonalds
});

var IconBrandMedium = createReactComponent("outline", "brand-medium", "IconBrandMedium", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 9h1l3 3l3 -3h1", "key": "svg-1" }], ["path", { "d": "M8 15l2 0", "key": "svg-2" }], ["path", { "d": "M14 15l2 0", "key": "svg-3" }], ["path", { "d": "M9 9l0 6", "key": "svg-4" }], ["path", { "d": "M15 9l0 6", "key": "svg-5" }]]);

var IconBrandMedium$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMedium
});

var IconBrandMeetup = createReactComponent("outline", "brand-meetup", "IconBrandMeetup", [["path", { "d": "M5.455 10.82c.935 -2.163 3.045 -3.82 5.545 -3.82c2.104 0 2.844 1.915 2 4l-2 6", "key": "svg-0" }], ["path", { "d": "M6.981 7l-3.981 9.914", "key": "svg-1" }], ["path", { "d": "M13 11c.937 -2.16 3.071 -3.802 5.42 -3.972c2.104 0 3.128 1.706 2.284 3.792l-2.454 6.094c-.853 1.676 .75 2.586 2.75 2.086", "key": "svg-2" }]]);

var IconBrandMeetup$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMeetup
});

var IconBrandMercedes = createReactComponent("outline", "brand-mercedes", "IconBrandMercedes", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v9", "key": "svg-1" }], ["path", { "d": "M12 12l7 5", "key": "svg-2" }], ["path", { "d": "M12 12l-7 5", "key": "svg-3" }]]);

var IconBrandMercedes$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMercedes
});

var IconBrandMessenger = createReactComponent("outline", "brand-messenger", "IconBrandMessenger", [["path", { "d": "M3 20l1.3 -3.9a9 8 0 1 1 3.4 2.9l-4.7 1", "key": "svg-0" }], ["path", { "d": "M8 13l3 -2l2 2l3 -2", "key": "svg-1" }]]);

var IconBrandMessenger$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMessenger
});

var IconBrandMeta = createReactComponent("outline", "brand-meta", "IconBrandMeta", [["path", { "d": "M12 10.174c1.766 -2.784 3.315 -4.174 4.648 -4.174c2 0 3.263 2.213 4 5.217c.704 2.869 .5 6.783 -2 6.783c-1.114 0 -2.648 -1.565 -4.148 -3.652a27.627 27.627 0 0 1 -2.5 -4.174z", "key": "svg-0" }], ["path", { "d": "M12 10.174c-1.766 -2.784 -3.315 -4.174 -4.648 -4.174c-2 0 -3.263 2.213 -4 5.217c-.704 2.869 -.5 6.783 2 6.783c1.114 0 2.648 -1.565 4.148 -3.652c1 -1.391 1.833 -2.783 2.5 -4.174z", "key": "svg-1" }]]);

var IconBrandMeta$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMeta
});

var IconBrandMetabrainz = createReactComponent("outline", "brand-metabrainz", "IconBrandMetabrainz", [["path", { "d": "M3 7v10l7 4v-18z", "key": "svg-0" }], ["path", { "d": "M21 7v10l-7 4v-18z", "key": "svg-1" }]]);

var IconBrandMetabrainz$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMetabrainz
});

var IconBrandMinecraft = createReactComponent("outline", "brand-minecraft", "IconBrandMinecraft", [["path", { "d": "M21 16.008v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008c.62 .354 1.38 .354 2 0l7 -4.008c.619 -.355 1 -1.01 1 -1.718z", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M12 17l3.003 -1.668m3 -1.667l2.997 -1.665m-9 5l-9 -5", "key": "svg-4" }], ["path", { "d": "M15 17l3 -1.67v-3l-3 1.67z", "key": "svg-5" }]]);

var IconBrandMinecraft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMinecraft
});

var IconBrandMiniprogram = createReactComponent("outline", "brand-miniprogram", "IconBrandMiniprogram", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M8 11.503a2.5 2.5 0 1 0 4 2v-3a2.5 2.5 0 1 1 4 2", "key": "svg-1" }]]);

var IconBrandMiniprogram$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMiniprogram
});

var IconBrandMixpanel = createReactComponent("outline", "brand-mixpanel", "IconBrandMixpanel", [["path", { "d": "M4.5 12m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M20.5 12m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-1" }], ["path", { "d": "M13 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }]]);

var IconBrandMixpanel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMixpanel
});

var IconBrandMonday = createReactComponent("outline", "brand-monday", "IconBrandMonday", [["path", { "d": "M19.5 15.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-0" }], ["path", { "d": "M9.5 7a1.5 1.5 0 0 1 1.339 2.177l-4.034 7.074c-.264 .447 -.75 .749 -1.305 .749a1.5 1.5 0 0 1 -1.271 -2.297l3.906 -6.827a1.5 1.5 0 0 1 1.365 -.876z", "key": "svg-1" }], ["path", { "d": "M16.5 7a1.5 1.5 0 0 1 1.339 2.177l-4.034 7.074c-.264 .447 -.75 .749 -1.305 .749a1.5 1.5 0 0 1 -1.271 -2.297l3.906 -6.827a1.5 1.5 0 0 1 1.365 -.876z", "key": "svg-2" }]]);

var IconBrandMonday$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMonday
});

var IconBrandMongodb = createReactComponent("outline", "brand-mongodb", "IconBrandMongodb", [["path", { "d": "M12 3v19", "key": "svg-0" }], ["path", { "d": "M18 11.227c0 3.273 -1.812 4.77 -6 9.273c-4.188 -4.503 -6 -6 -6 -9.273c0 -4.454 3.071 -6.927 6 -9.227c2.929 2.3 6 4.773 6 9.227z", "key": "svg-1" }]]);

var IconBrandMongodb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMongodb
});

var IconBrandMyOppo = createReactComponent("outline", "brand-my-oppo", "IconBrandMyOppo", [["path", { "d": "M18.316 5h-12.632l-3.418 4.019a1.089 1.089 0 0 0 .019 1.447l9.714 10.534l9.715 -10.49a1.09 1.09 0 0 0 .024 -1.444l-3.422 -4.066z", "key": "svg-0" }], ["path", { "d": "M9 11l3 3l3 -3", "key": "svg-1" }]]);

var IconBrandMyOppo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMyOppo
});

var IconBrandMysql = createReactComponent("outline", "brand-mysql", "IconBrandMysql", [["path", { "d": "M13 21c-1.427 -1.026 -3.59 -3.854 -4 -6c-.486 .77 -1.501 2 -2 2c-1.499 -.888 -.574 -3.973 0 -6c-1.596 -1.433 -2.468 -2.458 -2.5 -4c-3.35 -3.44 -.444 -5.27 2.5 -3h1c8.482 .5 6.421 8.07 9 11.5c2.295 .522 3.665 2.254 5 3.5c-2.086 -.2 -2.784 -.344 -3.5 0c.478 1.64 2.123 2.2 3.5 3", "key": "svg-0" }], ["path", { "d": "M9 7h.01", "key": "svg-1" }]]);

var IconBrandMysql$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandMysql
});

var IconBrandNationalGeographic = createReactComponent("outline", "brand-national-geographic", "IconBrandNationalGeographic", [["path", { "d": "M7 3h10v18h-10z", "key": "svg-0" }]]);

var IconBrandNationalGeographic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNationalGeographic
});

var IconBrandNem = createReactComponent("outline", "brand-nem", "IconBrandNem", [["path", { "d": "M12.182 2c1.94 .022 3.879 .382 5.818 1.08l.364 .135a23.075 23.075 0 0 1 3.636 1.785c0 5.618 -1.957 10.258 -5.87 13.92c-1.24 1.239 -2.5 2.204 -3.78 2.898l-.35 .182c-1.4 -.703 -2.777 -1.729 -4.13 -3.079c-3.912 -3.663 -5.87 -8.303 -5.87 -13.921c2.545 -1.527 5.09 -2.471 7.636 -2.832l.364 -.048a16.786 16.786 0 0 1 1.818 -.12h.364z", "key": "svg-0" }], ["path", { "d": "M2.1 7.07c2.073 6.72 5.373 7.697 9.9 2.93c0 -4 1.357 -6.353 4.07 -7.06l.59 -.11", "key": "svg-1" }], ["path", { "d": "M16.35 18.51s2.65 -5.51 -4.35 -8.51", "key": "svg-2" }]]);

var IconBrandNem$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNem
});

var IconBrandNetbeans = createReactComponent("outline", "brand-netbeans", "IconBrandNetbeans", [["path", { "d": "M19.875 6.27a2.225 2.225 0 0 1 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z", "key": "svg-0" }], ["path", { "d": "M15.5 9.43a1 1 0 0 1 .5 .874v3.268a1 1 0 0 1 -.515 .874l-3 1.917a1 1 0 0 1 -.97 0l-3 -1.917a1 1 0 0 1 -.515 -.873v-3.269a1 1 0 0 1 .514 -.874l3 -1.786c.311 -.173 .69 -.173 1 0l3 1.787h-.014z", "key": "svg-1" }], ["path", { "d": "M12 21v-9l-7.5 -4.5", "key": "svg-2" }], ["path", { "d": "M12 12l7.5 -4.5", "key": "svg-3" }], ["path", { "d": "M12 3v4.5", "key": "svg-4" }], ["path", { "d": "M19.5 16l-3.5 -2", "key": "svg-5" }], ["path", { "d": "M8 14l-3.5 2", "key": "svg-6" }]]);

var IconBrandNetbeans$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNetbeans
});

var IconBrandNeteaseMusic = createReactComponent("outline", "brand-netease-music", "IconBrandNeteaseMusic", [["path", { "d": "M9 4c-2.93 1.346 -5 5.046 -5 8.492c0 4.508 4 7.508 8 7.508s8 -3 8 -7c0 -3.513 -3.5 -5.513 -6 -5.513s-5 1.513 -5 4.513c0 2 1.5 3 3 3s3 -1 3 -3c0 -3.513 -2 -4.508 -2 -6.515c0 -3.504 3.5 -2.603 4 -1.502", "key": "svg-0" }]]);

var IconBrandNeteaseMusic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNeteaseMusic
});

var IconBrandNetflix = createReactComponent("outline", "brand-netflix", "IconBrandNetflix", [["path", { "d": "M9 3l10 18h-4l-10 -18z", "key": "svg-0" }], ["path", { "d": "M5 3v18h4v-10.5", "key": "svg-1" }], ["path", { "d": "M19 21v-18h-4v10.5", "key": "svg-2" }]]);

var IconBrandNetflix$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNetflix
});

var IconBrandNexo = createReactComponent("outline", "brand-nexo", "IconBrandNexo", [["path", { "d": "M17 3l5 3v12l-5 3l-10 -6v-6l10 6v-6l-5 -3z", "key": "svg-0" }], ["path", { "d": "M12 6l-5 -3l-5 3v12l5 3l4.7 -3.13", "key": "svg-1" }]]);

var IconBrandNexo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNexo
});

var IconBrandNextcloud = createReactComponent("outline", "brand-nextcloud", "IconBrandNextcloud", [["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-0" }], ["path", { "d": "M4.5 12.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-1" }], ["path", { "d": "M19.5 12.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-2" }]]);

var IconBrandNextcloud$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNextcloud
});

var IconBrandNextjs = createReactComponent("outline", "brand-nextjs", "IconBrandNextjs", [["path", { "d": "M9 15v-6l7.745 10.65a9 9 0 1 1 2.255 -1.993", "key": "svg-0" }], ["path", { "d": "M15 12v-3", "key": "svg-1" }]]);

var IconBrandNextjs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNextjs
});

var IconBrandNodejs = createReactComponent("outline", "brand-nodejs", "IconBrandNodejs", [["path", { "d": "M9 9v8.044a2 2 0 0 1 -2.996 1.734l-1.568 -.9a3 3 0 0 1 -1.436 -2.561v-6.635a3 3 0 0 1 1.436 -2.56l6 -3.667a3 3 0 0 1 3.128 0l6 3.667a3 3 0 0 1 1.436 2.561v6.634a3 3 0 0 1 -1.436 2.56l-6 3.667a3 3 0 0 1 -3.128 0", "key": "svg-0" }], ["path", { "d": "M17 9h-3.5a1.5 1.5 0 0 0 0 3h2a1.5 1.5 0 0 1 0 3h-3.5", "key": "svg-1" }]]);

var IconBrandNodejs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNodejs
});

var IconBrandNordVpn = createReactComponent("outline", "brand-nord-vpn", "IconBrandNordVpn", [["path", { "d": "M9.992 15l-2.007 -3l-4.015 8c-2.212 -3.061 -2.625 -7.098 -.915 -10.463a10.14 10.14 0 0 1 8.945 -5.537a10.14 10.14 0 0 1 8.945 5.537c1.71 3.365 1.297 7.402 -.915 10.463l-4.517 -8l-1.505 1.5", "key": "svg-0" }], ["path", { "d": "M14.5 15l-3 -6l-2.5 4.5", "key": "svg-1" }]]);

var IconBrandNordVpn$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNordVpn
});

var IconBrandNotion = createReactComponent("outline", "brand-notion", "IconBrandNotion", [["path", { "d": "M11 17.5v-6.5h.5l4 6h.5v-6.5", "key": "svg-0" }], ["path", { "d": "M19.077 20.071l-11.53 .887a1 1 0 0 1 -.876 -.397l-2.471 -3.294a1 1 0 0 1 -.2 -.6v-10.741a1 1 0 0 1 .923 -.997l11.389 -.876a2 2 0 0 1 1.262 .33l1.535 1.023a2 2 0 0 1 .891 1.664v12.004a1 1 0 0 1 -.923 .997z", "key": "svg-1" }], ["path", { "d": "M4.5 5.5l2.5 2.5", "key": "svg-2" }], ["path", { "d": "M20 7l-13 1v12.5", "key": "svg-3" }]]);

var IconBrandNotion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNotion
});

var IconBrandNpm = createReactComponent("outline", "brand-npm", "IconBrandNpm", [["path", { "d": "M1 8h22v7h-12v2h-4v-2h-6z", "key": "svg-0" }], ["path", { "d": "M7 8v7", "key": "svg-1" }], ["path", { "d": "M14 8v7", "key": "svg-2" }], ["path", { "d": "M17 11v4", "key": "svg-3" }], ["path", { "d": "M4 11v4", "key": "svg-4" }], ["path", { "d": "M11 11v1", "key": "svg-5" }], ["path", { "d": "M20 11v4", "key": "svg-6" }]]);

var IconBrandNpm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNpm
});

var IconBrandNuxt = createReactComponent("outline", "brand-nuxt", "IconBrandNuxt", [["path", { "d": "M12.146 8.583l-1.3 -2.09a1.046 1.046 0 0 0 -1.786 .017l-5.91 9.908a1.046 1.046 0 0 0 .897 1.582h3.913", "key": "svg-0" }], ["path", { "d": "M20.043 18c.743 0 1.201 -.843 .82 -1.505l-4.044 -7.013a.936 .936 0 0 0 -1.638 0l-4.043 7.013c-.382 .662 .076 1.505 .819 1.505h8.086z", "key": "svg-1" }]]);

var IconBrandNuxt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNuxt
});

var IconBrandNytimes = createReactComponent("outline", "brand-nytimes", "IconBrandNytimes", [["path", { "d": "M11.036 5.058a8 8 0 1 0 8.706 9.965", "key": "svg-0" }], ["path", { "d": "M12 21v-11l-7.5 4", "key": "svg-1" }], ["path", { "d": "M17.5 3a2.5 2.5 0 1 1 0 5l-11 -5a2.5 2.5 0 0 0 -.67 4.91", "key": "svg-2" }], ["path", { "d": "M9 12v8", "key": "svg-3" }], ["path", { "d": "M16 13h-.01", "key": "svg-4" }]]);

var IconBrandNytimes$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandNytimes
});

var IconBrandOauth = createReactComponent("outline", "brand-oauth", "IconBrandOauth", [["path", { "d": "M12 12m-10 0a10 10 0 1 0 20 0a10 10 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M12.556 6c.65 0 1.235 .373 1.508 .947l2.839 7.848a1.646 1.646 0 0 1 -1.01 2.108a1.673 1.673 0 0 1 -2.068 -.851l-.46 -1.052h-2.73l-.398 .905a1.67 1.67 0 0 1 -1.977 1.045l-.153 -.047a1.647 1.647 0 0 1 -1.056 -1.956l2.824 -7.852a1.664 1.664 0 0 1 1.409 -1.087l1.272 -.008z", "key": "svg-1" }]]);

var IconBrandOauth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOauth
});

var IconBrandOffice = createReactComponent("outline", "brand-office", "IconBrandOffice", [["path", { "d": "M4 18h9v-12l-5 2v5l-4 2v-8l9 -4l7 2v13l-7 3z", "key": "svg-0" }]]);

var IconBrandOffice$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOffice
});

var IconBrandOkRu = createReactComponent("outline", "brand-ok-ru", "IconBrandOkRu", [["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M20 12c0 8 0 8 -8 8s-8 0 -8 -8s0 -8 8 -8s8 0 8 8z", "key": "svg-1" }], ["path", { "d": "M9.5 13c1.333 .667 3.667 .667 5 0", "key": "svg-2" }], ["path", { "d": "M9.5 17l2.5 -3l2.5 3", "key": "svg-3" }], ["path", { "d": "M12 13.5v.5", "key": "svg-4" }]]);

var IconBrandOkRu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOkRu
});

var IconBrandOnedrive = createReactComponent("outline", "brand-onedrive", "IconBrandOnedrive", [["path", { "d": "M18.456 10.45a6.45 6.45 0 0 0 -12 -2.151a4.857 4.857 0 0 0 -4.44 5.241a4.856 4.856 0 0 0 5.236 4.444h10.751a3.771 3.771 0 0 0 3.99 -3.54a3.772 3.772 0 0 0 -3.538 -3.992z", "key": "svg-0" }]]);

var IconBrandOnedrive$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOnedrive
});

var IconBrandOnlyfans = createReactComponent("outline", "brand-onlyfans", "IconBrandOnlyfans", [["path", { "d": "M8.5 6a6.5 6.5 0 1 0 0 13a6.5 6.5 0 0 0 0 -13z", "key": "svg-0" }], ["path", { "d": "M8.5 15a2.5 2.5 0 1 1 0 -5a2.5 2.5 0 0 1 0 5z", "key": "svg-1" }], ["path", { "d": "M14 16c2.5 0 6.42 -1.467 7 -4h-6c3 -1 6.44 -3.533 7 -6h-4c-3.03 0 -3.764 -.196 -5 1.5", "key": "svg-2" }]]);

var IconBrandOnlyfans$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOnlyfans
});

var IconBrandOpenSource = createReactComponent("outline", "brand-open-source", "IconBrandOpenSource", [["path", { "d": "M12 3a9 9 0 0 1 3.618 17.243l-2.193 -5.602a3 3 0 1 0 -2.849 0l-2.193 5.603a9 9 0 0 1 3.617 -17.244z", "key": "svg-0" }]]);

var IconBrandOpenSource$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOpenSource
});

var IconBrandOpenai = createReactComponent("outline", "brand-openai", "IconBrandOpenai", [["path", { "d": "M11.217 19.384a3.501 3.501 0 0 0 6.783 -1.217v-5.167l-6 -3.35", "key": "svg-0" }], ["path", { "d": "M5.214 15.014a3.501 3.501 0 0 0 4.446 5.266l4.34 -2.534v-6.946", "key": "svg-1" }], ["path", { "d": "M6 7.63c-1.391 -.236 -2.787 .395 -3.534 1.689a3.474 3.474 0 0 0 1.271 4.745l4.263 2.514l6 -3.348", "key": "svg-2" }], ["path", { "d": "M12.783 4.616a3.501 3.501 0 0 0 -6.783 1.217v5.067l6 3.45", "key": "svg-3" }], ["path", { "d": "M18.786 8.986a3.501 3.501 0 0 0 -4.446 -5.266l-4.34 2.534v6.946", "key": "svg-4" }], ["path", { "d": "M18 16.302c1.391 .236 2.787 -.395 3.534 -1.689a3.474 3.474 0 0 0 -1.271 -4.745l-4.308 -2.514l-5.955 3.42", "key": "svg-5" }]]);

var IconBrandOpenai$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOpenai
});

var IconBrandOpenvpn = createReactComponent("outline", "brand-openvpn", "IconBrandOpenvpn", [["path", { "d": "M15.618 20.243l-2.193 -5.602a3 3 0 1 0 -2.849 0l-2.193 5.603", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandOpenvpn$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOpenvpn
});

var IconBrandOpera = createReactComponent("outline", "brand-opera", "IconBrandOpera", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 5 0 1 0 6 0a3 5 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandOpera$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandOpera
});

var IconBrandPagekit = createReactComponent("outline", "brand-pagekit", "IconBrandPagekit", [["path", { "d": "M12.077 20h-5.077v-16h11v14h-5.077", "key": "svg-0" }]]);

var IconBrandPagekit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPagekit
});

var IconBrandParsinta = createReactComponent("outline", "brand-parsinta", "IconBrandParsinta", [["path", { "d": "M12 3a9 9 0 1 0 9 9", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 0 0 -9 -9", "opacity": ".5", "key": "svg-1" }], ["path", { "d": "M10 9v6l5 -3z", "key": "svg-2" }]]);

var IconBrandParsinta$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandParsinta
});

var IconBrandPatreon = createReactComponent("outline", "brand-patreon", "IconBrandPatreon", [["path", { "d": "M20 8.408c-.003 -2.299 -1.746 -4.182 -3.79 -4.862c-2.54 -.844 -5.888 -.722 -8.312 .453c-2.939 1.425 -3.862 4.545 -3.896 7.656c-.028 2.559 .22 9.297 3.92 9.345c2.75 .036 3.159 -3.603 4.43 -5.356c.906 -1.247 2.071 -1.599 3.506 -1.963c2.465 -.627 4.146 -2.626 4.142 -5.273z", "key": "svg-0" }]]);

var IconBrandPatreon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPatreon
});

var IconBrandPaypal = createReactComponent("outline", "brand-paypal", "IconBrandPaypal", [["path", { "d": "M10 13l2.5 0c2.5 0 5 -2.5 5 -5c0 -3 -1.9 -5 -5 -5h-5.5c-.5 0 -1 .5 -1 1l-2 14c0 .5 .5 1 1 1h2.8l1.2 -5c.1 -.6 .4 -1 1 -1zm7.5 -5.8c1.7 1 2.5 2.8 2.5 4.8c0 2.5 -2.5 4.5 -5 4.5h-2.6l-.6 3.6a1 1 0 0 1 -1 .8l-2.7 0a.5 .5 0 0 1 -.5 -.6l.2 -1.4", "key": "svg-0" }]]);

var IconBrandPaypal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPaypal
});

var IconBrandPaypay = createReactComponent("outline", "brand-paypay", "IconBrandPaypay", [["path", { "d": "M6.375 21l3.938 -13.838", "key": "svg-0" }], ["path", { "d": "M3 6c16.731 0 21.231 9.881 4.5 11", "key": "svg-1" }], ["path", { "d": "M21 19v-14a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2z", "key": "svg-2" }]]);

var IconBrandPaypay$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPaypay
});

var IconBrandPeanut = createReactComponent("outline", "brand-peanut", "IconBrandPeanut", [["path", { "d": "M15 16.25l-.816 -.36l-.462 -.196c-1.444 -.592 -2 -.593 -3.447 0l-.462 .195l-.817 .359a4.5 4.5 0 1 1 0 -8.49v0l1.054 .462l.434 .178c1.292 .507 1.863 .48 3.237 -.082l.462 -.195l.817 -.359a4.5 4.5 0 1 1 0 8.49", "key": "svg-0" }]]);

var IconBrandPeanut$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPeanut
});

var IconBrandPepsi = createReactComponent("outline", "brand-pepsi", "IconBrandPepsi", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M4 16c5.713 -2.973 11 -3.5 13.449 -11.162", "key": "svg-1" }], ["path", { "d": "M5 17.5c5.118 -2.859 15 0 14 -11", "key": "svg-2" }]]);

var IconBrandPepsi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPepsi
});

var IconBrandPhp = createReactComponent("outline", "brand-php", "IconBrandPhp", [["path", { "d": "M12 12m-10 0a10 9 0 1 0 20 0a10 9 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M5.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653", "key": "svg-1" }], ["path", { "d": "M15.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653", "key": "svg-2" }], ["path", { "d": "M12 7.5l-1 5.5", "key": "svg-3" }], ["path", { "d": "M11.6 10h2.4l-.5 3", "key": "svg-4" }]]);

var IconBrandPhp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPhp
});

var IconBrandPicsart = createReactComponent("outline", "brand-picsart", "IconBrandPicsart", [["path", { "d": "M12 9m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 9m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M5 9v11a2 2 0 1 0 4 0v-4.5", "key": "svg-2" }]]);

var IconBrandPicsart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPicsart
});

var IconBrandPinterest = createReactComponent("outline", "brand-pinterest", "IconBrandPinterest", [["path", { "d": "M8 20l4 -9", "key": "svg-0" }], ["path", { "d": "M10.7 14c.437 1.263 1.43 2 2.55 2c2.071 0 3.75 -1.554 3.75 -4a5 5 0 1 0 -9.7 1.7", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconBrandPinterest$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPinterest
});

var IconBrandPlanetscale = createReactComponent("outline", "brand-planetscale", "IconBrandPlanetscale", [["path", { "d": "M20.993 11.63a9 9 0 0 1 -9.362 9.362l9.362 -9.362z", "key": "svg-0" }], ["path", { "d": "M12 3a9.001 9.001 0 0 1 8.166 5.211l-11.955 11.955a9 9 0 0 1 3.789 -17.166z", "key": "svg-1" }], ["path", { "d": "M12 12l-6 6", "key": "svg-2" }]]);

var IconBrandPlanetscale$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPlanetscale
});

var IconBrandPnpm = createReactComponent("outline", "brand-pnpm", "IconBrandPnpm", [["path", { "d": "M3 17h4v4h-4z", "key": "svg-0" }], ["path", { "d": "M10 17h4v4h-4z", "key": "svg-1" }], ["path", { "d": "M17 17h4v4h-4z", "key": "svg-2" }], ["path", { "d": "M17 10h4v4h-4z", "key": "svg-3" }], ["path", { "d": "M17 3h4v4h-4z", "key": "svg-4" }], ["path", { "d": "M10 10h4v4h-4z", "key": "svg-5" }], ["path", { "d": "M10 3h4v4h-4z", "key": "svg-6" }], ["path", { "d": "M3 3h4v4h-4z", "key": "svg-7" }]]);

var IconBrandPnpm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPnpm
});

var IconBrandPocket = createReactComponent("outline", "brand-pocket", "IconBrandPocket", [["path", { "d": "M5 4h14a2 2 0 0 1 2 2v6a9 9 0 0 1 -18 0v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M8 11l4 4l4 -4", "key": "svg-1" }]]);

var IconBrandPocket$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPocket
});

var IconBrandPolymer = createReactComponent("outline", "brand-polymer", "IconBrandPolymer", [["path", { "d": "M6.706 6l-3.706 6l3.706 6h1.059l8.47 -12h1.06l3.705 6l-3.706 6", "key": "svg-0" }]]);

var IconBrandPolymer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPolymer
});

var IconBrandPowershell = createReactComponent("outline", "brand-powershell", "IconBrandPowershell", [["path", { "d": "M4.887 20h11.868c.893 0 1.664 -.665 1.847 -1.592l2.358 -12c.212 -1.081 -.442 -2.14 -1.462 -2.366a1.784 1.784 0 0 0 -.385 -.042h-11.868c-.893 0 -1.664 .665 -1.847 1.592l-2.358 12c-.212 1.081 .442 2.14 1.462 2.366c.127 .028 .256 .042 .385 .042z", "key": "svg-0" }], ["path", { "d": "M9 8l4 4l-6 4", "key": "svg-1" }], ["path", { "d": "M12 16h3", "key": "svg-2" }]]);

var IconBrandPowershell$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPowershell
});

var IconBrandPrintables = createReactComponent("outline", "brand-printables", "IconBrandPrintables", [["path", { "d": "M6 21l12 -7v-7.5l-6 -3.5l-6 3.5l6 3.5v7.5l-6 -3.5z", "key": "svg-0" }]]);

var IconBrandPrintables$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPrintables
});

var IconBrandPrisma = createReactComponent("outline", "brand-prisma", "IconBrandPrisma", [["path", { "d": "M4.186 16.202l3.615 5.313c.265 .39 .754 .57 1.215 .447l10.166 -2.718a1.086 1.086 0 0 0 .713 -1.511l-7.505 -15.483a.448 .448 0 0 0 -.787 -.033l-7.453 12.838a1.07 1.07 0 0 0 .037 1.147z", "key": "svg-0" }], ["path", { "d": "M8.5 22l3.5 -20", "key": "svg-1" }]]);

var IconBrandPrisma$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPrisma
});

var IconBrandProducthunt = createReactComponent("outline", "brand-producthunt", "IconBrandProducthunt", [["path", { "d": "M10 16v-8h2.5a2.5 2.5 0 1 1 0 5h-2.5", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandProducthunt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandProducthunt
});

var IconBrandPushbullet = createReactComponent("outline", "brand-pushbullet", "IconBrandPushbullet", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 8v8h2a4 4 0 1 0 0 -8h-2z", "key": "svg-1" }], ["path", { "d": "M8 8v8", "key": "svg-2" }]]);

var IconBrandPushbullet$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPushbullet
});

var IconBrandPushover = createReactComponent("outline", "brand-pushover", "IconBrandPushover", [["path", { "d": "M6.16 10.985c-.83 -1.935 1.53 -7.985 8.195 -7.985c3.333 0 4.645 1.382 4.645 3.9c0 2.597 -2.612 6.1 -9 6.1", "key": "svg-0" }], ["path", { "d": "M12.5 6l-5.5 15", "key": "svg-1" }]]);

var IconBrandPushover$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPushover
});

var IconBrandPython = createReactComponent("outline", "brand-python", "IconBrandPython", [["path", { "d": "M12 9h-7a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h3", "key": "svg-0" }], ["path", { "d": "M12 15h7a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-3", "key": "svg-1" }], ["path", { "d": "M8 9v-4a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v5a2 2 0 0 1 -2 2h-4a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4", "key": "svg-2" }], ["path", { "d": "M11 6l0 .01", "key": "svg-3" }], ["path", { "d": "M13 18l0 .01", "key": "svg-4" }]]);

var IconBrandPython$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandPython
});

var IconBrandQq = createReactComponent("outline", "brand-qq", "IconBrandQq", [["path", { "d": "M6 9.748a14.716 14.716 0 0 0 11.995 -.052c.275 -9.236 -11.104 -11.256 -11.995 .052z", "key": "svg-0" }], ["path", { "d": "M18 10c.984 2.762 1.949 4.765 2 7.153c.014 .688 -.664 1.346 -1.184 .303c-.346 -.696 -.952 -1.181 -1.816 -1.456", "key": "svg-1" }], ["path", { "d": "M17 16c.031 1.831 .147 3.102 -1 4", "key": "svg-2" }], ["path", { "d": "M8 20c-1.099 -.87 -.914 -2.24 -1 -4", "key": "svg-3" }], ["path", { "d": "M6 10c-.783 2.338 -1.742 4.12 -1.968 6.43c-.217 2.227 .716 1.644 1.16 .917c.296 -.487 .898 -.934 1.808 -1.347", "key": "svg-4" }], ["path", { "d": "M15.898 13l-.476 -2", "key": "svg-5" }], ["path", { "d": "M8 20l-1.5 1c-.5 .5 -.5 1 .5 1h10c1 0 1 -.5 .5 -1l-1.5 -1", "key": "svg-6" }], ["path", { "d": "M13.75 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-7" }], ["path", { "d": "M10.25 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-8" }]]);

var IconBrandQq$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandQq
});

var IconBrandRadixUi = createReactComponent("outline", "brand-radix-ui", "IconBrandRadixUi", [["path", { "d": "M16.5 5.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M6 3h5v5h-5z", "key": "svg-1" }], ["path", { "d": "M11 11v10a5 5 0 0 1 -.217 -9.995l.217 -.005z", "key": "svg-2" }]]);

var IconBrandRadixUi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRadixUi
});

var IconBrandReactNative = createReactComponent("outline", "brand-react-native", "IconBrandReactNative", [["path", { "d": "M6.357 9c-2.637 .68 -4.357 1.845 -4.357 3.175c0 2.107 4.405 3.825 9.85 3.825c.74 0 1.26 -.039 1.95 -.097", "key": "svg-0" }], ["path", { "d": "M9.837 15.9c-.413 -.596 -.806 -1.133 -1.18 -1.8c-2.751 -4.9 -3.488 -9.77 -1.63 -10.873c1.15 -.697 3.047 .253 4.974 2.254", "key": "svg-1" }], ["path", { "d": "M6.429 15.387c-.702 2.688 -.56 4.716 .56 5.395c1.783 1.08 5.387 -1.958 8.043 -6.804c.36 -.67 .683 -1.329 .968 -1.978", "key": "svg-2" }], ["path", { "d": "M12 18.52c1.928 2 3.817 2.95 4.978 2.253c1.85 -1.102 1.121 -5.972 -1.633 -10.873c-.384 -.677 -.777 -1.204 -1.18 -1.8", "key": "svg-3" }], ["path", { "d": "M17.66 15c2.612 -.687 4.34 -1.85 4.34 -3.176c0 -2.11 -4.408 -3.824 -9.845 -3.824c-.747 0 -1.266 .029 -1.955 .087", "key": "svg-4" }], ["path", { "d": "M8 12c.285 -.66 .607 -1.308 .968 -1.978c2.647 -4.844 6.253 -7.89 8.046 -6.801c1.11 .679 1.262 2.706 .56 5.393", "key": "svg-5" }], ["path", { "d": "M12.26 12.015h-.01c-.01 .13 -.12 .24 -.26 .24a.263 .263 0 0 1 -.25 -.26c0 -.14 .11 -.25 .24 -.25h-.01c.13 -.01 .25 .11 .25 .24", "key": "svg-6" }]]);

var IconBrandReactNative$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandReactNative
});

var IconBrandReact = createReactComponent("outline", "brand-react", "IconBrandReact", [["path", { "d": "M6.306 8.711c-2.602 .723 -4.306 1.926 -4.306 3.289c0 2.21 4.477 4 10 4c.773 0 1.526 -.035 2.248 -.102", "key": "svg-0" }], ["path", { "d": "M17.692 15.289c2.603 -.722 4.308 -1.926 4.308 -3.289c0 -2.21 -4.477 -4 -10 -4c-.773 0 -1.526 .035 -2.25 .102", "key": "svg-1" }], ["path", { "d": "M6.305 15.287c-.676 2.615 -.485 4.693 .695 5.373c1.913 1.105 5.703 -1.877 8.464 -6.66c.387 -.67 .733 -1.339 1.036 -2", "key": "svg-2" }], ["path", { "d": "M17.694 8.716c.677 -2.616 .487 -4.696 -.694 -5.376c-1.913 -1.105 -5.703 1.877 -8.464 6.66c-.387 .67 -.733 1.34 -1.037 2", "key": "svg-3" }], ["path", { "d": "M12 5.424c-1.925 -1.892 -3.82 -2.766 -5 -2.084c-1.913 1.104 -1.226 5.877 1.536 10.66c.386 .67 .793 1.304 1.212 1.896", "key": "svg-4" }], ["path", { "d": "M12 18.574c1.926 1.893 3.821 2.768 5 2.086c1.913 -1.104 1.226 -5.877 -1.536 -10.66c-.375 -.65 -.78 -1.283 -1.212 -1.897", "key": "svg-5" }], ["path", { "d": "M11.5 12.866a1 1 0 1 0 1 -1.732a1 1 0 0 0 -1 1.732z", "key": "svg-6" }]]);

var IconBrandReact$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandReact
});

var IconBrandReason = createReactComponent("outline", "brand-reason", "IconBrandReason", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M18 18h-3v-6h3", "key": "svg-1" }], ["path", { "d": "M18 15h-3", "key": "svg-2" }], ["path", { "d": "M8 18v-6h2.5a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M12 18l-2 -3", "key": "svg-4" }]]);

var IconBrandReason$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandReason
});

var IconBrandReddit = createReactComponent("outline", "brand-reddit", "IconBrandReddit", [["path", { "d": "M12 8c2.648 0 5.028 .826 6.675 2.14a2.5 2.5 0 0 1 2.326 4.36c0 3.59 -4.03 6.5 -9 6.5c-4.875 0 -8.845 -2.8 -9 -6.294l-1 -.206a2.5 2.5 0 0 1 2.326 -4.36c1.646 -1.313 4.026 -2.14 6.674 -2.14z", "key": "svg-0" }], ["path", { "d": "M12 8l1 -5l6 1", "key": "svg-1" }], ["path", { "d": "M19 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["circle", { "cx": "9", "cy": "13", "r": ".5", "fill": "currentColor", "key": "svg-3" }], ["circle", { "cx": "15", "cy": "13", "r": ".5", "fill": "currentColor", "key": "svg-4" }], ["path", { "d": "M10 17c.667 .333 1.333 .5 2 .5s1.333 -.167 2 -.5", "key": "svg-5" }]]);

var IconBrandReddit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandReddit
});

var IconBrandRedhat = createReactComponent("outline", "brand-redhat", "IconBrandRedhat", [["path", { "d": "M6 10.5l1.436 -4c.318 -.876 .728 -1.302 1.359 -1.302c.219 0 1.054 .365 1.88 .583c.825 .219 .733 -.329 .908 -.487c.176 -.158 .355 -.294 .61 -.294c.242 0 .553 .048 1.692 .448c.759 .267 1.493 .574 2.204 .922c1.175 .582 1.426 .913 1.595 1.507l.816 4.623c2.086 .898 3.5 2.357 3.5 3.682c0 1.685 -1.2 3.818 -5.957 3.818c-6.206 0 -14.043 -4.042 -14.043 -7.32c0 -1.044 1.333 -1.77 4 -2.18z", "key": "svg-0" }], ["path", { "d": "M6 10.5c0 .969 4.39 3.5 9.5 3.5c1.314 0 3 .063 3 -1.5", "key": "svg-1" }]]);

var IconBrandRedhat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRedhat
});

var IconBrandRedux = createReactComponent("outline", "brand-redux", "IconBrandRedux", [["path", { "d": "M16.54 7c-.805 -2.365 -2.536 -4 -4.54 -4c-2.774 0 -5.023 2.632 -5.023 6.496c0 1.956 1.582 4.727 2.512 6", "key": "svg-0" }], ["path", { "d": "M4.711 11.979c-1.656 1.877 -2.214 4.185 -1.211 5.911c1.387 2.39 5.138 2.831 8.501 .9c1.703 -.979 2.875 -3.362 3.516 -4.798", "key": "svg-1" }], ["path", { "d": "M15.014 19.99c2.511 0 4.523 -.438 5.487 -2.1c1.387 -2.39 -.215 -5.893 -3.579 -7.824c-1.702 -.979 -4.357 -1.235 -5.927 -1.07", "key": "svg-2" }], ["path", { "d": "M10.493 9.862c.48 .276 1.095 .112 1.372 -.366a1 1 0 0 0 -.367 -1.365a1.007 1.007 0 0 0 -1.373 .366a1 1 0 0 0 .368 1.365z", "key": "svg-3" }], ["path", { "d": "M9.5 15.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M15.5 14m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }]]);

var IconBrandRedux$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRedux
});

var IconBrandRevolut = createReactComponent("outline", "brand-revolut", "IconBrandRevolut", [["path", { "d": "M5 10h3v10h-3z", "key": "svg-0" }], ["path", { "d": "M14.5 4h-9.5v3h9.4a1.5 1.5 0 0 1 0 3h-3.4v4l4 6h4l-5 -7h.5a4.5 4.5 0 1 0 0 -9z", "key": "svg-1" }]]);

var IconBrandRevolut$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRevolut
});

var IconBrandRumble = createReactComponent("outline", "brand-rumble", "IconBrandRumble", [["path", { "d": "M19.993 9.108c.383 .4 .687 .863 .893 1.368a4.195 4.195 0 0 1 .006 3.166a4.37 4.37 0 0 1 -.887 1.372a20.233 20.233 0 0 1 -2.208 2a20.615 20.615 0 0 1 -2.495 1.669a21.322 21.322 0 0 1 -5.622 2.202a4.213 4.213 0 0 1 -3.002 -.404a3.98 3.98 0 0 1 -1.163 -.967a3.796 3.796 0 0 1 -.695 -1.312c-1.199 -3.902 -1.022 -8.312 .134 -12.23c.609 -2.057 2.643 -3.349 4.737 -2.874c3.88 .88 7.52 3.147 10.302 6.01z", "key": "svg-0" }], ["path", { "d": "M14.044 13.034c.67 -.505 .67 -1.489 0 -2.01a14.824 14.824 0 0 0 -1.498 -1.044a15.783 15.783 0 0 0 -1.62 -.865c-.77 -.35 -1.63 .139 -1.753 .973a15.385 15.385 0 0 0 -.1 3.786a1.232 1.232 0 0 0 1.715 1.027a14.783 14.783 0 0 0 1.694 -.827a14.46 14.46 0 0 0 1.562 -1.035v-.005z", "key": "svg-1" }]]);

var IconBrandRumble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRumble
});

var IconBrandRust = createReactComponent("outline", "brand-rust", "IconBrandRust", [["path", { "d": "M10.139 3.463c.473 -1.95 3.249 -1.95 3.722 0a1.916 1.916 0 0 0 2.859 1.185c1.714 -1.045 3.678 .918 2.633 2.633a1.916 1.916 0 0 0 1.184 2.858c1.95 .473 1.95 3.249 0 3.722a1.916 1.916 0 0 0 -1.185 2.859c1.045 1.714 -.918 3.678 -2.633 2.633a1.916 1.916 0 0 0 -2.858 1.184c-.473 1.95 -3.249 1.95 -3.722 0a1.916 1.916 0 0 0 -2.859 -1.185c-1.714 1.045 -3.678 -.918 -2.633 -2.633a1.916 1.916 0 0 0 -1.184 -2.858c-1.95 -.473 -1.95 -3.249 0 -3.722a1.916 1.916 0 0 0 1.185 -2.859c-1.045 -1.714 .918 -3.678 2.633 -2.633a1.914 1.914 0 0 0 2.858 -1.184z", "key": "svg-0" }], ["path", { "d": "M8 12h6a2 2 0 1 0 0 -4h-6v8v-4z", "key": "svg-1" }], ["path", { "d": "M19 16h-2a2 2 0 0 1 -2 -2a2 2 0 0 0 -2 -2h-1", "key": "svg-2" }], ["path", { "d": "M9 8h-4", "key": "svg-3" }], ["path", { "d": "M5 16h4", "key": "svg-4" }]]);

var IconBrandRust$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandRust
});

var IconBrandSafari = createReactComponent("outline", "brand-safari", "IconBrandSafari", [["path", { "d": "M8 16l2 -6l6 -2l-2 6l-6 2", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconBrandSafari$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSafari
});

var IconBrandSamsungpass = createReactComponent("outline", "brand-samsungpass", "IconBrandSamsungpass", [["path", { "d": "M4 10m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 10v-1.862c0 -2.838 2.239 -5.138 5 -5.138s5 2.3 5 5.138v1.862", "key": "svg-1" }], ["path", { "d": "M10.485 17.577c.337 .29 .7 .423 1.515 .423h.413c.323 0 .633 -.133 .862 -.368a1.27 1.27 0 0 0 .356 -.886c0 -.332 -.128 -.65 -.356 -.886a1.203 1.203 0 0 0 -.862 -.368h-.826a1.2 1.2 0 0 1 -.861 -.367a1.27 1.27 0 0 1 -.356 -.886c0 -.332 .128 -.651 .356 -.886a1.2 1.2 0 0 1 .861 -.368h.413c.816 0 1.178 .133 1.515 .423", "key": "svg-2" }]]);

var IconBrandSamsungpass$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSamsungpass
});

var IconBrandSass = createReactComponent("outline", "brand-sass", "IconBrandSass", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 10.523c2.46 -.826 4 -.826 4 -2.155c0 -1.366 -1.347 -1.366 -2.735 -1.366c-1.91 0 -3.352 .49 -4.537 1.748c-.848 .902 -1.027 2.449 -.153 3.307c.973 .956 3.206 1.789 2.884 3.493c-.233 1.235 -1.469 1.823 -2.617 1.202c-.782 -.424 -.454 -1.746 .626 -2.512s2.822 -.992 4.1 -.24c.98 .575 1.046 1.724 .434 2.193", "key": "svg-1" }]]);

var IconBrandSass$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSass
});

var IconBrandSentry = createReactComponent("outline", "brand-sentry", "IconBrandSentry", [["path", { "d": "M3 18a1.93 1.93 0 0 0 .306 1.076a2 2 0 0 0 1.584 .924c.646 .033 -.537 0 .11 0h3a4.992 4.992 0 0 0 -3.66 -4.81c.558 -.973 1.24 -2.149 2.04 -3.531a9 9 0 0 1 5.62 8.341h4c.663 0 2.337 0 3 0a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-1.84 3.176c4.482 2.05 7.6 6.571 7.6 11.824", "key": "svg-0" }]]);

var IconBrandSentry$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSentry
});

var IconBrandSharik = createReactComponent("outline", "brand-sharik", "IconBrandSharik", [["path", { "d": "M4.281 16.606a8.968 8.968 0 0 1 1.363 -10.977a9.033 9.033 0 0 1 11.011 -1.346c-1.584 4.692 -2.415 6.96 -4.655 8.717c-1.584 1.242 -3.836 2.24 -7.719 3.606zm16.335 -7.306c2.113 7.59 -4.892 13.361 -11.302 11.264c1.931 -3.1 3.235 -4.606 4.686 -6.065c1.705 -1.715 3.591 -3.23 6.616 -5.199z", "key": "svg-0" }]]);

var IconBrandSharik$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSharik
});

var IconBrandShazam = createReactComponent("outline", "brand-shazam", "IconBrandShazam", [["path", { "d": "M10 12l2 -2a2.828 2.828 0 0 1 4 0a2.828 2.828 0 0 1 0 4l-3 3", "key": "svg-0" }], ["path", { "d": "M14 12l-2 2a2.828 2.828 0 1 1 -4 -4l3 -3", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconBrandShazam$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandShazam
});

var IconBrandShopee = createReactComponent("outline", "brand-shopee", "IconBrandShopee", [["path", { "d": "M4 7l.867 12.143a2 2 0 0 0 2 1.857h10.276a2 2 0 0 0 2 -1.857l.867 -12.143h-16z", "key": "svg-0" }], ["path", { "d": "M8.5 7c0 -1.653 1.5 -4 3.5 -4s3.5 2.347 3.5 4", "key": "svg-1" }], ["path", { "d": "M9.5 17c.413 .462 1 1 2.5 1s2.5 -.897 2.5 -2s-1 -1.5 -2.5 -2s-2 -1.47 -2 -2c0 -1.104 1 -2 2 -2s1.5 0 2.5 1", "key": "svg-2" }]]);

var IconBrandShopee$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandShopee
});

var IconBrandSketch = createReactComponent("outline", "brand-sketch", "IconBrandSketch", [["path", { "d": "M3.262 10.878l8 8.789c.4 .44 1.091 .44 1.491 0l8 -8.79c.313 -.344 .349 -.859 .087 -1.243l-3.537 -5.194a1 1 0 0 0 -.823 -.436h-8.926a1 1 0 0 0 -.823 .436l-3.54 5.192c-.263 .385 -.227 .901 .087 1.246z", "key": "svg-0" }]]);

var IconBrandSketch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSketch
});

var IconBrandSkype = createReactComponent("outline", "brand-skype", "IconBrandSkype", [["path", { "d": "M12 3a9 9 0 0 1 8.603 11.65a4.5 4.5 0 0 1 -5.953 5.953a9 9 0 0 1 -11.253 -11.253a4.5 4.5 0 0 1 5.953 -5.954a8.987 8.987 0 0 1 2.65 -.396z", "key": "svg-0" }], ["path", { "d": "M8 14.5c.5 2 2.358 2.5 4 2.5c2.905 0 4 -1.187 4 -2.5c0 -1.503 -1.927 -2.5 -4 -2.5s-4 -1 -4 -2.5c0 -1.313 1.095 -2.5 4 -2.5c1.642 0 3.5 .5 4 2.5", "key": "svg-1" }]]);

var IconBrandSkype$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSkype
});

var IconBrandSlack = createReactComponent("outline", "brand-slack", "IconBrandSlack", [["path", { "d": "M12 12v-6a2 2 0 0 1 4 0v6m0 -2a2 2 0 1 1 2 2h-6", "key": "svg-0" }], ["path", { "d": "M12 12h6a2 2 0 0 1 0 4h-6m2 0a2 2 0 1 1 -2 2v-6", "key": "svg-1" }], ["path", { "d": "M12 12v6a2 2 0 0 1 -4 0v-6m0 2a2 2 0 1 1 -2 -2h6", "key": "svg-2" }], ["path", { "d": "M12 12h-6a2 2 0 0 1 0 -4h6m-2 0a2 2 0 1 1 2 -2v6", "key": "svg-3" }]]);

var IconBrandSlack$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSlack
});

var IconBrandSnapchat = createReactComponent("outline", "brand-snapchat", "IconBrandSnapchat", [["path", { "d": "M16.882 7.842a4.882 4.882 0 0 0 -9.764 0c0 4.273 -.213 6.409 -4.118 8.118c2 .882 2 .882 3 3c3 0 4 2 6 2s3 -2 6 -2c1 -2.118 1 -2.118 3 -3c-3.906 -1.709 -4.118 -3.845 -4.118 -8.118zm-13.882 8.119c4 -2.118 4 -4.118 1 -7.118m17 7.118c-4 -2.118 -4 -4.118 -1 -7.118", "key": "svg-0" }]]);

var IconBrandSnapchat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSnapchat
});

var IconBrandSnapseed = createReactComponent("outline", "brand-snapseed", "IconBrandSnapseed", [["path", { "d": "M8.152 3.115a.46 .46 0 0 0 -.609 0c-2.943 2.58 -4.529 5.441 -4.543 8.378c0 2.928 1.586 5.803 4.543 8.392a.46 .46 0 0 0 .61 0c2.957 -2.589 4.547 -5.464 4.547 -8.392c0 -2.928 -1.6 -5.799 -4.548 -8.378z", "key": "svg-0" }], ["path", { "d": "M8 20l12.09 -.011c.503 0 .91 -.434 .91 -.969v-6.063c0 -.535 -.407 -.968 -.91 -.968h-7.382", "key": "svg-1" }]]);

var IconBrandSnapseed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSnapseed
});

var IconBrandSnowflake = createReactComponent("outline", "brand-snowflake", "IconBrandSnowflake", [["path", { "d": "M14 21v-5.5l4.5 2.5", "key": "svg-0" }], ["path", { "d": "M10 21v-5.5l-4.5 2.5", "key": "svg-1" }], ["path", { "d": "M3.5 14.5l4.5 -2.5l-4.5 -2.5", "key": "svg-2" }], ["path", { "d": "M20.5 9.5l-4.5 2.5l4.5 2.5", "key": "svg-3" }], ["path", { "d": "M10 3v5.5l-4.5 -2.5", "key": "svg-4" }], ["path", { "d": "M14 3v5.5l4.5 -2.5", "key": "svg-5" }], ["path", { "d": "M12 11l1 1l-1 1l-1 -1z", "key": "svg-6" }]]);

var IconBrandSnowflake$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSnowflake
});

var IconBrandSocketIo = createReactComponent("outline", "brand-socket-io", "IconBrandSocketIo", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M11 11h1l3 -4z", "key": "svg-1" }], ["path", { "d": "M12 13h1l-4 4z", "key": "svg-2" }]]);

var IconBrandSocketIo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSocketIo
});

var IconBrandSolidjs = createReactComponent("outline", "brand-solidjs", "IconBrandSolidjs", [["path", { "d": "M2 17.5c4.667 3 8 4.5 10 4.5c2.5 0 4 -1.5 4 -3.5s-1.5 -3.5 -4 -3.5c-2 0 -5.333 .833 -10 2.5z", "key": "svg-0" }], ["path", { "d": "M5 13.5c4.667 -1.667 8 -2.5 10 -2.5c2.5 0 4 1.5 4 3.5c0 .738 -.204 1.408 -.588 1.96l-2.883 3.825", "key": "svg-1" }], ["path", { "d": "M22 6.5c-4 -3 -8 -4.5 -10 -4.5c-2.04 0 -2.618 .463 -3.419 1.545", "key": "svg-2" }], ["path", { "d": "M2 17.5l3 -4", "key": "svg-3" }], ["path", { "d": "M22 6.5l-3 4", "key": "svg-4" }], ["path", { "d": "M8.581 3.545l-2.953 3.711", "key": "svg-5" }], ["path", { "d": "M7.416 12.662c-1.51 -.476 -2.416 -1.479 -2.416 -3.162c0 -2.5 1.5 -3.5 4 -3.5c1.688 0 5.087 1.068 8.198 3.204a114.76 114.76 0 0 1 1.802 1.296l-2.302 .785", "key": "svg-6" }]]);

var IconBrandSolidjs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSolidjs
});

var IconBrandSoundcloud = createReactComponent("outline", "brand-soundcloud", "IconBrandSoundcloud", [["path", { "d": "M17 11h1c1.38 0 3 1.274 3 3c0 1.657 -1.5 3 -3 3l-6 0v-10c3 0 4.5 1.5 5 4z", "key": "svg-0" }], ["path", { "d": "M9 8l0 9", "key": "svg-1" }], ["path", { "d": "M6 17l0 -7", "key": "svg-2" }], ["path", { "d": "M3 16l0 -2", "key": "svg-3" }]]);

var IconBrandSoundcloud$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSoundcloud
});

var IconBrandSpacehey = createReactComponent("outline", "brand-spacehey", "IconBrandSpacehey", [["path", { "d": "M17 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M14 20h6v-6a3 3 0 0 0 -6 0v6z", "key": "svg-1" }], ["path", { "d": "M11 8v2.5a3.5 3.5 0 0 1 -3.5 3.5h-.5a3 3 0 0 1 0 -6h4z", "key": "svg-2" }]]);

var IconBrandSpacehey$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSpacehey
});

var IconBrandSpeedtest = createReactComponent("outline", "brand-speedtest", "IconBrandSpeedtest", [["path", { "d": "M5.636 19.364a9 9 0 1 1 12.728 0", "key": "svg-0" }], ["path", { "d": "M16 9l-4 4", "key": "svg-1" }]]);

var IconBrandSpeedtest$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSpeedtest
});

var IconBrandSpotify = createReactComponent("outline", "brand-spotify", "IconBrandSpotify", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 11.973c2.5 -1.473 5.5 -.973 7.5 .527", "key": "svg-1" }], ["path", { "d": "M9 15c1.5 -1 4 -1 5 .5", "key": "svg-2" }], ["path", { "d": "M7 9c2 -1 6 -2 10 .5", "key": "svg-3" }]]);

var IconBrandSpotify$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSpotify
});

var IconBrandStackoverflow = createReactComponent("outline", "brand-stackoverflow", "IconBrandStackoverflow", [["path", { "d": "M4 17v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-1", "key": "svg-0" }], ["path", { "d": "M8 16h8", "key": "svg-1" }], ["path", { "d": "M8.322 12.582l7.956 .836", "key": "svg-2" }], ["path", { "d": "M8.787 9.168l7.826 1.664", "key": "svg-3" }], ["path", { "d": "M10.096 5.764l7.608 2.472", "key": "svg-4" }]]);

var IconBrandStackoverflow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStackoverflow
});

var IconBrandStackshare = createReactComponent("outline", "brand-stackshare", "IconBrandStackshare", [["path", { "d": "M19 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M19 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M7 12h3l3.5 6h3.5", "key": "svg-3" }], ["path", { "d": "M17 6h-3.5l-3.5 6", "key": "svg-4" }]]);

var IconBrandStackshare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStackshare
});

var IconBrandSteam = createReactComponent("outline", "brand-steam", "IconBrandSteam", [["path", { "d": "M16.5 5a4.5 4.5 0 1 1 -.653 8.953l-4.347 3.009l0 .038a3 3 0 0 1 -2.824 3l-.176 0a3 3 0 0 1 -2.94 -2.402l-2.56 -1.098v-3.5l3.51 1.755a2.989 2.989 0 0 1 2.834 -.635l2.727 -3.818a4.5 4.5 0 0 1 4.429 -5.302z", "key": "svg-0" }], ["circle", { "cx": "16.5", "cy": "9.5", "r": "1", "fill": "currentColor", "key": "svg-1" }]]);

var IconBrandSteam$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSteam
});

var IconBrandStocktwits = createReactComponent("outline", "brand-stocktwits", "IconBrandStocktwits", [["path", { "d": "M16 3l-8 4.5l8 4.5", "key": "svg-0" }], ["path", { "d": "M8 12l8 4.5l-8 4.5", "key": "svg-1" }]]);

var IconBrandStocktwits$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStocktwits
});

var IconBrandStorj = createReactComponent("outline", "brand-storj", "IconBrandStorj", [["path", { "d": "M4 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M4 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M20 17m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M20 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M12 3m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }], ["path", { "d": "M12 21m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-5" }], ["path", { "d": "M12 21l-8 -4v-10l8 -4l8 4v10z", "key": "svg-6" }], ["path", { "d": "M9.1 15a2.1 2.1 0 0 1 -.648 -4.098c.282 -1.648 1.319 -2.902 3.048 -2.902c1.694 0 2.906 1.203 3.23 2.8h.17a2.1 2.1 0 0 1 .202 4.19l-.202 .01h-5.8z", "key": "svg-7" }], ["path", { "d": "M4 7l4.323 2.702", "key": "svg-8" }], ["path", { "d": "M16.413 14.758l3.587 2.242", "key": "svg-9" }], ["path", { "d": "M4 17l3.529 -2.206", "key": "svg-10" }], ["path", { "d": "M14.609 10.37l5.391 -3.37", "key": "svg-11" }], ["path", { "d": "M12 3v5", "key": "svg-12" }], ["path", { "d": "M12 15v6", "key": "svg-13" }]]);

var IconBrandStorj$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStorj
});

var IconBrandStorybook = createReactComponent("outline", "brand-storybook", "IconBrandStorybook", [["path", { "d": "M5 4l.5 16.5l13.5 .5v-18z", "key": "svg-0" }], ["path", { "d": "M9 15c.6 1.5 1.639 2 3.283 2h-.283c1.8 0 3 -.974 3 -2.435c0 -1.194 -.831 -1.799 -2.147 -2.333l-1.975 -.802c-1.15 -.467 -1.878 -1.422 -1.878 -2.467c0 -.97 .899 -1.786 2.087 -1.893l.613 -.055c1.528 -.138 3 .762 3.3 1.985", "key": "svg-1" }], ["path", { "d": "M16 3.5v1", "key": "svg-2" }]]);

var IconBrandStorybook$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStorybook
});

var IconBrandStorytel = createReactComponent("outline", "brand-storytel", "IconBrandStorytel", [["path", { "d": "M4.103 22c2.292 -2.933 16.825 -2.43 16.825 -11.538c0 -6.298 -4.974 -8.462 -8.451 -8.462c-3.477 0 -9.477 3.036 -9.477 11.241c0 6.374 1.103 8.759 1.103 8.759z", "key": "svg-0" }]]);

var IconBrandStorytel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStorytel
});

var IconBrandStrava = createReactComponent("outline", "brand-strava", "IconBrandStrava", [["path", { "d": "M15 13l-5 -10l-5 10m6 0l4 8l4 -8", "key": "svg-0" }]]);

var IconBrandStrava$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStrava
});

var IconBrandStripe = createReactComponent("outline", "brand-stripe", "IconBrandStripe", [["path", { "d": "M11.453 8.056c0 -.623 .518 -.979 1.442 -.979c1.69 0 3.41 .343 4.605 .923l.5 -4c-.948 -.449 -2.82 -1 -5.5 -1c-1.895 0 -3.373 .087 -4.5 1c-1.172 .956 -2 2.33 -2 4c0 3.03 1.958 4.906 5 6c1.961 .69 3 .743 3 1.5c0 .735 -.851 1.5 -2 1.5c-1.423 0 -3.963 -.609 -5.5 -1.5l-.5 4c1.321 .734 3.474 1.5 6 1.5c2 0 3.957 -.468 5.084 -1.36c1.263 -.979 1.916 -2.268 1.916 -4.14c0 -3.096 -1.915 -4.547 -5 -5.637c-1.646 -.605 -2.544 -1.07 -2.544 -1.807z", "key": "svg-0" }]]);

var IconBrandStripe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandStripe
});

var IconBrandSublimeText = createReactComponent("outline", "brand-sublime-text", "IconBrandSublimeText", [["path", { "d": "M19 8l-14 4.5v-5.5l14 -4.5z", "key": "svg-0" }], ["path", { "d": "M19 17l-14 4.5v-5.5l14 -4.5z", "key": "svg-1" }], ["path", { "d": "M19 11.5l-14 -4.5", "key": "svg-2" }], ["path", { "d": "M5 12.5l14 4.5", "key": "svg-3" }]]);

var IconBrandSublimeText$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSublimeText
});

var IconBrandSugarizer = createReactComponent("outline", "brand-sugarizer", "IconBrandSugarizer", [["path", { "d": "M14.277 16l3.252 -3.252a1.61 1.61 0 0 0 -2.277 -2.276l-3.252 3.251l-3.252 -3.251a1.61 1.61 0 0 0 -2.276 2.276l3.251 3.252l-3.251 3.252a1.61 1.61 0 1 0 2.276 2.277l3.252 -3.252l3.252 3.252a1.61 1.61 0 1 0 2.277 -2.277l-3.252 -3.252z", "key": "svg-0" }], ["path", { "d": "M12 5m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }]]);

var IconBrandSugarizer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSugarizer
});

var IconBrandSupabase = createReactComponent("outline", "brand-supabase", "IconBrandSupabase", [["path", { "d": "M4 14h8v7l8 -11h-8v-7z", "key": "svg-0" }]]);

var IconBrandSupabase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSupabase
});

var IconBrandSuperhuman = createReactComponent("outline", "brand-superhuman", "IconBrandSuperhuman", [["path", { "d": "M16 12l4 3l-8 7l-8 -7l4 -3", "key": "svg-0" }], ["path", { "d": "M12 3l-8 6l8 6l8 -6z", "key": "svg-1" }], ["path", { "d": "M12 15h8", "key": "svg-2" }]]);

var IconBrandSuperhuman$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSuperhuman
});

var IconBrandSupernova = createReactComponent("outline", "brand-supernova", "IconBrandSupernova", [["path", { "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 15h.5c3.038 0 5.5 -1.343 5.5 -3s-2.462 -3 -5.5 -3c-1.836 0 -3.462 .49 -4.46 1.245", "key": "svg-1" }], ["path", { "d": "M9 9h-.5c-3.038 0 -5.5 1.343 -5.5 3s2.462 3 5.5 3c1.844 0 3.476 -.495 4.474 -1.255", "key": "svg-2" }], ["path", { "d": "M15 9v-.5c0 -3.038 -1.343 -5.5 -3 -5.5s-3 2.462 -3 5.5c0 1.833 .49 3.457 1.241 4.456", "key": "svg-3" }], ["path", { "d": "M9 15v.5c0 3.038 1.343 5.5 3 5.5s3 -2.462 3 -5.5c0 -1.842 -.494 -3.472 -1.252 -4.47", "key": "svg-4" }]]);

var IconBrandSupernova$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSupernova
});

var IconBrandSurfshark = createReactComponent("outline", "brand-surfshark", "IconBrandSurfshark", [["path", { "d": "M19.954 9.447c-.237 -6.217 0 -6.217 -6 -6.425c-5.774 -.208 -6.824 1 -7.91 5.382c-2.884 11.816 -3.845 14.716 4.792 11.198c9.392 -3.831 9.297 -5.382 9.114 -10.155z", "key": "svg-0" }], ["path", { "d": "M8 16h.452c1.943 .007 3.526 -1.461 3.543 -3.286v-2.428c.018 -1.828 1.607 -3.298 3.553 -3.286h.452", "key": "svg-1" }]]);

var IconBrandSurfshark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSurfshark
});

var IconBrandSvelte = createReactComponent("outline", "brand-svelte", "IconBrandSvelte", [["path", { "d": "M15 8l-5 3l.821 -.495c1.86 -1.15 4.412 -.49 5.574 1.352a3.91 3.91 0 0 1 -1.264 5.42l-5.053 3.126c-1.86 1.151 -4.312 .591 -5.474 -1.251a3.91 3.91 0 0 1 1.263 -5.42l.26 -.16", "key": "svg-0" }], ["path", { "d": "M8 17l5 -3l-.822 .496c-1.86 1.151 -4.411 .491 -5.574 -1.351a3.91 3.91 0 0 1 1.264 -5.42l5.054 -3.127c1.86 -1.15 4.311 -.59 5.474 1.252a3.91 3.91 0 0 1 -1.264 5.42l-.26 .16", "key": "svg-1" }]]);

var IconBrandSvelte$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSvelte
});

var IconBrandSwift = createReactComponent("outline", "brand-swift", "IconBrandSwift", [["path", { "d": "M20.547 15.828c1.33 -4.126 -1.384 -9.521 -6.047 -12.828c-.135 -.096 2.39 6.704 1.308 9.124c-2.153 -1.454 -4.756 -3.494 -7.808 -6.124l-.5 2l-3.5 -1c4.36 4.748 7.213 7.695 8.56 8.841c-4.658 2.089 -10.65 -.978 -10.56 -.841c1.016 1.545 6 6 11 6c2 0 3.788 -.502 4.742 -1.389c.005 -.005 .432 -.446 1.378 -.17c.504 .148 1.463 .667 2.88 1.559v-1.507c0 -1.377 -.515 -2.67 -1.453 -3.665z", "key": "svg-0" }]]);

var IconBrandSwift$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSwift
});

var IconBrandSymfony = createReactComponent("outline", "brand-symfony", "IconBrandSymfony", [["path", { "d": "M6 13c.458 .667 1.125 1 2 1c1.313 0 2 -.875 2 -1.5c0 -1.5 -2 -1 -2 -2c0 -.625 .516 -1.5 1.5 -1.5c2.5 0 1.563 2 5.5 2c.667 0 1 -.333 1 -1", "key": "svg-0" }], ["path", { "d": "M9 17c-.095 .667 .238 1 1 1c1.714 0 2.714 -2 3 -6c.286 -4 1.571 -6 3 -6c.571 0 .905 .333 1 1", "key": "svg-1" }], ["path", { "d": "M22 12c0 5.523 -4.477 10 -10 10s-10 -4.477 -10 -10s4.477 -10 10 -10a10 10 0 0 1 10 10z", "key": "svg-2" }]]);

var IconBrandSymfony$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandSymfony
});

var IconBrandTabler = createReactComponent("outline", "brand-tabler", "IconBrandTabler", [["path", { "d": "M8 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M13 15h3", "key": "svg-1" }], ["path", { "d": "M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-2" }]]);

var IconBrandTabler$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTabler
});

var IconBrandTailwind = createReactComponent("outline", "brand-tailwind", "IconBrandTailwind", [["path", { "d": "M11.667 6c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 2 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968zm-4 6.5c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 1.975 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968z", "key": "svg-0" }]]);

var IconBrandTailwind$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTailwind
});

var IconBrandTaobao = createReactComponent("outline", "brand-taobao", "IconBrandTaobao", [["path", { "d": "M2 5c.968 .555 1.335 1.104 2 2", "key": "svg-0" }], ["path", { "d": "M2 10c5.007 3.674 2.85 6.544 0 10", "key": "svg-1" }], ["path", { "d": "M10 4c-.137 4.137 -2.258 5.286 -3.709 6.684", "key": "svg-2" }], ["path", { "d": "M10 6c2.194 -.8 3.736 -.852 6.056 -.993c4.206 -.158 5.523 2.264 5.803 5.153c.428 4.396 -.077 7.186 -2.117 9.298c-1.188 1.23 -3.238 2.62 -7.207 .259", "key": "svg-3" }], ["path", { "d": "M11 10h6", "key": "svg-4" }], ["path", { "d": "M13 10v6.493", "key": "svg-5" }], ["path", { "d": "M8 13h10", "key": "svg-6" }], ["path", { "d": "M16 15.512l.853 1.72", "key": "svg-7" }], ["path", { "d": "M16.5 17c-1.145 .361 -7 3 -8.5 -.5", "key": "svg-8" }], ["path", { "d": "M11.765 8.539l-1.765 2.461", "key": "svg-9" }]]);

var IconBrandTaobao$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTaobao
});

var IconBrandTeams = createReactComponent("outline", "brand-teams", "IconBrandTeams", [["path", { "d": "M3 7h10v10h-10z", "key": "svg-0" }], ["path", { "d": "M6 10h4", "key": "svg-1" }], ["path", { "d": "M8 10v4", "key": "svg-2" }], ["path", { "d": "M8.104 17c.47 2.274 2.483 4 4.896 4a5 5 0 0 0 5 -5v-7h-5", "key": "svg-3" }], ["path", { "d": "M18 18a4 4 0 0 0 4 -4v-5h-4", "key": "svg-4" }], ["path", { "d": "M13.003 8.83a3 3 0 1 0 -1.833 -1.833", "key": "svg-5" }], ["path", { "d": "M15.83 8.36a2.5 2.5 0 1 0 .594 -4.117", "key": "svg-6" }]]);

var IconBrandTeams$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTeams
});

var IconBrandTed = createReactComponent("outline", "brand-ted", "IconBrandTed", [["path", { "d": "M2 8h4", "key": "svg-0" }], ["path", { "d": "M4 8v8", "key": "svg-1" }], ["path", { "d": "M13 8h-4v8h4", "key": "svg-2" }], ["path", { "d": "M9 12h2.5", "key": "svg-3" }], ["path", { "d": "M16 8v8h2a3 3 0 0 0 3 -3v-2a3 3 0 0 0 -3 -3h-2z", "key": "svg-4" }]]);

var IconBrandTed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTed
});

var IconBrandTelegram = createReactComponent("outline", "brand-telegram", "IconBrandTelegram", [["path", { "d": "M15 10l-4 4l6 6l4 -16l-18 7l4 2l2 6l3 -4", "key": "svg-0" }]]);

var IconBrandTelegram$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTelegram
});

var IconBrandTerraform = createReactComponent("outline", "brand-terraform", "IconBrandTerraform", [["path", { "d": "M15 15.5l-11.476 -6.216a1 1 0 0 1 -.524 -.88v-4.054a1.35 1.35 0 0 1 2.03 -1.166l9.97 5.816v10.65a1.35 1.35 0 0 1 -2.03 1.166l-3.474 -2.027a1 1 0 0 1 -.496 -.863v-11.926", "key": "svg-0" }], ["path", { "d": "M15 15.5l5.504 -3.21a1 1 0 0 0 .496 -.864v-3.576a1.35 1.35 0 0 0 -2.03 -1.166l-3.97 2.316", "key": "svg-1" }]]);

var IconBrandTerraform$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTerraform
});

var IconBrandTesla = createReactComponent("outline", "brand-tesla", "IconBrandTesla", [["path", { "d": "M12 21l3 -11c2.359 0 3 0 3 1c0 0 1.18 -1.745 2 -3c-3.077 -1.464 -6 -1 -6 -1l-2 2l-2 -2s-2.923 -.464 -6 1c.82 1.255 2 3 2 3c0 -1 .744 -1 3 -1z", "key": "svg-0" }], ["path", { "d": "M20 5c-5.114 -2 -10.886 -2 -16 0", "key": "svg-1" }]]);

var IconBrandTesla$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTesla
});

var IconBrandTether = createReactComponent("outline", "brand-tether", "IconBrandTether", [["path", { "d": "M14.08 20.188c-1.15 1.083 -3.02 1.083 -4.17 0l-6.93 -6.548c-.96 -.906 -1.27 -2.624 -.69 -3.831l2.4 -5.018c.47 -.991 1.72 -1.791 2.78 -1.791h9.06c1.06 0 2.31 .802 2.78 1.79l2.4 5.019c.58 1.207 .26 2.925 -.69 3.83c-3.453 3.293 -3.466 3.279 -6.94 6.549z", "key": "svg-0" }], ["path", { "d": "M12 15v-7", "key": "svg-1" }], ["path", { "d": "M8 8h8", "key": "svg-2" }]]);

var IconBrandTether$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTether
});

var IconBrandThingiverse = createReactComponent("outline", "brand-thingiverse", "IconBrandThingiverse", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 9h8m-4 0v8", "key": "svg-1" }]]);

var IconBrandThingiverse$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandThingiverse
});

var IconBrandThreads = createReactComponent("outline", "brand-threads", "IconBrandThreads", [["path", { "d": "M19 7.5c-1.333 -3 -3.667 -4.5 -7 -4.5c-5 0 -8 2.5 -8 9s3.5 9 8 9s7 -3 7 -5s-1 -5 -7 -5c-2.5 0 -3 1.25 -3 2.5c0 1.5 1 2.5 2.5 2.5c2.5 0 3.5 -1.5 3.5 -5s-2 -4 -3 -4s-1.833 .333 -2.5 1", "key": "svg-0" }]]);

var IconBrandThreads$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandThreads
});

var IconBrandThreejs = createReactComponent("outline", "brand-threejs", "IconBrandThreejs", [["path", { "d": "M8 22l-5 -19l19 5.5z", "key": "svg-0" }], ["path", { "d": "M12.573 17.58l-6.152 -1.576l8.796 -9.466l1.914 6.64", "key": "svg-1" }], ["path", { "d": "M12.573 17.58l-1.573 -6.58l6.13 2.179", "key": "svg-2" }], ["path", { "d": "M9.527 4.893l1.473 6.107l-6.31 -1.564z", "key": "svg-3" }]]);

var IconBrandThreejs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandThreejs
});

var IconBrandTidal = createReactComponent("outline", "brand-tidal", "IconBrandTidal", [["path", { "d": "M5.333 6l3.334 3.25l3.333 -3.25l3.333 3.25l3.334 -3.25l3.333 3.25l-3.333 3.25l-3.334 -3.25l-3.333 3.25l3.333 3.25l-3.333 3.25l-3.333 -3.25l3.333 -3.25l-3.333 -3.25l-3.334 3.25l-3.333 -3.25z", "key": "svg-0" }]]);

var IconBrandTidal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTidal
});

var IconBrandTiktok = createReactComponent("outline", "brand-tiktok", "IconBrandTiktok", [["path", { "d": "M21 7.917v4.034a9.948 9.948 0 0 1 -5 -1.951v4.5a6.5 6.5 0 1 1 -8 -6.326v4.326a2.5 2.5 0 1 0 4 2v-11.5h4.083a6.005 6.005 0 0 0 4.917 4.917z", "key": "svg-0" }]]);

var IconBrandTiktok$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTiktok
});

var IconBrandTinder = createReactComponent("outline", "brand-tinder", "IconBrandTinder", [["path", { "d": "M18.918 8.174c2.56 4.982 .501 11.656 -5.38 12.626c-7.702 1.687 -12.84 -7.716 -7.054 -13.229c.309 -.305 1.161 -1.095 1.516 -1.349c0 .528 .27 3.475 1 3.167c3 0 4 -4.222 3.587 -7.389c2.7 1.411 4.987 3.376 6.331 6.174z", "key": "svg-0" }]]);

var IconBrandTinder$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTinder
});

var IconBrandTopbuzz = createReactComponent("outline", "brand-topbuzz", "IconBrandTopbuzz", [["path", { "d": "M4.417 8.655a.524 .524 0 0 1 -.405 -.622l.986 -4.617a.524 .524 0 0 1 .626 -.404l14.958 3.162c.285 .06 .467 .339 .406 .622l-.987 4.618a.524 .524 0 0 1 -.625 .404l-4.345 -.92c-.198 -.04 -.315 .024 -.353 .197l-2.028 9.49a.527 .527 0 0 1 -.625 .404l-4.642 -.982a.527 .527 0 0 1 -.406 -.622l2.028 -9.493c.037 -.17 -.031 -.274 -.204 -.31l-4.384 -.927z", "key": "svg-0" }]]);

var IconBrandTopbuzz$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTopbuzz
});

var IconBrandTorchain = createReactComponent("outline", "brand-torchain", "IconBrandTorchain", [["path", { "d": "M15.588 15.537l-3.553 -3.537l-7.742 8.18c-.791 .85 .153 2.18 1.238 1.73l9.616 -4.096a1.398 1.398 0 0 0 .44 -2.277z", "key": "svg-0" }], ["path", { "d": "M8.412 8.464l3.553 3.536l7.742 -8.18c.791 -.85 -.153 -2.18 -1.238 -1.73l-9.616 4.098a1.398 1.398 0 0 0 -.44 2.277z", "key": "svg-1" }]]);

var IconBrandTorchain$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTorchain
});

var IconBrandToyota = createReactComponent("outline", "brand-toyota", "IconBrandToyota", [["path", { "d": "M12 12m-10 0a10 7 0 1 0 20 0a10 7 0 1 0 -20 0", "key": "svg-0" }], ["path", { "d": "M9 12c0 3.866 1.343 7 3 7s3 -3.134 3 -7s-1.343 -7 -3 -7s-3 3.134 -3 7z", "key": "svg-1" }], ["path", { "d": "M6.415 6.191c-.888 .503 -1.415 1.13 -1.415 1.809c0 1.657 3.134 3 7 3s7 -1.343 7 -3c0 -.678 -.525 -1.304 -1.41 -1.806", "key": "svg-2" }]]);

var IconBrandToyota$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandToyota
});

var IconBrandTrello = createReactComponent("outline", "brand-trello", "IconBrandTrello", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7 7h3v10h-3z", "key": "svg-1" }], ["path", { "d": "M14 7h3v6h-3z", "key": "svg-2" }]]);

var IconBrandTrello$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTrello
});

var IconBrandTripadvisor = createReactComponent("outline", "brand-tripadvisor", "IconBrandTripadvisor", [["path", { "d": "M6.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-0" }], ["path", { "d": "M17.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0", "key": "svg-1" }], ["path", { "d": "M17.5 9a4.5 4.5 0 1 0 3.5 1.671l1 -1.671h-4.5z", "key": "svg-2" }], ["path", { "d": "M6.5 9a4.5 4.5 0 1 1 -3.5 1.671l-1 -1.671h4.5z", "key": "svg-3" }], ["path", { "d": "M10.5 15.5l1.5 2l1.5 -2", "key": "svg-4" }], ["path", { "d": "M9 6.75c2 -.667 4 -.667 6 0", "key": "svg-5" }]]);

var IconBrandTripadvisor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTripadvisor
});

var IconBrandTumblr = createReactComponent("outline", "brand-tumblr", "IconBrandTumblr", [["path", { "d": "M14 21h4v-4h-4v-6h4v-4h-4v-4h-4v1a3 3 0 0 1 -3 3h-1v4h4v6a4 4 0 0 0 4 4", "key": "svg-0" }]]);

var IconBrandTumblr$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTumblr
});

var IconBrandTwilio = createReactComponent("outline", "brand-twilio", "IconBrandTwilio", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M9 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M15 9m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M15 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9 15m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconBrandTwilio$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTwilio
});

var IconBrandTwitch = createReactComponent("outline", "brand-twitch", "IconBrandTwitch", [["path", { "d": "M4 5v11a1 1 0 0 0 1 1h2v4l4 -4h5.584c.266 0 .52 -.105 .707 -.293l2.415 -2.414c.187 -.188 .293 -.442 .293 -.708v-8.585a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1z", "key": "svg-0" }], ["path", { "d": "M16 8l0 4", "key": "svg-1" }], ["path", { "d": "M12 8l0 4", "key": "svg-2" }]]);

var IconBrandTwitch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTwitch
});

var IconBrandTwitter = createReactComponent("outline", "brand-twitter", "IconBrandTwitter", [["path", { "d": "M22 4.01c-1 .49 -1.98 .689 -3 .99c-1.121 -1.265 -2.783 -1.335 -4.38 -.737s-2.643 2.06 -2.62 3.737v1c-3.245 .083 -6.135 -1.395 -8 -4c0 0 -4.182 7.433 4 11c-1.872 1.247 -3.739 2.088 -6 2c3.308 1.803 6.913 2.423 10.034 1.517c3.58 -1.04 6.522 -3.723 7.651 -7.742a13.84 13.84 0 0 0 .497 -3.753c0 -.249 1.51 -2.772 1.818 -4.013z", "key": "svg-0" }]]);

var IconBrandTwitter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTwitter
});

var IconBrandTypescript = createReactComponent("outline", "brand-typescript", "IconBrandTypescript", [["path", { "d": "M15 17.5c.32 .32 .754 .5 1.207 .5h.543c.69 0 1.25 -.56 1.25 -1.25v-.25a1.5 1.5 0 0 0 -1.5 -1.5a1.5 1.5 0 0 1 -1.5 -1.5v-.25c0 -.69 .56 -1.25 1.25 -1.25h.543c.453 0 .887 .18 1.207 .5", "key": "svg-0" }], ["path", { "d": "M9 12h4", "key": "svg-1" }], ["path", { "d": "M11 12v6", "key": "svg-2" }], ["path", { "d": "M21 19v-14a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2z", "key": "svg-3" }]]);

var IconBrandTypescript$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandTypescript
});

var IconBrandUber = createReactComponent("outline", "brand-uber", "IconBrandUber", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 9m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M3 12h6", "key": "svg-2" }]]);

var IconBrandUber$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandUber
});

var IconBrandUbuntu = createReactComponent("outline", "brand-ubuntu", "IconBrandUbuntu", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17.723 7.41a7.992 7.992 0 0 0 -3.74 -2.162m-3.971 0a7.993 7.993 0 0 0 -3.789 2.216m-1.881 3.215a8 8 0 0 0 -.342 2.32c0 .738 .1 1.453 .287 2.132m1.96 3.428a7.993 7.993 0 0 0 3.759 2.19m4 0a7.993 7.993 0 0 0 3.747 -2.186m1.962 -3.43a8.008 8.008 0 0 0 .287 -2.131c0 -.764 -.107 -1.503 -.307 -2.203", "key": "svg-1" }], ["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }]]);

var IconBrandUbuntu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandUbuntu
});

var IconBrandUnity = createReactComponent("outline", "brand-unity", "IconBrandUnity", [["path", { "d": "M14 3l6 4v7", "key": "svg-0" }], ["path", { "d": "M18 17l-6 4l-6 -4", "key": "svg-1" }], ["path", { "d": "M4 14v-7l6 -4", "key": "svg-2" }], ["path", { "d": "M4 7l8 5v9", "key": "svg-3" }], ["path", { "d": "M20 7l-8 5", "key": "svg-4" }]]);

var IconBrandUnity$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandUnity
});

var IconBrandUnsplash = createReactComponent("outline", "brand-unsplash", "IconBrandUnsplash", [["path", { "d": "M4 11h5v4h6v-4h5v9h-16zm5 -7h6v4h-6z", "key": "svg-0" }]]);

var IconBrandUnsplash$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandUnsplash
});

var IconBrandUpwork = createReactComponent("outline", "brand-upwork", "IconBrandUpwork", [["path", { "d": "M3 7v5a3 3 0 0 0 6 0v-5h1l4 6c.824 1.319 1.945 2 3.5 2a3.5 3.5 0 0 0 0 -7c-2.027 0 -3.137 1 -3.5 3c-.242 1.33 -.908 4 -2 8", "key": "svg-0" }]]);

var IconBrandUpwork$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandUpwork
});

var IconBrandValorant = createReactComponent("outline", "brand-valorant", "IconBrandValorant", [["path", { "d": "M14.5 14h4.5l2 -2v-6z", "key": "svg-0" }], ["path", { "d": "M9 19h5l-11 -13v6z", "key": "svg-1" }]]);

var IconBrandValorant$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandValorant
});

var IconBrandVercel = createReactComponent("outline", "brand-vercel", "IconBrandVercel", [["path", { "d": "M3 19h18l-9 -15z", "key": "svg-0" }]]);

var IconBrandVercel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVercel
});

var IconBrandVimeo = createReactComponent("outline", "brand-vimeo", "IconBrandVimeo", [["path", { "d": "M3 8.5l1 1s1.5 -1.102 2 -.5c.509 .609 1.863 7.65 2.5 9c.556 1.184 1.978 2.89 4 1.5c2 -1.5 7.5 -5.5 8.5 -11.5c.444 -2.661 -1 -4 -2.5 -4c-2 0 -4.047 1.202 -4.5 4c2.05 -1.254 2.551 1 1.5 3c-1.052 2 -2 3 -2.5 3c-.49 0 -.924 -1.165 -1.5 -3.5c-.59 -2.42 -.5 -6.5 -3 -6.5s-5.5 4.5 -5.5 4.5z", "key": "svg-0" }]]);

var IconBrandVimeo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVimeo
});

var IconBrandVinted = createReactComponent("outline", "brand-vinted", "IconBrandVinted", [["path", { "d": "M11.028 6c0 7.695 -.292 11.728 0 12c2.046 -5 4.246 -12.642 5.252 -14.099c.343 -.497 .768 -.93 1.257 -1.277c.603 -.39 1.292 -.76 1.463 -.575c-.07 2.319 -4.023 15.822 -4.209 16.314a6.135 6.135 0 0 1 -3.465 3.386c-3.213 .78 -3.429 -.446 -3.836 -1.134c-.95 -2.103 -1.682 -14.26 -1.445 -15.615c.05 -.523 .143 -1.851 2.491 -2c2.359 -.354 2.547 1.404 2.492 3z", "key": "svg-0" }]]);

var IconBrandVinted$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVinted
});

var IconBrandVisa = createReactComponent("outline", "brand-visa", "IconBrandVisa", [["path", { "d": "M21 15l-1 -6l-2.5 6", "key": "svg-0" }], ["path", { "d": "M9 15l1 -6", "key": "svg-1" }], ["path", { "d": "M3 9h1v6h.5l2.5 -6", "key": "svg-2" }], ["path", { "d": "M16 9.5a.5 .5 0 0 0 -.5 -.5h-.75c-.721 0 -1.337 .521 -1.455 1.233l-.09 .534a1.059 1.059 0 0 0 1.045 1.233a1.059 1.059 0 0 1 1.045 1.233l-.09 .534a1.476 1.476 0 0 1 -1.455 1.233h-.75a.5 .5 0 0 1 -.5 -.5", "key": "svg-3" }], ["path", { "d": "M18 14h2.7", "key": "svg-4" }]]);

var IconBrandVisa$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVisa
});

var IconBrandVisualStudio = createReactComponent("outline", "brand-visual-studio", "IconBrandVisualStudio", [["path", { "d": "M4 8l2 -1l10 13l4 -2v-12l-4 -2l-10 13l-2 -1z", "key": "svg-0" }]]);

var IconBrandVisualStudio$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVisualStudio
});

var IconBrandVite = createReactComponent("outline", "brand-vite", "IconBrandVite", [["path", { "d": "M10 4.5l6 -1.5l-2 6.5l2 -.5l-4 7v-5l-3 1z", "key": "svg-0" }], ["path", { "d": "M15 6.5l7 -1.5l-10 17l-10 -17l7.741 1.5", "key": "svg-1" }]]);

var IconBrandVite$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVite
});

var IconBrandVivaldi = createReactComponent("outline", "brand-vivaldi", "IconBrandVivaldi", [["path", { "d": "M21.648 6.808c-2.468 4.28 -4.937 8.56 -7.408 12.836c-.397 .777 -1.366 1.301 -2.24 1.356c-.962 .102 -1.7 -.402 -2.154 -1.254c-1.563 -2.684 -3.106 -5.374 -4.66 -8.064c-.943 -1.633 -1.891 -3.266 -2.83 -4.905a2.47 2.47 0 0 1 -.06 -2.45a2.493 2.493 0 0 1 2.085 -1.307c.951 -.065 1.85 .438 2.287 1.281c.697 1.19 2.043 3.83 2.55 4.682a3.919 3.919 0 0 0 3.282 2.017c2.126 .133 3.974 -.95 4.21 -3.058c0 -.164 .228 -3.178 .846 -3.962c.619 -.784 1.64 -1.155 2.606 -.893a2.484 2.484 0 0 1 1.814 2.062c.08 .581 -.041 1.171 -.343 1.674", "key": "svg-0" }]]);

var IconBrandVivaldi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVivaldi
});

var IconBrandVk = createReactComponent("outline", "brand-vk", "IconBrandVk", [["path", { "d": "M14 19h-4a8 8 0 0 1 -8 -8v-5h4v5a4 4 0 0 0 4 4h0v-9h4v4.5l.03 0a4.531 4.531 0 0 0 3.97 -4.496h4l-.342 1.711a6.858 6.858 0 0 1 -3.658 4.789h0a5.34 5.34 0 0 1 3.566 4.111l.434 2.389h0h-4a4.531 4.531 0 0 0 -3.97 -4.496v4.5z", "key": "svg-0" }]]);

var IconBrandVk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVk
});

var IconBrandVlc = createReactComponent("outline", "brand-vlc", "IconBrandVlc", [["path", { "d": "M13.79 4.337l3.101 9.305c.33 .985 -.113 2.07 -1.02 2.499a9.148 9.148 0 0 1 -7.742 0c-.907 -.428 -1.35 -1.514 -1.02 -2.499l3.1 -9.305c.267 -.8 .985 -1.337 1.791 -1.337c.807 0 1.525 .537 1.79 1.337z", "key": "svg-0" }], ["path", { "d": "M7 14h-1.429a2 2 0 0 0 -1.923 1.45l-.571 2a2 2 0 0 0 1.923 2.55h13.998a2 2 0 0 0 1.923 -2.55l-.572 -2a2 2 0 0 0 -1.923 -1.45h-1.426", "key": "svg-1" }]]);

var IconBrandVlc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVlc
});

var IconBrandVolkswagen = createReactComponent("outline", "brand-volkswagen", "IconBrandVolkswagen", [["path", { "d": "M12 21a9 9 0 0 0 9 -9a9 9 0 0 0 -9 -9a9 9 0 0 0 -9 9a9 9 0 0 0 9 9z", "key": "svg-0" }], ["path", { "d": "M5 7l4.5 11l1.5 -5h2l1.5 5l4.5 -11", "key": "svg-1" }], ["path", { "d": "M9 4l2 6h2l2 -6", "key": "svg-2" }]]);

var IconBrandVolkswagen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVolkswagen
});

var IconBrandVsco = createReactComponent("outline", "brand-vsco", "IconBrandVsco", [["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-0" }], ["path", { "d": "M17 12a5 5 0 1 0 -10 0a5 5 0 0 0 10 0z", "key": "svg-1" }], ["path", { "d": "M12 3v4", "key": "svg-2" }], ["path", { "d": "M21 12h-4", "key": "svg-3" }], ["path", { "d": "M12 21v-4", "key": "svg-4" }], ["path", { "d": "M3 12h4", "key": "svg-5" }], ["path", { "d": "M18.364 5.636l-2.828 2.828", "key": "svg-6" }], ["path", { "d": "M18.364 18.364l-2.828 -2.828", "key": "svg-7" }], ["path", { "d": "M5.636 18.364l2.828 -2.828", "key": "svg-8" }], ["path", { "d": "M5.636 5.636l2.828 2.828", "key": "svg-9" }]]);

var IconBrandVsco$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVsco
});

var IconBrandVscode = createReactComponent("outline", "brand-vscode", "IconBrandVscode", [["path", { "d": "M16 3v18l4 -2.5v-13z", "key": "svg-0" }], ["path", { "d": "M9.165 13.903l-4.165 3.597l-2 -1l4.333 -4.5m1.735 -1.802l6.932 -7.198v5l-4.795 4.141", "key": "svg-1" }], ["path", { "d": "M16 16.5l-11 -10l-2 1l13 13.5", "key": "svg-2" }]]);

var IconBrandVscode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVscode
});

var IconBrandVue = createReactComponent("outline", "brand-vue", "IconBrandVue", [["path", { "d": "M16.5 4l-4.5 8l-4.5 -8", "key": "svg-0" }], ["path", { "d": "M3 4l9 16l9 -16", "key": "svg-1" }]]);

var IconBrandVue$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandVue
});

var IconBrandWalmart = createReactComponent("outline", "brand-walmart", "IconBrandWalmart", [["path", { "d": "M12 8.04v-5.04", "key": "svg-0" }], ["path", { "d": "M15.5 10l4.5 -2.5", "key": "svg-1" }], ["path", { "d": "M15.5 14l4.5 2.5", "key": "svg-2" }], ["path", { "d": "M12 15.96v5.04", "key": "svg-3" }], ["path", { "d": "M8.5 14l-4.5 2.5", "key": "svg-4" }], ["path", { "d": "M8.5 10l-4.5 -2.505", "key": "svg-5" }]]);

var IconBrandWalmart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWalmart
});

var IconBrandWaze = createReactComponent("outline", "brand-waze", "IconBrandWaze", [["path", { "d": "M6.66 17.52a7 7 0 0 1 -3.66 -4.52c2 0 3 -1 3 -2.51c0 -3.92 2.25 -7.49 7.38 -7.49c4.62 0 7.62 3.51 7.62 8a8.08 8.08 0 0 1 -3.39 6.62", "key": "svg-0" }], ["path", { "d": "M10 18.69a17.29 17.29 0 0 0 3.33 .3h.54", "key": "svg-1" }], ["path", { "d": "M16 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M8 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M16 9h.01", "key": "svg-4" }], ["path", { "d": "M11 9h.01", "key": "svg-5" }]]);

var IconBrandWaze$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWaze
});

var IconBrandWebflow = createReactComponent("outline", "brand-webflow", "IconBrandWebflow", [["path", { "d": "M17 10s-1.376 3.606 -1.5 4c-.046 -.4 -1.5 -8 -1.5 -8c-2.627 0 -3.766 1.562 -4.5 3.5c0 0 -1.843 4.593 -2 5c-.013 -.368 -.5 -4.5 -.5 -4.5c-.15 -2.371 -2.211 -3.98 -4 -3.98l2 12.98c2.745 -.013 4.72 -1.562 5.5 -3.5c0 0 1.44 -4.3 1.5 -4.5c.013 .18 1 8 1 8c2.758 0 4.694 -1.626 5.5 -3.5l3.5 -9.5c-2.732 0 -4.253 2.055 -5 4z", "key": "svg-0" }]]);

var IconBrandWebflow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWebflow
});

var IconBrandWechat = createReactComponent("outline", "brand-wechat", "IconBrandWechat", [["path", { "d": "M16.5 10c3.038 0 5.5 2.015 5.5 4.5c0 1.397 -.778 2.645 -2 3.47l0 2.03l-1.964 -1.178a6.649 6.649 0 0 1 -1.536 .178c-3.038 0 -5.5 -2.015 -5.5 -4.5s2.462 -4.5 5.5 -4.5z", "key": "svg-0" }], ["path", { "d": "M11.197 15.698c-.69 .196 -1.43 .302 -2.197 .302a8.008 8.008 0 0 1 -2.612 -.432l-2.388 1.432v-2.801c-1.237 -1.082 -2 -2.564 -2 -4.199c0 -3.314 3.134 -6 7 -6c3.782 0 6.863 2.57 7 5.785l0 .233", "key": "svg-1" }], ["path", { "d": "M10 8h.01", "key": "svg-2" }], ["path", { "d": "M7 8h.01", "key": "svg-3" }], ["path", { "d": "M15 14h.01", "key": "svg-4" }], ["path", { "d": "M18 14h.01", "key": "svg-5" }]]);

var IconBrandWechat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWechat
});

var IconBrandWeibo = createReactComponent("outline", "brand-weibo", "IconBrandWeibo", [["path", { "d": "M19 14.127c0 3.073 -3.502 5.873 -8 5.873c-4.126 0 -8 -2.224 -8 -5.565c0 -1.78 .984 -3.737 2.7 -5.567c2.362 -2.51 5.193 -3.687 6.551 -2.238c.415 .44 .752 1.39 .749 2.062c2 -1.615 4.308 .387 3.5 2.693c1.26 .557 2.5 .538 2.5 2.742z", "key": "svg-0" }], ["path", { "d": "M15 4h1a5 5 0 0 1 5 5v1", "key": "svg-1" }]]);

var IconBrandWeibo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWeibo
});

var IconBrandWhatsapp = createReactComponent("outline", "brand-whatsapp", "IconBrandWhatsapp", [["path", { "d": "M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9", "key": "svg-0" }], ["path", { "d": "M9 10a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1", "key": "svg-1" }]]);

var IconBrandWhatsapp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWhatsapp
});

var IconBrandWikipedia = createReactComponent("outline", "brand-wikipedia", "IconBrandWikipedia", [["path", { "d": "M3 4.984h2", "key": "svg-0" }], ["path", { "d": "M8 4.984h2.5", "key": "svg-1" }], ["path", { "d": "M14.5 4.984h2.5", "key": "svg-2" }], ["path", { "d": "M22 4.984h-2", "key": "svg-3" }], ["path", { "d": "M4 4.984l5.455 14.516l6.545 -14.516", "key": "svg-4" }], ["path", { "d": "M9 4.984l6 14.516l6 -14.516", "key": "svg-5" }]]);

var IconBrandWikipedia$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWikipedia
});

var IconBrandWindows = createReactComponent("outline", "brand-windows", "IconBrandWindows", [["path", { "d": "M17.8 20l-12 -1.5c-1 -.1 -1.8 -.9 -1.8 -1.9v-9.2c0 -1 .8 -1.8 1.8 -1.9l12 -1.5c1.2 -.1 2.2 .8 2.2 1.9v12.1c0 1.2 -1.1 2.1 -2.2 1.9z", "key": "svg-0" }], ["path", { "d": "M12 5l0 14", "key": "svg-1" }], ["path", { "d": "M4 12l16 0", "key": "svg-2" }]]);

var IconBrandWindows$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWindows
});

var IconBrandWindy = createReactComponent("outline", "brand-windy", "IconBrandWindy", [["path", { "d": "M9 4c0 5.5 -.33 16 4 16s7.546 -11.27 8 -13", "key": "svg-0" }], ["path", { "d": "M3 4c.253 5.44 1.449 16 5.894 16c4.444 0 8.42 -10.036 9.106 -14", "key": "svg-1" }]]);

var IconBrandWindy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWindy
});

var IconBrandWish = createReactComponent("outline", "brand-wish", "IconBrandWish", [["path", { "d": "M2 6l5.981 2.392l-.639 6.037c-.18 .893 .06 1.819 .65 2.514a3 3 0 0 0 2.381 1.057a4.328 4.328 0 0 0 4.132 -3.57c-.18 .893 .06 1.819 .65 2.514a3 3 0 0 0 2.38 1.056a4.328 4.328 0 0 0 4.132 -3.57l.333 -4.633", "key": "svg-0" }], ["path", { "d": "M14.504 14.429l.334 -3", "key": "svg-1" }]]);

var IconBrandWish$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWish
});

var IconBrandWix = createReactComponent("outline", "brand-wix", "IconBrandWix", [["path", { "d": "M3 9l1.5 6l1.379 -5.515a.64 .64 0 0 1 1.242 0l1.379 5.515l1.5 -6", "key": "svg-0" }], ["path", { "d": "M13 11.5v3.5", "key": "svg-1" }], ["path", { "d": "M16 9l5 6", "key": "svg-2" }], ["path", { "d": "M21 9l-5 6", "key": "svg-3" }], ["path", { "d": "M13 9h.01", "key": "svg-4" }]]);

var IconBrandWix$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWix
});

var IconBrandWordpress = createReactComponent("outline", "brand-wordpress", "IconBrandWordpress", [["path", { "d": "M9.5 9h3", "key": "svg-0" }], ["path", { "d": "M4 9h2.5", "key": "svg-1" }], ["path", { "d": "M11 9l3 11l4 -9", "key": "svg-2" }], ["path", { "d": "M5.5 9l3.5 11l3 -7", "key": "svg-3" }], ["path", { "d": "M18 11c.177 -.528 1 -1.364 1 -2.5c0 -1.78 -.776 -2.5 -1.875 -2.5c-.898 0 -1.125 .812 -1.125 1.429c0 1.83 2 2.058 2 3.571z", "key": "svg-4" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-5" }]]);

var IconBrandWordpress$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandWordpress
});

var IconBrandX = createReactComponent("outline", "brand-x", "IconBrandX", [["path", { "d": "M4 4l11.733 16h4.267l-11.733 -16z", "key": "svg-0" }], ["path", { "d": "M4 20l6.768 -6.768m2.46 -2.46l6.772 -6.772", "key": "svg-1" }]]);

var IconBrandX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandX
});

var IconBrandXamarin = createReactComponent("outline", "brand-xamarin", "IconBrandXamarin", [["path", { "d": "M15.958 21h-7.917a2 2 0 0 1 -1.732 -1l-4.041 -7a2 2 0 0 1 0 -2l4.041 -7a2 2 0 0 1 1.732 -1h7.917a2 2 0 0 1 1.732 1l4.042 7a2 2 0 0 1 0 2l-4.041 7a2 2 0 0 1 -1.733 1z", "key": "svg-0" }], ["path", { "d": "M15 16l-6 -8", "key": "svg-1" }], ["path", { "d": "M9 16l6 -8", "key": "svg-2" }]]);

var IconBrandXamarin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandXamarin
});

var IconBrandXbox = createReactComponent("outline", "brand-xbox", "IconBrandXbox", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M6.5 5c7.72 2.266 10.037 7.597 12.5 12.5", "key": "svg-1" }], ["path", { "d": "M17.5 5c-7.72 2.266 -10.037 7.597 -12.5 12.5", "key": "svg-2" }]]);

var IconBrandXbox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandXbox
});

var IconBrandXdeep = createReactComponent("outline", "brand-xdeep", "IconBrandXdeep", [["path", { "d": "M14.401 8.398l1.599 -2.398h5l-4 6l4 6h-5l-8 -12h-5l4 6l-4 6h5l1.596 -2.393", "key": "svg-0" }]]);

var IconBrandXdeep$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandXdeep
});

var IconBrandXing = createReactComponent("outline", "brand-xing", "IconBrandXing", [["path", { "d": "M16 21l-4 -7l6.5 -11", "key": "svg-0" }], ["path", { "d": "M7 7l2 3.5l-3 4.5", "key": "svg-1" }]]);

var IconBrandXing$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandXing
});

var IconBrandYahoo = createReactComponent("outline", "brand-yahoo", "IconBrandYahoo", [["path", { "d": "M3 6l5 0", "key": "svg-0" }], ["path", { "d": "M7 18l7 0", "key": "svg-1" }], ["path", { "d": "M4.5 6l5.5 7v5", "key": "svg-2" }], ["path", { "d": "M10 13l6 -5", "key": "svg-3" }], ["path", { "d": "M12.5 8l5 0", "key": "svg-4" }], ["path", { "d": "M20 11l0 4", "key": "svg-5" }], ["path", { "d": "M20 18l0 .01", "key": "svg-6" }]]);

var IconBrandYahoo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYahoo
});

var IconBrandYandex = createReactComponent("outline", "brand-yandex", "IconBrandYandex", [["path", { "d": "M15 20v-16h-2a4 4 0 0 0 -4 4v1a4 4 0 0 0 4 4h2", "key": "svg-0" }], ["path", { "d": "M9 20l3 -7", "key": "svg-1" }]]);

var IconBrandYandex$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYandex
});

var IconBrandYarn = createReactComponent("outline", "brand-yarn", "IconBrandYarn", [["path", { "d": "M17.845 19.308c-1.268 .814 -2.41 1.254 -3.845 1.692c-.176 .21 -.645 .544 -.912 .588a42.469 42.469 0 0 1 -4.498 .412c-.812 .006 -1.31 -.214 -1.447 -.554c-.115 -.279 .336 -2.054 .298 -1.964c-.157 .392 -.575 1.287 -.997 1.72c-.579 .6 -1.674 .4 -2.322 .051c-.71 -.386 -.07 -1.28 -.346 -1.267c-.276 .014 -.776 -1.486 -.776 -2.236c0 -.828 .622 -1.674 1.235 -2.211a6.811 6.811 0 0 1 .46 -3.143a7.414 7.414 0 0 1 2.208 -2.615s-1.353 -1.534 -.849 -2.912c.328 -.902 .46 -.895 .567 -.935c.38 -.12 .727 -.33 1.013 -.612c.78 -.88 1.96 -1.438 3.116 -1.322c0 0 .781 -2.43 1.533 -1.936c.415 .653 .671 1.218 .967 1.936c0 0 1.15 -.7 1.25 -.5c.514 1.398 .487 3.204 .211 4.67c-.324 1.408 -.84 2.691 -1.711 3.83c-.094 .16 .98 .705 1.722 2.812c.686 1.928 .278 2.438 .278 2.688s.716 .144 2.296 -.855a5.848 5.848 0 0 1 2.984 -1.145c.735 -.066 .988 -.035 1.22 1c.232 1.035 -.346 1.406 -.744 1.506c0 0 -2.09 .675 -2.911 1.302z", "key": "svg-0" }]]);

var IconBrandYarn$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYarn
});

var IconBrandYatse = createReactComponent("outline", "brand-yatse", "IconBrandYatse", [["path", { "d": "M7 3l5 2.876v5.088l4.197 -2.73l4.803 2.731l-9.281 5.478l-2.383 1.41l-2.334 1.377l-3 1.77v-5.565l3 -1.771z", "key": "svg-0" }]]);

var IconBrandYatse$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYatse
});

var IconBrandYcombinator = createReactComponent("outline", "brand-ycombinator", "IconBrandYcombinator", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7l4 6l4 -6", "key": "svg-1" }], ["path", { "d": "M12 17l0 -4", "key": "svg-2" }]]);

var IconBrandYcombinator$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYcombinator
});

var IconBrandYoutubeKids = createReactComponent("outline", "brand-youtube-kids", "IconBrandYoutubeKids", [["path", { "d": "M18.608 17.75l-3.9 .268h-.027a13.83 13.83 0 0 0 -3.722 .828l-2.511 .908a4.111 4.111 0 0 1 -3.287 -.216a3.82 3.82 0 0 1 -1.98 -2.527l-1.376 -6.05a3.669 3.669 0 0 1 .536 -2.86a3.964 3.964 0 0 1 2.489 -1.661l11.25 -2.354c2.137 -.448 4.247 .85 4.713 2.9l1.403 6.162a3.677 3.677 0 0 1 -.697 3.086a4.007 4.007 0 0 1 -2.89 1.512v.002z", "key": "svg-0" }], ["path", { "d": "M9 10l1.208 5l4.292 -4z", "key": "svg-1" }]]);

var IconBrandYoutubeKids$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYoutubeKids
});

var IconBrandYoutube = createReactComponent("outline", "brand-youtube", "IconBrandYoutube", [["path", { "d": "M2 8a4 4 0 0 1 4 -4h12a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-12a4 4 0 0 1 -4 -4v-8z", "key": "svg-0" }], ["path", { "d": "M10 9l5 3l-5 3z", "key": "svg-1" }]]);

var IconBrandYoutube$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandYoutube
});

var IconBrandZalando = createReactComponent("outline", "brand-zalando", "IconBrandZalando", [["path", { "d": "M7.531 21c-.65 0 -1 -.15 -1.196 -.27c-.266 -.157 -.753 -.563 -1.197 -1.747a20.583 20.583 0 0 1 -1.137 -6.983c.015 -2.745 .436 -5.07 1.137 -6.975c.444 -1.2 .93 -1.605 1.197 -1.763c.192 -.103 .545 -.262 1.195 -.262c.244 0 .532 .022 .871 .075a19.093 19.093 0 0 1 6.425 2.475h.007a19.572 19.572 0 0 1 5.287 4.508c.783 .99 .879 1.627 .879 1.942c0 .315 -.096 .953 -.879 1.943a19.571 19.571 0 0 1 -5.287 4.5h-.007a19.041 19.041 0 0 1 -6.425 2.474a5.01 5.01 0 0 1 -.871 .083z", "key": "svg-0" }]]);

var IconBrandZalando$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZalando
});

var IconBrandZapier = createReactComponent("outline", "brand-zapier", "IconBrandZapier", [["path", { "d": "M3 12h6", "key": "svg-0" }], ["path", { "d": "M21 12h-6", "key": "svg-1" }], ["path", { "d": "M12 3v6", "key": "svg-2" }], ["path", { "d": "M12 15v6", "key": "svg-3" }], ["path", { "d": "M5.636 5.636l4.243 4.243", "key": "svg-4" }], ["path", { "d": "M18.364 18.364l-4.243 -4.243", "key": "svg-5" }], ["path", { "d": "M18.364 5.636l-4.243 4.243", "key": "svg-6" }], ["path", { "d": "M9.879 14.121l-4.243 4.243", "key": "svg-7" }]]);

var IconBrandZapier$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZapier
});

var IconBrandZeit = createReactComponent("outline", "brand-zeit", "IconBrandZeit", [["path", { "d": "M3 20h18l-9 -16z", "key": "svg-0" }]]);

var IconBrandZeit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZeit
});

var IconBrandZhihu = createReactComponent("outline", "brand-zhihu", "IconBrandZhihu", [["path", { "d": "M14 6h6v12h-2l-2 2l-1 -2h-1z", "key": "svg-0" }], ["path", { "d": "M4 12h6.5", "key": "svg-1" }], ["path", { "d": "M10.5 6h-5", "key": "svg-2" }], ["path", { "d": "M6 4c-.5 2.5 -1.5 3.5 -2.5 4.5", "key": "svg-3" }], ["path", { "d": "M8 6v7c0 4.5 -2 5.5 -4 7", "key": "svg-4" }], ["path", { "d": "M11 18l-3 -5", "key": "svg-5" }]]);

var IconBrandZhihu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZhihu
});

var IconBrandZoom = createReactComponent("outline", "brand-zoom", "IconBrandZoom", [["path", { "d": "M17.011 9.385v5.128l3.989 3.487v-12z", "key": "svg-0" }], ["path", { "d": "M3.887 6h10.08c1.468 0 3.033 1.203 3.033 2.803v8.196a.991 .991 0 0 1 -.975 1h-10.373c-1.667 0 -2.652 -1.5 -2.652 -3l.01 -8a.882 .882 0 0 1 .208 -.71a.841 .841 0 0 1 .67 -.287z", "key": "svg-1" }]]);

var IconBrandZoom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZoom
});

var IconBrandZulip = createReactComponent("outline", "brand-zulip", "IconBrandZulip", [["path", { "d": "M6.5 3h11c1.325 0 2.5 1 2.5 2.5c0 2 -1.705 3.264 -2 3.5l-4.5 4l2 -5h-9a2.5 2.5 0 0 1 0 -5z", "key": "svg-0" }], ["path", { "d": "M17.5 21h-11c-1.325 0 -2.5 -1 -2.5 -2.5c0 -2 1.705 -3.264 2 -3.5l4.5 -4l-2 5h9a2.5 2.5 0 1 1 0 5z", "key": "svg-1" }]]);

var IconBrandZulip$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZulip
});

var IconBrandZwift = createReactComponent("outline", "brand-zwift", "IconBrandZwift", [["path", { "d": "M5.5 4c-1.465 0 -2.5 1.101 -2.5 2.5s1.035 2.5 2.5 2.5h2.5l-4.637 7.19a2.434 2.434 0 0 0 -.011 2.538c.473 .787 1.35 1.272 2.3 1.272h10.848c1.465 0 2.5 -1.101 2.5 -2.5s-1.035 -2.5 -2.5 -2.5h-2.5l7 -11h-15.5z", "key": "svg-0" }]]);

var IconBrandZwift$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrandZwift
});

var IconBreadOff = createReactComponent("outline", "bread-off", "IconBreadOff", [["path", { "d": "M8 4l10 .005v-.005a3 3 0 0 1 2 5.235v6.765m-.59 3.418c-.36 .36 -.86 .582 -1.41 .582h-12a2 2 0 0 1 -2 -2v-8.764a3 3 0 0 1 .418 -4.785", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconBreadOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBreadOff
});

var IconBread = createReactComponent("outline", "bread", "IconBread", [["path", { "d": "M18 4a3 3 0 0 1 2 5.235v8.765a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-8.764a3 3 0 0 1 1.824 -5.231h12.176v-.005z", "key": "svg-0" }]]);

var IconBread$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBread
});

var IconBriefcase2 = createReactComponent("outline", "briefcase-2", "IconBriefcase2", [["path", { "d": "M3 9a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9z", "key": "svg-0" }], ["path", { "d": "M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2", "key": "svg-1" }]]);

var IconBriefcase2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBriefcase2
});

var IconBriefcaseOff = createReactComponent("outline", "briefcase-off", "IconBriefcaseOff", [["path", { "d": "M11 7h8a2 2 0 0 1 2 2v8m-1.166 2.818a1.993 1.993 0 0 1 -.834 .182h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M8.185 4.158a2 2 0 0 1 1.815 -1.158h4a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M12 12v.01", "key": "svg-2" }], ["path", { "d": "M3 13a20 20 0 0 0 11.905 1.928m3.263 -.763a20 20 0 0 0 2.832 -1.165", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconBriefcaseOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBriefcaseOff
});

var IconBriefcase = createReactComponent("outline", "briefcase", "IconBriefcase", [["path", { "d": "M3 7m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M12 12l0 .01", "key": "svg-2" }], ["path", { "d": "M3 13a20 20 0 0 0 18 0", "key": "svg-3" }]]);

var IconBriefcase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBriefcase
});

var IconBrightness2 = createReactComponent("outline", "brightness-2", "IconBrightness2", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-1" }]]);

var IconBrightness2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightness2
});

var IconBrightnessAuto = createReactComponent("outline", "brightness-auto", "IconBrightnessAuto", [["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-0" }], ["path", { "d": "M10 14.5v-3.5a2 2 0 1 1 4 0v3.5", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconBrightnessAuto$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightnessAuto
});

var IconBrightnessDown = createReactComponent("outline", "brightness-down", "IconBrightnessDown", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 5l0 .01", "key": "svg-1" }], ["path", { "d": "M17 7l0 .01", "key": "svg-2" }], ["path", { "d": "M19 12l0 .01", "key": "svg-3" }], ["path", { "d": "M17 17l0 .01", "key": "svg-4" }], ["path", { "d": "M12 19l0 .01", "key": "svg-5" }], ["path", { "d": "M7 17l0 .01", "key": "svg-6" }], ["path", { "d": "M5 12l0 .01", "key": "svg-7" }], ["path", { "d": "M7 7l0 .01", "key": "svg-8" }]]);

var IconBrightnessDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightnessDown
});

var IconBrightnessHalf = createReactComponent("outline", "brightness-half", "IconBrightnessHalf", [["path", { "d": "M12 9a3 3 0 0 0 0 6v-6z", "key": "svg-0" }], ["path", { "d": "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z", "key": "svg-1" }]]);

var IconBrightnessHalf$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightnessHalf
});

var IconBrightnessOff = createReactComponent("outline", "brightness-off", "IconBrightnessOff", [["path", { "d": "M12 3v5m0 4v9", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M12.5 8.5l4.15 -4.15", "key": "svg-2" }], ["path", { "d": "M12 14l1.025 -.983m2.065 -1.981l4.28 -4.106", "key": "svg-3" }], ["path", { "d": "M12 19.6l3.79 -3.79m2 -2l3.054 -3.054", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconBrightnessOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightnessOff
});

var IconBrightnessUp = createReactComponent("outline", "brightness-up", "IconBrightnessUp", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 5l0 -2", "key": "svg-1" }], ["path", { "d": "M17 7l1.4 -1.4", "key": "svg-2" }], ["path", { "d": "M19 12l2 0", "key": "svg-3" }], ["path", { "d": "M17 17l1.4 1.4", "key": "svg-4" }], ["path", { "d": "M12 19l0 2", "key": "svg-5" }], ["path", { "d": "M7 17l-1.4 1.4", "key": "svg-6" }], ["path", { "d": "M6 12l-2 0", "key": "svg-7" }], ["path", { "d": "M7 7l-1.4 -1.4", "key": "svg-8" }]]);

var IconBrightnessUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightnessUp
});

var IconBrightness = createReactComponent("outline", "brightness", "IconBrightness", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3l0 18", "key": "svg-1" }], ["path", { "d": "M12 9l4.65 -4.65", "key": "svg-2" }], ["path", { "d": "M12 14.3l7.37 -7.37", "key": "svg-3" }], ["path", { "d": "M12 19.6l8.85 -8.85", "key": "svg-4" }]]);

var IconBrightness$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrightness
});

var IconBroadcastOff = createReactComponent("outline", "broadcast-off", "IconBroadcastOff", [["path", { "d": "M18.364 19.364a9 9 0 0 0 -9.721 -14.717m-2.488 1.509a9 9 0 0 0 -.519 13.208", "key": "svg-0" }], ["path", { "d": "M15.536 16.536a5 5 0 0 0 -3.536 -8.536m-3 1a5 5 0 0 0 -.535 7.536", "key": "svg-1" }], ["path", { "d": "M12 12a1 1 0 1 0 1 1", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBroadcastOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBroadcastOff
});

var IconBroadcast = createReactComponent("outline", "broadcast", "IconBroadcast", [["path", { "d": "M18.364 19.364a9 9 0 1 0 -12.728 0", "key": "svg-0" }], ["path", { "d": "M15.536 16.536a5 5 0 1 0 -7.072 0", "key": "svg-1" }], ["path", { "d": "M12 13m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconBroadcast$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBroadcast
});

var IconBrowserCheck = createReactComponent("outline", "browser-check", "IconBrowserCheck", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 8h16", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M9.5 14.5l1.5 1.5l3 -3", "key": "svg-3" }]]);

var IconBrowserCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserCheck
});

var IconBrowserMaximize = createReactComponent("outline", "browser-maximize", "IconBrowserMaximize", [["path", { "d": "M4 8h8", "key": "svg-0" }], ["path", { "d": "M20 11.5v6.5a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6.5", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 8l5 -5", "key": "svg-3" }], ["path", { "d": "M21 7.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconBrowserMaximize$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserMaximize
});

var IconBrowserMinus = createReactComponent("outline", "browser-minus", "IconBrowserMinus", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v9", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconBrowserMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserMinus
});

var IconBrowserOff = createReactComponent("outline", "browser-off", "IconBrowserOff", [["path", { "d": "M8 4h11a1 1 0 0 1 1 1v11m-.288 3.702a1 1 0 0 1 -.712 .298h-14a1 1 0 0 1 -1 -1v-14c0 -.276 .112 -.526 .293 -.707", "key": "svg-0" }], ["path", { "d": "M4 8h4m4 0h8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBrowserOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserOff
});

var IconBrowserPlus = createReactComponent("outline", "browser-plus", "IconBrowserPlus", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconBrowserPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserPlus
});

var IconBrowserShare = createReactComponent("outline", "browser-share", "IconBrowserShare", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M12.5 20h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconBrowserShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserShare
});

var IconBrowserX = createReactComponent("outline", "browser-x", "IconBrowserX", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M4 8h16", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }], ["path", { "d": "M10 16l4 -4", "key": "svg-3" }], ["path", { "d": "M14 16l-4 -4", "key": "svg-4" }]]);

var IconBrowserX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowserX
});

var IconBrowser = createReactComponent("outline", "browser", "IconBrowser", [["path", { "d": "M4 8h16", "key": "svg-0" }], ["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M8 4v4", "key": "svg-2" }]]);

var IconBrowser$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrowser
});

var IconBrushOff = createReactComponent("outline", "brush-off", "IconBrushOff", [["path", { "d": "M3 17a4 4 0 1 1 4 4h-4v-4z", "key": "svg-0" }], ["path", { "d": "M21 3a16 16 0 0 0 -9.309 4.704m-1.795 2.212a15.993 15.993 0 0 0 -1.696 3.284", "key": "svg-1" }], ["path", { "d": "M21 3a16 16 0 0 1 -4.697 9.302m-2.195 1.786a15.993 15.993 0 0 1 -3.308 1.712", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBrushOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrushOff
});

var IconBrush = createReactComponent("outline", "brush", "IconBrush", [["path", { "d": "M3 21v-4a4 4 0 1 1 4 4h-4", "key": "svg-0" }], ["path", { "d": "M21 3a16 16 0 0 0 -12.8 10.2", "key": "svg-1" }], ["path", { "d": "M21 3a16 16 0 0 1 -10.2 12.8", "key": "svg-2" }], ["path", { "d": "M10.6 9a9 9 0 0 1 4.4 4.4", "key": "svg-3" }]]);

var IconBrush$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBrush
});

var IconBubbleMinus = createReactComponent("outline", "bubble-minus", "IconBubbleMinus", [["path", { "d": "M12.4 19a4.2 4.2 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 3.404 8.771", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconBubbleMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubbleMinus
});

var IconBubblePlus = createReactComponent("outline", "bubble-plus", "IconBubblePlus", [["path", { "d": "M12.4 19a4.2 4.2 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 4.45 6.89", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconBubblePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubblePlus
});

var IconBubbleTea2 = createReactComponent("outline", "bubble-tea-2", "IconBubbleTea2", [["path", { "d": "M17.95 9l-1.478 8.69c-.25 1.463 -.374 2.195 -.936 2.631c-1.2 .931 -6.039 .88 -7.172 0c-.562 -.436 -.687 -1.168 -.936 -2.632l-1.478 -8.689", "key": "svg-0" }], ["path", { "d": "M6 9l.514 -1.286a5.908 5.908 0 0 1 10.972 0l.514 1.286", "key": "svg-1" }], ["path", { "d": "M5 9h14", "key": "svg-2" }], ["path", { "d": "M12 9l4 -7", "key": "svg-3" }], ["path", { "d": "M7 14c.593 .642 1.484 1.017 2.5 1c1.016 .017 1.907 -.358 2.5 -1s1.484 -1.017 2.5 -1c1.016 -.017 1.907 .358 2.5 1", "key": "svg-4" }]]);

var IconBubbleTea2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubbleTea2
});

var IconBubbleTea = createReactComponent("outline", "bubble-tea", "IconBubbleTea", [["path", { "d": "M17.95 9l-1.478 8.69c-.25 1.463 -.374 2.195 -.936 2.631c-1.2 .931 -6.039 .88 -7.172 0c-.562 -.436 -.687 -1.168 -.936 -2.632l-1.478 -8.689", "key": "svg-0" }], ["path", { "d": "M6 9l.514 -1.286a5.908 5.908 0 0 1 10.972 0l.514 1.286", "key": "svg-1" }], ["path", { "d": "M5 9h14", "key": "svg-2" }], ["path", { "d": "M12 9l4 -7", "key": "svg-3" }], ["path", { "d": "M10.01 14h.01", "key": "svg-4" }], ["path", { "d": "M11.02 18h.01", "key": "svg-5" }], ["path", { "d": "M13.02 16h.01", "key": "svg-6" }]]);

var IconBubbleTea$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubbleTea
});

var IconBubbleText = createReactComponent("outline", "bubble-text", "IconBubbleText", [["path", { "d": "M7 10h10", "key": "svg-0" }], ["path", { "d": "M9 14h5", "key": "svg-1" }], ["path", { "d": "M12.4 3a5.34 5.34 0 0 1 4.906 3.239a5.333 5.333 0 0 1 -1.195 10.6a4.26 4.26 0 0 1 -5.28 1.863l-3.831 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.33 5.33 0 0 1 4.287 -2.16", "key": "svg-2" }]]);

var IconBubbleText$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubbleText
});

var IconBubbleX = createReactComponent("outline", "bubble-x", "IconBubbleX", [["path", { "d": "M13.5 18.75c-.345 .09 -.727 .25 -1.1 .25a4.3 4.3 0 0 1 -1.57 -.298l-3.83 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.335 5.335 0 0 1 9.194 1.078a5.333 5.333 0 0 1 4.484 6.778", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconBubbleX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubbleX
});

var IconBubble = createReactComponent("outline", "bubble", "IconBubble", [["path", { "d": "M12.4 3a5.34 5.34 0 0 1 4.906 3.239a5.333 5.333 0 0 1 -1.195 10.6a4.26 4.26 0 0 1 -5.28 1.863l-3.831 2.298v-3.134a2.668 2.668 0 0 1 -1.795 -3.773a4.8 4.8 0 0 1 2.908 -8.933a5.33 5.33 0 0 1 4.287 -2.16", "key": "svg-0" }]]);

var IconBubble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBubble
});

var IconBucketDroplet = createReactComponent("outline", "bucket-droplet", "IconBucketDroplet", [["path", { "d": "M5 16l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z", "key": "svg-0" }], ["path", { "d": "M13.737 9.737c2.299 -2.3 3.23 -5.095 2.081 -6.245c-1.15 -1.15 -3.945 -.217 -6.244 2.082c-2.3 2.299 -3.231 5.095 -2.082 6.244c1.15 1.15 3.946 .218 6.245 -2.081z", "key": "svg-1" }], ["path", { "d": "M7.492 11.818c.362 .362 .768 .676 1.208 .934l6.895 4.047c1.078 .557 2.255 -.075 3.692 -1.512c1.437 -1.437 2.07 -2.614 1.512 -3.692c-.372 -.718 -1.72 -3.017 -4.047 -6.895a6.015 6.015 0 0 0 -.934 -1.208", "key": "svg-2" }]]);

var IconBucketDroplet$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBucketDroplet
});

var IconBucketOff = createReactComponent("outline", "bucket-off", "IconBucketOff", [["path", { "d": "M5.029 5.036c-.655 .58 -1.029 1.25 -1.029 1.964c0 2.033 3.033 3.712 6.96 3.967m3.788 -.21c3.064 -.559 5.252 -2.029 5.252 -3.757c0 -2.21 -3.582 -4 -8 -4c-1.605 0 -3.1 .236 -4.352 .643", "key": "svg-0" }], ["path", { "d": "M4 7c0 .664 .088 1.324 .263 1.965l2.737 10.035c.5 1.5 2.239 2 5 2s4.5 -.5 5 -2c.1 -.3 .252 -.812 .457 -1.535m.862 -3.146c.262 -.975 .735 -2.76 1.418 -5.354a7.45 7.45 0 0 0 .263 -1.965", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconBucketOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBucketOff
});

var IconBucket = createReactComponent("outline", "bucket", "IconBucket", [["path", { "d": "M12 7m-8 0a8 4 0 1 0 16 0a8 4 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 7c0 .664 .088 1.324 .263 1.965l2.737 10.035c.5 1.5 2.239 2 5 2s4.5 -.5 5 -2c.333 -1 1.246 -4.345 2.737 -10.035a7.45 7.45 0 0 0 .263 -1.965", "key": "svg-1" }]]);

var IconBucket$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBucket
});

var IconBugOff = createReactComponent("outline", "bug-off", "IconBugOff", [["path", { "d": "M9.884 5.873a3 3 0 0 1 5.116 2.127v1", "key": "svg-0" }], ["path", { "d": "M13 9h3a6 6 0 0 1 1 3v1m-.298 3.705a5 5 0 0 1 -9.702 -1.705v-3a6 6 0 0 1 1 -3h1", "key": "svg-1" }], ["path", { "d": "M3 13h4", "key": "svg-2" }], ["path", { "d": "M17 13h4", "key": "svg-3" }], ["path", { "d": "M12 20v-6", "key": "svg-4" }], ["path", { "d": "M4 19l3.35 -2", "key": "svg-5" }], ["path", { "d": "M4 7l3.75 2.4", "key": "svg-6" }], ["path", { "d": "M20 7l-3.75 2.4", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBugOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBugOff
});

var IconBug = createReactComponent("outline", "bug", "IconBug", [["path", { "d": "M9 9v-1a3 3 0 0 1 6 0v1", "key": "svg-0" }], ["path", { "d": "M8 9h8a6 6 0 0 1 1 3v3a5 5 0 0 1 -10 0v-3a6 6 0 0 1 1 -3", "key": "svg-1" }], ["path", { "d": "M3 13l4 0", "key": "svg-2" }], ["path", { "d": "M17 13l4 0", "key": "svg-3" }], ["path", { "d": "M12 20l0 -6", "key": "svg-4" }], ["path", { "d": "M4 19l3.35 -2", "key": "svg-5" }], ["path", { "d": "M20 19l-3.35 -2", "key": "svg-6" }], ["path", { "d": "M4 7l3.75 2.4", "key": "svg-7" }], ["path", { "d": "M20 7l-3.75 2.4", "key": "svg-8" }]]);

var IconBug$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBug
});

var IconBuildingAirport = createReactComponent("outline", "building-airport", "IconBuildingAirport", [["path", { "d": "M3.59 7h8.82a1 1 0 0 1 .902 1.433l-1.44 3a1 1 0 0 1 -.901 .567h-5.942a1 1 0 0 1 -.901 -.567l-1.44 -3a1 1 0 0 1 .901 -1.433", "key": "svg-0" }], ["path", { "d": "M6 7l-.78 -2.342a.5 .5 0 0 1 .473 -.658h4.612a.5 .5 0 0 1 .475 .658l-.78 2.342", "key": "svg-1" }], ["path", { "d": "M8 2v2", "key": "svg-2" }], ["path", { "d": "M6 12v9h4v-9", "key": "svg-3" }], ["path", { "d": "M3 21h18", "key": "svg-4" }], ["path", { "d": "M22 5h-6l-1 -1", "key": "svg-5" }], ["path", { "d": "M18 3l2 2l-2 2", "key": "svg-6" }], ["path", { "d": "M10 17h7a2 2 0 0 1 2 2v2", "key": "svg-7" }]]);

var IconBuildingAirport$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingAirport
});

var IconBuildingArch = createReactComponent("outline", "building-arch", "IconBuildingArch", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M4 21v-15a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v15", "key": "svg-1" }], ["path", { "d": "M9 21v-8a3 3 0 0 1 6 0v8", "key": "svg-2" }]]);

var IconBuildingArch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingArch
});

var IconBuildingBank = createReactComponent("outline", "building-bank", "IconBuildingBank", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M3 10l18 0", "key": "svg-1" }], ["path", { "d": "M5 6l7 -3l7 3", "key": "svg-2" }], ["path", { "d": "M4 10l0 11", "key": "svg-3" }], ["path", { "d": "M20 10l0 11", "key": "svg-4" }], ["path", { "d": "M8 14l0 3", "key": "svg-5" }], ["path", { "d": "M12 14l0 3", "key": "svg-6" }], ["path", { "d": "M16 14l0 3", "key": "svg-7" }]]);

var IconBuildingBank$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingBank
});

var IconBuildingBridge2 = createReactComponent("outline", "building-bridge-2", "IconBuildingBridge2", [["path", { "d": "M6 7h12a2 2 0 0 1 2 2v9a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a4 4 0 0 0 -8 0v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-9a2 2 0 0 1 2 -2", "key": "svg-0" }]]);

var IconBuildingBridge2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingBridge2
});

var IconBuildingBridge = createReactComponent("outline", "building-bridge", "IconBuildingBridge", [["path", { "d": "M6 5l0 14", "key": "svg-0" }], ["path", { "d": "M18 5l0 14", "key": "svg-1" }], ["path", { "d": "M2 15l20 0", "key": "svg-2" }], ["path", { "d": "M3 8a7.5 7.5 0 0 0 3 -2a6.5 6.5 0 0 0 12 0a7.5 7.5 0 0 0 3 2", "key": "svg-3" }], ["path", { "d": "M12 10l0 5", "key": "svg-4" }]]);

var IconBuildingBridge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingBridge
});

var IconBuildingBroadcastTower = createReactComponent("outline", "building-broadcast-tower", "IconBuildingBroadcastTower", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M16.616 13.924a5 5 0 1 0 -9.23 0", "key": "svg-1" }], ["path", { "d": "M20.307 15.469a9 9 0 1 0 -16.615 0", "key": "svg-2" }], ["path", { "d": "M9 21l3 -9l3 9", "key": "svg-3" }], ["path", { "d": "M10 19h4", "key": "svg-4" }]]);

var IconBuildingBroadcastTower$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingBroadcastTower
});

var IconBuildingBurjAlArab = createReactComponent("outline", "building-burj-al-arab", "IconBuildingBurjAlArab", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M7 21v-18", "key": "svg-1" }], ["path", { "d": "M7 4c5.675 .908 10 5.613 10 11.28a11 11 0 0 1 -1.605 5.72", "key": "svg-2" }], ["path", { "d": "M5 9h12", "key": "svg-3" }], ["path", { "d": "M7 13h4", "key": "svg-4" }], ["path", { "d": "M7 17h4", "key": "svg-5" }]]);

var IconBuildingBurjAlArab$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingBurjAlArab
});

var IconBuildingCarousel = createReactComponent("outline", "building-carousel", "IconBuildingCarousel", [["path", { "d": "M12 12m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M5 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M12 4m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M5 16m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19 16m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }], ["path", { "d": "M8 22l4 -10l4 10", "key": "svg-6" }]]);

var IconBuildingCarousel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCarousel
});

var IconBuildingCastle = createReactComponent("outline", "building-castle", "IconBuildingCastle", [["path", { "d": "M15 19v-2a3 3 0 0 0 -6 0v2a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14h4v3h3v-3h4v3h3v-3h4v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M3 11l18 0", "key": "svg-1" }]]);

var IconBuildingCastle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCastle
});

var IconBuildingChurch = createReactComponent("outline", "building-church", "IconBuildingChurch", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M10 21v-4a2 2 0 0 1 4 0v4", "key": "svg-1" }], ["path", { "d": "M10 5l4 0", "key": "svg-2" }], ["path", { "d": "M12 3l0 5", "key": "svg-3" }], ["path", { "d": "M6 21v-7m-2 2l8 -8l8 8m-2 -2v7", "key": "svg-4" }]]);

var IconBuildingChurch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingChurch
});

var IconBuildingCircus = createReactComponent("outline", "building-circus", "IconBuildingCircus", [["path", { "d": "M4 11h16", "key": "svg-0" }], ["path", { "d": "M12 6.5c0 1 -5 4.5 -8 4.5", "key": "svg-1" }], ["path", { "d": "M12 6.5c0 1 5 4.5 8 4.5", "key": "svg-2" }], ["path", { "d": "M6 11c-.333 5.333 -1 8.667 -2 10h4c1 0 4 -4 4 -9v-1", "key": "svg-3" }], ["path", { "d": "M18 11c.333 5.333 1 8.667 2 10h-4c-1 0 -4 -4 -4 -9v-1", "key": "svg-4" }], ["path", { "d": "M12 7v-4l2 1h-2", "key": "svg-5" }]]);

var IconBuildingCircus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCircus
});

var IconBuildingCog = createReactComponent("outline", "building-cog", "IconBuildingCog", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 18c0 .53 .211 1.039 .586 1.414c.375 .375 .884 .586 1.414 .586c.53 0 1.039 -.211 1.414 -.586c.375 -.375 .586 -.884 .586 -1.414c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586c-.53 0 -1.039 .211 -1.414 .586c-.375 .375 -.586 .884 -.586 1.414z", "key": "svg-7" }], ["path", { "d": "M18 14.5v1.5", "key": "svg-8" }], ["path", { "d": "M18 20v1.5", "key": "svg-9" }], ["path", { "d": "M21.032 16.25l-1.299 .75", "key": "svg-10" }], ["path", { "d": "M16.27 19l-1.3 .75", "key": "svg-11" }], ["path", { "d": "M14.97 16.25l1.3 .75", "key": "svg-12" }], ["path", { "d": "M19.733 19l1.3 .75", "key": "svg-13" }]]);

var IconBuildingCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCog
});

var IconBuildingCommunity = createReactComponent("outline", "building-community", "IconBuildingCommunity", [["path", { "d": "M8 9l5 5v7h-5v-4m0 4h-5v-7l5 -5m1 1v-6a1 1 0 0 1 1 -1h10a1 1 0 0 1 1 1v17h-8", "key": "svg-0" }], ["path", { "d": "M13 7l0 .01", "key": "svg-1" }], ["path", { "d": "M17 7l0 .01", "key": "svg-2" }], ["path", { "d": "M17 11l0 .01", "key": "svg-3" }], ["path", { "d": "M17 15l0 .01", "key": "svg-4" }]]);

var IconBuildingCommunity$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCommunity
});

var IconBuildingCottage = createReactComponent("outline", "building-cottage", "IconBuildingCottage", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M4 21v-11l2.5 -4.5l5.5 -2.5l5.5 2.5l2.5 4.5v11", "key": "svg-1" }], ["path", { "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M9 21v-5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v5", "key": "svg-3" }]]);

var IconBuildingCottage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingCottage
});

var IconBuildingEstate = createReactComponent("outline", "building-estate", "IconBuildingEstate", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M19 21v-4", "key": "svg-1" }], ["path", { "d": "M19 17a2 2 0 0 0 2 -2v-2a2 2 0 1 0 -4 0v2a2 2 0 0 0 2 2z", "key": "svg-2" }], ["path", { "d": "M14 21v-14a3 3 0 0 0 -3 -3h-4a3 3 0 0 0 -3 3v14", "key": "svg-3" }], ["path", { "d": "M9 17v4", "key": "svg-4" }], ["path", { "d": "M8 13h2", "key": "svg-5" }], ["path", { "d": "M8 9h2", "key": "svg-6" }]]);

var IconBuildingEstate$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingEstate
});

var IconBuildingFactory2 = createReactComponent("outline", "building-factory-2", "IconBuildingFactory2", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M5 21v-12l5 4v-4l5 4h4", "key": "svg-1" }], ["path", { "d": "M19 21v-8l-1.436 -9.574a.5 .5 0 0 0 -.495 -.426h-1.145a.5 .5 0 0 0 -.494 .418l-1.43 8.582", "key": "svg-2" }], ["path", { "d": "M9 17h1", "key": "svg-3" }], ["path", { "d": "M14 17h1", "key": "svg-4" }]]);

var IconBuildingFactory2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingFactory2
});

var IconBuildingFactory = createReactComponent("outline", "building-factory", "IconBuildingFactory", [["path", { "d": "M4 21c1.147 -4.02 1.983 -8.027 2 -12h6c.017 3.973 .853 7.98 2 12", "key": "svg-0" }], ["path", { "d": "M12.5 13h4.5c.025 2.612 .894 5.296 2 8", "key": "svg-1" }], ["path", { "d": "M9 5a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1", "key": "svg-2" }], ["path", { "d": "M3 21l19 0", "key": "svg-3" }]]);

var IconBuildingFactory$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingFactory
});

var IconBuildingFortress = createReactComponent("outline", "building-fortress", "IconBuildingFortress", [["path", { "d": "M7 21h1a1 1 0 0 0 1 -1v-1h0a3 3 0 0 1 6 0m3 2h1a1 1 0 0 0 1 -1v-15l-3 -2l-3 2v6h-4v-6l-3 -2l-3 2v15a1 1 0 0 0 1 1h2m8 -2v1a1 1 0 0 0 1 1h2", "key": "svg-0" }], ["path", { "d": "M7 7h0v.01", "key": "svg-1" }], ["path", { "d": "M7 10h0v.01", "key": "svg-2" }], ["path", { "d": "M7 13h0v.01", "key": "svg-3" }], ["path", { "d": "M17 7h0v.01", "key": "svg-4" }], ["path", { "d": "M17 10h0v.01", "key": "svg-5" }], ["path", { "d": "M17 13h0v.01", "key": "svg-6" }]]);

var IconBuildingFortress$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingFortress
});

var IconBuildingHospital = createReactComponent("outline", "building-hospital", "IconBuildingHospital", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16", "key": "svg-1" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-2" }], ["path", { "d": "M10 9l4 0", "key": "svg-3" }], ["path", { "d": "M12 7l0 4", "key": "svg-4" }]]);

var IconBuildingHospital$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingHospital
});

var IconBuildingLighthouse = createReactComponent("outline", "building-lighthouse", "IconBuildingLighthouse", [["path", { "d": "M12 3l2 3l2 15h-8l2 -15z", "key": "svg-0" }], ["path", { "d": "M8 9l8 0", "key": "svg-1" }], ["path", { "d": "M3 11l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M21 11l-2 -2l2 -2", "key": "svg-3" }]]);

var IconBuildingLighthouse$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingLighthouse
});

var IconBuildingMinus = createReactComponent("outline", "building-minus", "IconBuildingMinus", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 19h6", "key": "svg-7" }]]);

var IconBuildingMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingMinus
});

var IconBuildingMonument = createReactComponent("outline", "building-monument", "IconBuildingMonument", [["path", { "d": "M8 18l2 -13l2 -2l2 2l2 13", "key": "svg-0" }], ["path", { "d": "M5 21v-3h14v3", "key": "svg-1" }], ["path", { "d": "M3 21l18 0", "key": "svg-2" }]]);

var IconBuildingMonument$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingMonument
});

var IconBuildingMosque = createReactComponent("outline", "building-mosque", "IconBuildingMosque", [["path", { "d": "M3 21h7v-2a2 2 0 1 1 4 0v2h7", "key": "svg-0" }], ["path", { "d": "M4 21v-10", "key": "svg-1" }], ["path", { "d": "M20 21v-10", "key": "svg-2" }], ["path", { "d": "M4 16h3v-3h10v3h3", "key": "svg-3" }], ["path", { "d": "M17 13a5 5 0 0 0 -10 0", "key": "svg-4" }], ["path", { "d": "M21 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z", "key": "svg-5" }], ["path", { "d": "M5 10.5c0 -.329 -.077 -.653 -.224 -.947l-.776 -1.553l-.776 1.553a2.118 2.118 0 0 0 -.224 .947a.5 .5 0 0 0 .5 .5h1a.5 .5 0 0 0 .5 -.5z", "key": "svg-6" }], ["path", { "d": "M12 2a2 2 0 1 0 2 2", "key": "svg-7" }], ["path", { "d": "M12 6v2", "key": "svg-8" }]]);

var IconBuildingMosque$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingMosque
});

var IconBuildingOff = createReactComponent("outline", "building-off", "IconBuildingOff", [["path", { "d": "M3 21h18", "key": "svg-0" }], ["path", { "d": "M9 12h1", "key": "svg-1" }], ["path", { "d": "M9 16h1", "key": "svg-2" }], ["path", { "d": "M14 8h1", "key": "svg-3" }], ["path", { "d": "M14 16h1", "key": "svg-4" }], ["path", { "d": "M5 21v-16", "key": "svg-5" }], ["path", { "d": "M7 3h10c1 0 2 1 2 2v10", "key": "svg-6" }], ["path", { "d": "M19 19v2", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconBuildingOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingOff
});

var IconBuildingPavilion = createReactComponent("outline", "building-pavilion", "IconBuildingPavilion", [["path", { "d": "M3 21h7v-3a2 2 0 0 1 4 0v3h7", "key": "svg-0" }], ["path", { "d": "M6 21l0 -9", "key": "svg-1" }], ["path", { "d": "M18 21l0 -9", "key": "svg-2" }], ["path", { "d": "M6 12h12a3 3 0 0 0 3 -3a9 8 0 0 1 -9 -6a9 8 0 0 1 -9 6a3 3 0 0 0 3 3", "key": "svg-3" }]]);

var IconBuildingPavilion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingPavilion
});

var IconBuildingPlus = createReactComponent("outline", "building-plus", "IconBuildingPlus", [["path", { "d": "M3 21h9", "key": "svg-0" }], ["path", { "d": "M9 8h1", "key": "svg-1" }], ["path", { "d": "M9 12h1", "key": "svg-2" }], ["path", { "d": "M9 16h1", "key": "svg-3" }], ["path", { "d": "M14 8h1", "key": "svg-4" }], ["path", { "d": "M14 12h1", "key": "svg-5" }], ["path", { "d": "M5 21v-16c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h10c.53 0 1.039 .211 1.414 .586c.375 .375 .586 .884 .586 1.414v7", "key": "svg-6" }], ["path", { "d": "M16 19h6", "key": "svg-7" }], ["path", { "d": "M19 16v6", "key": "svg-8" }]]);

var IconBuildingPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingPlus
});

var IconBuildingSkyscraper = createReactComponent("outline", "building-skyscraper", "IconBuildingSkyscraper", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M5 21v-14l8 -4v18", "key": "svg-1" }], ["path", { "d": "M19 21v-10l-6 -4", "key": "svg-2" }], ["path", { "d": "M9 9l0 .01", "key": "svg-3" }], ["path", { "d": "M9 12l0 .01", "key": "svg-4" }], ["path", { "d": "M9 15l0 .01", "key": "svg-5" }], ["path", { "d": "M9 18l0 .01", "key": "svg-6" }]]);

var IconBuildingSkyscraper$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingSkyscraper
});

var IconBuildingStadium = createReactComponent("outline", "building-stadium", "IconBuildingStadium", [["path", { "d": "M12 12m-8 0a8 2 0 1 0 16 0a8 2 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 12v7c0 .94 2.51 1.785 6 2v-3h4v3c3.435 -.225 6 -1.07 6 -2v-7", "key": "svg-1" }], ["path", { "d": "M15 6h4v-3h-4v7", "key": "svg-2" }], ["path", { "d": "M7 6h4v-3h-4v7", "key": "svg-3" }]]);

var IconBuildingStadium$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingStadium
});

var IconBuildingStore = createReactComponent("outline", "building-store", "IconBuildingStore", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M3 7v1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1h-18l2 -4h14l2 4", "key": "svg-1" }], ["path", { "d": "M5 21l0 -10.15", "key": "svg-2" }], ["path", { "d": "M19 21l0 -10.15", "key": "svg-3" }], ["path", { "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4", "key": "svg-4" }]]);

var IconBuildingStore$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingStore
});

var IconBuildingTunnel = createReactComponent("outline", "building-tunnel", "IconBuildingTunnel", [["path", { "d": "M5 21h14a2 2 0 0 0 2 -2v-7a9 9 0 0 0 -18 0v7a2 2 0 0 0 2 2z", "key": "svg-0" }], ["path", { "d": "M8 21v-9a4 4 0 1 1 8 0v9", "key": "svg-1" }], ["path", { "d": "M3 17h4", "key": "svg-2" }], ["path", { "d": "M17 17h4", "key": "svg-3" }], ["path", { "d": "M21 12h-4", "key": "svg-4" }], ["path", { "d": "M7 12h-4", "key": "svg-5" }], ["path", { "d": "M12 3v5", "key": "svg-6" }], ["path", { "d": "M6 6l3 3", "key": "svg-7" }], ["path", { "d": "M15 9l3 -3l-3 3z", "key": "svg-8" }]]);

var IconBuildingTunnel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingTunnel
});

var IconBuildingWarehouse = createReactComponent("outline", "building-warehouse", "IconBuildingWarehouse", [["path", { "d": "M3 21v-13l9 -4l9 4v13", "key": "svg-0" }], ["path", { "d": "M13 13h4v8h-10v-6h6", "key": "svg-1" }], ["path", { "d": "M13 21v-9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v3", "key": "svg-2" }]]);

var IconBuildingWarehouse$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingWarehouse
});

var IconBuildingWindTurbine = createReactComponent("outline", "building-wind-turbine", "IconBuildingWindTurbine", [["path", { "d": "M12 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M10 11v-2.573c0 -.18 .013 -.358 .04 -.536l.716 -4.828c.064 -.597 .597 -1.063 1.244 -1.063s1.18 .466 1.244 1.063l.716 4.828c.027 .178 .04 .357 .04 .536v2.573", "key": "svg-1" }], ["path", { "d": "M13.01 9.28l2.235 1.276c.156 .09 .305 .19 .446 .3l3.836 2.911c.487 .352 .624 1.04 .3 1.596c-.325 .556 -1 .782 -1.548 .541l-4.555 -1.68a3.624 3.624 0 0 1 -.486 -.231l-2.235 -1.277", "key": "svg-2" }], ["path", { "d": "M13 12.716l-2.236 1.277a3.624 3.624 0 0 1 -.485 .23l-4.555 1.681c-.551 .241 -1.223 .015 -1.548 -.54c-.324 -.557 -.187 -1.245 .3 -1.597l3.836 -2.91a3.41 3.41 0 0 1 .446 -.3l2.235 -1.277", "key": "svg-3" }], ["path", { "d": "M7 21h10", "key": "svg-4" }], ["path", { "d": "M10 21l1 -7", "key": "svg-5" }], ["path", { "d": "M13 14l1 7", "key": "svg-6" }]]);

var IconBuildingWindTurbine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildingWindTurbine
});

var IconBuilding = createReactComponent("outline", "building", "IconBuilding", [["path", { "d": "M3 21l18 0", "key": "svg-0" }], ["path", { "d": "M9 8l1 0", "key": "svg-1" }], ["path", { "d": "M9 12l1 0", "key": "svg-2" }], ["path", { "d": "M9 16l1 0", "key": "svg-3" }], ["path", { "d": "M14 8l1 0", "key": "svg-4" }], ["path", { "d": "M14 12l1 0", "key": "svg-5" }], ["path", { "d": "M14 16l1 0", "key": "svg-6" }], ["path", { "d": "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16", "key": "svg-7" }]]);

var IconBuilding$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuilding
});

var IconBuildings = createReactComponent("outline", "buildings", "IconBuildings", [["path", { "d": "M4 21v-15c0 -1 1 -2 2 -2h5c1 0 2 1 2 2v15", "key": "svg-0" }], ["path", { "d": "M16 8h2c1 0 2 1 2 2v11", "key": "svg-1" }], ["path", { "d": "M3 21h18", "key": "svg-2" }], ["path", { "d": "M10 12v0", "key": "svg-3" }], ["path", { "d": "M10 16v0", "key": "svg-4" }], ["path", { "d": "M10 8v0", "key": "svg-5" }], ["path", { "d": "M7 12v0", "key": "svg-6" }], ["path", { "d": "M7 16v0", "key": "svg-7" }], ["path", { "d": "M7 8v0", "key": "svg-8" }], ["path", { "d": "M17 12v0", "key": "svg-9" }], ["path", { "d": "M17 16v0", "key": "svg-10" }]]);

var IconBuildings$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBuildings
});

var IconBulbOff = createReactComponent("outline", "bulb-off", "IconBulbOff", [["path", { "d": "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7", "key": "svg-0" }], ["path", { "d": "M11.089 7.083a5 5 0 0 1 5.826 5.84m-1.378 2.611a5.012 5.012 0 0 1 -.537 .466a3.5 3.5 0 0 0 -1 3a2 2 0 1 1 -4 0a3.5 3.5 0 0 0 -1 -3a5 5 0 0 1 -.528 -7.544", "key": "svg-1" }], ["path", { "d": "M9.7 17h4.6", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconBulbOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBulbOff
});

var IconBulb = createReactComponent("outline", "bulb", "IconBulb", [["path", { "d": "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7", "key": "svg-0" }], ["path", { "d": "M9 16a5 5 0 1 1 6 0a3.5 3.5 0 0 0 -1 3a2 2 0 0 1 -4 0a3.5 3.5 0 0 0 -1 -3", "key": "svg-1" }], ["path", { "d": "M9.7 17l4.6 0", "key": "svg-2" }]]);

var IconBulb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBulb
});

var IconBulldozer = createReactComponent("outline", "bulldozer", "IconBulldozer", [["path", { "d": "M2 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 13v4a2 2 0 0 0 2 2h1", "key": "svg-2" }], ["path", { "d": "M14 19h-10", "key": "svg-3" }], ["path", { "d": "M4 15h10", "key": "svg-4" }], ["path", { "d": "M9 11v-5h2a3 3 0 0 1 3 3v6", "key": "svg-5" }], ["path", { "d": "M5 15v-3a1 1 0 0 1 1 -1h8", "key": "svg-6" }], ["path", { "d": "M19 17h-3", "key": "svg-7" }]]);

var IconBulldozer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBulldozer
});

var IconBurger = createReactComponent("outline", "burger", "IconBurger", [["path", { "d": "M4 15h16a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M12 4c3.783 0 6.953 2.133 7.786 5h-15.572c.833 -2.867 4.003 -5 7.786 -5z", "key": "svg-1" }], ["path", { "d": "M5 12h14", "key": "svg-2" }]]);

var IconBurger$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBurger
});

var IconBusOff = createReactComponent("outline", "bus-off", "IconBusOff", [["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16.18 16.172a2 2 0 0 0 2.652 2.648", "key": "svg-1" }], ["path", { "d": "M4 17h-2v-11a1 1 0 0 1 1 -1h2m4 0h8c2.761 0 5 3.134 5 7v5h-1m-5 0h-8", "key": "svg-2" }], ["path", { "d": "M16 5l1.5 7h4.5", "key": "svg-3" }], ["path", { "d": "M2 10h8m4 0h3", "key": "svg-4" }], ["path", { "d": "M7 7v3", "key": "svg-5" }], ["path", { "d": "M12 5v3", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconBusOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBusOff
});

var IconBusStop = createReactComponent("outline", "bus-stop", "IconBusStop", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M10 5h7c2.761 0 5 3.134 5 7v5h-2", "key": "svg-2" }], ["path", { "d": "M16 17h-8", "key": "svg-3" }], ["path", { "d": "M16 5l1.5 7h4.5", "key": "svg-4" }], ["path", { "d": "M9.5 10h7.5", "key": "svg-5" }], ["path", { "d": "M12 5v5", "key": "svg-6" }], ["path", { "d": "M5 9v11", "key": "svg-7" }]]);

var IconBusStop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBusStop
});

var IconBus = createReactComponent("outline", "bus", "IconBus", [["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M4 17h-2v-11a1 1 0 0 1 1 -1h14a5 7 0 0 1 5 7v5h-2m-4 0h-8", "key": "svg-2" }], ["path", { "d": "M16 5l1.5 7l4.5 0", "key": "svg-3" }], ["path", { "d": "M2 10l15 0", "key": "svg-4" }], ["path", { "d": "M7 5l0 5", "key": "svg-5" }], ["path", { "d": "M12 5l0 5", "key": "svg-6" }]]);

var IconBus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBus
});

var IconBusinessplan = createReactComponent("outline", "businessplan", "IconBusinessplan", [["path", { "d": "M16 6m-5 0a5 3 0 1 0 10 0a5 3 0 1 0 -10 0", "key": "svg-0" }], ["path", { "d": "M11 6v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-1" }], ["path", { "d": "M11 10v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-2" }], ["path", { "d": "M11 14v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4", "key": "svg-3" }], ["path", { "d": "M7 9h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M5 15v1m0 -8v1", "key": "svg-5" }]]);

var IconBusinessplan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconBusinessplan
});

var IconButterfly = createReactComponent("outline", "butterfly", "IconButterfly", [["path", { "d": "M12 18.176a3 3 0 1 1 -4.953 -2.449l-.025 .023a4.502 4.502 0 0 1 1.483 -8.75c1.414 0 2.675 .652 3.5 1.671a4.5 4.5 0 1 1 4.983 7.079a3 3 0 1 1 -4.983 2.25z", "key": "svg-0" }], ["path", { "d": "M12 19v-10", "key": "svg-1" }], ["path", { "d": "M9 3l3 2l3 -2", "key": "svg-2" }]]);

var IconButterfly$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconButterfly
});

var IconCactusOff = createReactComponent("outline", "cactus-off", "IconCactusOff", [["path", { "d": "M6 9v1a3 3 0 0 0 3 3h1", "key": "svg-0" }], ["path", { "d": "M18 8v5a3 3 0 0 1 -.129 .872m-2.014 2a3 3 0 0 1 -.857 .124h-1", "key": "svg-1" }], ["path", { "d": "M10 21v-11m0 -4v-1a2 2 0 1 1 4 0v5m0 4v7", "key": "svg-2" }], ["path", { "d": "M7 21h10", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCactusOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCactusOff
});

var IconCactus = createReactComponent("outline", "cactus", "IconCactus", [["path", { "d": "M6 9v1a3 3 0 0 0 3 3h1", "key": "svg-0" }], ["path", { "d": "M18 8v5a3 3 0 0 1 -3 3h-1", "key": "svg-1" }], ["path", { "d": "M10 21v-16a2 2 0 1 1 4 0v16", "key": "svg-2" }], ["path", { "d": "M7 21h10", "key": "svg-3" }]]);

var IconCactus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCactus
});

var IconCakeOff = createReactComponent("outline", "cake-off", "IconCakeOff", [["path", { "d": "M21 17v-5a3 3 0 0 0 -3 -3h-5m-4 0h-3a3 3 0 0 0 -3 3v8h17", "key": "svg-0" }], ["path", { "d": "M3 14.803c.312 .135 .654 .204 1 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1m4 0a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1 -.197", "key": "svg-1" }], ["path", { "d": "M10.172 6.188c.07 -.158 .163 -.31 .278 -.451l1.55 -1.737l1.465 1.638a2 2 0 0 1 -.65 3.19", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCakeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCakeOff
});

var IconCakeRoll = createReactComponent("outline", "cake-roll", "IconCakeRoll", [["path", { "d": "M12 15c-4.97 0 -9 -2.462 -9 -5.5s4.03 -5.5 9 -5.5s9 2.462 9 5.5s-4.03 5.5 -9 5.5", "key": "svg-0" }], ["path", { "d": "M12 6.97c3 0 4 1.036 4 1.979c0 2.805 -8 2.969 -8 -.99c0 -2.11 1.5 -3.959 4 -3.959", "key": "svg-1" }], ["path", { "d": "M21 9.333v5.334c0 2.945 -4.03 5.333 -9 5.333s-9 -2.388 -9 -5.333v-5.334", "key": "svg-2" }]]);

var IconCakeRoll$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCakeRoll
});

var IconCake = createReactComponent("outline", "cake", "IconCake", [["path", { "d": "M3 20h18v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3v8z", "key": "svg-0" }], ["path", { "d": "M3 14.803c.312 .135 .654 .204 1 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1 -.197", "key": "svg-1" }], ["path", { "d": "M12 4l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z", "key": "svg-2" }]]);

var IconCake$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCake
});

var IconCalculatorOff = createReactComponent("outline", "calculator-off", "IconCalculatorOff", [["path", { "d": "M19.823 19.824a2 2 0 0 1 -1.823 1.176h-12a2 2 0 0 1 -2 -2v-14c0 -.295 .064 -.575 .178 -.827m2.822 -1.173h11a2 2 0 0 1 2 2v11", "key": "svg-0" }], ["path", { "d": "M10 10h-1a1 1 0 0 1 -1 -1v-1m3 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1", "key": "svg-1" }], ["path", { "d": "M8 14v.01", "key": "svg-2" }], ["path", { "d": "M12 14v.01", "key": "svg-3" }], ["path", { "d": "M8 17v.01", "key": "svg-4" }], ["path", { "d": "M12 17v.01", "key": "svg-5" }], ["path", { "d": "M16 17v.01", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconCalculatorOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalculatorOff
});

var IconCalculator = createReactComponent("outline", "calculator", "IconCalculator", [["path", { "d": "M4 3m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 7m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M8 14l0 .01", "key": "svg-2" }], ["path", { "d": "M12 14l0 .01", "key": "svg-3" }], ["path", { "d": "M16 14l0 .01", "key": "svg-4" }], ["path", { "d": "M8 17l0 .01", "key": "svg-5" }], ["path", { "d": "M12 17l0 .01", "key": "svg-6" }], ["path", { "d": "M16 17l0 .01", "key": "svg-7" }]]);

var IconCalculator$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalculator
});

var IconCalendarBolt = createReactComponent("outline", "calendar-bolt", "IconCalendarBolt", [["path", { "d": "M13.5 21h-7.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconCalendarBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarBolt
});

var IconCalendarCancel = createReactComponent("outline", "calendar-cancel", "IconCalendarCancel", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconCalendarCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarCancel
});

var IconCalendarCheck = createReactComponent("outline", "calendar-check", "IconCalendarCheck", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconCalendarCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarCheck
});

var IconCalendarClock = createReactComponent("outline", "calendar-clock", "IconCalendarClock", [["path", { "d": "M10.5 21h-4.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h10", "key": "svg-3" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-4" }], ["path", { "d": "M18 16.5v1.5l.5 .5", "key": "svg-5" }]]);

var IconCalendarClock$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarClock
});

var IconCalendarCode = createReactComponent("outline", "calendar-code", "IconCalendarCode", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconCalendarCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarCode
});

var IconCalendarCog = createReactComponent("outline", "calendar-cog", "IconCalendarCog", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconCalendarCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarCog
});

var IconCalendarDollar = createReactComponent("outline", "calendar-dollar", "IconCalendarDollar", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h12.5", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconCalendarDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarDollar
});

var IconCalendarDot = createReactComponent("outline", "calendar-dot", "IconCalendarDot", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconCalendarDot$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarDot
});

var IconCalendarDown = createReactComponent("outline", "calendar-down", "IconCalendarDown", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }], ["path", { "d": "M16 3v4", "key": "svg-3" }], ["path", { "d": "M8 3v4", "key": "svg-4" }], ["path", { "d": "M4 11h16", "key": "svg-5" }]]);

var IconCalendarDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarDown
});

var IconCalendarDue = createReactComponent("outline", "calendar-due", "IconCalendarDue", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconCalendarDue$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarDue
});

var IconCalendarEvent = createReactComponent("outline", "calendar-event", "IconCalendarEvent", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 3l0 4", "key": "svg-1" }], ["path", { "d": "M8 3l0 4", "key": "svg-2" }], ["path", { "d": "M4 11l16 0", "key": "svg-3" }], ["path", { "d": "M8 15h2v2h-2z", "key": "svg-4" }]]);

var IconCalendarEvent$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarEvent
});

var IconCalendarExclamation = createReactComponent("outline", "calendar-exclamation", "IconCalendarExclamation", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M11 15h1", "key": "svg-4" }], ["path", { "d": "M12 15v3", "key": "svg-5" }], ["path", { "d": "M19 16v3", "key": "svg-6" }], ["path", { "d": "M19 22v.01", "key": "svg-7" }]]);

var IconCalendarExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarExclamation
});

var IconCalendarHeart = createReactComponent("outline", "calendar-heart", "IconCalendarHeart", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconCalendarHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarHeart
});

var IconCalendarMinus = createReactComponent("outline", "calendar-minus", "IconCalendarMinus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconCalendarMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarMinus
});

var IconCalendarMonth = createReactComponent("outline", "calendar-month", "IconCalendarMonth", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M8 14v4", "key": "svg-4" }], ["path", { "d": "M12 14v4", "key": "svg-5" }], ["path", { "d": "M16 14v4", "key": "svg-6" }]]);

var IconCalendarMonth$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarMonth
});

var IconCalendarOff = createReactComponent("outline", "calendar-off", "IconCalendarOff", [["path", { "d": "M9 5h9a2 2 0 0 1 2 2v9m-.184 3.839a2 2 0 0 1 -1.816 1.161h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.158 -1.815", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v1", "key": "svg-2" }], ["path", { "d": "M4 11h7m4 0h5", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCalendarOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarOff
});

var IconCalendarPause = createReactComponent("outline", "calendar-pause", "IconCalendarPause", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconCalendarPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarPause
});

var IconCalendarPin = createReactComponent("outline", "calendar-pin", "IconCalendarPin", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }], ["path", { "d": "M8 3v4", "key": "svg-4" }], ["path", { "d": "M4 11h16", "key": "svg-5" }]]);

var IconCalendarPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarPin
});

var IconCalendarPlus = createReactComponent("outline", "calendar-plus", "IconCalendarPlus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconCalendarPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarPlus
});

var IconCalendarQuestion = createReactComponent("outline", "calendar-question", "IconCalendarQuestion", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-5" }]]);

var IconCalendarQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarQuestion
});

var IconCalendarRepeat = createReactComponent("outline", "calendar-repeat", "IconCalendarRepeat", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h12", "key": "svg-3" }], ["path", { "d": "M20 14l2 2h-3", "key": "svg-4" }], ["path", { "d": "M20 18l2 -2", "key": "svg-5" }], ["path", { "d": "M19 16a3 3 0 1 0 2 5.236", "key": "svg-6" }]]);

var IconCalendarRepeat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarRepeat
});

var IconCalendarSad = createReactComponent("outline", "calendar-sad", "IconCalendarSad", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12zm12 -4v4m-8 -4v4m-4 4h16m-9.995 3h.01m3.99 0h.01", "key": "svg-0" }], ["path", { "d": "M10 18a3.5 3.5 0 0 1 4 0", "key": "svg-1" }]]);

var IconCalendarSad$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarSad
});

var IconCalendarSearch = createReactComponent("outline", "calendar-search", "IconCalendarSearch", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconCalendarSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarSearch
});

var IconCalendarShare = createReactComponent("outline", "calendar-share", "IconCalendarShare", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconCalendarShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarShare
});

var IconCalendarSmile = createReactComponent("outline", "calendar-smile", "IconCalendarSmile", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12zm12 -4v4m-8 -4v4m-4 4h16m-9.995 3h.01m3.99 0h.01", "key": "svg-0" }], ["path", { "d": "M10.005 17a3.5 3.5 0 0 0 4 0", "key": "svg-1" }]]);

var IconCalendarSmile$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarSmile
});

var IconCalendarStar = createReactComponent("outline", "calendar-star", "IconCalendarStar", [["path", { "d": "M11 21h-5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h11", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconCalendarStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarStar
});

var IconCalendarStats = createReactComponent("outline", "calendar-stats", "IconCalendarStats", [["path", { "d": "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M18 14v4h4", "key": "svg-1" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }], ["path", { "d": "M15 3v4", "key": "svg-3" }], ["path", { "d": "M7 3v4", "key": "svg-4" }], ["path", { "d": "M3 11h16", "key": "svg-5" }]]);

var IconCalendarStats$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarStats
});

var IconCalendarTime = createReactComponent("outline", "calendar-time", "IconCalendarTime", [["path", { "d": "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M15 3v4", "key": "svg-2" }], ["path", { "d": "M7 3v4", "key": "svg-3" }], ["path", { "d": "M3 11h16", "key": "svg-4" }], ["path", { "d": "M18 16.496v1.504l1 1", "key": "svg-5" }]]);

var IconCalendarTime$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarTime
});

var IconCalendarUp = createReactComponent("outline", "calendar-up", "IconCalendarUp", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconCalendarUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarUp
});

var IconCalendarUser = createReactComponent("outline", "calendar-user", "IconCalendarUser", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M19 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M22 22a2 2 0 0 0 -2 -2h-2a2 2 0 0 0 -2 2", "key": "svg-5" }]]);

var IconCalendarUser$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarUser
});

var IconCalendarWeek = createReactComponent("outline", "calendar-week", "IconCalendarWeek", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M7 14h.013", "key": "svg-4" }], ["path", { "d": "M10.01 14h.005", "key": "svg-5" }], ["path", { "d": "M13.01 14h.005", "key": "svg-6" }], ["path", { "d": "M16.015 14h.005", "key": "svg-7" }], ["path", { "d": "M13.015 17h.005", "key": "svg-8" }], ["path", { "d": "M7.01 17h.005", "key": "svg-9" }], ["path", { "d": "M10.01 17h.005", "key": "svg-10" }]]);

var IconCalendarWeek$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarWeek
});

var IconCalendarX = createReactComponent("outline", "calendar-x", "IconCalendarX", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconCalendarX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendarX
});

var IconCalendar = createReactComponent("outline", "calendar", "IconCalendar", [["path", { "d": "M4 7a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M16 3v4", "key": "svg-1" }], ["path", { "d": "M8 3v4", "key": "svg-2" }], ["path", { "d": "M4 11h16", "key": "svg-3" }], ["path", { "d": "M11 15h1", "key": "svg-4" }], ["path", { "d": "M12 15v3", "key": "svg-5" }]]);

var IconCalendar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCalendar
});

var IconCameraAi = createReactComponent("outline", "camera-ai", "IconCameraAi", [["path", { "d": "M10 20h-5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.362 11.15a3 3 0 1 0 -4.144 4.263", "key": "svg-1" }], ["path", { "d": "M14 21v-4a2 2 0 1 1 4 0v4", "key": "svg-2" }], ["path", { "d": "M14 19h4", "key": "svg-3" }], ["path", { "d": "M21 15v6", "key": "svg-4" }]]);

var IconCameraAi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraAi
});

var IconCameraBitcoin = createReactComponent("outline", "camera-bitcoin", "IconCameraBitcoin", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v1", "key": "svg-0" }], ["path", { "d": "M14.477 11.307a3 3 0 1 0 -2.477 4.693", "key": "svg-1" }], ["path", { "d": "M17 21v-6", "key": "svg-2" }], ["path", { "d": "M19 15v-1.5", "key": "svg-3" }], ["path", { "d": "M19 22.5v-1.5", "key": "svg-4" }], ["path", { "d": "M17 18h3", "key": "svg-5" }], ["path", { "d": "M19 18h.5a1.5 1.5 0 0 1 0 3h-3.5", "key": "svg-6" }], ["path", { "d": "M19 18h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-7" }]]);

var IconCameraBitcoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraBitcoin
});

var IconCameraBolt = createReactComponent("outline", "camera-bolt", "IconCameraBolt", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconCameraBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraBolt
});

var IconCameraCancel = createReactComponent("outline", "camera-cancel", "IconCameraCancel", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M14.984 13.307a3 3 0 1 0 -2.32 2.62", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconCameraCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraCancel
});

var IconCameraCheck = createReactComponent("outline", "camera-check", "IconCameraCheck", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconCameraCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraCheck
});

var IconCameraCode = createReactComponent("outline", "camera-code", "IconCameraCode", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.948 13.559a3 3 0 1 0 -2.58 2.419", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconCameraCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraCode
});

var IconCameraCog = createReactComponent("outline", "camera-cog", "IconCameraCog", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M14.973 13.406a3 3 0 1 0 -2.973 2.594", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconCameraCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraCog
});

var IconCameraDollar = createReactComponent("outline", "camera-dollar", "IconCameraDollar", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v1.5", "key": "svg-0" }], ["path", { "d": "M14.935 12.375a3.001 3.001 0 1 0 -1.902 3.442", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconCameraDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraDollar
});

var IconCameraDown = createReactComponent("outline", "camera-down", "IconCameraDown", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconCameraDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraDown
});

var IconCameraExclamation = createReactComponent("outline", "camera-exclamation", "IconCameraExclamation", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconCameraExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraExclamation
});

var IconCameraHeart = createReactComponent("outline", "camera-heart", "IconCameraHeart", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.41 11.212a3 3 0 1 0 -4.15 4.231", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconCameraHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraHeart
});

var IconCameraMinus = createReactComponent("outline", "camera-minus", "IconCameraMinus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-2" }]]);

var IconCameraMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraMinus
});

var IconCameraMoon = createReactComponent("outline", "camera-moon", "IconCameraMoon", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M14.815 11.96a3.001 3.001 0 1 0 -3.398 3.983", "key": "svg-1" }], ["path", { "d": "M18.62 22c-2 0 -3.62 -1.58 -3.62 -3.53c0 -1.727 1.273 -3.165 2.954 -3.47a3.4 3.4 0 0 0 -.24 1.264c0 1.95 1.621 3.53 3.62 3.53q .342 0 .666 -.06c-.521 1.326 -1.838 2.266 -3.38 2.266", "key": "svg-2" }]]);

var IconCameraMoon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraMoon
});

var IconCameraOff = createReactComponent("outline", "camera-off", "IconCameraOff", [["path", { "d": "M8.297 4.289a.997 .997 0 0 1 .703 -.289h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v8m-1.187 2.828c-.249 .11 -.524 .172 -.813 .172h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1c.298 0 .58 -.065 .834 -.181", "key": "svg-0" }], ["path", { "d": "M10.422 10.448a3 3 0 1 0 4.15 4.098", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCameraOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraOff
});

var IconCameraPause = createReactComponent("outline", "camera-pause", "IconCameraPause", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.958 13.506a3 3 0 1 0 -1.735 2.235", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconCameraPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraPause
});

var IconCameraPin = createReactComponent("outline", "camera-pin", "IconCameraPin", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2", "key": "svg-0" }], ["path", { "d": "M14.933 12.366a3.001 3.001 0 1 0 -2.933 3.634", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconCameraPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraPin
});

var IconCameraPlus = createReactComponent("outline", "camera-plus", "IconCameraPlus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-3" }]]);

var IconCameraPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraPlus
});

var IconCameraQuestion = createReactComponent("outline", "camera-question", "IconCameraQuestion", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.975 12.612a3 3 0 1 0 -1.507 3.005", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconCameraQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraQuestion
});

var IconCameraRotate = createReactComponent("outline", "camera-rotate", "IconCameraRotate", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M11.245 15.904a3 3 0 0 0 3.755 -2.904m-2.25 -2.905a3 3 0 0 0 -3.75 2.905", "key": "svg-1" }], ["path", { "d": "M14 13h2v2", "key": "svg-2" }], ["path", { "d": "M10 13h-2v-2", "key": "svg-3" }]]);

var IconCameraRotate$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraRotate
});

var IconCameraSearch = createReactComponent("outline", "camera-search", "IconCameraSearch", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.757 11.815a3 3 0 1 0 -3.431 4.109", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconCameraSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraSearch
});

var IconCameraSelfie = createReactComponent("outline", "camera-selfie", "IconCameraSelfie", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9.5 15a3.5 3.5 0 0 0 5 0", "key": "svg-1" }], ["path", { "d": "M15 11l.01 0", "key": "svg-2" }], ["path", { "d": "M9 11l.01 0", "key": "svg-3" }]]);

var IconCameraSelfie$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraSelfie
});

var IconCameraShare = createReactComponent("outline", "camera-share", "IconCameraShare", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M14.98 13.347a3 3 0 1 0 -2.39 2.595", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconCameraShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraShare
});

var IconCameraSpark = createReactComponent("outline", "camera-spark", "IconCameraSpark", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-2" }]]);

var IconCameraSpark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraSpark
});

var IconCameraStar = createReactComponent("outline", "camera-star", "IconCameraStar", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v2.5", "key": "svg-0" }], ["path", { "d": "M14.569 11.45a3 3 0 1 0 -4.518 3.83", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconCameraStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraStar
});

var IconCameraUp = createReactComponent("outline", "camera-up", "IconCameraUp", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5", "key": "svg-0" }], ["path", { "d": "M12 16a3 3 0 1 0 0 -6a3 3 0 0 0 0 6z", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconCameraUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraUp
});

var IconCameraX = createReactComponent("outline", "camera-x", "IconCameraX", [["path", { "d": "M13.5 20h-8.5a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconCameraX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCameraX
});

var IconCamera = createReactComponent("outline", "camera", "IconCamera", [["path", { "d": "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0", "key": "svg-1" }]]);

var IconCamera$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCamera
});

var IconCamper = createReactComponent("outline", "camper", "IconCamper", [["path", { "d": "M5 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 18h-1a1 1 0 0 1 -1 -1v-11a2 2 0 0 1 2 -2h12a4 4 0 0 1 4 4h-18", "key": "svg-2" }], ["path", { "d": "M9 18h6", "key": "svg-3" }], ["path", { "d": "M19 18h1a1 1 0 0 0 1 -1v-4l-3 -5", "key": "svg-4" }], ["path", { "d": "M21 13h-7", "key": "svg-5" }], ["path", { "d": "M14 8v10", "key": "svg-6" }]]);

var IconCamper$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCamper
});

var IconCampfire = createReactComponent("outline", "campfire", "IconCampfire", [["path", { "d": "M4 21l16 -4", "key": "svg-0" }], ["path", { "d": "M20 21l-16 -4", "key": "svg-1" }], ["path", { "d": "M12 15a4 4 0 0 0 4 -4c0 -3 -2 -3 -2 -8c-4 2 -6 5 -6 8a4 4 0 0 0 4 4z", "key": "svg-2" }]]);

var IconCampfire$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCampfire
});

var IconCancel = createReactComponent("outline", "cancel", "IconCancel", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M18.364 5.636l-12.728 12.728", "key": "svg-1" }]]);

var IconCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCancel
});

var IconCandle = createReactComponent("outline", "candle", "IconCandle", [["path", { "d": "M9 21h6v-10a1 1 0 0 0 -1 -1h-4a1 1 0 0 0 -1 1z", "key": "svg-0" }], ["path", { "d": "M12 2l1.465 1.638a2 2 0 1 1 -3.015 .099z", "key": "svg-1" }]]);

var IconCandle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCandle
});

var IconCandyOff = createReactComponent("outline", "candy-off", "IconCandyOff", [["path", { "d": "M11.174 7.17l.119 -.12a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-.124 .124m-2 2l-2.123 2.123a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828l2.113 -2.112", "key": "svg-0" }], ["path", { "d": "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913", "key": "svg-1" }], ["path", { "d": "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCandyOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCandyOff
});

var IconCandy = createReactComponent("outline", "candy", "IconCandy", [["path", { "d": "M7.05 11.293l4.243 -4.243a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-4.243 4.243a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828z", "key": "svg-0" }], ["path", { "d": "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913", "key": "svg-1" }], ["path", { "d": "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248", "key": "svg-2" }]]);

var IconCandy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCandy
});

var IconCane = createReactComponent("outline", "cane", "IconCane", [["path", { "d": "M9 21l6.324 -11.69c.54 -.974 1.756 -4.104 -1.499 -5.762c-3.255 -1.657 -5.175 .863 -5.825 2.032", "key": "svg-0" }]]);

var IconCane$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCane
});

var IconCannabis = createReactComponent("outline", "cannabis", "IconCannabis", [["path", { "d": "M7 20s0 -2 1 -3.5c-1.5 0 -2 -.5 -4 -1.5c0 0 1.839 -1.38 5 -1c-1.789 -.97 -3.279 -2.03 -5 -6c0 0 3.98 -.3 6.5 3.5c-2.284 -4.9 1.5 -9.5 1.5 -9.5c2.734 5.47 2.389 7.5 1.5 9.5c2.531 -3.77 6.5 -3.5 6.5 -3.5c-1.721 3.97 -3.211 5.03 -5 6c3.161 -.38 5 1 5 1c-2 1 -2.5 1.5 -4 1.5c1 1.5 1 3.5 1 3.5c-2 0 -4.438 -2.22 -5 -3c-.563 .78 -3 3 -5 3z", "key": "svg-0" }], ["path", { "d": "M12 22v-5", "key": "svg-1" }]]);

var IconCannabis$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCannabis
});

var IconCapProjecting = createReactComponent("outline", "cap-projecting", "IconCapProjecting", [["path", { "d": "M20 6h-13a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h13", "key": "svg-0" }], ["path", { "d": "M13 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-1" }], ["path", { "d": "M13 12h7", "key": "svg-2" }]]);

var IconCapProjecting$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapProjecting
});

var IconCapRounded = createReactComponent("outline", "cap-rounded", "IconCapRounded", [["path", { "d": "M20 6h-9a6 6 0 1 0 0 12h9", "key": "svg-0" }], ["path", { "d": "M13 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-1" }], ["path", { "d": "M13 12h7", "key": "svg-2" }]]);

var IconCapRounded$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapRounded
});

var IconCapStraight = createReactComponent("outline", "cap-straight", "IconCapStraight", [["path", { "d": "M8 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0", "key": "svg-0" }], ["path", { "d": "M8 12h12", "key": "svg-1" }], ["path", { "d": "M20 6h-12a2 2 0 0 0 -2 2v2", "key": "svg-2" }], ["path", { "d": "M6 14v2a2 2 0 0 0 2 2h12", "key": "svg-3" }]]);

var IconCapStraight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapStraight
});

var IconCapsuleHorizontal = createReactComponent("outline", "capsule-horizontal", "IconCapsuleHorizontal", [["path", { "d": "M3 6m0 6a6 6 0 0 1 6 -6h6a6 6 0 0 1 6 6v0a6 6 0 0 1 -6 6h-6a6 6 0 0 1 -6 -6z", "key": "svg-0" }]]);

var IconCapsuleHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapsuleHorizontal
});

var IconCapsule = createReactComponent("outline", "capsule", "IconCapsule", [["path", { "d": "M6 3m0 6a6 6 0 0 1 6 -6h0a6 6 0 0 1 6 6v6a6 6 0 0 1 -6 6h0a6 6 0 0 1 -6 -6z", "key": "svg-0" }]]);

var IconCapsule$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapsule
});

var IconCaptureOff = createReactComponent("outline", "capture-off", "IconCaptureOff", [["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-0" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-1" }], ["path", { "d": "M16 20h2c.554 0 1.055 -.225 1.417 -.589", "key": "svg-2" }], ["path", { "d": "M9.87 9.887a3 3 0 0 0 4.255 4.23m.58 -3.416a3.012 3.012 0 0 0 -1.4 -1.403", "key": "svg-3" }], ["path", { "d": "M4 8v-2c0 -.548 .22 -1.044 .577 -1.405", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCaptureOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaptureOff
});

var IconCapture = createReactComponent("outline", "capture", "IconCapture", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }]]);

var IconCapture$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCapture
});

var IconCar4wd = createReactComponent("outline", "car-4wd", "IconCar4wd", [["path", { "d": "M5 3m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M5 15m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M15 3m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-2" }], ["path", { "d": "M15 15m0 2a2 2 0 0 1 2 -2h0a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h0a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M9 18h6", "key": "svg-4" }], ["path", { "d": "M9 6h6", "key": "svg-5" }], ["path", { "d": "M12 6.5v-.5v12", "key": "svg-6" }]]);

var IconCar4wd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCar4wd
});

var IconCarCrane = createReactComponent("outline", "car-crane", "IconCarCrane", [["path", { "d": "M5 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M7 18h8m4 0h2v-6a5 5 0 0 0 -5 -5h-1l1.5 5h4.5", "key": "svg-2" }], ["path", { "d": "M12 18v-11h3", "key": "svg-3" }], ["path", { "d": "M3 17v-5h9", "key": "svg-4" }], ["path", { "d": "M4 12v-6l18 -3v2", "key": "svg-5" }], ["path", { "d": "M8 12v-4l-4 -2", "key": "svg-6" }]]);

var IconCarCrane$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarCrane
});

var IconCarCrash = createReactComponent("outline", "car-crash", "IconCarCrash", [["path", { "d": "M10 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M7 6l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-5m0 -6h8m-6 0v-5m2 0h-4", "key": "svg-1" }], ["path", { "d": "M14 8v-2", "key": "svg-2" }], ["path", { "d": "M19 12h2", "key": "svg-3" }], ["path", { "d": "M17.5 15.5l1.5 1.5", "key": "svg-4" }], ["path", { "d": "M17.5 8.5l1.5 -1.5", "key": "svg-5" }]]);

var IconCarCrash$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarCrash
});

var IconCarFan1 = createReactComponent("outline", "car-fan-1", "IconCarFan1", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.424 15.03l-2.424 -3.03h6", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 17l2 -2v6", "key": "svg-4" }]]);

var IconCarFan1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarFan1
});

var IconCarFan2 = createReactComponent("outline", "car-fan-2", "IconCarFan2", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-4" }]]);

var IconCarFan2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarFan2
});

var IconCarFan3 = createReactComponent("outline", "car-fan-3", "IconCarFan3", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M18 15.5a.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a.5 .5 0 0 1 -.5 -.5", "key": "svg-4" }]]);

var IconCarFan3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarFan3
});

var IconCarFanAuto = createReactComponent("outline", "car-fan-auto", "IconCarFanAuto", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M14.044 14.624l-2.044 -2.624h4", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }], ["path", { "d": "M17 21v-4a2 2 0 1 1 4 0v4", "key": "svg-4" }], ["path", { "d": "M17 19h4", "key": "svg-5" }]]);

var IconCarFanAuto$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarFanAuto
});

var IconCarFan = createReactComponent("outline", "car-fan", "IconCarFan", [["path", { "d": "M12 12v-9l4.912 1.914a1.7 1.7 0 0 1 .428 2.925z", "key": "svg-0" }], ["path", { "d": "M12 12h9l-1.914 4.912a1.7 1.7 0 0 1 -2.925 .428z", "key": "svg-1" }], ["path", { "d": "M12 12h-9l1.914 -4.912a1.7 1.7 0 0 1 2.925 -.428z", "key": "svg-2" }], ["path", { "d": "M12 12v9l-4.912 -1.914a1.7 1.7 0 0 1 -.428 -2.925z", "key": "svg-3" }]]);

var IconCarFan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarFan
});

var IconCarGarage = createReactComponent("outline", "car-garage", "IconCarGarage", [["path", { "d": "M5 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 20h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5", "key": "svg-2" }], ["path", { "d": "M3 6l9 -4l9 4", "key": "svg-3" }]]);

var IconCarGarage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarGarage
});

var IconCarOff = createReactComponent("outline", "car-off", "IconCarOff", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M15.584 15.588a2 2 0 0 0 2.828 2.83", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-6l2 -5h1m4 0h4l4 5h1a2 2 0 0 1 2 2v4m-6 0h-6m-6 -6h8m4 0h3m-6 -3v-2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCarOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarOff
});

var IconCarSuv = createReactComponent("outline", "car-suv", "IconCarSuv", [["path", { "d": "M5 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16 17a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 9l2 -4h7.438a2 2 0 0 1 1.94 1.515l.622 2.485h3a2 2 0 0 1 2 2v3", "key": "svg-2" }], ["path", { "d": "M10 9v-4", "key": "svg-3" }], ["path", { "d": "M2 7v4", "key": "svg-4" }], ["path", { "d": "M22.001 14.001a4.992 4.992 0 0 0 -4.001 -2.001a4.992 4.992 0 0 0 -4 2h-3a4.998 4.998 0 0 0 -8.003 .003", "key": "svg-5" }], ["path", { "d": "M5 12v-3h13", "key": "svg-6" }]]);

var IconCarSuv$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarSuv
});

var IconCarTurbine = createReactComponent("outline", "car-turbine", "IconCarTurbine", [["path", { "d": "M11 13m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M18.86 11c.088 .66 .14 1.512 .14 2a8 8 0 1 1 -8 -8h6", "key": "svg-1" }], ["path", { "d": "M11 9c2.489 .108 4.489 .108 6 0", "key": "svg-2" }], ["path", { "d": "M17 3m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-3" }], ["path", { "d": "M11 13l-3.5 -1.5", "key": "svg-4" }], ["path", { "d": "M11 13l2.5 3", "key": "svg-5" }], ["path", { "d": "M8.5 16l2.5 -3", "key": "svg-6" }], ["path", { "d": "M11 13l3.5 -1.5", "key": "svg-7" }], ["path", { "d": "M11 9v4", "key": "svg-8" }]]);

var IconCarTurbine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarTurbine
});

var IconCar = createReactComponent("outline", "car", "IconCar", [["path", { "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5", "key": "svg-2" }]]);

var IconCar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCar
});

var IconCarambola = createReactComponent("outline", "carambola", "IconCarambola", [["path", { "d": "M17.286 21.09q -1.69 .001 -5.288 -2.615q -3.596 2.617 -5.288 2.616q -2.726 0 -.495 -6.8q -9.389 -6.775 2.135 -6.775h.076q 1.785 -5.516 3.574 -5.516q 1.785 0 3.574 5.516h.076q 11.525 0 2.133 6.774q 2.23 6.802 -.497 6.8", "key": "svg-0" }]]);

var IconCarambola$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarambola
});

var IconCaravan = createReactComponent("outline", "caravan", "IconCaravan", [["path", { "d": "M7 18a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-0" }], ["path", { "d": "M11 18h7a2 2 0 0 0 2 -2v-7a2 2 0 0 0 -2 -2h-9.5a5.5 5.5 0 0 0 -5.5 5.5v3.5a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M8 7l7 -3l1 3", "key": "svg-2" }], ["path", { "d": "M13 11m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v2a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z", "key": "svg-3" }], ["path", { "d": "M20 16h2", "key": "svg-4" }]]);

var IconCaravan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaravan
});

var IconCardboardsOff = createReactComponent("outline", "cardboards-off", "IconCardboardsOff", [["path", { "d": "M20.96 16.953c.026 -.147 .04 -.298 .04 -.453v-8.5a2 2 0 0 0 -2 -2h-9m-4 0h-1a2 2 0 0 0 -2 2v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06c.155 0 .307 -.014 .454 -.041", "key": "svg-0" }], ["path", { "d": "M8 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M16.714 12.7a1 1 0 0 0 -1.417 -1.411l1.417 1.41z", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCardboardsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCardboardsOff
});

var IconCardboards = createReactComponent("outline", "cardboards", "IconCardboards", [["path", { "d": "M3 8v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06a2.5 2.5 0 0 0 2.5 -2.5v-8.5a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2z", "key": "svg-0" }], ["path", { "d": "M8 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M16 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }]]);

var IconCardboards$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCardboards
});

var IconCards = createReactComponent("outline", "cards", "IconCards", [["path", { "d": "M3.604 7.197l7.138 -3.109a.96 .96 0 0 1 1.27 .527l4.924 11.902a1 1 0 0 1 -.514 1.304l-7.137 3.109a.96 .96 0 0 1 -1.271 -.527l-4.924 -11.903a1 1 0 0 1 .514 -1.304z", "key": "svg-0" }], ["path", { "d": "M15 4h1a1 1 0 0 1 1 1v3.5", "key": "svg-1" }], ["path", { "d": "M20 6c.264 .112 .52 .217 .768 .315a1 1 0 0 1 .53 1.311l-2.298 5.374", "key": "svg-2" }]]);

var IconCards$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCards
});

var IconCaretDown = createReactComponent("outline", "caret-down", "IconCaretDown", [["path", { "d": "M6 10l6 6l6 -6h-12", "key": "svg-0" }]]);

var IconCaretDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretDown
});

var IconCaretLeftRight = createReactComponent("outline", "caret-left-right", "IconCaretLeftRight", [["path", { "d": "M14 18l6 -6l-6 -6v12", "key": "svg-0" }], ["path", { "d": "M10 18l-6 -6l6 -6v12", "key": "svg-1" }]]);

var IconCaretLeftRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretLeftRight
});

var IconCaretLeft = createReactComponent("outline", "caret-left", "IconCaretLeft", [["path", { "d": "M14 6l-6 6l6 6v-12", "key": "svg-0" }]]);

var IconCaretLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretLeft
});

var IconCaretRight = createReactComponent("outline", "caret-right", "IconCaretRight", [["path", { "d": "M10 18l6 -6l-6 -6v12", "key": "svg-0" }]]);

var IconCaretRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretRight
});

var IconCaretUpDown = createReactComponent("outline", "caret-up-down", "IconCaretUpDown", [["path", { "d": "M18 10l-6 -6l-6 6h12", "key": "svg-0" }], ["path", { "d": "M18 14l-6 6l-6 -6h12", "key": "svg-1" }]]);

var IconCaretUpDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretUpDown
});

var IconCaretUp = createReactComponent("outline", "caret-up", "IconCaretUp", [["path", { "d": "M18 14l-6 -6l-6 6h12", "key": "svg-0" }]]);

var IconCaretUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCaretUp
});

var IconCarouselHorizontal = createReactComponent("outline", "carousel-horizontal", "IconCarouselHorizontal", [["path", { "d": "M7 5m0 1a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M22 17h-1a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h1", "key": "svg-1" }], ["path", { "d": "M2 17h1a1 1 0 0 0 1 -1v-8a1 1 0 0 0 -1 -1h-1", "key": "svg-2" }]]);

var IconCarouselHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarouselHorizontal
});

var IconCarouselVertical = createReactComponent("outline", "carousel-vertical", "IconCarouselVertical", [["path", { "d": "M19 8v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1z", "key": "svg-0" }], ["path", { "d": "M7 22v-1a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v1", "key": "svg-1" }], ["path", { "d": "M17 2v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1", "key": "svg-2" }]]);

var IconCarouselVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarouselVertical
});

var IconCarrotOff = createReactComponent("outline", "carrot-off", "IconCarrotOff", [["path", { "d": "M8.868 8.846c-2.756 3.382 -5.868 12.154 -5.868 12.154s8.75 -3.104 12.134 -5.85m1.667 -2.342a4.486 4.486 0 0 0 -5.589 -5.615", "key": "svg-0" }], ["path", { "d": "M9 13l-1.5 -1.5", "key": "svg-1" }], ["path", { "d": "M22 8s-1.14 -2 -3 -2c-1.406 0 -3 2 -3 2s1.14 2 3 2s3 -2 3 -2z", "key": "svg-2" }], ["path", { "d": "M16 2s-2 1.14 -2 3s2 3 2 3s2 -1.577 2 -3c0 -1.86 -2 -3 -2 -3z", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCarrotOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarrotOff
});

var IconCarrot = createReactComponent("outline", "carrot", "IconCarrot", [["path", { "d": "M3 21s9.834 -3.489 12.684 -6.34a4.487 4.487 0 0 0 0 -6.344a4.483 4.483 0 0 0 -6.342 0c-2.86 2.861 -6.347 12.689 -6.347 12.689z", "key": "svg-0" }], ["path", { "d": "M9 13l-1.5 -1.5", "key": "svg-1" }], ["path", { "d": "M16 14l-2 -2", "key": "svg-2" }], ["path", { "d": "M22 8s-1.14 -2 -3 -2c-1.406 0 -3 2 -3 2s1.14 2 3 2s3 -2 3 -2z", "key": "svg-3" }], ["path", { "d": "M16 2s-2 1.14 -2 3s2 3 2 3s2 -1.577 2 -3c0 -1.86 -2 -3 -2 -3z", "key": "svg-4" }]]);

var IconCarrot$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCarrot
});

var IconCashBanknoteOff = createReactComponent("outline", "cash-banknote-off", "IconCashBanknoteOff", [["path", { "d": "M9.88 9.878a3 3 0 1 0 4.242 4.243m.58 -3.425a3.012 3.012 0 0 0 -1.412 -1.405", "key": "svg-0" }], ["path", { "d": "M10 6h9a2 2 0 0 1 2 2v8c0 .294 -.064 .574 -.178 .825m-2.822 1.175h-13a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h1", "key": "svg-1" }], ["path", { "d": "M18 12l.01 0", "key": "svg-2" }], ["path", { "d": "M6 12l.01 0", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCashBanknoteOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCashBanknoteOff
});

var IconCashBanknote = createReactComponent("outline", "cash-banknote", "IconCashBanknote", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M18 12l.01 0", "key": "svg-2" }], ["path", { "d": "M6 12l.01 0", "key": "svg-3" }]]);

var IconCashBanknote$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCashBanknote
});

var IconCashOff = createReactComponent("outline", "cash-off", "IconCashOff", [["path", { "d": "M13 9h6a2 2 0 0 1 2 2v6m-2 2h-10a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12.582 12.59a2 2 0 0 0 2.83 2.826", "key": "svg-1" }], ["path", { "d": "M17 9v-2a2 2 0 0 0 -2 -2h-6m-4 0a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCashOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCashOff
});

var IconCashRegister = createReactComponent("outline", "cash-register", "IconCashRegister", [["path", { "d": "M21 15h-2.5c-.398 0 -.779 .158 -1.061 .439c-.281 .281 -.439 .663 -.439 1.061c0 .398 .158 .779 .439 1.061c.281 .281 .663 .439 1.061 .439h1c.398 0 .779 .158 1.061 .439c.281 .281 .439 .663 .439 1.061c0 .398 -.158 .779 -.439 1.061c-.281 .281 -.663 .439 -1.061 .439h-2.5", "key": "svg-0" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-1" }], ["path", { "d": "M13 21h-7c-.53 0 -1.039 -.211 -1.414 -.586c-.375 -.375 -.586 -.884 -.586 -1.414v-10c0 -.53 .211 -1.039 .586 -1.414c.375 -.375 .884 -.586 1.414 -.586h2m12 3.12v-1.12c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586h-2", "key": "svg-2" }], ["path", { "d": "M16 10v-6c0 -.53 -.211 -1.039 -.586 -1.414c-.375 -.375 -.884 -.586 -1.414 -.586h-4c-.53 0 -1.039 .211 -1.414 .586c-.375 .375 -.586 .884 -.586 1.414v6m8 0h-8m8 0h1m-9 0h-1", "key": "svg-3" }], ["path", { "d": "M8 14v.01", "key": "svg-4" }], ["path", { "d": "M8 17v.01", "key": "svg-5" }], ["path", { "d": "M12 13.99v.01", "key": "svg-6" }], ["path", { "d": "M12 17v.01", "key": "svg-7" }]]);

var IconCashRegister$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCashRegister
});

var IconCash = createReactComponent("outline", "cash", "IconCash", [["path", { "d": "M7 9m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M14 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M17 9v-2a2 2 0 0 0 -2 -2h-10a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2", "key": "svg-2" }]]);

var IconCash$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCash
});

var IconCastOff = createReactComponent("outline", "cast-off", "IconCastOff", [["path", { "d": "M3 19h.01", "key": "svg-0" }], ["path", { "d": "M7 19a4 4 0 0 0 -4 -4", "key": "svg-1" }], ["path", { "d": "M11 19a8 8 0 0 0 -8 -8", "key": "svg-2" }], ["path", { "d": "M15 19h3a3 3 0 0 0 .875 -.13m2 -2a3 3 0 0 0 .128 -.868v-8a3 3 0 0 0 -3 -3h-9m-3.865 .136a3 3 0 0 0 -1.935 1.864", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCastOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCastOff
});

var IconCast = createReactComponent("outline", "cast", "IconCast", [["path", { "d": "M3 19l.01 0", "key": "svg-0" }], ["path", { "d": "M7 19a4 4 0 0 0 -4 -4", "key": "svg-1" }], ["path", { "d": "M11 19a8 8 0 0 0 -8 -8", "key": "svg-2" }], ["path", { "d": "M15 19h3a3 3 0 0 0 3 -3v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -2.8 2", "key": "svg-3" }]]);

var IconCast$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCast
});

var IconCat = createReactComponent("outline", "cat", "IconCat", [["path", { "d": "M20 3v10a8 8 0 1 1 -16 0v-10l3.432 3.432a7.963 7.963 0 0 1 4.568 -1.432c1.769 0 3.403 .574 4.728 1.546l3.272 -3.546z", "key": "svg-0" }], ["path", { "d": "M2 16h5l-4 4", "key": "svg-1" }], ["path", { "d": "M22 16h-5l4 4", "key": "svg-2" }], ["path", { "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M9 11v.01", "key": "svg-4" }], ["path", { "d": "M15 11v.01", "key": "svg-5" }]]);

var IconCat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCat
});

var IconCategory2 = createReactComponent("outline", "category-2", "IconCategory2", [["path", { "d": "M14 4h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M4 14h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M7 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }]]);

var IconCategory2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCategory2
});

var IconCategoryMinus = createReactComponent("outline", "category-minus", "IconCategoryMinus", [["path", { "d": "M4 4h6v6h-6zm10 0h6v6h-6zm-10 10h6v6h-6zm10 3h6", "key": "svg-0" }]]);

var IconCategoryMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCategoryMinus
});

var IconCategoryPlus = createReactComponent("outline", "category-plus", "IconCategoryPlus", [["path", { "d": "M4 4h6v6h-6zm10 0h6v6h-6zm-10 10h6v6h-6zm10 3h6m-3 -3v6", "key": "svg-0" }]]);

var IconCategoryPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCategoryPlus
});

var IconCategory = createReactComponent("outline", "category", "IconCategory", [["path", { "d": "M4 4h6v6h-6z", "key": "svg-0" }], ["path", { "d": "M14 4h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M4 14h6v6h-6z", "key": "svg-2" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }]]);

var IconCategory$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCategory
});

var IconCeOff = createReactComponent("outline", "ce-off", "IconCeOff", [["path", { "d": "M6.53 6.53a6.001 6.001 0 0 0 2.47 11.47", "key": "svg-0" }], ["path", { "d": "M21 6a6 6 0 0 0 -5.927 5.061l.927 .939", "key": "svg-1" }], ["path", { "d": "M16 12h5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCeOff
});

var IconCe = createReactComponent("outline", "ce", "IconCe", [["path", { "d": "M9 6a6 6 0 1 0 0 12", "key": "svg-0" }], ["path", { "d": "M21 6a6 6 0 1 0 0 12", "key": "svg-1" }], ["path", { "d": "M15 12h6", "key": "svg-2" }]]);

var IconCe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCe
});

var IconCellSignal1 = createReactComponent("outline", "cell-signal-1", "IconCellSignal1", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }]]);

var IconCellSignal1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignal1
});

var IconCellSignal2 = createReactComponent("outline", "cell-signal-2", "IconCellSignal2", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M8 20v-5", "key": "svg-1" }]]);

var IconCellSignal2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignal2
});

var IconCellSignal3 = createReactComponent("outline", "cell-signal-3", "IconCellSignal3", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M12 20v-9", "key": "svg-1" }]]);

var IconCellSignal3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignal3
});

var IconCellSignal4 = createReactComponent("outline", "cell-signal-4", "IconCellSignal4", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M16 7v13", "key": "svg-1" }]]);

var IconCellSignal4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignal4
});

var IconCellSignal5 = createReactComponent("outline", "cell-signal-5", "IconCellSignal5", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a.731 .731 0 0 1 1.249 .517v15.269z", "key": "svg-0" }], ["path", { "d": "M16 7v13", "key": "svg-1" }], ["path", { "d": "M12 20v-9", "key": "svg-2" }], ["path", { "d": "M8 20v-5", "key": "svg-3" }]]);

var IconCellSignal5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignal5
});

var IconCellSignalOff = createReactComponent("outline", "cell-signal-off", "IconCellSignalOff", [["path", { "d": "M20 20h-15.269a.731 .731 0 0 1 -.517 -1.249l7.265 -7.264m2 -2l5.272 -5.272a.731 .731 0 0 1 1.249 .517v11.269", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCellSignalOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCellSignalOff
});

var IconCell = createReactComponent("outline", "cell", "IconCell", [["path", { "d": "M8 4l-4 2v5l4 2l4 -2v-5z", "key": "svg-0" }], ["path", { "d": "M12 11l4 2l4 -2v-5l-4 -2l-4 2", "key": "svg-1" }], ["path", { "d": "M8 13v5l4 2l4 -2v-5", "key": "svg-2" }]]);

var IconCell$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCell
});

var IconCertificate2Off = createReactComponent("outline", "certificate-2-off", "IconCertificate2Off", [["path", { "d": "M12 12a3 3 0 1 0 3 3", "key": "svg-0" }], ["path", { "d": "M11 7h3", "key": "svg-1" }], ["path", { "d": "M10 18v4l2 -1l2 1v-4", "key": "svg-2" }], ["path", { "d": "M10 19h-2a2 2 0 0 1 -2 -2v-11m1.18 -2.825c.25 -.112 .529 -.175 .82 -.175h8a2 2 0 0 1 2 2v9m-.175 3.82a2 2 0 0 1 -1.825 1.18h-2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCertificate2Off$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCertificate2Off
});

var IconCertificate2 = createReactComponent("outline", "certificate-2", "IconCertificate2", [["path", { "d": "M12 15m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M10 7h4", "key": "svg-1" }], ["path", { "d": "M10 18v4l2 -1l2 1v-4", "key": "svg-2" }], ["path", { "d": "M10 19h-2a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-2", "key": "svg-3" }]]);

var IconCertificate2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCertificate2
});

var IconCertificateOff = createReactComponent("outline", "certificate-off", "IconCertificateOff", [["path", { "d": "M12.876 12.881a3 3 0 0 0 4.243 4.243m.588 -3.42a3.012 3.012 0 0 0 -1.437 -1.423", "key": "svg-0" }], ["path", { "d": "M13 17.5v4.5l2 -1.5l2 1.5v-4.5", "key": "svg-1" }], ["path", { "d": "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2m4 0h10a2 2 0 0 1 2 2v10", "key": "svg-2" }], ["path", { "d": "M6 9h3m4 0h5", "key": "svg-3" }], ["path", { "d": "M6 12h3", "key": "svg-4" }], ["path", { "d": "M6 15h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCertificateOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCertificateOff
});

var IconCertificate = createReactComponent("outline", "certificate", "IconCertificate", [["path", { "d": "M15 15m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M13 17.5v4.5l2 -1.5l2 1.5v-4.5", "key": "svg-1" }], ["path", { "d": "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -1 1.73", "key": "svg-2" }], ["path", { "d": "M6 9l12 0", "key": "svg-3" }], ["path", { "d": "M6 12l3 0", "key": "svg-4" }], ["path", { "d": "M6 15l2 0", "key": "svg-5" }]]);

var IconCertificate$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCertificate
});

var IconChairDirector = createReactComponent("outline", "chair-director", "IconChairDirector", [["path", { "d": "M6 21l12 -9", "key": "svg-0" }], ["path", { "d": "M6 12l12 9", "key": "svg-1" }], ["path", { "d": "M5 12h14", "key": "svg-2" }], ["path", { "d": "M6 3v9", "key": "svg-3" }], ["path", { "d": "M18 3v9", "key": "svg-4" }], ["path", { "d": "M6 8h12", "key": "svg-5" }], ["path", { "d": "M6 5h12", "key": "svg-6" }]]);

var IconChairDirector$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChairDirector
});

var IconChalkboardOff = createReactComponent("outline", "chalkboard-off", "IconChalkboardOff", [["path", { "d": "M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2m4 0h10a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M17 17v1a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h4", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChalkboardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChalkboardOff
});

var IconChalkboard = createReactComponent("outline", "chalkboard", "IconChalkboard", [["path", { "d": "M8 19h-3a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v11a1 1 0 0 1 -1 1", "key": "svg-0" }], ["path", { "d": "M11 16m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }]]);

var IconChalkboard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChalkboard
});

var IconChargingPile = createReactComponent("outline", "charging-pile", "IconChargingPile", [["path", { "d": "M18 7l-1 1", "key": "svg-0" }], ["path", { "d": "M14 11h1a2 2 0 0 1 2 2v3a1.5 1.5 0 0 0 3 0v-7l-3 -3", "key": "svg-1" }], ["path", { "d": "M4 20v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v14", "key": "svg-2" }], ["path", { "d": "M9 11.5l-1.5 2.5h3l-1.5 2.5", "key": "svg-3" }], ["path", { "d": "M3 20l12 0", "key": "svg-4" }], ["path", { "d": "M4 8l10 0", "key": "svg-5" }]]);

var IconChargingPile$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChargingPile
});

var IconChartArcs3 = createReactComponent("outline", "chart-arcs-3", "IconChartArcs3", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M7 12a5 5 0 1 0 5 -5", "key": "svg-1" }], ["path", { "d": "M6.29 18.957a9 9 0 1 0 5.71 -15.957", "key": "svg-2" }]]);

var IconChartArcs3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartArcs3
});

var IconChartArcs = createReactComponent("outline", "chart-arcs", "IconChartArcs", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M16.924 11.132a5 5 0 1 0 -4.056 5.792", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 9 -9", "key": "svg-2" }]]);

var IconChartArcs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartArcs
});

var IconChartAreaLine = createReactComponent("outline", "chart-area-line", "IconChartAreaLine", [["path", { "d": "M4 19l4 -6l4 2l4 -5l4 4l0 5l-16 0", "key": "svg-0" }], ["path", { "d": "M4 12l3 -4l4 2l5 -6l4 4", "key": "svg-1" }]]);

var IconChartAreaLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartAreaLine
});

var IconChartArea = createReactComponent("outline", "chart-area", "IconChartArea", [["path", { "d": "M4 19l16 0", "key": "svg-0" }], ["path", { "d": "M4 15l4 -6l4 2l4 -5l4 4l0 5l-16 0", "key": "svg-1" }]]);

var IconChartArea$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartArea
});

var IconChartArrowsVertical = createReactComponent("outline", "chart-arrows-vertical", "IconChartArrowsVertical", [["path", { "d": "M18 21v-14", "key": "svg-0" }], ["path", { "d": "M9 15l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M15 10l3 -3l3 3", "key": "svg-2" }], ["path", { "d": "M3 21l18 0", "key": "svg-3" }], ["path", { "d": "M12 21l0 -9", "key": "svg-4" }], ["path", { "d": "M3 6l3 -3l3 3", "key": "svg-5" }], ["path", { "d": "M6 21v-18", "key": "svg-6" }]]);

var IconChartArrowsVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartArrowsVertical
});

var IconChartArrows = createReactComponent("outline", "chart-arrows", "IconChartArrows", [["path", { "d": "M3 18l14 0", "key": "svg-0" }], ["path", { "d": "M9 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M14 15l3 3l-3 3", "key": "svg-2" }], ["path", { "d": "M3 3l0 18", "key": "svg-3" }], ["path", { "d": "M3 12l9 0", "key": "svg-4" }], ["path", { "d": "M18 3l3 3l-3 3", "key": "svg-5" }], ["path", { "d": "M3 6l18 0", "key": "svg-6" }]]);

var IconChartArrows$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartArrows
});

var IconChartBarOff = createReactComponent("outline", "chart-bar-off", "IconChartBarOff", [["path", { "d": "M3 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 8h2a1 1 0 0 1 1 1v2m0 4v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-10", "key": "svg-1" }], ["path", { "d": "M15 11v-6a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v12m-1 3h-4a1 1 0 0 1 -1 -1v-4", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconChartBarOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartBarOff
});

var IconChartBarPopular = createReactComponent("outline", "chart-bar-popular", "IconChartBarPopular", [["path", { "d": "M3 13a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 9a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M15 5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }]]);

var IconChartBarPopular$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartBarPopular
});

var IconChartBar = createReactComponent("outline", "chart-bar", "IconChartBar", [["path", { "d": "M3 13a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M15 9a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M9 5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z", "key": "svg-2" }], ["path", { "d": "M4 20h14", "key": "svg-3" }]]);

var IconChartBar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartBar
});

var IconChartBubble = createReactComponent("outline", "chart-bubble", "IconChartBubble", [["path", { "d": "M6 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M16 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14.5 7.5m-4.5 0a4.5 4.5 0 1 0 9 0a4.5 4.5 0 1 0 -9 0", "key": "svg-2" }]]);

var IconChartBubble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartBubble
});

var IconChartCandle = createReactComponent("outline", "chart-candle", "IconChartCandle", [["path", { "d": "M4 6m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M6 4l0 2", "key": "svg-1" }], ["path", { "d": "M6 11l0 9", "key": "svg-2" }], ["path", { "d": "M10 14m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-3" }], ["path", { "d": "M12 4l0 10", "key": "svg-4" }], ["path", { "d": "M12 19l0 1", "key": "svg-5" }], ["path", { "d": "M16 5m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z", "key": "svg-6" }], ["path", { "d": "M18 4l0 1", "key": "svg-7" }], ["path", { "d": "M18 11l0 9", "key": "svg-8" }]]);

var IconChartCandle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartCandle
});

var IconChartCircles = createReactComponent("outline", "chart-circles", "IconChartCircles", [["path", { "d": "M9.5 9.5m-5.5 0a5.5 5.5 0 1 0 11 0a5.5 5.5 0 1 0 -11 0", "key": "svg-0" }], ["path", { "d": "M14.5 14.5m-5.5 0a5.5 5.5 0 1 0 11 0a5.5 5.5 0 1 0 -11 0", "key": "svg-1" }]]);

var IconChartCircles$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartCircles
});

var IconChartCohort = createReactComponent("outline", "chart-cohort", "IconChartCohort", [["path", { "d": "M3 9h18v-6h-18v18h6v-18", "key": "svg-0" }], ["path", { "d": "M3 15h12v-12", "key": "svg-1" }]]);

var IconChartCohort$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartCohort
});

var IconChartColumn = createReactComponent("outline", "chart-column", "IconChartColumn", [["path", { "d": "M4 20h3", "key": "svg-0" }], ["path", { "d": "M17 20h3", "key": "svg-1" }], ["path", { "d": "M10.5 20h3", "key": "svg-2" }], ["path", { "d": "M4 16h3", "key": "svg-3" }], ["path", { "d": "M17 16h3", "key": "svg-4" }], ["path", { "d": "M10.5 16h3", "key": "svg-5" }], ["path", { "d": "M4 12h3", "key": "svg-6" }], ["path", { "d": "M17 12h3", "key": "svg-7" }], ["path", { "d": "M10.5 12h3", "key": "svg-8" }], ["path", { "d": "M4 8h3", "key": "svg-9" }], ["path", { "d": "M17 8h3", "key": "svg-10" }], ["path", { "d": "M4 4h3", "key": "svg-11" }]]);

var IconChartColumn$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartColumn
});

var IconChartCovariate = createReactComponent("outline", "chart-covariate", "IconChartCovariate", [["path", { "d": "M18 11h.009", "key": "svg-0" }], ["path", { "d": "M14 15h.009", "key": "svg-1" }], ["path", { "d": "M12 6h.009", "key": "svg-2" }], ["path", { "d": "M8 10h.009", "key": "svg-3" }], ["path", { "d": "M3 21l17 -17", "key": "svg-4" }], ["path", { "d": "M3 3v18h18", "key": "svg-5" }]]);

var IconChartCovariate$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartCovariate
});

var IconChartDonut2 = createReactComponent("outline", "chart-donut-2", "IconChartDonut2", [["path", { "d": "M12 3v5m4 4h5", "key": "svg-0" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconChartDonut2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDonut2
});

var IconChartDonut3 = createReactComponent("outline", "chart-donut-3", "IconChartDonut3", [["path", { "d": "M12 3v5m4 4h5", "key": "svg-0" }], ["path", { "d": "M8.929 14.582l-3.429 2.918", "key": "svg-1" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-3" }]]);

var IconChartDonut3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDonut3
});

var IconChartDonut4 = createReactComponent("outline", "chart-donut-4", "IconChartDonut4", [["path", { "d": "M8.848 14.667l-3.348 2.833", "key": "svg-0" }], ["path", { "d": "M12 3v5m4 4h5", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M14.219 15.328l2.781 4.172", "key": "svg-3" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-4" }]]);

var IconChartDonut4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDonut4
});

var IconChartDonut = createReactComponent("outline", "chart-donut", "IconChartDonut", [["path", { "d": "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-3.8a4.1 4.1 0 1 1 -5 -5v-4a.9 .9 0 0 0 -1 -.8", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a9 9 0 0 0 -1 -1v-4.5", "key": "svg-1" }]]);

var IconChartDonut$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDonut
});

var IconChartDots2 = createReactComponent("outline", "chart-dots-2", "IconChartDots2", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M13 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M21 3l-6 1.5", "key": "svg-4" }], ["path", { "d": "M14.113 6.65l2.771 3.695", "key": "svg-5" }], ["path", { "d": "M16 12.5l-5 2", "key": "svg-6" }]]);

var IconChartDots2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDots2
});

var IconChartDots3 = createReactComponent("outline", "chart-dots-3", "IconChartDots3", [["path", { "d": "M5 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M16 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M18 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M6 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M9 17l5 -1.5", "key": "svg-4" }], ["path", { "d": "M6.5 8.5l7.81 5.37", "key": "svg-5" }], ["path", { "d": "M7 7l8 -1", "key": "svg-6" }]]);

var IconChartDots3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDots3
});

var IconChartDots = createReactComponent("outline", "chart-dots", "IconChartDots", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M9 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M10.16 10.62l2.34 2.88", "key": "svg-4" }], ["path", { "d": "M15.088 13.328l2.837 -4.586", "key": "svg-5" }]]);

var IconChartDots$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartDots
});

var IconChartFunnel = createReactComponent("outline", "chart-funnel", "IconChartFunnel", [["path", { "d": "M4.387 3h15.226a1 1 0 0 1 .948 1.316l-5.105 15.316a2 2 0 0 1 -1.898 1.368h-3.116a2 2 0 0 1 -1.898 -1.368l-5.104 -15.316a1 1 0 0 1 .947 -1.316", "key": "svg-0" }], ["path", { "d": "M5 9h14", "key": "svg-1" }], ["path", { "d": "M7 15h10", "key": "svg-2" }]]);

var IconChartFunnel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartFunnel
});

var IconChartGridDots = createReactComponent("outline", "chart-grid-dots", "IconChartGridDots", [["path", { "d": "M18 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M6 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M8 18h8", "key": "svg-4" }], ["path", { "d": "M18 20v1", "key": "svg-5" }], ["path", { "d": "M18 3v1", "key": "svg-6" }], ["path", { "d": "M6 20v1", "key": "svg-7" }], ["path", { "d": "M6 10v-7", "key": "svg-8" }], ["path", { "d": "M12 3v18", "key": "svg-9" }], ["path", { "d": "M18 8v8", "key": "svg-10" }], ["path", { "d": "M8 12h13", "key": "svg-11" }], ["path", { "d": "M21 6h-1", "key": "svg-12" }], ["path", { "d": "M16 6h-13", "key": "svg-13" }], ["path", { "d": "M3 12h1", "key": "svg-14" }], ["path", { "d": "M20 18h1", "key": "svg-15" }], ["path", { "d": "M3 18h1", "key": "svg-16" }], ["path", { "d": "M6 14v2", "key": "svg-17" }]]);

var IconChartGridDots$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartGridDots
});

var IconChartHistogram = createReactComponent("outline", "chart-histogram", "IconChartHistogram", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M20 18v3", "key": "svg-1" }], ["path", { "d": "M16 16v5", "key": "svg-2" }], ["path", { "d": "M12 13v8", "key": "svg-3" }], ["path", { "d": "M8 16v5", "key": "svg-4" }], ["path", { "d": "M3 11c6 0 5 -5 9 -5s3 5 9 5", "key": "svg-5" }]]);

var IconChartHistogram$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartHistogram
});

var IconChartInfographic = createReactComponent("outline", "chart-infographic", "IconChartInfographic", [["path", { "d": "M7 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M7 3v4h4", "key": "svg-1" }], ["path", { "d": "M9 17l0 4", "key": "svg-2" }], ["path", { "d": "M17 14l0 7", "key": "svg-3" }], ["path", { "d": "M13 13l0 8", "key": "svg-4" }], ["path", { "d": "M21 12l0 9", "key": "svg-5" }]]);

var IconChartInfographic$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartInfographic
});

var IconChartLine = createReactComponent("outline", "chart-line", "IconChartLine", [["path", { "d": "M4 19l16 0", "key": "svg-0" }], ["path", { "d": "M4 15l4 -6l4 2l4 -5l4 4", "key": "svg-1" }]]);

var IconChartLine$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartLine
});

var IconChartPie2 = createReactComponent("outline", "chart-pie-2", "IconChartPie2", [["path", { "d": "M12 3v9h9", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconChartPie2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPie2
});

var IconChartPie3 = createReactComponent("outline", "chart-pie-3", "IconChartPie3", [["path", { "d": "M12 12l-6.5 5.5", "key": "svg-0" }], ["path", { "d": "M12 3v9h9", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconChartPie3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPie3
});

var IconChartPie4 = createReactComponent("outline", "chart-pie-4", "IconChartPie4", [["path", { "d": "M12 12l-6.5 5.5", "key": "svg-0" }], ["path", { "d": "M12 3v9h9", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M12 12l5 7.5", "key": "svg-3" }]]);

var IconChartPie4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPie4
});

var IconChartPieOff = createReactComponent("outline", "chart-pie-off", "IconChartPieOff", [["path", { "d": "M5.63 5.643a9 9 0 0 0 12.742 12.715m1.674 -2.29a9.03 9.03 0 0 0 .754 -2.068a1 1 0 0 0 -1 -1h-2.8m-4 0a2 2 0 0 1 -2 -2m0 -4v-3a.9 .9 0 0 0 -1 -.8a9 9 0 0 0 -2.057 .749", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChartPieOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPieOff
});

var IconChartPie = createReactComponent("outline", "chart-pie", "IconChartPie", [["path", { "d": "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-6.8a2 2 0 0 1 -2 -2v-7a.9 .9 0 0 0 -1 -.8", "key": "svg-0" }], ["path", { "d": "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5", "key": "svg-1" }]]);

var IconChartPie$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPie
});

var IconChartPpf = createReactComponent("outline", "chart-ppf", "IconChartPpf", [["path", { "d": "M19 17c0 -6.075 -5.373 -11 -12 -11", "key": "svg-0" }], ["path", { "d": "M3 3v18h18", "key": "svg-1" }]]);

var IconChartPpf$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartPpf
});

var IconChartRadar = createReactComponent("outline", "chart-radar", "IconChartRadar", [["path", { "d": "M12 3l9.5 7l-3.5 11h-12l-3.5 -11z", "key": "svg-0" }], ["path", { "d": "M12 7.5l5.5 4l-2.5 5.5h-6.5l-2 -5.5z", "key": "svg-1" }], ["path", { "d": "M2.5 10l9.5 3l9.5 -3", "key": "svg-2" }], ["path", { "d": "M12 3v10l6 8", "key": "svg-3" }], ["path", { "d": "M6 21l6 -8", "key": "svg-4" }]]);

var IconChartRadar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartRadar
});

var IconChartSankey = createReactComponent("outline", "chart-sankey", "IconChartSankey", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M3 6h18", "key": "svg-1" }], ["path", { "d": "M3 8c10 0 8 9 18 9", "key": "svg-2" }]]);

var IconChartSankey$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartSankey
});

var IconChartScatter3d = createReactComponent("outline", "chart-scatter-3d", "IconChartScatter3d", [["path", { "d": "M3 20l9 -7", "key": "svg-0" }], ["path", { "d": "M12 3v10l9 7", "key": "svg-1" }], ["path", { "d": "M17 12v.015", "key": "svg-2" }], ["path", { "d": "M17 4.015v.015", "key": "svg-3" }], ["path", { "d": "M21 8.015v.015", "key": "svg-4" }], ["path", { "d": "M12 19.015v.015", "key": "svg-5" }], ["path", { "d": "M3 12.015v.015", "key": "svg-6" }], ["path", { "d": "M7 8.015v.015", "key": "svg-7" }], ["path", { "d": "M3 4.015v.015", "key": "svg-8" }]]);

var IconChartScatter3d$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartScatter3d
});

var IconChartScatter = createReactComponent("outline", "chart-scatter", "IconChartScatter", [["path", { "d": "M3 3v18h18", "key": "svg-0" }], ["path", { "d": "M8 15.015v.015", "key": "svg-1" }], ["path", { "d": "M16 16.015v.015", "key": "svg-2" }], ["path", { "d": "M8 7.03v.015", "key": "svg-3" }], ["path", { "d": "M12 11.03v.015", "key": "svg-4" }], ["path", { "d": "M19 11.03v.015", "key": "svg-5" }]]);

var IconChartScatter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartScatter
});

var IconChartTreemap = createReactComponent("outline", "chart-treemap", "IconChartTreemap", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M12 4v16", "key": "svg-1" }], ["path", { "d": "M4 15h8", "key": "svg-2" }], ["path", { "d": "M12 12h8", "key": "svg-3" }], ["path", { "d": "M16 12v8", "key": "svg-4" }], ["path", { "d": "M16 16h4", "key": "svg-5" }]]);

var IconChartTreemap$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChartTreemap
});

var IconCheck = createReactComponent("outline", "check", "IconCheck", [["path", { "d": "M5 12l5 5l10 -10", "key": "svg-0" }]]);

var IconCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCheck
});

var IconCheckbox = createReactComponent("outline", "checkbox", "IconCheckbox", [["path", { "d": "M9 11l3 3l8 -8", "key": "svg-0" }], ["path", { "d": "M20 12v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h9", "key": "svg-1" }]]);

var IconCheckbox$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCheckbox
});

var IconChecklist = createReactComponent("outline", "checklist", "IconChecklist", [["path", { "d": "M9.615 20h-2.615a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M14 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M9 8h4", "key": "svg-2" }], ["path", { "d": "M9 12h2", "key": "svg-3" }]]);

var IconChecklist$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChecklist
});

var IconChecks = createReactComponent("outline", "checks", "IconChecks", [["path", { "d": "M7 12l5 5l10 -10", "key": "svg-0" }], ["path", { "d": "M2 12l5 5m5 -5l5 -5", "key": "svg-1" }]]);

var IconChecks$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChecks
});

var IconCheckupList = createReactComponent("outline", "checkup-list", "IconCheckupList", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 14h.01", "key": "svg-2" }], ["path", { "d": "M9 17h.01", "key": "svg-3" }], ["path", { "d": "M12 16l1 1l3 -3", "key": "svg-4" }]]);

var IconCheckupList$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCheckupList
});

var IconCheese = createReactComponent("outline", "cheese", "IconCheese", [["path", { "d": "M4.519 20.008l16.481 -.008v-3.5a2 2 0 1 1 0 -4v-3.5h-16.722", "key": "svg-0" }], ["path", { "d": "M21 9l-9.385 -4.992c-2.512 .12 -4.758 1.42 -6.327 3.425c-1.423 1.82 -2.288 4.221 -2.288 6.854c0 2.117 .56 4.085 1.519 5.721", "key": "svg-1" }], ["path", { "d": "M15 13v.01", "key": "svg-2" }], ["path", { "d": "M8 13v.01", "key": "svg-3" }], ["path", { "d": "M11 16v.01", "key": "svg-4" }]]);

var IconCheese$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCheese
});

var IconChefHatOff = createReactComponent("outline", "chef-hat-off", "IconChefHatOff", [["path", { "d": "M8.72 4.712a4 4 0 0 1 7.19 1.439a4 4 0 0 1 2.09 7.723v.126m0 4v3h-12v-7.126a4 4 0 0 1 .081 -7.796", "key": "svg-0" }], ["path", { "d": "M6.161 17.009l10.839 -.009", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChefHatOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChefHatOff
});

var IconChefHat = createReactComponent("outline", "chef-hat", "IconChefHat", [["path", { "d": "M12 3c1.918 0 3.52 1.35 3.91 3.151a4 4 0 0 1 2.09 7.723l0 7.126h-12v-7.126a4 4 0 1 1 2.092 -7.723a4 4 0 0 1 3.908 -3.151z", "key": "svg-0" }], ["path", { "d": "M6.161 17.009l11.839 -.009", "key": "svg-1" }]]);

var IconChefHat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChefHat
});

var IconCherry = createReactComponent("outline", "cherry", "IconCherry", [["path", { "d": "M7.5 16.5m-3.5 0a3.5 3.5 0 1 0 7 0a3.5 3.5 0 1 0 -7 0", "key": "svg-0" }], ["path", { "d": "M17 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M9 13c.366 -2 1.866 -3.873 4.5 -5.6", "key": "svg-2" }], ["path", { "d": "M17 15c-1.333 -2.333 -2.333 -5.333 -1 -9", "key": "svg-3" }], ["path", { "d": "M5 6c3.667 -2.667 7.333 -2.667 11 0c-3.667 2.667 -7.333 2.667 -11 0", "key": "svg-4" }]]);

var IconCherry$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCherry
});

var IconChessBishop = createReactComponent("outline", "chess-bishop", "IconChessBishop", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M12 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M9.5 16c-1.667 0 -2.5 -1.669 -2.5 -3c0 -3.667 1.667 -6 5 -7c3.333 1 5 3.427 5 7c0 1.284 -.775 2.881 -2.325 3l-.175 0h-5z", "key": "svg-2" }], ["path", { "d": "M15 8l-3 3", "key": "svg-3" }], ["path", { "d": "M12 5v1", "key": "svg-4" }]]);

var IconChessBishop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChessBishop
});

var IconChessKing = createReactComponent("outline", "chess-king", "IconChessKing", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M8.5 16a3.5 3.5 0 1 1 3.163 -5h.674a3.5 3.5 0 1 1 3.163 5z", "key": "svg-1" }], ["path", { "d": "M9 6h6", "key": "svg-2" }], ["path", { "d": "M12 3v8", "key": "svg-3" }]]);

var IconChessKing$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChessKing
});

var IconChessKnight = createReactComponent("outline", "chess-knight", "IconChessKnight", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M9 3l1 3l-3.491 2.148a1 1 0 0 0 .524 1.852h2.967l-2.073 6h7.961l.112 -5c0 -3 -1.09 -5.983 -4 -7c-1.94 -.678 -2.94 -1.011 -3 -1z", "key": "svg-1" }]]);

var IconChessKnight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChessKnight
});

var IconChessQueen = createReactComponent("outline", "chess-queen", "IconChessQueen", [["path", { "d": "M16 16l2 -11l-4 4l-2 -5l-2 5l-4 -4l2 11", "key": "svg-0" }], ["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-1" }], ["path", { "d": "M12 4m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["path", { "d": "M6 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-3" }], ["path", { "d": "M18 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-4" }]]);

var IconChessQueen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChessQueen
});

var IconChessRook = createReactComponent("outline", "chess-rook", "IconChessRook", [["path", { "d": "M8 16l-1.447 .724a1 1 0 0 0 -.553 .894v2.382h12v-2.382a1 1 0 0 0 -.553 -.894l-1.447 -.724h-8z", "key": "svg-0" }], ["path", { "d": "M8 16l1 -9h6l1 9", "key": "svg-1" }], ["path", { "d": "M6 4l.5 3h11l.5 -3", "key": "svg-2" }], ["path", { "d": "M10 4v3", "key": "svg-3" }], ["path", { "d": "M14 4v3", "key": "svg-4" }]]);

var IconChessRook$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChessRook
});

var IconChess = createReactComponent("outline", "chess", "IconChess", [["path", { "d": "M12 3a3 3 0 0 1 3 3c0 1.113 -.6 2.482 -1.5 3l1.5 7h-6l1.5 -7c-.9 -.518 -1.5 -1.887 -1.5 -3a3 3 0 0 1 3 -3z", "key": "svg-0" }], ["path", { "d": "M8 9h8", "key": "svg-1" }], ["path", { "d": "M6.684 16.772a1 1 0 0 0 -.684 .949v1.279a1 1 0 0 0 1 1h10a1 1 0 0 0 1 -1v-1.28a1 1 0 0 0 -.684 -.948l-2.316 -.772h-6l-2.316 .772z", "key": "svg-2" }]]);

var IconChess$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChess
});

var IconChevronCompactDown = createReactComponent("outline", "chevron-compact-down", "IconChevronCompactDown", [["path", { "d": "M4 11l8 3l8 -3", "key": "svg-0" }]]);

var IconChevronCompactDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronCompactDown
});

var IconChevronCompactLeft = createReactComponent("outline", "chevron-compact-left", "IconChevronCompactLeft", [["path", { "d": "M13 20l-3 -8l3 -8", "key": "svg-0" }]]);

var IconChevronCompactLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronCompactLeft
});

var IconChevronCompactRight = createReactComponent("outline", "chevron-compact-right", "IconChevronCompactRight", [["path", { "d": "M11 4l3 8l-3 8", "key": "svg-0" }]]);

var IconChevronCompactRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronCompactRight
});

var IconChevronCompactUp = createReactComponent("outline", "chevron-compact-up", "IconChevronCompactUp", [["path", { "d": "M4 13l8 -3l8 3", "key": "svg-0" }]]);

var IconChevronCompactUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronCompactUp
});

var IconChevronDownLeft = createReactComponent("outline", "chevron-down-left", "IconChevronDownLeft", [["path", { "d": "M8 8v8h8", "key": "svg-0" }]]);

var IconChevronDownLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronDownLeft
});

var IconChevronDownRight = createReactComponent("outline", "chevron-down-right", "IconChevronDownRight", [["path", { "d": "M16 8v8h-8", "key": "svg-0" }]]);

var IconChevronDownRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronDownRight
});

var IconChevronDown = createReactComponent("outline", "chevron-down", "IconChevronDown", [["path", { "d": "M6 9l6 6l6 -6", "key": "svg-0" }]]);

var IconChevronDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronDown
});

var IconChevronLeftPipe = createReactComponent("outline", "chevron-left-pipe", "IconChevronLeftPipe", [["path", { "d": "M7 6v12", "key": "svg-0" }], ["path", { "d": "M18 6l-6 6l6 6", "key": "svg-1" }]]);

var IconChevronLeftPipe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronLeftPipe
});

var IconChevronLeft = createReactComponent("outline", "chevron-left", "IconChevronLeft", [["path", { "d": "M15 6l-6 6l6 6", "key": "svg-0" }]]);

var IconChevronLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronLeft
});

var IconChevronRightPipe = createReactComponent("outline", "chevron-right-pipe", "IconChevronRightPipe", [["path", { "d": "M6 6l6 6l-6 6", "key": "svg-0" }], ["path", { "d": "M17 5v13", "key": "svg-1" }]]);

var IconChevronRightPipe$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronRightPipe
});

var IconChevronRight = createReactComponent("outline", "chevron-right", "IconChevronRight", [["path", { "d": "M9 6l6 6l-6 6", "key": "svg-0" }]]);

var IconChevronRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronRight
});

var IconChevronUpLeft = createReactComponent("outline", "chevron-up-left", "IconChevronUpLeft", [["path", { "d": "M8 16v-8h8", "key": "svg-0" }]]);

var IconChevronUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronUpLeft
});

var IconChevronUpRight = createReactComponent("outline", "chevron-up-right", "IconChevronUpRight", [["path", { "d": "M8 8h8v8", "key": "svg-0" }]]);

var IconChevronUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronUpRight
});

var IconChevronUp = createReactComponent("outline", "chevron-up", "IconChevronUp", [["path", { "d": "M6 15l6 -6l6 6", "key": "svg-0" }]]);

var IconChevronUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronUp
});

var IconChevronsDownLeft = createReactComponent("outline", "chevrons-down-left", "IconChevronsDownLeft", [["path", { "d": "M11 5v8h8", "key": "svg-0" }], ["path", { "d": "M7 9v8h8", "key": "svg-1" }]]);

var IconChevronsDownLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsDownLeft
});

var IconChevronsDownRight = createReactComponent("outline", "chevrons-down-right", "IconChevronsDownRight", [["path", { "d": "M13 5v8h-8", "key": "svg-0" }], ["path", { "d": "M17 9v8h-8", "key": "svg-1" }]]);

var IconChevronsDownRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsDownRight
});

var IconChevronsDown = createReactComponent("outline", "chevrons-down", "IconChevronsDown", [["path", { "d": "M7 7l5 5l5 -5", "key": "svg-0" }], ["path", { "d": "M7 13l5 5l5 -5", "key": "svg-1" }]]);

var IconChevronsDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsDown
});

var IconChevronsLeft = createReactComponent("outline", "chevrons-left", "IconChevronsLeft", [["path", { "d": "M11 7l-5 5l5 5", "key": "svg-0" }], ["path", { "d": "M17 7l-5 5l5 5", "key": "svg-1" }]]);

var IconChevronsLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsLeft
});

var IconChevronsRight = createReactComponent("outline", "chevrons-right", "IconChevronsRight", [["path", { "d": "M7 7l5 5l-5 5", "key": "svg-0" }], ["path", { "d": "M13 7l5 5l-5 5", "key": "svg-1" }]]);

var IconChevronsRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsRight
});

var IconChevronsUpLeft = createReactComponent("outline", "chevrons-up-left", "IconChevronsUpLeft", [["path", { "d": "M7 15v-8h8", "key": "svg-0" }], ["path", { "d": "M11 19v-8h8", "key": "svg-1" }]]);

var IconChevronsUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsUpLeft
});

var IconChevronsUpRight = createReactComponent("outline", "chevrons-up-right", "IconChevronsUpRight", [["path", { "d": "M9 7h8v8", "key": "svg-0" }], ["path", { "d": "M5 11h8v8", "key": "svg-1" }]]);

var IconChevronsUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsUpRight
});

var IconChevronsUp = createReactComponent("outline", "chevrons-up", "IconChevronsUp", [["path", { "d": "M7 11l5 -5l5 5", "key": "svg-0" }], ["path", { "d": "M7 17l5 -5l5 5", "key": "svg-1" }]]);

var IconChevronsUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChevronsUp
});

var IconChisel = createReactComponent("outline", "chisel", "IconChisel", [["path", { "d": "M14 14l1.5 1.5", "key": "svg-0" }], ["path", { "d": "M18.347 15.575l2.08 2.079a1.96 1.96 0 0 1 -2.773 2.772l-2.08 -2.079a1.96 1.96 0 0 1 2.773 -2.772z", "key": "svg-1" }], ["path", { "d": "M3 6l3 -3l7.414 7.414a2 2 0 0 1 .586 1.414v2.172h-2.172a2 2 0 0 1 -1.414 -.586l-7.414 -7.414z", "key": "svg-2" }]]);

var IconChisel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChisel
});

var IconChristmasBall = createReactComponent("outline", "christmas-ball", "IconChristmasBall", [["path", { "d": "M12 13m-8 0a8 8 0 1 0 16 0a8 8 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M11 5l1 -2l1 2", "key": "svg-1" }], ["path", { "d": "M4.512 10.161c2.496 -1.105 4.992 -.825 7.488 .839c2.627 1.752 5.255 1.97 7.882 .653", "key": "svg-2" }], ["path", { "d": "M4.315 15.252c2.561 -1.21 5.123 -.96 7.685 .748c2.293 1.528 4.585 1.889 6.878 1.081", "key": "svg-3" }]]);

var IconChristmasBall$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChristmasBall
});

var IconChristmasTreeOff = createReactComponent("outline", "christmas-tree-off", "IconChristmasTreeOff", [["path", { "d": "M9.5 5.5l2.5 -2.5l4 4l-2 1l4 4l-1.5 .5m.5 4.5h-12l4 -4l-3 -1l3 -3", "key": "svg-0" }], ["path", { "d": "M14 17v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconChristmasTreeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChristmasTreeOff
});

var IconChristmasTree = createReactComponent("outline", "christmas-tree", "IconChristmasTree", [["path", { "d": "M12 3l4 4l-2 1l4 4l-3 1l4 4h-14l4 -4l-3 -1l4 -4l-2 -1z", "key": "svg-0" }], ["path", { "d": "M14 17v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-3", "key": "svg-1" }]]);

var IconChristmasTree$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconChristmasTree
});

var IconCircleArrowDownLeft = createReactComponent("outline", "circle-arrow-down-left", "IconCircleArrowDownLeft", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9l-6 6", "key": "svg-1" }], ["path", { "d": "M15 15h-6v-6", "key": "svg-2" }]]);

var IconCircleArrowDownLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowDownLeft
});

var IconCircleArrowDownRight = createReactComponent("outline", "circle-arrow-down-right", "IconCircleArrowDownRight", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 15h-6", "key": "svg-1" }], ["path", { "d": "M15 9v6l-6 -6", "key": "svg-2" }]]);

var IconCircleArrowDownRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowDownRight
});

var IconCircleArrowDown = createReactComponent("outline", "circle-arrow-down", "IconCircleArrowDown", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M8 12l4 4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M16 12l-4 4", "key": "svg-3" }]]);

var IconCircleArrowDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowDown
});

var IconCircleArrowLeft = createReactComponent("outline", "circle-arrow-left", "IconCircleArrowLeft", [["path", { "d": "M12 21a9 9 0 1 0 0 -18a9 9 0 0 0 0 18", "key": "svg-0" }], ["path", { "d": "M8 12l4 4", "key": "svg-1" }], ["path", { "d": "M8 12h8", "key": "svg-2" }], ["path", { "d": "M12 8l-4 4", "key": "svg-3" }]]);

var IconCircleArrowLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowLeft
});

var IconCircleArrowRight = createReactComponent("outline", "circle-arrow-right", "IconCircleArrowRight", [["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18", "key": "svg-0" }], ["path", { "d": "M16 12l-4 -4", "key": "svg-1" }], ["path", { "d": "M16 12h-8", "key": "svg-2" }], ["path", { "d": "M12 16l4 -4", "key": "svg-3" }]]);

var IconCircleArrowRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowRight
});

var IconCircleArrowUpLeft = createReactComponent("outline", "circle-arrow-up-left", "IconCircleArrowUpLeft", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 9l6 6", "key": "svg-1" }], ["path", { "d": "M15 9h-6v6", "key": "svg-2" }]]);

var IconCircleArrowUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowUpLeft
});

var IconCircleArrowUpRight = createReactComponent("outline", "circle-arrow-up-right", "IconCircleArrowUpRight", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9l-6 6", "key": "svg-1" }], ["path", { "d": "M15 15v-6h-6", "key": "svg-2" }]]);

var IconCircleArrowUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowUpRight
});

var IconCircleArrowUp = createReactComponent("outline", "circle-arrow-up", "IconCircleArrowUp", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8l-4 4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }], ["path", { "d": "M16 12l-4 -4", "key": "svg-3" }]]);

var IconCircleArrowUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleArrowUp
});

var IconCircleCaretDown = createReactComponent("outline", "circle-caret-down", "IconCircleCaretDown", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 15l-4 -4h8z", "key": "svg-1" }]]);

var IconCircleCaretDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleCaretDown
});

var IconCircleCaretLeft = createReactComponent("outline", "circle-caret-left", "IconCircleCaretLeft", [["path", { "d": "M9 12l4 -4v8z", "key": "svg-0" }], ["path", { "d": "M12 21a9 9 0 1 1 0 -18a9 9 0 0 1 0 18z", "key": "svg-1" }]]);

var IconCircleCaretLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleCaretLeft
});

var IconCircleCaretRight = createReactComponent("outline", "circle-caret-right", "IconCircleCaretRight", [["path", { "d": "M15 12l-4 -4v8z", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleCaretRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleCaretRight
});

var IconCircleCaretUp = createReactComponent("outline", "circle-caret-up", "IconCircleCaretUp", [["path", { "d": "M12 9l4 4h-8z", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleCaretUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleCaretUp
});

var IconCircleCheck = createReactComponent("outline", "circle-check", "IconCircleCheck", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12l2 2l4 -4", "key": "svg-1" }]]);

var IconCircleCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleCheck
});

var IconCircleChevronDown = createReactComponent("outline", "circle-chevron-down", "IconCircleChevronDown", [["path", { "d": "M15 11l-3 3l-3 -3", "key": "svg-0" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18z", "key": "svg-1" }]]);

var IconCircleChevronDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronDown
});

var IconCircleChevronLeft = createReactComponent("outline", "circle-chevron-left", "IconCircleChevronLeft", [["path", { "d": "M13 15l-3 -3l3 -3", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 1 0 -18 0a9 9 0 0 0 18 0z", "key": "svg-1" }]]);

var IconCircleChevronLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronLeft
});

var IconCircleChevronRight = createReactComponent("outline", "circle-chevron-right", "IconCircleChevronRight", [["path", { "d": "M11 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0z", "key": "svg-1" }]]);

var IconCircleChevronRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronRight
});

var IconCircleChevronUp = createReactComponent("outline", "circle-chevron-up", "IconCircleChevronUp", [["path", { "d": "M9 13l3 -3l3 3", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleChevronUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronUp
});

var IconCircleChevronsDown = createReactComponent("outline", "circle-chevrons-down", "IconCircleChevronsDown", [["path", { "d": "M15 9l-3 3l-3 -3", "key": "svg-0" }], ["path", { "d": "M15 13l-3 3l-3 -3", "key": "svg-1" }], ["path", { "d": "M12 3a9 9 0 1 0 0 18a9 9 0 0 0 0 -18z", "key": "svg-2" }]]);

var IconCircleChevronsDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronsDown
});

var IconCircleChevronsLeft = createReactComponent("outline", "circle-chevrons-left", "IconCircleChevronsLeft", [["path", { "d": "M15 15l-3 -3l3 -3", "key": "svg-0" }], ["path", { "d": "M11 15l-3 -3l3 -3", "key": "svg-1" }], ["path", { "d": "M21 12a9 9 0 1 0 0 .265l0 -.265z", "key": "svg-2" }]]);

var IconCircleChevronsLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronsLeft
});

var IconCircleChevronsRight = createReactComponent("outline", "circle-chevrons-right", "IconCircleChevronsRight", [["path", { "d": "M9 9l3 3l-3 3", "key": "svg-0" }], ["path", { "d": "M13 9l3 3l-3 3", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 0 -.265l0 .265z", "key": "svg-2" }]]);

var IconCircleChevronsRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronsRight
});

var IconCircleChevronsUp = createReactComponent("outline", "circle-chevrons-up", "IconCircleChevronsUp", [["path", { "d": "M9 15l3 -3l3 3", "key": "svg-0" }], ["path", { "d": "M9 11l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 21a9 9 0 1 0 -.265 0l.265 0z", "key": "svg-2" }]]);

var IconCircleChevronsUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleChevronsUp
});

var IconCircleDashedCheck = createReactComponent("outline", "circle-dashed-check", "IconCircleDashedCheck", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12l2 2l4 -4", "key": "svg-8" }]]);

var IconCircleDashedCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedCheck
});

var IconCircleDashedLetterA = createReactComponent("outline", "circle-dashed-letter-a", "IconCircleDashedLetterA", [["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M10 13h4", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterA$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterA
});

var IconCircleDashedLetterB = createReactComponent("outline", "circle-dashed-letter-b", "IconCircleDashedLetterB", [["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2z", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterB$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterB
});

var IconCircleDashedLetterC = createReactComponent("outline", "circle-dashed-letter-c", "IconCircleDashedLetterC", [["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterC$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterC
});

var IconCircleDashedLetterD = createReactComponent("outline", "circle-dashed-letter-d", "IconCircleDashedLetterD", [["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterD$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterD
});

var IconCircleDashedLetterE = createReactComponent("outline", "circle-dashed-letter-e", "IconCircleDashedLetterE", [["path", { "d": "M14 8h-4v8h4", "key": "svg-0" }], ["path", { "d": "M10 12h2.5", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterE$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterE
});

var IconCircleDashedLetterF = createReactComponent("outline", "circle-dashed-letter-f", "IconCircleDashedLetterF", [["path", { "d": "M10 12h3", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterF$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterF
});

var IconCircleDashedLetterG = createReactComponent("outline", "circle-dashed-letter-g", "IconCircleDashedLetterG", [["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterG$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterG
});

var IconCircleDashedLetterH = createReactComponent("outline", "circle-dashed-letter-h", "IconCircleDashedLetterH", [["path", { "d": "M10 16v-8m4 0v8", "key": "svg-0" }], ["path", { "d": "M10 12h4", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterH$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterH
});

var IconCircleDashedLetterI = createReactComponent("outline", "circle-dashed-letter-i", "IconCircleDashedLetterI", [["path", { "d": "M12 8v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterI$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterI
});

var IconCircleDashedLetterJ = createReactComponent("outline", "circle-dashed-letter-j", "IconCircleDashedLetterJ", [["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterJ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterJ
});

var IconCircleDashedLetterK = createReactComponent("outline", "circle-dashed-letter-k", "IconCircleDashedLetterK", [["path", { "d": "M10 8v8", "key": "svg-0" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-1" }], ["path", { "d": "M10 12h1.5", "key": "svg-2" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-3" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-4" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-5" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-6" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-7" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-8" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-9" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-10" }]]);

var IconCircleDashedLetterK$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterK
});

var IconCircleDashedLetterL = createReactComponent("outline", "circle-dashed-letter-l", "IconCircleDashedLetterL", [["path", { "d": "M10 8v8h4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterL$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterL
});

var IconCircleDashedLetterM = createReactComponent("outline", "circle-dashed-letter-m", "IconCircleDashedLetterM", [["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterM$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterM
});

var IconCircleDashedLetterN = createReactComponent("outline", "circle-dashed-letter-n", "IconCircleDashedLetterN", [["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterN$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterN
});

var IconCircleDashedLetterO = createReactComponent("outline", "circle-dashed-letter-o", "IconCircleDashedLetterO", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterO$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterO
});

var IconCircleDashedLetterP = createReactComponent("outline", "circle-dashed-letter-p", "IconCircleDashedLetterP", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterP$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterP
});

var IconCircleDashedLetterQ = createReactComponent("outline", "circle-dashed-letter-q", "IconCircleDashedLetterQ", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M13 15l1 1", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterQ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterQ
});

var IconCircleDashedLetterR = createReactComponent("outline", "circle-dashed-letter-r", "IconCircleDashedLetterR", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterR$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterR
});

var IconCircleDashedLetterS = createReactComponent("outline", "circle-dashed-letter-s", "IconCircleDashedLetterS", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterS$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterS
});

var IconCircleDashedLetterT = createReactComponent("outline", "circle-dashed-letter-t", "IconCircleDashedLetterT", [["path", { "d": "M10 8h4", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterT$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterT
});

var IconCircleDashedLetterU = createReactComponent("outline", "circle-dashed-letter-u", "IconCircleDashedLetterU", [["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterU$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterU
});

var IconCircleDashedLetterV = createReactComponent("outline", "circle-dashed-letter-v", "IconCircleDashedLetterV", [["path", { "d": "M10 8l2 8l2 -8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterV$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterV
});

var IconCircleDashedLetterW = createReactComponent("outline", "circle-dashed-letter-w", "IconCircleDashedLetterW", [["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterW$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterW
});

var IconCircleDashedLetterX = createReactComponent("outline", "circle-dashed-letter-x", "IconCircleDashedLetterX", [["path", { "d": "M10 8l4 8", "key": "svg-0" }], ["path", { "d": "M10 16l4 -8", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterX
});

var IconCircleDashedLetterY = createReactComponent("outline", "circle-dashed-letter-y", "IconCircleDashedLetterY", [["path", { "d": "M10 8l2 5l2 -5", "key": "svg-0" }], ["path", { "d": "M12 16v-3", "key": "svg-1" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-2" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-3" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-4" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-5" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-6" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-7" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-8" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-9" }]]);

var IconCircleDashedLetterY$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterY
});

var IconCircleDashedLetterZ = createReactComponent("outline", "circle-dashed-letter-z", "IconCircleDashedLetterZ", [["path", { "d": "M10 8h4l-4 8h4", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }]]);

var IconCircleDashedLetterZ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedLetterZ
});

var IconCircleDashedMinus = createReactComponent("outline", "circle-dashed-minus", "IconCircleDashedMinus", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12h6", "key": "svg-8" }]]);

var IconCircleDashedMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedMinus
});

var IconCircleDashedNumber0 = createReactComponent("outline", "circle-dashed-number-0", "IconCircleDashedNumber0", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0z", "key": "svg-8" }]]);

var IconCircleDashedNumber0$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber0
});

var IconCircleDashedNumber1 = createReactComponent("outline", "circle-dashed-number-1", "IconCircleDashedNumber1", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 10l2 -2v8", "key": "svg-8" }]]);

var IconCircleDashedNumber1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber1
});

var IconCircleDashedNumber2 = createReactComponent("outline", "circle-dashed-number-2", "IconCircleDashedNumber2", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-8" }]]);

var IconCircleDashedNumber2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber2
});

var IconCircleDashedNumber3 = createReactComponent("outline", "circle-dashed-number-3", "IconCircleDashedNumber3", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h2.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-1.5h1.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-2.5", "key": "svg-8" }]]);

var IconCircleDashedNumber3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber3
});

var IconCircleDashedNumber4 = createReactComponent("outline", "circle-dashed-number-4", "IconCircleDashedNumber4", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8v3a1 1 0 0 0 1 1h3", "key": "svg-8" }], ["path", { "d": "M14 8v8", "key": "svg-9" }]]);

var IconCircleDashedNumber4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber4
});

var IconCircleDashedNumber5 = createReactComponent("outline", "circle-dashed-number-5", "IconCircleDashedNumber5", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3v-4h4", "key": "svg-8" }]]);

var IconCircleDashedNumber5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber5
});

var IconCircleDashedNumber6 = createReactComponent("outline", "circle-dashed-number-6", "IconCircleDashedNumber6", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M14 9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3", "key": "svg-8" }]]);

var IconCircleDashedNumber6$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber6
});

var IconCircleDashedNumber7 = createReactComponent("outline", "circle-dashed-number-7", "IconCircleDashedNumber7", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 8h4l-2 8", "key": "svg-8" }]]);

var IconCircleDashedNumber7$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber7
});

var IconCircleDashedNumber8 = createReactComponent("outline", "circle-dashed-number-8", "IconCircleDashedNumber8", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M12 12h-1a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1", "key": "svg-8" }]]);

var IconCircleDashedNumber8$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber8
});

var IconCircleDashedNumber9 = createReactComponent("outline", "circle-dashed-number-9", "IconCircleDashedNumber9", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-6a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-8" }]]);

var IconCircleDashedNumber9$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedNumber9
});

var IconCircleDashedPercentage = createReactComponent("outline", "circle-dashed-percentage", "IconCircleDashedPercentage", [["path", { "d": "M9 15l6 -6", "key": "svg-0" }], ["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-1" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-2" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-3" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-4" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-5" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-6" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-7" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-8" }], ["path", { "d": "M9 9.03v.015", "key": "svg-9" }], ["path", { "d": "M15 15.045v.015", "key": "svg-10" }]]);

var IconCircleDashedPercentage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedPercentage
});

var IconCircleDashedPlus = createReactComponent("outline", "circle-dashed-plus", "IconCircleDashedPlus", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M9 12h6", "key": "svg-8" }], ["path", { "d": "M12 9v6", "key": "svg-9" }]]);

var IconCircleDashedPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedPlus
});

var IconCircleDashedX = createReactComponent("outline", "circle-dashed-x", "IconCircleDashedX", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }], ["path", { "d": "M14 14l-4 -4", "key": "svg-8" }], ["path", { "d": "M10 14l4 -4", "key": "svg-9" }]]);

var IconCircleDashedX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashedX
});

var IconCircleDashed = createReactComponent("outline", "circle-dashed", "IconCircleDashed", [["path", { "d": "M8.56 3.69a9 9 0 0 0 -2.92 1.95", "key": "svg-0" }], ["path", { "d": "M3.69 8.56a9 9 0 0 0 -.69 3.44", "key": "svg-1" }], ["path", { "d": "M3.69 15.44a9 9 0 0 0 1.95 2.92", "key": "svg-2" }], ["path", { "d": "M8.56 20.31a9 9 0 0 0 3.44 .69", "key": "svg-3" }], ["path", { "d": "M15.44 20.31a9 9 0 0 0 2.92 -1.95", "key": "svg-4" }], ["path", { "d": "M20.31 15.44a9 9 0 0 0 .69 -3.44", "key": "svg-5" }], ["path", { "d": "M20.31 8.56a9 9 0 0 0 -1.95 -2.92", "key": "svg-6" }], ["path", { "d": "M15.44 3.69a9 9 0 0 0 -3.44 -.69", "key": "svg-7" }]]);

var IconCircleDashed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDashed
});

var IconCircleDot = createReactComponent("outline", "circle-dot", "IconCircleDot", [["path", { "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }]]);

var IconCircleDot$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDot
});

var IconCircleDottedLetterA = createReactComponent("outline", "circle-dotted-letter-a", "IconCircleDottedLetterA", [["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-0" }], ["path", { "d": "M10 13h4", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterA$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterA
});

var IconCircleDottedLetterB = createReactComponent("outline", "circle-dotted-letter-b", "IconCircleDottedLetterB", [["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2z", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterB$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterB
});

var IconCircleDottedLetterC = createReactComponent("outline", "circle-dotted-letter-c", "IconCircleDottedLetterC", [["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterC$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterC
});

var IconCircleDottedLetterD = createReactComponent("outline", "circle-dotted-letter-d", "IconCircleDottedLetterD", [["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterD$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterD
});

var IconCircleDottedLetterE = createReactComponent("outline", "circle-dotted-letter-e", "IconCircleDottedLetterE", [["path", { "d": "M14 8h-4v8h4", "key": "svg-0" }], ["path", { "d": "M10 12h2.5", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterE$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterE
});

var IconCircleDottedLetterF = createReactComponent("outline", "circle-dotted-letter-f", "IconCircleDottedLetterF", [["path", { "d": "M10 12h3", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterF$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterF
});

var IconCircleDottedLetterG = createReactComponent("outline", "circle-dotted-letter-g", "IconCircleDottedLetterG", [["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterG$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterG
});

var IconCircleDottedLetterH = createReactComponent("outline", "circle-dotted-letter-h", "IconCircleDottedLetterH", [["path", { "d": "M10 16v-8m4 0v8", "key": "svg-0" }], ["path", { "d": "M10 12h4", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterH$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterH
});

var IconCircleDottedLetterI = createReactComponent("outline", "circle-dotted-letter-i", "IconCircleDottedLetterI", [["path", { "d": "M12 8v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterI$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterI
});

var IconCircleDottedLetterJ = createReactComponent("outline", "circle-dotted-letter-j", "IconCircleDottedLetterJ", [["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterJ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterJ
});

var IconCircleDottedLetterK = createReactComponent("outline", "circle-dotted-letter-k", "IconCircleDottedLetterK", [["path", { "d": "M10 8v8", "key": "svg-0" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-1" }], ["path", { "d": "M10 12h1.5", "key": "svg-2" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-3" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-4" }], ["path", { "d": "M3 12v.01", "key": "svg-5" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-6" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M12 21v.01", "key": "svg-8" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-9" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-10" }], ["path", { "d": "M21 12v.01", "key": "svg-11" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-12" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-13" }], ["path", { "d": "M12 3v.01", "key": "svg-14" }]]);

var IconCircleDottedLetterK$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterK
});

var IconCircleDottedLetterL = createReactComponent("outline", "circle-dotted-letter-l", "IconCircleDottedLetterL", [["path", { "d": "M10 8v8h4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterL$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterL
});

var IconCircleDottedLetterM = createReactComponent("outline", "circle-dotted-letter-m", "IconCircleDottedLetterM", [["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterM$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterM
});

var IconCircleDottedLetterN = createReactComponent("outline", "circle-dotted-letter-n", "IconCircleDottedLetterN", [["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterN$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterN
});

var IconCircleDottedLetterO = createReactComponent("outline", "circle-dotted-letter-o", "IconCircleDottedLetterO", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterO$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterO
});

var IconCircleDottedLetterP = createReactComponent("outline", "circle-dotted-letter-p", "IconCircleDottedLetterP", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterP$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterP
});

var IconCircleDottedLetterQ = createReactComponent("outline", "circle-dotted-letter-q", "IconCircleDottedLetterQ", [["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M13 15l1 1", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterQ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterQ
});

var IconCircleDottedLetterR = createReactComponent("outline", "circle-dotted-letter-r", "IconCircleDottedLetterR", [["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterR$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterR
});

var IconCircleDottedLetterS = createReactComponent("outline", "circle-dotted-letter-s", "IconCircleDottedLetterS", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterS$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterS
});

var IconCircleDottedLetterT = createReactComponent("outline", "circle-dotted-letter-t", "IconCircleDottedLetterT", [["path", { "d": "M10 8h4", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterT$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterT
});

var IconCircleDottedLetterU = createReactComponent("outline", "circle-dotted-letter-u", "IconCircleDottedLetterU", [["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterU$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterU
});

var IconCircleDottedLetterV = createReactComponent("outline", "circle-dotted-letter-v", "IconCircleDottedLetterV", [["path", { "d": "M10 8l2 8l2 -8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterV$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterV
});

var IconCircleDottedLetterW = createReactComponent("outline", "circle-dotted-letter-w", "IconCircleDottedLetterW", [["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterW$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterW
});

var IconCircleDottedLetterX = createReactComponent("outline", "circle-dotted-letter-x", "IconCircleDottedLetterX", [["path", { "d": "M10 8l4 8", "key": "svg-0" }], ["path", { "d": "M10 16l4 -8", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterX
});

var IconCircleDottedLetterY = createReactComponent("outline", "circle-dotted-letter-y", "IconCircleDottedLetterY", [["path", { "d": "M10 8l2 5l2 -5", "key": "svg-0" }], ["path", { "d": "M12 16v-3", "key": "svg-1" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-2" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-3" }], ["path", { "d": "M3 12v.01", "key": "svg-4" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-5" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-6" }], ["path", { "d": "M12 21v.01", "key": "svg-7" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-8" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-9" }], ["path", { "d": "M21 12v.01", "key": "svg-10" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-11" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-12" }], ["path", { "d": "M12 3v.01", "key": "svg-13" }]]);

var IconCircleDottedLetterY$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterY
});

var IconCircleDottedLetterZ = createReactComponent("outline", "circle-dotted-letter-z", "IconCircleDottedLetterZ", [["path", { "d": "M10 8h4l-4 8h4", "key": "svg-0" }], ["path", { "d": "M7.5 4.21v.01", "key": "svg-1" }], ["path", { "d": "M4.21 7.5v.01", "key": "svg-2" }], ["path", { "d": "M3 12v.01", "key": "svg-3" }], ["path", { "d": "M4.21 16.5v.01", "key": "svg-4" }], ["path", { "d": "M7.5 19.79v.01", "key": "svg-5" }], ["path", { "d": "M12 21v.01", "key": "svg-6" }], ["path", { "d": "M16.5 19.79v.01", "key": "svg-7" }], ["path", { "d": "M19.79 16.5v.01", "key": "svg-8" }], ["path", { "d": "M21 12v.01", "key": "svg-9" }], ["path", { "d": "M19.79 7.5v.01", "key": "svg-10" }], ["path", { "d": "M16.5 4.21v.01", "key": "svg-11" }], ["path", { "d": "M12 3v.01", "key": "svg-12" }]]);

var IconCircleDottedLetterZ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDottedLetterZ
});

var IconCircleDotted = createReactComponent("outline", "circle-dotted", "IconCircleDotted", [["path", { "d": "M7.5 4.21l0 .01", "key": "svg-0" }], ["path", { "d": "M4.21 7.5l0 .01", "key": "svg-1" }], ["path", { "d": "M3 12l0 .01", "key": "svg-2" }], ["path", { "d": "M4.21 16.5l0 .01", "key": "svg-3" }], ["path", { "d": "M7.5 19.79l0 .01", "key": "svg-4" }], ["path", { "d": "M12 21l0 .01", "key": "svg-5" }], ["path", { "d": "M16.5 19.79l0 .01", "key": "svg-6" }], ["path", { "d": "M19.79 16.5l0 .01", "key": "svg-7" }], ["path", { "d": "M21 12l0 .01", "key": "svg-8" }], ["path", { "d": "M19.79 7.5l0 .01", "key": "svg-9" }], ["path", { "d": "M16.5 4.21l0 .01", "key": "svg-10" }], ["path", { "d": "M12 3l0 .01", "key": "svg-11" }]]);

var IconCircleDotted$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleDotted
});

var IconCircleHalf2 = createReactComponent("outline", "circle-half-2", "IconCircleHalf2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v18", "key": "svg-1" }], ["path", { "d": "M12 14l7 -7", "key": "svg-2" }], ["path", { "d": "M12 19l8.5 -8.5", "key": "svg-3" }], ["path", { "d": "M12 9l4.5 -4.5", "key": "svg-4" }]]);

var IconCircleHalf2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleHalf2
});

var IconCircleHalfVertical = createReactComponent("outline", "circle-half-vertical", "IconCircleHalfVertical", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M3 12h18", "key": "svg-1" }]]);

var IconCircleHalfVertical$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleHalfVertical
});

var IconCircleHalf = createReactComponent("outline", "circle-half", "IconCircleHalf", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 3v18", "key": "svg-1" }]]);

var IconCircleHalf$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleHalf
});

var IconCircleKey = createReactComponent("outline", "circle-key", "IconCircleKey", [["path", { "d": "M14 10m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z", "key": "svg-1" }], ["path", { "d": "M12.5 11.5l-4 4l1.5 1.5", "key": "svg-2" }], ["path", { "d": "M12 15l-1.5 -1.5", "key": "svg-3" }]]);

var IconCircleKey$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleKey
});

var IconCircleLetterA = createReactComponent("outline", "circle-letter-a", "IconCircleLetterA", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-6a2 2 0 1 1 4 0v6", "key": "svg-1" }], ["path", { "d": "M10 13h4", "key": "svg-2" }]]);

var IconCircleLetterA$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterA
});

var IconCircleLetterB = createReactComponent("outline", "circle-letter-b", "IconCircleLetterB", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2v8z", "key": "svg-1" }]]);

var IconCircleLetterB$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterB
});

var IconCircleLetterC = createReactComponent("outline", "circle-letter-c", "IconCircleLetterC", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-1" }]]);

var IconCircleLetterC$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterC
});

var IconCircleLetterD = createReactComponent("outline", "circle-letter-d", "IconCircleLetterD", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-2z", "key": "svg-1" }]]);

var IconCircleLetterD$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterD
});

var IconCircleLetterE = createReactComponent("outline", "circle-letter-e", "IconCircleLetterE", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 8h-4v8h4", "key": "svg-1" }], ["path", { "d": "M10 12h2.5", "key": "svg-2" }]]);

var IconCircleLetterE$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterE
});

var IconCircleLetterF = createReactComponent("outline", "circle-letter-f", "IconCircleLetterF", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h3", "key": "svg-1" }], ["path", { "d": "M14 8h-4v8", "key": "svg-2" }]]);

var IconCircleLetterF$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterF
});

var IconCircleLetterG = createReactComponent("outline", "circle-letter-g", "IconCircleLetterG", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 8h-2a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2v-4h-1", "key": "svg-1" }]]);

var IconCircleLetterG$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterG
});

var IconCircleLetterH = createReactComponent("outline", "circle-letter-h", "IconCircleLetterH", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-8m4 0v8", "key": "svg-1" }], ["path", { "d": "M10 12h4", "key": "svg-2" }]]);

var IconCircleLetterH$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterH
});

var IconCircleLetterI = createReactComponent("outline", "circle-letter-i", "IconCircleLetterI", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8v8", "key": "svg-1" }]]);

var IconCircleLetterI$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterI
});

var IconCircleLetterJ = createReactComponent("outline", "circle-letter-j", "IconCircleLetterJ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4v6a2 2 0 1 1 -4 0", "key": "svg-1" }]]);

var IconCircleLetterJ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterJ
});

var IconCircleLetterK = createReactComponent("outline", "circle-letter-k", "IconCircleLetterK", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8", "key": "svg-1" }], ["path", { "d": "M14 8l-2.5 4l2.5 4", "key": "svg-2" }], ["path", { "d": "M10 12h1.5", "key": "svg-3" }]]);

var IconCircleLetterK$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterK
});

var IconCircleLetterL = createReactComponent("outline", "circle-letter-l", "IconCircleLetterL", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v8h4", "key": "svg-1" }]]);

var IconCircleLetterL$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterL
});

var IconCircleLetterM = createReactComponent("outline", "circle-letter-m", "IconCircleLetterM", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 16v-8l3 5l3 -5v8", "key": "svg-1" }]]);

var IconCircleLetterM$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterM
});

var IconCircleLetterN = createReactComponent("outline", "circle-letter-n", "IconCircleLetterN", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 16v-8l4 8v-8", "key": "svg-1" }]]);

var IconCircleLetterN$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterN
});

var IconCircleLetterO = createReactComponent("outline", "circle-letter-o", "IconCircleLetterO", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }]]);

var IconCircleLetterO$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterO
});

var IconCircleLetterP = createReactComponent("outline", "circle-letter-p", "IconCircleLetterP", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8", "key": "svg-1" }]]);

var IconCircleLetterP$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterP
});

var IconCircleLetterQ = createReactComponent("outline", "circle-letter-q", "IconCircleLetterQ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }], ["path", { "d": "M13 15l1 1", "key": "svg-2" }]]);

var IconCircleLetterQ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterQ
});

var IconCircleLetterR = createReactComponent("outline", "circle-letter-r", "IconCircleLetterR", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 12h2a2 2 0 1 0 0 -4h-2v8m4 0l-3 -4", "key": "svg-1" }]]);

var IconCircleLetterR$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterR
});

var IconCircleLetterS = createReactComponent("outline", "circle-letter-s", "IconCircleLetterS", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-1" }]]);

var IconCircleLetterS$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterS
});

var IconCircleLetterT = createReactComponent("outline", "circle-letter-t", "IconCircleLetterT", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4", "key": "svg-1" }], ["path", { "d": "M12 8v8", "key": "svg-2" }]]);

var IconCircleLetterT$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterT
});

var IconCircleLetterU = createReactComponent("outline", "circle-letter-u", "IconCircleLetterU", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v6a2 2 0 1 0 4 0v-6", "key": "svg-1" }]]);

var IconCircleLetterU$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterU
});

var IconCircleLetterV = createReactComponent("outline", "circle-letter-v", "IconCircleLetterV", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l2 8l2 -8", "key": "svg-1" }]]);

var IconCircleLetterV$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterV
});

var IconCircleLetterW = createReactComponent("outline", "circle-letter-w", "IconCircleLetterW", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 8l1 8l2 -5l2 5l1 -8", "key": "svg-1" }]]);

var IconCircleLetterW$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterW
});

var IconCircleLetterX = createReactComponent("outline", "circle-letter-x", "IconCircleLetterX", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l4 8", "key": "svg-1" }], ["path", { "d": "M10 16l4 -8", "key": "svg-2" }]]);

var IconCircleLetterX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterX
});

var IconCircleLetterY = createReactComponent("outline", "circle-letter-y", "IconCircleLetterY", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8l2 5l2 -5", "key": "svg-1" }], ["path", { "d": "M12 16v-3", "key": "svg-2" }]]);

var IconCircleLetterY$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterY
});

var IconCircleLetterZ = createReactComponent("outline", "circle-letter-z", "IconCircleLetterZ", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4l-4 8h4", "key": "svg-1" }]]);

var IconCircleLetterZ$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleLetterZ
});

var IconCircleMinus2 = createReactComponent("outline", "circle-minus-2", "IconCircleMinus2", [["path", { "d": "M20.475 15.029a9 9 0 1 0 -7.962 5.957", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconCircleMinus2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleMinus2
});

var IconCircleMinus = createReactComponent("outline", "circle-minus", "IconCircleMinus", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12l6 0", "key": "svg-1" }]]);

var IconCircleMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleMinus
});

var IconCircleNumber0 = createReactComponent("outline", "circle-number-0", "IconCircleNumber0", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0z", "key": "svg-1" }]]);

var IconCircleNumber0$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber0
});

var IconCircleNumber1 = createReactComponent("outline", "circle-number-1", "IconCircleNumber1", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10l2 -2v8", "key": "svg-1" }]]);

var IconCircleNumber1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber1
});

var IconCircleNumber2 = createReactComponent("outline", "circle-number-2", "IconCircleNumber2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-1" }]]);

var IconCircleNumber2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber2
});

var IconCircleNumber3 = createReactComponent("outline", "circle-number-3", "IconCircleNumber3", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 9a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1", "key": "svg-1" }]]);

var IconCircleNumber3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber3
});

var IconCircleNumber4 = createReactComponent("outline", "circle-number-4", "IconCircleNumber4", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8v3a1 1 0 0 0 1 1h3", "key": "svg-1" }], ["path", { "d": "M14 8v8", "key": "svg-2" }]]);

var IconCircleNumber4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber4
});

var IconCircleNumber5 = createReactComponent("outline", "circle-number-5", "IconCircleNumber5", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3v-4h4", "key": "svg-1" }]]);

var IconCircleNumber5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber5
});

var IconCircleNumber6 = createReactComponent("outline", "circle-number-6", "IconCircleNumber6", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3", "key": "svg-1" }]]);

var IconCircleNumber6$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber6
});

var IconCircleNumber7 = createReactComponent("outline", "circle-number-7", "IconCircleNumber7", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 8h4l-2 8", "key": "svg-1" }]]);

var IconCircleNumber7$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber7
});

var IconCircleNumber8 = createReactComponent("outline", "circle-number-8", "IconCircleNumber8", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h-1a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1", "key": "svg-1" }]]);

var IconCircleNumber8$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber8
});

var IconCircleNumber9 = createReactComponent("outline", "circle-number-9", "IconCircleNumber9", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-6a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3", "key": "svg-1" }]]);

var IconCircleNumber9$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleNumber9
});

var IconCircleOff = createReactComponent("outline", "circle-off", "IconCircleOff", [["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCircleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleOff
});

var IconCirclePercentage = createReactComponent("outline", "circle-percentage", "IconCirclePercentage", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 15.075l6 -6", "key": "svg-1" }], ["path", { "d": "M9 9.105v.015", "key": "svg-2" }], ["path", { "d": "M15 15.12v.015", "key": "svg-3" }]]);

var IconCirclePercentage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCirclePercentage
});

var IconCirclePlus2 = createReactComponent("outline", "circle-plus-2", "IconCirclePlus2", [["path", { "d": "M20.985 12.522a9 9 0 1 0 -8.475 8.464", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconCirclePlus2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCirclePlus2
});

var IconCirclePlus = createReactComponent("outline", "circle-plus", "IconCirclePlus", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12h6", "key": "svg-1" }], ["path", { "d": "M12 9v6", "key": "svg-2" }]]);

var IconCirclePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCirclePlus
});

var IconCircleRectangleOff = createReactComponent("outline", "circle-rectangle-off", "IconCircleRectangleOff", [["path", { "d": "M14 10h3v3m-3 1h-7v-4h3", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCircleRectangleOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleRectangleOff
});

var IconCircleRectangle = createReactComponent("outline", "circle-rectangle", "IconCircleRectangle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M7 10h10v4h-10z", "key": "svg-1" }]]);

var IconCircleRectangle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleRectangle
});

var IconCircleSquare = createReactComponent("outline", "circle-square", "IconCircleSquare", [["path", { "d": "M9.5 9.5m-6.5 0a6.5 6.5 0 1 0 13 0a6.5 6.5 0 1 0 -13 0", "key": "svg-0" }], ["path", { "d": "M10 10m0 2a2 2 0 0 1 2 -2h7a2 2 0 0 1 2 2v7a2 2 0 0 1 -2 2h-7a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconCircleSquare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleSquare
});

var IconCircleTriangle = createReactComponent("outline", "circle-triangle", "IconCircleTriangle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 20l7 -12h-14z", "key": "svg-1" }]]);

var IconCircleTriangle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleTriangle
});

var IconCircleX = createReactComponent("outline", "circle-x", "IconCircleX", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 10l4 4m0 -4l-4 4", "key": "svg-1" }]]);

var IconCircleX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircleX
});

var IconCircle = createReactComponent("outline", "circle", "IconCircle", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }]]);

var IconCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircle
});

var IconCirclesRelation = createReactComponent("outline", "circles-relation", "IconCirclesRelation", [["path", { "d": "M9.183 6.117a6 6 0 1 0 4.511 3.986", "key": "svg-0" }], ["path", { "d": "M14.813 17.883a6 6 0 1 0 -4.496 -3.954", "key": "svg-1" }]]);

var IconCirclesRelation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCirclesRelation
});

var IconCircles = createReactComponent("outline", "circles", "IconCircles", [["path", { "d": "M12 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-0" }], ["path", { "d": "M6.5 17m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M17.5 17m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-2" }]]);

var IconCircles$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircles
});

var IconCircuitAmmeter = createReactComponent("outline", "circuit-ammeter", "IconCircuitAmmeter", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 14v-3c0 -1.036 .895 -2 2 -2s2 .964 2 2v3", "key": "svg-3" }], ["path", { "d": "M14 12h-4", "key": "svg-4" }]]);

var IconCircuitAmmeter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitAmmeter
});

var IconCircuitBattery = createReactComponent("outline", "circuit-battery", "IconCircuitBattery", [["path", { "d": "M2 12h4", "key": "svg-0" }], ["path", { "d": "M18 12h4", "key": "svg-1" }], ["path", { "d": "M18 5v14", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }], ["path", { "d": "M10 5v14", "key": "svg-4" }], ["path", { "d": "M6 9v6", "key": "svg-5" }]]);

var IconCircuitBattery$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitBattery
});

var IconCircuitBulb = createReactComponent("outline", "circuit-bulb", "IconCircuitBulb", [["path", { "d": "M2 12h5", "key": "svg-0" }], ["path", { "d": "M17 12h5", "key": "svg-1" }], ["path", { "d": "M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0", "key": "svg-2" }], ["path", { "d": "M8.5 8.5l7 7", "key": "svg-3" }], ["path", { "d": "M15.5 8.5l-7 7", "key": "svg-4" }]]);

var IconCircuitBulb$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitBulb
});

var IconCircuitCapacitorPolarized = createReactComponent("outline", "circuit-capacitor-polarized", "IconCircuitCapacitorPolarized", [["path", { "d": "M22 12h-8", "key": "svg-0" }], ["path", { "d": "M2 12h8", "key": "svg-1" }], ["path", { "d": "M10 7v10", "key": "svg-2" }], ["path", { "d": "M14 7v10", "key": "svg-3" }], ["path", { "d": "M17 5h4", "key": "svg-4" }], ["path", { "d": "M19 3v4", "key": "svg-5" }]]);

var IconCircuitCapacitorPolarized$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitCapacitorPolarized
});

var IconCircuitCapacitor = createReactComponent("outline", "circuit-capacitor", "IconCircuitCapacitor", [["path", { "d": "M22 12h-8", "key": "svg-0" }], ["path", { "d": "M2 12h8", "key": "svg-1" }], ["path", { "d": "M10 7v10", "key": "svg-2" }], ["path", { "d": "M14 7v10", "key": "svg-3" }]]);

var IconCircuitCapacitor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitCapacitor
});

var IconCircuitCellPlus = createReactComponent("outline", "circuit-cell-plus", "IconCircuitCellPlus", [["path", { "d": "M2 12h9", "key": "svg-0" }], ["path", { "d": "M15 12h7", "key": "svg-1" }], ["path", { "d": "M11 5v14", "key": "svg-2" }], ["path", { "d": "M15 9v6", "key": "svg-3" }], ["path", { "d": "M3 5h4", "key": "svg-4" }], ["path", { "d": "M5 3v4", "key": "svg-5" }]]);

var IconCircuitCellPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitCellPlus
});

var IconCircuitCell = createReactComponent("outline", "circuit-cell", "IconCircuitCell", [["path", { "d": "M2 12h8", "key": "svg-0" }], ["path", { "d": "M14 12h8", "key": "svg-1" }], ["path", { "d": "M10 5v14", "key": "svg-2" }], ["path", { "d": "M14 9v6", "key": "svg-3" }]]);

var IconCircuitCell$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitCell
});

var IconCircuitChangeover = createReactComponent("outline", "circuit-changeover", "IconCircuitChangeover", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 7h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 7m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M20 17h2", "key": "svg-4" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-5" }], ["path", { "d": "M7.5 10.5l8.5 -3.5", "key": "svg-6" }]]);

var IconCircuitChangeover$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitChangeover
});

var IconCircuitDiodeZener = createReactComponent("outline", "circuit-diode-zener", "IconCircuitDiodeZener", [["path", { "d": "M22 12h-6", "key": "svg-0" }], ["path", { "d": "M2 12h6", "key": "svg-1" }], ["path", { "d": "M8 7l8 5l-8 5z", "key": "svg-2" }], ["path", { "d": "M14 7h2v10h2", "key": "svg-3" }]]);

var IconCircuitDiodeZener$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitDiodeZener
});

var IconCircuitDiode = createReactComponent("outline", "circuit-diode", "IconCircuitDiode", [["path", { "d": "M22 12h-6", "key": "svg-0" }], ["path", { "d": "M2 12h6", "key": "svg-1" }], ["path", { "d": "M8 7l8 5l-8 5z", "key": "svg-2" }], ["path", { "d": "M16 7v10", "key": "svg-3" }]]);

var IconCircuitDiode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitDiode
});

var IconCircuitGroundDigital = createReactComponent("outline", "circuit-ground-digital", "IconCircuitGroundDigital", [["path", { "d": "M12 13v-10", "key": "svg-0" }], ["path", { "d": "M12 21l-6 -8h12z", "key": "svg-1" }]]);

var IconCircuitGroundDigital$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitGroundDigital
});

var IconCircuitGround = createReactComponent("outline", "circuit-ground", "IconCircuitGround", [["path", { "d": "M12 13v-8", "key": "svg-0" }], ["path", { "d": "M4 13h16", "key": "svg-1" }], ["path", { "d": "M7 16h10", "key": "svg-2" }], ["path", { "d": "M10 19h4", "key": "svg-3" }]]);

var IconCircuitGround$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitGround
});

var IconCircuitInductor = createReactComponent("outline", "circuit-inductor", "IconCircuitInductor", [["path", { "d": "M2 14h3v-2a2 2 0 1 1 4 0v2v-1.5a2.5 2.5 0 1 1 5 0v1.5v-1.5a2.5 2.5 0 1 1 5 0v1.5h3", "key": "svg-0" }]]);

var IconCircuitInductor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitInductor
});

var IconCircuitMotor = createReactComponent("outline", "circuit-motor", "IconCircuitMotor", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 14v-4l2 2l2 -2v4", "key": "svg-3" }]]);

var IconCircuitMotor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitMotor
});

var IconCircuitPushbutton = createReactComponent("outline", "circuit-pushbutton", "IconCircuitPushbutton", [["path", { "d": "M2 17h2", "key": "svg-0" }], ["path", { "d": "M20 17h2", "key": "svg-1" }], ["path", { "d": "M6 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M6 11h12", "key": "svg-4" }], ["path", { "d": "M12 11v-6", "key": "svg-5" }]]);

var IconCircuitPushbutton$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitPushbutton
});

var IconCircuitResistor = createReactComponent("outline", "circuit-resistor", "IconCircuitResistor", [["path", { "d": "M2 12h2l2 -5l3 10l3 -10l3 10l3 -10l1.5 5h2.5", "key": "svg-0" }]]);

var IconCircuitResistor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitResistor
});

var IconCircuitSwitchClosed = createReactComponent("outline", "circuit-switch-closed", "IconCircuitSwitchClosed", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 12h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M8 12h8", "key": "svg-4" }]]);

var IconCircuitSwitchClosed$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitSwitchClosed
});

var IconCircuitSwitchOpen = createReactComponent("outline", "circuit-switch-open", "IconCircuitSwitchOpen", [["path", { "d": "M2 12h2", "key": "svg-0" }], ["path", { "d": "M20 12h2", "key": "svg-1" }], ["path", { "d": "M6 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M18 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M7.5 10.5l7.5 -5.5", "key": "svg-4" }]]);

var IconCircuitSwitchOpen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitSwitchOpen
});

var IconCircuitVoltmeter = createReactComponent("outline", "circuit-voltmeter", "IconCircuitVoltmeter", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 12h-3", "key": "svg-1" }], ["path", { "d": "M19 12h3", "key": "svg-2" }], ["path", { "d": "M10 10l2 4l2 -4", "key": "svg-3" }]]);

var IconCircuitVoltmeter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCircuitVoltmeter
});

var IconClearAll = createReactComponent("outline", "clear-all", "IconClearAll", [["path", { "d": "M8 6h12", "key": "svg-0" }], ["path", { "d": "M6 12h12", "key": "svg-1" }], ["path", { "d": "M4 18h12", "key": "svg-2" }]]);

var IconClearAll$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClearAll
});

var IconClearFormatting = createReactComponent("outline", "clear-formatting", "IconClearFormatting", [["path", { "d": "M17 15l4 4m0 -4l-4 4", "key": "svg-0" }], ["path", { "d": "M7 6v-1h11v1", "key": "svg-1" }], ["path", { "d": "M7 19l4 0", "key": "svg-2" }], ["path", { "d": "M13 5l-4 14", "key": "svg-3" }]]);

var IconClearFormatting$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClearFormatting
});

var IconClick = createReactComponent("outline", "click", "IconClick", [["path", { "d": "M3 12l3 0", "key": "svg-0" }], ["path", { "d": "M12 3l0 3", "key": "svg-1" }], ["path", { "d": "M7.8 7.8l-2.2 -2.2", "key": "svg-2" }], ["path", { "d": "M16.2 7.8l2.2 -2.2", "key": "svg-3" }], ["path", { "d": "M7.8 16.2l-2.2 2.2", "key": "svg-4" }], ["path", { "d": "M12 12l9 3l-4 2l-2 4l-3 -9", "key": "svg-5" }]]);

var IconClick$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClick
});

var IconCliffJumping = createReactComponent("outline", "cliff-jumping", "IconCliffJumping", [["path", { "d": "M14 7a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M10.5 18l2.5 2l2 -2", "key": "svg-1" }], ["path", { "d": "M18 21l3 -3l-4 -2l-1 -5", "key": "svg-2" }], ["path", { "d": "M10.5 7.5l2 3l3.5 .5l3 -2l.5 -3", "key": "svg-3" }], ["path", { "d": "M4 21v-1l2 -3l.5 -2.5l1.5 -2.5l-1 -5l1 -3l-1 -1l-2 .5l-2 -.5", "key": "svg-4" }]]);

var IconCliffJumping$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCliffJumping
});

var IconClipboardCheck = createReactComponent("outline", "clipboard-check", "IconClipboardCheck", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 14l2 2l4 -4", "key": "svg-2" }]]);

var IconClipboardCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardCheck
});

var IconClipboardCopy = createReactComponent("outline", "clipboard-copy", "IconClipboardCopy", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h3m9 -9v-5a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M13 17v-1a1 1 0 0 1 1 -1h1m3 0h1a1 1 0 0 1 1 1v1m0 3v1a1 1 0 0 1 -1 1h-1m-3 0h-1a1 1 0 0 1 -1 -1v-1", "key": "svg-1" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-2" }]]);

var IconClipboardCopy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardCopy
});

var IconClipboardData = createReactComponent("outline", "clipboard-data", "IconClipboardData", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 17v-4", "key": "svg-2" }], ["path", { "d": "M12 17v-1", "key": "svg-3" }], ["path", { "d": "M15 17v-2", "key": "svg-4" }], ["path", { "d": "M12 17v-1", "key": "svg-5" }]]);

var IconClipboardData$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardData
});

var IconClipboardHeart = createReactComponent("outline", "clipboard-heart", "IconClipboardHeart", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M11.993 16.75l2.747 -2.815a1.9 1.9 0 0 0 0 -2.632a1.775 1.775 0 0 0 -2.56 0l-.183 .188l-.183 -.189a1.775 1.775 0 0 0 -2.56 0a1.899 1.899 0 0 0 0 2.632l2.738 2.825z", "key": "svg-2" }]]);

var IconClipboardHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardHeart
});

var IconClipboardList = createReactComponent("outline", "clipboard-list", "IconClipboardList", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12l.01 0", "key": "svg-2" }], ["path", { "d": "M13 12l2 0", "key": "svg-3" }], ["path", { "d": "M9 16l.01 0", "key": "svg-4" }], ["path", { "d": "M13 16l2 0", "key": "svg-5" }]]);

var IconClipboardList$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardList
});

var IconClipboardOff = createReactComponent("outline", "clipboard-off", "IconClipboardOff", [["path", { "d": "M5.575 5.597a2 2 0 0 0 -.575 1.403v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2m0 -4v-8a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 1 1 0 4h-2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconClipboardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardOff
});

var IconClipboardPlus = createReactComponent("outline", "clipboard-plus", "IconClipboardPlus", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M10 14h4", "key": "svg-2" }], ["path", { "d": "M12 12v4", "key": "svg-3" }]]);

var IconClipboardPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardPlus
});

var IconClipboardSearch = createReactComponent("outline", "clipboard-search", "IconClipboardSearch", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h4.5m7.5 -10v-4a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconClipboardSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardSearch
});

var IconClipboardSmile = createReactComponent("outline", "clipboard-smile", "IconClipboardSmile", [["path", { "d": "M10 13h.01", "key": "svg-0" }], ["path", { "d": "M14 13h.01", "key": "svg-1" }], ["path", { "d": "M10 16a3.5 3.5 0 0 0 4 0", "key": "svg-2" }], ["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-3" }], ["path", { "d": "M9 5a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-4" }]]);

var IconClipboardSmile$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardSmile
});

var IconClipboardText = createReactComponent("outline", "clipboard-text", "IconClipboardText", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12h6", "key": "svg-2" }], ["path", { "d": "M9 16h6", "key": "svg-3" }]]);

var IconClipboardText$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardText
});

var IconClipboardTypography = createReactComponent("outline", "clipboard-typography", "IconClipboardTypography", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M9 12v-1h6v1", "key": "svg-2" }], ["path", { "d": "M12 11v6", "key": "svg-3" }], ["path", { "d": "M11 17h2", "key": "svg-4" }]]);

var IconClipboardTypography$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardTypography
});

var IconClipboardX = createReactComponent("outline", "clipboard-x", "IconClipboardX", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }], ["path", { "d": "M10 12l4 4m0 -4l-4 4", "key": "svg-2" }]]);

var IconClipboardX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboardX
});

var IconClipboard = createReactComponent("outline", "clipboard", "IconClipboard", [["path", { "d": "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2", "key": "svg-0" }], ["path", { "d": "M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z", "key": "svg-1" }]]);

var IconClipboard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClipboard
});

var IconClock12 = createReactComponent("outline", "clock-12", "IconClock12", [["path", { "d": "M3 12a9 9 0 0 0 9 9m9 -9a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5l.5 .5", "key": "svg-1" }], ["path", { "d": "M18 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-2" }], ["path", { "d": "M15 21v-6", "key": "svg-3" }]]);

var IconClock12$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClock12
});

var IconClock2 = createReactComponent("outline", "clock-2", "IconClock2", [["path", { "d": "M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M4 12h1", "key": "svg-2" }], ["path", { "d": "M19 12h1", "key": "svg-3" }], ["path", { "d": "M12 19v1", "key": "svg-4" }]]);

var IconClock2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClock2
});

var IconClock24 = createReactComponent("outline", "clock-24", "IconClock24", [["path", { "d": "M3 12a9 9 0 0 0 5.998 8.485m12.002 -8.485a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }], ["path", { "d": "M12 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2", "key": "svg-2" }], ["path", { "d": "M18 15v2a1 1 0 0 0 1 1h1", "key": "svg-3" }], ["path", { "d": "M21 15v6", "key": "svg-4" }]]);

var IconClock24$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClock24
});

var IconClockBitcoin = createReactComponent("outline", "clock-bitcoin", "IconClockBitcoin", [["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-0" }], ["path", { "d": "M20.866 10.45a9 9 0 1 0 -7.815 10.488", "key": "svg-1" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-2" }]]);

var IconClockBitcoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockBitcoin
});

var IconClockBolt = createReactComponent("outline", "clock-bolt", "IconClockBolt", [["path", { "d": "M20.984 12.53a9 9 0 1 0 -7.552 8.355", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconClockBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockBolt
});

var IconClockCancel = createReactComponent("outline", "clock-cancel", "IconClockCancel", [["path", { "d": "M20.997 12.25a9 9 0 1 0 -8.718 8.745", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockCancel
});

var IconClockCheck = createReactComponent("outline", "clock-check", "IconClockCheck", [["path", { "d": "M20.942 13.021a9 9 0 1 0 -9.407 7.967", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconClockCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockCheck
});

var IconClockCode = createReactComponent("outline", "clock-code", "IconClockCode", [["path", { "d": "M20.931 13.111a9 9 0 1 0 -9.453 7.874", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockCode
});

var IconClockCog = createReactComponent("outline", "clock-cog", "IconClockCog", [["path", { "d": "M21 12a9 9 0 1 0 -9.002 9", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-8" }]]);

var IconClockCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockCog
});

var IconClockDollar = createReactComponent("outline", "clock-dollar", "IconClockDollar", [["path", { "d": "M20.866 10.45a9 9 0 1 0 -7.815 10.488", "key": "svg-0" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconClockDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockDollar
});

var IconClockDown = createReactComponent("outline", "clock-down", "IconClockDown", [["path", { "d": "M20.984 12.535a9 9 0 1 0 -8.431 8.448", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconClockDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockDown
});

var IconClockEdit = createReactComponent("outline", "clock-edit", "IconClockEdit", [["path", { "d": "M21 12a9 9 0 1 0 -9.972 8.948c.32 .034 .644 .052 .972 .052", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-2" }]]);

var IconClockEdit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockEdit
});

var IconClockExclamation = createReactComponent("outline", "clock-exclamation", "IconClockExclamation", [["path", { "d": "M20.986 12.502a9 9 0 1 0 -5.973 7.98", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconClockExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockExclamation
});

var IconClockHeart = createReactComponent("outline", "clock-heart", "IconClockHeart", [["path", { "d": "M20.956 11.107a9 9 0 1 0 -9.579 9.871", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }], ["path", { "d": "M12 7v5l.5 .5", "key": "svg-2" }]]);

var IconClockHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHeart
});

var IconClockHour1 = createReactComponent("outline", "clock-hour-1", "IconClockHour1", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }], ["path", { "d": "M12 12l2 -3", "key": "svg-2" }]]);

var IconClockHour1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour1
});

var IconClockHour10 = createReactComponent("outline", "clock-hour-10", "IconClockHour10", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-3 -2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour10$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour10
});

var IconClockHour11 = createReactComponent("outline", "clock-hour-11", "IconClockHour11", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-2 -3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour11$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour11
});

var IconClockHour12 = createReactComponent("outline", "clock-hour-12", "IconClockHour12", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5", "key": "svg-1" }]]);

var IconClockHour12$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour12
});

var IconClockHour2 = createReactComponent("outline", "clock-hour-2", "IconClockHour2", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l3 -2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour2
});

var IconClockHour3 = createReactComponent("outline", "clock-hour-3", "IconClockHour3", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour3
});

var IconClockHour4 = createReactComponent("outline", "clock-hour-4", "IconClockHour4", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l3 2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour4$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour4
});

var IconClockHour5 = createReactComponent("outline", "clock-hour-5", "IconClockHour5", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l2 3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour5$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour5
});

var IconClockHour6 = createReactComponent("outline", "clock-hour-6", "IconClockHour6", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12v3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour6$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour6
});

var IconClockHour7 = createReactComponent("outline", "clock-hour-7", "IconClockHour7", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-2 3", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour7$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour7
});

var IconClockHour8 = createReactComponent("outline", "clock-hour-8", "IconClockHour8", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12l-3 2", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour8$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour8
});

var IconClockHour9 = createReactComponent("outline", "clock-hour-9", "IconClockHour9", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12h-3.5", "key": "svg-1" }], ["path", { "d": "M12 7v5", "key": "svg-2" }]]);

var IconClockHour9$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockHour9
});

var IconClockMinus = createReactComponent("outline", "clock-minus", "IconClockMinus", [["path", { "d": "M20.477 15.022a9 9 0 1 0 -7.998 5.965", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconClockMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockMinus
});

var IconClockOff = createReactComponent("outline", "clock-off", "IconClockOff", [["path", { "d": "M5.633 5.64a9 9 0 1 0 12.735 12.72m1.674 -2.32a9 9 0 0 0 -12.082 -12.082", "key": "svg-0" }], ["path", { "d": "M12 7v1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconClockOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockOff
});

var IconClockPause = createReactComponent("outline", "clock-pause", "IconClockPause", [["path", { "d": "M20.942 13.018a9 9 0 1 0 -7.909 7.922", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconClockPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockPause
});

var IconClockPin = createReactComponent("outline", "clock-pin", "IconClockPin", [["path", { "d": "M20.971 11.278a9 9 0 1 0 -8.313 9.698", "key": "svg-0" }], ["path", { "d": "M12 7v5l1.5 1.5", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconClockPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockPin
});

var IconClockPlay = createReactComponent("outline", "clock-play", "IconClockPlay", [["path", { "d": "M12 7v5l2 2", "key": "svg-0" }], ["path", { "d": "M17 22l5 -3l-5 -3z", "key": "svg-1" }], ["path", { "d": "M13.017 20.943a9 9 0 1 1 7.831 -7.292", "key": "svg-2" }]]);

var IconClockPlay$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockPlay
});

var IconClockPlus = createReactComponent("outline", "clock-plus", "IconClockPlus", [["path", { "d": "M20.984 12.535a9 9 0 1 0 -8.468 8.45", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-3" }]]);

var IconClockPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockPlus
});

var IconClockQuestion = createReactComponent("outline", "clock-question", "IconClockQuestion", [["path", { "d": "M20.975 11.33a9 9 0 1 0 -5.717 9.06", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconClockQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockQuestion
});

var IconClockRecord = createReactComponent("outline", "clock-record", "IconClockRecord", [["path", { "d": "M21 12.3a9 9 0 1 0 -8.683 8.694", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconClockRecord$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockRecord
});

var IconClockSearch = createReactComponent("outline", "clock-search", "IconClockSearch", [["path", { "d": "M20.993 11.646a9 9 0 1 0 -9.318 9.348", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconClockSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockSearch
});

var IconClockShare = createReactComponent("outline", "clock-share", "IconClockShare", [["path", { "d": "M20.943 13.016a9 9 0 1 0 -8.915 7.984", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-3" }]]);

var IconClockShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockShare
});

var IconClockShield = createReactComponent("outline", "clock-shield", "IconClockShield", [["path", { "d": "M21 12a9 9 0 1 0 -8.98 9", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M22 16c0 4 -2.5 6 -3.5 6s-3.5 -2 -3.5 -6c1 0 2.5 -.5 3.5 -1.5c1 1 2.5 1.5 3.5 1.5z", "key": "svg-2" }]]);

var IconClockShield$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockShield
});

var IconClockStar = createReactComponent("outline", "clock-star", "IconClockStar", [["path", { "d": "M20.982 11.436a9 9 0 1 0 -9.966 9.51", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-2" }]]);

var IconClockStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockStar
});

var IconClockStop = createReactComponent("outline", "clock-stop", "IconClockStop", [["path", { "d": "M21 12a9 9 0 1 0 -9 9", "key": "svg-0" }], ["path", { "d": "M12 7v5l1 1", "key": "svg-1" }], ["path", { "d": "M16 16h6v6h-6z", "key": "svg-2" }]]);

var IconClockStop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockStop
});

var IconClockUp = createReactComponent("outline", "clock-up", "IconClockUp", [["path", { "d": "M20.983 12.548a9 9 0 1 0 -8.45 8.436", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M12 7v5l2.5 2.5", "key": "svg-3" }]]);

var IconClockUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockUp
});

var IconClockX = createReactComponent("outline", "clock-x", "IconClockX", [["path", { "d": "M20.926 13.15a9 9 0 1 0 -7.835 7.784", "key": "svg-0" }], ["path", { "d": "M12 7v5l2 2", "key": "svg-1" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-2" }], ["path", { "d": "M17 22l5 -5", "key": "svg-3" }]]);

var IconClockX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClockX
});

var IconClock = createReactComponent("outline", "clock", "IconClock", [["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7v5l3 3", "key": "svg-1" }]]);

var IconClock$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClock
});

var IconClothesRackOff = createReactComponent("outline", "clothes-rack-off", "IconClothesRackOff", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 7v1m0 4v9", "key": "svg-1" }], ["path", { "d": "M9 21h6", "key": "svg-2" }], ["path", { "d": "M7.757 9.243a6 6 0 0 0 3.129 1.653m3.578 -.424a6 6 0 0 0 1.779 -1.229", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconClothesRackOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClothesRackOff
});

var IconClothesRack = createReactComponent("outline", "clothes-rack", "IconClothesRack", [["path", { "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M12 7v14", "key": "svg-1" }], ["path", { "d": "M9 21h6", "key": "svg-2" }], ["path", { "d": "M7.757 9.243a6 6 0 0 0 8.486 0", "key": "svg-3" }]]);

var IconClothesRack$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClothesRack
});

var IconCloudBitcoin = createReactComponent("outline", "cloud-bitcoin", "IconCloudBitcoin", [["path", { "d": "M17 21v-6m2 0v-1.5m0 9v-1.5m-2 -3h3m-1 0h.5a1.5 1.5 0 0 1 0 3h-3.5m3 -3h.5a1.5 1.5 0 0 0 0 -3h-3.5", "key": "svg-0" }], ["path", { "d": "M13.5 18.004h-6.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487s2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.28 1.023 1.957 2.51 1.873 4.027", "key": "svg-1" }]]);

var IconCloudBitcoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudBitcoin
});

var IconCloudBolt = createReactComponent("outline", "cloud-bolt", "IconCloudBolt", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.396 0 2.6 .831 3.148 2.03", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }]]);

var IconCloudBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudBolt
});

var IconCloudCancel = createReactComponent("outline", "cloud-cancel", "IconCloudCancel", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.45 3.45 0 0 1 2.756 1.373", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }]]);

var IconCloudCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudCancel
});

var IconCloudCheck = createReactComponent("outline", "cloud-check", "IconCloudCheck", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.388 0 2.585 .82 3.138 2.007", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }]]);

var IconCloudCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudCheck
});

var IconCloudCode = createReactComponent("outline", "cloud-code", "IconCloudCode", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.468 3.468 0 0 1 3.307 2.444", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }]]);

var IconCloudCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudCode
});

var IconCloudCog = createReactComponent("outline", "cloud-cog", "IconCloudCog", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c.956 0 1.822 .39 2.449 1.02", "key": "svg-0" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-2" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-3" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-4" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-5" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-6" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-7" }]]);

var IconCloudCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudCog
});

var IconCloudComputing = createReactComponent("outline", "cloud-computing", "IconCloudComputing", [["path", { "d": "M6.657 16c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878", "key": "svg-0" }], ["path", { "d": "M12 16v5", "key": "svg-1" }], ["path", { "d": "M16 16v4a1 1 0 0 0 1 1h4", "key": "svg-2" }], ["path", { "d": "M8 16v4a1 1 0 0 1 -1 1h-4", "key": "svg-3" }]]);

var IconCloudComputing$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudComputing
});

var IconCloudDataConnection = createReactComponent("outline", "cloud-data-connection", "IconCloudDataConnection", [["path", { "d": "M5 9.897c0 -1.714 1.46 -3.104 3.26 -3.104c.275 -1.22 1.255 -2.215 2.572 -2.611c1.317 -.397 2.77 -.134 3.811 .69c1.042 .822 1.514 2.08 1.239 3.3h.693a2.42 2.42 0 0 1 2.425 2.414a2.42 2.42 0 0 1 -2.425 2.414h-8.315c-1.8 0 -3.26 -1.39 -3.26 -3.103z", "key": "svg-0" }], ["path", { "d": "M12 13v3", "key": "svg-1" }], ["path", { "d": "M12 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M14 18h7", "key": "svg-3" }], ["path", { "d": "M3 18h7", "key": "svg-4" }]]);

var IconCloudDataConnection$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudDataConnection
});

var IconCloudDollar = createReactComponent("outline", "cloud-dollar", "IconCloudDollar", [["path", { "d": "M13.5 18.004h-6.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.28 1.023 1.957 2.51 1.873 4.027", "key": "svg-0" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-1" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-2" }]]);

var IconCloudDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudDollar
});

var IconCloudDown = createReactComponent("outline", "cloud-down", "IconCloudDown", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.38 0 2.573 .813 3.13 1.99", "key": "svg-0" }], ["path", { "d": "M19 16v6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-2" }]]);

var IconCloudDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudDown
});

var IconCloudDownload = createReactComponent("outline", "cloud-download", "IconCloudDownload", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1a5 4.5 0 0 0 -11 -2a4.6 4.4 0 0 0 -2.1 8.4", "key": "svg-0" }], ["path", { "d": "M12 13l0 9", "key": "svg-1" }], ["path", { "d": "M9 19l3 3l3 -3", "key": "svg-2" }]]);

var IconCloudDownload$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudDownload
});

var IconCloudExclamation = createReactComponent("outline", "cloud-exclamation", "IconCloudExclamation", [["path", { "d": "M15 18.004h-8.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.374 0 2.562 .805 3.121 1.972", "key": "svg-0" }], ["path", { "d": "M19 16v3", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }]]);

var IconCloudExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudExclamation
});

var IconCloudFog = createReactComponent("outline", "cloud-fog", "IconCloudFog", [["path", { "d": "M7 16a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-12", "key": "svg-0" }], ["path", { "d": "M5 20l14 0", "key": "svg-1" }]]);

var IconCloudFog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudFog
});

var IconCloudHeart = createReactComponent("outline", "cloud-heart", "IconCloudHeart", [["path", { "d": "M10 18.004h-3.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-1" }]]);

var IconCloudHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudHeart
});

var IconCloudLockOpen = createReactComponent("outline", "cloud-lock-open", "IconCloudLockOpen", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027", "key": "svg-0" }], ["path", { "d": "M8 15m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M10 15v-2a2 2 0 0 1 3.736 -1", "key": "svg-2" }]]);

var IconCloudLockOpen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudLockOpen
});

var IconCloudLock = createReactComponent("outline", "cloud-lock", "IconCloudLock", [["path", { "d": "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027", "key": "svg-0" }], ["path", { "d": "M8 15m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-1" }], ["path", { "d": "M10 15v-2a2 2 0 1 1 4 0v2", "key": "svg-2" }]]);

var IconCloudLock$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudLock
});

var IconCloudMinus = createReactComponent("outline", "cloud-minus", "IconCloudMinus", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 .186 -.015 .37 -.042 .548", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }]]);

var IconCloudMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudMinus
});

var IconCloudNetwork = createReactComponent("outline", "cloud-network", "IconCloudNetwork", [["path", { "d": "M3 20h7", "key": "svg-0" }], ["path", { "d": "M14 20h7", "key": "svg-1" }], ["path", { "d": "M10 20a2 2 0 1 0 4 0a2 2 0 0 0 -4 0", "key": "svg-2" }], ["path", { "d": "M12 16v2", "key": "svg-3" }], ["path", { "d": "M8 16.004h-1.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-2.535", "key": "svg-4" }]]);

var IconCloudNetwork$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudNetwork
});

var IconCloudOff = createReactComponent("outline", "cloud-off", "IconCloudOff", [["path", { "d": "M9.58 5.548c.24 -.11 .492 -.207 .752 -.286c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 .957 -.383 1.824 -1.003 2.454m-2.997 1.033h-11.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.13 -.582 .37 -1.128 .7 -1.62", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCloudOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudOff
});

var IconCloudPause = createReactComponent("outline", "cloud-pause", "IconCloudPause", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.406 0 2.617 .843 3.16 2.055", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }]]);

var IconCloudPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudPause
});

var IconCloudPin = createReactComponent("outline", "cloud-pin", "IconCloudPin", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }]]);

var IconCloudPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudPin
});

var IconCloudPlus = createReactComponent("outline", "cloud-plus", "IconCloudPlus", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99a3.46 3.46 0 0 1 3.085 1.9", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconCloudPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudPlus
});

var IconCloudQuestion = createReactComponent("outline", "cloud-question", "IconCloudQuestion", [["path", { "d": "M14.5 18.004h-7.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }]]);

var IconCloudQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudQuestion
});

var IconCloudRain = createReactComponent("outline", "cloud-rain", "IconCloudRain", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7", "key": "svg-0" }], ["path", { "d": "M11 13v2m0 3v2m4 -5v2m0 3v2", "key": "svg-1" }]]);

var IconCloudRain$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudRain
});

var IconCloudSearch = createReactComponent("outline", "cloud-search", "IconCloudSearch", [["path", { "d": "M11 18.004h-4.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }]]);

var IconCloudSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudSearch
});

var IconCloudShare = createReactComponent("outline", "cloud-share", "IconCloudShare", [["path", { "d": "M12.5 18.004h-5.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.41 0 2.624 .848 3.164 2.065", "key": "svg-0" }], ["path", { "d": "M16 22l5 -5", "key": "svg-1" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-2" }]]);

var IconCloudShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudShare
});

var IconCloudSnow = createReactComponent("outline", "cloud-snow", "IconCloudSnow", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7", "key": "svg-0" }], ["path", { "d": "M11 15v.01m0 3v.01m0 3v.01m4 -4v.01m0 3v.01", "key": "svg-1" }]]);

var IconCloudSnow$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudSnow
});

var IconCloudStar = createReactComponent("outline", "cloud-star", "IconCloudStar", [["path", { "d": "M9.5 18.004h-2.843c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.209 .967 1.88 2.347 1.88 3.776", "key": "svg-0" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-1" }]]);

var IconCloudStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudStar
});

var IconCloudStorm = createReactComponent("outline", "cloud-storm", "IconCloudStorm", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1", "key": "svg-0" }], ["path", { "d": "M13 14l-2 4l3 0l-2 4", "key": "svg-1" }]]);

var IconCloudStorm$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudStorm
});

var IconCloudUp = createReactComponent("outline", "cloud-up", "IconCloudUp", [["path", { "d": "M12 18.004h-5.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.38 0 2.57 .811 3.128 1.986", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }]]);

var IconCloudUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudUp
});

var IconCloudUpload = createReactComponent("outline", "cloud-upload", "IconCloudUpload", [["path", { "d": "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1", "key": "svg-0" }], ["path", { "d": "M9 15l3 -3l3 3", "key": "svg-1" }], ["path", { "d": "M12 12l0 9", "key": "svg-2" }]]);

var IconCloudUpload$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudUpload
});

var IconCloudX = createReactComponent("outline", "cloud-x", "IconCloudX", [["path", { "d": "M13 18.004h-6.343c-2.572 -.004 -4.657 -2.011 -4.657 -4.487c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.37 0 2.556 .8 3.117 1.964", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }]]);

var IconCloudX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloudX
});

var IconCloud = createReactComponent("outline", "cloud", "IconCloud", [["path", { "d": "M6.657 18c-2.572 0 -4.657 -2.007 -4.657 -4.483c0 -2.475 2.085 -4.482 4.657 -4.482c.393 -1.762 1.794 -3.2 3.675 -3.773c1.88 -.572 3.956 -.193 5.444 1c1.488 1.19 2.162 3.007 1.77 4.769h.99c1.913 0 3.464 1.56 3.464 3.486c0 1.927 -1.551 3.487 -3.465 3.487h-11.878", "key": "svg-0" }]]);

var IconCloud$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCloud
});

var IconClover2 = createReactComponent("outline", "clover-2", "IconClover2", [["path", { "d": "M11 11l-3.397 -3.44a2.104 2.104 0 0 1 0 -2.95a2.04 2.04 0 0 1 2.912 0l.485 .39l.485 -.39a2.04 2.04 0 0 1 2.912 0a2.104 2.104 0 0 1 0 2.95l-3.397 3.44z", "key": "svg-0" }], ["path", { "d": "M11 11l-3.397 3.44a2.104 2.104 0 0 0 0 2.95a2.04 2.04 0 0 0 2.912 0l.485 -.39l.485 .39a2.04 2.04 0 0 0 2.912 0a2.104 2.104 0 0 0 0 -2.95l-3.397 -3.44z", "key": "svg-1" }], ["path", { "d": "M14.44 7.603a2.104 2.104 0 0 1 2.95 0a2.04 2.04 0 0 1 0 2.912l-.39 .485l.39 .485a2.04 2.04 0 0 1 0 2.912a2.104 2.104 0 0 1 -2.95 0", "key": "svg-2" }], ["path", { "d": "M7.56 7.603a2.104 2.104 0 0 0 -2.95 0a2.04 2.04 0 0 0 0 2.912l.39 .485l-.39 .485a2.04 2.04 0 0 0 0 2.912a2.104 2.104 0 0 0 2.95 0", "key": "svg-3" }], ["path", { "d": "M15 15l6 6", "key": "svg-4" }]]);

var IconClover2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClover2
});

var IconClover = createReactComponent("outline", "clover", "IconClover", [["path", { "d": "M12 10l-3.397 -3.44a2.104 2.104 0 0 1 0 -2.95a2.04 2.04 0 0 1 2.912 0l.485 .39l.485 -.39a2.04 2.04 0 0 1 2.912 0a2.104 2.104 0 0 1 0 2.95l-3.397 3.44z", "key": "svg-0" }], ["path", { "d": "M12 14l-3.397 3.44a2.104 2.104 0 0 0 0 2.95a2.04 2.04 0 0 0 2.912 0l.485 -.39l.485 .39a2.04 2.04 0 0 0 2.912 0a2.104 2.104 0 0 0 0 -2.95l-3.397 -3.44z", "key": "svg-1" }], ["path", { "d": "M14 12l3.44 -3.397a2.104 2.104 0 0 1 2.95 0a2.04 2.04 0 0 1 0 2.912l-.39 .485l.39 .485a2.04 2.04 0 0 1 0 2.912a2.104 2.104 0 0 1 -2.95 0l-3.44 -3.397z", "key": "svg-2" }], ["path", { "d": "M10 12l-3.44 -3.397a2.104 2.104 0 0 0 -2.95 0a2.04 2.04 0 0 0 0 2.912l.39 .485l-.39 .485a2.04 2.04 0 0 0 0 2.912a2.104 2.104 0 0 0 2.95 0l3.44 -3.397z", "key": "svg-3" }]]);

var IconClover$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClover
});

var IconClubs = createReactComponent("outline", "clubs", "IconClubs", [["path", { "d": "M12 3a4 4 0 0 1 3.164 6.447a4 4 0 1 1 -1.164 6.198v1.355l1 4h-6l1 -4l0 -1.355a4 4 0 1 1 -1.164 -6.199a4 4 0 0 1 3.163 -6.446z", "key": "svg-0" }]]);

var IconClubs$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconClubs
});

var IconCodeAsterisk = createReactComponent("outline", "code-asterisk", "IconCodeAsterisk", [["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12 11.875l3 -1.687", "key": "svg-1" }], ["path", { "d": "M12 11.875v3.375", "key": "svg-2" }], ["path", { "d": "M12 11.875l-3 -1.687", "key": "svg-3" }], ["path", { "d": "M12 11.875l3 1.688", "key": "svg-4" }], ["path", { "d": "M12 8.5v3.375", "key": "svg-5" }], ["path", { "d": "M12 11.875l-3 1.688", "key": "svg-6" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-7" }]]);

var IconCodeAsterisk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeAsterisk
});

var IconCodeCircle2 = createReactComponent("outline", "code-circle-2", "IconCodeCircle2", [["path", { "d": "M8.5 13.5l-1.5 -1.5l1.5 -1.5", "key": "svg-0" }], ["path", { "d": "M15.5 10.5l1.5 1.5l-1.5 1.5", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }], ["path", { "d": "M13 9.5l-2 5.5", "key": "svg-3" }]]);

var IconCodeCircle2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeCircle2
});

var IconCodeCircle = createReactComponent("outline", "code-circle", "IconCodeCircle", [["path", { "d": "M10 14l-2 -2l2 -2", "key": "svg-0" }], ["path", { "d": "M14 10l2 2l-2 2", "key": "svg-1" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-2" }]]);

var IconCodeCircle$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeCircle
});

var IconCodeDots = createReactComponent("outline", "code-dots", "IconCodeDots", [["path", { "d": "M15 12h.01", "key": "svg-0" }], ["path", { "d": "M12 12h.01", "key": "svg-1" }], ["path", { "d": "M9 12h.01", "key": "svg-2" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-3" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-4" }]]);

var IconCodeDots$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeDots
});

var IconCodeMinus = createReactComponent("outline", "code-minus", "IconCodeMinus", [["path", { "d": "M9 12h6", "key": "svg-0" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-1" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-2" }]]);

var IconCodeMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeMinus
});

var IconCodeOff = createReactComponent("outline", "code-off", "IconCodeOff", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-2.5 2.5", "key": "svg-1" }], ["path", { "d": "M14 4l-1.201 4.805m-.802 3.207l-2 7.988", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCodeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeOff
});

var IconCodePlus = createReactComponent("outline", "code-plus", "IconCodePlus", [["path", { "d": "M9 12h6", "key": "svg-0" }], ["path", { "d": "M12 9v6", "key": "svg-1" }], ["path", { "d": "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2", "key": "svg-2" }], ["path", { "d": "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2", "key": "svg-3" }]]);

var IconCodePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodePlus
});

var IconCodeVariableMinus = createReactComponent("outline", "code-variable-minus", "IconCodeVariableMinus", [["path", { "d": "M12.5 16h-6.5a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4", "key": "svg-0" }], ["path", { "d": "M16 18h6", "key": "svg-1" }]]);

var IconCodeVariableMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeVariableMinus
});

var IconCodeVariablePlus = createReactComponent("outline", "code-variable-plus", "IconCodeVariablePlus", [["path", { "d": "M13 16h-7a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v1", "key": "svg-0" }], ["path", { "d": "M16 18h6", "key": "svg-1" }], ["path", { "d": "M19 15v6", "key": "svg-2" }]]);

var IconCodeVariablePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeVariablePlus
});

var IconCodeVariable = createReactComponent("outline", "code-variable", "IconCodeVariable", [["path", { "d": "M4 8m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCodeVariable$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCodeVariable
});

var IconCode = createReactComponent("outline", "code", "IconCode", [["path", { "d": "M7 8l-4 4l4 4", "key": "svg-0" }], ["path", { "d": "M17 8l4 4l-4 4", "key": "svg-1" }], ["path", { "d": "M14 4l-4 16", "key": "svg-2" }]]);

var IconCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCode
});

var IconCoffeeOff = createReactComponent("outline", "coffee-off", "IconCoffeeOff", [["path", { "d": "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.73 -.565 1.783 -.923 3 -.99", "key": "svg-0" }], ["path", { "d": "M8 3c-.194 .14 -.364 .305 -.506 .49", "key": "svg-1" }], ["path", { "d": "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-2" }], ["path", { "d": "M14 10h3v3m-.257 3.743a6 6 0 0 1 -5.743 4.257h-2a6 6 0 0 1 -6 -6v-5h7", "key": "svg-3" }], ["path", { "d": "M20.116 16.124a3 3 0 0 0 -3.118 -4.953", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCoffeeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoffeeOff
});

var IconCoffee = createReactComponent("outline", "coffee", "IconCoffee", [["path", { "d": "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.83 -.642 2.077 -1.017 3.5 -1c1.423 -.017 2.67 .358 3.5 1", "key": "svg-0" }], ["path", { "d": "M8 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-1" }], ["path", { "d": "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2", "key": "svg-2" }], ["path", { "d": "M3 10h14v5a6 6 0 0 1 -6 6h-2a6 6 0 0 1 -6 -6v-5z", "key": "svg-3" }], ["path", { "d": "M16.746 16.726a3 3 0 1 0 .252 -5.555", "key": "svg-4" }]]);

var IconCoffee$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoffee
});

var IconCoffin = createReactComponent("outline", "coffin", "IconCoffin", [["path", { "d": "M7 3l-2 6l2 12h6l2 -12l-2 -6z", "key": "svg-0" }], ["path", { "d": "M10 7v5", "key": "svg-1" }], ["path", { "d": "M8 9h4", "key": "svg-2" }], ["path", { "d": "M13 21h4l2 -12l-2 -6h-4", "key": "svg-3" }]]);

var IconCoffin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoffin
});

var IconCoinBitcoin = createReactComponent("outline", "coin-bitcoin", "IconCoinBitcoin", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 8h4.09c1.055 0 1.91 .895 1.91 2s-.855 2 -1.91 2c1.055 0 1.91 .895 1.91 2s-.855 2 -1.91 2h-4.09", "key": "svg-1" }], ["path", { "d": "M10 12h4", "key": "svg-2" }], ["path", { "d": "M10 7v10v-9", "key": "svg-3" }], ["path", { "d": "M13 7v1", "key": "svg-4" }], ["path", { "d": "M13 16v1", "key": "svg-5" }]]);

var IconCoinBitcoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinBitcoin
});

var IconCoinEuro = createReactComponent("outline", "coin-euro", "IconCoinEuro", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14.401 8c-.669 -.628 -1.5 -1 -2.401 -1c-2.21 0 -4 2.239 -4 5s1.79 5 4 5c.9 0 1.731 -.372 2.4 -1", "key": "svg-1" }], ["path", { "d": "M7 10.5h4", "key": "svg-2" }], ["path", { "d": "M7 13.5h4", "key": "svg-3" }]]);

var IconCoinEuro$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinEuro
});

var IconCoinMonero = createReactComponent("outline", "coin-monero", "IconCoinMonero", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M4 16h4v-7l4 4l4 -4v7h4", "key": "svg-1" }]]);

var IconCoinMonero$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinMonero
});

var IconCoinOff = createReactComponent("outline", "coin-off", "IconCoinOff", [["path", { "d": "M14.8 9a2 2 0 0 0 -1.8 -1h-1m-2.82 1.171a2 2 0 0 0 1.82 2.829h1m2.824 2.822a2 2 0 0 1 -1.824 1.178h-2a2 2 0 0 1 -1.8 -1", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 6v2m0 8v2", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCoinOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinOff
});

var IconCoinPound = createReactComponent("outline", "coin-pound", "IconCoinPound", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9a2 2 0 1 0 -4 0v5a2 2 0 0 1 -2 2h6", "key": "svg-1" }], ["path", { "d": "M9 12h4", "key": "svg-2" }]]);

var IconCoinPound$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinPound
});

var IconCoinRupee = createReactComponent("outline", "coin-rupee", "IconCoinRupee", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 8h-6h1a3 3 0 0 1 0 6h-1l3 3", "key": "svg-1" }], ["path", { "d": "M9 11h6", "key": "svg-2" }]]);

var IconCoinRupee$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinRupee
});

var IconCoinTaka = createReactComponent("outline", "coin-taka", "IconCoinTaka", [["path", { "d": "M8 8l.553 -.276a1 1 0 0 1 1.447 .894v6.382a2 2 0 0 0 2 2h.5a2.5 2.5 0 0 0 2.5 -2.5v-.5h-1", "key": "svg-0" }], ["path", { "d": "M8 11h7", "key": "svg-1" }], ["path", { "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0", "key": "svg-2" }]]);

var IconCoinTaka$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinTaka
});

var IconCoinYen = createReactComponent("outline", "coin-yen", "IconCoinYen", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 12h6", "key": "svg-1" }], ["path", { "d": "M9 15h6", "key": "svg-2" }], ["path", { "d": "M9 8l3 4.5", "key": "svg-3" }], ["path", { "d": "M15 8l-3 4.5v4.5", "key": "svg-4" }]]);

var IconCoinYen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinYen
});

var IconCoinYuan = createReactComponent("outline", "coin-yuan", "IconCoinYuan", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 13h6", "key": "svg-1" }], ["path", { "d": "M9 8l3 4.5", "key": "svg-2" }], ["path", { "d": "M15 8l-3 4.5v4.5", "key": "svg-3" }]]);

var IconCoinYuan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoinYuan
});

var IconCoin = createReactComponent("outline", "coin", "IconCoin", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 1 0 0 4h2a2 2 0 1 1 0 4h-2a2 2 0 0 1 -1.8 -1", "key": "svg-1" }], ["path", { "d": "M12 7v10", "key": "svg-2" }]]);

var IconCoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoin
});

var IconCoins = createReactComponent("outline", "coins", "IconCoins", [["path", { "d": "M9 14c0 1.657 2.686 3 6 3s6 -1.343 6 -3s-2.686 -3 -6 -3s-6 1.343 -6 3z", "key": "svg-0" }], ["path", { "d": "M9 14v4c0 1.656 2.686 3 6 3s6 -1.344 6 -3v-4", "key": "svg-1" }], ["path", { "d": "M3 6c0 1.072 1.144 2.062 3 2.598s4.144 .536 6 0c1.856 -.536 3 -1.526 3 -2.598c0 -1.072 -1.144 -2.062 -3 -2.598s-4.144 -.536 -6 0c-1.856 .536 -3 1.526 -3 2.598z", "key": "svg-2" }], ["path", { "d": "M3 6v10c0 .888 .772 1.45 2 2", "key": "svg-3" }], ["path", { "d": "M3 11c0 .888 .772 1.45 2 2", "key": "svg-4" }]]);

var IconCoins$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCoins
});

var IconColorFilter = createReactComponent("outline", "color-filter", "IconColorFilter", [["path", { "d": "M13.58 13.79c.27 .68 .42 1.43 .42 2.21c0 1.77 -.77 3.37 -2 4.46a5.93 5.93 0 0 1 -4 1.54c-3.31 0 -6 -2.69 -6 -6c0 -2.76 1.88 -5.1 4.42 -5.79", "key": "svg-0" }], ["path", { "d": "M17.58 10.21c2.54 .69 4.42 3.03 4.42 5.79c0 3.31 -2.69 6 -6 6a5.93 5.93 0 0 1 -4 -1.54", "key": "svg-1" }], ["path", { "d": "M12 8m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-2" }]]);

var IconColorFilter$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColorFilter
});

var IconColorPickerOff = createReactComponent("outline", "color-picker-off", "IconColorPickerOff", [["path", { "d": "M11 7l6 6", "key": "svg-0" }], ["path", { "d": "M12 8l3.699 -3.699a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-3.702 3.702m-2 2l-6 6h-4v-4l6 -6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconColorPickerOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColorPickerOff
});

var IconColorPicker = createReactComponent("outline", "color-picker", "IconColorPicker", [["path", { "d": "M11 7l6 6", "key": "svg-0" }], ["path", { "d": "M4 16l11.7 -11.7a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-11.7 11.7h-4v-4z", "key": "svg-1" }]]);

var IconColorPicker$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColorPicker
});

var IconColorSwatchOff = createReactComponent("outline", "color-swatch-off", "IconColorSwatchOff", [["path", { "d": "M13 13v4a4 4 0 0 0 6.832 2.825m1.168 -2.825v-12a2 2 0 0 0 -2 -2h-4a2 2 0 0 0 -2 2v4", "key": "svg-0" }], ["path", { "d": "M13 7.35l-2 -2a2 2 0 0 0 -2.11 -.461m-2.13 1.874l-1.416 1.415a2 2 0 0 0 0 2.828l9 9", "key": "svg-1" }], ["path", { "d": "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12", "key": "svg-2" }], ["path", { "d": "M17 17v.01", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconColorSwatchOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColorSwatchOff
});

var IconColorSwatch = createReactComponent("outline", "color-swatch", "IconColorSwatch", [["path", { "d": "M19 3h-4a2 2 0 0 0 -2 2v12a4 4 0 0 0 8 0v-12a2 2 0 0 0 -2 -2", "key": "svg-0" }], ["path", { "d": "M13 7.35l-2 -2a2 2 0 0 0 -2.828 0l-2.828 2.828a2 2 0 0 0 0 2.828l9 9", "key": "svg-1" }], ["path", { "d": "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12", "key": "svg-2" }], ["path", { "d": "M17 17l0 .01", "key": "svg-3" }]]);

var IconColorSwatch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColorSwatch
});

var IconColumnInsertLeft = createReactComponent("outline", "column-insert-left", "IconColumnInsertLeft", [["path", { "d": "M14 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M5 12l4 0", "key": "svg-1" }], ["path", { "d": "M7 10l0 4", "key": "svg-2" }]]);

var IconColumnInsertLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumnInsertLeft
});

var IconColumnInsertRight = createReactComponent("outline", "column-insert-right", "IconColumnInsertRight", [["path", { "d": "M6 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M15 12l4 0", "key": "svg-1" }], ["path", { "d": "M17 10l0 4", "key": "svg-2" }]]);

var IconColumnInsertRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumnInsertRight
});

var IconColumnRemove = createReactComponent("outline", "column-remove", "IconColumnRemove", [["path", { "d": "M6 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z", "key": "svg-0" }], ["path", { "d": "M16 10l4 4", "key": "svg-1" }], ["path", { "d": "M16 14l4 -4", "key": "svg-2" }]]);

var IconColumnRemove$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumnRemove
});

var IconColumns1 = createReactComponent("outline", "columns-1", "IconColumns1", [["path", { "d": "M5 3m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }]]);

var IconColumns1$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumns1
});

var IconColumns2 = createReactComponent("outline", "columns-2", "IconColumns2", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1zm9 -1v18", "key": "svg-0" }]]);

var IconColumns2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumns2
});

var IconColumns3 = createReactComponent("outline", "columns-3", "IconColumns3", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v16a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1zm6 -1v18m6 -18v18", "key": "svg-0" }]]);

var IconColumns3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumns3
});

var IconColumnsOff = createReactComponent("outline", "columns-off", "IconColumnsOff", [["path", { "d": "M4 6h2", "key": "svg-0" }], ["path", { "d": "M4 10h5.5", "key": "svg-1" }], ["path", { "d": "M4 14h5.5", "key": "svg-2" }], ["path", { "d": "M4 18h5.5", "key": "svg-3" }], ["path", { "d": "M14.5 6h5.5", "key": "svg-4" }], ["path", { "d": "M14.5 10h5.5", "key": "svg-5" }], ["path", { "d": "M18 14h2", "key": "svg-6" }], ["path", { "d": "M14.5 18h3.5", "key": "svg-7" }], ["path", { "d": "M3 3l18 18", "key": "svg-8" }]]);

var IconColumnsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumnsOff
});

var IconColumns = createReactComponent("outline", "columns", "IconColumns", [["path", { "d": "M4 6l5.5 0", "key": "svg-0" }], ["path", { "d": "M4 10l5.5 0", "key": "svg-1" }], ["path", { "d": "M4 14l5.5 0", "key": "svg-2" }], ["path", { "d": "M4 18l5.5 0", "key": "svg-3" }], ["path", { "d": "M14.5 6l5.5 0", "key": "svg-4" }], ["path", { "d": "M14.5 10l5.5 0", "key": "svg-5" }], ["path", { "d": "M14.5 14l5.5 0", "key": "svg-6" }], ["path", { "d": "M14.5 18l5.5 0", "key": "svg-7" }]]);

var IconColumns$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconColumns
});

var IconComet = createReactComponent("outline", "comet", "IconComet", [["path", { "d": "M15.5 18.5l-3 1.5l.5 -3.5l-2 -2l3 -.5l1.5 -3l1.5 3l3 .5l-2 2l.5 3.5z", "key": "svg-0" }], ["path", { "d": "M4 4l7 7", "key": "svg-1" }], ["path", { "d": "M9 4l3.5 3.5", "key": "svg-2" }], ["path", { "d": "M4 9l3.5 3.5", "key": "svg-3" }]]);

var IconComet$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconComet
});

var IconCommandOff = createReactComponent("outline", "command-off", "IconCommandOff", [["path", { "d": "M9 9v8a2 2 0 1 1 -2 -2h8m3.411 3.417a2 2 0 0 1 -3.411 -1.417v-2m0 -4v-4a2 2 0 1 1 2 2h-4m-4 0h-2a2 2 0 0 1 -1.417 -3.411", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCommandOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCommandOff
});

var IconCommand = createReactComponent("outline", "command", "IconCommand", [["path", { "d": "M7 9a2 2 0 1 1 2 -2v10a2 2 0 1 1 -2 -2h10a2 2 0 1 1 -2 2v-10a2 2 0 1 1 2 2h-10", "key": "svg-0" }]]);

var IconCommand$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCommand
});

var IconCompassOff = createReactComponent("outline", "compass-off", "IconCompassOff", [["path", { "d": "M13 9l3 -1l-1 3m-1 3l-6 2l2 -6", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M12 3v2", "key": "svg-2" }], ["path", { "d": "M12 19v2", "key": "svg-3" }], ["path", { "d": "M3 12h2", "key": "svg-4" }], ["path", { "d": "M19 12h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCompassOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCompassOff
});

var IconCompass = createReactComponent("outline", "compass", "IconCompass", [["path", { "d": "M8 16l2 -6l6 -2l-2 6l-6 2", "key": "svg-0" }], ["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-1" }], ["path", { "d": "M12 3l0 2", "key": "svg-2" }], ["path", { "d": "M12 19l0 2", "key": "svg-3" }], ["path", { "d": "M3 12l2 0", "key": "svg-4" }], ["path", { "d": "M19 12l2 0", "key": "svg-5" }]]);

var IconCompass$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCompass
});

var IconComponentsOff = createReactComponent("outline", "components-off", "IconComponentsOff", [["path", { "d": "M3 12l3 3l3 -3l-3 -3z", "key": "svg-0" }], ["path", { "d": "M18.5 14.5l2.5 -2.5l-3 -3l-2.5 2.5", "key": "svg-1" }], ["path", { "d": "M12.499 8.501l2.501 -2.501l-3 -3l-2.5 2.5", "key": "svg-2" }], ["path", { "d": "M9 18l3 3l3 -3l-3 -3z", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconComponentsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconComponentsOff
});

var IconComponents = createReactComponent("outline", "components", "IconComponents", [["path", { "d": "M3 12l3 3l3 -3l-3 -3z", "key": "svg-0" }], ["path", { "d": "M15 12l3 3l3 -3l-3 -3z", "key": "svg-1" }], ["path", { "d": "M9 6l3 3l3 -3l-3 -3z", "key": "svg-2" }], ["path", { "d": "M9 18l3 3l3 -3l-3 -3z", "key": "svg-3" }]]);

var IconComponents$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconComponents
});

var IconCone2 = createReactComponent("outline", "cone-2", "IconCone2", [["path", { "d": "M21 5.002v.5l-8.13 14.99a1 1 0 0 1 -1.74 0l-8.13 -14.989v-.5c0 -1.659 4.03 -3.003 9 -3.003s9 1.344 9 3.002", "key": "svg-0" }]]);

var IconCone2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCone2
});

var IconConeOff = createReactComponent("outline", "cone-off", "IconConeOff", [["path", { "d": "M20.396 16.384l-7.526 -13.877a1 1 0 0 0 -1.74 0l-1.626 2.998m-1.407 2.594l-5.097 9.398v.5c0 1.66 4.03 3.003 9 3.003c3.202 0 6.014 -.558 7.609 -1.398", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconConeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconConeOff
});

var IconConePlus = createReactComponent("outline", "cone-plus", "IconConePlus", [["path", { "d": "M18.03 12.022l-5.16 -9.515a1 1 0 0 0 -1.74 0l-8.13 14.99v.5c0 1.66 4.03 3.003 9 3.003c.17 0 .34 -.002 .508 -.005", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }]]);

var IconConePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconConePlus
});

var IconCone = createReactComponent("outline", "cone", "IconCone", [["path", { "d": "M21 17.998v-.5l-8.13 -14.99a1 1 0 0 0 -1.74 0l-8.13 14.989v.5c0 1.659 4.03 3.003 9 3.003s9 -1.344 9 -3.002", "key": "svg-0" }]]);

var IconCone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCone
});

var IconConfettiOff = createReactComponent("outline", "confetti-off", "IconConfettiOff", [["path", { "d": "M4 5h1", "key": "svg-0" }], ["path", { "d": "M5 5v1", "key": "svg-1" }], ["path", { "d": "M11.5 4l-.5 2", "key": "svg-2" }], ["path", { "d": "M18 5h2", "key": "svg-3" }], ["path", { "d": "M19 4v2", "key": "svg-4" }], ["path", { "d": "M15 9l-1 1", "key": "svg-5" }], ["path", { "d": "M18 13l2 -.5", "key": "svg-6" }], ["path", { "d": "M18 19h1", "key": "svg-7" }], ["path", { "d": "M19 19v1", "key": "svg-8" }], ["path", { "d": "M14 16.518l-6.518 -6.518l-4.39 9.58a1 1 0 0 0 1.329 1.329l9.579 -4.39v0z", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconConfettiOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconConfettiOff
});

var IconConfetti = createReactComponent("outline", "confetti", "IconConfetti", [["path", { "d": "M4 5h2", "key": "svg-0" }], ["path", { "d": "M5 4v2", "key": "svg-1" }], ["path", { "d": "M11.5 4l-.5 2", "key": "svg-2" }], ["path", { "d": "M18 5h2", "key": "svg-3" }], ["path", { "d": "M19 4v2", "key": "svg-4" }], ["path", { "d": "M15 9l-1 1", "key": "svg-5" }], ["path", { "d": "M18 13l2 -.5", "key": "svg-6" }], ["path", { "d": "M18 19h2", "key": "svg-7" }], ["path", { "d": "M19 18v2", "key": "svg-8" }], ["path", { "d": "M14 16.518l-6.518 -6.518l-4.39 9.58a1 1 0 0 0 1.329 1.329l9.579 -4.39z", "key": "svg-9" }]]);

var IconConfetti$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconConfetti
});

var IconConfucius = createReactComponent("outline", "confucius", "IconConfucius", [["path", { "d": "M9 19l3 2v-18", "key": "svg-0" }], ["path", { "d": "M4 10l8 -2", "key": "svg-1" }], ["path", { "d": "M4 18l8 -10", "key": "svg-2" }], ["path", { "d": "M20 18l-8 -8l8 -4", "key": "svg-3" }]]);

var IconConfucius$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconConfucius
});

var IconCongruentTo = createReactComponent("outline", "congruent-to", "IconCongruentTo", [["path", { "d": "M5 13h14", "key": "svg-0" }], ["path", { "d": "M5 17h14", "key": "svg-1" }], ["path", { "d": "M5 7.686c2.333 -2.624 4.667 -1.856 7 .064s4.667 2.688 7 .064", "key": "svg-2" }]]);

var IconCongruentTo$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCongruentTo
});

var IconContainerOff = createReactComponent("outline", "container-off", "IconContainerOff", [["path", { "d": "M20 4v.01", "key": "svg-0" }], ["path", { "d": "M20 20v.01", "key": "svg-1" }], ["path", { "d": "M20 16v.01", "key": "svg-2" }], ["path", { "d": "M20 12v.01", "key": "svg-3" }], ["path", { "d": "M20 8v.01", "key": "svg-4" }], ["path", { "d": "M8.297 4.289a1 1 0 0 1 .703 -.289h6a1 1 0 0 1 1 1v7m0 4v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1v-11", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 20v.01", "key": "svg-7" }], ["path", { "d": "M4 16v.01", "key": "svg-8" }], ["path", { "d": "M4 12v.01", "key": "svg-9" }], ["path", { "d": "M4 8v.01", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconContainerOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContainerOff
});

var IconContainer = createReactComponent("outline", "container", "IconContainer", [["path", { "d": "M20 4v.01", "key": "svg-0" }], ["path", { "d": "M20 20v.01", "key": "svg-1" }], ["path", { "d": "M20 16v.01", "key": "svg-2" }], ["path", { "d": "M20 12v.01", "key": "svg-3" }], ["path", { "d": "M20 8v.01", "key": "svg-4" }], ["path", { "d": "M8 4m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z", "key": "svg-5" }], ["path", { "d": "M4 4v.01", "key": "svg-6" }], ["path", { "d": "M4 20v.01", "key": "svg-7" }], ["path", { "d": "M4 16v.01", "key": "svg-8" }], ["path", { "d": "M4 12v.01", "key": "svg-9" }], ["path", { "d": "M4 8v.01", "key": "svg-10" }]]);

var IconContainer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContainer
});

var IconContract = createReactComponent("outline", "contract", "IconContract", [["path", { "d": "M8 21h-2a3 3 0 0 1 -3 -3v-1h5.5", "key": "svg-0" }], ["path", { "d": "M17 8.5v-3.5a2 2 0 1 1 2 2h-2", "key": "svg-1" }], ["path", { "d": "M19 3h-11a3 3 0 0 0 -3 3v11", "key": "svg-2" }], ["path", { "d": "M9 7h4", "key": "svg-3" }], ["path", { "d": "M9 11h4", "key": "svg-4" }], ["path", { "d": "M18.42 12.61a2.1 2.1 0 0 1 2.97 2.97l-6.39 6.42h-3v-3z", "key": "svg-5" }]]);

var IconContract$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContract
});

var IconContrast2Off = createReactComponent("outline", "contrast-2-off", "IconContrast2Off", [["path", { "d": "M4 18h2a6 6 0 0 0 6 -6m.878 -3.126a6 6 0 0 1 5.122 -2.874h2", "key": "svg-0" }], ["path", { "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconContrast2Off$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContrast2Off
});

var IconContrast2 = createReactComponent("outline", "contrast-2", "IconContrast2", [["path", { "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M3 19h2.25c3.728 0 6.75 -3.134 6.75 -7s3.022 -7 6.75 -7h2.25", "key": "svg-1" }]]);

var IconContrast2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContrast2
});

var IconContrastOff = createReactComponent("outline", "contrast-off", "IconContrastOff", [["path", { "d": "M12 12v5a4.984 4.984 0 0 0 3.522 -1.45m1.392 -2.623a5 5 0 0 0 -4.914 -5.927v1", "key": "svg-0" }], ["path", { "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconContrastOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContrastOff
});

var IconContrast = createReactComponent("outline", "contrast", "IconContrast", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 17a5 5 0 0 0 0 -10v10", "key": "svg-1" }]]);

var IconContrast$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconContrast
});

var IconCooker = createReactComponent("outline", "cooker", "IconCooker", [["path", { "d": "M12 7h.01", "key": "svg-0" }], ["path", { "d": "M15 7h.01", "key": "svg-1" }], ["path", { "d": "M9 7h.01", "key": "svg-2" }], ["path", { "d": "M5 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z", "key": "svg-3" }], ["path", { "d": "M9 15h6", "key": "svg-4" }], ["path", { "d": "M5 11h14", "key": "svg-5" }]]);

var IconCooker$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCooker
});

var IconCookieMan = createReactComponent("outline", "cookie-man", "IconCookieMan", [["path", { "d": "M12 2a5 5 0 0 1 2.845 9.112l.147 .369l1.755 -.803c.969 -.443 2.12 -.032 2.571 .918a1.88 1.88 0 0 1 -.787 2.447l-.148 .076l-2.383 1.089v2.02l1.426 1.425l.114 .125a1.96 1.96 0 0 1 -2.762 2.762l-.125 -.114l-2.079 -2.08l-.114 -.124a2 2 0 0 1 -.161 -.22h-.599q -.071 .114 -.16 .22l-.115 .125l-2.08 2.079a1.96 1.96 0 0 1 -2.886 -2.648l.114 -.125l1.427 -1.426v-2.019l-2.383 -1.09l-.148 -.075a1.88 1.88 0 0 1 -.787 -2.447c.429 -.902 1.489 -1.318 2.424 -.978l.147 .06l1.755 .803l.147 -.369a5 5 0 0 1 -2.15 -3.895v-.217a5 5 0 0 1 5 -5z", "key": "svg-1" }], ["path", { "d": "M12 16h.01", "key": "svg-2" }], ["path", { "d": "M12 13h.01", "key": "svg-3" }], ["path", { "d": "M10 7h.01", "key": "svg-4" }], ["path", { "d": "M14 7h.01", "key": "svg-5" }], ["path", { "d": "M12 9h.01", "key": "svg-6" }]]);

var IconCookieMan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCookieMan
});

var IconCookieOff = createReactComponent("outline", "cookie-off", "IconCookieOff", [["path", { "d": "M8 13v.01", "key": "svg-0" }], ["path", { "d": "M12 17v.01", "key": "svg-1" }], ["path", { "d": "M12 12v.01", "key": "svg-2" }], ["path", { "d": "M18.192 18.187a3 3 0 0 1 -.976 .652c-1.048 .263 -1.787 .483 -2.216 .661c-.475 .197 -1.092 .538 -1.852 1.024a3 3 0 0 1 -2.296 0c-.802 -.503 -1.419 -.844 -1.852 -1.024c-.471 -.195 -1.21 -.415 -2.216 -.66a3 3 0 0 1 -1.623 -1.624c-.265 -1.052 -.485 -1.79 -.661 -2.216c-.198 -.479 -.54 -1.096 -1.024 -1.852a3 3 0 0 1 0 -2.296c.48 -.744 .82 -1.361 1.024 -1.852c.171 -.413 .391 -1.152 .66 -2.216a3 3 0 0 1 .649 -.971m2.821 -1.174c.14 -.049 .263 -.095 .37 -.139c.458 -.19 1.075 -.531 1.852 -1.024a3 3 0 0 1 2.296 0l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296c-.497 .786 -.838 1.404 -1.024 1.852a6.579 6.579 0 0 0 -.135 .36", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCookieOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCookieOff
});

var IconCookie = createReactComponent("outline", "cookie", "IconCookie", [["path", { "d": "M8 13v.01", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M12 12v.01", "key": "svg-3" }], ["path", { "d": "M16 14v.01", "key": "svg-4" }], ["path", { "d": "M11 8v.01", "key": "svg-5" }], ["path", { "d": "M13.148 3.476l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296q -.745 1.18 -1.024 1.852q -.283 .684 -.66 2.216a3 3 0 0 1 -1.624 1.623q -1.572 .394 -2.216 .661q -.712 .295 -1.852 1.024a3 3 0 0 1 -2.296 0q -1.203 -.754 -1.852 -1.024q -.707 -.292 -2.216 -.66a3 3 0 0 1 -1.623 -1.624q -.397 -1.577 -.661 -2.216q -.298 -.718 -1.024 -1.852a3 3 0 0 1 0 -2.296q .719 -1.116 1.024 -1.852q .257 -.62 .66 -2.216a3 3 0 0 1 1.624 -1.623q 1.547 -.384 2.216 -.661q .687 -.285 1.852 -1.024a3 3 0 0 1 2.296 0", "key": "svg-6" }]]);

var IconCookie$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCookie
});

var IconCopyCheck = createReactComponent("outline", "copy-check", "IconCopyCheck", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14l2 2l4 -4", "key": "svg-3" }]]);

var IconCopyCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyCheck
});

var IconCopyMinus = createReactComponent("outline", "copy-minus", "IconCopyMinus", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14h6", "key": "svg-3" }]]);

var IconCopyMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyMinus
});

var IconCopyOff = createReactComponent("outline", "copy-off", "IconCopyOff", [["path", { "d": "M19.414 19.415a2 2 0 0 1 -1.414 .585h-8a2 2 0 0 1 -2 -2v-8c0 -.554 .225 -1.055 .589 -1.417m3.411 -.583h6a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M16 8v-2a2 2 0 0 0 -2 -2h-6m-3.418 .59c-.36 .36 -.582 .86 -.582 1.41v8a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyOff
});

var IconCopyPlus = createReactComponent("outline", "copy-plus", "IconCopyPlus", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11 14h6", "key": "svg-3" }], ["path", { "d": "M14 11v6", "key": "svg-4" }]]);

var IconCopyPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyPlus
});

var IconCopyX = createReactComponent("outline", "copy-x", "IconCopyX", [["path", { "d": "M7 9.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-1" }], ["path", { "d": "M4.012 16.737a2 2 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-2" }], ["path", { "d": "M11.5 11.5l4.9 5", "key": "svg-3" }], ["path", { "d": "M16.5 11.5l-5.1 5", "key": "svg-4" }]]);

var IconCopyX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyX
});

var IconCopy = createReactComponent("outline", "copy", "IconCopy", [["path", { "d": "M7 7m0 2.667a2.667 2.667 0 0 1 2.667 -2.667h8.666a2.667 2.667 0 0 1 2.667 2.667v8.666a2.667 2.667 0 0 1 -2.667 2.667h-8.666a2.667 2.667 0 0 1 -2.667 -2.667z", "key": "svg-0" }], ["path", { "d": "M4.012 16.737a2.005 2.005 0 0 1 -1.012 -1.737v-10c0 -1.1 .9 -2 2 -2h10c.75 0 1.158 .385 1.5 1", "key": "svg-1" }]]);

var IconCopy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopy
});

var IconCopyleftOff = createReactComponent("outline", "copyleft-off", "IconCopyleftOff", [["path", { "d": "M13.303 9.3a3.01 3.01 0 0 1 1.405 1.406m-.586 3.413a3.016 3.016 0 0 1 -4.122 .131", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyleftOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyleftOff
});

var IconCopyleft = createReactComponent("outline", "copyleft", "IconCopyleft", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10 9.75a3.016 3.016 0 0 1 4.163 .173a2.993 2.993 0 0 1 0 4.154a3.016 3.016 0 0 1 -4.163 .173", "key": "svg-1" }]]);

var IconCopyleft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyleft
});

var IconCopyrightOff = createReactComponent("outline", "copyright-off", "IconCopyrightOff", [["path", { "d": "M14 9.75a3.016 3.016 0 0 0 -.711 -.466m-3.41 .596a2.993 2.993 0 0 0 -.042 4.197a3.016 3.016 0 0 0 4.163 .173", "key": "svg-0" }], ["path", { "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCopyrightOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyrightOff
});

var IconCopyright = createReactComponent("outline", "copyright", "IconCopyright", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M14 9.75a3.016 3.016 0 0 0 -4.163 .173a2.993 2.993 0 0 0 0 4.154a3.016 3.016 0 0 0 4.163 .173", "key": "svg-1" }]]);

var IconCopyright$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCopyright
});

var IconCornerDownLeftDouble = createReactComponent("outline", "corner-down-left-double", "IconCornerDownLeftDouble", [["path", { "d": "M19 5v6a3 3 0 0 1 -3 3h-7", "key": "svg-0" }], ["path", { "d": "M13 10l-4 4l4 4m-5 -8l-4 4l4 4", "key": "svg-1" }]]);

var IconCornerDownLeftDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerDownLeftDouble
});

var IconCornerDownLeft = createReactComponent("outline", "corner-down-left", "IconCornerDownLeft", [["path", { "d": "M18 6v6a3 3 0 0 1 -3 3h-10l4 -4m0 8l-4 -4", "key": "svg-0" }]]);

var IconCornerDownLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerDownLeft
});

var IconCornerDownRightDouble = createReactComponent("outline", "corner-down-right-double", "IconCornerDownRightDouble", [["path", { "d": "M4 5v6a3 3 0 0 0 3 3h7", "key": "svg-0" }], ["path", { "d": "M10 10l4 4l-4 4m5 -8l4 4l-4 4", "key": "svg-1" }]]);

var IconCornerDownRightDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerDownRightDouble
});

var IconCornerDownRight = createReactComponent("outline", "corner-down-right", "IconCornerDownRight", [["path", { "d": "M6 6v6a3 3 0 0 0 3 3h10l-4 -4m0 8l4 -4", "key": "svg-0" }]]);

var IconCornerDownRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerDownRight
});

var IconCornerLeftDownDouble = createReactComponent("outline", "corner-left-down-double", "IconCornerLeftDownDouble", [["path", { "d": "M18 4h-6a3 3 0 0 0 -3 3v7", "key": "svg-0" }], ["path", { "d": "M13 10l-4 4l-4 -4m8 5l-4 4l-4 -4", "key": "svg-1" }]]);

var IconCornerLeftDownDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerLeftDownDouble
});

var IconCornerLeftDown = createReactComponent("outline", "corner-left-down", "IconCornerLeftDown", [["path", { "d": "M18 6h-6a3 3 0 0 0 -3 3v10l-4 -4m8 0l-4 4", "key": "svg-0" }]]);

var IconCornerLeftDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerLeftDown
});

var IconCornerLeftUpDouble = createReactComponent("outline", "corner-left-up-double", "IconCornerLeftUpDouble", [["path", { "d": "M18 19h-6a3 3 0 0 1 -3 -3v-7", "key": "svg-0" }], ["path", { "d": "M13 13l-4 -4l-4 4m8 -5l-4 -4l-4 4", "key": "svg-1" }]]);

var IconCornerLeftUpDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerLeftUpDouble
});

var IconCornerLeftUp = createReactComponent("outline", "corner-left-up", "IconCornerLeftUp", [["path", { "d": "M18 18h-6a3 3 0 0 1 -3 -3v-10l-4 4m8 0l-4 -4", "key": "svg-0" }]]);

var IconCornerLeftUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerLeftUp
});

var IconCornerRightDownDouble = createReactComponent("outline", "corner-right-down-double", "IconCornerRightDownDouble", [["path", { "d": "M5 4h6a3 3 0 0 1 3 3v7", "key": "svg-0" }], ["path", { "d": "M10 10l4 4l4 -4m-8 5l4 4l4 -4", "key": "svg-1" }]]);

var IconCornerRightDownDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerRightDownDouble
});

var IconCornerRightDown = createReactComponent("outline", "corner-right-down", "IconCornerRightDown", [["path", { "d": "M6 6h6a3 3 0 0 1 3 3v10l-4 -4m8 0l-4 4", "key": "svg-0" }]]);

var IconCornerRightDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerRightDown
});

var IconCornerRightUpDouble = createReactComponent("outline", "corner-right-up-double", "IconCornerRightUpDouble", [["path", { "d": "M5 19h6a3 3 0 0 0 3 -3v-7", "key": "svg-0" }], ["path", { "d": "M10 13l4 -4l4 4m-8 -5l4 -4l4 4", "key": "svg-1" }]]);

var IconCornerRightUpDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerRightUpDouble
});

var IconCornerRightUp = createReactComponent("outline", "corner-right-up", "IconCornerRightUp", [["path", { "d": "M6 18h6a3 3 0 0 0 3 -3v-10l-4 4m8 0l-4 -4", "key": "svg-0" }]]);

var IconCornerRightUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerRightUp
});

var IconCornerUpLeftDouble = createReactComponent("outline", "corner-up-left-double", "IconCornerUpLeftDouble", [["path", { "d": "M19 18v-6a3 3 0 0 0 -3 -3h-7", "key": "svg-0" }], ["path", { "d": "M13 13l-4 -4l4 -4m-5 8l-4 -4l4 -4", "key": "svg-1" }]]);

var IconCornerUpLeftDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerUpLeftDouble
});

var IconCornerUpLeft = createReactComponent("outline", "corner-up-left", "IconCornerUpLeft", [["path", { "d": "M18 18v-6a3 3 0 0 0 -3 -3h-10l4 -4m0 8l-4 -4", "key": "svg-0" }]]);

var IconCornerUpLeft$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerUpLeft
});

var IconCornerUpRightDouble = createReactComponent("outline", "corner-up-right-double", "IconCornerUpRightDouble", [["path", { "d": "M4 18v-6a3 3 0 0 1 3 -3h7", "key": "svg-0" }], ["path", { "d": "M10 13l4 -4l-4 -4m5 8l4 -4l-4 -4", "key": "svg-1" }]]);

var IconCornerUpRightDouble$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerUpRightDouble
});

var IconCornerUpRight = createReactComponent("outline", "corner-up-right", "IconCornerUpRight", [["path", { "d": "M6 18v-6a3 3 0 0 1 3 -3h10l-4 -4m0 8l4 -4", "key": "svg-0" }]]);

var IconCornerUpRight$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCornerUpRight
});

var IconCpu2 = createReactComponent("outline", "cpu-2", "IconCpu2", [["path", { "d": "M5 5m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M8 10v-2h2m6 6v2h-2m-4 0h-2v-2m8 -4v-2h-2", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }]]);

var IconCpu2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCpu2
});

var IconCpuOff = createReactComponent("outline", "cpu-off", "IconCpuOff", [["path", { "d": "M9 5h9a1 1 0 0 1 1 1v9m-.292 3.706a1 1 0 0 1 -.708 .294h-12a1 1 0 0 1 -1 -1v-12c0 -.272 .108 -.518 .284 -.698", "key": "svg-0" }], ["path", { "d": "M13 9h2v2m0 4h-6v-6", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }], ["path", { "d": "M3 3l18 18", "key": "svg-10" }]]);

var IconCpuOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCpuOff
});

var IconCpu = createReactComponent("outline", "cpu", "IconCpu", [["path", { "d": "M5 5m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M9 9h6v6h-6z", "key": "svg-1" }], ["path", { "d": "M3 10h2", "key": "svg-2" }], ["path", { "d": "M3 14h2", "key": "svg-3" }], ["path", { "d": "M10 3v2", "key": "svg-4" }], ["path", { "d": "M14 3v2", "key": "svg-5" }], ["path", { "d": "M21 10h-2", "key": "svg-6" }], ["path", { "d": "M21 14h-2", "key": "svg-7" }], ["path", { "d": "M14 21v-2", "key": "svg-8" }], ["path", { "d": "M10 21v-2", "key": "svg-9" }]]);

var IconCpu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCpu
});

var IconCraneOff = createReactComponent("outline", "crane-off", "IconCraneOff", [["path", { "d": "M6 21h6", "key": "svg-0" }], ["path", { "d": "M9 21v-12", "key": "svg-1" }], ["path", { "d": "M9 5v-2l-1 1", "key": "svg-2" }], ["path", { "d": "M6 6l-3 3h6", "key": "svg-3" }], ["path", { "d": "M13 9h8", "key": "svg-4" }], ["path", { "d": "M9 3l10 6", "key": "svg-5" }], ["path", { "d": "M17 9v4a2 2 0 0 1 2 2m-2 2a2 2 0 0 1 -2 -2", "key": "svg-6" }], ["path", { "d": "M3 3l18 18", "key": "svg-7" }]]);

var IconCraneOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCraneOff
});

var IconCrane = createReactComponent("outline", "crane", "IconCrane", [["path", { "d": "M6 21h6", "key": "svg-0" }], ["path", { "d": "M9 21v-18l-6 6h18", "key": "svg-1" }], ["path", { "d": "M9 3l10 6", "key": "svg-2" }], ["path", { "d": "M17 9v4a2 2 0 1 1 -2 2", "key": "svg-3" }]]);

var IconCrane$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrane
});

var IconCreativeCommonsBy = createReactComponent("outline", "creative-commons-by", "IconCreativeCommonsBy", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 7m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-1" }], ["path", { "d": "M9 13v-1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-.5l-.5 4h-2l-.5 -4h-.5a1 1 0 0 1 -1 -1z", "key": "svg-2" }]]);

var IconCreativeCommonsBy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsBy
});

var IconCreativeCommonsNc = createReactComponent("outline", "creative-commons-nc", "IconCreativeCommonsNc", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M15 9h-4.5a1.5 1.5 0 0 0 0 3h3a1.5 1.5 0 0 1 0 3h-4.5", "key": "svg-1" }], ["path", { "d": "M12 7v2", "key": "svg-2" }], ["path", { "d": "M12 15v2", "key": "svg-3" }], ["path", { "d": "M6 6l3 3", "key": "svg-4" }], ["path", { "d": "M15 15l3 3", "key": "svg-5" }]]);

var IconCreativeCommonsNc$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsNc
});

var IconCreativeCommonsNd = createReactComponent("outline", "creative-commons-nd", "IconCreativeCommonsNd", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M9 10h6", "key": "svg-1" }], ["path", { "d": "M9 14h6", "key": "svg-2" }]]);

var IconCreativeCommonsNd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsNd
});

var IconCreativeCommonsOff = createReactComponent("outline", "creative-commons-off", "IconCreativeCommonsOff", [["path", { "d": "M5.638 5.634a9 9 0 1 0 12.723 12.733m1.686 -2.332a9 9 0 0 0 -12.093 -12.077", "key": "svg-0" }], ["path", { "d": "M10.5 10.5a2.187 2.187 0 0 0 -2.914 .116a1.928 1.928 0 0 0 0 2.768a2.188 2.188 0 0 0 2.914 .116", "key": "svg-1" }], ["path", { "d": "M16.5 10.5a2.194 2.194 0 0 0 -2.309 -.302", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCreativeCommonsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsOff
});

var IconCreativeCommonsSa = createReactComponent("outline", "creative-commons-sa", "IconCreativeCommonsSa", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 16a4 4 0 1 0 -4 -4v1", "key": "svg-1" }], ["path", { "d": "M6 12l2 2l2 -2", "key": "svg-2" }]]);

var IconCreativeCommonsSa$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsSa
});

var IconCreativeCommonsZero = createReactComponent("outline", "creative-commons-zero", "IconCreativeCommonsZero", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M12 12m-3 0a3 4 0 1 0 6 0a3 4 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M14 9l-4 6", "key": "svg-2" }]]);

var IconCreativeCommonsZero$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommonsZero
});

var IconCreativeCommons = createReactComponent("outline", "creative-commons", "IconCreativeCommons", [["path", { "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0", "key": "svg-0" }], ["path", { "d": "M10.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116", "key": "svg-1" }], ["path", { "d": "M16.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116", "key": "svg-2" }]]);

var IconCreativeCommons$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreativeCommons
});

var IconCreditCardOff = createReactComponent("outline", "credit-card-off", "IconCreditCardOff", [["path", { "d": "M3 3l18 18", "key": "svg-0" }], ["path", { "d": "M9 5h9a3 3 0 0 1 3 3v8a3 3 0 0 1 -.128 .87", "key": "svg-1" }], ["path", { "d": "M18.87 18.872a3 3 0 0 1 -.87 .128h-12a3 3 0 0 1 -3 -3v-8c0 -1.352 .894 -2.495 2.124 -2.87", "key": "svg-2" }], ["path", { "d": "M3 11l8 0", "key": "svg-3" }], ["path", { "d": "M15 11l6 0", "key": "svg-4" }], ["path", { "d": "M7 15l.01 0", "key": "svg-5" }], ["path", { "d": "M11 15l2 0", "key": "svg-6" }]]);

var IconCreditCardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreditCardOff
});

var IconCreditCardPay = createReactComponent("outline", "credit-card-pay", "IconCreditCardPay", [["path", { "d": "M12 19h-6a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5", "key": "svg-0" }], ["path", { "d": "M3 10h18", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-3" }], ["path", { "d": "M7.005 15h.005", "key": "svg-4" }], ["path", { "d": "M11 15h2", "key": "svg-5" }]]);

var IconCreditCardPay$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreditCardPay
});

var IconCreditCardRefund = createReactComponent("outline", "credit-card-refund", "IconCreditCardRefund", [["path", { "d": "M12 19h-6a3 3 0 0 1 -3 -3v-8a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v4.5", "key": "svg-0" }], ["path", { "d": "M3 10h18", "key": "svg-1" }], ["path", { "d": "M7 15h.01", "key": "svg-2" }], ["path", { "d": "M11 15h2", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l-3 3l3 3", "key": "svg-5" }]]);

var IconCreditCardRefund$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreditCardRefund
});

var IconCreditCard = createReactComponent("outline", "credit-card", "IconCreditCard", [["path", { "d": "M3 5m0 3a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v8a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3z", "key": "svg-0" }], ["path", { "d": "M3 10l18 0", "key": "svg-1" }], ["path", { "d": "M7 15l.01 0", "key": "svg-2" }], ["path", { "d": "M11 15l2 0", "key": "svg-3" }]]);

var IconCreditCard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCreditCard
});

var IconCricket = createReactComponent("outline", "cricket", "IconCricket", [["path", { "d": "M11.105 18.79l-1 .992a4.159 4.159 0 0 1 -6.038 -5.715l.157 -.166l8.282 -8.401l1.5 1.5l3.45 -3.391a2.08 2.08 0 0 1 3.057 2.815l-.116 .126l-3.391 3.45l1.5 1.5l-3.668 3.617", "key": "svg-0" }], ["path", { "d": "M10.5 7.5l6 6", "key": "svg-1" }], ["path", { "d": "M14 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }]]);

var IconCricket$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCricket
});

var IconCrop11 = createReactComponent("outline", "crop-1-1", "IconCrop11", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop11$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop11
});

var IconCrop169 = createReactComponent("outline", "crop-16-9", "IconCrop169", [["path", { "d": "M4 8m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop169$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop169
});

var IconCrop32 = createReactComponent("outline", "crop-3-2", "IconCrop32", [["path", { "d": "M4 7m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop32$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop32
});

var IconCrop54 = createReactComponent("outline", "crop-5-4", "IconCrop54", [["path", { "d": "M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop54$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop54
});

var IconCrop75 = createReactComponent("outline", "crop-7-5", "IconCrop75", [["path", { "d": "M4 6m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCrop75$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop75
});

var IconCropLandscape = createReactComponent("outline", "crop-landscape", "IconCropLandscape", [["path", { "d": "M4 6m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCropLandscape$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCropLandscape
});

var IconCropPortrait = createReactComponent("outline", "crop-portrait", "IconCropPortrait", [["path", { "d": "M6 4m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }]]);

var IconCropPortrait$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCropPortrait
});

var IconCrop = createReactComponent("outline", "crop", "IconCrop", [["path", { "d": "M8 5v10a1 1 0 0 0 1 1h10", "key": "svg-0" }], ["path", { "d": "M5 8h10a1 1 0 0 1 1 1v10", "key": "svg-1" }]]);

var IconCrop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrop
});

var IconCrossOff = createReactComponent("outline", "cross-off", "IconCrossOff", [["path", { "d": "M16 12h3v-4h-5v-5h-4v3m-2 2h-3v4h5v9h4v-7", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCrossOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrossOff
});

var IconCross = createReactComponent("outline", "cross", "IconCross", [["path", { "d": "M10 21h4v-9h5v-4h-5v-5h-4v5h-5v4h5z", "key": "svg-0" }]]);

var IconCross$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCross
});

var IconCrosshair = createReactComponent("outline", "crosshair", "IconCrosshair", [["path", { "d": "M4 8v-2a2 2 0 0 1 2 -2h2", "key": "svg-0" }], ["path", { "d": "M4 16v2a2 2 0 0 0 2 2h2", "key": "svg-1" }], ["path", { "d": "M16 4h2a2 2 0 0 1 2 2v2", "key": "svg-2" }], ["path", { "d": "M16 20h2a2 2 0 0 0 2 -2v-2", "key": "svg-3" }], ["path", { "d": "M9 12l6 0", "key": "svg-4" }], ["path", { "d": "M12 9l0 6", "key": "svg-5" }]]);

var IconCrosshair$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrosshair
});

var IconCrownOff = createReactComponent("outline", "crown-off", "IconCrownOff", [["path", { "d": "M18 18h-13l-1.865 -9.327a.25 .25 0 0 1 .4 -.244l4.465 3.571l1.6 -2.4m1.596 -2.394l.804 -1.206l4 6l4.464 -3.571a.25 .25 0 0 1 .401 .244l-1.363 6.818", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCrownOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrownOff
});

var IconCrown = createReactComponent("outline", "crown", "IconCrown", [["path", { "d": "M12 6l4 6l5 -4l-2 10h-14l-2 -10l5 4z", "key": "svg-0" }]]);

var IconCrown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrown
});

var IconCrutchesOff = createReactComponent("outline", "crutches-off", "IconCrutchesOff", [["path", { "d": "M8.178 4.174a2 2 0 0 1 1.822 -1.174h4a2 2 0 1 1 0 4h-3", "key": "svg-0" }], ["path", { "d": "M11 21h2", "key": "svg-1" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .097 -.155m.407 -3.601v-3", "key": "svg-2" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-2.092", "key": "svg-3" }], ["path", { "d": "M10 11h1", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCrutchesOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrutchesOff
});

var IconCrutches = createReactComponent("outline", "crutches", "IconCrutches", [["path", { "d": "M8 3m0 2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-4a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 21h2", "key": "svg-1" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .504 -1.664v-5.092", "key": "svg-2" }], ["path", { "d": "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-5.092", "key": "svg-3" }], ["path", { "d": "M10 11h4", "key": "svg-4" }]]);

var IconCrutches$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrutches
});

var IconCrystalBall = createReactComponent("outline", "crystal-ball", "IconCrystalBall", [["path", { "d": "M6.73 17.018a8 8 0 1 1 10.54 0", "key": "svg-0" }], ["path", { "d": "M5 19a2 2 0 0 0 2 2h10a2 2 0 1 0 0 -4h-10a2 2 0 0 0 -2 2z", "key": "svg-1" }], ["path", { "d": "M11 7a3 3 0 0 0 -3 3", "key": "svg-2" }]]);

var IconCrystalBall$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCrystalBall
});

var IconCsv = createReactComponent("outline", "csv", "IconCsv", [["path", { "d": "M10 15a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 1 -1 -1v-2a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1", "key": "svg-0" }], ["path", { "d": "M17 8l2 8l2 -8", "key": "svg-1" }], ["path", { "d": "M7 10a2 2 0 1 0 -4 0v4a2 2 0 1 0 4 0", "key": "svg-2" }]]);

var IconCsv$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCsv
});

var IconCube3dSphereOff = createReactComponent("outline", "cube-3d-sphere-off", "IconCube3dSphereOff", [["path", { "d": "M6 17.6l-2 -1.1v-2.5", "key": "svg-0" }], ["path", { "d": "M4 10v-2.5l2 -1.1", "key": "svg-1" }], ["path", { "d": "M10 4.1l2 -1.1l2 1.1", "key": "svg-2" }], ["path", { "d": "M18 6.4l2 1.1v2.5", "key": "svg-3" }], ["path", { "d": "M20 14v2", "key": "svg-4" }], ["path", { "d": "M14 19.9l-2 1.1l-2 -1.1", "key": "svg-5" }], ["path", { "d": "M18 8.6l2 -1.1", "key": "svg-6" }], ["path", { "d": "M12 12v2.5", "key": "svg-7" }], ["path", { "d": "M12 18.5v2.5", "key": "svg-8" }], ["path", { "d": "M12 12l-2 -1.12", "key": "svg-9" }], ["path", { "d": "M6 8.6l-2 -1.1", "key": "svg-10" }], ["path", { "d": "M3 3l18 18", "key": "svg-11" }]]);

var IconCube3dSphereOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCube3dSphereOff
});

var IconCube3dSphere = createReactComponent("outline", "cube-3d-sphere", "IconCube3dSphere", [["path", { "d": "M6 17.6l-2 -1.1v-2.5", "key": "svg-0" }], ["path", { "d": "M4 10v-2.5l2 -1.1", "key": "svg-1" }], ["path", { "d": "M10 4.1l2 -1.1l2 1.1", "key": "svg-2" }], ["path", { "d": "M18 6.4l2 1.1v2.5", "key": "svg-3" }], ["path", { "d": "M20 14v2.5l-2 1.12", "key": "svg-4" }], ["path", { "d": "M14 19.9l-2 1.1l-2 -1.1", "key": "svg-5" }], ["path", { "d": "M12 12l2 -1.1", "key": "svg-6" }], ["path", { "d": "M18 8.6l2 -1.1", "key": "svg-7" }], ["path", { "d": "M12 12l0 2.5", "key": "svg-8" }], ["path", { "d": "M12 18.5l0 2.5", "key": "svg-9" }], ["path", { "d": "M12 12l-2 -1.12", "key": "svg-10" }], ["path", { "d": "M6 8.6l-2 -1.1", "key": "svg-11" }]]);

var IconCube3dSphere$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCube3dSphere
});

var IconCubeOff = createReactComponent("outline", "cube-off", "IconCubeOff", [["path", { "d": "M20.83 16.809c.11 -.248 .17 -.52 .17 -.801v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-3.012 1.725m-2.547 1.458l-1.441 .825c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0l5.544 -3.174", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M14.532 10.538l6.198 -3.578", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCubeOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCubeOff
});

var IconCubePlus = createReactComponent("outline", "cube-plus", "IconCubePlus", [["path", { "d": "M21 12.5v-4.509a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.007c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconCubePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCubePlus
});

var IconCubeSend = createReactComponent("outline", "cube-send", "IconCubeSend", [["path", { "d": "M16 12.5l-5 -3l5 -3l5 3v5.5l-5 3z", "key": "svg-0" }], ["path", { "d": "M11 9.5v5.5l5 3", "key": "svg-1" }], ["path", { "d": "M16 12.545l5 -3.03", "key": "svg-2" }], ["path", { "d": "M7 9h-5", "key": "svg-3" }], ["path", { "d": "M7 12h-3", "key": "svg-4" }], ["path", { "d": "M7 15h-1", "key": "svg-5" }]]);

var IconCubeSend$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCubeSend
});

var IconCubeSpark = createReactComponent("outline", "cube-spark", "IconCubeSpark", [["path", { "d": "M21 12v-4.01a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.02 2.02 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008c.62 .354 1.38 .354 2 0", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }], ["path", { "d": "M19 22.5a4.75 4.75 0 0 1 3.5 -3.5a4.75 4.75 0 0 1 -3.5 -3.5a4.75 4.75 0 0 1 -3.5 3.5a4.75 4.75 0 0 1 3.5 3.5", "key": "svg-4" }]]);

var IconCubeSpark$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCubeSpark
});

var IconCubeUnfolded = createReactComponent("outline", "cube-unfolded", "IconCubeUnfolded", [["path", { "d": "M2 15h10v5h5v-5h5v-5h-10v-5h-5v5h-5z", "key": "svg-0" }], ["path", { "d": "M7 15v-5h5v5h5v-5", "key": "svg-1" }]]);

var IconCubeUnfolded$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCubeUnfolded
});

var IconCube = createReactComponent("outline", "cube", "IconCube", [["path", { "d": "M21 16.008v-8.018a1.98 1.98 0 0 0 -1 -1.717l-7 -4.008a2.016 2.016 0 0 0 -2 0l-7 4.008c-.619 .355 -1 1.01 -1 1.718v8.018c0 .709 .381 1.363 1 1.717l7 4.008a2.016 2.016 0 0 0 2 0l7 -4.008c.619 -.355 1 -1.01 1 -1.718z", "key": "svg-0" }], ["path", { "d": "M12 22v-10", "key": "svg-1" }], ["path", { "d": "M12 12l8.73 -5.04", "key": "svg-2" }], ["path", { "d": "M3.27 6.96l8.73 5.04", "key": "svg-3" }]]);

var IconCube$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCube
});

var IconCupOff = createReactComponent("outline", "cup-off", "IconCupOff", [["path", { "d": "M8 8h-3v3h6m4 0h4v-3h-7", "key": "svg-0" }], ["path", { "d": "M17.5 11l-.323 2.154m-.525 3.497l-.652 4.349h-8l-1.5 -10", "key": "svg-1" }], ["path", { "d": "M6 8v-1c0 -.296 .064 -.577 .18 -.83m2.82 -1.17h7a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconCupOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCupOff
});

var IconCup = createReactComponent("outline", "cup", "IconCup", [["path", { "d": "M5 11h14v-3h-14z", "key": "svg-0" }], ["path", { "d": "M17.5 11l-1.5 10h-8l-1.5 -10", "key": "svg-1" }], ["path", { "d": "M6 8v-1a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v1", "key": "svg-2" }], ["path", { "d": "M15 5v-2", "key": "svg-3" }]]);

var IconCup$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCup
});

var IconCurling = createReactComponent("outline", "curling", "IconCurling", [["path", { "d": "M4 9m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v2a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z", "key": "svg-0" }], ["path", { "d": "M4 14h16", "key": "svg-1" }], ["path", { "d": "M8 5h6a2 2 0 0 1 2 2v2", "key": "svg-2" }]]);

var IconCurling$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurling
});

var IconCurlyLoop = createReactComponent("outline", "curly-loop", "IconCurlyLoop", [["path", { "d": "M21 8c-4 0 -7 2 -7 5a3 3 0 0 0 6 0c0 -3 -2.5 -5 -8 -5s-8 2 -8 5a3 3 0 0 0 6 0c0 -3 -3 -5 -7 -5", "key": "svg-0" }]]);

var IconCurlyLoop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurlyLoop
});

var IconCurrencyAfghani = createReactComponent("outline", "currency-afghani", "IconCurrencyAfghani", [["path", { "d": "M15 13h-3.5a3.5 3.5 0 1 1 3.5 -3.5v6.5h-7", "key": "svg-0" }], ["path", { "d": "M12 3v.01", "key": "svg-1" }], ["path", { "d": "M12 19v2", "key": "svg-2" }]]);

var IconCurrencyAfghani$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyAfghani
});

var IconCurrencyBahraini = createReactComponent("outline", "currency-bahraini", "IconCurrencyBahraini", [["path", { "d": "M3 10v1a4 4 0 0 0 4 4h2a2 2 0 0 0 2 -2v-3", "key": "svg-0" }], ["path", { "d": "M7 19.01v-.01", "key": "svg-1" }], ["path", { "d": "M14 15.01v-.01", "key": "svg-2" }], ["path", { "d": "M17 15h2a2 2 0 0 0 1.649 -3.131l-2.653 -3.869", "key": "svg-3" }]]);

var IconCurrencyBahraini$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyBahraini
});

var IconCurrencyBaht = createReactComponent("outline", "currency-baht", "IconCurrencyBaht", [["path", { "d": "M8 6h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143", "key": "svg-0" }], ["path", { "d": "M8 12h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143", "key": "svg-1" }], ["path", { "d": "M8 6v12", "key": "svg-2" }], ["path", { "d": "M11 4v2", "key": "svg-3" }], ["path", { "d": "M11 18v2", "key": "svg-4" }]]);

var IconCurrencyBaht$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyBaht
});

var IconCurrencyBitcoin = createReactComponent("outline", "currency-bitcoin", "IconCurrencyBitcoin", [["path", { "d": "M6 6h8a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-8", "key": "svg-0" }], ["path", { "d": "M8 6l0 12", "key": "svg-1" }], ["path", { "d": "M8 12l6 0", "key": "svg-2" }], ["path", { "d": "M9 3l0 3", "key": "svg-3" }], ["path", { "d": "M13 3l0 3", "key": "svg-4" }], ["path", { "d": "M9 18l0 3", "key": "svg-5" }], ["path", { "d": "M13 18l0 3", "key": "svg-6" }]]);

var IconCurrencyBitcoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyBitcoin
});

var IconCurrencyCent = createReactComponent("outline", "currency-cent", "IconCurrencyCent", [["path", { "d": "M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a6 6 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4 -1.536", "key": "svg-0" }], ["path", { "d": "M12 20v-2", "key": "svg-1" }], ["path", { "d": "M12 6v-2", "key": "svg-2" }]]);

var IconCurrencyCent$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyCent
});

var IconCurrencyDinar = createReactComponent("outline", "currency-dinar", "IconCurrencyDinar", [["path", { "d": "M14 20.01v-.01", "key": "svg-0" }], ["path", { "d": "M6 13l2.386 -.9a1 1 0 0 0 -.095 -1.902l-1.514 -.404a1 1 0 0 1 -.102 -1.9l2.325 -.894", "key": "svg-1" }], ["path", { "d": "M3 14v1a3 3 0 0 0 3 3h4.161a3 3 0 0 0 2.983 -3.32l-1.144 -10.68", "key": "svg-2" }], ["path", { "d": "M16 17l1 1h2a2 2 0 0 0 1.649 -3.131l-2.653 -3.869", "key": "svg-3" }]]);

var IconCurrencyDinar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDinar
});

var IconCurrencyDirham = createReactComponent("outline", "currency-dirham", "IconCurrencyDirham", [["path", { "d": "M8.5 19h-3.5", "key": "svg-0" }], ["path", { "d": "M8.599 16.479a1.5 1.5 0 1 0 -1.099 2.521", "key": "svg-1" }], ["path", { "d": "M7 4v9", "key": "svg-2" }], ["path", { "d": "M15 13h1.888a1.5 1.5 0 0 0 1.296 -2.256l-2.184 -3.744", "key": "svg-3" }], ["path", { "d": "M11 13.01v-.01", "key": "svg-4" }]]);

var IconCurrencyDirham$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDirham
});

var IconCurrencyDogecoin = createReactComponent("outline", "currency-dogecoin", "IconCurrencyDogecoin", [["path", { "d": "M6 12h6", "key": "svg-0" }], ["path", { "d": "M9 6v12", "key": "svg-1" }], ["path", { "d": "M6 18h6a6 6 0 1 0 0 -12h-6", "key": "svg-2" }]]);

var IconCurrencyDogecoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDogecoin
});

var IconCurrencyDollarAustralian = createReactComponent("outline", "currency-dollar-australian", "IconCurrencyDollarAustralian", [["path", { "d": "M3 18l3.279 -11.476a.75 .75 0 0 1 1.442 0l3.279 11.476", "key": "svg-0" }], ["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }], ["path", { "d": "M4.5 14h5", "key": "svg-4" }]]);

var IconCurrencyDollarAustralian$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarAustralian
});

var IconCurrencyDollarBrunei = createReactComponent("outline", "currency-dollar-brunei", "IconCurrencyDollarBrunei", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6v12h4a3 3 0 0 0 0 -6h-4h4a3 3 0 0 0 0 -6h-4z", "key": "svg-3" }]]);

var IconCurrencyDollarBrunei$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarBrunei
});

var IconCurrencyDollarCanadian = createReactComponent("outline", "currency-dollar-canadian", "IconCurrencyDollarCanadian", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 18h-1a6 6 0 1 1 0 -12h1", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarCanadian$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarCanadian
});

var IconCurrencyDollarGuyanese = createReactComponent("outline", "currency-dollar-guyanese", "IconCurrencyDollarGuyanese", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 6h-3a4 4 0 0 0 -4 4v4a4 4 0 0 0 4 4h3v-6h-2", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarGuyanese$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarGuyanese
});

var IconCurrencyDollarOff = createReactComponent("outline", "currency-dollar-off", "IconCurrencyDollarOff", [["path", { "d": "M16.7 8a3 3 0 0 0 -2.7 -2h-4m-2.557 1.431a3 3 0 0 0 2.557 4.569h2m4.564 4.558a3 3 0 0 1 -2.564 1.442h-4a3 3 0 0 1 -2.7 -2", "key": "svg-0" }], ["path", { "d": "M12 3v3m0 12v3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCurrencyDollarOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarOff
});

var IconCurrencyDollarSingapore = createReactComponent("outline", "currency-dollar-singapore", "IconCurrencyDollarSingapore", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M10 6h-4a3 3 0 1 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-1" }], ["path", { "d": "M17 20v-2", "key": "svg-2" }], ["path", { "d": "M18 6v-2", "key": "svg-3" }]]);

var IconCurrencyDollarSingapore$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarSingapore
});

var IconCurrencyDollarZimbabwean = createReactComponent("outline", "currency-dollar-zimbabwean", "IconCurrencyDollarZimbabwean", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6h7l-7 12h7", "key": "svg-3" }]]);

var IconCurrencyDollarZimbabwean$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollarZimbabwean
});

var IconCurrencyDollar = createReactComponent("outline", "currency-dollar", "IconCurrencyDollar", [["path", { "d": "M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2", "key": "svg-0" }], ["path", { "d": "M12 3v3m0 12v3", "key": "svg-1" }]]);

var IconCurrencyDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDollar
});

var IconCurrencyDong = createReactComponent("outline", "currency-dong", "IconCurrencyDong", [["path", { "d": "M6 19h12", "key": "svg-0" }], ["path", { "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M16 16v-12", "key": "svg-2" }], ["path", { "d": "M17 5h-4", "key": "svg-3" }]]);

var IconCurrencyDong$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDong
});

var IconCurrencyDram = createReactComponent("outline", "currency-dram", "IconCurrencyDram", [["path", { "d": "M4 10a6 6 0 1 1 12 0v10", "key": "svg-0" }], ["path", { "d": "M12 16h8", "key": "svg-1" }], ["path", { "d": "M12 12h8", "key": "svg-2" }]]);

var IconCurrencyDram$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyDram
});

var IconCurrencyEthereum = createReactComponent("outline", "currency-ethereum", "IconCurrencyEthereum", [["path", { "d": "M6 12l6 -9l6 9l-6 9z", "key": "svg-0" }], ["path", { "d": "M6 12l6 -3l6 3l-6 2z", "key": "svg-1" }]]);

var IconCurrencyEthereum$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyEthereum
});

var IconCurrencyEuroOff = createReactComponent("outline", "currency-euro-off", "IconCurrencyEuroOff", [["path", { "d": "M17.2 7c-1.977 -2.26 -4.954 -2.602 -7.234 -1.04m-1.913 2.079c-1.604 2.72 -1.374 6.469 .69 8.894c2.292 2.691 6 2.758 8.356 .18", "key": "svg-0" }], ["path", { "d": "M10 10h-5m0 4h8", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCurrencyEuroOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyEuroOff
});

var IconCurrencyEuro = createReactComponent("outline", "currency-euro", "IconCurrencyEuro", [["path", { "d": "M17.2 7a6 7 0 1 0 0 10", "key": "svg-0" }], ["path", { "d": "M13 10h-8m0 4h8", "key": "svg-1" }]]);

var IconCurrencyEuro$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyEuro
});

var IconCurrencyFlorin = createReactComponent("outline", "currency-florin", "IconCurrencyFlorin", [["path", { "d": "M8 12h8", "key": "svg-0" }], ["path", { "d": "M7 19c1.213 0 2.31 -.723 2.788 -1.838l4.424 -10.324a3.033 3.033 0 0 1 2.788 -1.838", "key": "svg-1" }]]);

var IconCurrencyFlorin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyFlorin
});

var IconCurrencyForint = createReactComponent("outline", "currency-forint", "IconCurrencyForint", [["path", { "d": "M11 4h-4a3 3 0 0 0 -3 3v12", "key": "svg-0" }], ["path", { "d": "M10 11h-6", "key": "svg-1" }], ["path", { "d": "M16 4v13a2 2 0 0 0 2 2h2", "key": "svg-2" }], ["path", { "d": "M19 9h-5", "key": "svg-3" }]]);

var IconCurrencyForint$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyForint
});

var IconCurrencyFrank = createReactComponent("outline", "currency-frank", "IconCurrencyFrank", [["path", { "d": "M17 5h-6a2 2 0 0 0 -2 2v12", "key": "svg-0" }], ["path", { "d": "M7 15h4", "key": "svg-1" }], ["path", { "d": "M9 11h7", "key": "svg-2" }]]);

var IconCurrencyFrank$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyFrank
});

var IconCurrencyGuarani = createReactComponent("outline", "currency-guarani", "IconCurrencyGuarani", [["path", { "d": "M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a6 6 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4 -1.536c.732 -.66 1.064 -2.148 1 -4.464h-5", "key": "svg-0" }], ["path", { "d": "M12 20v-16", "key": "svg-1" }]]);

var IconCurrencyGuarani$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyGuarani
});

var IconCurrencyHryvnia = createReactComponent("outline", "currency-hryvnia", "IconCurrencyHryvnia", [["path", { "d": "M8 7a2.64 2.64 0 0 1 2.562 -2h3.376a2.64 2.64 0 0 1 2.562 2a2.57 2.57 0 0 1 -1.344 2.922l-5.876 2.938a3.338 3.338 0 0 0 -1.78 3.64a3.11 3.11 0 0 0 3.05 2.5h2.888a2.64 2.64 0 0 0 2.562 -2", "key": "svg-0" }], ["path", { "d": "M6 10h12", "key": "svg-1" }], ["path", { "d": "M6 14h12", "key": "svg-2" }]]);

var IconCurrencyHryvnia$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyHryvnia
});

var IconCurrencyIranianRial = createReactComponent("outline", "currency-iranian-rial", "IconCurrencyIranianRial", [["path", { "d": "M9 4v9a2 2 0 0 1 -2 2h-1a3 3 0 0 1 -3 -3v-1", "key": "svg-0" }], ["path", { "d": "M12 5v8a1 1 0 0 0 1 1h1a2 2 0 0 0 2 -2v-1", "key": "svg-1" }], ["path", { "d": "M21 14v1.096a5 5 0 0 1 -3.787 4.85l-.213 .054", "key": "svg-2" }], ["path", { "d": "M11 18h.01", "key": "svg-3" }], ["path", { "d": "M14 18h.01", "key": "svg-4" }]]);

var IconCurrencyIranianRial$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyIranianRial
});

var IconCurrencyKip = createReactComponent("outline", "currency-kip", "IconCurrencyKip", [["path", { "d": "M6 12h12", "key": "svg-0" }], ["path", { "d": "M9 5v14", "key": "svg-1" }], ["path", { "d": "M16 19a7 7 0 0 0 -7 -7a7 7 0 0 0 7 -7", "key": "svg-2" }]]);

var IconCurrencyKip$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyKip
});

var IconCurrencyKroneCzech = createReactComponent("outline", "currency-krone-czech", "IconCurrencyKroneCzech", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M19 6l-2 2l-2 -2", "key": "svg-3" }], ["path", { "d": "M19 12h-2a3 3 0 0 0 0 6h2", "key": "svg-4" }]]);

var IconCurrencyKroneCzech$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyKroneCzech
});

var IconCurrencyKroneDanish = createReactComponent("outline", "currency-krone-danish", "IconCurrencyKroneDanish", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M15 10v8", "key": "svg-3" }], ["path", { "d": "M19 10a4 4 0 0 0 -4 4", "key": "svg-4" }], ["path", { "d": "M20 18.01v-.01", "key": "svg-5" }]]);

var IconCurrencyKroneDanish$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyKroneDanish
});

var IconCurrencyKroneSwedish = createReactComponent("outline", "currency-krone-swedish", "IconCurrencyKroneSwedish", [["path", { "d": "M5 6v12", "key": "svg-0" }], ["path", { "d": "M5 12c3.5 0 6 -3 6 -6", "key": "svg-1" }], ["path", { "d": "M5 12c3.5 0 6 3 6 6", "key": "svg-2" }], ["path", { "d": "M15 10v8", "key": "svg-3" }], ["path", { "d": "M19 10a4 4 0 0 0 -4 4", "key": "svg-4" }]]);

var IconCurrencyKroneSwedish$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyKroneSwedish
});

var IconCurrencyLari = createReactComponent("outline", "currency-lari", "IconCurrencyLari", [["path", { "d": "M18 13a6 6 0 1 0 -6 6", "key": "svg-0" }], ["path", { "d": "M6 19h12", "key": "svg-1" }], ["path", { "d": "M10 5v7", "key": "svg-2" }], ["path", { "d": "M14 12v-7", "key": "svg-3" }]]);

var IconCurrencyLari$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyLari
});

var IconCurrencyLeu = createReactComponent("outline", "currency-leu", "IconCurrencyLeu", [["path", { "d": "M17 18h-7a3 3 0 0 1 -3 -3v-10", "key": "svg-0" }]]);

var IconCurrencyLeu$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyLeu
});

var IconCurrencyLira = createReactComponent("outline", "currency-lira", "IconCurrencyLira", [["path", { "d": "M10 5v15a7 7 0 0 0 7 -7", "key": "svg-0" }], ["path", { "d": "M6 15l8 -4", "key": "svg-1" }], ["path", { "d": "M14 7l-8 4", "key": "svg-2" }]]);

var IconCurrencyLira$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyLira
});

var IconCurrencyLitecoin = createReactComponent("outline", "currency-litecoin", "IconCurrencyLitecoin", [["path", { "d": "M18 19h-8.194a2 2 0 0 1 -1.98 -2.283l1.674 -11.717", "key": "svg-0" }], ["path", { "d": "M14 9l-9 4", "key": "svg-1" }]]);

var IconCurrencyLitecoin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyLitecoin
});

var IconCurrencyLyd = createReactComponent("outline", "currency-lyd", "IconCurrencyLyd", [["path", { "d": "M11 15h.01", "key": "svg-0" }], ["path", { "d": "M21 5v10a2 2 0 0 1 -2 2h-2.764a2 2 0 0 1 -1.789 -1.106l-.447 -.894", "key": "svg-1" }], ["path", { "d": "M5 8l2.773 4.687c.427 .697 .234 1.626 -.43 2.075a1.38 1.38 0 0 1 -.773 .238h-2.224a.93 .93 0 0 1 -.673 -.293l-.673 -.707", "key": "svg-2" }]]);

var IconCurrencyLyd$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyLyd
});

var IconCurrencyManat = createReactComponent("outline", "currency-manat", "IconCurrencyManat", [["path", { "d": "M7 19v-7a5 5 0 1 1 10 0v7", "key": "svg-0" }], ["path", { "d": "M12 5v14", "key": "svg-1" }]]);

var IconCurrencyManat$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyManat
});

var IconCurrencyMonero = createReactComponent("outline", "currency-monero", "IconCurrencyMonero", [["path", { "d": "M3 18h3v-11l6 7l6 -7v11h3", "key": "svg-0" }]]);

var IconCurrencyMonero$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyMonero
});

var IconCurrencyNaira = createReactComponent("outline", "currency-naira", "IconCurrencyNaira", [["path", { "d": "M7 18v-10.948a1.05 1.05 0 0 1 1.968 -.51l6.064 10.916a1.05 1.05 0 0 0 1.968 -.51v-10.948", "key": "svg-0" }], ["path", { "d": "M5 10h14", "key": "svg-1" }], ["path", { "d": "M5 14h14", "key": "svg-2" }]]);

var IconCurrencyNaira$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyNaira
});

var IconCurrencyNano = createReactComponent("outline", "currency-nano", "IconCurrencyNano", [["path", { "d": "M7 20l10 -16", "key": "svg-0" }], ["path", { "d": "M7 12h10", "key": "svg-1" }], ["path", { "d": "M7 16h10", "key": "svg-2" }], ["path", { "d": "M17 20l-10 -16", "key": "svg-3" }]]);

var IconCurrencyNano$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyNano
});

var IconCurrencyOff = createReactComponent("outline", "currency-off", "IconCurrencyOff", [["path", { "d": "M18.531 14.524a7 7 0 0 0 -9.06 -9.053m-2.422 1.582a7 7 0 0 0 9.903 9.896", "key": "svg-0" }], ["path", { "d": "M4 4l3 3", "key": "svg-1" }], ["path", { "d": "M20 4l-3 3", "key": "svg-2" }], ["path", { "d": "M4 20l3 -3", "key": "svg-3" }], ["path", { "d": "M20 20l-3 -3", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconCurrencyOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyOff
});

var IconCurrencyPaanga = createReactComponent("outline", "currency-paanga", "IconCurrencyPaanga", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M17 20v-2", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M3 6h8", "key": "svg-3" }], ["path", { "d": "M7 6v12", "key": "svg-4" }]]);

var IconCurrencyPaanga$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyPaanga
});

var IconCurrencyPeso = createReactComponent("outline", "currency-peso", "IconCurrencyPeso", [["path", { "d": "M8 19v-14h3.5a4.5 4.5 0 1 1 0 9h-3.5", "key": "svg-0" }], ["path", { "d": "M18 8h-12", "key": "svg-1" }], ["path", { "d": "M18 11h-12", "key": "svg-2" }]]);

var IconCurrencyPeso$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyPeso
});

var IconCurrencyPoundOff = createReactComponent("outline", "currency-pound-off", "IconCurrencyPoundOff", [["path", { "d": "M17 18.5a6 6 0 0 1 -5 0a6 6 0 0 0 -5 .5a3 3 0 0 0 2 -2.5v-7.5m1.192 -2.825a4 4 0 0 1 6.258 .825m-3.45 6h-6", "key": "svg-0" }], ["path", { "d": "M3 3l18 18", "key": "svg-1" }]]);

var IconCurrencyPoundOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyPoundOff
});

var IconCurrencyPound = createReactComponent("outline", "currency-pound", "IconCurrencyPound", [["path", { "d": "M17 18.5a6 6 0 0 1 -5 0a6 6 0 0 0 -5 .5a3 3 0 0 0 2 -2.5v-7.5a4 4 0 0 1 7.45 -2m-2.55 6h-7", "key": "svg-0" }]]);

var IconCurrencyPound$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyPound
});

var IconCurrencyQuetzal = createReactComponent("outline", "currency-quetzal", "IconCurrencyQuetzal", [["path", { "d": "M12 12m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0", "key": "svg-0" }], ["path", { "d": "M13 13l5 5", "key": "svg-1" }]]);

var IconCurrencyQuetzal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyQuetzal
});

var IconCurrencyReal = createReactComponent("outline", "currency-real", "IconCurrencyReal", [["path", { "d": "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4", "key": "svg-0" }], ["path", { "d": "M4 18v-12h3a3 3 0 1 1 0 6h-3c5.5 0 5 4 6 6", "key": "svg-1" }], ["path", { "d": "M18 6v-2", "key": "svg-2" }], ["path", { "d": "M17 20v-2", "key": "svg-3" }]]);

var IconCurrencyReal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyReal
});

var IconCurrencyRenminbi = createReactComponent("outline", "currency-renminbi", "IconCurrencyRenminbi", [["path", { "d": "M15 9v8a2 2 0 1 0 4 0", "key": "svg-0" }], ["path", { "d": "M19 9h-14", "key": "svg-1" }], ["path", { "d": "M19 5h-14", "key": "svg-2" }], ["path", { "d": "M9 9v4c0 2.5 -.667 4 -2 6", "key": "svg-3" }]]);

var IconCurrencyRenminbi$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRenminbi
});

var IconCurrencyRipple = createReactComponent("outline", "currency-ripple", "IconCurrencyRipple", [["path", { "d": "M7 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M10 12h3l2 -2.5", "key": "svg-3" }], ["path", { "d": "M15 14.5l-2 -2.5", "key": "svg-4" }]]);

var IconCurrencyRipple$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRipple
});

var IconCurrencyRiyal = createReactComponent("outline", "currency-riyal", "IconCurrencyRiyal", [["path", { "d": "M15 9v2a2 2 0 1 1 -4 0v-1v1a2 2 0 1 1 -4 0v-1v4a2 2 0 1 1 -4 0v-2", "key": "svg-0" }], ["path", { "d": "M18 12.01v-.01", "key": "svg-1" }], ["path", { "d": "M22 10v1a5 5 0 0 1 -5 5", "key": "svg-2" }]]);

var IconCurrencyRiyal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRiyal
});

var IconCurrencyRubel = createReactComponent("outline", "currency-rubel", "IconCurrencyRubel", [["path", { "d": "M8 19v-14h6a3 3 0 0 1 0 6h-8", "key": "svg-0" }], ["path", { "d": "M14 15h-8", "key": "svg-1" }]]);

var IconCurrencyRubel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRubel
});

var IconCurrencyRufiyaa = createReactComponent("outline", "currency-rufiyaa", "IconCurrencyRufiyaa", [["path", { "d": "M20 16h.01", "key": "svg-0" }], ["path", { "d": "M4 16c9.5 -4 11.5 -8 14 -9", "key": "svg-1" }], ["path", { "d": "M12 8l5 3", "key": "svg-2" }]]);

var IconCurrencyRufiyaa$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRufiyaa
});

var IconCurrencyRupeeNepalese = createReactComponent("outline", "currency-rupee-nepalese", "IconCurrencyRupeeNepalese", [["path", { "d": "M15 5h-11h3a4 4 0 1 1 0 8h-3l6 6", "key": "svg-0" }], ["path", { "d": "M21 17l-4.586 -4.414a2 2 0 0 0 -2.828 2.828l.707 .707", "key": "svg-1" }]]);

var IconCurrencyRupeeNepalese$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRupeeNepalese
});

var IconCurrencyRupee = createReactComponent("outline", "currency-rupee", "IconCurrencyRupee", [["path", { "d": "M18 5h-11h3a4 4 0 0 1 0 8h-3l6 6", "key": "svg-0" }], ["path", { "d": "M7 9l11 0", "key": "svg-1" }]]);

var IconCurrencyRupee$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyRupee
});

var IconCurrencyShekel = createReactComponent("outline", "currency-shekel", "IconCurrencyShekel", [["path", { "d": "M6 18v-12h4a4 4 0 0 1 4 4v4", "key": "svg-0" }], ["path", { "d": "M18 6v12h-4a4 4 0 0 1 -4 -4v-4", "key": "svg-1" }]]);

var IconCurrencyShekel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyShekel
});

var IconCurrencySolana = createReactComponent("outline", "currency-solana", "IconCurrencySolana", [["path", { "d": "M4 18h12l4 -4h-12z", "key": "svg-0" }], ["path", { "d": "M8 14l-4 -4h12l4 4", "key": "svg-1" }], ["path", { "d": "M16 10l4 -4h-12l-4 4", "key": "svg-2" }]]);

var IconCurrencySolana$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencySolana
});

var IconCurrencySom = createReactComponent("outline", "currency-som", "IconCurrencySom", [["path", { "d": "M10 18v-12h-5v10a2 2 0 0 1 -2 2", "key": "svg-0" }], ["path", { "d": "M14 6v12h4a3 3 0 0 0 0 -6h-4h4a3 3 0 0 0 0 -6h-4z", "key": "svg-1" }]]);

var IconCurrencySom$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencySom
});

var IconCurrencyTaka = createReactComponent("outline", "currency-taka", "IconCurrencyTaka", [["path", { "d": "M16.5 15.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-0" }], ["path", { "d": "M7 7a2 2 0 1 1 4 0v9a3 3 0 0 0 6 0v-.5", "key": "svg-1" }], ["path", { "d": "M8 11h6", "key": "svg-2" }]]);

var IconCurrencyTaka$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyTaka
});

var IconCurrencyTenge = createReactComponent("outline", "currency-tenge", "IconCurrencyTenge", [["path", { "d": "M6 5h12", "key": "svg-0" }], ["path", { "d": "M6 9h12", "key": "svg-1" }], ["path", { "d": "M12 9v10", "key": "svg-2" }]]);

var IconCurrencyTenge$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyTenge
});

var IconCurrencyTugrik = createReactComponent("outline", "currency-tugrik", "IconCurrencyTugrik", [["path", { "d": "M7 6h10", "key": "svg-0" }], ["path", { "d": "M12 6v13", "key": "svg-1" }], ["path", { "d": "M8 17l8 -3", "key": "svg-2" }], ["path", { "d": "M16 10l-8 3", "key": "svg-3" }]]);

var IconCurrencyTugrik$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyTugrik
});

var IconCurrencyWon = createReactComponent("outline", "currency-won", "IconCurrencyWon", [["path", { "d": "M4 6l3.245 11.358a.85 .85 0 0 0 1.624 .035l3.131 -9.393l3.131 9.393a.85 .85 0 0 0 1.624 -.035l3.245 -11.358", "key": "svg-0" }], ["path", { "d": "M21 10h-18", "key": "svg-1" }], ["path", { "d": "M21 14h-18", "key": "svg-2" }]]);

var IconCurrencyWon$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyWon
});

var IconCurrencyXrp = createReactComponent("outline", "currency-xrp", "IconCurrencyXrp", [["path", { "d": "M5 5l3.585 3.585a4.83 4.83 0 0 0 6.83 0l3.585 -3.585", "key": "svg-0" }], ["path", { "d": "M5 19l3.585 -3.585a4.83 4.83 0 0 1 6.83 0l3.585 3.584", "key": "svg-1" }]]);

var IconCurrencyXrp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyXrp
});

var IconCurrencyYenOff = createReactComponent("outline", "currency-yen-off", "IconCurrencyYenOff", [["path", { "d": "M12 19v-7m5 -7l-3.328 4.66", "key": "svg-0" }], ["path", { "d": "M8 17h8", "key": "svg-1" }], ["path", { "d": "M8 13h5", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconCurrencyYenOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyYenOff
});

var IconCurrencyYen = createReactComponent("outline", "currency-yen", "IconCurrencyYen", [["path", { "d": "M12 19v-7l-5 -7m10 0l-5 7", "key": "svg-0" }], ["path", { "d": "M8 17l8 0", "key": "svg-1" }], ["path", { "d": "M8 13l8 0", "key": "svg-2" }]]);

var IconCurrencyYen$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyYen
});

var IconCurrencyYuan = createReactComponent("outline", "currency-yuan", "IconCurrencyYuan", [["path", { "d": "M12 19v-7l-5 -7", "key": "svg-0" }], ["path", { "d": "M17 5l-5 7", "key": "svg-1" }], ["path", { "d": "M8 13h8", "key": "svg-2" }]]);

var IconCurrencyYuan$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyYuan
});

var IconCurrencyZloty = createReactComponent("outline", "currency-zloty", "IconCurrencyZloty", [["path", { "d": "M12 18h-7l7 -7h-7", "key": "svg-0" }], ["path", { "d": "M17 18v-13", "key": "svg-1" }], ["path", { "d": "M14 14.5l6 -3.5", "key": "svg-2" }]]);

var IconCurrencyZloty$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrencyZloty
});

var IconCurrency = createReactComponent("outline", "currency", "IconCurrency", [["path", { "d": "M12 12m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M4 4l3 3", "key": "svg-1" }], ["path", { "d": "M20 4l-3 3", "key": "svg-2" }], ["path", { "d": "M4 20l3 -3", "key": "svg-3" }], ["path", { "d": "M20 20l-3 -3", "key": "svg-4" }]]);

var IconCurrency$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrency
});

var IconCurrentLocationOff = createReactComponent("outline", "current-location-off", "IconCurrentLocationOff", [["path", { "d": "M14.685 10.661c-.3 -.6 -.795 -1.086 -1.402 -1.374m-3.397 .584a3 3 0 1 0 4.24 4.245", "key": "svg-0" }], ["path", { "d": "M6.357 6.33a8 8 0 1 0 11.301 11.326m1.642 -2.378a8 8 0 0 0 -10.597 -10.569", "key": "svg-1" }], ["path", { "d": "M12 2v2", "key": "svg-2" }], ["path", { "d": "M12 20v2", "key": "svg-3" }], ["path", { "d": "M20 12h2", "key": "svg-4" }], ["path", { "d": "M2 12h2", "key": "svg-5" }], ["path", { "d": "M3 3l18 18", "key": "svg-6" }]]);

var IconCurrentLocationOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrentLocationOff
});

var IconCurrentLocation = createReactComponent("outline", "current-location", "IconCurrentLocation", [["path", { "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M12 12m-8 0a8 8 0 1 0 16 0a8 8 0 1 0 -16 0", "key": "svg-1" }], ["path", { "d": "M12 2l0 2", "key": "svg-2" }], ["path", { "d": "M12 20l0 2", "key": "svg-3" }], ["path", { "d": "M20 12l2 0", "key": "svg-4" }], ["path", { "d": "M2 12l2 0", "key": "svg-5" }]]);

var IconCurrentLocation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCurrentLocation
});

var IconCursorOff = createReactComponent("outline", "cursor-off", "IconCursorOff", [["path", { "d": "M9 4a3 3 0 0 1 3 3v1m0 9a3 3 0 0 1 -3 3", "key": "svg-0" }], ["path", { "d": "M15 4a3 3 0 0 0 -3 3v1m0 4v5a3 3 0 0 0 3 3", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCursorOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCursorOff
});

var IconCursorText = createReactComponent("outline", "cursor-text", "IconCursorText", [["path", { "d": "M10 12h4", "key": "svg-0" }], ["path", { "d": "M9 4a3 3 0 0 1 3 3v10a3 3 0 0 1 -3 3", "key": "svg-1" }], ["path", { "d": "M15 4a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3", "key": "svg-2" }]]);

var IconCursorText$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCursorText
});

var IconCut = createReactComponent("outline", "cut", "IconCut", [["path", { "d": "M7 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-0" }], ["path", { "d": "M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M9.15 14.85l8.85 -10.85", "key": "svg-2" }], ["path", { "d": "M6 4l8.85 10.85", "key": "svg-3" }]]);

var IconCut$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCut
});

var IconCylinderOff = createReactComponent("outline", "cylinder-off", "IconCylinderOff", [["path", { "d": "M5.23 5.233c-.15 .245 -.23 .502 -.23 .767c0 1.131 1.461 2.117 3.62 2.628m4.357 .343c3.404 -.204 6.023 -1.456 6.023 -2.971c0 -1.657 -3.134 -3 -7 -3c-1.645 0 -3.158 .243 -4.353 .65", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3c3.245 0 5.974 -.946 6.767 -2.23m.233 -3.77v-9", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconCylinderOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCylinderOff
});

var IconCylinderPlus = createReactComponent("outline", "cylinder-plus", "IconCylinderPlus", [["path", { "d": "M12 6m-7 0a7 3 0 1 0 14 0a7 3 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3c.173 0 .345 -.003 .515 -.008m6.485 -8.992v-6", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconCylinderPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCylinderPlus
});

var IconCylinder = createReactComponent("outline", "cylinder", "IconCylinder", [["path", { "d": "M12 6m-7 0a7 3 0 1 0 14 0a7 3 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M5 6v12c0 1.657 3.134 3 7 3s7 -1.343 7 -3v-12", "key": "svg-1" }]]);

var IconCylinder$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconCylinder
});

var IconDashboardOff = createReactComponent("outline", "dashboard-off", "IconDashboardOff", [["path", { "d": "M11.175 11.178a2 2 0 1 0 2.653 2.634", "key": "svg-0" }], ["path", { "d": "M14.5 10.5l1 -1", "key": "svg-1" }], ["path", { "d": "M8.621 4.612a9 9 0 0 1 11.721 11.72m-1.516 2.488a9.008 9.008 0 0 1 -1.226 1.18h-11.2a9 9 0 0 1 -.268 -13.87", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDashboardOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDashboardOff
});

var IconDashboard = createReactComponent("outline", "dashboard", "IconDashboard", [["path", { "d": "M12 13m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-0" }], ["path", { "d": "M13.45 11.55l2.05 -2.05", "key": "svg-1" }], ["path", { "d": "M6.4 20a9 9 0 1 1 11.2 0z", "key": "svg-2" }]]);

var IconDashboard$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDashboard
});

var IconDatabaseCog = createReactComponent("outline", "database-cog", "IconDatabaseCog", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.21 0 .42 -.003 .626 -.01", "key": "svg-1" }], ["path", { "d": "M20 11.5v-5.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconDatabaseCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseCog
});

var IconDatabaseDollar = createReactComponent("outline", "database-dollar", "IconDatabaseDollar", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.415 0 .822 -.012 1.22 -.035", "key": "svg-1" }], ["path", { "d": "M20 10v-4", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.352 0 .698 -.009 1.037 -.025", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconDatabaseDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseDollar
});

var IconDatabaseEdit = createReactComponent("outline", "database-edit", "IconDatabaseEdit", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.478 0 .947 -.016 1.402 -.046", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.526 3.04 2.786 6.972 2.975", "key": "svg-3" }], ["path", { "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z", "key": "svg-4" }]]);

var IconDatabaseEdit$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseEdit
});

var IconDatabaseExclamation = createReactComponent("outline", "database-exclamation", "IconDatabaseExclamation", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.118 0 2.182 -.086 3.148 -.241m4.852 -2.759v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c1.064 0 2.079 -.078 3.007 -.22", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDatabaseExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseExclamation
});

var IconDatabaseExport = createReactComponent("outline", "database-export", "IconDatabaseExport", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.118 0 2.183 -.086 3.15 -.241", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.157 0 .312 -.002 .466 -.005", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16l3 3l-3 3", "key": "svg-5" }]]);

var IconDatabaseExport$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseExport
});

var IconDatabaseHeart = createReactComponent("outline", "database-heart", "IconDatabaseHeart", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.453 2.755 2.665 6.414 2.941", "key": "svg-1" }], ["path", { "d": "M20 11v-5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.579 3.253 2.873 7.383 2.991", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconDatabaseHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseHeart
});

var IconDatabaseImport = createReactComponent("outline", "database-import", "IconDatabaseImport", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.856 0 1.68 -.05 2.454 -.144m5.546 -2.856v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.171 0 .341 -.002 .51 -.006", "key": "svg-2" }], ["path", { "d": "M19 22v-6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-4" }]]);

var IconDatabaseImport$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseImport
});

var IconDatabaseLeak = createReactComponent("outline", "database-leak", "IconDatabaseLeak", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v12c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-12", "key": "svg-1" }], ["path", { "d": "M4 15a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1", "key": "svg-2" }]]);

var IconDatabaseLeak$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseLeak
});

var IconDatabaseMinus = createReactComponent("outline", "database-minus", "IconDatabaseMinus", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.164 0 .328 -.002 .49 -.006", "key": "svg-2" }], ["path", { "d": "M20 15v-3", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconDatabaseMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseMinus
});

var IconDatabaseOff = createReactComponent("outline", "database-off", "IconDatabaseOff", [["path", { "d": "M12.983 8.978c3.955 -.182 7.017 -1.446 7.017 -2.978c0 -1.657 -3.582 -3 -8 -3c-1.661 0 -3.204 .19 -4.483 .515m-2.783 1.228c-.471 .382 -.734 .808 -.734 1.257c0 1.22 1.944 2.271 4.734 2.74", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.986 0 1.93 -.067 2.802 -.19m3.187 -.82c1.251 -.53 2.011 -1.228 2.011 -1.99v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c3.217 0 5.991 -.712 7.261 -1.74m.739 -3.26v-4", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDatabaseOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseOff
});

var IconDatabasePlus = createReactComponent("outline", "database-plus", "IconDatabasePlus", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c1.075 0 2.1 -.08 3.037 -.224", "key": "svg-1" }], ["path", { "d": "M20 12v-6", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.166 0 .331 -.002 .495 -.006", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconDatabasePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabasePlus
});

var IconDatabaseSearch = createReactComponent("outline", "database-search", "IconDatabaseSearch", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3m8 -3.5v-5.5", "key": "svg-1" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-2" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-4" }]]);

var IconDatabaseSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseSearch
});

var IconDatabaseShare = createReactComponent("outline", "database-share", "IconDatabaseShare", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.361 0 .716 -.009 1.065 -.026", "key": "svg-1" }], ["path", { "d": "M20 13v-7", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconDatabaseShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseShare
});

var IconDatabaseSmile = createReactComponent("outline", "database-smile", "IconDatabaseSmile", [["path", { "d": "M10 14h.01", "key": "svg-0" }], ["path", { "d": "M14 14h.01", "key": "svg-1" }], ["path", { "d": "M10 17a3.5 3.5 0 0 0 4 0", "key": "svg-2" }], ["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-3" }], ["path", { "d": "M4 6v12c0 1.657 3.582 3 8 3s8 -1.343 8 -3v-12", "key": "svg-4" }]]);

var IconDatabaseSmile$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseSmile
});

var IconDatabaseStar = createReactComponent("outline", "database-star", "IconDatabaseStar", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.43 2.67 2.627 6.243 2.927", "key": "svg-1" }], ["path", { "d": "M20 10.5v-4.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.546 3.12 2.82 7.128 2.982", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconDatabaseStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseStar
});

var IconDatabaseX = createReactComponent("outline", "database-x", "IconDatabaseX", [["path", { "d": "M4 6c0 1.657 3.582 3 8 3s8 -1.343 8 -3s-3.582 -3 -8 -3s-8 1.343 -8 3", "key": "svg-0" }], ["path", { "d": "M4 6v6c0 1.657 3.582 3 8 3c.537 0 1.062 -.02 1.57 -.058", "key": "svg-1" }], ["path", { "d": "M20 13.5v-7.5", "key": "svg-2" }], ["path", { "d": "M4 12v6c0 1.657 3.582 3 8 3c.384 0 .762 -.01 1.132 -.03", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconDatabaseX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabaseX
});

var IconDatabase = createReactComponent("outline", "database", "IconDatabase", [["path", { "d": "M12 6m-8 0a8 3 0 1 0 16 0a8 3 0 1 0 -16 0", "key": "svg-0" }], ["path", { "d": "M4 6v6a8 3 0 0 0 16 0v-6", "key": "svg-1" }], ["path", { "d": "M4 12v6a8 3 0 0 0 16 0v-6", "key": "svg-2" }]]);

var IconDatabase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDatabase
});

var IconDecimal = createReactComponent("outline", "decimal", "IconDecimal", [["path", { "d": "M17 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M10 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z", "key": "svg-1" }], ["path", { "d": "M5 16h.01", "key": "svg-2" }]]);

var IconDecimal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDecimal
});

var IconDeer = createReactComponent("outline", "deer", "IconDeer", [["path", { "d": "M3 3c0 2 1 3 4 3c2 0 3 1 3 3", "key": "svg-0" }], ["path", { "d": "M21 3c0 2 -1 3 -4 3c-2 0 -3 .333 -3 3", "key": "svg-1" }], ["path", { "d": "M12 18c-1 0 -4 -3 -4 -6c0 -2 1.333 -3 4 -3s4 1 4 3c0 3 -3 6 -4 6", "key": "svg-2" }], ["path", { "d": "M15.185 14.889l.095 -.18a4 4 0 1 1 -6.56 0", "key": "svg-3" }], ["path", { "d": "M17 3c0 1.333 -.333 2.333 -1 3", "key": "svg-4" }], ["path", { "d": "M7 3c0 1.333 .333 2.333 1 3", "key": "svg-5" }], ["path", { "d": "M7 6c-2.667 .667 -4.333 1.667 -5 3", "key": "svg-6" }], ["path", { "d": "M17 6c2.667 .667 4.333 1.667 5 3", "key": "svg-7" }], ["path", { "d": "M8.5 10l-1.5 -1", "key": "svg-8" }], ["path", { "d": "M15.5 10l1.5 -1", "key": "svg-9" }], ["path", { "d": "M12 15h.01", "key": "svg-10" }]]);

var IconDeer$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeer
});

var IconDelta = createReactComponent("outline", "delta", "IconDelta", [["path", { "d": "M4 20h16l-8 -16z", "key": "svg-0" }]]);

var IconDelta$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDelta
});

var IconDentalBroken = createReactComponent("outline", "dental-broken", "IconDentalBroken", [["path", { "d": "M12 5.5c-1.074 -.586 -2.583 -1.5 -4 -1.5c-2.1 0 -4 1.247 -4 5c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c1.615 -2.127 2.671 -5.637 2.671 -10.537c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5z", "key": "svg-0" }], ["path", { "d": "M12 5.5l1 2.5l-2 2l2 2", "key": "svg-1" }]]);

var IconDentalBroken$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDentalBroken
});

var IconDentalOff = createReactComponent("outline", "dental-off", "IconDentalOff", [["path", { "d": "M19.277 15.281c.463 -1.75 .723 -3.844 .723 -6.281c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5c-1.074 -.586 -2.583 -1.5 -4 -1.5m-2.843 1.153c-.707 .784 -1.157 2.017 -1.157 3.847c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c.305 -.402 .59 -.853 .852 -1.353", "key": "svg-0" }], ["path", { "d": "M12 5.5l3 1.5", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDentalOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDentalOff
});

var IconDental = createReactComponent("outline", "dental", "IconDental", [["path", { "d": "M12 5.5c-1.074 -.586 -2.583 -1.5 -4 -1.5c-2.1 0 -4 1.247 -4 5c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 0 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 2 .993 2.567 .237c1.615 -2.127 2.671 -5.637 2.671 -10.537c0 -3.74 -1.908 -5 -4 -5c-1.423 0 -2.92 .911 -4 1.5z", "key": "svg-0" }], ["path", { "d": "M12 5.5l3 1.5", "key": "svg-1" }]]);

var IconDental$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDental
});

var IconDeselect = createReactComponent("outline", "deselect", "IconDeselect", [["path", { "d": "M12 8h3a1 1 0 0 1 1 1v3", "key": "svg-0" }], ["path", { "d": "M16 16h-7a1 1 0 0 1 -1 -1v-7", "key": "svg-1" }], ["path", { "d": "M12 20v.01", "key": "svg-2" }], ["path", { "d": "M16 20v.01", "key": "svg-3" }], ["path", { "d": "M8 20v.01", "key": "svg-4" }], ["path", { "d": "M4 20v.01", "key": "svg-5" }], ["path", { "d": "M4 16v.01", "key": "svg-6" }], ["path", { "d": "M4 12v.01", "key": "svg-7" }], ["path", { "d": "M4 8v.01", "key": "svg-8" }], ["path", { "d": "M8 4v.01", "key": "svg-9" }], ["path", { "d": "M12 4v.01", "key": "svg-10" }], ["path", { "d": "M16 4v.01", "key": "svg-11" }], ["path", { "d": "M20 4v.01", "key": "svg-12" }], ["path", { "d": "M20 8v.01", "key": "svg-13" }], ["path", { "d": "M20 12v.01", "key": "svg-14" }], ["path", { "d": "M20 16v.01", "key": "svg-15" }], ["path", { "d": "M3 3l18 18", "key": "svg-16" }]]);

var IconDeselect$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeselect
});

var IconDesk = createReactComponent("outline", "desk", "IconDesk", [["path", { "d": "M3 6h18", "key": "svg-0" }], ["path", { "d": "M4 6v13", "key": "svg-1" }], ["path", { "d": "M20 19v-13", "key": "svg-2" }], ["path", { "d": "M4 10h16", "key": "svg-3" }], ["path", { "d": "M15 6v8a2 2 0 0 0 2 2h3", "key": "svg-4" }]]);

var IconDesk$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDesk
});

var IconDetailsOff = createReactComponent("outline", "details-off", "IconDetailsOff", [["path", { "d": "M5 19h14", "key": "svg-0" }], ["path", { "d": "M20.986 16.984a2 2 0 0 0 -.146 -.734l-7.1 -12.25a2 2 0 0 0 -3.5 0l-.821 1.417m-1.469 2.534l-4.81 8.299a2 2 0 0 0 1.75 2.75", "key": "svg-1" }], ["path", { "d": "M12 3v5m0 4v7", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDetailsOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDetailsOff
});

var IconDetails = createReactComponent("outline", "details", "IconDetails", [["path", { "d": "M11.999 3l.001 17", "key": "svg-0" }], ["path", { "d": "M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z", "key": "svg-1" }]]);

var IconDetails$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDetails
});

var IconDeviceAirpodsCase = createReactComponent("outline", "device-airpods-case", "IconDeviceAirpodsCase", [["path", { "d": "M21 10h-18", "key": "svg-0" }], ["path", { "d": "M3 4m0 4a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z", "key": "svg-1" }], ["path", { "d": "M7 10v1.5a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 1.5 -1.5v-1.5", "key": "svg-2" }]]);

var IconDeviceAirpodsCase$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceAirpodsCase
});

var IconDeviceAirpods = createReactComponent("outline", "device-airpods", "IconDeviceAirpods", [["path", { "d": "M6 4a4 4 0 0 1 4 3.8l0 .2v10.5a1.5 1.5 0 0 1 -3 0v-6.5h-1a4 4 0 0 1 -4 -3.8l0 -.2a4 4 0 0 1 4 -4z", "key": "svg-0" }], ["path", { "d": "M18 4a4 4 0 0 0 -4 3.8l0 .2v10.5a1.5 1.5 0 0 0 3 0v-6.5h1a4 4 0 0 0 4 -3.8l0 -.2a4 4 0 0 0 -4 -4z", "key": "svg-1" }]]);

var IconDeviceAirpods$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceAirpods
});

var IconDeviceAirtag = createReactComponent("outline", "device-airtag", "IconDeviceAirtag", [["path", { "d": "M4 12a8 8 0 1 0 16 0a8 8 0 0 0 -16 0", "key": "svg-0" }], ["path", { "d": "M9 15v.01", "key": "svg-1" }], ["path", { "d": "M15 15a6 6 0 0 0 -6 -6", "key": "svg-2" }], ["path", { "d": "M12 15a3 3 0 0 0 -3 -3", "key": "svg-3" }]]);

var IconDeviceAirtag$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceAirtag
});

var IconDeviceAnalytics = createReactComponent("outline", "device-analytics", "IconDeviceAnalytics", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 20l10 0", "key": "svg-1" }], ["path", { "d": "M9 16l0 4", "key": "svg-2" }], ["path", { "d": "M15 16l0 4", "key": "svg-3" }], ["path", { "d": "M8 12l3 -3l2 2l3 -3", "key": "svg-4" }]]);

var IconDeviceAnalytics$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceAnalytics
});

var IconDeviceAudioTape = createReactComponent("outline", "device-audio-tape", "IconDeviceAudioTape", [["path", { "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M3 17l4 -3h10l4 3", "key": "svg-1" }], ["circle", { "cx": "7.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-2" }], ["circle", { "cx": "16.5", "cy": "9.5", "r": ".5", "fill": "currentColor", "key": "svg-3" }]]);

var IconDeviceAudioTape$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceAudioTape
});

var IconDeviceCameraPhone = createReactComponent("outline", "device-camera-phone", "IconDeviceCameraPhone", [["path", { "d": "M18.5 8.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0", "key": "svg-0" }], ["path", { "d": "M13 7h-8a2 2 0 0 0 -2 2v7a2 2 0 0 0 2 2h13a2 2 0 0 0 2 -2v-2", "key": "svg-1" }], ["path", { "d": "M17 15v-1", "key": "svg-2" }]]);

var IconDeviceCameraPhone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceCameraPhone
});

var IconDeviceCctvOff = createReactComponent("outline", "device-cctv-off", "IconDeviceCctvOff", [["path", { "d": "M7 7h-3a1 1 0 0 1 -1 -1v-2c0 -.275 .11 -.523 .29 -.704m3.71 -.296h13a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-9", "key": "svg-0" }], ["path", { "d": "M10.36 10.35a4 4 0 1 0 5.285 5.3", "key": "svg-1" }], ["path", { "d": "M19 7v7c0 .321 -.022 .637 -.064 .947m-1.095 2.913a7 7 0 0 1 -12.841 -3.86l0 -7", "key": "svg-2" }], ["path", { "d": "M12 14h.01", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDeviceCctvOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceCctvOff
});

var IconDeviceCctv = createReactComponent("outline", "device-cctv", "IconDeviceCctv", [["path", { "d": "M3 3m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M12 14m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0", "key": "svg-1" }], ["path", { "d": "M19 7v7a7 7 0 0 1 -14 0v-7", "key": "svg-2" }], ["path", { "d": "M12 14l.01 0", "key": "svg-3" }]]);

var IconDeviceCctv$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceCctv
});

var IconDeviceComputerCameraOff = createReactComponent("outline", "device-computer-camera-off", "IconDeviceComputerCameraOff", [["path", { "d": "M6.15 6.153a7 7 0 0 0 9.696 9.696m2 -2a7 7 0 0 0 -9.699 -9.695", "key": "svg-0" }], ["path", { "d": "M9.13 9.122a3 3 0 0 0 3.743 3.749m2 -2a3 3 0 0 0 -3.737 -3.736", "key": "svg-1" }], ["path", { "d": "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486", "key": "svg-2" }], ["path", { "d": "M3 3l18 18", "key": "svg-3" }]]);

var IconDeviceComputerCameraOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceComputerCameraOff
});

var IconDeviceComputerCamera = createReactComponent("outline", "device-computer-camera", "IconDeviceComputerCamera", [["path", { "d": "M12 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0", "key": "svg-0" }], ["path", { "d": "M12 10m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486", "key": "svg-2" }]]);

var IconDeviceComputerCamera$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceComputerCamera
});

var IconDeviceDesktopAnalytics = createReactComponent("outline", "device-desktop-analytics", "IconDeviceDesktopAnalytics", [["path", { "d": "M3 4m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M9 12v-4", "key": "svg-4" }], ["path", { "d": "M12 12v-1", "key": "svg-5" }], ["path", { "d": "M15 12v-2", "key": "svg-6" }], ["path", { "d": "M12 12v-1", "key": "svg-7" }]]);

var IconDeviceDesktopAnalytics$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopAnalytics
});

var IconDeviceDesktopBolt = createReactComponent("outline", "device-desktop-bolt", "IconDeviceDesktopBolt", [["path", { "d": "M14.5 16h-10.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h6", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-3" }]]);

var IconDeviceDesktopBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopBolt
});

var IconDeviceDesktopCancel = createReactComponent("outline", "device-desktop-cancel", "IconDeviceDesktopCancel", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M17 21l4 -4", "key": "svg-4" }]]);

var IconDeviceDesktopCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopCancel
});

var IconDeviceDesktopCheck = createReactComponent("outline", "device-desktop-check", "IconDeviceDesktopCheck", [["path", { "d": "M12 16h-8a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M7 20h4", "key": "svg-2" }], ["path", { "d": "M9 16v4", "key": "svg-3" }]]);

var IconDeviceDesktopCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopCheck
});

var IconDeviceDesktopCode = createReactComponent("outline", "device-desktop-code", "IconDeviceDesktopCode", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h4", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-3" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-4" }]]);

var IconDeviceDesktopCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopCode
});

var IconDeviceDesktopCog = createReactComponent("outline", "device-desktop-cog", "IconDeviceDesktopCog", [["path", { "d": "M12 16h-8a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDeviceDesktopCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopCog
});

var IconDeviceDesktopDollar = createReactComponent("outline", "device-desktop-dollar", "IconDeviceDesktopDollar", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v5.5", "key": "svg-0" }], ["path", { "d": "M7 20h6.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-4" }]]);

var IconDeviceDesktopDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopDollar
});

var IconDeviceDesktopDown = createReactComponent("outline", "device-desktop-down", "IconDeviceDesktopDown", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-4" }]]);

var IconDeviceDesktopDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopDown
});

var IconDeviceDesktopExclamation = createReactComponent("outline", "device-desktop-exclamation", "IconDeviceDesktopExclamation", [["path", { "d": "M15 16h-11a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M7 20h8", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M19 16v3", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }]]);

var IconDeviceDesktopExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopExclamation
});

var IconDeviceDesktopHeart = createReactComponent("outline", "device-desktop-heart", "IconDeviceDesktopHeart", [["path", { "d": "M10 16h-6a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M7 20h3.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-3" }]]);

var IconDeviceDesktopHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopHeart
});

var IconDeviceDesktopMinus = createReactComponent("outline", "device-desktop-minus", "IconDeviceDesktopMinus", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconDeviceDesktopMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopMinus
});

var IconDeviceDesktopOff = createReactComponent("outline", "device-desktop-off", "IconDeviceDesktopOff", [["path", { "d": "M8 4h12a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1m-4 0h-12a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }], ["path", { "d": "M3 3l18 18", "key": "svg-4" }]]);

var IconDeviceDesktopOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopOff
});

var IconDeviceDesktopPause = createReactComponent("outline", "device-desktop-pause", "IconDeviceDesktopPause", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }], ["path", { "d": "M7 20h6", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopPause
});

var IconDeviceDesktopPin = createReactComponent("outline", "device-desktop-pin", "IconDeviceDesktopPin", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }], ["path", { "d": "M7 20h5", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopPin
});

var IconDeviceDesktopPlus = createReactComponent("outline", "device-desktop-plus", "IconDeviceDesktopPlus", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M7 20h5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }]]);

var IconDeviceDesktopPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopPlus
});

var IconDeviceDesktopQuestion = createReactComponent("outline", "device-desktop-question", "IconDeviceDesktopQuestion", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h8", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-4" }]]);

var IconDeviceDesktopQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopQuestion
});

var IconDeviceDesktopSearch = createReactComponent("outline", "device-desktop-search", "IconDeviceDesktopSearch", [["path", { "d": "M11.5 16h-7.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h4", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-3" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-4" }]]);

var IconDeviceDesktopSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopSearch
});

var IconDeviceDesktopShare = createReactComponent("outline", "device-desktop-share", "IconDeviceDesktopShare", [["path", { "d": "M12.5 16h-8.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h5.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M16 22l5 -5", "key": "svg-3" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-4" }]]);

var IconDeviceDesktopShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopShare
});

var IconDeviceDesktopStar = createReactComponent("outline", "device-desktop-star", "IconDeviceDesktopStar", [["path", { "d": "M10 16h-6a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M7 20h3.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-3" }]]);

var IconDeviceDesktopStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopStar
});

var IconDeviceDesktopUp = createReactComponent("outline", "device-desktop-up", "IconDeviceDesktopUp", [["path", { "d": "M13.5 16h-9.5a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M7 20h5", "key": "svg-3" }], ["path", { "d": "M9 16v4", "key": "svg-4" }]]);

var IconDeviceDesktopUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopUp
});

var IconDeviceDesktopX = createReactComponent("outline", "device-desktop-x", "IconDeviceDesktopX", [["path", { "d": "M13 16h-9a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M7 20h6.5", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-3" }], ["path", { "d": "M17 22l5 -5", "key": "svg-4" }]]);

var IconDeviceDesktopX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktopX
});

var IconDeviceDesktop = createReactComponent("outline", "device-desktop", "IconDeviceDesktop", [["path", { "d": "M3 5a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1v-10z", "key": "svg-0" }], ["path", { "d": "M7 20h10", "key": "svg-1" }], ["path", { "d": "M9 16v4", "key": "svg-2" }], ["path", { "d": "M15 16v4", "key": "svg-3" }]]);

var IconDeviceDesktop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceDesktop
});

var IconDeviceFloppy = createReactComponent("outline", "device-floppy", "IconDeviceFloppy", [["path", { "d": "M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-1" }], ["path", { "d": "M14 4l0 4l-6 0l0 -4", "key": "svg-2" }]]);

var IconDeviceFloppy$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceFloppy
});

var IconDeviceGamepad2 = createReactComponent("outline", "device-gamepad-2", "IconDeviceGamepad2", [["path", { "d": "M12 5h3.5a5 5 0 0 1 0 10h-5.5l-4.015 4.227a2.3 2.3 0 0 1 -3.923 -2.035l1.634 -8.173a5 5 0 0 1 4.904 -4.019h3.4z", "key": "svg-0" }], ["path", { "d": "M14 15l4.07 4.284a2.3 2.3 0 0 0 3.925 -2.023l-1.6 -8.232", "key": "svg-1" }], ["path", { "d": "M8 9v2", "key": "svg-2" }], ["path", { "d": "M7 10h2", "key": "svg-3" }], ["path", { "d": "M14 10h2", "key": "svg-4" }]]);

var IconDeviceGamepad2$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceGamepad2
});

var IconDeviceGamepad3 = createReactComponent("outline", "device-gamepad-3", "IconDeviceGamepad3", [["path", { "d": "M9 12l-3 -3h-2a1 1 0 0 0 -1 1v4a1 1 0 0 0 1 1h2z", "key": "svg-0" }], ["path", { "d": "M15 12l3 -3h2a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-2z", "key": "svg-1" }], ["path", { "d": "M12 15l-3 3v2a1 1 0 0 0 1 1h4a1 1 0 0 0 1 -1v-2z", "key": "svg-2" }], ["path", { "d": "M12 9l-3 -3v-2a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v2z", "key": "svg-3" }]]);

var IconDeviceGamepad3$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceGamepad3
});

var IconDeviceGamepad = createReactComponent("outline", "device-gamepad", "IconDeviceGamepad", [["path", { "d": "M2 6m0 2a2 2 0 0 1 2 -2h16a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-16a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M6 12h4m-2 -2v4", "key": "svg-1" }], ["path", { "d": "M15 11l0 .01", "key": "svg-2" }], ["path", { "d": "M18 13l0 .01", "key": "svg-3" }]]);

var IconDeviceGamepad$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceGamepad
});

var IconDeviceHeartMonitor = createReactComponent("outline", "device-heart-monitor", "IconDeviceHeartMonitor", [["path", { "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M4 9h6l1 -2l2 4l1 -2h6", "key": "svg-1" }], ["path", { "d": "M4 14h16", "key": "svg-2" }], ["path", { "d": "M14 17v.01", "key": "svg-3" }], ["path", { "d": "M17 17v.01", "key": "svg-4" }]]);

var IconDeviceHeartMonitor$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceHeartMonitor
});

var IconDeviceImacBolt = createReactComponent("outline", "device-imac-bolt", "IconDeviceImacBolt", [["path", { "d": "M13.5 17h-9.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h5.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-4" }]]);

var IconDeviceImacBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacBolt
});

var IconDeviceImacCancel = createReactComponent("outline", "device-imac-cancel", "IconDeviceImacCancel", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h12.5", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M17 21l4 -4", "key": "svg-5" }]]);

var IconDeviceImacCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacCancel
});

var IconDeviceImacCheck = createReactComponent("outline", "device-imac-check", "IconDeviceImacCheck", [["path", { "d": "M11.5 17h-7.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-4" }]]);

var IconDeviceImacCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacCheck
});

var IconDeviceImacCode = createReactComponent("outline", "device-imac-code", "IconDeviceImacCode", [["path", { "d": "M11.5 17h-7.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-4" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-5" }]]);

var IconDeviceImacCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacCode
});

var IconDeviceImacCog = createReactComponent("outline", "device-imac-cog", "IconDeviceImacCog", [["path", { "d": "M12 17h-8a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-4" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-5" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-6" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-7" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-8" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-9" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-10" }]]);

var IconDeviceImacCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacCog
});

var IconDeviceImacDollar = createReactComponent("outline", "device-imac-dollar", "IconDeviceImacDollar", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v6.5", "key": "svg-0" }], ["path", { "d": "M3 13h11", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-4" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-5" }]]);

var IconDeviceImacDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacDollar
});

var IconDeviceImacDown = createReactComponent("outline", "device-imac-down", "IconDeviceImacDown", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 16v6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-5" }]]);

var IconDeviceImacDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacDown
});

var IconDeviceImacExclamation = createReactComponent("outline", "device-imac-exclamation", "IconDeviceImacExclamation", [["path", { "d": "M15 17h-11a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h7", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M19 16v3", "key": "svg-5" }], ["path", { "d": "M19 22v.01", "key": "svg-6" }]]);

var IconDeviceImacExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacExclamation
});

var IconDeviceImacHeart = createReactComponent("outline", "device-imac-heart", "IconDeviceImacHeart", [["path", { "d": "M10 17h-6a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7", "key": "svg-0" }], ["path", { "d": "M3 13h9", "key": "svg-1" }], ["path", { "d": "M8 21h3.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-4" }]]);

var IconDeviceImacHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacHeart
});

var IconDeviceImacMinus = createReactComponent("outline", "device-imac-minus", "IconDeviceImacMinus", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v11", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }]]);

var IconDeviceImacMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacMinus
});

var IconDeviceImacOff = createReactComponent("outline", "device-imac-off", "IconDeviceImacOff", [["path", { "d": "M7 3h13a1 1 0 0 1 1 1v12c0 .28 -.115 .532 -.3 .713m-3.7 .287h-13a1 1 0 0 1 -1 -1v-12c0 -.276 .112 -.526 .293 -.707", "key": "svg-0" }], ["path", { "d": "M3 13h10m4 0h4", "key": "svg-1" }], ["path", { "d": "M8 21h8", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M3 3l18 18", "key": "svg-5" }]]);

var IconDeviceImacOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacOff
});

var IconDeviceImacPause = createReactComponent("outline", "device-imac-pause", "IconDeviceImacPause", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M17 17v5", "key": "svg-4" }], ["path", { "d": "M21 17v5", "key": "svg-5" }]]);

var IconDeviceImacPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacPause
});

var IconDeviceImacPin = createReactComponent("outline", "device-imac-pin", "IconDeviceImacPin", [["path", { "d": "M12 17h-8a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-1" }], ["path", { "d": "M19 18v.01", "key": "svg-2" }], ["path", { "d": "M3 13h11", "key": "svg-3" }], ["path", { "d": "M8 21h4.5", "key": "svg-4" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-5" }]]);

var IconDeviceImacPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacPin
});

var IconDeviceImacPlus = createReactComponent("outline", "device-imac-plus", "IconDeviceImacPlus", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13.5", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 19h6", "key": "svg-4" }], ["path", { "d": "M19 16v6", "key": "svg-5" }]]);

var IconDeviceImacPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacPlus
});

var IconDeviceImacQuestion = createReactComponent("outline", "device-imac-question", "IconDeviceImacQuestion", [["path", { "d": "M14 17h-10a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M3 13h11.5", "key": "svg-1" }], ["path", { "d": "M8 21h7", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }], ["path", { "d": "M19 22v.01", "key": "svg-5" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-6" }]]);

var IconDeviceImacQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacQuestion
});

var IconDeviceImacSearch = createReactComponent("outline", "device-imac-search", "IconDeviceImacSearch", [["path", { "d": "M11 17h-7a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8", "key": "svg-0" }], ["path", { "d": "M3 13h10", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-4" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-5" }]]);

var IconDeviceImacSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacSearch
});

var IconDeviceImacShare = createReactComponent("outline", "device-imac-share", "IconDeviceImacShare", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h4", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M16 22l5 -5", "key": "svg-4" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-5" }]]);

var IconDeviceImacShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacShare
});

var IconDeviceImacStar = createReactComponent("outline", "device-imac-star", "IconDeviceImacStar", [["path", { "d": "M10 17h-6a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v7.5", "key": "svg-0" }], ["path", { "d": "M3 13h10", "key": "svg-1" }], ["path", { "d": "M8 21h3", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-4" }]]);

var IconDeviceImacStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacStar
});

var IconDeviceImacUp = createReactComponent("outline", "device-imac-up", "IconDeviceImacUp", [["path", { "d": "M12.5 17h-8.5a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v8.5", "key": "svg-0" }], ["path", { "d": "M3 13h13", "key": "svg-1" }], ["path", { "d": "M8 21h4.5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M19 22v-6", "key": "svg-4" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-5" }]]);

var IconDeviceImacUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacUp
});

var IconDeviceImacX = createReactComponent("outline", "device-imac-x", "IconDeviceImacX", [["path", { "d": "M13 17h-9a1 1 0 0 1 -1 -1v-12a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v9", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h5", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-4" }], ["path", { "d": "M17 22l5 -5", "key": "svg-5" }]]);

var IconDeviceImacX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImacX
});

var IconDeviceImac = createReactComponent("outline", "device-imac", "IconDeviceImac", [["path", { "d": "M3 4a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v12a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1v-12z", "key": "svg-0" }], ["path", { "d": "M3 13h18", "key": "svg-1" }], ["path", { "d": "M8 21h8", "key": "svg-2" }], ["path", { "d": "M10 17l-.5 4", "key": "svg-3" }], ["path", { "d": "M14 17l.5 4", "key": "svg-4" }]]);

var IconDeviceImac$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceImac
});

var IconDeviceIpadBolt = createReactComponent("outline", "device-ipad-bolt", "IconDeviceIpadBolt", [["path", { "d": "M13.5 21h-7.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconDeviceIpadBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadBolt
});

var IconDeviceIpadCancel = createReactComponent("outline", "device-ipad-cancel", "IconDeviceIpadCancel", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconDeviceIpadCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadCancel
});

var IconDeviceIpadCheck = createReactComponent("outline", "device-ipad-check", "IconDeviceIpadCheck", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-2" }]]);

var IconDeviceIpadCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadCheck
});

var IconDeviceIpadCode = createReactComponent("outline", "device-ipad-code", "IconDeviceIpadCode", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconDeviceIpadCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadCode
});

var IconDeviceIpadCog = createReactComponent("outline", "device-ipad-cog", "IconDeviceIpadCog", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconDeviceIpadCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadCog
});

var IconDeviceIpadDollar = createReactComponent("outline", "device-ipad-dollar", "IconDeviceIpadDollar", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconDeviceIpadDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadDollar
});

var IconDeviceIpadDown = createReactComponent("outline", "device-ipad-down", "IconDeviceIpadDown", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconDeviceIpadDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadDown
});

var IconDeviceIpadExclamation = createReactComponent("outline", "device-ipad-exclamation", "IconDeviceIpadExclamation", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h6", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconDeviceIpadExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadExclamation
});

var IconDeviceIpadHeart = createReactComponent("outline", "device-ipad-heart", "IconDeviceIpadHeart", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h1", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceIpadHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHeart
});

var IconDeviceIpadHorizontalBolt = createReactComponent("outline", "device-ipad-horizontal-bolt", "IconDeviceIpadHorizontalBolt", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h4.5", "key": "svg-1" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalBolt
});

var IconDeviceIpadHorizontalCancel = createReactComponent("outline", "device-ipad-horizontal-cancel", "IconDeviceIpadHorizontalCancel", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M17 21l4 -4", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalCancel
});

var IconDeviceIpadHorizontalCheck = createReactComponent("outline", "device-ipad-horizontal-check", "IconDeviceIpadHorizontalCheck", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-1" }], ["path", { "d": "M9 17h2.5", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalCheck
});

var IconDeviceIpadHorizontalCode = createReactComponent("outline", "device-ipad-horizontal-code", "IconDeviceIpadHorizontalCode", [["path", { "d": "M11 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h2.5", "key": "svg-1" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-2" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalCode
});

var IconDeviceIpadHorizontalCog = createReactComponent("outline", "device-ipad-horizontal-cog", "IconDeviceIpadHorizontalCog", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-2" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-3" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-4" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-5" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-6" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-7" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-8" }]]);

var IconDeviceIpadHorizontalCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalCog
});

var IconDeviceIpadHorizontalDollar = createReactComponent("outline", "device-ipad-horizontal-dollar", "IconDeviceIpadHorizontalDollar", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4.5", "key": "svg-0" }], ["path", { "d": "M9 17h4", "key": "svg-1" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-2" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalDollar
});

var IconDeviceIpadHorizontalDown = createReactComponent("outline", "device-ipad-horizontal-down", "IconDeviceIpadHorizontalDown", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalDown
});

var IconDeviceIpadHorizontalExclamation = createReactComponent("outline", "device-ipad-horizontal-exclamation", "IconDeviceIpadHorizontalExclamation", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }], ["path", { "d": "M19 16v3", "key": "svg-2" }], ["path", { "d": "M19 22v.01", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalExclamation
});

var IconDeviceIpadHorizontalHeart = createReactComponent("outline", "device-ipad-horizontal-heart", "IconDeviceIpadHorizontalHeart", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h1", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalHeart
});

var IconDeviceIpadHorizontalMinus = createReactComponent("outline", "device-ipad-horizontal-minus", "IconDeviceIpadHorizontalMinus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v9", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalMinus
});

var IconDeviceIpadHorizontalOff = createReactComponent("outline", "device-ipad-horizontal-off", "IconDeviceIpadHorizontalOff", [["path", { "d": "M8 4h12a2 2 0 0 1 2 2v12m-2 2h-16a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalOff
});

var IconDeviceIpadHorizontalPause = createReactComponent("outline", "device-ipad-horizontal-pause", "IconDeviceIpadHorizontalPause", [["path", { "d": "M13 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h4", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalPause
});

var IconDeviceIpadHorizontalPin = createReactComponent("outline", "device-ipad-horizontal-pin", "IconDeviceIpadHorizontalPin", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalPin
});

var IconDeviceIpadHorizontalPlus = createReactComponent("outline", "device-ipad-horizontal-plus", "IconDeviceIpadHorizontalPlus", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalPlus
});

var IconDeviceIpadHorizontalQuestion = createReactComponent("outline", "device-ipad-horizontal-question", "IconDeviceIpadHorizontalQuestion", [["path", { "d": "M15 20h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M9 17h4.5", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalQuestion
});

var IconDeviceIpadHorizontalSearch = createReactComponent("outline", "device-ipad-horizontal-search", "IconDeviceIpadHorizontalSearch", [["path", { "d": "M11.5 20h-6.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 17h2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalSearch
});

var IconDeviceIpadHorizontalShare = createReactComponent("outline", "device-ipad-horizontal-share", "IconDeviceIpadHorizontalShare", [["path", { "d": "M12.5 20h-7.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 17h3", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalShare
});

var IconDeviceIpadHorizontalStar = createReactComponent("outline", "device-ipad-horizontal-star", "IconDeviceIpadHorizontalStar", [["path", { "d": "M10.5 20h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 17h1", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceIpadHorizontalStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalStar
});

var IconDeviceIpadHorizontalUp = createReactComponent("outline", "device-ipad-horizontal-up", "IconDeviceIpadHorizontalUp", [["path", { "d": "M12 20h-7a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M9 17h3.5", "key": "svg-1" }], ["path", { "d": "M19 22v-6", "key": "svg-2" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalUp
});

var IconDeviceIpadHorizontalX = createReactComponent("outline", "device-ipad-horizontal-x", "IconDeviceIpadHorizontalX", [["path", { "d": "M13.5 20h-8.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }], ["path", { "d": "M9 17h4", "key": "svg-3" }]]);

var IconDeviceIpadHorizontalX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontalX
});

var IconDeviceIpadHorizontal = createReactComponent("outline", "device-ipad-horizontal", "IconDeviceIpadHorizontal", [["path", { "d": "M3 6a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-12z", "key": "svg-0" }], ["path", { "d": "M9 17h6", "key": "svg-1" }]]);

var IconDeviceIpadHorizontal$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadHorizontal
});

var IconDeviceIpadMinus = createReactComponent("outline", "device-ipad-minus", "IconDeviceIpadMinus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }]]);

var IconDeviceIpadMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadMinus
});

var IconDeviceIpadOff = createReactComponent("outline", "device-ipad-off", "IconDeviceIpadOff", [["path", { "d": "M6 2h12a2 2 0 0 1 2 2v12m0 4a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-16", "key": "svg-0" }], ["path", { "d": "M9 19h6", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceIpadOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadOff
});

var IconDeviceIpadPause = createReactComponent("outline", "device-ipad-pause", "IconDeviceIpadPause", [["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h4", "key": "svg-1" }], ["path", { "d": "M17 17v5", "key": "svg-2" }], ["path", { "d": "M21 17v5", "key": "svg-3" }]]);

var IconDeviceIpadPause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadPause
});

var IconDeviceIpadPin = createReactComponent("outline", "device-ipad-pin", "IconDeviceIpadPin", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }]]);

var IconDeviceIpadPin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadPin
});

var IconDeviceIpadPlus = createReactComponent("outline", "device-ipad-plus", "IconDeviceIpadPlus", [["path", { "d": "M12.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M9 18h3", "key": "svg-1" }], ["path", { "d": "M16 19h6", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }]]);

var IconDeviceIpadPlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadPlus
});

var IconDeviceIpadQuestion = createReactComponent("outline", "device-ipad-question", "IconDeviceIpadQuestion", [["path", { "d": "M15 21h-9a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h5", "key": "svg-1" }], ["path", { "d": "M19 22v.01", "key": "svg-2" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-3" }]]);

var IconDeviceIpadQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadQuestion
});

var IconDeviceIpadSearch = createReactComponent("outline", "device-ipad-search", "IconDeviceIpadSearch", [["path", { "d": "M11.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M9 18h2", "key": "svg-1" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-2" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-3" }]]);

var IconDeviceIpadSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadSearch
});

var IconDeviceIpadShare = createReactComponent("outline", "device-ipad-share", "IconDeviceIpadShare", [["path", { "d": "M12 21h-6a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M9 18h3.5", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }]]);

var IconDeviceIpadShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadShare
});

var IconDeviceIpadStar = createReactComponent("outline", "device-ipad-star", "IconDeviceIpadStar", [["path", { "d": "M11 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v5.5", "key": "svg-0" }], ["path", { "d": "M9 18h1", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceIpadStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadStar
});

var IconDeviceIpadUp = createReactComponent("outline", "device-ipad-up", "IconDeviceIpadUp", [["path", { "d": "M9 18h3", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M13.5 21h-6.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v7", "key": "svg-3" }]]);

var IconDeviceIpadUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadUp
});

var IconDeviceIpadX = createReactComponent("outline", "device-ipad-x", "IconDeviceIpadX", [["path", { "d": "M22 22l-5 -5", "key": "svg-0" }], ["path", { "d": "M17 22l5 -5", "key": "svg-1" }], ["path", { "d": "M13 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v9", "key": "svg-2" }], ["path", { "d": "M9 18h4", "key": "svg-3" }]]);

var IconDeviceIpadX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpadX
});

var IconDeviceIpad = createReactComponent("outline", "device-ipad", "IconDeviceIpad", [["path", { "d": "M18 3a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2z", "key": "svg-0" }], ["path", { "d": "M9 18h6", "key": "svg-1" }]]);

var IconDeviceIpad$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceIpad
});

var IconDeviceLandlinePhone = createReactComponent("outline", "device-landline-phone", "IconDeviceLandlinePhone", [["path", { "d": "M20 3h-2a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h2a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z", "key": "svg-0" }], ["path", { "d": "M16 4h-11a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3h11", "key": "svg-1" }], ["path", { "d": "M12 8h-6v3h6z", "key": "svg-2" }], ["path", { "d": "M12 14v.01", "key": "svg-3" }], ["path", { "d": "M9 14v.01", "key": "svg-4" }], ["path", { "d": "M6 14v.01", "key": "svg-5" }], ["path", { "d": "M12 17v.01", "key": "svg-6" }], ["path", { "d": "M9 17v.01", "key": "svg-7" }], ["path", { "d": "M6 17v.01", "key": "svg-8" }]]);

var IconDeviceLandlinePhone$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceLandlinePhone
});

var IconDeviceLaptopOff = createReactComponent("outline", "device-laptop-off", "IconDeviceLaptopOff", [["path", { "d": "M3 19h16", "key": "svg-0" }], ["path", { "d": "M10 6h8a1 1 0 0 1 1 1v8m-3 1h-10a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }]]);

var IconDeviceLaptopOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceLaptopOff
});

var IconDeviceLaptop = createReactComponent("outline", "device-laptop", "IconDeviceLaptop", [["path", { "d": "M3 19l18 0", "key": "svg-0" }], ["path", { "d": "M5 6m0 1a1 1 0 0 1 1 -1h12a1 1 0 0 1 1 1v8a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1z", "key": "svg-1" }]]);

var IconDeviceLaptop$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceLaptop
});

var IconDeviceMobileBolt = createReactComponent("outline", "device-mobile-bolt", "IconDeviceMobileBolt", [["path", { "d": "M13.5 21h-5.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 16l-2 3h4l-2 3", "key": "svg-1" }], ["path", { "d": "M11 4h2", "key": "svg-2" }], ["path", { "d": "M12 17v.01", "key": "svg-3" }]]);

var IconDeviceMobileBolt$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileBolt
});

var IconDeviceMobileCancel = createReactComponent("outline", "device-mobile-cancel", "IconDeviceMobileCancel", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M17 21l4 -4", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileCancel$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileCancel
});

var IconDeviceMobileCharging = createReactComponent("outline", "device-mobile-charging", "IconDeviceMobileCharging", [["path", { "d": "M6 3m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 9.5l-1 2.5h2l-1 2.5", "key": "svg-2" }]]);

var IconDeviceMobileCharging$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileCharging
});

var IconDeviceMobileCheck = createReactComponent("outline", "device-mobile-check", "IconDeviceMobileCheck", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v9.5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M15 19l2 2l4 -4", "key": "svg-3" }]]);

var IconDeviceMobileCheck$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileCheck
});

var IconDeviceMobileCode = createReactComponent("outline", "device-mobile-code", "IconDeviceMobileCode", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M20 21l2 -2l-2 -2", "key": "svg-1" }], ["path", { "d": "M17 17l-2 2l2 2", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileCode$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileCode
});

var IconDeviceMobileCog = createReactComponent("outline", "device-mobile-cog", "IconDeviceMobileCog", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6.5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0", "key": "svg-3" }], ["path", { "d": "M19.001 15.5v1.5", "key": "svg-4" }], ["path", { "d": "M19.001 21v1.5", "key": "svg-5" }], ["path", { "d": "M22.032 17.25l-1.299 .75", "key": "svg-6" }], ["path", { "d": "M17.27 20l-1.3 .75", "key": "svg-7" }], ["path", { "d": "M15.97 17.25l1.3 .75", "key": "svg-8" }], ["path", { "d": "M20.733 20l1.3 .75", "key": "svg-9" }]]);

var IconDeviceMobileCog$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileCog
});

var IconDeviceMobileDollar = createReactComponent("outline", "device-mobile-dollar", "IconDeviceMobileDollar", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5", "key": "svg-3" }], ["path", { "d": "M19 21v1m0 -8v1", "key": "svg-4" }]]);

var IconDeviceMobileDollar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileDollar
});

var IconDeviceMobileDown = createReactComponent("outline", "device-mobile-down", "IconDeviceMobileDown", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19 16v6", "key": "svg-3" }], ["path", { "d": "M22 19l-3 3l-3 -3", "key": "svg-4" }]]);

var IconDeviceMobileDown$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileDown
});

var IconDeviceMobileExclamation = createReactComponent("outline", "device-mobile-exclamation", "IconDeviceMobileExclamation", [["path", { "d": "M15 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M19 16v3", "key": "svg-3" }], ["path", { "d": "M19 22v.01", "key": "svg-4" }]]);

var IconDeviceMobileExclamation$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileExclamation
});

var IconDeviceMobileHeart = createReactComponent("outline", "device-mobile-heart", "IconDeviceMobileHeart", [["path", { "d": "M11.5 21h-3.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z", "key": "svg-2" }]]);

var IconDeviceMobileHeart$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileHeart
});

var IconDeviceMobileMessage = createReactComponent("outline", "device-mobile-message", "IconDeviceMobileMessage", [["path", { "d": "M11 3h10v8h-3l-4 2v-2h-3z", "key": "svg-0" }], ["path", { "d": "M15 16v4a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1h2", "key": "svg-1" }], ["path", { "d": "M10 18v.01", "key": "svg-2" }]]);

var IconDeviceMobileMessage$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileMessage
});

var IconDeviceMobileMinus = createReactComponent("outline", "device-mobile-minus", "IconDeviceMobileMinus", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v10", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }], ["path", { "d": "M16 19h6", "key": "svg-3" }]]);

var IconDeviceMobileMinus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileMinus
});

var IconDeviceMobileOff = createReactComponent("outline", "device-mobile-off", "IconDeviceMobileOff", [["path", { "d": "M7.159 3.185c.256 -.119 .54 -.185 .841 -.185h8a2 2 0 0 1 2 2v9m0 4v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-13", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M3 3l18 18", "key": "svg-2" }], ["path", { "d": "M12 17v.01", "key": "svg-3" }]]);

var IconDeviceMobileOff$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileOff
});

var IconDeviceMobilePause = createReactComponent("outline", "device-mobile-pause", "IconDeviceMobilePause", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M17 17v5", "key": "svg-1" }], ["path", { "d": "M21 17v5", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobilePause$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobilePause
});

var IconDeviceMobilePin = createReactComponent("outline", "device-mobile-pin", "IconDeviceMobilePin", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z", "key": "svg-2" }], ["path", { "d": "M19 18v.01", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobilePin$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobilePin
});

var IconDeviceMobilePlus = createReactComponent("outline", "device-mobile-plus", "IconDeviceMobilePlus", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M16 19h6", "key": "svg-1" }], ["path", { "d": "M19 16v6", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobilePlus$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobilePlus
});

var IconDeviceMobileQuestion = createReactComponent("outline", "device-mobile-question", "IconDeviceMobileQuestion", [["path", { "d": "M15 21h-7a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M19 22v.01", "key": "svg-1" }], ["path", { "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileQuestion$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileQuestion
});

var IconDeviceMobileRotated = createReactComponent("outline", "device-mobile-rotated", "IconDeviceMobileRotated", [["path", { "d": "M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M20 11v2", "key": "svg-1" }], ["path", { "d": "M7 12h-.01", "key": "svg-2" }]]);

var IconDeviceMobileRotated$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileRotated
});

var IconDeviceMobileSearch = createReactComponent("outline", "device-mobile-search", "IconDeviceMobileSearch", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v6", "key": "svg-0" }], ["path", { "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0", "key": "svg-1" }], ["path", { "d": "M20.2 20.2l1.8 1.8", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileSearch$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileSearch
});

var IconDeviceMobileShare = createReactComponent("outline", "device-mobile-share", "IconDeviceMobileShare", [["path", { "d": "M12 21h-4a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M16 22l5 -5", "key": "svg-2" }], ["path", { "d": "M21 21.5v-4.5h-4.5", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileShare$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileShare
});

var IconDeviceMobileStar = createReactComponent("outline", "device-mobile-star", "IconDeviceMobileStar", [["path", { "d": "M11 21h-3a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v5", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z", "key": "svg-2" }]]);

var IconDeviceMobileStar$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileStar
});

var IconDeviceMobileUp = createReactComponent("outline", "device-mobile-up", "IconDeviceMobileUp", [["path", { "d": "M12.5 21h-4.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v7", "key": "svg-0" }], ["path", { "d": "M19 22v-6", "key": "svg-1" }], ["path", { "d": "M22 19l-3 -3l-3 3", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileUp$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileUp
});

var IconDeviceMobileVibration = createReactComponent("outline", "device-mobile-vibration", "IconDeviceMobileVibration", [["path", { "d": "M3 3m0 2a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2z", "key": "svg-0" }], ["path", { "d": "M8 4l2 0", "key": "svg-1" }], ["path", { "d": "M9 17l0 .01", "key": "svg-2" }], ["path", { "d": "M21 6l-2 3l2 3l-2 3l2 3", "key": "svg-3" }]]);

var IconDeviceMobileVibration$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileVibration
});

var IconDeviceMobileX = createReactComponent("outline", "device-mobile-x", "IconDeviceMobileX", [["path", { "d": "M13 21h-5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8", "key": "svg-0" }], ["path", { "d": "M22 22l-5 -5", "key": "svg-1" }], ["path", { "d": "M17 22l5 -5", "key": "svg-2" }], ["path", { "d": "M11 4h2", "key": "svg-3" }], ["path", { "d": "M12 17v.01", "key": "svg-4" }]]);

var IconDeviceMobileX$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobileX
});

var IconDeviceMobile = createReactComponent("outline", "device-mobile", "IconDeviceMobile", [["path", { "d": "M6 5a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-14z", "key": "svg-0" }], ["path", { "d": "M11 4h2", "key": "svg-1" }], ["path", { "d": "M12 17v.01", "key": "svg-2" }]]);

var IconDeviceMobile$1 = /*#__PURE__*/Object.freeze({
  __proto__: null,
  default: IconDeviceMobile
});

var IconDeviceNintendoOff = createReactComponent("outline", "device-nintendo-off", "IconDeviceNintendoOff", [["path", { "d": "M4.713 4.718a4 4 0 0 0 -1.713 3.282v8a4 4 0 0 0 4 4h3v-10m0 -4v-2h-2", "key": "svg-0" }], ["path", { "d": "M14 10v-6h3a4 4 0 0 1 4 4v8c0 .308 -.035 .608 -.1 .896m-1.62 2.39a3.982 3.982 0 0 1 -2.28 .714h-3v-6", "key": "svg-1" }], ["path", { "d": "M6.5 8.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0", "key": "svg-2" }], ["