/*
 * ngtcp2
 *
 * Copyright (c) 2017 ngtcp2 contributors
 * Copyright (c) 2016 nghttp2 contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef NETWORK_H
#define NETWORK_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif // defined(HAVE_CONFIG_H)

#include <sys/types.h>
#ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#endif // defined(HAVE_SYS_SOCKET_H)
#include <sys/un.h>
#ifdef HAVE_NETINET_IN_H
#  include <netinet/in.h>
#endif // defined(HAVE_NETINET_IN_H)
#ifdef HAVE_ARPA_INET_H
#  include <arpa/inet.h>
#endif // defined(HAVE_ARPA_INET_H)

#include <array>
#include <variant>

#include <ngtcp2/ngtcp2.h>

namespace ngtcp2 {

enum network_error {
  NETWORK_ERR_OK = 0,
  NETWORK_ERR_SEND_BLOCKED = -11,
  NETWORK_ERR_CLOSE_WAIT = -12,
  NETWORK_ERR_RETRY = -13,
  NETWORK_ERR_DROP_CONN = -14,
};

using InAddr = std::variant<std::monostate, in_addr, in6_addr>;

using Sockaddr = std::variant<std::monostate, sockaddr_in, sockaddr_in6>;

struct Address {
  // as_sockaddr returns the pointer to the stored address casted to
  // const sockaddr *.
  [[nodiscard]] const sockaddr *as_sockaddr() const;
  [[nodiscard]] sockaddr *as_sockaddr();
  // family returns the address family.
  [[nodiscard]] int family() const;
  // port returns the port.
  [[nodiscard]] uint16_t port() const;
  // port sets |port| to this address.
  void port(uint16_t port);
  // set stores |sa| to this address.  The address family is
  // determined by |sa|->sa_family, and |sa| must point to the memory
  // that contains valid object which is either sockaddr_in or
  // sockaddr_in6.
  void set(const sockaddr *sa);
  // size returns the size of the stored address.
  [[nodiscard]] socklen_t size() const;
  // empty returns true if this address does not contain any
  // meaningful address.
  [[nodiscard]] bool empty() const;

  Sockaddr skaddr;
  uint32_t ifindex{};
};

} // namespace ngtcp2

#endif // !defined(NETWORK_H)
