import { QueryParamConfig } from 'serialize-query-params';
import { QueryParamOptions } from './options';
import { UrlUpdateType } from './types';
declare type NewValueType<D> = D | ((latestValue: D) => D);
/**
 * Given a query param name and query parameter configuration ({ encode, decode })
 * return the decoded value and a setter for updating it.
 *
 * The setter takes two arguments (newValue, updateType) where updateType
 * is one of 'replace' | 'replaceIn' | 'push' | 'pushIn', defaulting to
 * 'pushIn'.
 */
export declare const useQueryParam: <TypeToEncode, TypeFromDecode = TypeToEncode>(name: string, paramConfig?: QueryParamConfig<TypeToEncode, TypeFromDecode> | undefined, options?: QueryParamOptions) => [TypeFromDecode, (newValue: NewValueType<TypeToEncode>, updateType?: UrlUpdateType) => void];
export {};
