import { useEffect, useMemo, useRef, useState } from "react";
import {
  StringParam
} from "serialize-query-params";
import { decodedParamCache } from "./decodedParamCache";
import {
  extendParamConfigForKeys,
  convertInheritedParamStringsToParams
} from "./inheritedParams";
import { makeStableGetLatestDecodedValues } from "./latestValues";
import { memoSearchStringToObject } from "./memoSearchStringToObject";
import { mergeOptions } from "./options";
import { useQueryParamContext } from "./QueryParamProvider";
import { enqueueUpdate } from "./updateSearchString";
import { serializeUrlNameMap } from "./urlName";
function useQueryParams(arg1, arg2) {
  const { adapter, options: contextOptions } = useQueryParamContext();
  const [stableGetLatest] = useState(makeStableGetLatestDecodedValues);
  const { paramConfigMap: paramConfigMapWithInherit, options } = parseArguments(
    arg1,
    arg2
  );
  const mergedOptions = useMemo(() => {
    return mergeOptions(contextOptions, options);
  }, [contextOptions, options]);
  let paramConfigMap = convertInheritedParamStringsToParams(
    paramConfigMapWithInherit,
    mergedOptions
  );
  const parsedParams = memoSearchStringToObject(
    mergedOptions.searchStringToObject,
    adapter.location.search,
    serializeUrlNameMap(paramConfigMap)
  );
  if (mergedOptions.includeAllParams) {
    paramConfigMap = extendParamConfigForKeys(
      paramConfigMap,
      Object.keys(parsedParams),
      mergedOptions.params,
      StringParam
    );
  }
  const decodedValues = stableGetLatest(
    parsedParams,
    paramConfigMap,
    decodedParamCache
  );
  const paramKeyString = Object.keys(paramConfigMap).join("\0");
  useEffect(() => {
    const paramNames = paramKeyString.split("\0");
    decodedParamCache.registerParams(paramNames);
    return () => {
      decodedParamCache.unregisterParams(paramNames);
    };
  }, [paramKeyString]);
  const callbackDependencies = {
    adapter,
    paramConfigMap,
    options: mergedOptions
  };
  const callbackDependenciesRef = useRef(callbackDependencies);
  if (callbackDependenciesRef.current == null) {
    callbackDependenciesRef.current = callbackDependencies;
  }
  useEffect(() => {
    callbackDependenciesRef.current.adapter = adapter;
    callbackDependenciesRef.current.paramConfigMap = paramConfigMap;
    callbackDependenciesRef.current.options = mergedOptions;
  }, [adapter, paramConfigMap, mergedOptions]);
  const [setQuery] = useState(() => {
    const setQuery2 = (changes, updateType) => {
      const { adapter: adapter2, paramConfigMap: paramConfigMap2, options: options2 } = callbackDependenciesRef.current;
      if (updateType == null)
        updateType = options2.updateType;
      enqueueUpdate(
        {
          changes,
          updateType,
          currentSearchString: adapter2.location.search,
          paramConfigMap: paramConfigMap2,
          options: options2,
          adapter: adapter2
        },
        { immediate: !options2.enableBatching }
      );
    };
    return setQuery2;
  });
  return [decodedValues, setQuery];
}
var useQueryParams_default = useQueryParams;
function parseArguments(arg1, arg2) {
  let paramConfigMap;
  let options;
  if (arg1 === void 0) {
    paramConfigMap = {};
    options = arg2;
  } else if (Array.isArray(arg1)) {
    paramConfigMap = Object.fromEntries(
      arg1.map((key) => [key, "inherit"])
    );
    options = arg2;
  } else {
    paramConfigMap = arg1;
    options = arg2;
  }
  return { paramConfigMap, options };
}
export {
  useQueryParams_default as default,
  useQueryParams
};
//# sourceMappingURL=useQueryParams.js.map
