package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnDeletedDomains invokes the cdn.DescribeCdnDeletedDomains API synchronously
func (client *Client) DescribeCdnDeletedDomains(request *DescribeCdnDeletedDomainsRequest) (response *DescribeCdnDeletedDomainsResponse, err error) {
	response = CreateDescribeCdnDeletedDomainsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnDeletedDomainsWithChan invokes the cdn.DescribeCdnDeletedDomains API asynchronously
func (client *Client) DescribeCdnDeletedDomainsWithChan(request *DescribeCdnDeletedDomainsRequest) (<-chan *DescribeCdnDeletedDomainsResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnDeletedDomainsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnDeletedDomains(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnDeletedDomainsWithCallback invokes the cdn.DescribeCdnDeletedDomains API asynchronously
func (client *Client) DescribeCdnDeletedDomainsWithCallback(request *DescribeCdnDeletedDomainsRequest, callback func(response *DescribeCdnDeletedDomainsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnDeletedDomainsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnDeletedDomains(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnDeletedDomainsRequest is the request struct for api DescribeCdnDeletedDomains
type DescribeCdnDeletedDomainsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCdnDeletedDomainsResponse is the response struct for api DescribeCdnDeletedDomains
type DescribeCdnDeletedDomainsResponse struct {
	*responses.BaseResponse
	RequestId  string                             `json:"RequestId" xml:"RequestId"`
	PageNumber int64                              `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64                              `json:"PageSize" xml:"PageSize"`
	TotalCount int64                              `json:"TotalCount" xml:"TotalCount"`
	Domains    DomainsInDescribeCdnDeletedDomains `json:"Domains" xml:"Domains"`
}

// CreateDescribeCdnDeletedDomainsRequest creates a request to invoke DescribeCdnDeletedDomains API
func CreateDescribeCdnDeletedDomainsRequest() (request *DescribeCdnDeletedDomainsRequest) {
	request = &DescribeCdnDeletedDomainsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnDeletedDomains", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnDeletedDomainsResponse creates a response to parse from DescribeCdnDeletedDomains response
func CreateDescribeCdnDeletedDomainsResponse() (response *DescribeCdnDeletedDomainsResponse) {
	response = &DescribeCdnDeletedDomainsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
