package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnAskingBackConfig invokes the cloudcallcenter.ModifyVnAskingBackConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnaskingbackconfig.html
func (client *Client) ModifyVnAskingBackConfig(request *ModifyVnAskingBackConfigRequest) (response *ModifyVnAskingBackConfigResponse, err error) {
	response = CreateModifyVnAskingBackConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnAskingBackConfigWithChan invokes the cloudcallcenter.ModifyVnAskingBackConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnaskingbackconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnAskingBackConfigWithChan(request *ModifyVnAskingBackConfigRequest) (<-chan *ModifyVnAskingBackConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyVnAskingBackConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnAskingBackConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnAskingBackConfigWithCallback invokes the cloudcallcenter.ModifyVnAskingBackConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnaskingbackconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnAskingBackConfigWithCallback(request *ModifyVnAskingBackConfigRequest, callback func(response *ModifyVnAskingBackConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnAskingBackConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnAskingBackConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnAskingBackConfigRequest is the request struct for api ModifyVnAskingBackConfig
type ModifyVnAskingBackConfigRequest struct {
	*requests.RpcRequest
	NegativeFeedbackPrompt       string           `position:"Query" name:"NegativeFeedbackPrompt"`
	NegativeFeedbackAction       string           `position:"Query" name:"NegativeFeedbackAction"`
	Enabled                      requests.Boolean `position:"Query" name:"Enabled"`
	EnableNegativeFeedback       requests.Boolean `position:"Query" name:"EnableNegativeFeedback"`
	InstanceId                   string           `position:"Query" name:"InstanceId"`
	Prompt                       string           `position:"Query" name:"Prompt"`
	NegativeFeedbackUtterances   *[]string        `position:"Query" name:"NegativeFeedbackUtterances"  type:"Repeated"`
	NegativeFeedbackActionParams string           `position:"Query" name:"NegativeFeedbackActionParams"`
}

// ModifyVnAskingBackConfigResponse is the response struct for api ModifyVnAskingBackConfig
type ModifyVnAskingBackConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnAskingBackConfigRequest creates a request to invoke ModifyVnAskingBackConfig API
func CreateModifyVnAskingBackConfigRequest() (request *ModifyVnAskingBackConfigRequest) {
	request = &ModifyVnAskingBackConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnAskingBackConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnAskingBackConfigResponse creates a response to parse from ModifyVnAskingBackConfig response
func CreateModifyVnAskingBackConfigResponse() (response *ModifyVnAskingBackConfigResponse) {
	response = &ModifyVnAskingBackConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
