package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUpgradeAPGroupProgress invokes the cloudwf.GetUpgradeAPGroupProgress API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapgroupprogress.html
func (client *Client) GetUpgradeAPGroupProgress(request *GetUpgradeAPGroupProgressRequest) (response *GetUpgradeAPGroupProgressResponse, err error) {
	response = CreateGetUpgradeAPGroupProgressResponse()
	err = client.DoAction(request, response)
	return
}

// GetUpgradeAPGroupProgressWithChan invokes the cloudwf.GetUpgradeAPGroupProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapgroupprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUpgradeAPGroupProgressWithChan(request *GetUpgradeAPGroupProgressRequest) (<-chan *GetUpgradeAPGroupProgressResponse, <-chan error) {
	responseChan := make(chan *GetUpgradeAPGroupProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUpgradeAPGroupProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUpgradeAPGroupProgressWithCallback invokes the cloudwf.GetUpgradeAPGroupProgress API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getupgradeapgroupprogress.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUpgradeAPGroupProgressWithCallback(request *GetUpgradeAPGroupProgressRequest, callback func(response *GetUpgradeAPGroupProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUpgradeAPGroupProgressResponse
		var err error
		defer close(result)
		response, err = client.GetUpgradeAPGroupProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUpgradeAPGroupProgressRequest is the request struct for api GetUpgradeAPGroupProgress
type GetUpgradeAPGroupProgressRequest struct {
	*requests.RpcRequest
}

// GetUpgradeAPGroupProgressResponse is the response struct for api GetUpgradeAPGroupProgress
type GetUpgradeAPGroupProgressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetUpgradeAPGroupProgressRequest creates a request to invoke GetUpgradeAPGroupProgress API
func CreateGetUpgradeAPGroupProgressRequest() (request *GetUpgradeAPGroupProgressRequest) {
	request = &GetUpgradeAPGroupProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetUpgradeAPGroupProgress", "cloudwf", "openAPI")
	return
}

// CreateGetUpgradeAPGroupProgressResponse creates a response to parse from GetUpgradeAPGroupProgress response
func CreateGetUpgradeAPGroupProgressResponse() (response *GetUpgradeAPGroupProgressResponse) {
	response = &GetUpgradeAPGroupProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
