package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HeadquartersTrend invokes the cloudwf.HeadquartersTrend API synchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstrend.html
func (client *Client) HeadquartersTrend(request *HeadquartersTrendRequest) (response *HeadquartersTrendResponse, err error) {
	response = CreateHeadquartersTrendResponse()
	err = client.DoAction(request, response)
	return
}

// HeadquartersTrendWithChan invokes the cloudwf.HeadquartersTrend API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersTrendWithChan(request *HeadquartersTrendRequest) (<-chan *HeadquartersTrendResponse, <-chan error) {
	responseChan := make(chan *HeadquartersTrendResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HeadquartersTrend(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HeadquartersTrendWithCallback invokes the cloudwf.HeadquartersTrend API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/headquarterstrend.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) HeadquartersTrendWithCallback(request *HeadquartersTrendRequest, callback func(response *HeadquartersTrendResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HeadquartersTrendResponse
		var err error
		defer close(result)
		response, err = client.HeadquartersTrend(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HeadquartersTrendRequest is the request struct for api HeadquartersTrend
type HeadquartersTrendRequest struct {
	*requests.RpcRequest
	Bid requests.Integer `position:"Query" name:"Bid"`
}

// HeadquartersTrendResponse is the response struct for api HeadquartersTrend
type HeadquartersTrendResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateHeadquartersTrendRequest creates a request to invoke HeadquartersTrend API
func CreateHeadquartersTrendRequest() (request *HeadquartersTrendRequest) {
	request = &HeadquartersTrendRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "HeadquartersTrend", "cloudwf", "openAPI")
	return
}

// CreateHeadquartersTrendResponse creates a response to parse from HeadquartersTrend response
func CreateHeadquartersTrendResponse() (response *HeadquartersTrendResponse) {
	response = &HeadquartersTrendResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
