package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDevopsOrganizationMembers invokes the devops_rdc.GetDevopsOrganizationMembers API synchronously
func (client *Client) GetDevopsOrganizationMembers(request *GetDevopsOrganizationMembersRequest) (response *GetDevopsOrganizationMembersResponse, err error) {
	response = CreateGetDevopsOrganizationMembersResponse()
	err = client.DoAction(request, response)
	return
}

// GetDevopsOrganizationMembersWithChan invokes the devops_rdc.GetDevopsOrganizationMembers API asynchronously
func (client *Client) GetDevopsOrganizationMembersWithChan(request *GetDevopsOrganizationMembersRequest) (<-chan *GetDevopsOrganizationMembersResponse, <-chan error) {
	responseChan := make(chan *GetDevopsOrganizationMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDevopsOrganizationMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDevopsOrganizationMembersWithCallback invokes the devops_rdc.GetDevopsOrganizationMembers API asynchronously
func (client *Client) GetDevopsOrganizationMembersWithCallback(request *GetDevopsOrganizationMembersRequest, callback func(response *GetDevopsOrganizationMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDevopsOrganizationMembersResponse
		var err error
		defer close(result)
		response, err = client.GetDevopsOrganizationMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDevopsOrganizationMembersRequest is the request struct for api GetDevopsOrganizationMembers
type GetDevopsOrganizationMembersRequest struct {
	*requests.RpcRequest
	OrgId string `position:"Body" name:"OrgId"`
}

// GetDevopsOrganizationMembersResponse is the response struct for api GetDevopsOrganizationMembers
type GetDevopsOrganizationMembersResponse struct {
	*responses.BaseResponse
	Successful bool     `json:"Successful" xml:"Successful"`
	ErrorCode  string   `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	Object     []Member `json:"Object" xml:"Object"`
}

// CreateGetDevopsOrganizationMembersRequest creates a request to invoke GetDevopsOrganizationMembers API
func CreateGetDevopsOrganizationMembersRequest() (request *GetDevopsOrganizationMembersRequest) {
	request = &GetDevopsOrganizationMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "GetDevopsOrganizationMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDevopsOrganizationMembersResponse creates a response to parse from GetDevopsOrganizationMembers response
func CreateGetDevopsOrganizationMembersResponse() (response *GetDevopsOrganizationMembersResponse) {
	response = &GetDevopsOrganizationMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
