package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListThingModelVersion invokes the iot.ListThingModelVersion API synchronously
func (client *Client) ListThingModelVersion(request *ListThingModelVersionRequest) (response *ListThingModelVersionResponse, err error) {
	response = CreateListThingModelVersionResponse()
	err = client.DoAction(request, response)
	return
}

// ListThingModelVersionWithChan invokes the iot.ListThingModelVersion API asynchronously
func (client *Client) ListThingModelVersionWithChan(request *ListThingModelVersionRequest) (<-chan *ListThingModelVersionResponse, <-chan error) {
	responseChan := make(chan *ListThingModelVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListThingModelVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListThingModelVersionWithCallback invokes the iot.ListThingModelVersion API asynchronously
func (client *Client) ListThingModelVersionWithCallback(request *ListThingModelVersionRequest, callback func(response *ListThingModelVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListThingModelVersionResponse
		var err error
		defer close(result)
		response, err = client.ListThingModelVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListThingModelVersionRequest is the request struct for api ListThingModelVersion
type ListThingModelVersionRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
}

// ListThingModelVersionResponse is the response struct for api ListThingModelVersion
type ListThingModelVersionResponse struct {
	*responses.BaseResponse
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	Code         string                      `json:"Code" xml:"Code"`
	ErrorMessage string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInListThingModelVersion `json:"Data" xml:"Data"`
}

// CreateListThingModelVersionRequest creates a request to invoke ListThingModelVersion API
func CreateListThingModelVersionRequest() (request *ListThingModelVersionRequest) {
	request = &ListThingModelVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "ListThingModelVersion", "", "")
	request.Method = requests.POST
	return
}

// CreateListThingModelVersionResponse creates a response to parse from ListThingModelVersion response
func CreateListThingModelVersionResponse() (response *ListThingModelVersionResponse) {
	response = &ListThingModelVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
