package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagStaticRoute invokes the smartag.ModifySagStaticRoute API synchronously
func (client *Client) ModifySagStaticRoute(request *ModifySagStaticRouteRequest) (response *ModifySagStaticRouteResponse, err error) {
	response = CreateModifySagStaticRouteResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagStaticRouteWithChan invokes the smartag.ModifySagStaticRoute API asynchronously
func (client *Client) ModifySagStaticRouteWithChan(request *ModifySagStaticRouteRequest) (<-chan *ModifySagStaticRouteResponse, <-chan error) {
	responseChan := make(chan *ModifySagStaticRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagStaticRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagStaticRouteWithCallback invokes the smartag.ModifySagStaticRoute API asynchronously
func (client *Client) ModifySagStaticRouteWithCallback(request *ModifySagStaticRouteRequest, callback func(response *ModifySagStaticRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagStaticRouteResponse
		var err error
		defer close(result)
		response, err = client.ModifySagStaticRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagStaticRouteRequest is the request struct for api ModifySagStaticRoute
type ModifySagStaticRouteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Vlan                 string           `position:"Query" name:"Vlan"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NextHop              string           `position:"Query" name:"NextHop"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
	PortName             string           `position:"Query" name:"PortName"`
	DestinationCidr      string           `position:"Query" name:"DestinationCidr"`
}

// ModifySagStaticRouteResponse is the response struct for api ModifySagStaticRoute
type ModifySagStaticRouteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagStaticRouteRequest creates a request to invoke ModifySagStaticRoute API
func CreateModifySagStaticRouteRequest() (request *ModifySagStaticRouteRequest) {
	request = &ModifySagStaticRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagStaticRoute", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagStaticRouteResponse creates a response to parse from ModifySagStaticRoute response
func CreateModifySagStaticRouteResponse() (response *ModifySagStaticRouteResponse) {
	response = &ModifySagStaticRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
