package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTenantName invokes the unimkt.ListTenantName API synchronously
func (client *Client) ListTenantName(request *ListTenantNameRequest) (response *ListTenantNameResponse, err error) {
	response = CreateListTenantNameResponse()
	err = client.DoAction(request, response)
	return
}

// ListTenantNameWithChan invokes the unimkt.ListTenantName API asynchronously
func (client *Client) ListTenantNameWithChan(request *ListTenantNameRequest) (<-chan *ListTenantNameResponse, <-chan error) {
	responseChan := make(chan *ListTenantNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTenantName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTenantNameWithCallback invokes the unimkt.ListTenantName API asynchronously
func (client *Client) ListTenantNameWithCallback(request *ListTenantNameRequest, callback func(response *ListTenantNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTenantNameResponse
		var err error
		defer close(result)
		response, err = client.ListTenantName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTenantNameRequest is the request struct for api ListTenantName
type ListTenantNameRequest struct {
	*requests.RpcRequest
	EndCreateTime    requests.Integer `position:"Query" name:"EndCreateTime"`
	Business         string           `position:"Query" name:"Business"`
	UserId           string           `position:"Query" name:"UserId"`
	OriginSiteUserId string           `position:"Query" name:"OriginSiteUserId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	Environment      string           `position:"Query" name:"Environment"`
	AppName          string           `position:"Query" name:"AppName"`
	StartCreateTime  requests.Integer `position:"Query" name:"StartCreateTime"`
	TenantId         string           `position:"Query" name:"TenantId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	UserSite         string           `position:"Query" name:"UserSite"`
	TenantName       string           `position:"Query" name:"TenantName"`
	Status           string           `position:"Query" name:"Status"`
}

// ListTenantNameResponse is the response struct for api ListTenantName
type ListTenantNameResponse struct {
	*responses.BaseResponse
	Code       string   `json:"Code" xml:"Code"`
	Success    bool     `json:"Success" xml:"Success"`
	Message    string   `json:"Message" xml:"Message"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	Total      int64    `json:"Total" xml:"Total"`
	Model      []Tenant `json:"Model" xml:"Model"`
}

// CreateListTenantNameRequest creates a request to invoke ListTenantName API
func CreateListTenantNameRequest() (request *ListTenantNameRequest) {
	request = &ListTenantNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ListTenantName", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTenantNameResponse creates a response to parse from ListTenantName response
func CreateListTenantNameResponse() (response *ListTenantNameResponse) {
	response = &ListTenantNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
