package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIPv6Translator invokes the vpc.DeleteIPv6Translator API synchronously
func (client *Client) DeleteIPv6Translator(request *DeleteIPv6TranslatorRequest) (response *DeleteIPv6TranslatorResponse, err error) {
	response = CreateDeleteIPv6TranslatorResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIPv6TranslatorWithChan invokes the vpc.DeleteIPv6Translator API asynchronously
func (client *Client) DeleteIPv6TranslatorWithChan(request *DeleteIPv6TranslatorRequest) (<-chan *DeleteIPv6TranslatorResponse, <-chan error) {
	responseChan := make(chan *DeleteIPv6TranslatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIPv6Translator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIPv6TranslatorWithCallback invokes the vpc.DeleteIPv6Translator API asynchronously
func (client *Client) DeleteIPv6TranslatorWithCallback(request *DeleteIPv6TranslatorRequest, callback func(response *DeleteIPv6TranslatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIPv6TranslatorResponse
		var err error
		defer close(result)
		response, err = client.DeleteIPv6Translator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIPv6TranslatorRequest is the request struct for api DeleteIPv6Translator
type DeleteIPv6TranslatorRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6TranslatorId     string           `position:"Query" name:"Ipv6TranslatorId"`
}

// DeleteIPv6TranslatorResponse is the response struct for api DeleteIPv6Translator
type DeleteIPv6TranslatorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIPv6TranslatorRequest creates a request to invoke DeleteIPv6Translator API
func CreateDeleteIPv6TranslatorRequest() (request *DeleteIPv6TranslatorRequest) {
	request = &DeleteIPv6TranslatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteIPv6Translator", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteIPv6TranslatorResponse creates a response to parse from DeleteIPv6Translator response
func CreateDeleteIPv6TranslatorResponse() (response *DeleteIPv6TranslatorResponse) {
	response = &DeleteIPv6TranslatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
