package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsTopDomainsByFlow invokes the vs.DescribeVsTopDomainsByFlow API synchronously
func (client *Client) DescribeVsTopDomainsByFlow(request *DescribeVsTopDomainsByFlowRequest) (response *DescribeVsTopDomainsByFlowResponse, err error) {
	response = CreateDescribeVsTopDomainsByFlowResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsTopDomainsByFlowWithChan invokes the vs.DescribeVsTopDomainsByFlow API asynchronously
func (client *Client) DescribeVsTopDomainsByFlowWithChan(request *DescribeVsTopDomainsByFlowRequest) (<-chan *DescribeVsTopDomainsByFlowResponse, <-chan error) {
	responseChan := make(chan *DescribeVsTopDomainsByFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsTopDomainsByFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsTopDomainsByFlowWithCallback invokes the vs.DescribeVsTopDomainsByFlow API asynchronously
func (client *Client) DescribeVsTopDomainsByFlowWithCallback(request *DescribeVsTopDomainsByFlowRequest, callback func(response *DescribeVsTopDomainsByFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsTopDomainsByFlowResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsTopDomainsByFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsTopDomainsByFlowRequest is the request struct for api DescribeVsTopDomainsByFlow
type DescribeVsTopDomainsByFlowRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	Limit     requests.Integer `position:"Query" name:"Limit"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsTopDomainsByFlowResponse is the response struct for api DescribeVsTopDomainsByFlow
type DescribeVsTopDomainsByFlowResponse struct {
	*responses.BaseResponse
	RequestId         string     `json:"RequestId" xml:"RequestId"`
	StartTime         string     `json:"StartTime" xml:"StartTime"`
	EndTime           string     `json:"EndTime" xml:"EndTime"`
	DomainCount       int64      `json:"DomainCount" xml:"DomainCount"`
	DomainOnlineCount int64      `json:"DomainOnlineCount" xml:"DomainOnlineCount"`
	TopDomains        TopDomains `json:"TopDomains" xml:"TopDomains"`
}

// CreateDescribeVsTopDomainsByFlowRequest creates a request to invoke DescribeVsTopDomainsByFlow API
func CreateDescribeVsTopDomainsByFlowRequest() (request *DescribeVsTopDomainsByFlowRequest) {
	request = &DescribeVsTopDomainsByFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsTopDomainsByFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsTopDomainsByFlowResponse creates a response to parse from DescribeVsTopDomainsByFlow response
func CreateDescribeVsTopDomainsByFlowResponse() (response *DescribeVsTopDomainsByFlowResponse) {
	response = &DescribeVsTopDomainsByFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
