/* Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email hexxagon@nesqi.se 
 * 
 */


#include "helper_functions.h"
#include <iostream>
#include <cstdlib>

Glib::RefPtr<Gdk::Pixbuf> open_pixmap_from_file(const std::string& filename)
{
    std::string name = std::string(IMAGE_INSTALL_DIR) + filename;
    Glib::RefPtr<Gdk::Pixbuf> ret;
   
    try
    {
        ret = Gdk::Pixbuf::create_from_file(name);
    }
    
    catch(Glib::FileError e)
    {
        std::cout << "Could not open image: " << name << ", aborting!\n";
        exit(-1);
    }

    catch(Gdk::PixbufError)
    {
        std::cout << "Could not parse image: " << name << ", aborting!\n";
        exit(-1);
    }

    return ret;
}


void error_dialog(const Glib::ustring &text, Gtk::MessageType mt)
{
    Gtk::MessageDialog dialog(text, false, mt);

    dialog.run();
}
