//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// This type is used to configure a media browser for individual media types.
///
/// Warning: Though this type is declared as a set of mixable options -- and was originally intended to become that eventually -- you should treat it as an enum.
///
/// Warning: In other words, this type should be declared with NS_ENUM rather than NS_OPTIONS, but the latter has historical inertia not worth struggling against.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmedialibrary?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSMediaLibrary(pub NSUInteger);
bitflags::bitflags! {
    impl NSMediaLibrary: NSUInteger {
        #[doc(alias = "NSMediaLibraryAudio")]
        const Audio = 1<<0;
        #[doc(alias = "NSMediaLibraryImage")]
        const Image = 1<<1;
        #[doc(alias = "NSMediaLibraryMovie")]
        const Movie = 1<<2;
    }
}

unsafe impl Encode for NSMediaLibrary {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSMediaLibrary {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// This class configures and displays a media browser panel.
    ///
    /// This class provides no direct access to the panel, and its meaningful contents aren't in the calling process.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/appkit/nsmedialibrarybrowsercontroller?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSMediaLibraryBrowserController;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSMediaLibraryBrowserController {}
);

impl NSMediaLibraryBrowserController {
    extern_methods!(
        #[unsafe(method(sharedMediaLibraryBrowserController))]
        #[unsafe(method_family = none)]
        pub fn sharedMediaLibraryBrowserController() -> Retained<NSMediaLibraryBrowserController>;

        #[unsafe(method(isVisible))]
        #[unsafe(method_family = none)]
        pub fn isVisible(&self) -> bool;

        /// Setter for [`isVisible`][Self::isVisible].
        #[unsafe(method(setVisible:))]
        #[unsafe(method_family = none)]
        pub fn setVisible(&self, visible: bool);

        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub fn frame(&self) -> NSRect;

        /// Setter for [`frame`][Self::frame].
        #[unsafe(method(setFrame:))]
        #[unsafe(method_family = none)]
        pub fn setFrame(&self, frame: NSRect);

        #[unsafe(method(mediaLibraries))]
        #[unsafe(method_family = none)]
        pub fn mediaLibraries(&self) -> NSMediaLibrary;

        /// Setter for [`mediaLibraries`][Self::mediaLibraries].
        #[unsafe(method(setMediaLibraries:))]
        #[unsafe(method_family = none)]
        pub fn setMediaLibraries(&self, media_libraries: NSMediaLibrary);

        /// # Safety
        ///
        /// `sender` should be of the correct type.
        #[unsafe(method(togglePanel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn togglePanel(&self, sender: Option<&AnyObject>);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSMediaLibraryBrowserController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSMediaLibraryBrowserController {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}
