/***************************************************************************
                        main.cpp  -  C-O-B Main Program
                             -------------------
    begin                : Tue Oct 14 10:23:39 BST 2003
    copyright            : (C) 2003 by Paul Robson
    email                : autismuk@autismuk.freeserve.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cob.hxx"

//	**************************************************************************************************************************
//
//                                                      Main Program
//
//	**************************************************************************************************************************

int SDLWrapper::Main(int argc, char *argv[])
{
    int x,y;
    Surface logical;
    Graphics graphics;
    Map map(logical,graphics);
    DisplaySurface disp;
    int LastScore = 0;
    char Buffer[32];
    MenuObject m1(0,"Start Game");
    MenuObject m2(1,"Normal Speed:Brisk Speed:High Speed");
    MenuObject m3(2,"Normal:Difficult:Impossible");
    MenuObject m4(3,"Exit Game");
    Game game(map,graphics,logical);
    do
    {
        disp.SetColour(0,0,0);disp.FillRect();
        disp.SetColour(0,255,255);
        disp.String(32,32,992,256,"Cruising on Broadway");
        disp.SetColour(0,255,0);
        disp.String(200,272,824,302,"Written by Paul Robson");
        disp.String(100,312,924,342,"Based on the original by Jeff Naylor");
        sprintf(Buffer,"Last Score : %05d",LastScore);
        disp.SetColour(255,128,0);
        disp.String(200,392,824,432,Buffer);
        m1.Paint();
        m2.Paint();
        m3.Paint();
        m4.Paint();            
        MouseClick(x,y);
        if (m1.Click(x,y))
        {
            int Speed = m2.Get()*30+100;
            int Chasers = m3.Get()+1;
            int Level = 1;
            game.ResetScore();
            while (game.Run(Speed,Level,Chasers))
            {
                Level = Level + 1;
                if (Level == 5) Level = 1,Chasers++;
                if (Chasers == MAXCHASERS) Chasers = MAXCHASERS-1;
            }
            LastScore = game.GetScore();
        }
        m2.Click(x,y);
        m3.Click(x,y);
    } while (m4.Click(x,y) == 0);
    return EXIT_SUCCESS;
}

char *SDLWrapper::Name(char *Name)
{
    return "Cruising on Broadway";
}

