<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

November 3, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Dennis Adams - Sony
  * [X] Alessandra Tomassi - Industrial Light & Magic
  * [X] J Schulte - Industrial Light & Magic

Apologies:
  * Carol Payne
  * Thomas Mansencal

# **OCIO Configs Working Group Meeting Notes**

* Time change:
    - Michael: All daylight savings shifts are now done and Thomas is unable to 
      attend. Can we shift one hour earlier next time?
    - All ok with this. We will try to not change time mid-daylight savings 
      shift in future to reduce confusion.

* Projects status:
    - Michael: If there is needed discussion around the current generator, 
      let's move that to Slack for now. Other code can be shared via a 
      draft PR to share if needed.
    - Mark: Still need to talk to ACES about naming goals, to get on same page. 
      Alex was at last meeting. We should reach out to him. Since we're pulling 
      naming from CTL, ideally correct in aces-dev. CTL in flux - some PRs that 
      when merged will remove a lot of complexity. We can influence change 
      there similarly to how ACES influences OCIO change.
    - Michael: Last meeting we discussed that the input BuiltinTransforms were 
      largely present, but needed output transforms to proceed. Is there an 
      expected timeline for that work Doug?
    - Doug: Will try to get something before next meeting.
    - Mark: OCIO v2 has display transforms. Are we making use of that? Some 
      transforms have OCES space, but PQ goes straight from scene linear. This 
      config is supposed to represent all the features of OCIO v2. should we 
      make use of both?
    - Doug: Yes, will include this in proposal, but think will make use of 
      display color spaces, so output transforms will be view transform plus 
      display transform. OCES wouldn't have an interface. More recent ACES 
      transforms have moved away from it. OCES was interesting theoretical 
      idea, providing a break point between points of transform that proved to 
      be more confusing. Would not use OCES.
    - Mark: What would become the display space? The generator draws 
      connections between the ACES blobs and the newer transforms skip the OCES 
      step.
    - Doug: Display colorimetry. All the Output Transforms go through that but 
      don't break it out as external interface in CTL, for historical reasons.
    - Mark: That will make it difficult to make generator which looks at CTL to 
      generate. Not married to that plan but seems sensible for tracking 
      upstream. Also happy to abandon it for config expressed in code if that's 
      more useful.
    - Doug: Was thinking could use generator to identify the ACES end and 
      display code value end, but not necessarily use the OCES interface. For 
      output transforms, some go direct from ACES and others through OCES, but 
      we could handle them as if they went from ACES to device.
    - Mark: At moment, generator doesn't parse CTL code, just looks at URN in 
      header of files, so no way to track transforms or chains between functions.
    - Doug: We know anything that expects OCES as input wants to include RRT.
    - Mark: So use RRT as point?
    - Doug: Part of problem is the RRT does not produce display referred 
      imagery, which has caused confusion. Produces idealized output referred 
      intermediate. Actual display referred colorimetry requires first part of 
      ODT. RRT doesn't provide technical benefit. Think we can ignore RRT, and 
      for transforms with OCES input, go from ACES to OCES.
    - Mark: Not sure benefit to tracking CTL to get these relationships if we 
      need to implement transforms. Maybe skip checking of CTL and 
      programmatically build transforms.
    - Michael: Could use generator for testing if not for config generation. To 
      do image comparison etc.
    - Doug: Thomas' generator found issues which have value to go through and 
      report the problems. Agree it may not make sense to follow it strictly 
      from built graph. Needs to be manual intervention at some point. Agree 
      with treating it more as CI process.
    - Mark: Yeah, to get the names from it and try to call those transforms. 
      Will wait until display referred spaces are setup in ACES context.
    - Doug: Yes, will help for me to take one transform and show how it works 
      in OCIO. Will also reduce amount of code. The way I'm proposing it is 
      removing a lot of the redundancy in the current CTL code. If you look at 
      ODTs there are lots of commonalities, so my proposal takes that common 
      part and factors it into the view transform. Will make the overall 
      structure easier to follow.
    - Michael: That would then be a point of divergence in the code. The 
      current code for testing against upstream ACES, and a new generator for
      a config itself.
    - Mark: Will be more similar to other generators.
    - Doug: With input transforms, ones implemented already are CSC transforms. 
      Bunch of those are also IDTs, or the code is similar. Some slight 
      differences between CSCs and IDTs, which were called out and not sure 
      those have been harmonized. Need to investigate that. Should lookout for 
      that issue. Also need to decide if we want to do all the IDTs. ARRI has 
      one per ISO for example, and multiple versions. Tons of IDTs. Do we want 
      to implement them all? Most can be implemented compactly with 
      LogCameraTransform, but at the extreme ISOs ARRI introduces hermite 
      spline to keep from running off edge of LUT, so those would need a Lut1D.
    - Mark: Talked before about making multiple configs, with customizable 
      generators. Think some IDTs would not make the cut, but could be in 
      another version. ARRI could be in there since it's common.
    - J: EI 800 would make sense, but not sure all are needed.
    - Doug: Current ACES config has a bunch of these color spaces so need to 
      decide about compatibility.
    - J: Need to figure out which flavor we publish. One complaint we have 
      heard is the config is unwieldy because of so many color spaces.
    - Mark: Not sure how many need to be builtin transforms as well. Could 
      include LUTs and matrices in some. Could be example for implementation.
    - Michael: We'll need the transforms that make ACES ACES for the reference 
      config. Others can be for the studio config.
    - J: What determines which are included?
    - Mark: We decide with community feedback.
    - Doug: Thomas' graph will illustrate that. Another area where manual 
      intervention is needed. Don't need all ARRI IDTs.
    - Mark: Already filtering if not EI 800.
    - J: EI 800 is base one anyway, so good mandate.
    - Doug: Other thing about the IDTs. ACES repo doesn't include CTL for RED, 
      Canon, etc. Also need to decide about those. In current ACEs config some 
      work was done to track down that stuff and create transforms.
    - Michael: Could cut off stuff not in aces-dev repo.
    - Doug: Need some RED and Canon, and there are CSC transforms for those. 
      Maybe don't go beyond that. Some needed discussion around what those 
      transform are. Was hoping Thomas' work was to produce list of proposed 
      transform IDs to use as builtin transform names. Think thats one of the 
      next steps. Make spreadsheet of specific list of transforms. Which have 
      CTL and which don't, and assign someone to figure out the latest and 
      greatest collection.
    - Mark: Lot of noise in output from generator, filtering through 
      relationships with various rules. Not sure how much of that snuck into 
      graph. Not sure how many intermediates we want in there too.
    - Doug: Think it will help. Discussion that needs more community input. 
      What is in the config and what are the strings.
    - Michael: Can put all transforms in spreadsheet and show which are 
      excluded and why.
    - Mark: Can have column for what is included.
    - **TODO**: Mark will use generator to create a spreadsheet for discussion
      of which transforms are included in reference config.
    - **TODO**: Doug will create example of builtin output transform in OCIO.

* ACES reference config goal
    - Michael: Shall we set a goal to have the reference config done by OCIO 
      v2 (non-RC) release? Would be good to ship an example if possible.
    - Mark: We can try for that. Might get pushed.
