/* SettingsDialog.c generated by valac 0.54.3, the Vala compiler
 * generated from SettingsDialog.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <errno.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MOSERIAL_TYPE_SETTINGS_DIALOG (moserial_settings_dialog_get_type ())
#define MOSERIAL_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog))
#define MOSERIAL_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))
#define MOSERIAL_IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SETTINGS_DIALOG))
#define MOSERIAL_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialogClass))

typedef struct _moserialSettingsDialog moserialSettingsDialog;
typedef struct _moserialSettingsDialogClass moserialSettingsDialogClass;
typedef struct _moserialSettingsDialogPrivate moserialSettingsDialogPrivate;

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
enum  {
	MOSERIAL_SETTINGS_DIALOG_0_PROPERTY,
	MOSERIAL_SETTINGS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* moserial_settings_dialog_properties[MOSERIAL_SETTINGS_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())
typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())
enum  {
	MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL,
	MOSERIAL_SETTINGS_DIALOG_NUM_SIGNALS
};
static guint moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_NUM_SIGNALS] = {0};

struct _moserialSettingsDialog {
	GObject parent_instance;
	moserialSettingsDialogPrivate * priv;
};

struct _moserialSettingsDialogClass {
	GObjectClass parent_class;
};

struct _moserialSettingsDialogPrivate {
	GtkWindow* parent;
	Settings* currentSettings;
	GtkDialog* dialog;
	GtkButton* cancelButton;
	GtkButton* okButton;
	Settings* settings;
	GtkComboBox* deviceCombo;
	GtkComboBox* baudRateCombo;
	GtkComboBox* dataBitsCombo;
	GtkComboBox* stopBitsCombo;
	GtkComboBox* parityCombo;
	GtkCheckButton* hardwareHandshake;
	GtkCheckButton* softwareHandshake;
	GtkComboBox* accessModeCombo;
	GtkCheckButton* localEcho;
	GtkCheckButton* autoConnect;
	GtkListStore* deviceModel;
	GtkEntry* deviceInput;
	GtkEntry* baudRateInput;
};

static gint moserialSettingsDialog_private_offset;
static gpointer moserial_settings_dialog_parent_class = NULL;
VALA_EXTERN gchar* settings_DEFAULT_DEVICEFILE;

VALA_EXTERN GType moserial_settings_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialSettingsDialog, g_object_unref)
VALA_EXTERN GType settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Settings, g_object_unref)
#define MOSERIAL_SETTINGS_DIALOG_max_devices 32
VALA_EXTERN moserialSettingsDialog* moserial_settings_dialog_new (GtkWindow* parent);
VALA_EXTERN moserialSettingsDialog* moserial_settings_dialog_construct (GType object_type,
                                                            GtkWindow* parent);
VALA_EXTERN void mo_utils_populateComboBox (GtkComboBox* Combo,
                                gchar** val_array,
                                gint val_array_length1,
                                gboolean render_cell);
VALA_EXTERN gboolean moserial_settings_dialog_hide (moserialSettingsDialog* self);
static gboolean _moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender,
                                                                 GdkEventAny* event,
                                                                 gpointer self);
VALA_EXTERN void moserial_settings_dialog_cancel (moserialSettingsDialog* self,
                                      GtkWidget* w);
static void _moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
VALA_EXTERN void moserial_settings_dialog_ok (moserialSettingsDialog* self,
                                  GtkWidget* w);
static void _moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void moserial_settings_dialog_populateDevices (moserialSettingsDialog* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN void moserial_settings_dialog_show (moserialSettingsDialog* self,
                                    Settings* settings);
VALA_EXTERN void moserial_settings_dialog_loadSettings (moserialSettingsDialog* self);
VALA_EXTERN const gchar* settings_get_device (Settings* self);
VALA_EXTERN gint settings_get_baudRate (Settings* self);
VALA_EXTERN gint settings_get_dataBits (Settings* self);
VALA_EXTERN gint settings_get_stopBits (Settings* self);
VALA_EXTERN GType settings_parity_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsParity settings_get_parity (Settings* self);
VALA_EXTERN GType settings_access_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsAccessMode settings_get_accessMode (Settings* self);
VALA_EXTERN GType settings_handshake_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsHandshake settings_get_handshake (Settings* self);
VALA_EXTERN gboolean settings_get_localEcho (Settings* self);
VALA_EXTERN gboolean settings_get_autoConnect (Settings* self);
VALA_EXTERN Settings* settings_new (const gchar* device,
                        gint baudRate,
                        gint dataBits,
                        gint stopBits,
                        SettingsParity parity,
                        SettingsHandshake handshake,
                        SettingsAccessMode accessMode,
                        gboolean localEcho,
                        gboolean autoConnect);
VALA_EXTERN Settings* settings_construct (GType object_type,
                              const gchar* device,
                              gint baudRate,
                              gint dataBits,
                              gint stopBits,
                              SettingsParity parity,
                              SettingsHandshake handshake,
                              SettingsAccessMode accessMode,
                              gboolean localEcho,
                              gboolean autoConnect);
static void moserial_settings_dialog_finalize (GObject * obj);
static GType moserial_settings_dialog_get_type_once (void);

VALA_EXTERN const gchar* SETTINGS_BaudRateItems[17];
VALA_EXTERN const gchar* SETTINGS_DataBitItems[4];
VALA_EXTERN const gchar* SETTINGS_StopBitItems[2];
VALA_EXTERN const gchar* SETTINGS_ParityModeStrings[5];
VALA_EXTERN const gchar* SETTINGS_AccessModeStrings[3];

static inline gpointer
moserial_settings_dialog_get_instance_private (moserialSettingsDialog* self)
{
	return G_STRUCT_MEMBER_P (self, moserialSettingsDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_moserial_settings_dialog_hide_gtk_widget_delete_event (GtkWidget* _sender,
                                                        GdkEventAny* event,
                                                        gpointer self)
{
	gboolean result;
	result = moserial_settings_dialog_hide ((moserialSettingsDialog*) self);
	return result;
}

static void
_moserial_settings_dialog_cancel_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	moserial_settings_dialog_cancel ((moserialSettingsDialog*) self, _sender);
}

static void
_moserial_settings_dialog_ok_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	moserial_settings_dialog_ok ((moserialSettingsDialog*) self, _sender);
}

moserialSettingsDialog*
moserial_settings_dialog_construct (GType object_type,
                                    GtkWindow* parent)
{
	moserialSettingsDialog * self = NULL;
	GtkWindow* _tmp0_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp1_;
	GObject* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GObject* _tmp5_;
	GtkButton* _tmp6_;
	GObject* _tmp7_;
	GtkButton* _tmp8_;
	GObject* _tmp9_;
	GtkEntry* _tmp10_;
	GObject* _tmp11_;
	GtkEntry* _tmp12_;
	GObject* _tmp13_;
	GtkComboBox* _tmp14_;
	GtkComboBox* _tmp15_;
	GObject* _tmp16_;
	GtkComboBox* _tmp17_;
	GtkComboBox* _tmp18_;
	GObject* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkComboBox* _tmp21_;
	GObject* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkComboBox* _tmp24_;
	GObject* _tmp25_;
	GtkCheckButton* _tmp26_;
	GtkCheckButton* _tmp27_;
	GObject* _tmp28_;
	GtkCheckButton* _tmp29_;
	GtkCheckButton* _tmp30_;
	GObject* _tmp31_;
	GtkComboBox* _tmp32_;
	GtkComboBox* _tmp33_;
	GObject* _tmp34_;
	GtkCheckButton* _tmp35_;
	GtkCheckButton* _tmp36_;
	GObject* _tmp37_;
	GtkCheckButton* _tmp38_;
	GtkCheckButton* _tmp39_;
	GtkDialog* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GObject* _tmp43_;
	GtkComboBox* _tmp44_;
	GtkListStore* _tmp45_;
	GtkComboBox* _tmp46_;
	GtkListStore* _tmp47_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (moserialSettingsDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp0_;
	_tmp1_ = gtk_builder_new_from_resource (UIROOT "settings_dialog.ui");
	builder = _tmp1_;
	_tmp2_ = gtk_builder_get_object (builder, "settings_dialog");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_dialog_get_type (), GtkDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp3_;
	_tmp4_ = self->priv->dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp4_, parent);
	_tmp5_ = gtk_builder_get_object (builder, "settings_cancel_button");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->cancelButton);
	self->priv->cancelButton = _tmp6_;
	_tmp7_ = gtk_builder_get_object (builder, "settings_ok_button");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->okButton);
	self->priv->okButton = _tmp8_;
	_tmp9_ = gtk_builder_get_object (builder, "settings_device_input");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->deviceInput);
	self->priv->deviceInput = _tmp10_;
	_tmp11_ = gtk_builder_get_object (builder, "settings_baudrate_input");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->baudRateInput);
	self->priv->baudRateInput = _tmp12_;
	_tmp13_ = gtk_builder_get_object (builder, "settings_baud_rate");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->baudRateCombo);
	self->priv->baudRateCombo = _tmp14_;
	_tmp15_ = self->priv->baudRateCombo;
	mo_utils_populateComboBox (_tmp15_, SETTINGS_BaudRateItems, (gint) G_N_ELEMENTS (SETTINGS_BaudRateItems), FALSE);
	_tmp16_ = gtk_builder_get_object (builder, "settings_data_bits");
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->dataBitsCombo);
	self->priv->dataBitsCombo = _tmp17_;
	_tmp18_ = self->priv->dataBitsCombo;
	mo_utils_populateComboBox (_tmp18_, SETTINGS_DataBitItems, (gint) G_N_ELEMENTS (SETTINGS_DataBitItems), TRUE);
	_tmp19_ = gtk_builder_get_object (builder, "settings_stop_bits");
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->stopBitsCombo);
	self->priv->stopBitsCombo = _tmp20_;
	_tmp21_ = self->priv->stopBitsCombo;
	mo_utils_populateComboBox (_tmp21_, SETTINGS_StopBitItems, (gint) G_N_ELEMENTS (SETTINGS_StopBitItems), TRUE);
	_tmp22_ = gtk_builder_get_object (builder, "settings_parity");
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->parityCombo);
	self->priv->parityCombo = _tmp23_;
	_tmp24_ = self->priv->parityCombo;
	mo_utils_populateComboBox (_tmp24_, SETTINGS_ParityModeStrings, (gint) G_N_ELEMENTS (SETTINGS_ParityModeStrings), TRUE);
	_tmp25_ = gtk_builder_get_object (builder, "settings_hardware_handshake");
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->hardwareHandshake);
	self->priv->hardwareHandshake = _tmp26_;
	_tmp27_ = self->priv->hardwareHandshake;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("Also known as RTS/CTS handshaking"));
	_tmp28_ = gtk_builder_get_object (builder, "settings_software_handshake");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->softwareHandshake);
	self->priv->softwareHandshake = _tmp29_;
	_tmp30_ = self->priv->softwareHandshake;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Also known as XON/XOFF handshaking"));
	_tmp31_ = gtk_builder_get_object (builder, "settings_open_for");
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->accessModeCombo);
	self->priv->accessModeCombo = _tmp32_;
	_tmp33_ = self->priv->accessModeCombo;
	mo_utils_populateComboBox (_tmp33_, SETTINGS_AccessModeStrings, (gint) G_N_ELEMENTS (SETTINGS_AccessModeStrings), TRUE);
	_tmp34_ = gtk_builder_get_object (builder, "settings_local_echo");
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->localEcho);
	self->priv->localEcho = _tmp35_;
	_tmp36_ = self->priv->localEcho;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp36_, _ ("Normally disabled"));
	_tmp37_ = gtk_builder_get_object (builder, "settings_auto_connect");
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_check_button_get_type (), GtkCheckButton));
	_g_object_unref0 (self->priv->autoConnect);
	self->priv->autoConnect = _tmp38_;
	_tmp39_ = self->priv->autoConnect;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp39_, _ ("Enable to automatically connect on startup or when a profile is loaded"));
	_tmp40_ = self->priv->dialog;
	g_signal_connect_object ((GtkWidget*) _tmp40_, "delete-event", (GCallback) _moserial_settings_dialog_hide_gtk_widget_delete_event, self, 0);
	_tmp41_ = self->priv->cancelButton;
	g_signal_connect_object (_tmp41_, "clicked", (GCallback) _moserial_settings_dialog_cancel_gtk_button_clicked, self, 0);
	_tmp42_ = self->priv->okButton;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) _moserial_settings_dialog_ok_gtk_button_clicked, self, 0);
	_tmp43_ = gtk_builder_get_object (builder, "settings_device");
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_combo_box_get_type (), GtkComboBox));
	_g_object_unref0 (self->priv->deviceCombo);
	self->priv->deviceCombo = _tmp44_;
	_tmp45_ = gtk_list_store_new (1, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->deviceModel);
	self->priv->deviceModel = _tmp45_;
	_tmp46_ = self->priv->deviceCombo;
	_tmp47_ = self->priv->deviceModel;
	gtk_combo_box_set_model (_tmp46_, (GtkTreeModel*) _tmp47_);
	_g_object_unref0 (builder);
	return self;
}

moserialSettingsDialog*
moserial_settings_dialog_new (GtkWindow* parent)
{
	return moserial_settings_dialog_construct (MOSERIAL_TYPE_SETTINGS_DIALOG, parent);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
moserial_settings_dialog_populateDevices (moserialSettingsDialog* self)
{
	GList* deviceTypes = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkListStore* _tmp8_;
	GtkTreeIter iter = {0};
	GList* _tmp9_;
	g_return_if_fail (self != NULL);
	deviceTypes = NULL;
	_tmp0_ = g_strdup ("/dev/ttyAMA");
	deviceTypes = g_list_append (deviceTypes, _tmp0_);
	_tmp1_ = g_strdup ("/dev/ttyS");
	deviceTypes = g_list_append (deviceTypes, _tmp1_);
	_tmp2_ = g_strdup ("/dev/ttyUSB");
	deviceTypes = g_list_append (deviceTypes, _tmp2_);
	_tmp3_ = g_strdup ("/dev/pts/");
	deviceTypes = g_list_append (deviceTypes, _tmp3_);
	_tmp4_ = g_strdup ("/dev/ttyACM");
	deviceTypes = g_list_append (deviceTypes, _tmp4_);
	_tmp5_ = g_strdup ("/dev/rfcomm");
	deviceTypes = g_list_append (deviceTypes, _tmp5_);
	_tmp6_ = g_strdup ("/dev/cuaU");
	deviceTypes = g_list_append (deviceTypes, _tmp6_);
	_tmp7_ = g_strdup ("/dev/cua");
	deviceTypes = g_list_append (deviceTypes, _tmp7_);
	_tmp8_ = self->priv->deviceModel;
	gtk_list_store_clear (_tmp8_);
	_tmp9_ = deviceTypes;
	{
		GList* devType_collection = NULL;
		GList* devType_it = NULL;
		devType_collection = _tmp9_;
		for (devType_it = devType_collection; devType_it != NULL; devType_it = devType_it->next) {
			gchar* _tmp10_;
			gchar* devType = NULL;
			_tmp10_ = g_strdup ((const gchar*) devType_it->data);
			devType = _tmp10_;
			{
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							gchar* dev = NULL;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							const gchar* _tmp15_;
							if (!_tmp11_) {
								gint _tmp12_;
								_tmp12_ = i;
								i = _tmp12_ + 1;
							}
							_tmp11_ = FALSE;
							if (!(i < MOSERIAL_SETTINGS_DIALOG_max_devices)) {
								break;
							}
							_tmp13_ = devType;
							_tmp14_ = g_strdup_printf ("%s%d", _tmp13_, i);
							dev = _tmp14_;
							_tmp15_ = dev;
							if (g_file_test (_tmp15_, G_FILE_TEST_EXISTS)) {
								GtkListStore* _tmp16_;
								GtkTreeIter _tmp17_ = {0};
								GtkListStore* _tmp18_;
								GtkTreeIter _tmp19_;
								const gchar* _tmp20_;
								_tmp16_ = self->priv->deviceModel;
								gtk_list_store_append (_tmp16_, &_tmp17_);
								iter = _tmp17_;
								_tmp18_ = self->priv->deviceModel;
								_tmp19_ = iter;
								_tmp20_ = dev;
								gtk_list_store_set (_tmp18_, &_tmp19_, 0, _tmp20_, -1);
							}
							_g_free0 (dev);
						}
					}
				}
				_g_free0 (devType);
			}
		}
	}
	(deviceTypes == NULL) ? NULL : (deviceTypes = (_g_list_free__g_free0_ (deviceTypes), NULL));
}

void
moserial_settings_dialog_show (moserialSettingsDialog* self,
                               Settings* settings)
{
	Settings* _tmp0_;
	GtkDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	moserial_settings_dialog_populateDevices (self);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp0_;
	moserial_settings_dialog_loadSettings (self);
	_tmp1_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
}

void
moserial_settings_dialog_loadSettings (moserialSettingsDialog* self)
{
	GtkTreeModel* t = NULL;
	GtkTreeIter ti = {0};
	gboolean success = FALSE;
	GtkComboBox* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_;
	GtkEntry* _tmp17_;
	Settings* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GtkComboBox* _tmp23_;
	GtkTreeModel* _tmp24_;
	GtkTreeModel* _tmp25_;
	GtkTreeModel* _tmp26_;
	GtkTreeIter _tmp27_ = {0};
	gboolean _tmp28_;
	GtkComboBox* _tmp43_;
	GtkTreeModel* _tmp44_;
	GtkTreeModel* _tmp45_;
	GtkTreeModel* _tmp46_;
	GtkTreeIter _tmp47_ = {0};
	gboolean _tmp48_;
	GtkComboBox* _tmp63_;
	Settings* _tmp64_;
	SettingsParity _tmp65_;
	SettingsParity _tmp66_;
	GtkComboBox* _tmp67_;
	Settings* _tmp68_;
	SettingsAccessMode _tmp69_;
	SettingsAccessMode _tmp70_;
	GtkCheckButton* _tmp71_;
	GtkCheckButton* _tmp72_;
	gboolean _tmp73_ = FALSE;
	Settings* _tmp74_;
	SettingsHandshake _tmp75_;
	SettingsHandshake _tmp76_;
	gboolean _tmp81_ = FALSE;
	Settings* _tmp82_;
	SettingsHandshake _tmp83_;
	SettingsHandshake _tmp84_;
	Settings* _tmp89_;
	gboolean _tmp90_;
	gboolean _tmp91_;
	Settings* _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp96_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deviceCombo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (t);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp5_ = gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	ti = _tmp4_;
	success = _tmp5_;
	while (TRUE) {
		GValue str_data = {0};
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GValue _tmp8_ = {0};
		const gchar* _tmp9_;
		Settings* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GtkTreeModel* _tmp15_;
		gboolean _tmp16_;
		if (!success) {
			break;
		}
		_tmp6_ = t;
		_tmp7_ = ti;
		gtk_tree_model_get_value (_tmp6_, &_tmp7_, 0, &_tmp8_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp8_;
		_tmp9_ = g_value_get_string (&str_data);
		_tmp10_ = self->priv->currentSettings;
		_tmp11_ = settings_get_device (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp9_, _tmp12_) == 0) {
			GtkComboBox* _tmp13_;
			GtkTreeIter _tmp14_;
			_tmp13_ = self->priv->deviceCombo;
			_tmp14_ = ti;
			gtk_combo_box_set_active_iter (_tmp13_, &_tmp14_);
		}
		_tmp15_ = t;
		_tmp16_ = gtk_tree_model_iter_next (_tmp15_, &ti);
		success = _tmp16_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp17_ = self->priv->baudRateInput;
	_tmp18_ = self->priv->currentSettings;
	_tmp19_ = settings_get_baudRate (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strdup_printf ("%i", _tmp20_);
	_tmp22_ = _tmp21_;
	gtk_entry_set_text (_tmp17_, _tmp22_);
	_g_free0 (_tmp22_);
	_tmp23_ = self->priv->dataBitsCombo;
	_tmp24_ = gtk_combo_box_get_model (_tmp23_);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (t);
	t = _tmp25_;
	_tmp26_ = t;
	_tmp28_ = gtk_tree_model_get_iter_first (_tmp26_, &_tmp27_);
	ti = _tmp27_;
	success = _tmp28_;
	while (TRUE) {
		GValue str_data = {0};
		GtkTreeModel* _tmp29_;
		GtkTreeIter _tmp30_;
		GValue _tmp31_ = {0};
		const gchar* _tmp32_;
		Settings* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gboolean _tmp38_;
		GtkTreeModel* _tmp41_;
		gboolean _tmp42_;
		if (!success) {
			break;
		}
		_tmp29_ = t;
		_tmp30_ = ti;
		gtk_tree_model_get_value (_tmp29_, &_tmp30_, 0, &_tmp31_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp31_;
		_tmp32_ = g_value_get_string (&str_data);
		_tmp33_ = self->priv->currentSettings;
		_tmp34_ = settings_get_dataBits (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("%i", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strcmp0 (_tmp32_, _tmp37_) == 0;
		_g_free0 (_tmp37_);
		if (_tmp38_) {
			GtkComboBox* _tmp39_;
			GtkTreeIter _tmp40_;
			_tmp39_ = self->priv->dataBitsCombo;
			_tmp40_ = ti;
			gtk_combo_box_set_active_iter (_tmp39_, &_tmp40_);
		}
		_tmp41_ = t;
		_tmp42_ = gtk_tree_model_iter_next (_tmp41_, &ti);
		success = _tmp42_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp43_ = self->priv->stopBitsCombo;
	_tmp44_ = gtk_combo_box_get_model (_tmp43_);
	_tmp45_ = _g_object_ref0 (_tmp44_);
	_g_object_unref0 (t);
	t = _tmp45_;
	_tmp46_ = t;
	_tmp48_ = gtk_tree_model_get_iter_first (_tmp46_, &_tmp47_);
	ti = _tmp47_;
	success = _tmp48_;
	while (TRUE) {
		GValue str_data = {0};
		GtkTreeModel* _tmp49_;
		GtkTreeIter _tmp50_;
		GValue _tmp51_ = {0};
		const gchar* _tmp52_;
		Settings* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gboolean _tmp58_;
		GtkTreeModel* _tmp61_;
		gboolean _tmp62_;
		if (!success) {
			break;
		}
		_tmp49_ = t;
		_tmp50_ = ti;
		gtk_tree_model_get_value (_tmp49_, &_tmp50_, 0, &_tmp51_);
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
		str_data = _tmp51_;
		_tmp52_ = g_value_get_string (&str_data);
		_tmp53_ = self->priv->currentSettings;
		_tmp54_ = settings_get_stopBits (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf ("%i", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strcmp0 (_tmp52_, _tmp57_) == 0;
		_g_free0 (_tmp57_);
		if (_tmp58_) {
			GtkComboBox* _tmp59_;
			GtkTreeIter _tmp60_;
			_tmp59_ = self->priv->stopBitsCombo;
			_tmp60_ = ti;
			gtk_combo_box_set_active_iter (_tmp59_, &_tmp60_);
		}
		_tmp61_ = t;
		_tmp62_ = gtk_tree_model_iter_next (_tmp61_, &ti);
		success = _tmp62_;
		G_IS_VALUE (&str_data) ? (g_value_unset (&str_data), NULL) : NULL;
	}
	_tmp63_ = self->priv->parityCombo;
	_tmp64_ = self->priv->currentSettings;
	_tmp65_ = settings_get_parity (_tmp64_);
	_tmp66_ = _tmp65_;
	gtk_combo_box_set_active (_tmp63_, (gint) _tmp66_);
	_tmp67_ = self->priv->accessModeCombo;
	_tmp68_ = self->priv->currentSettings;
	_tmp69_ = settings_get_accessMode (_tmp68_);
	_tmp70_ = _tmp69_;
	gtk_combo_box_set_active (_tmp67_, (gint) _tmp70_);
	_tmp71_ = self->priv->hardwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp71_, FALSE);
	_tmp72_ = self->priv->softwareHandshake;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp72_, FALSE);
	_tmp74_ = self->priv->currentSettings;
	_tmp75_ = settings_get_handshake (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp73_ = TRUE;
	} else {
		Settings* _tmp77_;
		SettingsHandshake _tmp78_;
		SettingsHandshake _tmp79_;
		_tmp77_ = self->priv->currentSettings;
		_tmp78_ = settings_get_handshake (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp73_ = _tmp79_ == SETTINGS_HANDSHAKE_HARDWARE;
	}
	if (_tmp73_) {
		GtkCheckButton* _tmp80_;
		_tmp80_ = self->priv->hardwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp80_, TRUE);
	}
	_tmp82_ = self->priv->currentSettings;
	_tmp83_ = settings_get_handshake (_tmp82_);
	_tmp84_ = _tmp83_;
	if (_tmp84_ == SETTINGS_HANDSHAKE_BOTH) {
		_tmp81_ = TRUE;
	} else {
		Settings* _tmp85_;
		SettingsHandshake _tmp86_;
		SettingsHandshake _tmp87_;
		_tmp85_ = self->priv->currentSettings;
		_tmp86_ = settings_get_handshake (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp81_ = _tmp87_ == SETTINGS_HANDSHAKE_SOFTWARE;
	}
	if (_tmp81_) {
		GtkCheckButton* _tmp88_;
		_tmp88_ = self->priv->softwareHandshake;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp88_, TRUE);
	}
	_tmp89_ = self->priv->currentSettings;
	_tmp90_ = settings_get_localEcho (_tmp89_);
	_tmp91_ = _tmp90_;
	if (_tmp91_) {
		GtkCheckButton* _tmp92_;
		_tmp92_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp92_, TRUE);
	} else {
		GtkCheckButton* _tmp93_;
		_tmp93_ = self->priv->localEcho;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp93_, FALSE);
	}
	_tmp94_ = self->priv->currentSettings;
	_tmp95_ = settings_get_autoConnect (_tmp94_);
	_tmp96_ = _tmp95_;
	if (_tmp96_) {
		GtkCheckButton* _tmp97_;
		_tmp97_ = self->priv->autoConnect;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp97_, TRUE);
	} else {
		GtkCheckButton* _tmp98_;
		_tmp98_ = self->priv->autoConnect;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp98_, FALSE);
	}
	_g_object_unref0 (t);
}

gboolean
moserial_settings_dialog_hide (moserialSettingsDialog* self)
{
	GtkDialog* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}

void
moserial_settings_dialog_cancel (moserialSettingsDialog* self,
                                 GtkWidget* w)
{
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = NULL;
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar* * unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

void
moserial_settings_dialog_ok (moserialSettingsDialog* self,
                             GtkWidget* w)
{
	gchar* device = NULL;
	gint baudRate = 0;
	gint dataBits = 0;
	gint stopBits = 0;
	SettingsParity parity = 0;
	SettingsHandshake handshake = 0;
	SettingsAccessMode accessMode = 0;
	gboolean pLocalEcho = FALSE;
	gboolean pAutoConnect = FALSE;
	GtkEntry* _tmp0_;
	gchar* unparsed = NULL;
	GtkEntry* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_;
	gchar* _tmp11_;
	GtkComboBox* _tmp16_;
	const gchar* _tmp17_;
	GtkComboBox* _tmp18_;
	const gchar* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkComboBox* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GtkCheckButton* _tmp23_;
	GtkCheckButton* _tmp27_;
	GtkCheckButton* _tmp28_;
	const gchar* _tmp29_;
	SettingsParity _tmp30_;
	SettingsHandshake _tmp31_;
	SettingsAccessMode _tmp32_;
	Settings* _tmp33_;
	Settings* _tmp34_;
	Settings* _tmp35_;
	Settings* _tmp36_;
	GtkDialog* _tmp37_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->deviceInput;
	if (((gint) gtk_entry_get_text_length (_tmp0_)) == 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = settings_DEFAULT_DEVICEFILE;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (device);
		device = _tmp2_;
	} else {
		GtkEntry* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->deviceInput;
		_tmp4_ = gtk_entry_get_text (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (device);
		device = _tmp5_;
	}
	unparsed = NULL;
	_tmp6_ = self->priv->baudRateInput;
	_tmp7_ = gtk_entry_get_text (_tmp6_);
	_tmp10_ = int_try_parse (_tmp7_, &_tmp8_, &_tmp9_, (guint) 10);
	baudRate = _tmp8_;
	_g_free0 (unparsed);
	_tmp11_ = g_strdup (_tmp9_);
	unparsed = _tmp11_;
	if (!_tmp10_) {
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp12_;
		GtkMessageDialog* _tmp13_;
		GtkMessageDialog* _tmp14_;
		GtkMessageDialog* _tmp15_;
		_tmp12_ = self->priv->parent;
		_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp12_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Please enter valid baud rate!");
		g_object_ref_sink (_tmp13_);
		dialog = _tmp13_;
		_tmp14_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp14_);
		_tmp15_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		_g_object_unref0 (dialog);
		_g_free0 (unparsed);
		_g_free0 (device);
		return;
	}
	_tmp16_ = self->priv->dataBitsCombo;
	_tmp17_ = SETTINGS_DataBitItems[gtk_combo_box_get_active (_tmp16_)];
	dataBits = atoi (_tmp17_);
	_tmp18_ = self->priv->stopBitsCombo;
	_tmp19_ = SETTINGS_StopBitItems[gtk_combo_box_get_active (_tmp18_)];
	stopBits = atoi (_tmp19_);
	_tmp20_ = self->priv->parityCombo;
	parity = (SettingsParity) gtk_combo_box_get_active (_tmp20_);
	_tmp21_ = self->priv->accessModeCombo;
	accessMode = (SettingsAccessMode) gtk_combo_box_get_active (_tmp21_);
	_tmp23_ = self->priv->hardwareHandshake;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp23_)) {
		GtkCheckButton* _tmp24_;
		_tmp24_ = self->priv->softwareHandshake;
		_tmp22_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp24_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		handshake = SETTINGS_HANDSHAKE_BOTH;
	} else {
		GtkCheckButton* _tmp25_;
		_tmp25_ = self->priv->hardwareHandshake;
		if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp25_)) {
			handshake = SETTINGS_HANDSHAKE_HARDWARE;
		} else {
			GtkCheckButton* _tmp26_;
			_tmp26_ = self->priv->softwareHandshake;
			if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp26_)) {
				handshake = SETTINGS_HANDSHAKE_SOFTWARE;
			} else {
				handshake = SETTINGS_HANDSHAKE_NONE;
			}
		}
	}
	_tmp27_ = self->priv->localEcho;
	pLocalEcho = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp27_);
	_tmp28_ = self->priv->autoConnect;
	pAutoConnect = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp28_);
	_tmp29_ = device;
	_tmp30_ = parity;
	_tmp31_ = handshake;
	_tmp32_ = accessMode;
	_tmp33_ = settings_new (_tmp29_, baudRate, dataBits, stopBits, _tmp30_, _tmp31_, _tmp32_, pLocalEcho, pAutoConnect);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp33_;
	_tmp34_ = self->priv->settings;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (self->priv->currentSettings);
	self->priv->currentSettings = _tmp35_;
	_tmp36_ = self->priv->currentSettings;
	g_signal_emit (self, moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL], 0, _tmp36_);
	_tmp37_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp37_);
	_g_free0 (unparsed);
	_g_free0 (device);
}

static void
moserial_settings_dialog_class_init (moserialSettingsDialogClass * klass,
                                     gpointer klass_data)
{
	moserial_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &moserialSettingsDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = moserial_settings_dialog_finalize;
	moserial_settings_dialog_signals[MOSERIAL_SETTINGS_DIALOG_UPDATE_SETTINGS_SIGNAL] = g_signal_new ("update-settings", MOSERIAL_TYPE_SETTINGS_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_SETTINGS);
}

static void
moserial_settings_dialog_instance_init (moserialSettingsDialog * self,
                                        gpointer klass)
{
	self->priv = moserial_settings_dialog_get_instance_private (self);
}

static void
moserial_settings_dialog_finalize (GObject * obj)
{
	moserialSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SETTINGS_DIALOG, moserialSettingsDialog);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->currentSettings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancelButton);
	_g_object_unref0 (self->priv->okButton);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->deviceCombo);
	_g_object_unref0 (self->priv->baudRateCombo);
	_g_object_unref0 (self->priv->dataBitsCombo);
	_g_object_unref0 (self->priv->stopBitsCombo);
	_g_object_unref0 (self->priv->parityCombo);
	_g_object_unref0 (self->priv->hardwareHandshake);
	_g_object_unref0 (self->priv->softwareHandshake);
	_g_object_unref0 (self->priv->accessModeCombo);
	_g_object_unref0 (self->priv->localEcho);
	_g_object_unref0 (self->priv->autoConnect);
	_g_object_unref0 (self->priv->deviceModel);
	_g_object_unref0 (self->priv->deviceInput);
	_g_object_unref0 (self->priv->baudRateInput);
	G_OBJECT_CLASS (moserial_settings_dialog_parent_class)->finalize (obj);
}

static GType
moserial_settings_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (moserialSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSettingsDialog), 0, (GInstanceInitFunc) moserial_settings_dialog_instance_init, NULL };
	GType moserial_settings_dialog_type_id;
	moserial_settings_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSettingsDialog", &g_define_type_info, 0);
	moserialSettingsDialog_private_offset = g_type_add_instance_private (moserial_settings_dialog_type_id, sizeof (moserialSettingsDialogPrivate));
	return moserial_settings_dialog_type_id;
}

GType
moserial_settings_dialog_get_type (void)
{
	static volatile gsize moserial_settings_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_settings_dialog_type_id__volatile)) {
		GType moserial_settings_dialog_type_id;
		moserial_settings_dialog_type_id = moserial_settings_dialog_get_type_once ();
		g_once_init_leave (&moserial_settings_dialog_type_id__volatile, moserial_settings_dialog_type_id);
	}
	return moserial_settings_dialog_type_id__volatile;
}

