/*========================== begin_copyright_notice ============================

Copyright (C) 2023-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_metric_sets_MTL_GT2.cpp
//
//     Abstract:   C++ automated generated file that defines Metric Sets
//                 for each Concurrent Group

#include "md_concurrent_group.h"
#include "md_metric_set.h"
#include "md_metric_sets_MTL_GT2.h"
#include "md_information.h"
#include "md_metric.h"
#include "md_utils.h"
#include <algorithm>

#if MD_INCLUDE_MTL_GT2_METRICS

namespace MetricsDiscoveryInternal::MetricSets_MTL_GT2_PipelineStatistics
{
    CPipelineStatsMetricSet::CPipelineStatsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CPipelineStatsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "", 0, 0, 0x80000206, 0, 0, "", 0, "Intel_Raw_Pipeline_Statistics_Query", 0 ) );

        metric = AddMetric( "IAVertices", "Input vertices",
            "The total number of vertices that entered the 3D Pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "vertices", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );

        metric = AddMetric( "IAPrimitives", "Input primitives",
            "The total number of rendering primitives assembled and put into the input assembly stage of the 3D Pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );

        metric = AddMetric( "VsInvocations", "VS per vertex invocations",
            "The total number of times a vertex shader was invoked. 3D rendering invokes the vertex shader once per vertex.",
            "3D Pipe/Vertex Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_VS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );

        metric = AddMetric( "HsInvocations", "HS invocations",
            "The total number of times a hull shader was invoked.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );

        metric = AddMetric( "DsInvocations", "DS invocations",
            "The total number of times a domain shader was invoked.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );

        metric = AddMetric( "GsInvocations", "GS per triangle invocations",
            "The total number of times a geometry shader was invoked per triangle.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );

        metric = AddMetric( "GsPrimitives", "Post-GS primitives",
            "The total number of primitives that flowed through from GS to the clipper if GS was enabled.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );

        metric = AddMetric( "ClipperInvocations", "Clipper invocations",
            "The total number of primitives sent to the Clipper.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );

        metric = AddMetric( "ClipperPrimitives", "Clipper primitives",
            "The total number of primitives that flowed out of the Clipper.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "triangles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );

        metric = AddMetric( "PsInvocations", "PS invocations",
            "The total number of times a pixel shader was invoked. 3D rendering invokes a pixel shader once per pixel or subsample.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );

        metric = AddMetric( "CsInvocations", "CS invocations",
            "The total number of times a compute shader was invoked.",
            "3D Pipe/Compute Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );

        metric = AddMetric( "CpsInvocations", "CPS invocations",
            "The total number of times a coarse shader was invoked.",
            "3D Pipe/Compute Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CS * 0x10000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_OGL | API_TYPE_OGL4_X,
            METRIC_TYPE_EVENT, RESULT_UINT64, "invocations", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );

        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

} // namespace MetricsDiscoveryInternal::MetricSets_MTL_GT2_PipelineStatistics

namespace MetricsDiscoveryInternal::MetricSets_MTL_GT2_OA
{
    TCompletionCode AddInformationSet( CConcurrentGroup* concurrentGroup )
    {
        CInformation* information = nullptr;

        information = concurrentGroup->AddInformation( "QueryBeginTime", "Query Begin Time", "The measurement begin time.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_TIMESTAMP, "ns", nullptr, 0 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x1c0" ) );
        MD_CHECK_CC( information->SetOverflowFunction( "NS_TIME" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyMHz", "GPU Core Frequency", "The last GPU core (unslice) frequency in the measurement.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 1 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 0x1ff AND 16666 UMUL 1000 UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x218 1000000 UDIV" ) );

        information = concurrentGroup->AddInformation( "XveSliceFrequencyMHz", "XVE Slice Frequency", "The last GPU Vector Engine Unit slice frequency in the measurement.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 2 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 25 >> dw@0x0 9 >> 0x3 AND OR 16666 UMUL 1000 UDIV" ) );

        information = concurrentGroup->AddInformation( "ReportReason", "Report Reason", "The reason of the report.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_REPORT_REASON, nullptr, nullptr, 3 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 19 >> 0x7f AND" ) );

        information = concurrentGroup->AddInformation( "ContextIdValid", "Context ID Valid", "When set indicates render context is valid", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_FLAG, nullptr, nullptr, 4 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 16 >> 0x1 AND" ) );

        information = concurrentGroup->AddInformation( "ContextId", "Context ID", "The context tag in which report has been taken.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_CONTEXT_ID_TAG, nullptr, nullptr, 5 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 0xfc7fffbf AND dw@0x0 16 >> 0x1 AND UMUL" ) );

        information = concurrentGroup->AddInformation( "SourceId", "SourceId", "SourceId", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 6 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 26 >> 0x3f AND" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyChanged", "GPU Core Frequency Changed", "The flag indicating that GPU core frequency has changed.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 7 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x214" ) );

        information = concurrentGroup->AddInformation( "QuerySplitOccurred", "Query Split Occurred", "The flag indicating that query has been split during execution on the GPU.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 8 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x210" ) );

        information = concurrentGroup->AddInformation( "ReportId", "Query report id", "Query report identification number.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 9 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x220" ) );

        information = concurrentGroup->AddInformation( "ReportsCount", "Query reports count", "The number of available query reports.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 10 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x224" ) );

        information = concurrentGroup->AddInformation( "OverrunOccured", "Query Overrun Occurred", "The flag indicating that Oa buffer has been overran.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 11 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1dc" ) );

        information = concurrentGroup->AddInformation( "MidQueryTimer", "Mid Query Timer", "The flag indicating that timer report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 12 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryProgramming", "Mid Query Programming", "The flag indicating that counter programming report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 13 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMarker", "Mid Query Marker", "The flag indicating that query marker report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 14 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x04 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryCtxSwitch", "Mid Query Context Switch", "The flag indicating that context switch report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 15 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryC6", "Mid Query C6", "The flag indicating that C6 report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 16 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryFreqChange", "Mid Query Freq Change", "The flag indicating that frequency change report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 17 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMmioTrigger", "Mid Query Mmio Trigger", "The flag indicating that mmio trigger report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 18 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x40 AND" ) );

        information = concurrentGroup->AddInformation( "StreamMarker", "Stream marker", "Stream marker value.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 19 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 dw@0x0 19 >> 0x8 AND 0x0 == UMUL" ) );

        information = concurrentGroup->AddInformation( "ReportError", "Query report error", "An error in the query execution, the received report should be ignored.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 20 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x33 AND" ) );

        information = concurrentGroup->AddInformation( "ReportLost", "Query report lost", "Begin or end query report has not been triggered due to hw limitations.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 21 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "ReportInconsistent", "Query report inconsistent", "The contextId inconsistency in the Oa buffer within the query window.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 22 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "ReportCtxSwitchLost", "Query report context switch lost", "Other contexts activity is not filter out from the query report.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 23 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "ReportWithoutWorkload", "Query report missing workload", "Missing workload between query begin and query end.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 24 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "ReportContextMismatch", "Query report context mismatch", "Contexts on query begin and query end are different.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 25 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "ReportQueryNotExecuted", "Query report not executed", "Begin or end query report was not executed.", "Report Meta Data", API_TYPE_DX12 | API_TYPE_VULKAN, INFORMATION_TYPE_FLAG, nullptr, nullptr, 26 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x04 AND" ) );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRenderBasicMetricSet::CRenderBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRenderBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuEmActive", "EM And FPU Pipes Active",
            "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsFpuActive", "VS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsEmActive", "VS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsSendActive", "VS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsFpuActive", "PS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsEmActive", "PS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsSendActive", "PS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "RasterizedPixels", "Rasterized Pixels",
            "The total number of rasterized pixels.",
            "3D Pipe/Rasterizer", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,pixel|fragment", "oa.fixed", 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x64:0xb5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xb8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HiDepthTestFails", "Early Hi-Depth Test Fails",
            "The total number of pixels dropped on early hierarchical depth test.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x68:0xb6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "EarlyDepthTestFails", "Early Depth Test Fails",
            "The total number of pixels dropped on early depth test.",
            "3D Pipe/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x6c:0xb7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplesKilledInPs", "Samples Killed in PS",
            "The total number of samples or pixels dropped in pixel shaders.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x70" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "PixelsFailingPostPsTests", "Pixels Failing Tests",
            "The total number of pixels dropped on post-PS alpha, stencil, or depth tests.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x74" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesWritten", "Samples Written",
            "The total number of samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x78" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesBlended", "Samples Blended",
            "The total number of blended samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x7c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplerTexels", "Sampler Texels",
            "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
            "Sampler/Sampler Input", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_IN * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x80:0xbc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplerTexelMisses", "Sampler Texels Misses",
            "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
            "Sampler/Sampler Cache", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_CACHE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_BATCH | USAGE_FLAG_FRAME | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 28 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x84:0xbd" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SlmReads", "SLM Bytes Read",
            "The total number of reads from shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 29 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x88:0xbe" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x100" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "SlmWrites", "SLM Writes",
            "The total number of writes into shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 30 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x8c:0xbf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x108" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "ShaderMemoryAccesses", "Shader Memory Accesses",
            "The total number of shader memory accesses to L3.",
            "L3/Data Port", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 31 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x90" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x110" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderAtomics", "Shader Atomic Memory Accesses",
            "The total number of shader atomic memory accesses.",
            "L3/Data Port/Atomics", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_ATOMICS * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 32 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderBarriers", "Shader Barrier Messages",
            "The total number of shader barrier messages.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 33 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GtiReadThroughput", "GTI Read Throughput",
            "The total number of GPU memory bytes read from GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 34 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "GtiWriteThroughput", "GTI Write Throughput",
            "The total number of GPU memory bytes written to GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 35 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "SamplersBusy", "Samplers Busy",
            "The percentage of time in which samplers or L1 cache are not idle.",
            "Sampler", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtXeCoreMask 1 AND", nullptr, nullptr, 36 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SamplerBottleneck", "Samplers Bottleneck",
            "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.",
            "Sampler", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_INDICATE | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_SLICE, "$GtXeCoreMask 1 AND", nullptr, nullptr, 37 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20042800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04042000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14040800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16040037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00003008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00011010, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00050012, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00052051, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeBasicMetricSet::CComputeBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "FpuActive", "XVE FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "EmActive", "EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XmxActive", "XMX Pipe Active",
            "The percentage of time in which XVE XMX pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuEmActive", "EM And FPU Pipes Active",
            "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuXmxActive", "XMX And FPU Pipes Active",
            "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveAvgIpcRate", "XVE AVG IPC Rate",
            "The average rate of IPC calculated for 2 FPU pipelines.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_RATIO, RESULT_FLOAT, "number", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$XveFpuEmActive $FpuActive $EmActive FADD $EmActive FSUB FDIV 1 FADD" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "2" ) );

        metric = AddMetric( "SendActive", "Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x4c:0xaf FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x88 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt16", "FPU FLT16 Instruction",
            "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt32", "FPU FLT32 Instruction",
            "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x54:0xb1" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x98" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveFpuFlt64", "FPU FLT64 Instruction",
            "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x58:0xb2" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "RasterizedPixels", "Rasterized Pixels",
            "The total number of rasterized pixels.",
            "3D Pipe/Rasterizer", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,pixel|fragment", "oa.fixed", 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x64:0xb5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xb8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HiDepthTestFails", "Early Hi-Depth Test Fails",
            "The total number of pixels dropped on early hierarchical depth test.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x68:0xb6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "EarlyDepthTestFails", "Early Depth Test Fails",
            "The total number of pixels dropped on early depth test.",
            "3D Pipe/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x6c:0xb7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xc8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplesKilledInPs", "Samples Killed in PS",
            "The total number of samples or pixels dropped in pixel shaders.",
            "3D Pipe/Pixel Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_PS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x70" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "PixelsFailingPostPsTests", "Pixels Failing Tests",
            "The total number of pixels dropped on post-PS alpha, stencil, or depth tests.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "Pixel|Fragment,PS|FS,pixel|fragment", "oa.fixed", 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x74" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xd8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesWritten", "Samples Written",
            "The total number of samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 28 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x78" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplesBlended", "Samples Blended",
            "The total number of blended samples or pixels written to all render targets.",
            "3D Pipe/Output Merger", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_OM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "pixels", 0, 0, HW_UNIT_GPU, nullptr, "pixel|fragment", "oa.fixed", 29 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x7c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xe8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SamplerTexels", "Sampler Texels",
            "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.",
            "Sampler/Sampler Input", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_IN * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 30 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x80:0xbc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SamplerTexelMisses", "Sampler Texels Misses",
            "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.",
            "Sampler/Sampler Cache", ( METRIC_GROUP_NAME_ID_SAMPLER * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER_CACHE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_BATCH | USAGE_FLAG_FRAME | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "texels", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 31 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x84:0xbd" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xf8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 4 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "SlmReads", "SLM Bytes Read",
            "The total number of reads from shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 32 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x88:0xbe" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x100" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "SlmWrites", "SLM Writes",
            "The total number of writes into shared local memory.",
            "L3/Data Port/SLM", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SLM * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 33 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x8c:0xbf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x108" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $XeCoreTotalCount UMUL" ) );

        metric = AddMetric( "ShaderMemoryAccesses", "Shader Memory Accesses",
            "The total number of shader memory accesses to L3.",
            "L3/Data Port", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 34 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x90" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x110" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderAtomics", "Shader Atomic Memory Accesses",
            "The total number of shader atomic memory accesses.",
            "L3/Data Port/Atomics", ( METRIC_GROUP_NAME_ID_L3 * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ) | ( METRIC_GROUP_NAME_ID_ATOMICS * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 35 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ShaderBarriers", "Shader Barrier Messages",
            "The total number of shader barrier messages.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 36 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GtiReadThroughput", "GTI Read Throughput",
            "The total number of GPU memory bytes read from GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 37 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        metric = AddMetric( "GtiWriteThroughput", "GTI Write Throughput",
            "The total number of GPU memory bytes written to GTI.",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 38 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks 512 UMUL" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00001000, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00003009, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x0000200a, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00006008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe55c, 0x0000b007, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CAsyncComputeMetricSet::CAsyncComputeMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CAsyncComputeMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "FpuActive", "XVE FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsFpuActive", "VS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsFpuActive", "PS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsFpuActive", "CS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "AsyncCsFpuActive", "ASYNC CS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "EmActive", "EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsEmActive", "VS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PsEmActive", "PS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a pixel shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsEmActive", "CS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "AsyncCsEmActive", "ASYNC CS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x54:0xb1 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x98 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x58:0xb2" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x5c:0xb3" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0xa8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00010000, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00060050, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00001090, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00051011, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00091061, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe55c, 0x00004008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe65c, 0x00000005, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CXveActivityMetricSet::CXveActivityMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CXveActivityMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "HsFpuActive", "HS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsFpuActive", "DS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsFpuActive", "GS FPU Pipe Active",
            "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HsEmActive", "HS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsEmActive", "DS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsEmActive", "GS EM Pipe Active",
            "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HsSendActive", "HS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DsSendActive", "DS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GsSendActive", "GS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "CsSendActive", "CS Send Pipe Active",
            "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00030020, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00021040, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00041031, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x00032022, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x00062042, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CGpuBusynessMetricSet::CGpuBusynessMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CGpuBusynessMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveActive", "XVE Active",
            "The percentage of time in which the Execution Units were actively processing.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveStall", "XVE Stall",
            "The percentage of time in which the Execution Units were stalled.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XveThreadOccupancy", "XVE Thread Occupancy",
            "The percentage of time in which hardware threads occupied XVEs.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "VsThreads", "VS Threads Dispatched",
            "The total number of vertex shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x14" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x18" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "HsThreads", "HS Threads Dispatched",
            "The total number of hull shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "hull|control,HS|TCS", "oa.fixed", 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x18" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x20" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DsThreads", "DS Threads Dispatched",
            "The total number of domain shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "domain|evaluation,DS|TES", "oa.fixed", 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x1c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x28" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GsThreads", "GS Threads Dispatched",
            "The total number of geometry shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x24:0xa5" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x38" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "PsThreads", "PS Threads Dispatched",
            "The total number of pixel shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, "PS|FS,pixel|fragment", "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x28:0xa6" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x40" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "CsThreads", "CS Threads Dispatched",
            "The total number of compute shader hardware threads dispatched.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "RenderBusy", "Render Ring Busy",
            "The percentage of time when render command streamer was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ComputeEngine0Busy", "ComputeEngine0 Ring Busy",
            "The percentage of time when compute command streamer 0 was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "BlitterBusy", "Blitter Ring Busy",
            "The percentage of time when blitter command streamer was busy.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a022400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c012400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26010009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16020004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010c09, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16010100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18010014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CHDCAndSFMetricSet::CHDCAndSFMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CHDCAndSFMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader00AccessStalledOnL3", "Slice0 Xe Core0 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core0)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader01AccessStalledOnL3", "Slice0 Xe Core1 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core1)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader02AccessStalledOnL3", "Slice0 Xe Core2 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core2)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonSamplerShader03AccessStalledOnL3", "Slice0 Xe Core3 Non-sampler Shader Access Stalled On L3",
            "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core3)",
            "GPU/Data Port", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DATA_PORT * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Poly0DataReady", "Polygon (Slice0) Data Ready",
            "The percentage of time in which geometry pipeline output is ready",
            "GPU/3D Pipe/Strip-Fans", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GTRequestQueue00Full", "SQ00 is full",
            "The percentage of time when IDI0 SQ00 is filled above a threshold (usually 48 entries)",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GTRequestQueue01Full", "SQ01 is full",
            "The percentage of time when IDI0 SQ01 is filled above a threshold (usually 48 entries)",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GTRequestQueue10Full", "SQ10 is full",
            "The percentage of time when IDI0 SQ10 is filled above a threshold (usually 48 entries)",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GTRequestQueue11Full", "SQ11 is full",
            "The percentage of time when IDI0 SQ11 is filled above a threshold (usually 48 entries)",
            "GTI", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c023800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06024e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c023800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c023800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080209c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000200c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000800c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c023800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020027, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c106400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2607001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e07001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2208001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a08001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001301a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00140050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001700a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00100000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x061009c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c001c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e001c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d00a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000602a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02065500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000102af, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0607000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160705a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100805a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fffd, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fffb, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL3MetricSet::CL3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK0", "L3 Input Available L3bank0",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK1", "L3 Input Available L3bank1",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK2", "L3 Input Available L3bank2",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK3", "L3 Input Available L3bank3",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK0", "L3 Output Ready L3bank0",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK1", "L3 Output Ready L3bank1",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK2", "L3 Output Ready L3bank2",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK3", "L3 Output Ready L3bank3",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12410007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x108101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRasterizerAndPixelBackend1MetricSet::CRasterizerAndPixelBackend1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRasterizerAndPixelBackend1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer0OutputReady", "Slice0 Rasterizer Output Ready",
            "The percentage of time in which slice0 rasterizer output is ready",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData00Ready", "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData01Ready", "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSOutput00Available", "PS00 Output Available",
            "The percentage of time in which PS00 output is available",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "PS|FS", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelValues00Ready", "Pixel Values 00 Ready",
            "The percentage of time in which pixel values 00 are ready",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x161224c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24107000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0e7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0e6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080f7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0f6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10120e31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02120000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00120000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001300a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02137c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00140050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001700a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02100020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12100037, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00100000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ce00f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020e0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040e7d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ee00c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d0050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f07d0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206a800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000100aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201a800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010060, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000060, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRasterizerAndPixelBackend2MetricSet::CRasterizerAndPixelBackend2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRasterizerAndPixelBackend2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Rasterizer0InputAvailable", "Slice0 Rasterizer Input Available",
            "The percentage of time in which slice0 rasterizer input is available",
            "GPU/Rasterizer", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, "$GtSlice0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData00Ready", "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelData01Ready", "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready",
            "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)",
            "GPU/Rasterizer/Early Depth Test", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_IZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSOutput00Available", "PS00 Output Available",
            "The percentage of time in which PS00 output is available",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "PS|FS", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PixelValues00Ready", "Pixel Values 00 Ready",
            "The percentage of time in which pixel values 00 are ready",
            "GPU/3D Pipe", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SLICE, nullptr, "Pixel|Fragment,pixel|fragment", nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x161224c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24106000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26100000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0e7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0e6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080f701f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0f6000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10120c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12120038, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02120000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00120000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00132815, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00141400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00151400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00161415, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00172800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021069a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04100fb5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00100000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cc07f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020e0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060e0400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080e001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ec067, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d1400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060f0400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00062aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00012aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010804, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010060, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x70800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000000c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000300, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ff9f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CRenderPipeProfileMetricSet::CRenderPipeProfileMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CRenderPipeProfileMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vf0Bottleneck", "VF0 Bottleneck",
            "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Input Assembler", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_IA * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Vs0Bottleneck", "VS0 Bottleneck",
            "The percentage of time in which VS0 pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Vertex Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_VS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl0Bottleneck", "Clipper0 Bottleneck",
            "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 10, 30, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs0Bottleneck", "HS0 Bottleneck",
            "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 3, 9, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds0Bottleneck", "DS0 Bottleneck",
            "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Gs0Bottleneck", "GS0 Bottleneck",
            "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Geometry Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_GS * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf0Bottleneck", "SF0 Bottleneck",
            "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 10, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So0Bottleneck", "SO0 Bottleneck",
            "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Cl0Stall", "CL0 Stall",
            "The percentage of time in which clipper pipeline stage was stalled.",
            "3D Pipe/Clipper", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_CL * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Hs0Stall", "HS0 Stall",
            "The percentage of time in which hull stall pipeline stage was stalled.",
            "3D Pipe/Hull Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_HS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Hull|Control,hull|control,HS|TCS", nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Ds0Stall", "DS0 Stall",
            "The percentage of time in which domain shader pipeline stage was stalled.",
            "3D Pipe/Domain Shader", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_DS * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, "Domain|Evaluation,domain|evaluation,DS|TES", nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sf0Stall", "SF0 Stall",
            "The percentage of time in which strip-fans pipeline stage was stalled.",
            "3D Pipe/Rasterizer/Strip-Fans", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_SF * 0x100 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "So0Stall", "SO0 Stall",
            "The percentage of time in which stream-output pipeline stage was stalled.",
            "3D Pipe/Stream Output", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SO * 0x10000 ), USAGE_FLAG_TIER_4 | USAGE_FLAG_CORRELATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth00Bottleneck", "Hi-Depth00 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "HiDepth01Bottleneck", "Hi-Depth01 Bottleneck",
            "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Hi-Depth Test", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_HZ * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Bc00Bottleneck", "BC00 Bottleneck",
            "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.",
            "3D Pipe/Rasterizer/Barycentric Calc", ( METRIC_GROUP_NAME_ID_3D_PIPE * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_WM * 0x10000 ) | ( METRIC_GROUP_NAME_ID_BC * 0x100 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_INDICATE | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 5, 15, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1807001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02043000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16070002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a150000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x221503c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24150000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x161601f0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16170640, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c170002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1418001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a180000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140e2400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120f2400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaa8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021382aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144155, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04150003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06150020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a150003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e150ae3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10150001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12150880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14150029, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150544, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02154014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04160200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06160025, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02164155, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04170000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a170880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10170840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00170044, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02178004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00180002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02180010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04180032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06180003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c180007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cbfff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020e0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100e01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x060e0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e9fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d4000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000f0004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100f01c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040f0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02068aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201baaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010402, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010401, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010e06, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSamplerMetricSet::CSamplerMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSamplerMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler00InputAvailable", "Slice0 Xe Core0 Input Available",
            "The percentage of time in which slice0 Xe core0 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler01InputAvailable", "Slice0 Xe Core1 Input Available",
            "The percentage of time in which slice0 Xe core1 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler02InputAvailable", "Slice0 Xe Core2 Input Available",
            "The percentage of time in which slice0 Xe core2 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler03InputAvailable", "Slice0 Xe Core3 Input Available",
            "The percentage of time in which slice0 Xe core3 sampler input is available",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler00OutputReady", "Slice0 Xe Core0 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core0 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler01OutputReady", "Slice0 Xe Core1 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core1 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler02OutputReady", "Slice0 Xe Core2 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core2 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "Sampler03OutputReady", "Slice0 Xe Core3 Sampler Output Ready",
            "The percentage of time in which slice0 Xe core3 sampler output is ready",
            "GPU/Sampler", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_SAMPLER * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14032c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14010024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02027030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02083030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14032c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02021000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02041020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14032c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010024, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020703, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040509, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080303, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1a010013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14032c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10010900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c030016, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040102, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02170a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c3300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e3300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d0a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02060a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201fafa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5001042a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54011203, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL1MetricSet::CTDL1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread00ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread00ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00Ready", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort0", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort1", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort2", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader00ReadyPort3", "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread01ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread01ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01Ready", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort0", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort1", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort2", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader01ReadyPort3", "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c070400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000455ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0204ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a070821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14070cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16070c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c070400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020400ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e070821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10070cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12070c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTDL2MetricSet::CTDL2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTDL2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuBusy", "GPU Busy",
            "The percentage of time in which the GPU has been processing GPU commands.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x10" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x10" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread02ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", "PS|FS", nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread02ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", "PS|FS", nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02Ready", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort0", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort1", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort2", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader02ReadyPort3", "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "NonPSThread03ReadyForDispatch", "Non-PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", "PS|FS", nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "PSThread03ReadyForDispatch", "PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", "PS|FS", nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03Ready", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort0", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 0",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 0",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort1", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 1",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 1",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort2", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 2",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 2",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "ThreadHeader03ReadyPort3", "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 3",
            "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 3",
            "GPU/Thread Dispatcher", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_TD * 0x10000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c070400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000455ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0204ff55, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a070821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14070cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16070c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c070400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0004ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020400ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06070006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0708e2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e070821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10070cb3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12070c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000effff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTestOaMetricSet::CTestOaMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTestOaMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Counter0", "TestCounter0",
            "HW test counter 0. Factor: 0.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter1", "TestCounter1",
            "HW test counter 1. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter2", "TestCounter2",
            "HW test counter 2. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter3", "TestCounter3",
            "HW test counter 3. Factor: 0.5",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter4", "TestCounter4",
            "HW test counter 4. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter5", "TestCounter5",
            "HW test counter 5. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter6", "TestCounter6",
            "HW test counter 6. Factor: 0.16666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter7", "TestCounter7",
            "HW test counter 7. Factor: 0.6666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter8", "TestCounter8",
            "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter9", "TestCounter9 - OAR enable",
            "HW test counter 9. Should be equal to 1 in query.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x46010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0802000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18020033, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0801000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16010dc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02014000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00100082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x001000c2, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00100001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeOverviewMetricSet::CComputeOverviewMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeOverviewMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BYTE_READ", "L3 Byte Read",
            "Number of bytes read from L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "L3_BYTE_WRITE", "L3 Byte Write",
            "Number of bytes written to L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XVE_ATOMIC_ACCESS_COUNT", "XVE Atomic Access Count",
            "Number of shader atomic memory accesses",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_BARRIER_MESSAGE_COUNT", "XVE Barrier Message Count",
            "Number of shader barrier messages",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL", "XVE Inst Executed XMX All",
            "Number of execution slots taken by instructions executed in XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL", "XVE Inst Executed Send All",
            "Number of instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL", "XVE Inst Executed Control All",
            "Number of instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE", "XVE Pipe ALU0 And ALU1 Active",
            "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_XMX_ACTIVE", "XVE Pipe ALU0 And XMX Active",
            "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION", "XVE Inst Executed Send All Utilization",
            "Percentage of time taken by instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION", "XVE Inst Executed Control All Utilization",
            "Percentage of time taken by instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION", "XVE Inst Executed XMX All Utilization",
            "Percentage of execution slots taken by instructions executed in XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06016000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06416000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06816000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e410005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00009001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x02001002, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x0000a003, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportReadsMetricSet::CDataportReadsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportReadsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ", "Dataport Byte Read",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 2 UMUL dw@0xc0 dw@0xc4 UADD dw@0xc8 UADD dw@0xcc UADD dw@0xd0 UADD dw@0xd4 UADD dw@0xd8 UADD dw@0xdc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 2 UMUL qw@0x140 qw@0x148 UADD qw@0x150 UADD qw@0x158 UADD qw@0x160 UADD qw@0x168 UADD qw@0x170 UADD qw@0x178 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06022e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1002001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1402001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080205c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020018, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1202001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ccccc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ecccc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000da0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020da0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206a0a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001afaf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201afaf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010601, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010220, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportWritesMetricSet::CDataportWritesMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportWritesMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SAMPLER_L3_READ", "Sampler L3 Read",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0 dw@0xe4 UADD dw@0xe8 UADD dw@0xec UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180 qw@0x188 UADD qw@0x190 UADD qw@0x198 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "4 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SAMPLER_L3_BYTE_READ", "Sampler L3 Byte Read",
            "Number of L3 read bytes resulting from Sampler local cache miss",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0 dw@0xe4 UADD dw@0xe8 UADD dw@0xec UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180 qw@0x188 UADD qw@0x190 UADD qw@0x198 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 4 UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE", "Dataport Byte Write",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "32 dw@0xf0 dw@0xf4 UADD dw@0xf8 UADD dw@0xfc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "32 qw@0x1a0 qw@0x1a8 UADD qw@0x1b0 UADD qw@0x1b8 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c026800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c026800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c026800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020880, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c026800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16020022, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02044000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e810006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00120200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213a0ae, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145061, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021550c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ccf00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ecf00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020da000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206a0aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201afaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010e07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet::CL1ProfileSlmBankConflictsMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xdc 2 dw@0xd8 UMUL UADD 4 dw@0xd4 UMUL UADD 8 dw@0xd0 UMUL UADD UADD dw@0xcc 2 dw@0xc8 UMUL UADD 4 dw@0xc4 UMUL UADD 8 dw@0xc0 UMUL UADD UADD 2 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x178 2 qw@0x170 UMUL UADD 4 qw@0x168 UMUL UADD 8 qw@0x160 UMUL UADD UADD qw@0x158 2 qw@0x150 UMUL UADD 4 qw@0x148 UMUL UADD 8 qw@0x140 UMUL UADD UADD 2 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x260814c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080baf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c0800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06081000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c0800a6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06081000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080c31, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080fbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x260814c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080032, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080821, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080baf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c00ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e00ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60011203, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CLoadStoreCacheProfileMetricSet_XeCore0::CLoadStoreCacheProfileMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CLoadStoreCacheProfileMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1208030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CLoadStoreCacheProfileMetricSet_XeCore3::CLoadStoreCacheProfileMetricSet_XeCore3( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CLoadStoreCacheProfileMetricSet_XeCore3::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080085, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1208030d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408028b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000efffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSLMProfileMetricSet_XeCore0::CSLMProfileMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSLMProfileMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore0 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x180802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120802cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160801c8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CSLMProfileMetricSet_XeCore3::CSLMProfileMetricSet_XeCore3( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CSLMProfileMetricSet_XeCore3::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "2 $XeCoreTotalCount UMUL dw@0xe0 2 dw@0xdc UMUL UADD 4 dw@0xd8 UMUL UADD 8 dw@0xd4 UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xcc UMUL UADD 64 dw@0xc8 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "2 $XeCoreTotalCount UMUL qw@0x180 2 qw@0x178 UMUL UADD 4 qw@0x170 UMUL UADD 8 qw@0x168 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x158 UMUL UADD 64 qw@0x150 UMUL UADD UMUL $GtSlice0XeCore3 UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $SliceTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x180802b4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080146, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120802cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1408024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160801c8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cfffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000efffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt1MetricSet::CExt1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI0", "GPU Memory Byte Write Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_SQIDI1", "GPU Memory Byte Write Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE_SQIDI0", "GPU Memory Write Sqidi0",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE_SQIDI1", "GPU Memory Write Sqidi1",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_WRITE", "GPU Memory Write",
            "Number of GTI memory writes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_WRITE_SQIDI0 $$GPU_MEMORY_WRITE_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_READ_SQIDI0", "GPU Memory Read Sqidi0",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_READ_SQIDI1", "GPU Memory Read Sqidi1",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_READ", "GPU Memory Read",
            "Number of GTI memory reads",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_READ_SQIDI0 $$GPU_MEMORY_READ_SQIDI1 UADD" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI0", "GPU Memory Byte Read Sqidi0",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_SQIDI1", "GPU Memory Byte Read Sqidi1",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_ACTIVE_SQIDI0", "GPU Memory Active Sqidi0",
            "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_ACTIVE_SQIDI1", "GPU Memory Active Sqidi1",
            "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_BW_SQIDI0", "GPU Memory Byte Read Bw Sqidi0",
            "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_READ_SQIDI0 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ_BW_SQIDI1", "GPU Memory Byte Read Bw Sqidi1",
            "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_READ_SQIDI1 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0", "GPU Memory Byte Write Bw Sqidi0",
            "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_WRITE_SQIDI0 $$GpuTime FDIV" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1", "GPU Memory Byte Write Bw Sqidi1",
            "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_FLOAT, "GBpS", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$$GPU_MEMORY_BYTE_WRITE_SQIDI1 $$GpuTime FDIV" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c070007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00065500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02065555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04070076, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c070180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e070380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12070147, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140703c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16070340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08070000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00071100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02071105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080076, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a08000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080147, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1008000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1208000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt4MetricSet::CExt4MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt4MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_READ_L3BANK0", "L3 Read L3bank0",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK1", "L3 Read L3bank1",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK2", "L3 Read L3bank2",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_READ_L3BANK3", "L3 Read L3bank3",
            "Number of L3 read requests",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK0", "L3 Write L3bank0",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK1", "L3 Write L3bank1",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK2", "L3 Write L3bank2",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_WRITE_L3BANK3", "L3 Write L3bank3",
            "Number of L3 write requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06016000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06416000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06816000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c16000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e810005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec10140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baae, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144961, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021583c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt5MetricSet::CExt5MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt5MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK0", "Dataport L3 Read L3bank0",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK1", "Dataport L3 Read L3bank1",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK2", "Dataport L3 Read L3bank2",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_READ_L3BANK3", "Dataport L3 Read L3bank3",
            "Number of L3 read requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK0", "Dataport L3 Write L3bank0",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK1", "Dataport L3 Write L3bank1",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK2", "Dataport L3 Write L3bank2",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_WRITE_L3BANK3", "Dataport L3 Write L3bank3",
            "Number of L3 write requests coming from XVE via Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK0", "L3 Hit L3bank0",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK1", "L3 Hit L3bank1",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK2", "L3 Hit L3bank2",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_HIT_L3BANK3", "L3 Hit L3bank3",
            "Number of L3 accesses which hits in the L3 cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c8122c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc1200b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0102c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a410001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e41000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124440, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013ba00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00144900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00158300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cfff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000efff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2220, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt7MetricSet::CExt7MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt7MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK0", "Sampler L3 Read L3bank0",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK1", "Sampler L3 Read L3bank1",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK2", "Sampler L3 Read L3bank2",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_READ_L3BANK3", "Sampler L3 Read L3bank3",
            "Number of L3 read requests resulting from Sampler local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK0", "Sampler L3 Hit L3bank0",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK1", "Sampler L3 Hit L3bank1",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK2", "Sampler L3 Hit L3bank2",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_L3_HIT_L3BANK3", "Sampler L3 Hit L3bank3",
            "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE0", "Sampler Busy Xecore0",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE1", "Sampler Busy Xecore1",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE2", "Sampler Busy Xecore2",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "SAMPLER_BUSY_XECORE3", "Sampler Busy Xecore3",
            "Percentage of time in which Sampler pipeline active",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c030034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c030d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030034, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040060, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18030004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e030d00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08010006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08410180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12410008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a810006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac10180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013ae00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00146100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144950, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0015c200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158350, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cfcf0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000efcf0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001a0800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010e07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010227, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010e07, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010070, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt8MetricSet::CExt8MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt8MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK0", "ICache L3 Read L3bank0",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK1", "ICache L3 Read L3bank1",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK2", "ICache L3 Read L3bank2",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_READ_L3BANK3", "ICache L3 Read L3bank3",
            "Number of L3 read requests coming from XVE Instruction Cache",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK0", "ICache L3 Hit L3bank0",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK1", "ICache L3 Hit L3bank1",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK2", "ICache L3 Hit L3bank2",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "ICACHE_L3_HIT_L3BANK3", "ICache L3 Hit L3bank3",
            "Number of XVE instruction cache requests that hit the L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e410002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x108103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt10MetricSet::CExt10MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt10MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK0", "Dataport L3 Hit L3bank0",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK1", "Dataport L3 Hit L3bank1",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK2", "Dataport L3 Hit L3bank2",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_L3_HIT_L3BANK3", "Dataport L3 Hit L3bank3",
            "Number of L3 hits for requests coming from the Dataport",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK0", "Color L3 Hit L3bank0",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK1", "Color L3 Hit L3bank1",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK2", "Color L3 Hit L3bank2",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_HIT_L3BANK3", "Color L3 Hit L3bank3",
            "Number of L3 read requests resulting from color local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK0", "Z L3 Access L3bank0",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK1", "Z L3 Access L3bank1",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK2", "Z L3 Access L3bank2",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_ACCESS_L3BANK3", "Z L3 Access L3bank3",
            "Number of L3 read requests resulting from Z local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04012000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04412000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04812000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c12000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc1000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a410007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e41000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12410008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x088101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124440, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013ba00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00144900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00158300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cfff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000efff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2220, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt11MetricSet::CExt11MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt11MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK0", "Z L3 Hit L3bank0",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK1", "Z L3 Hit L3bank1",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK2", "Z L3 Hit L3bank2",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Z_L3_HIT_L3BANK3", "Z L3 Hit L3bank3",
            "Number of L3 read requests resulting from Z local cache miss which hits in L3",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK0", "L3 Atomic Access L3bank0",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK1", "L3 Atomic Access L3bank1",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK2", "L3 Atomic Access L3bank2",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "L3_ATOMIC_ACCESS_L3BANK3", "L3 Atomic Access L3bank3",
            "Number of atomic accesses to L3 Bank",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt12MetricSet::CExt12MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt12MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK0", "L3 Input Available L3bank0",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK1", "L3 Input Available L3bank1",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK2", "L3 Input Available L3bank2",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_INPUT_AVAILABLE_L3BANK3", "L3 Input Available L3bank3",
            "Percentage of time in which L3 Bank has input requests",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK0", "L3 Output Ready L3bank0",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK1", "L3 Output Ready L3bank1",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK2", "L3 Output Ready L3bank2",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_OUTPUT_READY_L3BANK3", "L3 Output Ready L3bank3",
            "Percentage of time in which L3 Bank has output ready",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e010180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12410007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x108101c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c10007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baba, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144949, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158383, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt13MetricSet::CExt13MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt13MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK0", "L3 Superq Full L3bank0",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK1", "L3 Superq Full L3bank1",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK2", "L3 Superq Full L3bank2",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_SUPERQ_FULL_L3BANK3", "L3 Superq Full L3bank3",
            "Percentage of time in which all slots in L3 request queue are waiting for data return / response",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK0", "Color L3 Access L3bank0",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK1", "Color L3 Access L3bank1",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK2", "Color L3 Access L3bank2",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "COLOR_L3_ACCESS_L3BANK3", "Color L3 Access L3bank3",
            "Number of L3 request resulting from color local cache miss",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04013183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c011000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04413000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04813000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c13000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06410183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1241000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08810183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x108103c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac10183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c1000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0012400c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aafa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213ba00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145a05, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144900, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0015f00a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02158300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cf0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000ef0ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001a00a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b2030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aa00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000060, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000600, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt14MetricSet::CExt14MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt14MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BUSY_L3BANK0", "L3 Busy L3bank0",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK1", "L3 Busy L3bank1",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK2", "L3 Busy L3bank2",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_BUSY_L3BANK3", "L3 Busy L3bank3",
            "Percentage of time in which L3 request queue has one or more requests pending",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK0", "L3 Stall L3bank0",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK1", "L3 Stall L3bank1",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK2", "L3 Stall L3bank2",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "L3_STALL_L3BANK3", "L3 Stall L3bank3",
            "Percentage of time in which L3 Bank Stalled",
            "GTI/L3", ( METRIC_GROUP_NAME_ID_GTI * 0x1000000 ) | ( METRIC_GROUP_NAME_ID_L3 * 0x10000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_SUBSLICE_BANK, "$GtSliceMask 3 0 2 UMUL << AND", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04011042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04411000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06410080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04811000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00010010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00410010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08410001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12410008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00810010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a810042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10810200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02810000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c10008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00124038, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013afea, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213baaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0014a015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02144956, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0015002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021583fc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000effff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001a0a80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021a2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b21c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000038, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x000001c0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000e00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00007000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt17MetricSet::CExt17MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt17MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0", "Load Store Cache Input Available Xecore0",
            "Percentage of time in which the Load Store Cache has input available",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1", "Load Store Cache Input Available Xecore1",
            "Percentage of time in which the Load Store Cache has input available",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2", "Load Store Cache Input Available Xecore2",
            "Percentage of time in which the Load Store Cache has input available",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3", "Load Store Cache Input Available Xecore3",
            "Percentage of time in which the Load Store Cache has input available",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_OUTPUT_READY_XECORE0", "Load Store Cache Output Ready Xecore0",
            "Percentage of time in which the Load Store Cache has output ready",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc dw@0xd8 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 qw@0x170 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_OUTPUT_READY_XECORE1", "Load Store Cache Output Ready Xecore1",
            "Percentage of time in which the Load Store Cache has output ready",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4 dw@0xd0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168 qw@0x160 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_OUTPUT_READY_XECORE2", "Load Store Cache Output Ready Xecore2",
            "Percentage of time in which the Load Store Cache has output ready",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_OUTPUT_READY_XECORE3", "Load Store Cache Output Ready Xecore3",
            "Percentage of time in which the Load Store Cache has output ready",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4 dw@0xc0 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148 qw@0x140 FADD 2 FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808005e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080830, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080b7d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808005e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080830, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080b7d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808005e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080830, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080b7d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808005e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080830, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080b7d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010229, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt21MetricSet::CExt21MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt21MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_ACCESS_XECORE0", "Load Store Cache Access Xecore0",
            "Number of Load Store Cache accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_ACCESS_XECORE1", "Load Store Cache Access Xecore1",
            "Number of Load Store Cache accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_ACCESS_XECORE2", "Load Store Cache Access Xecore2",
            "Number of Load Store Cache accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_ACCESS_XECORE3", "Load Store Cache Access Xecore3",
            "Number of Load Store Cache accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_READ_XECORE0", "Load Store Cache L3 Read Xecore0",
            "Number of cacheline read requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc dw@0xd8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 qw@0x170 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_READ_XECORE1", "Load Store Cache L3 Read Xecore1",
            "Number of cacheline read requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4 dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168 qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_READ_XECORE2", "Load Store Cache L3 Read Xecore2",
            "Number of cacheline read requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_READ_XECORE3", "Load Store Cache L3 Read Xecore3",
            "Number of cacheline read requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4 dw@0xc0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148 qw@0x140 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c081800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080493, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c081800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080493, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c081800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080493, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c081800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080493, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010229, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt23MetricSet::CExt23MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt23MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_HIT_XECORE0", "Load Store Cache Hit Xecore0",
            "Number of Load Store Cache hits",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_HIT_XECORE1", "Load Store Cache Hit Xecore1",
            "Number of Load Store Cache hits",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_HIT_XECORE2", "Load Store Cache Hit Xecore2",
            "Number of Load Store Cache hits",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_HIT_XECORE3", "Load Store Cache Hit Xecore3",
            "Number of Load Store Cache hits",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080800c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0802ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0800c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0802ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100800c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x120802ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140800c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160802ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000018, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000060, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000180, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000600, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00001800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00006000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00018000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00060000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt28MetricSet::CExt28MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt28MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_WRITE_XECORE0", "Load Store Cache L3 Write Xecore0",
            "Number of cacheline write requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_WRITE_XECORE1", "Load Store Cache L3 Write Xecore1",
            "Number of cacheline write requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_WRITE_XECORE2", "Load Store Cache L3 Write Xecore2",
            "Number of cacheline write requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_L3_WRITE_XECORE3", "Load Store Cache L3 Write Xecore3",
            "Number of cacheline write requests from the Load Store Cache to L3",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0", "Load Store Cache Partial Write Count Xecore0",
            "Number of writes to the Load Store Cache that don't fill a subsector",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc dw@0xd8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 qw@0x170 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1", "Load Store Cache Partial Write Count Xecore1",
            "Number of writes to the Load Store Cache that don't fill a subsector",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4 dw@0xd0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168 qw@0x160 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2", "Load Store Cache Partial Write Count Xecore2",
            "Number of writes to the Load Store Cache that don't fill a subsector",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc dw@0xc8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158 qw@0x150 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3", "Load Store Cache Partial Write Count Xecore3",
            "Number of writes to the Load Store Cache that don't fill a subsector",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4 dw@0xc0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148 qw@0x140 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080304, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080515, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080304, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080515, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080304, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080515, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18080003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c080c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2408001f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04080808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080304, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080515, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0f0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010211, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010229, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt31MetricSet::CExt31MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt31MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0", "XVE Load Store Cache Read Message Count Xecore0",
            "Number of read messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1", "XVE Load Store Cache Read Message Count Xecore1",
            "Number of read messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2", "XVE Load Store Cache Read Message Count Xecore2",
            "Number of read messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3", "XVE Load Store Cache Read Message Count Xecore3",
            "Number of read messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt35MetricSet::CExt35MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt35MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0", "XVE Load Store Cache Write Message Count Xecore0",
            "Number of write messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1", "XVE Load Store Cache Write Message Count Xecore1",
            "Number of write messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2", "XVE Load Store Cache Write Message Count Xecore2",
            "Number of write messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3", "XVE Load Store Cache Write Message Count Xecore3",
            "Number of write messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt39MetricSet::CExt39MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt39MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0", "XVE Load Store Cache Fence Message Count Xecore0",
            "Number of fence messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1", "XVE Load Store Cache Fence Message Count Xecore1",
            "Number of fence messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2", "XVE Load Store Cache Fence Message Count Xecore2",
            "Number of fence messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3", "XVE Load Store Cache Fence Message Count Xecore3",
            "Number of fence messages sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt43MetricSet::CExt43MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt43MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0", "XVE Load Store Cache Atomic Message Count Xecore0",
            "Number of atomic operations sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1", "XVE Load Store Cache Atomic Message Count Xecore1",
            "Number of atomic operations sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0", "XVE Load Store Cache Register Request Count Xecore0",
            "Number of message payload transactions sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1", "XVE Load Store Cache Register Request Count Xecore1",
            "Number of message payload transactions sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080a79, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080a79, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0060001c, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x030000c4, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x18000604, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0xc0003004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt45MetricSet::CExt45MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt45MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2", "XVE Load Store Cache Atomic Message Count Xecore2",
            "Number of atomic operations sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3", "XVE Load Store Cache Atomic Message Count Xecore3",
            "Number of atomic operations sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2", "XVE Load Store Cache Register Request Count Xecore2",
            "Number of message payload transactions sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3", "XVE Load Store Cache Register Request Count Xecore3",
            "Number of message payload transactions sent by XVEs to the Load Store Cache",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080a79, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080a79, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000effff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0060001c, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x030000c4, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x18000604, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0xc0003004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt51MetricSet::CExt51MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt51MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0", "XVE Load Store Cache Register Response Count Xecore0",
            "Number of message payload transactions sent from the Load Store Cache back to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc dw@0xf8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8 qw@0x1b0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1", "XVE Load Store Cache Register Response Count Xecore1",
            "Number of message payload transactions sent from the Load Store Cache back to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4 dw@0xf0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8 qw@0x1a0 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2", "XVE Load Store Cache Register Response Count Xecore2",
            "Number of message payload transactions sent from the Load Store Cache back to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec dw@0xe8 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198 qw@0x190 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3", "XVE Load Store Cache Register Response Count Xecore3",
            "Number of message payload transactions sent from the Load Store Cache back to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4 dw@0xe0 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188 qw@0x180 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808001d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080975, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808001d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080975, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808001d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080975, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2808001d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c087400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202000f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080975, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0f00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010229, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt53MetricSet::CExt53MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt53MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_SLM_READ_MESSAGE_COUNT_XECORE0", "XVE SLM Read Message Count Xecore0",
            "Number of SLM read messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_READ_MESSAGE_COUNT_XECORE1", "XVE SLM Read Message Count Xecore1",
            "Number of SLM read messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_READ_MESSAGE_COUNT_XECORE2", "XVE SLM Read Message Count Xecore2",
            "Number of SLM read messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_READ_MESSAGE_COUNT_XECORE3", "XVE SLM Read Message Count Xecore3",
            "Number of SLM read messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080c34, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000001a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000062, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000182, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000602, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00001802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00006002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00018002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00060002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt57MetricSet::CExt57MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt57MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0", "XVE SLM Write Message Count Xecore0",
            "Number of SLM write messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1", "XVE SLM Write Message Count Xecore1",
            "Number of SLM write messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2", "XVE SLM Write Message Count Xecore2",
            "Number of SLM write messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3", "XVE SLM Write Message Count Xecore3",
            "Number of SLM write messages sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06080204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080823, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080c33, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000001a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000062, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000182, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000602, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00001802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00006002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00018002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00060002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt61MetricSet::CExt61MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt61MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0", "XVE SLM Fence Message Count Xecore0",
            "Number of SLM fence operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1", "XVE SLM Fence Message Count Xecore1",
            "Number of SLM fence operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2", "XVE SLM Fence Message Count Xecore2",
            "Number of SLM fence operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3", "XVE SLM Fence Message Count Xecore3",
            "Number of SLM fence operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 dw@0xdc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 qw@0x178 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14080a27, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16080e37, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000001a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000062, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000182, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000602, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00001802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00006002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00018002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00060002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt65MetricSet::CExt65MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt65MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0", "XVE SLM Atomic Message Count Xecore0",
            "Number of SLM atomic operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1", "XVE SLM Atomic Message Count Xecore1",
            "Number of SLM atomic operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000021, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000101, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000801, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00004001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt66MetricSet::CExt66MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt66MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2", "XVE SLM Atomic Message Count Xecore2",
            "Number of SLM atomic operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3", "XVE SLM Atomic Message Count Xecore3",
            "Number of SLM atomic operations sent by XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8 dw@0xcc UADD" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150 qw@0x158 UADD" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020800ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28080001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c080400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002f000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06083254, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0808a3, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10080ce8, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12080e32, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021300aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021700aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c0fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e0fff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d00aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020600aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020100aa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000021, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff8, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000101, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffc7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000801, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000fe3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00004001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000f1ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt73MetricSet::CExt73MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt73MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_INPUT_AVAILABLE_XECORE0", "Dataport Input Available Xecore0",
            "Percentage of time in which XVEs have requests to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DATAPORT_INPUT_AVAILABLE_XECORE1", "Dataport Input Available Xecore1",
            "Percentage of time in which XVEs have requests to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602e6c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080201c6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020048, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0200c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602e6c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100201c6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020048, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140200c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ff00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x000000ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt74MetricSet::CExt74MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt74MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_INPUT_AVAILABLE_XECORE2", "Dataport Input Available Xecore2",
            "Percentage of time in which XVEs have requests to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DATAPORT_INPUT_AVAILABLE_XECORE3", "Dataport Input Available Xecore3",
            "Percentage of time in which XVEs have requests to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602e6c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080201c6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020048, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c0200c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602e6c4, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100201c6, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020048, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x140200c2, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000effff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x30800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ff00, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x000000ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt77MetricSet::CExt77MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt77MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_OUTPUT_READY_XECORE0", "Dataport Output Ready Xecore0",
            "Percentage of time in which the Dataport has data to return to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DATAPORT_OUTPUT_READY_XECORE1", "Dataport Output Ready Xecore1",
            "Percentage of time in which the Dataport has data to return to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DATAPORT_OUTPUT_READY_XECORE2", "Dataport Output Ready Xecore2",
            "Percentage of time in which the Dataport has data to return to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "DATAPORT_OUTPUT_READY_XECORE3", "Dataport Output Ready Xecore3",
            "Percentage of time in which the Dataport has data to return to XVEs",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "GpuDuration" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06022000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020491, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0002ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0008ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02c491, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020491, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02c000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020491, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16020013, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000eff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010221, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c011209, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010090, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010609, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000078, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fff0, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000780, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ff0f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00007800, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000f0ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00078000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x00000fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt79MetricSet::CExt79MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt79MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE0", "Dataport Byte Read Xecore0",
            "Number of bytes read through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD dw@0xc8 UADD dw@0xcc UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD qw@0x150 UADD qw@0x158 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE1", "Dataport Byte Read Xecore1",
            "Number of bytes read through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD dw@0xd8 UADD dw@0xdc UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD qw@0x170 UADD qw@0x178 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a51a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b01b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06022e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020598, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020559, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b5c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020598, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020559, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1402051a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt80MetricSet::CExt80MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt80MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE2", "Dataport Byte Read Xecore2",
            "Number of bytes read through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 dw@0xc4 UADD dw@0xc8 UADD dw@0xcc UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 qw@0x148 UADD qw@0x150 UADD qw@0x158 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE3", "Dataport Byte Read Xecore3",
            "Number of bytes read through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0 dw@0xd4 UADD dw@0xd8 UADD dw@0xdc UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160 qw@0x168 UADD qw@0x170 UADD qw@0x178 UADD 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a51a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b01b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06022e00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08020598, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a020559, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0202ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0208ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e02b5c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020b00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020598, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020559, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1402051a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602001b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0213aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02145555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02155555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02165555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0217aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000cffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000effff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020daaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0006aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0206aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0001aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x58010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5a010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5c010603, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x5e010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x0000000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000fffc, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000022, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000fff3, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00000202, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000ff3f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00000802, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000fcff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00002002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000f3ff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x00008002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000cfff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00020002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x00003fff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt83MetricSet::CExt83MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt83MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE0", "Dataport Byte Write Xecore0",
            "Number of bytes written through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE1", "Dataport Byte Write Xecore1",
            "Number of bytes written through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE2", "Dataport Byte Write Xecore2",
            "Number of bytes written through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE3", "Dataport Byte Write Xecore3",
            "Number of bytes written through the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "32 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0", "Dataport Texture Cache Access Xecore0",
            "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1", "Dataport Texture Cache Access Xecore1",
            "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2", "Dataport Texture Cache Access Xecore2",
            "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3", "Dataport Texture Cache Access Xecore3",
            "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e02001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020021, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1602002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02023030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02083030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e02001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020a80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02041010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e02001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10020021, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1402002a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020303, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080303, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c020400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e02001a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e020840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12020a80, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160505, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02170a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c3300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e3300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020d0a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02060a0a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0201fafa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x60010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x62010030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4e010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x50010229, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x52010000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x54011203, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x56010011, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x74010002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CExt85MetricSet::CExt85MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CExt85MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0", "XVE Dataport Read Message Count Xecore0",
            "Number of read messages sent by XVEs to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1", "XVE Dataport Read Message Count Xecore1",
            "Number of read messages sent by XVEs to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2", "XVE Dataport Read Message Count Xecore2",
            "Number of read messages sent by XVEs to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3", "XVE Dataport Read Message Count Xecore3",
            "Number of read messages sent by XVEs to the Dataport",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_HIT_XECORE0", "Dataport Texture Cache Hit Xecore0",
            "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore0", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_HIT_XECORE1", "Dataport Texture Cache Hit Xecore1",
            "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore1", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_HIT_XECORE2", "Dataport Texture Cache Hit Xecore2",
            "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore2", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_TEXTURE_CACHE_HIT_XECORE3", "Dataport Texture Cache Hit Xecore3",
            "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_DUALSUBSLICE, "$GtSlice0XeCore3", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1802016a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0203e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402202c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06020a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080202c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16020020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020fc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02023000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080fc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02083000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1802016a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0203e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402202c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a0201c5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c02000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00040540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02041000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1802016a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0203e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402202c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c020140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0202c7, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14020020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020203fc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00045000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020803fc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1802016a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0203e0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0402202c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x100201c5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1202080b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02020000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02040154, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0013a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00145000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02140555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00155000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02150555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00165000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02160555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0017a000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02170aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000c3fc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000e3fc0, REGISTER_TYPE_NOA ) );
        MD_CHE