/**************************************************************************
    Lightspark, a free flash player implementation

    Copyright (C) 2013  Alessandro Pignotti (a.pignotti@sssup.it)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
**************************************************************************/

/* This file is generated by errorgen - DO NOT EDIT */

#include <initializer_list>
#include "errorconstants.h"
#include "compat.h"

namespace lightspark
{

const std::map<int, const char *> errorMessages = {
	{kOutOfMemoryError, "The system is out of memory."},
	{kNotImplementedError, "The method %1 is not implemented."},
	{kInvalidPrecisionError, "Number.toPrecision has a range of 1 to 21. Number.toFixed and Number.toExponential have a range of 0 to 20. Specified value is not within expected range."},
	{kInvalidRadixError, "The radix argument must be between 2 and 36; got %1."},
	{kInvokeOnIncompatibleObjectError, "Method %1 was invoked on an incompatible object."},
	{kArrayIndexNotIntegerError, "Array index is not a positive integer (%1)."},
	{kCallOfNonFunctionError, "%1 is not a function."},
	{kConstructOfNonFunctionError, "Instantiation attempted on a non-constructor."},
	{kAmbiguousBindingError, "%1 is ambiguous; Found more than one matching binding."},
	{kConvertNullToObjectError, "Cannot access a property or method of a null object reference."},
	{kConvertUndefinedToObjectError, "A term is undefined and has no properties."},
	{kIllegalOpcodeError, "Method %1 contained illegal opcode %2 at offset %3."},
	{kLastInstExceedsCodeSizeError, "The last instruction exceeded code size."},
	{kFindVarWithNoScopeError, "Cannot call OP_findproperty when scopeDepth is 0."},
	{kClassNotFoundError, "Class %1 could not be found."},
	{kIllegalSetDxns, "Method %1 cannot set default xml namespace"},
	{kDescendentsError, "Descendants operator (..) not supported on type %1."},
	{kScopeStackOverflowError, "Scope stack overflow occurred."},
	{kScopeStackUnderflowError, "Scope stack underflow occurred."},
	{kGetScopeObjectBoundsError, "Getscopeobject %1 is out of bounds."},
	{kCannotFallOffMethodError, "Code cannot fall off the end of a method."},
	{kInvalidBranchTargetError, "At least one branch target was not on a valid instruction in the method."},
	{kIllegalVoidError, "Type void may only be used as a function return type."},
	{kStackOverflowError, "Stack overflow occurred."},
	{kStackUnderflowError, "Stack underflow occurred."},
	{kInvalidRegisterError, "An invalid register %1 was accessed."},
	{kSlotExceedsCountError, "Slot %1 exceeds slotCount=%2 of %3."},
	{kMethodInfoExceedsCountError, "Method_info %1 exceeds method_count=%2."},
	{kDispIdExceedsCountError, "Disp_id %1 exceeds max_disp_id=%2 of %3."},
	{kDispIdUndefinedError, "Disp_id %1 is undefined on %2."},
	{kStackDepthUnbalancedError, "Stack depth is unbalanced. %1 != %2."},
	{kScopeDepthUnbalancedError, "Scope depth is unbalanced. %1 != %2."},
	{kCpoolIndexRangeError, "Cpool index %1 is out of range %2."},
	{kCpoolEntryWrongTypeError, "Cpool entry %1 is wrong type."},
	{kCheckTypeFailedError, "Type Coercion failed: cannot convert %1 to %2."},
	{kIllegalSuperCallError, "Illegal super expression found in method %1."},
	{kCannotAssignToMethodError, "Cannot assign to a method %1 on %2."},
	{kRedefinedError, "%1 is already defined."},
	{kCannotVerifyUntilReferencedError, "Cannot verify method until it is referenced."},
	{kCantUseInstanceofOnNonObjectError, "The right-hand side of instanceof must be a class or function."},
	{kIsTypeMustBeClassError, "The right-hand side of operator must be a class."},
	{kInvalidMagicError, "Not an ABC file.  major_version=%1 minor_version=%2."},
	{kInvalidCodeLengthError, "Invalid code_length=%1."},
	{kInvalidMethodInfoFlagsError, "MethodInfo-%1 unsupported flags=%2."},
	{kUnsupportedTraitsKindError, "Unsupported traits kind=%1."},
	{kMethodInfoOrderError, "MethodInfo-%1 referenced before definition."},
	{kMissingEntryPointError, "No entry point was found."},
	{kPrototypeTypeError, "Prototype objects must be vanilla Objects."},
	{kConvertToPrimitiveError, "Cannot convert %1 to primitive."},
	{kIllegalEarlyBindingError, "Illegal early binding access to %1."},
	{kInvalidURIError, "Invalid URI passed to %1 function."},
	{kIllegalOverrideError, "Illegal override of %1 in %2."},
	{kIllegalExceptionHandlerError, "Illegal range or target offsets in exception handler."},
	{kWriteSealedError, "Cannot create property %1 on %2."},
	{kIllegalSlotError, "%1 can only contain methods."},
	{kIllegalOperandTypeError, "Illegal operand type: %1 must be %2."},
	{kClassInfoOrderError, "ClassInfo-%1 is referenced before definition."},
	{kClassInfoExceedsCountError, "ClassInfo %1 exceeds class_count=%2."},
	{kNumberOutOfRangeError, "The value %1 cannot be converted to %2 without losing precision."},
	{kWrongArgumentCountError, "Argument count mismatch on %1. Expected %2, got %3."},
	{kCannotCallMethodAsConstructor, "Cannot call method %1 as constructor."},
	{kUndefinedVarError, "Variable %1 is not defined."},
	{kFunctionConstructorError, "The form function('function body') is not supported."},
	{kIllegalNativeMethodBodyError, "Native method %1 has illegal method body."},
	{kCannotMergeTypesError, "%1 and %2 cannot be reconciled."},
	{kReadSealedError, "Property %1 not found on %2 and there is no default value."},
	{kCallNotFoundError, "Method %1 not found on %2"},
	{kAlreadyBoundError, "Function %1 has already been bound to %2."},
	{kZeroDispIdError, "Disp_id 0 is illegal."},
	{kDuplicateDispIdError, "Non-override method %1 replaced because of duplicate disp_id %2."},
	{kConstWriteError, "Illegal write to read-only property %1 on %2."},
	{kMathNotFunctionError, "Math is not a function."},
	{kMathNotConstructorError, "Math is not a constructor."},
	{kWriteOnlyError, "Illegal read of write-only property %1 on %2."},
	{kIllegalOpMultinameError, "Illegal opcode/multiname combination: %1<%2>."},
	{kIllegalNativeMethodError, "Native methods are not allowed in loaded code."},
	{kIllegalNamespaceError, "Illegal value for namespace."},
	{kReadSealedErrorNs, "Property %1 not found on %2 and there is no default value."},
	{kNoDefaultNamespaceError, "No default namespace has been set."},
	{kXMLPrefixNotBound, "The prefix \"%1\" for element \"%2\" is not bound."},
	{kXMLBadQName, "Element or attribute (\"%1\") does not match QName production: QName::=(NCName':')?NCName."},
	{kXMLUnterminatedElementTag, "The element type \"%1\" must be terminated by the matching end-tag \"</%2>\"."},
	{kXMLOnlyWorksWithOneItemLists, "The %1 method only works on lists containing one item."},
	{kXMLAssignmentToIndexedXMLNotAllowed, "Assignment to indexed XML is not allowed."},
	{kXMLMarkupMustBeWellFormed, "The markup in the document following the root element must be well-formed."},
	{kXMLAssigmentOneItemLists, "Assignment to lists with more than one item is not supported."},
	{kXMLMalformedElement, "XML parser failure: element is malformed."},
	{kXMLUnterminatedCData, "XML parser failure: Unterminated CDATA section."},
	{kXMLUnterminatedXMLDecl, "XML parser failure: Unterminated XML declaration."},
	{kXMLUnterminatedDocTypeDecl, "XML parser failure: Unterminated DOCTYPE declaration."},
	{kXMLUnterminatedComment, "XML parser failure: Unterminated comment."},
	{kXMLUnterminatedAttribute, "XML parser failure: Unterminated attribute."},
	{kXMLUnterminatedElement, "XML parser failure: Unterminated element."},
	{kXMLUnterminatedProcessingInstruction, "XML parser failure: Unterminated processing instruction."},
	{kXMLNamespaceWithPrefixAndNoURI, "Illegal prefix %1 for no namespace."},
	{kRegExpFlagsArgumentError, "Cannot supply flags when constructing one RegExp from another."},
	{kNoScopeError, "Cannot verify method %1 with unknown scope."},
	{kIllegalDefaultValue, "Illegal default value for type %1."},
	{kCannotExtendFinalClass, "Class %1 cannot extend final base class."},
	{kXMLDuplicateAttribute, "Attribute \"%1\" was already specified for element \"%2\"."},
	{kCorruptABCError, "The ABC data is corrupt, attempt to read out of bounds."},
	{kInvalidBaseClassError, "The OP_newclass opcode was used with the incorrect base class."},
	{kDanglingFunctionError, "Attempt to directly call unbound function %1 from method %2."},
	{kCannotExtendError, "%1 cannot extend %2."},
	{kCannotImplementError, "%1 cannot implement %2."},
	{kCoerceArgumentCountError, "Argument count mismatch on class coercion.  Expected 1, got %1."},
	{kInvalidNewActivationError, "OP_newactivation used in method without NEED_ACTIVATION flag."},
	{kNoGlobalScopeError, "OP_getglobalslot or OP_setglobalslot used with no global scope."},
	{kNotConstructorError, "%1 is not a constructor."},
	{kApplyError, "second argument to Function.prototype.apply must be an array."},
	{kXMLInvalidName, "Invalid XML name: %1."},
	{kXMLIllegalCyclicalLoop, "Illegal cyclical loop between nodes."},
	{kDeleteTypeError, "Delete operator is not supported with operand of type %1."},
	{kDeleteSealedError, "Cannot delete property %1 on %2."},
	{kDuplicateMethodBodyError, "Method %1 has a duplicate method body."},
	{kIllegalInterfaceMethodBodyError, "Interface method %1 has illegal method body."},
	{kFilterError, "Filter operator not supported on type %1."},
	{kInvalidHasNextError, "OP_hasnext2 requires object and index to be distinct registers."},
	{kOutOfRangeError, "The index %1 is out of range %2."},
	{kVectorFixedError, "Cannot change the length of a fixed Vector."},
	{kTypeAppOfNonParamType, "Type application attempted on a non-parameterized type."},
	{kWrongTypeArgCountError, "Incorrect number of type parameters for %1. Expected %2, got %3."},
	{kJSONCyclicStructure, "Cyclic structure cannot be converted to JSON string."},
	{kJSONInvalidReplacer, "Replacer argument to JSON stringifier must be an array or a two parameter function."},
	{kJSONInvalidParseInput, "Invalid JSON parse input."},
	{kFileOpenError, "Error occurred opening file %1."},
	{kFileWriteError, "Error occurred writing to file %1."},
	{kScriptTimeoutError, "A script has executed for longer than the default timeout period of 15 seconds."},
	{kScriptTerminatedError, "A script failed to exit after 30 seconds and was terminated."},
	{kEndOfFileError, "End of file."},
	{kStringIndexOutOfBoundsError, "The string index %1 is out of bounds; must be in range %2 to %3."},
	{kInvalidRangeError, "The specified range is invalid."},
	{kNullArgumentError, "Argument %1 cannot be null."},
	{kInvalidArgumentError, "The value specified for argument %1 is invalid."},
	{kArrayFilterNonNullObjectError, "When the callback argument is a method of a class, the optional this argument must be null."},
	{kWorkerAlreadyStarted, "Worker is already started."},
	{kFailedWorkerCannotBeRestarted, "Starting a worker that already failed is not supported."},
	{kWorkerTerminated, "Worker has terminated.\""},
	{kMutextNotLocked, "unlock() with no preceding matching lock()."},
	{kConditionInvalidTimeout, "Invalid condition timeout value: %1."},
	{kConditionCannotNotify, "Condition cannot notify if associated mutex is not owned."},
	{kConditionCannotNotifyAll, "Condition cannot notifyAll if associated mutex is not owned."},
	{kConditionCannotWait, "Condition cannot wait if associated mutex is not owned."},
	{kConditionCannotBeInitialized, "Condition cannot be initialized."},
	{kMutexCannotBeInitialized, "Mutex cannot be initialized."},
	{kWorkerIllegalCallToStart, "Only the worker's parent may call start."},
	{kInvalidSocket, "Operation attempted on invalid socket."},
	{kInvalidParamError, "One of the parameters is invalid."},
	{kParamRangeError, "The supplied index is out of bounds."},
	{kNullPointerError, "Parameter %1 must be non-null."},
	{kInvalidEnumError, "Parameter %1 must be one of the accepted values."},
	{kCantInstantiateError, "%1 class cannot be instantiated."},
	{kInvalidBitmapData, "Invalid BitmapData."},
	{kParamRangeNonNegativeError, "Parameter %1 must be a non-negative number; got %2."},
	{kEOFError, "End of file was encountered."},
	{kCompressedDataError, "There was an error decompressing the data."},
	{kEmptyStringError, "Parameter %1 must be non-empty string."},
	{kProxyGetPropertyError, "The Proxy class does not implement getProperty. It must be overridden by a subclass."},
	{kProxySetPropertyError, "The Proxy class does not implement setProperty. It must be overridden by a subclass."},
	{kProxyCallPropertyError, "The Proxy class does not implement callProperty. It must be overridden by a subclass."},
	{kProxyHasPropertyError, "The Proxy class does not implement hasProperty. It must be overridden by a subclass."},
	{kProxyDeletePropertyError, "The Proxy class does not implement deleteProperty. It must be overridden by a subclass."},
	{kProxyGetDescendantsError, "The Proxy class does not implement getDescendants. It must be overridden by a subclass."},
	{kProxyNextNameIndexError, "The Proxy class does not implement nextNameIndex. It must be overridden by a subclass."},
	{kProxyNextNameError, "The Proxy class does not implement nextName. It must be overridden by a subclass."},
	{kProxyNextValueError, "The Proxy class does not implement nextValue. It must be overridden by a subclass."},
	{kInvalidArrayLengthError, "The value %1 is not a valid Array length."},
	{kReadExternalNotImplementedError, "Unable to read object in stream.  The class %1 does not implement flash.utils.IExternalizable but is aliased to an externalizable class."},
	};

};
