This external plugin helps you push numbers from your logs as [SPM](http://sematext.com/spm/) Custom Metrics:
https://sematext.atlassian.net/wiki/display/PUBSPM/Custom+Metrics

The point would be graph and alert on those metrics. For example: https://apps.sematext.com/spm-reports/s/wnsdoAstHj

###Howto

First and foremost, you need to edit the script and fill in the token of your SPM app in the **spmToken** variable. You can use the template to define a JSON, and in that JSON you'd put whatever metrics you want to send.

For example, if you want to push the number of submitted messages going through rsyslog, as generated by [impstats](https://www.rsyslog.com/doc/master/configuration/modules/impstats.html), the template can look like this:

```
template(name="stats_spm" type="list" option.json="on") {
  constant(value="{")
  constant(value="\"name\":\"")
  property(name="$!data!name")
  constant(value="\",\"value\":")
  property(name="$!data!submitted")
  constant(value=",\"aggregation\":\"sum\"}\n")
}
```

Sticking to the impstats example, you'd also need to load the module to generate the stats in the first place:

```
module(load="impstats"
  interval="10"
  resetCounters="on"
  format="json-elasticsearch"
  ruleset="stats")
```

This will push stats in JSON format into the ruleset called **stats**. Before defining the ruleset, you'd also need to load two modules: [mmnormalize](https://www.rsyslog.com/doc/master/configuration/modules/mmnormalize.html) to parse the JSON stats and [omprog](https://www.rsyslog.com/doc/master/configuration/modules/omprog.html) to use this external plugin:

```
module(load="omprog")
module(load="mmnormalize")
```

Now the ruleset:

```
ruleset(name="stats"){
    # first, parse the JSON stats
    action(
        name="parse_rsyslog_stats"
        type="mmnormalize"
        ruleBase="/etc/rsyslog-json.rulebase" # may only contain this: rule=json,plain:%data:json%
    )

    # then, submit the relevant ones via the external plugin, using the template defined earlier
    if ($!data!submitted != "") and ($!data!name != "") then {
      action(
        name="send_to_spm"
        type="omprog"
        binary="/opt/rsyslog/rsyslog_spm_custom_metrics.py"
        template="stats_spm"
      )
    }
}
```

After restarting rsyslog, you can graph these metrics in the Custom -> Custom Metrics tab of your SPM app.

###Improvements?
Improvements to this doc and the plugin itself are very welcome. Just
send us a patch!


