//go:build linux && cgo && !agent

package cluster

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"context"
	"database/sql"
	"fmt"
	"net/http"
	"strings"

	"github.com/canonical/lxd/lxd/db/query"
	"github.com/canonical/lxd/shared/api"
)

var _ = api.ServerEnvironment{}

var nodeClusterGroupObjects = RegisterStmt(`
SELECT nodes_cluster_groups.group_id, nodes.name AS node
  FROM nodes_cluster_groups
  JOIN nodes ON nodes_cluster_groups.node_id = nodes.id
  ORDER BY nodes_cluster_groups.group_id
`)

var nodeClusterGroupObjectsByGroupID = RegisterStmt(`
SELECT nodes_cluster_groups.group_id, nodes.name AS node
  FROM nodes_cluster_groups
  JOIN nodes ON nodes_cluster_groups.node_id = nodes.id
  WHERE ( nodes_cluster_groups.group_id = ? )
  ORDER BY nodes_cluster_groups.group_id
`)

var nodeClusterGroupDeleteByGroupID = RegisterStmt(`
DELETE FROM nodes_cluster_groups WHERE group_id = ?
`)

// nodeClusterGroupColumns returns a string of column names to be used with a SELECT statement for the entity.
// Use this function when building statements to retrieve database entries matching the NodeClusterGroup entity.
func nodeClusterGroupColumns() string {
	return "nodes_clusters_groups.group_id, nodes.name AS node"
}

// getNodeClusterGroups can be used to run handwritten sql.Stmts to return a slice of objects.
func getNodeClusterGroups(ctx context.Context, stmt *sql.Stmt, args ...any) ([]NodeClusterGroup, error) {
	objects := make([]NodeClusterGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		n := NodeClusterGroup{}
		err := scan(&n.GroupID, &n.Node)
		if err != nil {
			return err
		}

		objects = append(objects, n)

		return nil
	}

	err := query.SelectObjects(ctx, stmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"nodes_clusters_groups\" table: %w", err)
	}

	return objects, nil
}

// getNodeClusterGroupsRaw can be used to run handwritten query strings to return a slice of objects.
func getNodeClusterGroupsRaw(ctx context.Context, tx *sql.Tx, sql string, args ...any) ([]NodeClusterGroup, error) {
	objects := make([]NodeClusterGroup, 0)

	dest := func(scan func(dest ...any) error) error {
		n := NodeClusterGroup{}
		err := scan(&n.GroupID, &n.Node)
		if err != nil {
			return err
		}

		objects = append(objects, n)

		return nil
	}

	err := query.Scan(ctx, tx, sql, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"nodes_clusters_groups\" table: %w", err)
	}

	return objects, nil
}

// GetNodeClusterGroups returns all available node_cluster_groups.
// generator: node_cluster_group GetMany
func GetNodeClusterGroups(ctx context.Context, tx *sql.Tx, filters ...NodeClusterGroupFilter) ([]NodeClusterGroup, error) {
	var err error

	// Result slice.
	objects := make([]NodeClusterGroup, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	args := []any{}
	queryParts := [2]string{}

	if len(filters) == 0 {
		sqlStmt, err = Stmt(tx, nodeClusterGroupObjects)
		if err != nil {
			return nil, fmt.Errorf("Failed to get \"nodeClusterGroupObjects\" prepared statement: %w", err)
		}
	}

	for i, filter := range filters {
		if filter.GroupID != nil {
			args = append(args, []any{filter.GroupID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(tx, nodeClusterGroupObjectsByGroupID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"nodeClusterGroupObjectsByGroupID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(nodeClusterGroupObjectsByGroupID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"nodeClusterGroupObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.GroupID == nil {
			return nil, fmt.Errorf("Cannot filter on empty NodeClusterGroupFilter")
		} else {
			return nil, fmt.Errorf("No statement exists for the given Filter")
		}
	}

	// Select.
	if sqlStmt != nil {
		objects, err = getNodeClusterGroups(ctx, sqlStmt, args...)
	} else {
		queryStr := strings.Join(queryParts[:], "ORDER BY")
		objects, err = getNodeClusterGroupsRaw(ctx, tx, queryStr, args...)
	}

	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"nodes_clusters_groups\" table: %w", err)
	}

	return objects, nil
}

// DeleteNodeClusterGroup deletes the node_cluster_group matching the given key parameters.
// generator: node_cluster_group DeleteOne-by-GroupID
func DeleteNodeClusterGroup(ctx context.Context, tx *sql.Tx, groupID int) error {
	stmt, err := Stmt(tx, nodeClusterGroupDeleteByGroupID)
	if err != nil {
		return fmt.Errorf("Failed to get \"nodeClusterGroupDeleteByGroupID\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(groupID)
	if err != nil {
		return fmt.Errorf("Delete \"nodes_clusters_groups\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return api.StatusErrorf(http.StatusNotFound, "NodeClusterGroup not found")
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d NodeClusterGroup rows instead of 1", n)
	}

	return nil
}
