<!-- omit in toc -->
# Contributing to Fuzion

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions. 🎉

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which we would also be very happy about:
> - Star the project
> - Tweet about it
> - Refer this project in your project's readme
> - Mention the project at local meetups and tell your friends/colleagues

<!-- omit in toc -->
## Table of Contents

- [Code of Conduct](#code-of-conduct)
- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
  - [Reporting Bugs](#reporting-bugs)
  - [Suggesting Enhancements](#suggesting-enhancements)
- [Styleguides](#styleguides)
  - [Source Code](#source-code)
  - [Commit Messages](#commit-messages)
- [Join The Project Team](#join-the-project-team)


## Code of Conduct

This project and everyone participating in it is governed by the
[Fuzion Code of Conduct](https://github.com/tokiwa-software/fuzion/blob/main/CODE_OF_CONDUCT.md).
By participating, you are expected to uphold this code. Please report unacceptable behavior
to <info@tokiwa.software>.


## I Have a Question

> If you want to ask a question, we assume that you have read the available [Documentation](https://fuzion-lang.dev).

Before you ask a question, it is best to search for existing [Issues](https://github.com/tokiwa-software/fuzion/issues) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an [Issue](https://github.com/tokiwa-software/fuzion/issues/new).
- Provide as much context as you can about what you're running into.
- Provide project and platform versions (nodejs, npm, etc), depending on what seems relevant.

We will then take care of the issue as soon as possible.

<!--
You might want to create a separate issue tag for questions and include it in this description. People should then tag their issues accordingly.

Depending on how large the project is, you may want to outsource the questioning, e.g. to Stack Overflow or Gitter. You may add additional contact and information possibilities:
- IRC
- Slack
- Gitter
- Stack Overflow tag
- Blog
- FAQ
- Roadmap
- E-Mail List
- Forum
-->

## I Want To Contribute

> ### Legal Notice <!-- omit in toc -->
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the necessary rights to the content and that the content you contribute may be provided under the project license.
> A checkbox to agree to the [Tokiwa Software Fuzion Contributor Agreement](https://github.com/tokiwa-software/fuzion/blob/main/CONTRIBUTOR_LICENSE_AGREEMENT.md) will automatically be added to the text describing your pull request. You will have to accept this agreement.
> Please make sure that your identity is known to the the Fuzion team.  In case you prefer to use an anonymous account for your contribution, make sure your identity is known to the Fuzion team by sending an email to <info@tokiwa.software>.

### Reporting Bugs

<!-- omit in toc -->
#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions (Make sure that you have read the [documentation](https://fuzion-lang.dev). If you are looking for support, you might want to check [this section](#i-have-a-question)).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [bug tracker](https://github.com/tokiwa-software/fuzionissues?q=label%3Abug).
- Also make sure to search the internet (including Stack Overflow) to see if users outside of the GitHub community have discussed the issue.
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS, Platform and Version (Windows, Linux, macOS, x86, ARM)
  - Version of the interpreter, compiler, SDK, runtime environment, package manager, depending on what seems relevant.
  - Possibly your input and the output
  - Can you reliably reproduce the issue? And can you also reproduce it with older versions?

<!-- omit in toc -->
#### How Do I Submit a Good Bug Report?

> You must never report security related issues, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public. Instead sensitive bugs must be sent by email to <info@tokiwa.software>.
<!-- You may add a PGP key to allow the messages to be sent encrypted as well. -->

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://github.com/tokiwa-software/fuzion/issues/new). (Since we can't be sure at this point whether it is a bug or not, we ask you not to talk about a bug yet and not to label the issue.)
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code. For good bug reports you should isolate the problem and create a reduced test case.
- Provide the information you collected in the previous section.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no reproduction steps or no obvious way to reproduce the issue, the team will ask you for those steps and mark the issue as `need info`. Bugs with the `need info` tag will not be addressed until they are reproduced.
- If the team is able to reproduce the issue, it will be marked `bug`, as well as possibly other tags (such as `base library`), and the issue will be left to be [implemented by someone](#your-first-code-contribution).

<!-- You might want to create an issue template for bugs and errors that can be used as a guide and that defines the structure of the information to be included. If you do so, reference it here in the description. -->


### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for Fuzion, **including completely new features and minor improvements to existing functionality**. Following these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.

<!-- omit in toc -->
#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](https://fuzion-lang.dev) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform a [search](https://github.com/tokiwa-software/fuzion/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

<!-- omit in toc -->
#### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://github.com/tokiwa-software/fuzion/issues).

- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- You may want to **include screenshots and videos** which help you demonstrate the steps or point out the part which the suggestion is related to. You can use [this tool](https://www.cockos.com/licecap/) to record videos on macOS and Windows, and [this tool](https://github.com/colinkeenan/silentcast) or [this tool](https://github.com/GNOME/byzanz) on Linux. <!-- this should only be included if the project has a GUI -->
- **Explain why this enhancement would be useful** to most Fuzion users. You may also want to point out the other projects that solved it better and which could serve as inspiration.

<!-- You might want to create an issue template for enhancement suggestions that can be used as a guide and that defines the structure of the information to be included. If you do so, reference it here in the description. -->

<!-- TODO
### Your First Code Contribution
include Setup of env, IDE and typical getting started instructions?

-->

<!-- TODO
### Improving The Documentation
Updating, improving and correcting the documentation

-->

## Styleguides

### Source Code

C and Java source code should roughly follow the [GNU Coding
Standards](https://www.gnu.org/prep/standards/standards.html) with the exception
that optional braces `{`/`}` in statements should never be omitted.

#### Work-in-Progress code markers

Code that requires additional work or that may profit from a future enhancements
should be marked with a comment starting `NYI:` followed by a category, if
applicable an issue id, and an explanation on what should or could be done to
improve the code.  For bugs, hacks or otherwise important required work in code
sections that are otherwise stable, an issue should be created in github.

The available categories are

- _HACK_ -- the code is incorrect but was made to work in common cases
- _BUG_ -- the code is incorrect and needs to be fixed
- _IMPROVEMENT_ -- the code can be improved (preferable use _OPTIMIZATION_ or _CLEANUP_ if applicable)
- _OPTIMIZATION_ -- code code could be made more efficient
- _CLEANUP_ -- code codes maintainability could be improved
- _FUTURE PROBLEM_ -- the code works but might need to be changed in the future, e.g., to support an expected change in the OS, CPU architecture, external libraries, etc.
- _UNDER DEVELOPMENT_ -- the code is being worked on
- _COMMENT_ -- the code needs better documentation

Here is an example for a work-in-progress marker:

    if (!f.typeParameter().isCotypesThisType())  // NYI: CLEANUP: #706: remove special handling for 'THIS_TYPE'

### Commit Messages

The first line of a commit message should describe the part of Fuzion that is
affected by the change, followed by a short description of what is changed and,
if applicable, an issue number this commit is related to.

Here is an example

    lib: fix O(n³) performance of String.split follwed by Sequence.filter, fix #2323

Module identifiers to be used include

- _lib_ the Fuzion base library
- _fe_ the Fuzion front end
- _parser_ the Fuzion parser, lexer, etc.
- _be/c_, _be/jvm_, _be/interpreter_ the Fuzion C, JVM or interpreter backends
- _me_ the Fuzion middle end


<!-- TODO
## Join The Project Team
-->

<!-- omit in toc -->
## Attribution
This guide is based on the **contributing-gen**. [Make your own](https://github.com/bttger/contributing-gen)!
