/*
 * Copyright © 2025 Broadcom
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include "broadcom/common/v3d_macros.h"
#include "broadcom/cle/v3dx_pack.h"

enum V3DX(Texture_Data_Formats) v3d_get_tex_format(const struct v3d_device_info *devinfo,
                                                    enum pipe_format f);

enum V3DX(Output_Image_Format) v3d_get_rt_format(const struct v3d_device_info *devinfo,
                                                 enum pipe_format f);

bool v3dX(tfu_supports_tex_format)(enum V3DX(Texture_Data_Formats) tex_format,
                                    bool for_mipmap);

void v3dX(get_internal_type_bpp_for_output_format)(enum V3DX(Output_Image_Format) format,
                                                    uint32_t *type, uint32_t *bpp);

