/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.diagram.ui;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Action;
import org.argouml.ui.ArgoJMenu;
import org.argouml.uml.diagram.deployment.ui.FigComponent;
import org.dbuml.argo.uml.diagram.ui.DBFigure;
import org.dbuml.argo.uml.ui.ActionConnect;
import org.dbuml.argo.uml.ui.ActionGenerateSource;
import org.dbuml.argo.uml.ui.ActionImportAttributeTypes;
import org.dbuml.argo.uml.ui.ActionImportSchemas;
import org.dbuml.argo.uml.ui.ActionUpdateCatalog;
import org.dbuml.base.database.DBMetadata;
import org.dbuml.base.database.DBMetadataCache;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Database;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.undo.UndoableAction;

public class FigDatabase
extends FigComponent
implements DBFigure {
    private static Color filler = new Color(204, 204, 255);

    public FigDatabase(GraphModel gm, Object node) {
        super(gm, node);
        this.setFillColor(filler);
    }

    public FigDatabase() {
        this.setFillColor(filler);
    }

    public Vector getAdditionalPopUpActions() {
        boolean connected;
        Vector<UndoableAction> popUpActions = new Vector<UndoableAction>();
        Database database = DBModelFacade.getInstance().getOwningDatabase(this.getOwner());
        ActionConnect actionConnect = ActionConnect.SINGLETON;
        String connectLabel = Translator.getInstance().localize("CONNECT_CATALOG");
        boolean bl = connected = database != null && database.isConnected();
        if (connected) {
            connectLabel = Translator.getInstance().localize("DISCONNECT_CATALOG");
        }
        actionConnect.putValue("Name", connectLabel);
        actionConnect.putValue("ShortDescription", connectLabel);
        popUpActions.addElement(actionConnect);
        if (connected) {
            ArgoJMenu importMenu = new ArgoJMenu(Translator.getInstance().localize("IMPORT_FROM_CATALOG"));
            try {
                DBMetadata dbmd = DBMetadataCache.getDBMetadata(database);
                importMenu.add((Action)((Object)ActionImportSchemas.SINGLETON));
                ActionImportSchemas.SINGLETON.setEnabled(dbmd != null && dbmd.supportsSchemaInTableDefinitions());
            }
            catch (SQLException e) {
                System.err.println(e.getMessage());
            }
            importMenu.add((Action)((Object)ActionImportAttributeTypes.SINGLETON));
            importMenu.setEnabled(connected);
            popUpActions.addElement((UndoableAction)importMenu);
            popUpActions.addElement(ActionUpdateCatalog.SINGLETON);
        }
        popUpActions.addElement(ActionGenerateSource.SINGLETON);
        return popUpActions;
    }

    public Vector getPopUpActions(MouseEvent me) {
        Vector popUpActions = super.getPopUpActions(me);
        popUpActions.addAll(this.getAdditionalPopUpActions());
        return popUpActions;
    }

    public String placeString() {
        return "new " + this.getDBFigName();
    }

    public void updateLineColor() {
        if (this.isConnected()) {
            this.setLineColor(Color.GREEN);
        } else {
            this.setLineColor(Color.BLACK);
        }
    }

    private boolean isConnected() {
        Database database = DBModelFacade.getInstance().getOwningDatabase(this.getOwner());
        return database != null && database.isConnected();
    }

    public void postLoad() {
        super.postLoad();
        this.updateLineColor();
    }

    public String getTipString(MouseEvent me) {
        return this.getDBFigName() + ": " + this.getName();
    }

    public String getDBFigName() {
        return "Database";
    }
}

