/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.logging;

import de.unkrig.commons.util.Consumer;
import de.unkrig.commons.util.ConsumerUtil;
import de.unkrig.commons.util.logging.FormatFormatter;
import java.io.Writer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogUtil {
    private static final Logger ROOT_LOGGER = Logger.getLogger("");

    private LogUtil() {
    }

    public static void addConsoleHandlerToRootLogger() {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new FormatFormatter(null));
        Handler[] handlerArray = ROOT_LOGGER.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            ROOT_LOGGER.removeHandler(h);
            ++n2;
        }
        ROOT_LOGGER.addHandler(consoleHandler);
    }

    public static void removeAllHandlersFromRootLogger() {
        Handler[] handlerArray = ROOT_LOGGER.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler h = handlerArray[n2];
            ROOT_LOGGER.removeHandler(h);
            ++n2;
        }
    }

    public static void setRootLoggerLevel(Level level) {
        ROOT_LOGGER.setLevel(level);
    }

    public static Consumer<String> logConsumer(final Logger logger, final Level level, final String optionalPrefix) {
        return new Consumer<String>(){

            @Override
            public void consume(String message) throws RuntimeException {
                if (optionalPrefix != null) {
                    message = String.valueOf(optionalPrefix) + message;
                }
                logger.log(level, message);
            }
        };
    }

    public static Writer logWriter(Logger logger, Level level, String optionalPrefix) {
        return ConsumerUtil.characterConsumerWriter(ConsumerUtil.lines(ConsumerUtil.cast(LogUtil.logConsumer(logger, level, optionalPrefix))));
    }
}

