/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.AbstractUrlConnectionTask;
import de.unkrig.antology.util.Compat;
import de.unkrig.commons.io.InputStreams;
import de.unkrig.commons.io.IoUtil;
import de.unkrig.commons.io.OutputStreams;
import de.unkrig.commons.lang.AssertionUtil;
import de.unkrig.commons.lang.protocol.Consumer;
import de.unkrig.commons.lang.protocol.ConsumerWhichThrows;
import de.unkrig.commons.lang.protocol.NoException;
import de.unkrig.commons.net.UrlConnections;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterChain;

public class FollowTask
extends AbstractUrlConnectionTask {
    private OutputStream out = OutputStreams.DISCARD;
    @Nullable
    private Charset charset;
    private final Vector<FilterChain> filterChains = new Vector();
    private int periodTime = 3000;
    private int timeout = 300;
    private boolean failOnTimeout = true;

    public void setFile(File file) throws MalformedURLException {
        this.setUrl(new URL("file", null, file.getPath()));
    }

    public void setOutputFile(File outputFile) throws FileNotFoundException {
        this.assertOutIsDefault();
        this.out = new FileOutputStream(outputFile);
    }

    public void setStdout(boolean stdout) {
        if (!stdout) {
            return;
        }
        this.assertOutIsDefault();
        this.out = System.out;
    }

    public void setStderr(boolean stderr) {
        if (!stderr) {
            return;
        }
        this.assertOutIsDefault();
        this.out = System.err;
    }

    public void setEncoding(String encoding) {
        this.charset = Charset.forName(encoding);
    }

    public void addConfigured(FilterChain filterChain) {
        this.filterChains.add(filterChain);
    }

    public void setPeriodTime(int periodTime) {
        this.periodTime = periodTime;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public void execute() {
        try {
            this.execute2();
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute2() throws Exception {
        Followable followable = this.urlFollowable();
        long expiration = this.timeout <= 0 ? Long.MAX_VALUE : System.currentTimeMillis() + 1000L * (long)this.timeout;
        InputStreamSucker copier = this.copier(this.out);
        while (true) {
            InputStream is;
            if ((is = followable.getInputStream()) != null) {
                try {
                    copier.suck(is);
                    is.close();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (System.currentTimeMillis() >= expiration) {
                if (this.failOnTimeout) {
                    throw new BuildException("<follow> timed out at " + new Date() + " after " + this.timeout + " seconds");
                }
                return;
            }
            try {
                Thread.sleep(this.periodTime);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BuildException("INTERRUPTED");
            }
        }
    }

    private Followable urlFollowable() throws IOException {
        return new Followable(){
            long previousSize;
            long previousModificationTime;
            {
                URLConnection conn;
                try {
                    conn = FollowTask.this.openConnection();
                    this.previousSize = conn.getContentLength();
                }
                catch (FileNotFoundException fnfe) {
                    this.previousSize = 0L;
                }
                try {
                    conn = FollowTask.this.openConnection();
                    this.previousModificationTime = conn.getLastModified();
                }
                catch (FileNotFoundException fnfe) {
                    this.previousModificationTime = 0L;
                }
            }

            @Override
            @Nullable
            public InputStream getInputStream() throws IOException {
                try {
                    HttpURLConnection httpConn;
                    URLConnection conn = FollowTask.this.openConnection();
                    FollowTask.this.configureUrlConnection(conn);
                    if (conn instanceof HttpURLConnection) {
                        httpConn = (HttpURLConnection)conn;
                        FollowTask.this.configureHttpUrlConnection(httpConn);
                        httpConn.setRequestMethod("HEAD");
                        if (FollowTask.this.httpFollowRedirects2) {
                            conn = UrlConnections.followRedirects2(httpConn);
                            httpConn = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
                        }
                    } else {
                        httpConn = null;
                    }
                    long newSize = conn.getContentLength();
                    long newModificationTime = conn.getLastModified();
                    if (newSize != -1L && newSize == this.previousSize) {
                        return null;
                    }
                    if (newModificationTime != 0L && newModificationTime == this.previousModificationTime) {
                        return null;
                    }
                    if (newSize != -1L && newSize < this.previousSize) {
                        this.previousSize = 0L;
                    }
                    if (httpConn != null) {
                        httpConn.disconnect();
                        conn = FollowTask.this.openConnection();
                        httpConn = (HttpURLConnection)conn;
                        FollowTask.this.configureUrlConnection(httpConn);
                        FollowTask.this.configureHttpUrlConnection(httpConn);
                        if (this.previousSize != -1L) {
                            httpConn.addRequestProperty("Range", "bytes=" + this.previousSize + "-");
                        }
                    }
                    InputStream is = conn.getInputStream();
                    try {
                        if (httpConn == null || this.previousSize == -1L || newSize == -1L) {
                            if (this.previousSize == -1L) {
                                this.previousSize = is.skip(Long.MAX_VALUE);
                                return is;
                            }
                            if (is.skip(this.previousSize) != this.previousSize) {
                                throw new IOException("Could not position input stream");
                            }
                        }
                        if (newSize != -1L) {
                            this.previousSize = newSize;
                            return is;
                        }
                        return InputStreams.wye(is, OutputStreams.lengthWritten((ConsumerWhichThrows<? super Integer, NoException>)new Consumer<Integer>(){

                            @Override
                            public void consume(Integer n) {
                                previousSize += (long)n.intValue();
                            }
                        }));
                    }
                    catch (IOException ioe) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw ioe;
                    }
                    catch (RuntimeException re) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw re;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    this.previousSize = 0L;
                    return null;
                }
            }
        };
    }

    private InputStreamSucker copier(final OutputStream out) {
        if (this.filterChains.isEmpty()) {
            if (this.charset != null) {
                throw new BuildException("The 'encoding' attribute takes effect only if a '<filterchain>' is configured");
            }
            return new InputStreamSucker(){

                @Override
                public long suck(InputStream in) throws IOException {
                    return IoUtil.copy(in, out);
                }

                @Override
                public void close() {
                }
            };
        }
        ChainReaderHelper crh = new ChainReaderHelper();
        crh.setBufferSize(8192);
        crh.setFilterChains(this.filterChains);
        crh.setProject(this.getProject());
        Charset charset = this.charset;
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        final OutputStreamWriter w = new OutputStreamWriter(out, charset);
        class ProxyInputStream
        extends FilterInputStream {
            ProxyInputStream() {
                super((InputStream)new StringInputStream(""));
            }

            void setDelegate(InputStream in) {
                this.in = in;
            }
        }
        final ProxyInputStream pis = new ProxyInputStream();
        crh.setPrimaryReader((Reader)new InputStreamReader((InputStream)pis, charset));
        final BufferedReader r = new BufferedReader(Compat.getAssembledReader(crh));
        return new InputStreamSucker(){
            {
            }

            @Override
            public long suck(InputStream in) throws IOException {
                pis.setDelegate(in);
                return IoUtil.copy(r, w);
            }

            @Override
            public void close() throws IOException {
                r.close();
            }
        };
    }

    private void assertOutIsDefault() {
        if (this.out != OutputStreams.DISCARD) {
            throw new BuildException("Only one of 'outputFile=...', 'stdout=true' and 'stderr=true' allowed");
        }
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }

    private static interface InputStreamSucker {
        public long suck(InputStream var1) throws IOException;

        public void close() throws IOException;
    }

    static interface Followable {
        @Nullable
        public InputStream getInputStream() throws IOException;
    }
}

