/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class LogTask
extends Task {
    private static final Logger LOGGER = Logger.getLogger(LogTask.class.getName());
    private static final Logger ROOT_LOGGER = Logger.getLogger("");
    private Logger logger = ROOT_LOGGER;
    private Level level = Level.INFO;
    @Nullable
    private String message;

    public void setLogger(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    public void setLevel(String nameOrNumber) {
        this.level = Level.parse(nameOrNumber);
    }

    public void setMessage(String text) {
        this.message = text;
    }

    public void execute() throws BuildException {
        try {
            if (this.message == null) {
                throw new IllegalArgumentException("'message' attribute is missing");
            }
            this.logger.log(this.level, this.message);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
            throw new BuildException((Throwable)e);
        }
    }
}

