/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.commons.net.authenticator.CustomAuthenticator;
import de.unkrig.commons.nullanalysis.Nullable;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.security.auth.Destroyable;
import org.apache.tools.ant.Task;

public class SetAuthenticatorTask
extends Task
implements Destroyable {
    public static final String DEFAULT_STORE_MODE = "NONE";
    public static final String DEFAULT_CACHE_MODE = "USER_NAMES_AND_PASSWORDS";
    @Nullable
    private String dialogLabel;
    private CustomAuthenticator.CacheMode cacheMode = CustomAuthenticator.CacheMode.valueOf("USER_NAMES_AND_PASSWORDS");
    private CustomAuthenticator.StoreMode storeMode = CustomAuthenticator.StoreMode.valueOf("NONE");
    private final List<CredentialsSpec2> credentials = new ArrayList<CredentialsSpec2>();
    private boolean destroyed;
    @Nullable
    private static CustomAuthenticator myAuthenticator;

    protected void finalize() {
        this.destroy();
    }

    @Override
    public void destroy() {
        for (CredentialsSpec2 ce : this.credentials) {
            ce.destroy();
        }
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDialogLabel(String value) {
        this.dialogLabel = value;
    }

    public void setCache(CustomAuthenticator.CacheMode value) {
        this.cacheMode = value;
    }

    public void setStore(CustomAuthenticator.StoreMode value) {
        this.storeMode = value;
    }

    public void addConfiguredCredentials(CredentialsSpec2 credentials) {
        this.credentials.add(credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.destroyed) {
            throw new IllegalStateException();
        }
        Class<SetAuthenticatorTask> clazz = SetAuthenticatorTask.class;
        synchronized (SetAuthenticatorTask.class) {
            CustomAuthenticator ca = myAuthenticator;
            if (ca == null) {
                ca = myAuthenticator = new CustomAuthenticator(this.cacheMode, this.storeMode);
                if (this.dialogLabel != null) {
                    ca.setDialogLabel(this.dialogLabel);
                }
                Authenticator.setDefault(ca);
            }
            for (CredentialsSpec2 c : this.credentials) {
                ca.addCredentials(Collections.singleton(c.delegate));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    private static Pattern regex(@Nullable String regex) {
        return regex == null ? null : Pattern.compile(regex);
    }

    public static final class CredentialsSpec2
    implements Destroyable {
        private final CustomAuthenticator.CredentialsSpec delegate = new CustomAuthenticator.CredentialsSpec();

        protected void finalize() {
            this.destroy();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public boolean isDestroyed() {
            return this.delegate.isDestroyed();
        }

        public void setRequestingHost(@Nullable String regex) {
            this.delegate.setRequestingHost(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingSite(@Nullable String regex) {
            this.delegate.setRequestingSite(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingPort(@Nullable String regex) {
            this.delegate.setRequestingPort(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingProtocol(@Nullable String regex) {
            this.delegate.setRequestingProtocol(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingPrompt(@Nullable String regex) {
            this.delegate.setRequestingPrompt(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingScheme(@Nullable String regex) {
            this.delegate.setRequestingScheme(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestingUrl(@Nullable String regex) {
            this.delegate.setRequestingUrl(SetAuthenticatorTask.regex(regex));
        }

        public void setRequestorType(@Nullable String regex) {
            this.delegate.setRequestorType(SetAuthenticatorTask.regex(regex));
        }

        public void setDeny(boolean value) {
            this.delegate.setDeny(value);
        }

        public void setUserName(String userName) {
            this.delegate.setUserName(!userName.isEmpty() && !"-".equals(userName) ? userName : null);
        }

        public void setPassword(@Nullable char[] password) {
            this.delegate.setPassword(password == null || password.length == 0 || password.length == 1 && password[0] == '-' ? null : password);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return this.delegate.equals(obj);
        }
    }
}

