/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.util;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;

public final class Logging {
    private static final ThreadLocal<Map<Project, String>> PREFIX = new ThreadLocal<Map<Project, String>>(){

        @Override
        protected Map<Project, String> initialValue() {
            return new HashMap<Project, String>();
        }
    };

    private Logging() {
    }

    public static void setLogMessagePrefix(Project project, String prefix) {
        Vector orig = project.getBuildListeners();
        for (BuildListener buildListener : orig) {
            if (buildListener instanceof IndentingBuildListener) continue;
            for (BuildListener bl : orig) {
                project.removeBuildListener(bl);
            }
            for (BuildListener bl : orig) {
                if (!(bl instanceof IndentingBuildListener)) {
                    bl = new IndentingBuildListener(bl);
                }
                project.addBuildListener(bl);
            }
        }
        PREFIX.get().put(project, prefix);
    }

    public static String getLogMessagePrefix(Project project) {
        String prefix = PREFIX.get().get(project);
        return prefix == null ? "" : prefix;
    }

    @NotNullByDefault(value=false)
    private static class IndentingBuildListener
    extends FilterBuildListener {
        IndentingBuildListener(BuildListener delegate) {
            super(delegate);
        }

        @Override
        public void messageLogged(BuildEvent event) {
            String prefix = (String)((Map)PREFIX.get()).get(event.getProject());
            if (prefix != null) {
                event.setMessage(prefix + event.getMessage(), event.getPriority());
            }
            super.messageLogged(event);
        }
    }

    @NotNullByDefault(value=false)
    private static class FilterBuildListener
    implements BuildListener {
        private final BuildListener delegate;

        FilterBuildListener(BuildListener delegate) {
            this.delegate = delegate;
        }

        public void buildStarted(BuildEvent event) {
            this.delegate.buildStarted(event);
        }

        public void buildFinished(BuildEvent event) {
            this.delegate.buildFinished(event);
        }

        public void targetStarted(BuildEvent event) {
            this.delegate.targetStarted(event);
        }

        public void targetFinished(BuildEvent event) {
            this.delegate.targetFinished(event);
        }

        public void taskStarted(BuildEvent event) {
            this.delegate.taskStarted(event);
        }

        public void taskFinished(BuildEvent event) {
            this.delegate.taskFinished(event);
        }

        public void messageLogged(BuildEvent event) {
            this.delegate.messageLogged(event);
        }
    }
}

