/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

public final class CharSequences {
    private CharSequences() {
    }

    public static CharSequence subSequence(final CharSequence delegate, final int start, final int end) {
        if (start == 0 && end == delegate.length()) {
            return delegate;
        }
        return new CharSequence(){

            @Override
            public CharSequence subSequence(int start2, int end2) {
                return CharSequences.subSequence(delegate, start + start2, start + end2);
            }

            @Override
            public int length() {
                return end - start;
            }

            @Override
            public char charAt(int index) {
                return delegate.charAt(start + index);
            }
        };
    }

    public static CharSequence from(final char[] buf) {
        return new CharSequence(){

            @Override
            public CharSequence subSequence(int start, int end) {
                return CharSequences.subSequence(this, start, end);
            }

            @Override
            public int length() {
                return buf.length;
            }

            @Override
            public char charAt(int index) {
                return buf[index];
            }
        };
    }

    public static CharSequence from(final char[] buf, final int off, final int len) {
        if (off < 0) {
            throw new IndexOutOfBoundsException(off + "<0");
        }
        if (off > buf.length) {
            throw new IndexOutOfBoundsException(off + ">" + buf.length);
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException(len + "<0");
        }
        if (off + len > buf.length) {
            throw new IndexOutOfBoundsException(off + len + ">" + buf.length);
        }
        return new CharSequence(){

            @Override
            public CharSequence subSequence(int start, int end) {
                return CharSequences.subSequence(this, off + start, off + end);
            }

            @Override
            public int length() {
                return len;
            }

            @Override
            public char charAt(int index) {
                return buf[off + index];
            }
        };
    }

    public static char[] toCharArray(CharSequence cs) {
        char[] result = new char[cs.length()];
        for (int i = cs.length() - 1; i >= 0; --i) {
            result[i] = cs.charAt(i);
        }
        return result;
    }
}

