/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ThreadUtil;
import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.nullanalysis.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public final class ProcessUtil {
    private static final ProcessStarter PROCESS_STARTER;

    private ProcessUtil() {
    }

    public static boolean execute(List<String> command, @Nullable File workingDirectory, InputStream stdin, boolean closeStdin, OutputStream stdout, boolean closeStdout, OutputStream stderr, boolean closeStderr) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.directory(workingDirectory);
        Process process = PROCESS_STARTER.startProcess(processBuilder, stdin, closeStdin, stdout, closeStdout, stderr, closeStderr);
        return process.waitFor() == 0;
    }

    private static Stoppable copyInBackground(final InputStream in, final boolean closeIn, final OutputStream out, final boolean closeOut) {
        return ThreadUtil.runInBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessUtil.copy(in, closeIn, out, closeOut);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, "copy-in-background");
    }

    private static void copy(InputStream inputStream, boolean closeInputStream, OutputStream outputStream, boolean closeOutputStream) throws IOException {
        try {
            int m;
            byte[] buffer = new byte[4096];
            while ((m = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, m);
            }
            outputStream.flush();
            if (closeInputStream) {
                inputStream.close();
            }
            if (closeOutputStream) {
                outputStream.close();
            }
        }
        catch (IOException ioe) {
            if (closeInputStream) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (closeOutputStream) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    static {
        ProcessStarter ps;
        try {
            Method redirectError;
            Method redirectOutput;
            Method redirectInput;
            Field redirectInherit;
            Class<?> redirect = Class.forName("java.lang.ProcessBuilder.Redirect");
            try {
                redirectInherit = redirect.getField("INHERIT");
                redirectInput = redirect.getMethod("redirectInput", redirect);
                redirectOutput = redirect.getMethod("redirectOutput", redirect);
                redirectError = redirect.getMethod("redirectError", redirect);
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
            ps = new ProcessStarter(){

                @Override
                public Process startProcess(ProcessBuilder processBuilder, InputStream stdin, boolean closeStdin, OutputStream stdout, boolean closeStdout, OutputStream stderr, boolean closeStderr) throws IOException {
                    try {
                        if (stdin == System.in) {
                            redirectInput.invoke((Object)processBuilder, redirectInherit);
                        }
                        if (stdout == System.out) {
                            redirectOutput.invoke((Object)processBuilder, redirectInherit);
                        }
                        if (stderr == System.err) {
                            redirectError.invoke((Object)processBuilder, redirectInherit);
                        }
                    }
                    catch (Exception e) {
                        throw ExceptionUtil.wrap(null, e, AssertionError.class);
                    }
                    Process process = processBuilder.start();
                    if (stdout != System.out) {
                        ProcessUtil.copyInBackground(process.getInputStream(), false, stdout, closeStdout);
                    }
                    if (stderr != System.err) {
                        ProcessUtil.copyInBackground(process.getErrorStream(), false, stderr, closeStderr);
                    }
                    if (stdin != System.in) {
                        try {
                            ProcessUtil.copy(stdin, closeStdin, process.getOutputStream(), true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return process;
                }
            };
        }
        catch (ClassNotFoundException e) {
            ps = new ProcessStarter(){

                @Override
                public Process startProcess(ProcessBuilder processBuilder, InputStream stdin, boolean closeStdin, OutputStream stdout, boolean closeStdout, OutputStream stderr, boolean closeStderr) throws IOException {
                    Process process = processBuilder.start();
                    ProcessUtil.copyInBackground(process.getInputStream(), false, stdout, closeStdout);
                    ProcessUtil.copyInBackground(process.getErrorStream(), false, stderr, closeStderr);
                    try {
                        ProcessUtil.copy(stdin, closeStdin, process.getOutputStream(), true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return process;
                }
            };
        }
        PROCESS_STARTER = ps;
    }

    static interface ProcessStarter {
        public Process startProcess(ProcessBuilder var1, InputStream var2, boolean var3, OutputStream var4, boolean var5, OutputStream var6, boolean var7) throws IOException;
    }
}

