/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.protocol;

import de.unkrig.commons.lang.protocol.Predicate;
import de.unkrig.commons.lang.protocol.Producer;
import de.unkrig.commons.lang.protocol.RunnableWhichThrows;
import java.util.Collection;

public final class RunnableUtil {
    public static final Runnable NOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    private RunnableUtil() {
    }

    public static <EX extends Throwable> RunnableWhichThrows<EX> runSequentially(final RunnableWhichThrows<EX> delegate1, final RunnableWhichThrows<EX> delegate2) {
        return new RunnableWhichThrows<EX>(){

            @Override
            public void run() throws Throwable {
                delegate1.run();
                delegate2.run();
            }
        };
    }

    public static <EX extends Throwable> RunnableWhichThrows<EX> runSequentially(final Collection<RunnableWhichThrows<EX>> delegates) {
        return new RunnableWhichThrows<EX>(){

            @Override
            public void run() throws Throwable {
                for (RunnableWhichThrows delegate : delegates) {
                    delegate.run();
                }
            }
        };
    }

    public static <EX extends RuntimeException> Runnable asRunnable(final RunnableWhichThrows<EX> delegate) {
        return new Runnable(){

            @Override
            public void run() {
                delegate.run();
            }
        };
    }

    public static <EX extends Throwable> RunnableWhichThrows<EX> asRunnableWhichThrows(final Runnable delegate) {
        return new RunnableWhichThrows<EX>(){

            @Override
            public void run() {
                delegate.run();
            }
        };
    }

    public static <ST> Runnable sparingRunnable(final Runnable delegate, final Predicate<? super ST> condition, final ST subject) {
        return new Runnable(){

            @Override
            public void run() {
                if (condition.evaluate(subject)) {
                    delegate.run();
                }
            }
        };
    }

    public static Runnable sparingRunnable(final Runnable delegate, final Producer<? extends Boolean> condition) {
        return new Runnable(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(condition.produce())) {
                    delegate.run();
                }
            }
        };
    }

    public static <EX extends Throwable> void swapIf(boolean swap, RunnableWhichThrows<EX> runnable1, RunnableWhichThrows<EX> runnable2) throws EX {
        if (swap) {
            runnable2.run();
            runnable1.run();
        } else {
            runnable1.run();
            runnable2.run();
        }
    }

    public static <EX extends Throwable> Runnable ignoreExceptions(final Class<EX> exceptionClass, final RunnableWhichThrows<EX> delegate) {
        return new Runnable(){

            @Override
            public void run() {
                block6: {
                    try {
                        delegate.run();
                    }
                    catch (RuntimeException re) {
                        if (!exceptionClass.isAssignableFrom(re.getClass())) {
                            throw re;
                        }
                    }
                    catch (Error e) {
                        if (!exceptionClass.isAssignableFrom(e.getClass())) {
                            throw e;
                        }
                    }
                    catch (Throwable t) {
                        if ($assertionsDisabled || exceptionClass.isAssignableFrom(t.getClass())) break block6;
                        throw new AssertionError();
                    }
                }
            }
        };
    }
}

