/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.tool.nullserver;

import de.unkrig.commons.lang.protocol.Stoppable;
import de.unkrig.commons.net.TcpServer;
import de.unkrig.commons.util.logging.SimpleLogging;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.logging.Logger;

public final class Main {
    private static final Logger LOGGER;

    private Main() {
    }

    public static void main(String[] args) throws IOException {
        String arg;
        int i = 0;
        while (i < args.length && (arg = args[i]).startsWith("-")) {
            ++i;
            if ("-help".equals(arg)) {
                System.out.println("A server that accepts connections from clients and logs the data it receives");
                System.out.println("from these connections.");
                System.out.println();
                System.out.println("Usage:");
                System.out.println("  java [ <option> ... ] " + Main.class.getName() + " <port>");
                System.out.println("Valid <global-option>s are:");
                System.out.println("  -help");
                System.out.println("  -out <file>     Redirect the output to the given file");
                System.out.println("  -nowarn         Suppress all messages except errors");
                System.out.println("  -quiet          Suppress normal output");
                System.out.println("  -verbose        Log verbose messages");
                System.out.println("  -debug          Log verbose and debug messages (repeat to get more output)");
                System.out.println("  -log <level>:<logger>:<handler>:<formatter>:<format>");
                System.out.println("                  Add logging at level FINE on logger 'de.unkrig' to STDERR");
                System.out.println("                  using the FormatFormatter and SIMPLE format, or the given");
                System.out.println("                  arguments which are all optional.");
                System.exit(0);
                continue;
            }
            if ("-out".equals(arg)) {
                SimpleLogging.setOut(new File(args[i++]));
                continue;
            }
            if ("-nowarn".equals(arg)) {
                SimpleLogging.setNoWarn();
                continue;
            }
            if ("-quiet".equals(arg)) {
                SimpleLogging.setQuiet();
                continue;
            }
            if ("-verbose".equals(arg)) {
                SimpleLogging.setVerbose();
                continue;
            }
            if ("-debug".equals(arg)) {
                SimpleLogging.setDebug();
                continue;
            }
            if ("-log".equals(arg)) {
                SimpleLogging.configureLoggers(args[i++]);
                continue;
            }
            System.err.println("Invalid command line option '" + arg + "'; try '-help'");
        }
        if (i + 1 != args.length) {
            System.err.println("Local port missing; try '-help'");
            System.exit(1);
        }
        int port = Integer.parseInt(args[i++]);
        new TcpServer(new InetSocketAddress(port), 0, new TcpServer.ConnectionHandler(){

            @Override
            public void handleConnection(InputStream in, OutputStream out, InetSocketAddress localSocketAddress, InetSocketAddress remoteSocketAddress, Stoppable stoppable) throws IOException {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
                while ((line = br.readLine()) != null) {
                    LOGGER.fine(line);
                }
            }
        }).run();
    }

    static {
        SimpleLogging.init();
        LOGGER = Logger.getLogger(Main.class.getName());
    }
}

