/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.nullanalysis.Nullable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class IdentityHashSet<E>
extends AbstractSet<E> {
    private transient IdentityHashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public IdentityHashSet() {
        this.map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<? extends E> c) {
        this.map = new IdentityHashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.map = new IdentityHashMap(expectedMaxSize);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(@Nullable E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            IdentityHashMap map;
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet.map = map = (IdentityHashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

