-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"). you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--   http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing,
-- software distributed under the License is distributed on an
-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
-- KIND, either express or implied.  See the License for the
-- specific language governing permissions and limitations
-- under the License.    

drop table if exists velocity_template_varchar;

create table velocity_template_varchar
(
	vt_id VARCHAR(64) not null primary key,
	vt_timestamp TIMESTAMP,
	vt_def VARCHAR(255) not null
);

insert into velocity_template_varchar (vt_id, vt_timestamp, vt_def) VALUES
	( 'testTemplate1', current_timestamp, 'I am a test through the data loader');

insert into velocity_template_varchar (vt_id, vt_timestamp, vt_def) VALUES
	( 'testTemplate2', current_timestamp, '$tool.message $tool.add(23, 19)');

insert into velocity_template_varchar (vt_id, vt_def) VALUES
	( 'testTemplate3', 'This is a template with a null timestamp');

insert into velocity_template_varchar (vt_id, vt_timestamp, vt_def) VALUES
	( 'testTemplate4', current_timestamp, '#testMacro("foo")');

insert into velocity_template_varchar (vt_id, vt_timestamp, vt_def) VALUES
	( 'VM_global_library.vm', current_timestamp, '#macro (testMacro $param) I am a macro using $param #end');


-- same templates as clob

drop table if exists velocity_template_clob;

create table velocity_template_clob
(
	vt_id VARCHAR(64) not null primary key,
	vt_timestamp TIMESTAMP,
	vt_def CLOB not null
);

insert into velocity_template_clob select * from velocity_template_varchar;
